/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.devtools.jsdoc.checks;

import com.google.common.base.Joiner;
import com.google.javascript.rhino.head.ast.AstNode;
import com.google.javascript.rhino.head.ast.Comment;
import com.google.javascript.rhino.head.ast.FunctionNode;
import com.google.javascript.rhino.head.ast.Name;
import com.google.javascript.rhino.head.ast.ObjectProperty;
import com.google.javascript.rhino.head.ast.ReturnStatement;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.chromium.devtools.jsdoc.checks.AstUtil;
import org.chromium.devtools.jsdoc.checks.ContextTrackingChecker;
import org.chromium.devtools.jsdoc.checks.FunctionRecord;

public final class MethodAnnotationChecker
extends ContextTrackingChecker {
    private static final Pattern PARAM_PATTERN = Pattern.compile("^[^@\n]*@param\\s+(\\{.+\\}\\s+)?([^\\s]+).*$", 8);
    private static final Pattern INVALID_RETURN_PATTERN = Pattern.compile("^[^@\n]*(@)return(?:s.*|\\s+[^{]*)$", 8);
    private final Set<FunctionRecord> valueReturningFunctions = new HashSet<FunctionRecord>();
    private final Set<FunctionRecord> throwingFunctions = new HashSet<FunctionRecord>();

    @Override
    public void enterNode(AstNode astNode) {
        switch (astNode.getType()) {
            case 109: {
                this.handleFunction((FunctionNode)astNode);
                break;
            }
            case 4: {
                this.handleReturn((ReturnStatement)astNode);
                break;
            }
            case 50: {
                this.handleThrow();
                break;
            }
        }
    }

    private void handleFunction(FunctionNode functionNode) {
        int n = functionNode.getParams().size();
        if (n == 0) {
            return;
        }
        Comment comment = AstUtil.getJsDocNode(functionNode);
        Object[] objectArray = this.getNonAnnotatedParamData(functionNode.getParams(), comment);
        if (objectArray.length > 0 && functionNode.getParams().size() != objectArray.length) {
            this.reportErrorAtNodeStart(comment, String.format("No @param JSDoc tag found for parameters: [%s]", Joiner.on(',').join(objectArray)));
        }
    }

    private String[] getNonAnnotatedParamData(List<AstNode> list, Comment comment) {
        String string;
        if (comment == null) {
            return new String[0];
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (AstNode object2 : list) {
            string = this.getContext().getNodeText(object2);
            if (hashSet.add(string)) continue;
            this.reportErrorAtNodeStart(object2, String.format("Duplicate function argument name: %s", string));
        }
        String string2 = this.getContext().getNodeText(comment);
        Matcher matcher = PARAM_PATTERN.matcher(string2);
        while (matcher.find()) {
            string = matcher.group(1);
            if (string == null) {
                this.getContext().reportErrorInNode(comment, matcher.start(2), String.format("Invalid @param annotation found - should be \"@param {<type>} paramName\"", new Object[0]));
                continue;
            }
            hashSet.remove(matcher.group(2));
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    private void handleReturn(ReturnStatement returnStatement) {
        if (returnStatement.getReturnValue() == null || AstUtil.parentOfType(returnStatement, 90) != null) {
            return;
        }
        FunctionRecord functionRecord = this.getState().getCurrentFunctionRecord();
        if (functionRecord == null) {
            return;
        }
        AstNode astNode = MethodAnnotationChecker.getFunctionNameNode(functionRecord.functionNode);
        if (astNode == null) {
            return;
        }
        this.valueReturningFunctions.add(functionRecord);
    }

    private void handleThrow() {
        FunctionRecord functionRecord = this.getState().getCurrentFunctionRecord();
        if (functionRecord == null) {
            return;
        }
        AstNode astNode = MethodAnnotationChecker.getFunctionNameNode(functionRecord.functionNode);
        if (astNode == null) {
            return;
        }
        this.throwingFunctions.add(functionRecord);
    }

    @Override
    public void leaveNode(AstNode astNode) {
        if (astNode.getType() != 109) {
            return;
        }
        FunctionRecord functionRecord = this.getState().getCurrentFunctionRecord();
        if (functionRecord != null) {
            this.checkFunctionAnnotation(functionRecord);
        }
    }

    private void checkFunctionAnnotation(FunctionRecord functionRecord) {
        String string = this.getFunctionName(functionRecord.functionNode);
        if (string == null) {
            return;
        }
        boolean bl = !string.startsWith("_") && (functionRecord.isTopLevelFunction() || functionRecord.enclosingType != null && MethodAnnotationChecker.isPlainTopLevelFunction(functionRecord.enclosingFunctionRecord));
        Comment comment = AstUtil.getJsDocNode(functionRecord.functionNode);
        boolean bl2 = this.valueReturningFunctions.contains(functionRecord);
        boolean bl3 = functionRecord.enclosingType != null && functionRecord.enclosingType.isInterface;
        int n = MethodAnnotationChecker.invalidReturnAnnotationIndex(this.getState().getNodeText(comment));
        if (n != -1) {
            String string2 = bl2 || bl3 ? "should be \"@return {<type>}\"" : "please remove, as function does not return value";
            this.getContext().reportErrorInNode(comment, n, String.format("invalid return type annotation found - %s", string2));
            return;
        }
        AstNode astNode = MethodAnnotationChecker.getFunctionNameNode(functionRecord.functionNode);
        if (astNode == null) {
            return;
        }
        if (bl2) {
            if (!functionRecord.hasReturnAnnotation() && bl) {
                this.reportErrorAtNodeStart(astNode, "@return annotation is required for API functions that return value");
            }
        } else if (functionRecord.hasReturnAnnotation() && !bl3 && !this.throwingFunctions.contains(functionRecord)) {
            this.reportErrorAtNodeStart(astNode, "@return annotation found, yet function does not return value");
        }
    }

    private static boolean isPlainTopLevelFunction(FunctionRecord functionRecord) {
        return functionRecord != null && functionRecord.isTopLevelFunction() && functionRecord.enclosingType == null && !functionRecord.isConstructor;
    }

    private String getFunctionName(FunctionNode functionNode) {
        AstNode astNode = MethodAnnotationChecker.getFunctionNameNode(functionNode);
        return astNode == null ? null : this.getState().getNodeText(astNode);
    }

    private static int invalidReturnAnnotationIndex(String string) {
        if (string == null) {
            return -1;
        }
        Matcher matcher = INVALID_RETURN_PATTERN.matcher(string);
        return matcher.find() ? matcher.start(1) : -1;
    }

    private static AstNode getFunctionNameNode(FunctionNode functionNode) {
        Name name = functionNode.getFunctionName();
        if (name != null) {
            return name;
        }
        ObjectProperty objectProperty = (ObjectProperty)AstUtil.parentOfType(functionNode, 103);
        if (objectProperty != null) {
            return objectProperty.getLeft();
        }
        return null;
    }
}

