/*
 * Copyright (C) 2012 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef THIRD_PARTY_BLINK_RENDERER_CORE_INSPECTOR_INSPECTOR_HISTORY_H_
#define THIRD_PARTY_BLINK_RENDERER_CORE_INSPECTOR_INSPECTOR_HISTORY_H_

#include "base/macros.h"
#include "base/memory/scoped_refptr.h"
#include "third_party/blink/renderer/platform/heap/handle.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"
#include "third_party/blink/renderer/platform/wtf/vector.h"

namespace blink {

class ExceptionState;

class InspectorHistory final : public GarbageCollected<InspectorHistory> {
 public:
  class Action : public GarbageCollectedFinalized<Action> {
   public:
    explicit Action(const String& name);
    virtual ~Action();
    virtual void Trace(blink::Visitor*);
    virtual String ToString();

    virtual String MergeId();
    virtual void Merge(Action*);

    virtual bool Perform(ExceptionState&) = 0;

    virtual bool Undo(ExceptionState&) = 0;
    virtual bool Redo(ExceptionState&) = 0;

    virtual bool IsNoop() { return false; }

    virtual bool IsUndoableStateMark();

   private:
    String name_;
  };

  InspectorHistory();
  void Trace(blink::Visitor*);

  bool Perform(Action*, ExceptionState&);
  void AppendPerformedAction(Action*);
  void MarkUndoableState();

  bool Undo(ExceptionState&);
  bool Redo(ExceptionState&);
  void Reset();

 private:
  HeapVector<Member<Action>> history_;
  wtf_size_t after_last_action_index_;

  DISALLOW_COPY_AND_ASSIGN(InspectorHistory);
};

}  // namespace blink

#endif  // !defined(InspectorHistory_h)
