/*
 * Copyright (C) 1999 Lars Knoll (knoll@kde.org)
 *           (C) 1999 Antti Koivisto (koivisto@kde.org)
 * Copyright (C) 2004 Apple Computer, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 */

#ifndef THIRD_PARTY_BLINK_RENDERER_CORE_HTML_HTML_IMAGE_LOADER_H_
#define THIRD_PARTY_BLINK_RENDERER_CORE_HTML_HTML_IMAGE_LOADER_H_

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/loader/image_loader.h"

namespace blink {

class CORE_EXPORT HTMLImageLoader final : public ImageLoader {
 public:
  static HTMLImageLoader* Create(Element* element) {
    return MakeGarbageCollected<HTMLImageLoader>(element);
  }

  explicit HTMLImageLoader(Element*);
  ~HTMLImageLoader() override;

  void DispatchLoadEvent() override;

  void ImageNotifyFinished(ImageResourceContent*) override;
  String DebugName() const override { return "HTMLImageLoader"; }

 private:
  void NoImageResourceToLoad() override;
};

}  // namespace blink

#endif
