/*
 * Copyright (C) 2011 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
#ifndef LinkLoaderClient_h
#define LinkLoaderClient_h

#include "core/CoreExport.h"
#include "platform/WebTaskRunner.h"

#include "platform/heap/Handle.h"

namespace blink {

class CORE_EXPORT LinkLoaderClient : public GarbageCollectedMixin {
 public:
  virtual ~LinkLoaderClient() = default;
  void Trace(blink::Visitor* visitor) override {}

  virtual bool ShouldLoadLink() = 0;

  virtual void LinkLoaded() = 0;
  virtual void LinkLoadingErrored() = 0;
  // There is no notification for cancellation.

  virtual void DidStartLinkPrerender() = 0;
  virtual void DidStopLinkPrerender() = 0;
  virtual void DidSendLoadForLinkPrerender() = 0;
  virtual void DidSendDOMContentLoadedForLinkPrerender() = 0;

  virtual scoped_refptr<WebTaskRunner> GetLoadingTaskRunner() = 0;
};

}  // namespace blink

#endif
