// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_NTP_SNIPPETS_PREF_NAMES_H_
#define COMPONENTS_NTP_SNIPPETS_PREF_NAMES_H_

namespace ntp_snippets {
namespace prefs {

// If set to false, remote suggestions are completely disabled. This is set by
// an enterprise policy.
extern const char kEnableSnippets[];

// The pref name under which remote suggestion categories (including their ID
// and title) are stored.
extern const char kRemoteSuggestionCategories[];

// The pref name for the last time when a background fetch was attempted.
extern const char kSnippetLastFetchAttempt[];

// Pref names for minimal intervals between two successive background fetches.
//
// The prefs store *currently applied* minimal intervals. For each trigger type
// there are two intervals stored in prefs:
//  - "Wifi" for situations with Wifi / unmetered network connectivity, and
//  - "Fallback" for situations with only non-Wifi / metered network.
// We check "meteredness" of the current network only on platforms that support
// that, notably Android; we use WiFi as the proxy of being unmetered elsewhere.
//
// Intervals for trigger type 1: wake-up of the persistent scheduler.
extern const char kSnippetPersistentFetchingIntervalWifi[];
extern const char kSnippetPersistentFetchingIntervalFallback[];
// Intervals for trigger type 2: browser started-up (both cold and warm start).
extern const char kSnippetStartupFetchingIntervalWifi[];
extern const char kSnippetStartupFetchingIntervalFallback[];
// Intervals for trigger type 3: suggestions shown to the user.
extern const char kSnippetShownFetchingIntervalWifi[];
extern const char kSnippetShownFetchingIntervalFallback[];

// The pref name for today's count of RemoteSuggestionsFetcher requests, so far.
extern const char kSnippetFetcherRequestCount[];
// The pref name for today's count of RemoteSuggestionsFetcher interactive
// requests.
extern const char kSnippetFetcherInteractiveRequestCount[];
// The pref name for the current day for the counter of RemoteSuggestionsFetcher
// requests.
extern const char kSnippetFetcherRequestsDay[];

// The pref name for today's count of requests for article thumbnails, so far.
extern const char kSnippetThumbnailsRequestCount[];
// The pref name for today's count of interactive requests for article
// thumbnails, so far.
extern const char kSnippetThumbnailsInteractiveRequestCount[];
// The pref name for the current day for the counter of requests for article
// thumbnails.
extern const char kSnippetThumbnailsRequestsDay[];

// The pref name for the time of the last successful background fetch.
extern const char kLastSuccessfulBackgroundFetchTime[];

extern const char kDismissedAssetDownloadSuggestions[];
extern const char kDismissedForeignSessionsSuggestions[];
extern const char kDismissedOfflinePageDownloadSuggestions[];
extern const char kDismissedPhysicalWebPageSuggestions[];
extern const char kDismissedRecentOfflineTabSuggestions[];

extern const char kDismissedCategories[];

// The pref name for the discounted average number of browsing sessions per hour
// that involve opening a new NTP.
extern const char kUserClassifierAverageNTPOpenedPerHour[];
// The pref name for the discounted average number of browsing sessions per hour
// that involve opening showing the content suggestions.
extern const char kUserClassifierAverageSuggestionsShownPerHour[];
// The pref name for the discounted average number of browsing sessions per hour
// that involve using content suggestions (i.e. opening one or clicking on the
// "More" button).
extern const char kUserClassifierAverageSuggestionsUsedPerHour[];

// The pref name for the last time a new NTP was opened.
extern const char kUserClassifierLastTimeToOpenNTP[];
// The pref name for the last time content suggestions were shown to the user.
extern const char kUserClassifierLastTimeToShowSuggestions[];
// The pref name for the last time content suggestions were used by the user.
extern const char kUserClassifierLastTimeToUseSuggestions[];

// The pref name for the current order of categories and their clicks.
extern const char kClickBasedCategoryRankerOrderWithClicks[];
// The pref name for the time when last click decay has happened.
extern const char kClickBasedCategoryRankerLastDecayTime[];

// The folllowing prefs hold the data used when subscribing for content
// suggestions via GCM push updates. They are stored in pref such that in case
// of change (e.g. the token renders invalid), re-subscription is required.
// They are stored in prefs for persisting them across Chrome restarts.
///////////////////////////////////////////////////////////////////////////////
// The pref name for the subscription token used when subscription for
// breaking news push updates.
extern const char kBreakingNewsSubscriptionDataToken[];
// The pref name for whether the subscription is authenticated or not.
extern const char kBreakingNewsSubscriptionDataIsAuthenticated[];
//////////////////////// End of breaking news subscription-related prefs.

// The pref name for the subscription token received from the gcm server. As
// recommended by the GCM team, it is cached in pref for faster bookkeeping to
// see if subscription exists. This is pref holds the valid token even if
// different from the one used for subscription. When they are different, Chrome
// unsubscribes the old token from the content suggestions server, subscribe
// with the new one and update kBreakingNewsSubscriptionDataToken.
extern const char kBreakingNewsGCMSubscriptionTokenCache[];

}  // namespace prefs
}  // namespace ntp_snippets

#endif  // COMPONENTS_NTP_SNIPPETS_PREF_NAMES_H_
