/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android.purchasing;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.android.vending.billing.IInAppBillingService;
import java.util.ArrayList;
import java.util.HashSet;
import org.json.JSONException;
import org.json.JSONObject;
import org.qtproject.qt5.android.purchasing.Security;

public class QtInAppPurchase {
    private Context m_context = null;
    private IInAppBillingService m_service = null;
    private String m_publicKey = null;
    private long m_nativePointer;
    public static final int RESULT_OK = 0;
    public static final int RESULT_USER_CANCELED = 1;
    public static final int RESULT_BILLING_UNAVAILABLE = 3;
    public static final int RESULT_ITEM_UNAVAILABLE = 4;
    public static final int RESULT_DEVELOPER_ERROR = 5;
    public static final int RESULT_ERROR = 6;
    public static final int RESULT_ITEM_ALREADY_OWNED = 7;
    public static final int RESULT_ITEM_NOT_OWNED = 8;
    public static final int RESULT_QTPURCHASING_ERROR = 9;
    public static final String TAG = "QtInAppPurchase";
    public static final String TYPE_INAPP = "inapp";
    public static final int IAP_VERSION = 3;
    public static final int FAILUREREASON_NOFAILURE = 0;
    public static final int FAILUREREASON_USERCANCELED = 1;
    public static final int FAILUREREASON_ERROR = 2;
    private ServiceConnection m_serviceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            QtInAppPurchase.this.m_service = IInAppBillingService.Stub.asInterface(iBinder);
            try {
                int n = QtInAppPurchase.this.m_service.isBillingSupported(3, QtInAppPurchase.this.m_context.getPackageName(), QtInAppPurchase.TYPE_INAPP);
                if (n != 0) {
                    Log.e((String)QtInAppPurchase.TAG, (String)"In-app billing not supported");
                    return;
                }
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            final Handler handler = new Handler();
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    QtInAppPurchase.this.queryPurchasedProducts();
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            QtInAppPurchase.purchasedProductsQueried(QtInAppPurchase.this.m_nativePointer);
                        }
                    });
                }
            });
            thread.start();
        }

        public void onServiceDisconnected(ComponentName componentName) {
            QtInAppPurchase.this.m_service = null;
        }
    };

    public QtInAppPurchase(Context context, long l) {
        this.m_context = context;
        this.m_nativePointer = l;
    }

    public void initializeConnection() {
        Intent intent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
        intent.setPackage("com.android.vending");
        try {
            if (!this.m_context.getPackageManager().queryIntentServices(intent, 0).isEmpty()) {
                this.m_context.bindService(intent, this.m_serviceConnection, 1);
            } else {
                Log.e((String)TAG, (String)"No in-app billing service available.");
                QtInAppPurchase.purchasedProductsQueried(this.m_nativePointer);
            }
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Could not query InAppBillingService intent.");
            QtInAppPurchase.purchasedProductsQueried(this.m_nativePointer);
        }
    }

    private int bundleResponseCode(Bundle bundle) {
        Object object = bundle.get("RESPONSE_CODE");
        if (object == null) {
            return 0;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Long) {
            return (int)((Long)object).longValue();
        }
        Log.e((String)TAG, (String)("Unexpected result for response code: " + object));
        return 9;
    }

    private void queryPurchasedProducts() {
        if (this.m_service == null) {
            Log.e((String)TAG, (String)"queryPurchasedProducts: Service not initialized");
            return;
        }
        String string = null;
        try {
            Bundle bundle;
            do {
                int n;
                if ((n = this.bundleResponseCode(bundle = this.m_service.getPurchases(3, this.m_context.getPackageName(), TYPE_INAPP, string))) != 0) {
                    Log.e((String)TAG, (String)"queryPurchasedProducts: Failed to query purchases products");
                    return;
                }
                ArrayList arrayList = bundle.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
                if (arrayList == null) {
                    Log.e((String)TAG, (String)"queryPurchasedProducts: No data list in bundle");
                    return;
                }
                ArrayList arrayList2 = bundle.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
                if (arrayList2 == null) {
                    Log.e((String)TAG, (String)"queryPurchasedProducts: No signature list in bundle");
                    return;
                }
                if (arrayList.size() != arrayList2.size()) {
                    Log.e((String)TAG, (String)"queryPurchasedProducts: Mismatching sizes of lists in bundle");
                    return;
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string2 = (String)arrayList.get(i);
                    String string3 = (String)arrayList2.get(i);
                    if (this.m_publicKey != null && !Security.verifyPurchase(this.m_publicKey, string2, string3)) {
                        Log.e((String)TAG, (String)"queryPurchasedProducts: Cannot verify signature of purchase");
                        return;
                    }
                    try {
                        long l;
                        JSONObject jSONObject = new JSONObject(string2);
                        String string4 = jSONObject.getString("productId");
                        int n2 = jSONObject.getInt("purchaseState");
                        String string5 = jSONObject.getString("purchaseToken");
                        String string6 = jSONObject.has("orderId") ? jSONObject.getString("orderId") : "";
                        long l2 = l = jSONObject.has("purchaseTime") ? jSONObject.getLong("purchaseTime") : 0L;
                        if (n2 != 0) continue;
                        QtInAppPurchase.registerPurchased(this.m_nativePointer, string4, string3, string2, string5, string6, l);
                        continue;
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                }
            } while ((string = bundle.getString("INAPP_CONTINUATION_TOKEN")) != null && string.length() > 0);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void queryDetails(final String[] stringArray) {
        if (this.m_service == null) {
            Log.e((String)TAG, (String)"queryDetails: Service not initialized");
            for (String string : stringArray) {
                QtInAppPurchase.queryFailed(this.m_nativePointer, string);
            }
            return;
        }
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IInAppBillingService iInAppBillingService = QtInAppPurchase.this.m_service;
                synchronized (iInAppBillingService) {
                    HashSet<String> hashSet = new HashSet<String>();
                    int n = 0;
                    while (n < stringArray.length) {
                        ArrayList arrayList = new ArrayList();
                        for (int i = n; i < Math.min(n + 20, stringArray.length); ++i) {
                            arrayList.add(stringArray[i]);
                            hashSet.add(stringArray[i]);
                        }
                        n += arrayList.size();
                        try {
                            String string = new Bundle();
                            string.putStringArrayList("ITEM_ID_LIST", arrayList);
                            Bundle bundle = QtInAppPurchase.this.m_service.getSkuDetails(3, QtInAppPurchase.this.m_context.getPackageName(), QtInAppPurchase.TYPE_INAPP, (Bundle)string);
                            int n2 = QtInAppPurchase.this.bundleResponseCode(bundle);
                            if (n2 != 0) {
                                Log.e((String)QtInAppPurchase.TAG, (String)"queryDetails: Couldn't retrieve sku details.");
                                continue;
                            }
                            ArrayList arrayList2 = bundle.getStringArrayList("DETAILS_LIST");
                            if (arrayList2 == null) {
                                Log.e((String)QtInAppPurchase.TAG, (String)"queryDetails: No details list in response.");
                                continue;
                            }
                            for (String string2 : arrayList2) {
                                try {
                                    JSONObject jSONObject = new JSONObject(string2);
                                    String string3 = jSONObject.getString("productId");
                                    String string4 = jSONObject.getString("price");
                                    String string5 = jSONObject.getString("title");
                                    String string6 = jSONObject.getString("description");
                                    if (string3 == null || string4 == null || string5 == null || string6 == null) {
                                        Log.e((String)QtInAppPurchase.TAG, (String)"Data missing from product details.");
                                        continue;
                                    }
                                    hashSet.remove(string3);
                                    QtInAppPurchase.registerProduct(QtInAppPurchase.this.m_nativePointer, string3, string4, string5, string6);
                                }
                                catch (JSONException jSONException) {
                                    jSONException.printStackTrace();
                                }
                            }
                        }
                        catch (RemoteException remoteException) {
                            remoteException.printStackTrace();
                        }
                    }
                    for (String string : hashSet) {
                        QtInAppPurchase.queryFailed(QtInAppPurchase.this.m_nativePointer, string);
                    }
                }
            }
        });
        thread.start();
    }

    public void handleActivityResult(int n, int n2, Intent intent, String string) {
        if (intent == null) {
            this.purchaseFailed(n, 2, "Data missing from result");
            return;
        }
        int n3 = intent.getIntExtra("RESPONSE_CODE", -1);
        String string2 = intent.getStringExtra("INAPP_PURCHASE_DATA");
        String string3 = intent.getStringExtra("INAPP_DATA_SIGNATURE");
        String string4 = "";
        String string5 = "";
        long l = 0L;
        if (n3 == 1) {
            this.purchaseFailed(n, 1, "");
            return;
        }
        if (n3 != 0) {
            String string6;
            switch (n3) {
                case 3: {
                    string6 = "Billing unavailable";
                    break;
                }
                case 4: {
                    string6 = "Item unavailable";
                    break;
                }
                case 5: {
                    string6 = "Developer error";
                    break;
                }
                case 6: {
                    string6 = "Fatal error occurred";
                    break;
                }
                case 7: {
                    string6 = "Item already owned";
                    break;
                }
                default: {
                    string6 = "Unknown billing error " + n3;
                }
            }
            this.purchaseFailed(n, 2, string6);
            return;
        }
        try {
            if (this.m_publicKey != null && !Security.verifyPurchase(this.m_publicKey, string2, string3)) {
                this.purchaseFailed(n, 2, "Signature could not be verified");
                return;
            }
            JSONObject jSONObject = new JSONObject(string2);
            String string7 = jSONObject.getString("productId");
            if (!string7.equals(string)) {
                this.purchaseFailed(n, 2, "Unexpected identifier in result");
                return;
            }
            int n4 = jSONObject.getInt("purchaseState");
            if (n4 != 0) {
                this.purchaseFailed(n, 2, "Unexpected purchase state in result");
                return;
            }
            string4 = jSONObject.getString("purchaseToken");
            if (jSONObject.has("orderId")) {
                string5 = jSONObject.getString("orderId");
            }
            if (jSONObject.has("purchaseTime")) {
                l = jSONObject.getLong("purchaseTime");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.purchaseFailed(n, 2, exception.getMessage());
        }
        this.purchaseSucceeded(n, string3, string2, string4, string5, l);
    }

    public void setPublicKey(String string) {
        this.m_publicKey = string;
    }

    public IntentSender createBuyIntentSender(String string) {
        if (this.m_service == null) {
            Log.e((String)TAG, (String)"Unable to create buy intent. No IAP service connection.");
            return null;
        }
        try {
            Bundle bundle = this.m_service.getBuyIntent(3, this.m_context.getPackageName(), string, TYPE_INAPP, string);
            int n = this.bundleResponseCode(bundle);
            if (n != 0) {
                Log.e((String)TAG, (String)("Unable to create buy intent. Response code: " + n));
                return null;
            }
            PendingIntent pendingIntent = (PendingIntent)bundle.getParcelable("BUY_INTENT");
            return pendingIntent.getIntentSender();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void consumePurchase(String string) {
        if (this.m_service == null) {
            Log.e((String)TAG, (String)"consumePurchase: Unable to consume purchase. No IAP service connection.");
            return;
        }
        try {
            int n = this.m_service.consumePurchase(3, this.m_context.getPackageName(), string);
            if (n != 0) {
                Log.e((String)TAG, (String)("consumePurchase: Unable to consume purchase. Response code: " + n));
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void purchaseFailed(int n, int n2, String string) {
        QtInAppPurchase.purchaseFailed(this.m_nativePointer, n, n2, string);
    }

    private void purchaseSucceeded(int n, String string, String string2, String string3, String string4, long l) {
        QtInAppPurchase.purchaseSucceeded(this.m_nativePointer, n, string, string2, string3, string4, l);
    }

    private static native void queryFailed(long var0, String var2);

    private static native void purchasedProductsQueried(long var0);

    private static native void registerProduct(long var0, String var2, String var3, String var4, String var5);

    private static native void purchaseFailed(long var0, int var2, int var3, String var4);

    private static native void purchaseSucceeded(long var0, int var2, String var3, String var4, String var5, String var6, long var7);

    private static native void registerPurchased(long var0, String var2, String var3, String var4, String var5, String var6, long var7);
}

