/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android.multimedia;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.util.Log;
import android.view.SurfaceHolder;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;

public class QtAndroidMediaPlayer {
    private MediaPlayer mMediaPlayer = null;
    private Uri mUri = null;
    private final long mID;
    private final Context mContext;
    private boolean mMuted = false;
    private int mVolume = 100;
    private static final String TAG = "Qt MediaPlayer";
    private SurfaceHolder mSurfaceHolder = null;
    private volatile int mState = 1;

    public native void onErrorNative(int var1, int var2, long var3);

    public native void onBufferingUpdateNative(int var1, long var2);

    public native void onProgressUpdateNative(int var1, long var2);

    public native void onDurationChangedNative(int var1, long var2);

    public native void onInfoNative(int var1, int var2, long var3);

    public native void onVideoSizeChangedNative(int var1, int var2, long var3);

    public native void onStateChangedNative(int var1, long var2);

    public QtAndroidMediaPlayer(Context context, long l) {
        this.mID = l;
        this.mContext = context;
    }

    private void setState(int n) {
        if (this.mState == n) {
            return;
        }
        this.mState = n;
        this.onStateChangedNative(this.mState, this.mID);
    }

    private void init() {
        if (this.mMediaPlayer == null) {
            this.mMediaPlayer = new MediaPlayer();
            this.setState(2);
            this.setVolumeHelper(this.mMuted ? 0 : this.mVolume);
        }
    }

    public void start() {
        if ((this.mState & 0x1A8) == 0) {
            return;
        }
        try {
            this.mMediaPlayer.start();
            this.setState(32);
        }
        catch (IllegalStateException illegalStateException) {
            Log.d((String)TAG, (String)("" + illegalStateException.getMessage()));
        }
    }

    public void pause() {
        if ((this.mState & 0x1A0) == 0) {
            return;
        }
        try {
            this.mMediaPlayer.pause();
            this.setState(128);
        }
        catch (IllegalStateException illegalStateException) {
            Log.d((String)TAG, (String)("" + illegalStateException.getMessage()));
        }
    }

    public void stop() {
        if ((this.mState & 0x1E8) == 0) {
            return;
        }
        try {
            this.mMediaPlayer.stop();
            this.setState(64);
        }
        catch (IllegalStateException illegalStateException) {
            Log.d((String)TAG, (String)("" + illegalStateException.getMessage()));
        }
    }

    public void seekTo(int n) {
        if ((this.mState & 0x1A8) == 0) {
            return;
        }
        try {
            this.mMediaPlayer.seekTo(n);
        }
        catch (IllegalStateException illegalStateException) {
            Log.d((String)TAG, (String)("" + illegalStateException.getMessage()));
        }
    }

    public boolean isPlaying() {
        boolean bl = false;
        if ((this.mState & 0x1FA) == 0) {
            return bl;
        }
        try {
            bl = this.mMediaPlayer.isPlaying();
        }
        catch (IllegalStateException illegalStateException) {
            Log.d((String)TAG, (String)("" + illegalStateException.getMessage()));
        }
        return bl;
    }

    public void prepareAsync() {
        if ((this.mState & 0x50) == 0) {
            return;
        }
        try {
            this.mMediaPlayer.prepareAsync();
            this.setState(4);
        }
        catch (IllegalStateException illegalStateException) {
            Log.d((String)TAG, (String)("" + illegalStateException.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSource(String string) {
        block36: {
            if ((this.mState & 1) != 0) {
                this.init();
            }
            if ((this.mState & 2) == 0) {
                return;
            }
            this.mMediaPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)new MediaPlayerBufferingListener());
            this.mMediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)new MediaPlayerCompletionListener());
            this.mMediaPlayer.setOnInfoListener((MediaPlayer.OnInfoListener)new MediaPlayerInfoListener());
            this.mMediaPlayer.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)new MediaPlayerSeekCompleteListener());
            this.mMediaPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)new MediaPlayerVideoSizeChangedListener());
            this.mMediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)new MediaPlayerErrorListener());
            this.mMediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)new MediaPlayerPreparedListener());
            if (this.mSurfaceHolder != null) {
                this.mMediaPlayer.setDisplay(this.mSurfaceHolder);
            }
            AssetFileDescriptor assetFileDescriptor = null;
            FileInputStream fileInputStream = null;
            try {
                boolean bl;
                this.mUri = Uri.parse((String)string);
                boolean bl2 = bl = this.mUri.getScheme().compareTo("assets") == 0;
                if (bl) {
                    String string2 = this.mUri.getPath().substring(1);
                    AssetManager assetManager = this.mContext.getAssets();
                    assetFileDescriptor = assetManager.openFd(string2);
                    long l = assetFileDescriptor.getStartOffset();
                    long l2 = assetFileDescriptor.getLength();
                    FileDescriptor fileDescriptor = assetFileDescriptor.getFileDescriptor();
                    this.mMediaPlayer.setDataSource(fileDescriptor, l, l2);
                } else if (this.mUri.getScheme().compareTo("file") == 0) {
                    fileInputStream = new FileInputStream(this.mUri.getPath());
                    FileDescriptor fileDescriptor = fileInputStream.getFD();
                    this.mMediaPlayer.setDataSource(fileDescriptor);
                } else {
                    this.mMediaPlayer.setDataSource(string);
                }
                this.setState(16);
            }
            catch (IOException iOException) {
                Log.d((String)TAG, (String)("" + iOException.getMessage()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.d((String)TAG, (String)("" + illegalArgumentException.getMessage()));
            }
            catch (SecurityException securityException) {
                Log.d((String)TAG, (String)("" + securityException.getMessage()));
            }
            catch (IllegalStateException illegalStateException) {
                Log.d((String)TAG, (String)("" + illegalStateException.getMessage()));
            }
            catch (NullPointerException nullPointerException) {
                Log.d((String)TAG, (String)("" + nullPointerException.getMessage()));
            }
            finally {
                try {
                    if (assetFileDescriptor != null) {
                        assetFileDescriptor.close();
                    }
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                if ((this.mState & 0x10) != 0) break block36;
                this.setState(512);
                this.onErrorNative(1, -1004, this.mID);
                return;
            }
        }
    }

    public int getCurrentPosition() {
        int n = 0;
        if ((this.mState & 0x1FA) == 0) {
            return n;
        }
        try {
            n = this.mMediaPlayer.getCurrentPosition();
        }
        catch (IllegalStateException illegalStateException) {
            Log.d((String)TAG, (String)("" + illegalStateException.getMessage()));
        }
        return n;
    }

    public int getDuration() {
        int n = 0;
        if ((this.mState & 0x1E8) == 0) {
            return n;
        }
        try {
            n = this.mMediaPlayer.getDuration();
        }
        catch (IllegalStateException illegalStateException) {
            Log.d((String)TAG, (String)("" + illegalStateException.getMessage()));
        }
        return n;
    }

    public void setVolume(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 100) {
            n = 100;
        }
        this.mVolume = n;
        if (!this.mMuted) {
            this.setVolumeHelper(this.mVolume);
        }
    }

    private void setVolumeHelper(int n) {
        if ((this.mState & 0x1FA) == 0) {
            return;
        }
        try {
            float f = (float)n / 100.0f;
            this.mMediaPlayer.setVolume(f, f);
        }
        catch (IllegalStateException illegalStateException) {
            Log.d((String)TAG, (String)("" + illegalStateException.getMessage()));
        }
    }

    public SurfaceHolder display() {
        return this.mSurfaceHolder;
    }

    public void setDisplay(SurfaceHolder surfaceHolder) {
        this.mSurfaceHolder = surfaceHolder;
        if ((this.mState & 1) != 0) {
            return;
        }
        this.mMediaPlayer.setDisplay(this.mSurfaceHolder);
    }

    public int getVolume() {
        return this.mVolume;
    }

    public void mute(boolean bl) {
        this.mMuted = bl;
        this.setVolumeHelper(bl ? 0 : this.mVolume);
    }

    public boolean isMuted() {
        return this.mMuted;
    }

    public void reset() {
        if ((this.mState & 0x3FA) == 0) {
            return;
        }
        this.mMediaPlayer.reset();
        this.setState(2);
    }

    public void release() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.reset();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
        this.setState(1);
    }

    private class MediaPlayerVideoSizeChangedListener
    implements MediaPlayer.OnVideoSizeChangedListener {
        private MediaPlayerVideoSizeChangedListener() {
        }

        public void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
            QtAndroidMediaPlayer.this.onVideoSizeChangedNative(n, n2, QtAndroidMediaPlayer.this.mID);
        }
    }

    private class MediaPlayerSeekCompleteListener
    implements MediaPlayer.OnSeekCompleteListener {
        private MediaPlayerSeekCompleteListener() {
        }

        public void onSeekComplete(MediaPlayer mediaPlayer) {
            QtAndroidMediaPlayer.this.onProgressUpdateNative(QtAndroidMediaPlayer.this.getCurrentPosition(), QtAndroidMediaPlayer.this.mID);
        }
    }

    private class MediaPlayerPreparedListener
    implements MediaPlayer.OnPreparedListener {
        private MediaPlayerPreparedListener() {
        }

        public void onPrepared(MediaPlayer mediaPlayer) {
            QtAndroidMediaPlayer.this.setState(8);
            QtAndroidMediaPlayer.this.onDurationChangedNative(QtAndroidMediaPlayer.this.getDuration(), QtAndroidMediaPlayer.this.mID);
        }
    }

    private class MediaPlayerInfoListener
    implements MediaPlayer.OnInfoListener {
        private MediaPlayerInfoListener() {
        }

        public boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
            QtAndroidMediaPlayer.this.onInfoNative(n, n2, QtAndroidMediaPlayer.this.mID);
            return true;
        }
    }

    private class MediaPlayerCompletionListener
    implements MediaPlayer.OnCompletionListener {
        private MediaPlayerCompletionListener() {
        }

        public void onCompletion(MediaPlayer mediaPlayer) {
            QtAndroidMediaPlayer.this.setState(256);
        }
    }

    private class MediaPlayerBufferingListener
    implements MediaPlayer.OnBufferingUpdateListener {
        private int mBufferPercent = -1;

        private MediaPlayerBufferingListener() {
        }

        public void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
            if (this.mBufferPercent == n) {
                return;
            }
            this.mBufferPercent = n;
            QtAndroidMediaPlayer.this.onBufferingUpdateNative(this.mBufferPercent, QtAndroidMediaPlayer.this.mID);
        }
    }

    private class MediaPlayerErrorListener
    implements MediaPlayer.OnErrorListener {
        private MediaPlayerErrorListener() {
        }

        public boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
            QtAndroidMediaPlayer.this.setState(512);
            QtAndroidMediaPlayer.this.onErrorNative(n, n2, QtAndroidMediaPlayer.this.mID);
            return true;
        }
    }

    private class State {
        static final int Uninitialized = 1;
        static final int Idle = 2;
        static final int Preparing = 4;
        static final int Prepared = 8;
        static final int Initialized = 16;
        static final int Started = 32;
        static final int Stopped = 64;
        static final int Paused = 128;
        static final int PlaybackCompleted = 256;
        static final int Error = 512;

        private State() {
        }
    }
}

