/****************************************************************************
**
** Copyright (C) 2015 Klaralvdalens Datakonsult AB (KDAB).
** Copyright (C) 2017 The Qt Company Ltd.
** Contact: http://www.qt.io/licensing/
**
** This file is part of Qt 3D Studio.
**
** $QT_BEGIN_LICENSE:GPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 or (at your option) any later version
** approved by the KDE Free Qt Foundation. The licenses are as published by
** the Free Software Foundation and appearing in the file LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QT3DRENDER_DRAGON_SHADER_H
#define QT3DRENDER_DRAGON_SHADER_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of other Qt classes.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include <private/dragonbackendnode_p.h>
#include <private/dragonshaderparameterpack_p.h>
#include <private/dragonshadervariables_p.h>

#include <Qt3DRender/qshaderprogram.h>

#include <Qt3DCore/qpropertyupdatedchange.h>

#include <QVector>

QT_BEGIN_NAMESPACE

class QOpenGLShaderProgram;

namespace Qt3DRender {

namespace Dragon {

class ShaderManager;
struct AttachmentPack;

typedef uint ProgramDNA;

class Shader : public BackendNode
{
public:
    Shader();

//    void prepareUniforms(ShaderParameterPack &pack);
//    void setFragOutputs(const QHash<QString, int> &fragOutputs);
    const QHash<QString, int> fragOutputs() const;

    inline QVector<int> uniformsNamesIds() const { return m_uniformsNamesIds; }
    inline QVector<int> uniformBlockNamesIds() const { return m_uniformBlockNamesIds; }
    inline QVector<int> storageBlockNamesIds() const { return m_shaderStorageBlockNamesIds; }
    inline QVector<int> attributeNamesIds() const { return m_attributeNamesIds; }

    QVector<QString> uniformsNames() const;
    QVector<QString> attributesNames() const;
    QVector<QString> uniformBlockNames() const;
    QVector<QString> storageBlockNames() const;
    QVector<QByteArray> shaderCode() const;
    void setShaderCode(QShaderProgram::ShaderType type, const QByteArray &code);

    void sceneChangeEvent(const Qt3DCore::QSceneChangePtr &e) override;

    // TODO makes no sense here, we need to introduce LoadedShader type
    bool isLoaded() const { return m_isLoaded; }
    void setLoaded(bool loaded) { m_isLoaded = loaded; }
    ProgramDNA dna() const Q_DECL_NOTHROW { return m_dna; }

    inline QVector<ShaderUniform> uniforms() const { return m_uniforms; }
    inline QVector<ShaderAttribute> attributes() const { return m_attributes; }
    inline QVector<ShaderUniformBlock> uniformBlocks() const { return m_uniformBlocks; }
    inline QVector<ShaderStorageBlock> storageBlocks() const { return m_shaderStorageBlocks; }

    QHash<QString, ShaderUniform> activeUniformsForUniformBlock(int blockIndex) const;

    ShaderUniformBlock uniformBlockForBlockIndex(int blockNameId) const;
    ShaderUniformBlock uniformBlockForBlockNameId(int blockIndex) const;
    ShaderUniformBlock uniformBlockForBlockName(const QString &blockName) const;

    ShaderStorageBlock storageBlockForBlockIndex(int blockIndex) const ;
    ShaderStorageBlock storageBlockForBlockNameId(int blockNameId) const;
    ShaderStorageBlock storageBlockForBlockName(const QString &blockName) const;

    inline QString log() const { return m_log; }
    inline QShaderProgram::Status status() const { return m_status; }

    void submitPendingNotifications();
    inline bool hasPendingNotifications() const { return !m_pendingNotifications.empty(); }
    void initializeFromPeer(const Qt3DCore::QNodeCreatedChangeBasePtr &change) final;

    // TODO remove getters and make invariant members public
private:

    QVector<QString> m_uniformsNames;
    QVector<int> m_uniformsNamesIds;
    QVector<ShaderUniform> m_uniforms;

    QVector<QString> m_attributesNames;
    QVector<int> m_attributeNamesIds;
    QVector<ShaderAttribute> m_attributes;

    QVector<QString> m_uniformBlockNames;
    QVector<int> m_uniformBlockNamesIds;
    QVector<ShaderUniformBlock> m_uniformBlocks;
    QHash<int, QHash<QString, ShaderUniform> > m_uniformBlockIndexToShaderUniforms;

    QVector<QString> m_shaderStorageBlockNames;
    QVector<int> m_shaderStorageBlockNamesIds;
    QVector<ShaderStorageBlock> m_shaderStorageBlocks;

    QHash<QString, int> m_fragOutputs;

    QVector<QByteArray> m_shaderCode;

    bool m_isLoaded;
    ProgramDNA m_dna;
    ProgramDNA m_oldDna;
//    GraphicsContext *m_graphicsContext;
    QMetaObject::Connection m_contextConnection;
    QString m_log;
    QShaderProgram::Status m_status;

    QVector<Qt3DCore::QPropertyUpdatedChangePtr> m_pendingNotifications;

    void updateDNA();

    // Private so that only GraphicContext can call it
//    void initializeUniforms(const QVector<ShaderUniform> &uniformsDescription);
//    void initializeAttributes(const QVector<ShaderAttribute> &attributesDescription);
//    void initializeUniformBlocks(const QVector<ShaderUniformBlock> &uniformBlockDescription);
//    void initializeShaderStorageBlocks(const QVector<ShaderStorageBlock> &shaderStorageBlockDescription);

    void initializeFromReference(const Shader &other);
    void setLog(const QString &log);
    void setStatus(QShaderProgram::Status status);

//    friend class GraphicsContext;
};

#ifndef QT_NO_DEBUG_STREAM
inline QDebug operator<<(QDebug dbg, const Shader &shader)
{
    QDebugStateSaver saver(dbg);
    dbg << "QNodeId =" << shader.peerId() << "dna =" << shader.dna() << endl;
    return dbg;
}
#endif

} // namespace Dragon
} // namespace Qt3DRender

QT_END_NAMESPACE

#endif // QT3DRENDER_DRAGON_SHADER_H
