/****************************************************************************
**
** Copyright (C) 2019 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt 3D Studio.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// constructor
function Component()
{
    if (installer.isOfflineOnly()) {
        component.setValue("Virtual", "false")
        component.setValue("Default", "true")
        // skip component selection in the offline installer
        installer.setDefaultPageVisible(QInstaller.ComponentSelection, false);
    }

    component.loaded.connect(this, Component.prototype.loaded);
    installer.installationFinished.connect(this, Component.prototype.installationFinishedPageIsShown);
    installer.finishButtonClicked.connect(this, Component.prototype.installationFinished);
    installer.valueChanged.connect(this, Component.prototype.reactOnTargetDirChange);

    if (installer.value("os") == "win") {
        if (systemInfo.currentCpuArchitecture == "x86_64")
            component.addDependency("qt.tools.vcredist_msvc2015_x64");
    }

    // set the default values to SDKToolBinary
    Component.prototype.reactOnTargetDirChange("TargetDir", installer.value("TargetDir"));

    // for opensource installation add GPL3 EXCEPT dependency
    var isOpenSource = "true";
    if (['true', 'yes', '1'].indexOf(isOpenSource) >= 0) {
        var gpl3LicenseDependency = component.value("Dependencies");
        var gpl3LicenseDependencyStr = "qt.license.gplv3except";
        if (gpl3LicenseDependency) {
            component.setValue("Dependencies", gpl3LicenseDependency + "," + gpl3LicenseDependencyStr)
        }
        else {
            component.setValue("Dependencies", gpl3LicenseDependencyStr)
        }
    }

    // Determine if this is a online snapshot build
    var snapshotBuild = false;
    var isSnapshotStr = "false";
    if (['true', 'yes', '1'].indexOf(isSnapshotStr) >= 0)
        snapshotBuild = true;

    if (snapshotBuild) {
        // Add timestamp string to displayname to track snapshots
        var displayName = component.value("DisplayName");
        var timeStampStr = "-202010161016";
        if (displayName)
            component.setValue("DisplayName", displayName + " snapshot " + "(" + timeStampStr.replace('-', '') + ")")
    }
}

Component.prototype.loaded = function()
{
    try {
        if (installer.value("os") == "win" && installer.isInstaller())
            installer.addWizardPageItem(component, "AssociateCommonFiletypesForm", QInstaller.TargetDirectory);
    } catch(e) {
        print(e);
    }
}

Component.prototype.beginInstallation = function()
{
    if (installer.value("os") === "win")
        component.addStopProcessForUpdateRequest(component.qt3DStudioBinaryPath);
}

Component.prototype.reactOnTargetDirChange = function(key, value)
{
    if (key == "TargetDir") {
        if (installer.value("os") == "win") {
            component.qt3DStudioBinPath = value + "\\/Qt3DStudio-2.8.0-preview\\bin";
            component.qt3DStudioBinPath = component.qt3DStudioBinPath.replace(/\//g, "\\");
            component.platformPluginsPath = value + "\\/Qt3DStudio-2.8.0-preview\\plugins\\platforms";
            component.platformPluginsPath = component.platformPluginsPath.replace(/\//g, "\\");
            component.imageformatPluginsPath = value + "\\/Qt3DStudio-2.8.0-preview\\plugins\\imageformats";
            component.imageformatPluginsPath = component.imageformatPluginsPath.replace(/\//g, "\\");

            component.qt3DStudioBinaryPath = value + "\\/Qt3DStudio-2.8.0-preview\\bin\\Qt3DStudio.exe";
            component.qt3DStudioBinaryPath = component.qt3DStudioBinaryPath.replace(/\//g, "\\");
            component.qt3DSViewerBinaryPath = value + "\\/Qt3DStudio-2.8.0-preview\\bin\\q3dsviewer.exe";
            component.qt3DSViewerBinaryPath = component.qt3DSViewerBinaryPath.replace(/\//g, "\\");

        } else if (installer.value("os") == "mac") {
            component.qt3DStudioBinaryPath = value + "//Qt3DStudio-2.8.0-preview/bin/Qt3DStudio.app/Contents/MacOS/Qt3DStudio";
            // fix duplicate forward slashes in path
            component.qt3DStudioBinaryPath = component.qt3DStudioBinaryPath.replace(/\/+/g, "/");
        } else {
            component.qt3DStudioBinPath = value + "//Qt3DStudio-2.8.0-preview/bin";
            component.qt3DStudioBinPath = component.qt3DStudioBinPath.replace(/\/+/g, "/");
            component.platformPluginsPath = value + "//Qt3DStudio-2.8.0-preview/plugins/platforms";
            component.platformPluginsPath = component.platformPluginsPath.replace(/\/+/g, "/");
            component.imageformatPluginsPath = value + "//Qt3DStudio-2.8.0-preview/plugins/imageformats";
            component.imageformatPluginsPath = component.imageformatPluginsPath.replace(/\/+/g, "/");
            component.qt3DStudioBinaryPath = value + "//Qt3DStudio-2.8.0-preview/bin/Qt3DStudio";
            // fix duplicate forward slashes in path
            component.qt3DStudioBinaryPath = component.qt3DStudioBinaryPath.replace(/\/+/g, "/");
        }
    }
}

function registerWindowsFileTypeExtensions()
{
    try {
        component.addOperation("RegisterFileType",
                                "uip",
                                "\"" + component.qt3DStudioBinaryPath + "\" \"%1\"",
                                "Studio uip File",
                                "application/uip",
                                component.qt3DStudioBinaryPath + ",0");
        component.addOperation("RegisterFileType",
                                "uia",
                                "\"" + component.qt3DStudioBinaryPath + "\" \"%1\"",
                                "Studio uia File",
                                "application/uia",
                                component.qt3DStudioBinaryPath + ",0");
    } catch (e) {
        console.log(e);
    }
}

function patchLinuxInstallation()
{
    // platforms plugin
    var platformPluginsTargetDir = component.qt3DStudioBinPath + "/platforms";
    platformPluginsTargetDir = platformPluginsTargetDir.replace(/\/+/g, "/");

    component.addOperation("Execute", "{0}", "mkdir", platformPluginsTargetDir, "UNDOEXECUTE", "rm", "-rf", platformPluginsTargetDir);

    var platformPluginsSourceFile = component.platformPluginsPath + "/libqxcb.so";
    platformPluginsSourceFile = platformPluginsSourceFile.replace(/\/+/g, "/");

    var platformPluginsTargetFile = platformPluginsTargetDir + "/libqxcb.so";
    platformPluginsTargetFile = platformPluginsTargetFile.replace(/\/+/g, "/");

    component.addOperation("Move", platformPluginsSourceFile, platformPluginsTargetFile);

    // imageformats plugin
    var imageformatPluginsTargetDir = component.qt3DStudioBinPath + "/imageformats";
    imageformatPluginsTargetDir = imageformatPluginsTargetDir.replace(/\/+/g, "/");

    component.addOperation("Execute", "{0}", "mkdir", imageformatPluginsTargetDir, "UNDOEXECUTE", "rm", "-rf", imageformatPluginsTargetDir);

    var imageformatPluginsSourceFile = component.imageformatPluginsPath + "/libqjpeg.so";
    imageformatPluginsSourceFile = imageformatPluginsSourceFile.replace(/\/+/g, "/");

    var imageformatPluginsTargetFile = imageformatPluginsTargetDir + "/libqjpeg.so";
    imageformatPluginsTargetFile = imageformatPluginsTargetFile.replace(/\/+/g, "/");

    component.addOperation("Move", imageformatPluginsSourceFile, imageformatPluginsTargetFile);

    // xcbglintegrations plugin
    var xcbglintegrationSourceDir = installer.value("TargetDir") + "/Qt3DStudio-2.8.0-preview" + "/plugins/xcbglintegrations"
    var xcbglintegrationTargetDir = installer.value("TargetDir") + "/Qt3DStudio-2.8.0-preview" + "/bin/xcbglintegrations"
    xcbglintegrationSourceDir = xcbglintegrationSourceDir.replace(/\/+/g, "/");
    xcbglintegrationTargetDir = xcbglintegrationTargetDir.replace(/\/+/g, "/");
    print("Qt3DStudio patching: Copying: [" + xcbglintegrationSourceDir + "] into [" + xcbglintegrationTargetDir + "]")
    component.addOperation("Execute", "{0}", "/bin/cp", "-r", xcbglintegrationSourceDir, xcbglintegrationTargetDir, "UNDOEXECUTE", "rm", "-rf", xcbglintegrationTargetDir);

    // qml
    var qmlSourceDir = installer.value("TargetDir") + "/Qt3DStudio-2.8.0-preview" + "/qml"
    var qmlTargetDir = installer.value("TargetDir") + "/Qt3DStudio-2.8.0-preview" + "/bin/qml"
    qmlSourceDir = qmlSourceDir.replace(/\/+/g, "/");
    qmlTargetDir = qmlTargetDir.replace(/\/+/g, "/");
    // remove the existing qml file for the copy to succeed
    component.addOperation("Execute", "{0}", "/bin/rm", "-rf", qmlTargetDir);
    print("Qt3DStudio patching: Copying: [" + qmlSourceDir + "] into [" + qmlTargetDir + "]")
    component.addOperation("Execute", "{0}", "/bin/cp", "-r", qmlSourceDir, qmlTargetDir, "UNDOEXECUTE", "rm", "-rf", qmlTargetDir);

    // FIX ME: this is not a proper way to handle dependencies inside installation
    var libSourceDir = installer.value("TargetDir") + "/Qt3DStudio-2.8.0-preview" + "/lib"
    var libTargetDir = installer.value("TargetDir") + "/Qt3DStudio-2.8.0-preview" + "/bin/lib"
    libSourceDir = libSourceDir.replace(/\/+/g, "/");
    libTargetDir = libTargetDir.replace(/\/+/g, "/");
    // remove the existing lib files for the copy to succeed
    component.addOperation("Execute", "{0}", "/bin/rm", "-rf", libTargetDir);
    print("Qt3DStudio patching: Copying: [" + libSourceDir + "] into [" + libTargetDir + "]")
    component.addOperation("Execute", "{0}", "/bin/cp", "-r", libSourceDir, libTargetDir, "UNDOEXECUTE", "rm", "-rf", libTargetDir);

}

Component.prototype.createOperations = function()
{
    try {
        // call the base create operations function
        component.createOperations();
        if (installer.value("os") === "win") {
            // create shortcuts
            var filetypesForm = component.userInterface("AssociateCommonFiletypesForm")
            if (filetypesForm && filetypesForm.AssociateCommonFiletypesCheckBox.checked)
                registerWindowsFileTypeExtensions();
            component.addOperation("CreateShortcut", component.qt3DStudioBinaryPath, "@StartMenuDir@\\Qt 3D Studio.lnk",
                "workingDirectory=@TargetDir@\\bin", "iconPath=" + component.qt3DStudioBinaryPath, "iconId=0");
            component.addOperation("CreateShortcut", component.qt3DSViewerBinaryPath, "@StartMenuDir@\\Qt 3D Viewer.lnk",
                "workingDirectory=@TargetDir@\\bin", "iconPath=" + component.qt3DSViewerBinaryPath, "iconId=0");
            // maintenancetool filename is Qt3DStudioUninst in qt3dstudio offline installer configuration template
            if (installer.isOfflineOnly()) {
                component.addOperation("CreateShortcut", "@TargetDir@/Qt3DStudioUninst.exe", "@StartMenuDir@/Uninstall Qt 3D Studio.lnk", " --uninstall");
            }
            // maintenancetool filename is MaintenanceTool in online installations
            else {
                component.addOperation("CreateShortcut", "@TargetDir@/MaintenanceTool.exe", "@StartMenuDir@/Uninstall Qt 3D Studio.lnk", " --uninstall");
            }
        }
        if (installer.value("os") === "x11") {
            // patch the installation
            patchLinuxInstallation()
        }
    } catch (e) {
        console.log(e);
    }
}

Component.prototype.loaded = function ()
{
}

function isRoot()
{
    if (installer.value("os") == "x11" || installer.value("os") == "mac")
    {
        var id = installer.execute("/usr/bin/id", new Array("-u"))[0];
        id = id.replace(/(\r\n|\n|\r)/gm,"");
        if (id === "0")
        {
            return true;
        }
    }
    return false;
}

Component.prototype.installationFinishedPageIsShown = function()
{
    isroot = isRoot();
    try {
        if (component.installed && installer.isInstaller() && installer.status == QInstaller.Success && !isroot)
            installer.addWizardPageItem( component, "LaunchQt3DStudioPreviewCheckBoxForm", QInstaller.InstallationFinished );
    } catch(e) {
        print(e);
    }
}

Component.prototype.installationFinished = function()
{
    try {
        if (component.installed && installer.isInstaller() && installer.status == QInstaller.Success && !isroot) {
            var isLaunchQt3DStudioPreviewBoxChecked = component.userInterface("LaunchQt3DStudioPreviewCheckBoxForm").launchQt3DStudioPreviewCheckBox.checked;
            if (isLaunchQt3DStudioPreviewBoxChecked)
                installer.executeDetached(component.qt3DStudioBinaryPath, new Array(), "@homeDir@");
        }
    } catch(e) {
        print(e);
    }
}
