/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.trove;

import com.squareup.haha.guava.base.Ascii;
import com.squareup.haha.trove.THash;
import com.squareup.haha.trove.TIntHashingStrategy;
import com.squareup.haha.trove.TIntObjectProcedure;
import com.squareup.haha.trove.TObjectHash;

public final class TIntObjectHashMap<V>
extends THash
implements TIntHashingStrategy {
    private transient V[] _values;
    private transient int[] _set;
    protected final TIntHashingStrategy _hashingStrategy = this;

    @Override
    protected final int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new Object[capacity];
        this._set = new int[capacity];
        return capacity;
    }

    @Override
    protected final int capacity() {
        return this._values.length;
    }

    public final V put(int key, V value) {
        boolean wasFree = false;
        V previous = null;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = TIntObjectHashMap.unwrapNull(this._values[index]);
            isNewMapping = false;
        } else {
            wasFree = TIntObjectHashMap.isFree(this._values, index);
        }
        this._set[index] = key;
        V v = value;
        TObjectHash.NULL nULL = this._values[index] = v == null ? TObjectHash.NULL : v;
        if (isNewMapping) {
            this.postInsertHook(wasFree);
        }
        return previous;
    }

    @Override
    protected final void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        int[] oldKeys = this._set;
        Object[] oldVals = this._values;
        this._set = new int[newCapacity];
        this._values = new Object[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (!TIntObjectHashMap.isFull(oldVals, i)) continue;
            int o = oldKeys[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i];
        }
    }

    public final V get(int key) {
        int index = this.index(key);
        if (index < 0) {
            return null;
        }
        return TIntObjectHashMap.unwrapNull(this._values[index]);
    }

    private static <V> V unwrapNull(V value) {
        if (value == TObjectHash.NULL) {
            return null;
        }
        return value;
    }

    @Override
    public final void clear() {
        super.clear();
        int[] keys = this._set;
        V[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = 0;
            values[i] = null;
        }
    }

    protected final int index(int val) {
        int[] set = this._set;
        Object[] values = this._values;
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (!TIntObjectHashMap.isFree(values, index) && (TIntObjectHashMap.isRemoved(values, index) || set[index] != val)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (!TIntObjectHashMap.isFree(values, index) && (TIntObjectHashMap.isRemoved(values, index) || set[index] != val));
        }
        if (TIntObjectHashMap.isFree(values, index)) {
            return -1;
        }
        return index;
    }

    private int insertionIndex(int val) {
        int firstRemoved;
        Object[] values = this._values;
        int[] set = this._set;
        int length = this._set.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (TIntObjectHashMap.isFree(values, index)) {
            return index;
        }
        if (TIntObjectHashMap.isFull(values, index) && set[index] == val) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        int n = firstRemoved = TIntObjectHashMap.isRemoved(values, index) ? index : -1;
        do {
            if ((index -= probe) < 0) {
                index += length;
            }
            if (firstRemoved != -1 || !TIntObjectHashMap.isRemoved(values, index)) continue;
            firstRemoved = index;
        } while (TIntObjectHashMap.isFull(values, index) && set[index] != val);
        if (TIntObjectHashMap.isRemoved(values, index)) {
            while (!TIntObjectHashMap.isFree(values, index) && (TIntObjectHashMap.isRemoved(values, index) || set[index] != val)) {
                if ((index -= probe) >= 0) continue;
                index += length;
            }
        }
        if (TIntObjectHashMap.isFull(values, index)) {
            return -index - 1;
        }
        if (firstRemoved == -1) {
            return index;
        }
        return firstRemoved;
    }

    private static boolean isFull(Object[] values, int index) {
        Object value = values[index];
        return value != null && value != TObjectHash.REMOVED;
    }

    private static boolean isRemoved(Object[] values, int index) {
        return values[index] == TObjectHash.REMOVED;
    }

    private static boolean isFree(Object[] values, int index) {
        return values[index] == null;
    }

    public final boolean equals(Object other) {
        if (!(other instanceof TIntObjectHashMap)) {
            return false;
        }
        TIntObjectHashMap that = (TIntObjectHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public final int hashCode() {
        HashProcedure p = new HashProcedure(this);
        this.forEachEntry(p);
        HashProcedure hashProcedure = p;
        return hashProcedure.h;
    }

    @Override
    protected final void removeAt(int index) {
        this._values[index] = TObjectHash.REMOVED;
        super.removeAt(index);
    }

    public final Object[] getValues() {
        Object[] vals = new Object[this.size()];
        Object[] values = this._values;
        int i = this._values.length;
        int j = 0;
        while (i-- > 0) {
            if (!TIntObjectHashMap.isFull(values, i)) continue;
            vals[j++] = TIntObjectHashMap.unwrapNull(values[i]);
        }
        return vals;
    }

    public final int[] keys() {
        int[] keys = new int[this.size()];
        int[] k = this._set;
        Object[] values = this._values;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (!TIntObjectHashMap.isFull(values, i)) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    private boolean forEachEntry(TIntObjectProcedure<V> procedure) {
        int[] keys = this._set;
        Object[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (!TIntObjectHashMap.isFull(values, i) || procedure.execute(keys[i], TIntObjectHashMap.unwrapNull(values[i]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int computeHashCode(int val) {
        int n = val;
        return n;
    }

    static final class EqProcedure<V>
    implements TIntObjectProcedure<V> {
        private final TIntObjectHashMap<V> _otherMap;

        EqProcedure(TIntObjectHashMap<V> otherMap) {
            this._otherMap = otherMap;
        }

        @Override
        public final boolean execute(int key, V value) {
            V v;
            V v2;
            int index = this._otherMap.index(key);
            return index >= 0 && ((v2 = value) == (v = this._otherMap.get(key)) || v2 != null && v2.equals(v));
        }
    }

    final class HashProcedure
    implements TIntObjectProcedure<V> {
        int h;
        private /* synthetic */ TIntObjectHashMap this$0;

        HashProcedure(TIntObjectHashMap tIntObjectHashMap) {
            this.this$0 = tIntObjectHashMap;
        }

        @Override
        public final boolean execute(int key, V value) {
            this.h += this.this$0._hashingStrategy.computeHashCode(key) ^ Ascii.hash(value);
            return true;
        }
    }
}

