/****************************************************************************
**
** Copyright (C) 2016 Klaralvdalens Datakonsult AB (KDAB)
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtOpenGLExtensions module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:BSD$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** BSD License Usage
** Alternatively, you may use this file under the terms of the BSD license
** as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of The Qt Company Ltd nor the names of its
**     contributors may be used to endorse or promote products derived
**     from this software without specific prior written permission.
**
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
** $QT_END_LICENSE$
**
**
** This file was generated by glgen version 0.1
** Command line was: glgen
**
** glgen is Copyright (C) 2013 Klaralvdalens Datakonsult AB (KDAB)
**
** This is an auto-generated file.
** Do not edit! All changes made to it will be lost.
**
****************************************************************************/

#ifndef QOPENGLEXTENSIONS_H
#define QOPENGLEXTENSIONS_H

#include <QtCore/qglobal.h>

#ifndef QT_NO_OPENGL

#include <QtGui/qopengl.h>

class QOpenGLContext;

QT_BEGIN_NAMESPACE

#if 0
// silence syncqt warnings
#pragma qt_class(QOpenGLExtensions)
#pragma qt_sync_stop_processing
#endif


class QAbstractOpenGLExtensionPrivate
{
public:
    QAbstractOpenGLExtensionPrivate() : initialized(false) {}
    bool initialized;
};

class QAbstractOpenGLExtension
{
public:
    virtual ~QAbstractOpenGLExtension();

    virtual bool initializeOpenGLFunctions();

    Q_DECLARE_PRIVATE(QAbstractOpenGLExtension)

protected:
    bool isInitialized() const;

    QAbstractOpenGLExtension() {}
    QAbstractOpenGLExtension(QAbstractOpenGLExtensionPrivate &dd) : d_ptr(&dd) {}
    QAbstractOpenGLExtensionPrivate *d_ptr;
};

#if !defined(QT_OPENGL_ES_2)

class QOpenGLExtension_3DFX_tbufferPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP TbufferMask3DFX)(GLuint mask);
};

class QOpenGLExtension_3DFX_tbuffer : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_3DFX_tbuffer();

    bool initializeOpenGLFunctions() final;

    void glTbufferMask3DFX(GLuint mask);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_3DFX_tbuffer)
};

inline void QOpenGLExtension_3DFX_tbuffer::glTbufferMask3DFX(GLuint mask)
{
    Q_D(QOpenGLExtension_3DFX_tbuffer);
    d->TbufferMask3DFX(mask);
}

class QOpenGLExtension_AMD_debug_outputPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    GLuint (QOPENGLF_APIENTRYP GetDebugMessageLogAMD)(GLuint count, GLsizei bufsize, GLenum *categories, GLuint *severities, GLuint *ids, GLsizei *lengths, GLchar *message);
    void (QOPENGLF_APIENTRYP DebugMessageCallbackAMD)(GLDEBUGPROCAMD callback, GLvoid *userParam);
    void (QOPENGLF_APIENTRYP DebugMessageInsertAMD)(GLenum category, GLenum severity, GLuint id, GLsizei length, const GLchar *buf);
    void (QOPENGLF_APIENTRYP DebugMessageEnableAMD)(GLenum category, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled);
};

class QOpenGLExtension_AMD_debug_output : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_AMD_debug_output();

    bool initializeOpenGLFunctions() final;

    GLuint glGetDebugMessageLogAMD(GLuint count, GLsizei bufsize, GLenum *categories, GLuint *severities, GLuint *ids, GLsizei *lengths, GLchar *message);
    void glDebugMessageCallbackAMD(GLDEBUGPROCAMD callback, GLvoid *userParam);
    void glDebugMessageInsertAMD(GLenum category, GLenum severity, GLuint id, GLsizei length, const GLchar *buf);
    void glDebugMessageEnableAMD(GLenum category, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_AMD_debug_output)
};

inline GLuint QOpenGLExtension_AMD_debug_output::glGetDebugMessageLogAMD(GLuint count, GLsizei bufsize, GLenum *categories, GLuint *severities, GLuint *ids, GLsizei *lengths, GLchar *message)
{
    Q_D(QOpenGLExtension_AMD_debug_output);
    return d->GetDebugMessageLogAMD(count, bufsize, categories, severities, ids, lengths, message);
}

inline void QOpenGLExtension_AMD_debug_output::glDebugMessageCallbackAMD(GLDEBUGPROCAMD callback, GLvoid *userParam)
{
    Q_D(QOpenGLExtension_AMD_debug_output);
    d->DebugMessageCallbackAMD(callback, userParam);
}

inline void QOpenGLExtension_AMD_debug_output::glDebugMessageInsertAMD(GLenum category, GLenum severity, GLuint id, GLsizei length, const GLchar *buf)
{
    Q_D(QOpenGLExtension_AMD_debug_output);
    d->DebugMessageInsertAMD(category, severity, id, length, buf);
}

inline void QOpenGLExtension_AMD_debug_output::glDebugMessageEnableAMD(GLenum category, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled)
{
    Q_D(QOpenGLExtension_AMD_debug_output);
    d->DebugMessageEnableAMD(category, severity, count, ids, enabled);
}

class QOpenGLExtension_AMD_draw_buffers_blendPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP BlendEquationSeparateIndexedAMD)(GLuint buf, GLenum modeRGB, GLenum modeAlpha);
    void (QOPENGLF_APIENTRYP BlendEquationIndexedAMD)(GLuint buf, GLenum mode);
    void (QOPENGLF_APIENTRYP BlendFuncSeparateIndexedAMD)(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha);
    void (QOPENGLF_APIENTRYP BlendFuncIndexedAMD)(GLuint buf, GLenum src, GLenum dst);
};

class QOpenGLExtension_AMD_draw_buffers_blend : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_AMD_draw_buffers_blend();

    bool initializeOpenGLFunctions() final;

    void glBlendEquationSeparateIndexedAMD(GLuint buf, GLenum modeRGB, GLenum modeAlpha);
    void glBlendEquationIndexedAMD(GLuint buf, GLenum mode);
    void glBlendFuncSeparateIndexedAMD(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha);
    void glBlendFuncIndexedAMD(GLuint buf, GLenum src, GLenum dst);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_AMD_draw_buffers_blend)
};

inline void QOpenGLExtension_AMD_draw_buffers_blend::glBlendEquationSeparateIndexedAMD(GLuint buf, GLenum modeRGB, GLenum modeAlpha)
{
    Q_D(QOpenGLExtension_AMD_draw_buffers_blend);
    d->BlendEquationSeparateIndexedAMD(buf, modeRGB, modeAlpha);
}

inline void QOpenGLExtension_AMD_draw_buffers_blend::glBlendEquationIndexedAMD(GLuint buf, GLenum mode)
{
    Q_D(QOpenGLExtension_AMD_draw_buffers_blend);
    d->BlendEquationIndexedAMD(buf, mode);
}

inline void QOpenGLExtension_AMD_draw_buffers_blend::glBlendFuncSeparateIndexedAMD(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha)
{
    Q_D(QOpenGLExtension_AMD_draw_buffers_blend);
    d->BlendFuncSeparateIndexedAMD(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
}

inline void QOpenGLExtension_AMD_draw_buffers_blend::glBlendFuncIndexedAMD(GLuint buf, GLenum src, GLenum dst)
{
    Q_D(QOpenGLExtension_AMD_draw_buffers_blend);
    d->BlendFuncIndexedAMD(buf, src, dst);
}

class QOpenGLExtension_AMD_multi_draw_indirectPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP MultiDrawElementsIndirectAMD)(GLenum mode, GLenum type, const GLvoid *indirect, GLsizei primcount, GLsizei stride);
    void (QOPENGLF_APIENTRYP MultiDrawArraysIndirectAMD)(GLenum mode, const GLvoid *indirect, GLsizei primcount, GLsizei stride);
};

class QOpenGLExtension_AMD_multi_draw_indirect : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_AMD_multi_draw_indirect();

    bool initializeOpenGLFunctions() final;

    void glMultiDrawElementsIndirectAMD(GLenum mode, GLenum type, const GLvoid *indirect, GLsizei primcount, GLsizei stride);
    void glMultiDrawArraysIndirectAMD(GLenum mode, const GLvoid *indirect, GLsizei primcount, GLsizei stride);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_AMD_multi_draw_indirect)
};

inline void QOpenGLExtension_AMD_multi_draw_indirect::glMultiDrawElementsIndirectAMD(GLenum mode, GLenum type, const GLvoid *indirect, GLsizei primcount, GLsizei stride)
{
    Q_D(QOpenGLExtension_AMD_multi_draw_indirect);
    d->MultiDrawElementsIndirectAMD(mode, type, indirect, primcount, stride);
}

inline void QOpenGLExtension_AMD_multi_draw_indirect::glMultiDrawArraysIndirectAMD(GLenum mode, const GLvoid *indirect, GLsizei primcount, GLsizei stride)
{
    Q_D(QOpenGLExtension_AMD_multi_draw_indirect);
    d->MultiDrawArraysIndirectAMD(mode, indirect, primcount, stride);
}

class QOpenGLExtension_AMD_name_gen_deletePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    GLboolean (QOPENGLF_APIENTRYP IsNameAMD)(GLenum identifier, GLuint name);
    void (QOPENGLF_APIENTRYP DeleteNamesAMD)(GLenum identifier, GLuint num, const GLuint *names);
    void (QOPENGLF_APIENTRYP GenNamesAMD)(GLenum identifier, GLuint num, GLuint *names);
};

class QOpenGLExtension_AMD_name_gen_delete : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_AMD_name_gen_delete();

    bool initializeOpenGLFunctions() final;

    GLboolean glIsNameAMD(GLenum identifier, GLuint name);
    void glDeleteNamesAMD(GLenum identifier, GLuint num, const GLuint *names);
    void glGenNamesAMD(GLenum identifier, GLuint num, GLuint *names);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_AMD_name_gen_delete)
};

inline GLboolean QOpenGLExtension_AMD_name_gen_delete::glIsNameAMD(GLenum identifier, GLuint name)
{
    Q_D(QOpenGLExtension_AMD_name_gen_delete);
    return d->IsNameAMD(identifier, name);
}

inline void QOpenGLExtension_AMD_name_gen_delete::glDeleteNamesAMD(GLenum identifier, GLuint num, const GLuint *names)
{
    Q_D(QOpenGLExtension_AMD_name_gen_delete);
    d->DeleteNamesAMD(identifier, num, names);
}

inline void QOpenGLExtension_AMD_name_gen_delete::glGenNamesAMD(GLenum identifier, GLuint num, GLuint *names)
{
    Q_D(QOpenGLExtension_AMD_name_gen_delete);
    d->GenNamesAMD(identifier, num, names);
}

class QOpenGLExtension_AMD_performance_monitorPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetPerfMonitorCounterDataAMD)(GLuint monitor, GLenum pname, GLsizei dataSize, GLuint *data, GLint *bytesWritten);
    void (QOPENGLF_APIENTRYP EndPerfMonitorAMD)(GLuint monitor);
    void (QOPENGLF_APIENTRYP BeginPerfMonitorAMD)(GLuint monitor);
    void (QOPENGLF_APIENTRYP SelectPerfMonitorCountersAMD)(GLuint monitor, GLboolean enable, GLuint group, GLint numCounters, GLuint *counterList);
    void (QOPENGLF_APIENTRYP DeletePerfMonitorsAMD)(GLsizei n, GLuint *monitors);
    void (QOPENGLF_APIENTRYP GenPerfMonitorsAMD)(GLsizei n, GLuint *monitors);
    void (QOPENGLF_APIENTRYP GetPerfMonitorCounterInfoAMD)(GLuint group, GLuint counter, GLenum pname, GLvoid *data);
    void (QOPENGLF_APIENTRYP GetPerfMonitorCounterStringAMD)(GLuint group, GLuint counter, GLsizei bufSize, GLsizei *length, GLchar *counterString);
    void (QOPENGLF_APIENTRYP GetPerfMonitorGroupStringAMD)(GLuint group, GLsizei bufSize, GLsizei *length, GLchar *groupString);
    void (QOPENGLF_APIENTRYP GetPerfMonitorCountersAMD)(GLuint group, GLint *numCounters, GLint *maxActiveCounters, GLsizei counterSize, GLuint *counters);
    void (QOPENGLF_APIENTRYP GetPerfMonitorGroupsAMD)(GLint *numGroups, GLsizei groupsSize, GLuint *groups);
};

class QOpenGLExtension_AMD_performance_monitor : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_AMD_performance_monitor();

    bool initializeOpenGLFunctions() final;

    void glGetPerfMonitorCounterDataAMD(GLuint monitor, GLenum pname, GLsizei dataSize, GLuint *data, GLint *bytesWritten);
    void glEndPerfMonitorAMD(GLuint monitor);
    void glBeginPerfMonitorAMD(GLuint monitor);
    void glSelectPerfMonitorCountersAMD(GLuint monitor, GLboolean enable, GLuint group, GLint numCounters, GLuint *counterList);
    void glDeletePerfMonitorsAMD(GLsizei n, GLuint *monitors);
    void glGenPerfMonitorsAMD(GLsizei n, GLuint *monitors);
    void glGetPerfMonitorCounterInfoAMD(GLuint group, GLuint counter, GLenum pname, GLvoid *data);
    void glGetPerfMonitorCounterStringAMD(GLuint group, GLuint counter, GLsizei bufSize, GLsizei *length, GLchar *counterString);
    void glGetPerfMonitorGroupStringAMD(GLuint group, GLsizei bufSize, GLsizei *length, GLchar *groupString);
    void glGetPerfMonitorCountersAMD(GLuint group, GLint *numCounters, GLint *maxActiveCounters, GLsizei counterSize, GLuint *counters);
    void glGetPerfMonitorGroupsAMD(GLint *numGroups, GLsizei groupsSize, GLuint *groups);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_AMD_performance_monitor)
};

inline void QOpenGLExtension_AMD_performance_monitor::glGetPerfMonitorCounterDataAMD(GLuint monitor, GLenum pname, GLsizei dataSize, GLuint *data, GLint *bytesWritten)
{
    Q_D(QOpenGLExtension_AMD_performance_monitor);
    d->GetPerfMonitorCounterDataAMD(monitor, pname, dataSize, data, bytesWritten);
}

inline void QOpenGLExtension_AMD_performance_monitor::glEndPerfMonitorAMD(GLuint monitor)
{
    Q_D(QOpenGLExtension_AMD_performance_monitor);
    d->EndPerfMonitorAMD(monitor);
}

inline void QOpenGLExtension_AMD_performance_monitor::glBeginPerfMonitorAMD(GLuint monitor)
{
    Q_D(QOpenGLExtension_AMD_performance_monitor);
    d->BeginPerfMonitorAMD(monitor);
}

inline void QOpenGLExtension_AMD_performance_monitor::glSelectPerfMonitorCountersAMD(GLuint monitor, GLboolean enable, GLuint group, GLint numCounters, GLuint *counterList)
{
    Q_D(QOpenGLExtension_AMD_performance_monitor);
    d->SelectPerfMonitorCountersAMD(monitor, enable, group, numCounters, counterList);
}

inline void QOpenGLExtension_AMD_performance_monitor::glDeletePerfMonitorsAMD(GLsizei n, GLuint *monitors)
{
    Q_D(QOpenGLExtension_AMD_performance_monitor);
    d->DeletePerfMonitorsAMD(n, monitors);
}

inline void QOpenGLExtension_AMD_performance_monitor::glGenPerfMonitorsAMD(GLsizei n, GLuint *monitors)
{
    Q_D(QOpenGLExtension_AMD_performance_monitor);
    d->GenPerfMonitorsAMD(n, monitors);
}

inline void QOpenGLExtension_AMD_performance_monitor::glGetPerfMonitorCounterInfoAMD(GLuint group, GLuint counter, GLenum pname, GLvoid *data)
{
    Q_D(QOpenGLExtension_AMD_performance_monitor);
    d->GetPerfMonitorCounterInfoAMD(group, counter, pname, data);
}

inline void QOpenGLExtension_AMD_performance_monitor::glGetPerfMonitorCounterStringAMD(GLuint group, GLuint counter, GLsizei bufSize, GLsizei *length, GLchar *counterString)
{
    Q_D(QOpenGLExtension_AMD_performance_monitor);
    d->GetPerfMonitorCounterStringAMD(group, counter, bufSize, length, counterString);
}

inline void QOpenGLExtension_AMD_performance_monitor::glGetPerfMonitorGroupStringAMD(GLuint group, GLsizei bufSize, GLsizei *length, GLchar *groupString)
{
    Q_D(QOpenGLExtension_AMD_performance_monitor);
    d->GetPerfMonitorGroupStringAMD(group, bufSize, length, groupString);
}

inline void QOpenGLExtension_AMD_performance_monitor::glGetPerfMonitorCountersAMD(GLuint group, GLint *numCounters, GLint *maxActiveCounters, GLsizei counterSize, GLuint *counters)
{
    Q_D(QOpenGLExtension_AMD_performance_monitor);
    d->GetPerfMonitorCountersAMD(group, numCounters, maxActiveCounters, counterSize, counters);
}

inline void QOpenGLExtension_AMD_performance_monitor::glGetPerfMonitorGroupsAMD(GLint *numGroups, GLsizei groupsSize, GLuint *groups)
{
    Q_D(QOpenGLExtension_AMD_performance_monitor);
    d->GetPerfMonitorGroupsAMD(numGroups, groupsSize, groups);
}

class QOpenGLExtension_AMD_sample_positionsPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP SetMultisamplefvAMD)(GLenum pname, GLuint index, const GLfloat *val);
};

class QOpenGLExtension_AMD_sample_positions : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_AMD_sample_positions();

    bool initializeOpenGLFunctions() final;

    void glSetMultisamplefvAMD(GLenum pname, GLuint index, const GLfloat *val);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_AMD_sample_positions)
};

inline void QOpenGLExtension_AMD_sample_positions::glSetMultisamplefvAMD(GLenum pname, GLuint index, const GLfloat *val)
{
    Q_D(QOpenGLExtension_AMD_sample_positions);
    d->SetMultisamplefvAMD(pname, index, val);
}

class QOpenGLExtension_AMD_sparse_texturePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP TexStorageSparseAMD)(GLenum target, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLsizei layers, GLbitfield flags);
};

class QOpenGLExtension_AMD_sparse_texture : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_AMD_sparse_texture();

    bool initializeOpenGLFunctions() final;

    void glTexStorageSparseAMD(GLenum target, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLsizei layers, GLbitfield flags);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_AMD_sparse_texture)
};

inline void QOpenGLExtension_AMD_sparse_texture::glTexStorageSparseAMD(GLenum target, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLsizei layers, GLbitfield flags)
{
    Q_D(QOpenGLExtension_AMD_sparse_texture);
    d->TexStorageSparseAMD(target, internalFormat, width, height, depth, layers, flags);
}

class QOpenGLExtension_AMD_stencil_operation_extendedPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP StencilOpValueAMD)(GLenum face, GLuint value);
};

class QOpenGLExtension_AMD_stencil_operation_extended : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_AMD_stencil_operation_extended();

    bool initializeOpenGLFunctions() final;

    void glStencilOpValueAMD(GLenum face, GLuint value);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_AMD_stencil_operation_extended)
};

inline void QOpenGLExtension_AMD_stencil_operation_extended::glStencilOpValueAMD(GLenum face, GLuint value)
{
    Q_D(QOpenGLExtension_AMD_stencil_operation_extended);
    d->StencilOpValueAMD(face, value);
}

class QOpenGLExtension_AMD_vertex_shader_tesselatorPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP TessellationModeAMD)(GLenum mode);
    void (QOPENGLF_APIENTRYP TessellationFactorAMD)(GLfloat factor);
};

class QOpenGLExtension_AMD_vertex_shader_tesselator : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_AMD_vertex_shader_tesselator();

    bool initializeOpenGLFunctions() final;

    void glTessellationModeAMD(GLenum mode);
    void glTessellationFactorAMD(GLfloat factor);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_AMD_vertex_shader_tesselator)
};

inline void QOpenGLExtension_AMD_vertex_shader_tesselator::glTessellationModeAMD(GLenum mode)
{
    Q_D(QOpenGLExtension_AMD_vertex_shader_tesselator);
    d->TessellationModeAMD(mode);
}

inline void QOpenGLExtension_AMD_vertex_shader_tesselator::glTessellationFactorAMD(GLfloat factor)
{
    Q_D(QOpenGLExtension_AMD_vertex_shader_tesselator);
    d->TessellationFactorAMD(factor);
}

class QOpenGLExtension_APPLE_element_arrayPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP MultiDrawRangeElementArrayAPPLE)(GLenum mode, GLuint start, GLuint end, const GLint *first, const GLsizei *count, GLsizei primcount);
    void (QOPENGLF_APIENTRYP MultiDrawElementArrayAPPLE)(GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount);
    void (QOPENGLF_APIENTRYP DrawRangeElementArrayAPPLE)(GLenum mode, GLuint start, GLuint end, GLint first, GLsizei count);
    void (QOPENGLF_APIENTRYP DrawElementArrayAPPLE)(GLenum mode, GLint first, GLsizei count);
    void (QOPENGLF_APIENTRYP ElementPointerAPPLE)(GLenum type, const GLvoid *pointer);
};

class QOpenGLExtension_APPLE_element_array : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_APPLE_element_array();

    bool initializeOpenGLFunctions() final;

    void glMultiDrawRangeElementArrayAPPLE(GLenum mode, GLuint start, GLuint end, const GLint *first, const GLsizei *count, GLsizei primcount);
    void glMultiDrawElementArrayAPPLE(GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount);
    void glDrawRangeElementArrayAPPLE(GLenum mode, GLuint start, GLuint end, GLint first, GLsizei count);
    void glDrawElementArrayAPPLE(GLenum mode, GLint first, GLsizei count);
    void glElementPointerAPPLE(GLenum type, const GLvoid *pointer);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_APPLE_element_array)
};

inline void QOpenGLExtension_APPLE_element_array::glMultiDrawRangeElementArrayAPPLE(GLenum mode, GLuint start, GLuint end, const GLint *first, const GLsizei *count, GLsizei primcount)
{
    Q_D(QOpenGLExtension_APPLE_element_array);
    d->MultiDrawRangeElementArrayAPPLE(mode, start, end, first, count, primcount);
}

inline void QOpenGLExtension_APPLE_element_array::glMultiDrawElementArrayAPPLE(GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount)
{
    Q_D(QOpenGLExtension_APPLE_element_array);
    d->MultiDrawElementArrayAPPLE(mode, first, count, primcount);
}

inline void QOpenGLExtension_APPLE_element_array::glDrawRangeElementArrayAPPLE(GLenum mode, GLuint start, GLuint end, GLint first, GLsizei count)
{
    Q_D(QOpenGLExtension_APPLE_element_array);
    d->DrawRangeElementArrayAPPLE(mode, start, end, first, count);
}

inline void QOpenGLExtension_APPLE_element_array::glDrawElementArrayAPPLE(GLenum mode, GLint first, GLsizei count)
{
    Q_D(QOpenGLExtension_APPLE_element_array);
    d->DrawElementArrayAPPLE(mode, first, count);
}

inline void QOpenGLExtension_APPLE_element_array::glElementPointerAPPLE(GLenum type, const GLvoid *pointer)
{
    Q_D(QOpenGLExtension_APPLE_element_array);
    d->ElementPointerAPPLE(type, pointer);
}

class QOpenGLExtension_APPLE_fencePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP FinishObjectAPPLE)(GLenum object, GLint name);
    GLboolean (QOPENGLF_APIENTRYP TestObjectAPPLE)(GLenum object, GLuint name);
    void (QOPENGLF_APIENTRYP FinishFenceAPPLE)(GLuint fence);
    GLboolean (QOPENGLF_APIENTRYP TestFenceAPPLE)(GLuint fence);
    GLboolean (QOPENGLF_APIENTRYP IsFenceAPPLE)(GLuint fence);
    void (QOPENGLF_APIENTRYP SetFenceAPPLE)(GLuint fence);
    void (QOPENGLF_APIENTRYP DeleteFencesAPPLE)(GLsizei n, const GLuint *fences);
    void (QOPENGLF_APIENTRYP GenFencesAPPLE)(GLsizei n, GLuint *fences);
};

class QOpenGLExtension_APPLE_fence : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_APPLE_fence();

    bool initializeOpenGLFunctions() final;

    void glFinishObjectAPPLE(GLenum object, GLint name);
    GLboolean glTestObjectAPPLE(GLenum object, GLuint name);
    void glFinishFenceAPPLE(GLuint fence);
    GLboolean glTestFenceAPPLE(GLuint fence);
    GLboolean glIsFenceAPPLE(GLuint fence);
    void glSetFenceAPPLE(GLuint fence);
    void glDeleteFencesAPPLE(GLsizei n, const GLuint *fences);
    void glGenFencesAPPLE(GLsizei n, GLuint *fences);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_APPLE_fence)
};

inline void QOpenGLExtension_APPLE_fence::glFinishObjectAPPLE(GLenum object, GLint name)
{
    Q_D(QOpenGLExtension_APPLE_fence);
    d->FinishObjectAPPLE(object, name);
}

inline GLboolean QOpenGLExtension_APPLE_fence::glTestObjectAPPLE(GLenum object, GLuint name)
{
    Q_D(QOpenGLExtension_APPLE_fence);
    return d->TestObjectAPPLE(object, name);
}

inline void QOpenGLExtension_APPLE_fence::glFinishFenceAPPLE(GLuint fence)
{
    Q_D(QOpenGLExtension_APPLE_fence);
    d->FinishFenceAPPLE(fence);
}

inline GLboolean QOpenGLExtension_APPLE_fence::glTestFenceAPPLE(GLuint fence)
{
    Q_D(QOpenGLExtension_APPLE_fence);
    return d->TestFenceAPPLE(fence);
}

inline GLboolean QOpenGLExtension_APPLE_fence::glIsFenceAPPLE(GLuint fence)
{
    Q_D(QOpenGLExtension_APPLE_fence);
    return d->IsFenceAPPLE(fence);
}

inline void QOpenGLExtension_APPLE_fence::glSetFenceAPPLE(GLuint fence)
{
    Q_D(QOpenGLExtension_APPLE_fence);
    d->SetFenceAPPLE(fence);
}

inline void QOpenGLExtension_APPLE_fence::glDeleteFencesAPPLE(GLsizei n, const GLuint *fences)
{
    Q_D(QOpenGLExtension_APPLE_fence);
    d->DeleteFencesAPPLE(n, fences);
}

inline void QOpenGLExtension_APPLE_fence::glGenFencesAPPLE(GLsizei n, GLuint *fences)
{
    Q_D(QOpenGLExtension_APPLE_fence);
    d->GenFencesAPPLE(n, fences);
}

class QOpenGLExtension_APPLE_flush_buffer_rangePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP FlushMappedBufferRangeAPPLE)(GLenum target, GLintptr offset, GLsizeiptr size);
    void (QOPENGLF_APIENTRYP BufferParameteriAPPLE)(GLenum target, GLenum pname, GLint param);
};

class QOpenGLExtension_APPLE_flush_buffer_range : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_APPLE_flush_buffer_range();

    bool initializeOpenGLFunctions() final;

    void glFlushMappedBufferRangeAPPLE(GLenum target, GLintptr offset, GLsizeiptr size);
    void glBufferParameteriAPPLE(GLenum target, GLenum pname, GLint param);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_APPLE_flush_buffer_range)
};

inline void QOpenGLExtension_APPLE_flush_buffer_range::glFlushMappedBufferRangeAPPLE(GLenum target, GLintptr offset, GLsizeiptr size)
{
    Q_D(QOpenGLExtension_APPLE_flush_buffer_range);
    d->FlushMappedBufferRangeAPPLE(target, offset, size);
}

inline void QOpenGLExtension_APPLE_flush_buffer_range::glBufferParameteriAPPLE(GLenum target, GLenum pname, GLint param)
{
    Q_D(QOpenGLExtension_APPLE_flush_buffer_range);
    d->BufferParameteriAPPLE(target, pname, param);
}

class QOpenGLExtension_APPLE_object_purgeablePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetObjectParameterivAPPLE)(GLenum objectType, GLuint name, GLenum pname, GLint *params);
    GLenum (QOPENGLF_APIENTRYP ObjectUnpurgeableAPPLE)(GLenum objectType, GLuint name, GLenum option);
    GLenum (QOPENGLF_APIENTRYP ObjectPurgeableAPPLE)(GLenum objectType, GLuint name, GLenum option);
};

class QOpenGLExtension_APPLE_object_purgeable : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_APPLE_object_purgeable();

    bool initializeOpenGLFunctions() final;

    void glGetObjectParameterivAPPLE(GLenum objectType, GLuint name, GLenum pname, GLint *params);
    GLenum glObjectUnpurgeableAPPLE(GLenum objectType, GLuint name, GLenum option);
    GLenum glObjectPurgeableAPPLE(GLenum objectType, GLuint name, GLenum option);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_APPLE_object_purgeable)
};

inline void QOpenGLExtension_APPLE_object_purgeable::glGetObjectParameterivAPPLE(GLenum objectType, GLuint name, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_APPLE_object_purgeable);
    d->GetObjectParameterivAPPLE(objectType, name, pname, params);
}

inline GLenum QOpenGLExtension_APPLE_object_purgeable::glObjectUnpurgeableAPPLE(GLenum objectType, GLuint name, GLenum option)
{
    Q_D(QOpenGLExtension_APPLE_object_purgeable);
    return d->ObjectUnpurgeableAPPLE(objectType, name, option);
}

inline GLenum QOpenGLExtension_APPLE_object_purgeable::glObjectPurgeableAPPLE(GLenum objectType, GLuint name, GLenum option)
{
    Q_D(QOpenGLExtension_APPLE_object_purgeable);
    return d->ObjectPurgeableAPPLE(objectType, name, option);
}

class QOpenGLExtension_APPLE_texture_rangePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetTexParameterPointervAPPLE)(GLenum target, GLenum pname, GLvoid* *params);
    void (QOPENGLF_APIENTRYP TextureRangeAPPLE)(GLenum target, GLsizei length, const GLvoid *pointer);
};

class QOpenGLExtension_APPLE_texture_range : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_APPLE_texture_range();

    bool initializeOpenGLFunctions() final;

    void glGetTexParameterPointervAPPLE(GLenum target, GLenum pname, GLvoid* *params);
    void glTextureRangeAPPLE(GLenum target, GLsizei length, const GLvoid *pointer);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_APPLE_texture_range)
};

inline void QOpenGLExtension_APPLE_texture_range::glGetTexParameterPointervAPPLE(GLenum target, GLenum pname, GLvoid* *params)
{
    Q_D(QOpenGLExtension_APPLE_texture_range);
    d->GetTexParameterPointervAPPLE(target, pname, params);
}

inline void QOpenGLExtension_APPLE_texture_range::glTextureRangeAPPLE(GLenum target, GLsizei length, const GLvoid *pointer)
{
    Q_D(QOpenGLExtension_APPLE_texture_range);
    d->TextureRangeAPPLE(target, length, pointer);
}

class QOpenGLExtension_APPLE_vertex_array_objectPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    GLboolean (QOPENGLF_APIENTRYP IsVertexArrayAPPLE)(GLuint array);
    void (QOPENGLF_APIENTRYP GenVertexArraysAPPLE)(GLsizei n, GLuint *arrays);
    void (QOPENGLF_APIENTRYP DeleteVertexArraysAPPLE)(GLsizei n, const GLuint *arrays);
    void (QOPENGLF_APIENTRYP BindVertexArrayAPPLE)(GLuint array);
};

class QOpenGLExtension_APPLE_vertex_array_object : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_APPLE_vertex_array_object();

    bool initializeOpenGLFunctions() final;

    GLboolean glIsVertexArrayAPPLE(GLuint array);
    void glGenVertexArraysAPPLE(GLsizei n, GLuint *arrays);
    void glDeleteVertexArraysAPPLE(GLsizei n, const GLuint *arrays);
    void glBindVertexArrayAPPLE(GLuint array);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_APPLE_vertex_array_object)
};

inline GLboolean QOpenGLExtension_APPLE_vertex_array_object::glIsVertexArrayAPPLE(GLuint array)
{
    Q_D(QOpenGLExtension_APPLE_vertex_array_object);
    return d->IsVertexArrayAPPLE(array);
}

inline void QOpenGLExtension_APPLE_vertex_array_object::glGenVertexArraysAPPLE(GLsizei n, GLuint *arrays)
{
    Q_D(QOpenGLExtension_APPLE_vertex_array_object);
    d->GenVertexArraysAPPLE(n, arrays);
}

inline void QOpenGLExtension_APPLE_vertex_array_object::glDeleteVertexArraysAPPLE(GLsizei n, const GLuint *arrays)
{
    Q_D(QOpenGLExtension_APPLE_vertex_array_object);
    d->DeleteVertexArraysAPPLE(n, arrays);
}

inline void QOpenGLExtension_APPLE_vertex_array_object::glBindVertexArrayAPPLE(GLuint array)
{
    Q_D(QOpenGLExtension_APPLE_vertex_array_object);
    d->BindVertexArrayAPPLE(array);
}

class QOpenGLExtension_APPLE_vertex_array_rangePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP VertexArrayParameteriAPPLE)(GLenum pname, GLint param);
    void (QOPENGLF_APIENTRYP FlushVertexArrayRangeAPPLE)(GLsizei length, GLvoid *pointer);
    void (QOPENGLF_APIENTRYP VertexArrayRangeAPPLE)(GLsizei length, GLvoid *pointer);
};

class QOpenGLExtension_APPLE_vertex_array_range : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_APPLE_vertex_array_range();

    bool initializeOpenGLFunctions() final;

    void glVertexArrayParameteriAPPLE(GLenum pname, GLint param);
    void glFlushVertexArrayRangeAPPLE(GLsizei length, GLvoid *pointer);
    void glVertexArrayRangeAPPLE(GLsizei length, GLvoid *pointer);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_APPLE_vertex_array_range)
};

inline void QOpenGLExtension_APPLE_vertex_array_range::glVertexArrayParameteriAPPLE(GLenum pname, GLint param)
{
    Q_D(QOpenGLExtension_APPLE_vertex_array_range);
    d->VertexArrayParameteriAPPLE(pname, param);
}

inline void QOpenGLExtension_APPLE_vertex_array_range::glFlushVertexArrayRangeAPPLE(GLsizei length, GLvoid *pointer)
{
    Q_D(QOpenGLExtension_APPLE_vertex_array_range);
    d->FlushVertexArrayRangeAPPLE(length, pointer);
}

inline void QOpenGLExtension_APPLE_vertex_array_range::glVertexArrayRangeAPPLE(GLsizei length, GLvoid *pointer)
{
    Q_D(QOpenGLExtension_APPLE_vertex_array_range);
    d->VertexArrayRangeAPPLE(length, pointer);
}

class QOpenGLExtension_APPLE_vertex_program_evaluatorsPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP MapVertexAttrib2fAPPLE)(GLuint index, GLuint size, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points);
    void (QOPENGLF_APIENTRYP MapVertexAttrib2dAPPLE)(GLuint index, GLuint size, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points);
    void (QOPENGLF_APIENTRYP MapVertexAttrib1fAPPLE)(GLuint index, GLuint size, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points);
    void (QOPENGLF_APIENTRYP MapVertexAttrib1dAPPLE)(GLuint index, GLuint size, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points);
    GLboolean (QOPENGLF_APIENTRYP IsVertexAttribEnabledAPPLE)(GLuint index, GLenum pname);
    void (QOPENGLF_APIENTRYP DisableVertexAttribAPPLE)(GLuint index, GLenum pname);
    void (QOPENGLF_APIENTRYP EnableVertexAttribAPPLE)(GLuint index, GLenum pname);
};

class QOpenGLExtension_APPLE_vertex_program_evaluators : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_APPLE_vertex_program_evaluators();

    bool initializeOpenGLFunctions() final;

    void glMapVertexAttrib2fAPPLE(GLuint index, GLuint size, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points);
    void glMapVertexAttrib2dAPPLE(GLuint index, GLuint size, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points);
    void glMapVertexAttrib1fAPPLE(GLuint index, GLuint size, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points);
    void glMapVertexAttrib1dAPPLE(GLuint index, GLuint size, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points);
    GLboolean glIsVertexAttribEnabledAPPLE(GLuint index, GLenum pname);
    void glDisableVertexAttribAPPLE(GLuint index, GLenum pname);
    void glEnableVertexAttribAPPLE(GLuint index, GLenum pname);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_APPLE_vertex_program_evaluators)
};

inline void QOpenGLExtension_APPLE_vertex_program_evaluators::glMapVertexAttrib2fAPPLE(GLuint index, GLuint size, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points)
{
    Q_D(QOpenGLExtension_APPLE_vertex_program_evaluators);
    d->MapVertexAttrib2fAPPLE(index, size, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
}

inline void QOpenGLExtension_APPLE_vertex_program_evaluators::glMapVertexAttrib2dAPPLE(GLuint index, GLuint size, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points)
{
    Q_D(QOpenGLExtension_APPLE_vertex_program_evaluators);
    d->MapVertexAttrib2dAPPLE(index, size, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
}

inline void QOpenGLExtension_APPLE_vertex_program_evaluators::glMapVertexAttrib1fAPPLE(GLuint index, GLuint size, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points)
{
    Q_D(QOpenGLExtension_APPLE_vertex_program_evaluators);
    d->MapVertexAttrib1fAPPLE(index, size, u1, u2, stride, order, points);
}

inline void QOpenGLExtension_APPLE_vertex_program_evaluators::glMapVertexAttrib1dAPPLE(GLuint index, GLuint size, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points)
{
    Q_D(QOpenGLExtension_APPLE_vertex_program_evaluators);
    d->MapVertexAttrib1dAPPLE(index, size, u1, u2, stride, order, points);
}

inline GLboolean QOpenGLExtension_APPLE_vertex_program_evaluators::glIsVertexAttribEnabledAPPLE(GLuint index, GLenum pname)
{
    Q_D(QOpenGLExtension_APPLE_vertex_program_evaluators);
    return d->IsVertexAttribEnabledAPPLE(index, pname);
}

inline void QOpenGLExtension_APPLE_vertex_program_evaluators::glDisableVertexAttribAPPLE(GLuint index, GLenum pname)
{
    Q_D(QOpenGLExtension_APPLE_vertex_program_evaluators);
    d->DisableVertexAttribAPPLE(index, pname);
}

inline void QOpenGLExtension_APPLE_vertex_program_evaluators::glEnableVertexAttribAPPLE(GLuint index, GLenum pname)
{
    Q_D(QOpenGLExtension_APPLE_vertex_program_evaluators);
    d->EnableVertexAttribAPPLE(index, pname);
}

class QOpenGLExtension_ARB_ES2_compatibilityPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP ClearDepthf)(GLfloat dd);
    void (QOPENGLF_APIENTRYP DepthRangef)(GLfloat n, GLfloat f);
    void (QOPENGLF_APIENTRYP GetShaderPrecisionFormat)(GLenum shadertype, GLenum precisiontype, GLint *range, GLint *precision);
    void (QOPENGLF_APIENTRYP ShaderBinary)(GLsizei count, const GLuint *shaders, GLenum binaryformat, const GLvoid *binary, GLsizei length);
    void (QOPENGLF_APIENTRYP ReleaseShaderCompiler)();
};

class QOpenGLExtension_ARB_ES2_compatibility : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_ES2_compatibility();

    bool initializeOpenGLFunctions() final;

    void glClearDepthf(GLfloat dd);
    void glDepthRangef(GLfloat n, GLfloat f);
    void glGetShaderPrecisionFormat(GLenum shadertype, GLenum precisiontype, GLint *range, GLint *precision);
    void glShaderBinary(GLsizei count, const GLuint *shaders, GLenum binaryformat, const GLvoid *binary, GLsizei length);
    void glReleaseShaderCompiler();

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_ES2_compatibility)
};

inline void QOpenGLExtension_ARB_ES2_compatibility::glClearDepthf(GLfloat dd)
{
    Q_D(QOpenGLExtension_ARB_ES2_compatibility);
    d->ClearDepthf(dd);
}

inline void QOpenGLExtension_ARB_ES2_compatibility::glDepthRangef(GLfloat n, GLfloat f)
{
    Q_D(QOpenGLExtension_ARB_ES2_compatibility);
    d->DepthRangef(n, f);
}

inline void QOpenGLExtension_ARB_ES2_compatibility::glGetShaderPrecisionFormat(GLenum shadertype, GLenum precisiontype, GLint *range, GLint *precision)
{
    Q_D(QOpenGLExtension_ARB_ES2_compatibility);
    d->GetShaderPrecisionFormat(shadertype, precisiontype, range, precision);
}

inline void QOpenGLExtension_ARB_ES2_compatibility::glShaderBinary(GLsizei count, const GLuint *shaders, GLenum binaryformat, const GLvoid *binary, GLsizei length)
{
    Q_D(QOpenGLExtension_ARB_ES2_compatibility);
    d->ShaderBinary(count, shaders, binaryformat, binary, length);
}

inline void QOpenGLExtension_ARB_ES2_compatibility::glReleaseShaderCompiler()
{
    Q_D(QOpenGLExtension_ARB_ES2_compatibility);
    d->ReleaseShaderCompiler();
}

class QOpenGLExtension_ARB_base_instancePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP DrawElementsInstancedBaseVertexBaseInstance)(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLint basevertex, GLuint baseinstance);
    void (QOPENGLF_APIENTRYP DrawElementsInstancedBaseInstance)(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLuint baseinstance);
    void (QOPENGLF_APIENTRYP DrawArraysInstancedBaseInstance)(GLenum mode, GLint first, GLsizei count, GLsizei instancecount, GLuint baseinstance);
};

class QOpenGLExtension_ARB_base_instance : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_base_instance();

    bool initializeOpenGLFunctions() final;

    void glDrawElementsInstancedBaseVertexBaseInstance(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLint basevertex, GLuint baseinstance);
    void glDrawElementsInstancedBaseInstance(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLuint baseinstance);
    void glDrawArraysInstancedBaseInstance(GLenum mode, GLint first, GLsizei count, GLsizei instancecount, GLuint baseinstance);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_base_instance)
};

inline void QOpenGLExtension_ARB_base_instance::glDrawElementsInstancedBaseVertexBaseInstance(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLint basevertex, GLuint baseinstance)
{
    Q_D(QOpenGLExtension_ARB_base_instance);
    d->DrawElementsInstancedBaseVertexBaseInstance(mode, count, type, indices, instancecount, basevertex, baseinstance);
}

inline void QOpenGLExtension_ARB_base_instance::glDrawElementsInstancedBaseInstance(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLuint baseinstance)
{
    Q_D(QOpenGLExtension_ARB_base_instance);
    d->DrawElementsInstancedBaseInstance(mode, count, type, indices, instancecount, baseinstance);
}

inline void QOpenGLExtension_ARB_base_instance::glDrawArraysInstancedBaseInstance(GLenum mode, GLint first, GLsizei count, GLsizei instancecount, GLuint baseinstance)
{
    Q_D(QOpenGLExtension_ARB_base_instance);
    d->DrawArraysInstancedBaseInstance(mode, first, count, instancecount, baseinstance);
}

class QOpenGLExtension_ARB_blend_func_extendedPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    GLint (QOPENGLF_APIENTRYP GetFragDataIndex)(GLuint program, const GLchar *name);
    void (QOPENGLF_APIENTRYP BindFragDataLocationIndexed)(GLuint program, GLuint colorNumber, GLuint index, const GLchar *name);
};

class QOpenGLExtension_ARB_blend_func_extended : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_blend_func_extended();

    bool initializeOpenGLFunctions() final;

    GLint glGetFragDataIndex(GLuint program, const GLchar *name);
    void glBindFragDataLocationIndexed(GLuint program, GLuint colorNumber, GLuint index, const GLchar *name);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_blend_func_extended)
};

inline GLint QOpenGLExtension_ARB_blend_func_extended::glGetFragDataIndex(GLuint program, const GLchar *name)
{
    Q_D(QOpenGLExtension_ARB_blend_func_extended);
    return d->GetFragDataIndex(program, name);
}

inline void QOpenGLExtension_ARB_blend_func_extended::glBindFragDataLocationIndexed(GLuint program, GLuint colorNumber, GLuint index, const GLchar *name)
{
    Q_D(QOpenGLExtension_ARB_blend_func_extended);
    d->BindFragDataLocationIndexed(program, colorNumber, index, name);
}

class QOpenGLExtension_ARB_cl_eventPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    GLsync (QOPENGLF_APIENTRYP CreateSyncFromCLeventARB)(struct _cl_context * context, struct _cl_event * event, GLbitfield flags);
};

class QOpenGLExtension_ARB_cl_event : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_cl_event();

    bool initializeOpenGLFunctions() final;

    GLsync glCreateSyncFromCLeventARB(struct _cl_context * context, struct _cl_event * event, GLbitfield flags);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_cl_event)
};

inline GLsync QOpenGLExtension_ARB_cl_event::glCreateSyncFromCLeventARB(struct _cl_context * context, struct _cl_event * event, GLbitfield flags)
{
    Q_D(QOpenGLExtension_ARB_cl_event);
    return d->CreateSyncFromCLeventARB(context, event, flags);
}

class QOpenGLExtension_ARB_clear_buffer_objectPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP ClearBufferSubData)(GLenum target, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const void *data);
    void (QOPENGLF_APIENTRYP ClearBufferData)(GLenum target, GLenum internalformat, GLenum format, GLenum type, const void *data);
};

class QOpenGLExtension_ARB_clear_buffer_object : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_clear_buffer_object();

    bool initializeOpenGLFunctions() final;

    void glClearBufferSubData(GLenum target, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const void *data);
    void glClearBufferData(GLenum target, GLenum internalformat, GLenum format, GLenum type, const void *data);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_clear_buffer_object)
};

inline void QOpenGLExtension_ARB_clear_buffer_object::glClearBufferSubData(GLenum target, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const void *data)
{
    Q_D(QOpenGLExtension_ARB_clear_buffer_object);
    d->ClearBufferSubData(target, internalformat, offset, size, format, type, data);
}

inline void QOpenGLExtension_ARB_clear_buffer_object::glClearBufferData(GLenum target, GLenum internalformat, GLenum format, GLenum type, const void *data)
{
    Q_D(QOpenGLExtension_ARB_clear_buffer_object);
    d->ClearBufferData(target, internalformat, format, type, data);
}

class QOpenGLExtension_ARB_color_buffer_floatPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP ClampColorARB)(GLenum target, GLenum clamp);
};

class QOpenGLExtension_ARB_color_buffer_float : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_color_buffer_float();

    bool initializeOpenGLFunctions() final;

    void glClampColorARB(GLenum target, GLenum clamp);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_color_buffer_float)
};

inline void QOpenGLExtension_ARB_color_buffer_float::glClampColorARB(GLenum target, GLenum clamp)
{
    Q_D(QOpenGLExtension_ARB_color_buffer_float);
    d->ClampColorARB(target, clamp);
}

class QOpenGLExtension_ARB_compute_shaderPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP DispatchComputeIndirect)(GLintptr indirect);
    void (QOPENGLF_APIENTRYP DispatchCompute)(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z);
};

class QOpenGLExtension_ARB_compute_shader : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_compute_shader();

    bool initializeOpenGLFunctions() final;

    void glDispatchComputeIndirect(GLintptr indirect);
    void glDispatchCompute(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_compute_shader)
};

inline void QOpenGLExtension_ARB_compute_shader::glDispatchComputeIndirect(GLintptr indirect)
{
    Q_D(QOpenGLExtension_ARB_compute_shader);
    d->DispatchComputeIndirect(indirect);
}

inline void QOpenGLExtension_ARB_compute_shader::glDispatchCompute(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z)
{
    Q_D(QOpenGLExtension_ARB_compute_shader);
    d->DispatchCompute(num_groups_x, num_groups_y, num_groups_z);
}

class QOpenGLExtension_ARB_copy_bufferPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP CopyBufferSubData)(GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size);
};

class QOpenGLExtension_ARB_copy_buffer : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_copy_buffer();

    bool initializeOpenGLFunctions() final;

    void glCopyBufferSubData(GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_copy_buffer)
};

inline void QOpenGLExtension_ARB_copy_buffer::glCopyBufferSubData(GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size)
{
    Q_D(QOpenGLExtension_ARB_copy_buffer);
    d->CopyBufferSubData(readTarget, writeTarget, readOffset, writeOffset, size);
}

class QOpenGLExtension_ARB_copy_imagePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP CopyImageSubData)(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth);
};

class QOpenGLExtension_ARB_copy_image : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_copy_image();

    bool initializeOpenGLFunctions() final;

    void glCopyImageSubData(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_copy_image)
};

inline void QOpenGLExtension_ARB_copy_image::glCopyImageSubData(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth)
{
    Q_D(QOpenGLExtension_ARB_copy_image);
    d->CopyImageSubData(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight, srcDepth);
}

class QOpenGLExtension_ARB_debug_outputPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    GLuint (QOPENGLF_APIENTRYP GetDebugMessageLogARB)(GLuint count, GLsizei bufsize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog);
    void (QOPENGLF_APIENTRYP DebugMessageCallbackARB)(GLDEBUGPROCARB callback, const GLvoid *userParam);
    void (QOPENGLF_APIENTRYP DebugMessageInsertARB)(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *buf);
    void (QOPENGLF_APIENTRYP DebugMessageControlARB)(GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled);
};

class QOpenGLExtension_ARB_debug_output : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_debug_output();

    bool initializeOpenGLFunctions() final;

    GLuint glGetDebugMessageLogARB(GLuint count, GLsizei bufsize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog);
    void glDebugMessageCallbackARB(GLDEBUGPROCARB callback, const GLvoid *userParam);
    void glDebugMessageInsertARB(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *buf);
    void glDebugMessageControlARB(GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_debug_output)
};

inline GLuint QOpenGLExtension_ARB_debug_output::glGetDebugMessageLogARB(GLuint count, GLsizei bufsize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog)
{
    Q_D(QOpenGLExtension_ARB_debug_output);
    return d->GetDebugMessageLogARB(count, bufsize, sources, types, ids, severities, lengths, messageLog);
}

inline void QOpenGLExtension_ARB_debug_output::glDebugMessageCallbackARB(GLDEBUGPROCARB callback, const GLvoid *userParam)
{
    Q_D(QOpenGLExtension_ARB_debug_output);
    d->DebugMessageCallbackARB(callback, userParam);
}

inline void QOpenGLExtension_ARB_debug_output::glDebugMessageInsertARB(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *buf)
{
    Q_D(QOpenGLExtension_ARB_debug_output);
    d->DebugMessageInsertARB(source, type, id, severity, length, buf);
}

inline void QOpenGLExtension_ARB_debug_output::glDebugMessageControlARB(GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled)
{
    Q_D(QOpenGLExtension_ARB_debug_output);
    d->DebugMessageControlARB(source, type, severity, count, ids, enabled);
}

class QOpenGLExtension_ARB_draw_buffersPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP DrawBuffersARB)(GLsizei n, const GLenum *bufs);
};

class QOpenGLExtension_ARB_draw_buffers : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_draw_buffers();

    bool initializeOpenGLFunctions() final;

    void glDrawBuffersARB(GLsizei n, const GLenum *bufs);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_draw_buffers)
};

inline void QOpenGLExtension_ARB_draw_buffers::glDrawBuffersARB(GLsizei n, const GLenum *bufs)
{
    Q_D(QOpenGLExtension_ARB_draw_buffers);
    d->DrawBuffersARB(n, bufs);
}

class QOpenGLExtension_ARB_draw_buffers_blendPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP BlendFuncSeparateiARB)(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha);
    void (QOPENGLF_APIENTRYP BlendFunciARB)(GLuint buf, GLenum src, GLenum dst);
    void (QOPENGLF_APIENTRYP BlendEquationSeparateiARB)(GLuint buf, GLenum modeRGB, GLenum modeAlpha);
    void (QOPENGLF_APIENTRYP BlendEquationiARB)(GLuint buf, GLenum mode);
};

class QOpenGLExtension_ARB_draw_buffers_blend : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_draw_buffers_blend();

    bool initializeOpenGLFunctions() final;

    void glBlendFuncSeparateiARB(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha);
    void glBlendFunciARB(GLuint buf, GLenum src, GLenum dst);
    void glBlendEquationSeparateiARB(GLuint buf, GLenum modeRGB, GLenum modeAlpha);
    void glBlendEquationiARB(GLuint buf, GLenum mode);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_draw_buffers_blend)
};

inline void QOpenGLExtension_ARB_draw_buffers_blend::glBlendFuncSeparateiARB(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha)
{
    Q_D(QOpenGLExtension_ARB_draw_buffers_blend);
    d->BlendFuncSeparateiARB(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
}

inline void QOpenGLExtension_ARB_draw_buffers_blend::glBlendFunciARB(GLuint buf, GLenum src, GLenum dst)
{
    Q_D(QOpenGLExtension_ARB_draw_buffers_blend);
    d->BlendFunciARB(buf, src, dst);
}

inline void QOpenGLExtension_ARB_draw_buffers_blend::glBlendEquationSeparateiARB(GLuint buf, GLenum modeRGB, GLenum modeAlpha)
{
    Q_D(QOpenGLExtension_ARB_draw_buffers_blend);
    d->BlendEquationSeparateiARB(buf, modeRGB, modeAlpha);
}

inline void QOpenGLExtension_ARB_draw_buffers_blend::glBlendEquationiARB(GLuint buf, GLenum mode)
{
    Q_D(QOpenGLExtension_ARB_draw_buffers_blend);
    d->BlendEquationiARB(buf, mode);
}

class QOpenGLExtension_ARB_draw_elements_base_vertexPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP MultiDrawElementsBaseVertex)(GLenum mode, const GLsizei *count, GLenum type, const GLvoid* const *indices, GLsizei drawcount, const GLint *basevertex);
    void (QOPENGLF_APIENTRYP DrawElementsInstancedBaseVertex)(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei instancecount, GLint basevertex);
    void (QOPENGLF_APIENTRYP DrawRangeElementsBaseVertex)(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices, GLint basevertex);
    void (QOPENGLF_APIENTRYP DrawElementsBaseVertex)(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLint basevertex);
};

class QOpenGLExtension_ARB_draw_elements_base_vertex : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_draw_elements_base_vertex();

    bool initializeOpenGLFunctions() final;

    void glMultiDrawElementsBaseVertex(GLenum mode, const GLsizei *count, GLenum type, const GLvoid* const *indices, GLsizei drawcount, const GLint *basevertex);
    void glDrawElementsInstancedBaseVertex(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei instancecount, GLint basevertex);
    void glDrawRangeElementsBaseVertex(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices, GLint basevertex);
    void glDrawElementsBaseVertex(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLint basevertex);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_draw_elements_base_vertex)
};

inline void QOpenGLExtension_ARB_draw_elements_base_vertex::glMultiDrawElementsBaseVertex(GLenum mode, const GLsizei *count, GLenum type, const GLvoid* const *indices, GLsizei drawcount, const GLint *basevertex)
{
    Q_D(QOpenGLExtension_ARB_draw_elements_base_vertex);
    d->MultiDrawElementsBaseVertex(mode, count, type, indices, drawcount, basevertex);
}

inline void QOpenGLExtension_ARB_draw_elements_base_vertex::glDrawElementsInstancedBaseVertex(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei instancecount, GLint basevertex)
{
    Q_D(QOpenGLExtension_ARB_draw_elements_base_vertex);
    d->DrawElementsInstancedBaseVertex(mode, count, type, indices, instancecount, basevertex);
}

inline void QOpenGLExtension_ARB_draw_elements_base_vertex::glDrawRangeElementsBaseVertex(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices, GLint basevertex)
{
    Q_D(QOpenGLExtension_ARB_draw_elements_base_vertex);
    d->DrawRangeElementsBaseVertex(mode, start, end, count, type, indices, basevertex);
}

inline void QOpenGLExtension_ARB_draw_elements_base_vertex::glDrawElementsBaseVertex(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLint basevertex)
{
    Q_D(QOpenGLExtension_ARB_draw_elements_base_vertex);
    d->DrawElementsBaseVertex(mode, count, type, indices, basevertex);
}

class QOpenGLExtension_ARB_draw_indirectPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP DrawElementsIndirect)(GLenum mode, GLenum type, const GLvoid *indirect);
    void (QOPENGLF_APIENTRYP DrawArraysIndirect)(GLenum mode, const GLvoid *indirect);
};

class QOpenGLExtension_ARB_draw_indirect : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_draw_indirect();

    bool initializeOpenGLFunctions() final;

    void glDrawElementsIndirect(GLenum mode, GLenum type, const GLvoid *indirect);
    void glDrawArraysIndirect(GLenum mode, const GLvoid *indirect);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_draw_indirect)
};

inline void QOpenGLExtension_ARB_draw_indirect::glDrawElementsIndirect(GLenum mode, GLenum type, const GLvoid *indirect)
{
    Q_D(QOpenGLExtension_ARB_draw_indirect);
    d->DrawElementsIndirect(mode, type, indirect);
}

inline void QOpenGLExtension_ARB_draw_indirect::glDrawArraysIndirect(GLenum mode, const GLvoid *indirect)
{
    Q_D(QOpenGLExtension_ARB_draw_indirect);
    d->DrawArraysIndirect(mode, indirect);
}

class QOpenGLExtension_ARB_draw_instancedPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP DrawElementsInstancedARB)(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei primcount);
    void (QOPENGLF_APIENTRYP DrawArraysInstancedARB)(GLenum mode, GLint first, GLsizei count, GLsizei primcount);
};

class QOpenGLExtension_ARB_draw_instanced : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_draw_instanced();

    bool initializeOpenGLFunctions() final;

    void glDrawElementsInstancedARB(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei primcount);
    void glDrawArraysInstancedARB(GLenum mode, GLint first, GLsizei count, GLsizei primcount);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_draw_instanced)
};

inline void QOpenGLExtension_ARB_draw_instanced::glDrawElementsInstancedARB(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei primcount)
{
    Q_D(QOpenGLExtension_ARB_draw_instanced);
    d->DrawElementsInstancedARB(mode, count, type, indices, primcount);
}

inline void QOpenGLExtension_ARB_draw_instanced::glDrawArraysInstancedARB(GLenum mode, GLint first, GLsizei count, GLsizei primcount)
{
    Q_D(QOpenGLExtension_ARB_draw_instanced);
    d->DrawArraysInstancedARB(mode, first, count, primcount);
}

class QOpenGLExtension_ARB_framebuffer_no_attachmentsPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetFramebufferParameteriv)(GLenum target, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP FramebufferParameteri)(GLenum target, GLenum pname, GLint param);
};

class QOpenGLExtension_ARB_framebuffer_no_attachments : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_framebuffer_no_attachments();

    bool initializeOpenGLFunctions() final;

    void glGetFramebufferParameteriv(GLenum target, GLenum pname, GLint *params);
    void glFramebufferParameteri(GLenum target, GLenum pname, GLint param);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_framebuffer_no_attachments)
};

inline void QOpenGLExtension_ARB_framebuffer_no_attachments::glGetFramebufferParameteriv(GLenum target, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_ARB_framebuffer_no_attachments);
    d->GetFramebufferParameteriv(target, pname, params);
}

inline void QOpenGLExtension_ARB_framebuffer_no_attachments::glFramebufferParameteri(GLenum target, GLenum pname, GLint param)
{
    Q_D(QOpenGLExtension_ARB_framebuffer_no_attachments);
    d->FramebufferParameteri(target, pname, param);
}

class QOpenGLExtension_ARB_framebuffer_objectPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP FramebufferTextureLayer)(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer);
    void (QOPENGLF_APIENTRYP RenderbufferStorageMultisample)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
    void (QOPENGLF_APIENTRYP BlitFramebuffer)(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter);
    void (QOPENGLF_APIENTRYP GenerateMipmap)(GLenum target);
    void (QOPENGLF_APIENTRYP GetFramebufferAttachmentParameteriv)(GLenum target, GLenum attachment, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP FramebufferRenderbuffer)(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
    void (QOPENGLF_APIENTRYP FramebufferTexture3D)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset);
    void (QOPENGLF_APIENTRYP FramebufferTexture2D)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
    void (QOPENGLF_APIENTRYP FramebufferTexture1D)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
    GLenum (QOPENGLF_APIENTRYP CheckFramebufferStatus)(GLenum target);
    void (QOPENGLF_APIENTRYP GenFramebuffers)(GLsizei n, GLuint *framebuffers);
    void (QOPENGLF_APIENTRYP DeleteFramebuffers)(GLsizei n, const GLuint *framebuffers);
    void (QOPENGLF_APIENTRYP BindFramebuffer)(GLenum target, GLuint framebuffer);
    GLboolean (QOPENGLF_APIENTRYP IsFramebuffer)(GLuint framebuffer);
    void (QOPENGLF_APIENTRYP GetRenderbufferParameteriv)(GLenum target, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP RenderbufferStorage)(GLenum target, GLenum internalformat, GLsizei width, GLsizei height);
    void (QOPENGLF_APIENTRYP GenRenderbuffers)(GLsizei n, GLuint *renderbuffers);
    void (QOPENGLF_APIENTRYP DeleteRenderbuffers)(GLsizei n, const GLuint *renderbuffers);
    void (QOPENGLF_APIENTRYP BindRenderbuffer)(GLenum target, GLuint renderbuffer);
    GLboolean (QOPENGLF_APIENTRYP IsRenderbuffer)(GLuint renderbuffer);
};

class QOpenGLExtension_ARB_framebuffer_object : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_framebuffer_object();

    bool initializeOpenGLFunctions() final;

    void glFramebufferTextureLayer(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer);
    void glRenderbufferStorageMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
    void glBlitFramebuffer(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter);
    void glGenerateMipmap(GLenum target);
    void glGetFramebufferAttachmentParameteriv(GLenum target, GLenum attachment, GLenum pname, GLint *params);
    void glFramebufferRenderbuffer(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
    void glFramebufferTexture3D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset);
    void glFramebufferTexture2D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
    void glFramebufferTexture1D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
    GLenum glCheckFramebufferStatus(GLenum target);
    void glGenFramebuffers(GLsizei n, GLuint *framebuffers);
    void glDeleteFramebuffers(GLsizei n, const GLuint *framebuffers);
    void glBindFramebuffer(GLenum target, GLuint framebuffer);
    GLboolean glIsFramebuffer(GLuint framebuffer);
    void glGetRenderbufferParameteriv(GLenum target, GLenum pname, GLint *params);
    void glRenderbufferStorage(GLenum target, GLenum internalformat, GLsizei width, GLsizei height);
    void glGenRenderbuffers(GLsizei n, GLuint *renderbuffers);
    void glDeleteRenderbuffers(GLsizei n, const GLuint *renderbuffers);
    void glBindRenderbuffer(GLenum target, GLuint renderbuffer);
    GLboolean glIsRenderbuffer(GLuint renderbuffer);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_framebuffer_object)
};

inline void QOpenGLExtension_ARB_framebuffer_object::glFramebufferTextureLayer(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer)
{
    Q_D(QOpenGLExtension_ARB_framebuffer_object);
    d->FramebufferTextureLayer(target, attachment, texture, level, layer);
}

inline void QOpenGLExtension_ARB_framebuffer_object::glRenderbufferStorageMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height)
{
    Q_D(QOpenGLExtension_ARB_framebuffer_object);
    d->RenderbufferStorageMultisample(target, samples, internalformat, width, height);
}

inline void QOpenGLExtension_ARB_framebuffer_object::glBlitFramebuffer(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter)
{
    Q_D(QOpenGLExtension_ARB_framebuffer_object);
    d->BlitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
}

inline void QOpenGLExtension_ARB_framebuffer_object::glGenerateMipmap(GLenum target)
{
    Q_D(QOpenGLExtension_ARB_framebuffer_object);
    d->GenerateMipmap(target);
}

inline void QOpenGLExtension_ARB_framebuffer_object::glGetFramebufferAttachmentParameteriv(GLenum target, GLenum attachment, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_ARB_framebuffer_object);
    d->GetFramebufferAttachmentParameteriv(target, attachment, pname, params);
}

inline void QOpenGLExtension_ARB_framebuffer_object::glFramebufferRenderbuffer(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer)
{
    Q_D(QOpenGLExtension_ARB_framebuffer_object);
    d->FramebufferRenderbuffer(target, attachment, renderbuffertarget, renderbuffer);
}

inline void QOpenGLExtension_ARB_framebuffer_object::glFramebufferTexture3D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset)
{
    Q_D(QOpenGLExtension_ARB_framebuffer_object);
    d->FramebufferTexture3D(target, attachment, textarget, texture, level, zoffset);
}

inline void QOpenGLExtension_ARB_framebuffer_object::glFramebufferTexture2D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)
{
    Q_D(QOpenGLExtension_ARB_framebuffer_object);
    d->FramebufferTexture2D(target, attachment, textarget, texture, level);
}

inline void QOpenGLExtension_ARB_framebuffer_object::glFramebufferTexture1D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)
{
    Q_D(QOpenGLExtension_ARB_framebuffer_object);
    d->FramebufferTexture1D(target, attachment, textarget, texture, level);
}

inline GLenum QOpenGLExtension_ARB_framebuffer_object::glCheckFramebufferStatus(GLenum target)
{
    Q_D(QOpenGLExtension_ARB_framebuffer_object);
    return d->CheckFramebufferStatus(target);
}

inline void QOpenGLExtension_ARB_framebuffer_object::glGenFramebuffers(GLsizei n, GLuint *framebuffers)
{
    Q_D(QOpenGLExtension_ARB_framebuffer_object);
    d->GenFramebuffers(n, framebuffers);
}

inline void QOpenGLExtension_ARB_framebuffer_object::glDeleteFramebuffers(GLsizei n, const GLuint *framebuffers)
{
    Q_D(QOpenGLExtension_ARB_framebuffer_object);
    d->DeleteFramebuffers(n, framebuffers);
}

inline void QOpenGLExtension_ARB_framebuffer_object::glBindFramebuffer(GLenum target, GLuint framebuffer)
{
    Q_D(QOpenGLExtension_ARB_framebuffer_object);
    d->BindFramebuffer(target, framebuffer);
}

inline GLboolean QOpenGLExtension_ARB_framebuffer_object::glIsFramebuffer(GLuint framebuffer)
{
    Q_D(QOpenGLExtension_ARB_framebuffer_object);
    return d->IsFramebuffer(framebuffer);
}

inline void QOpenGLExtension_ARB_framebuffer_object::glGetRenderbufferParameteriv(GLenum target, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_ARB_framebuffer_object);
    d->GetRenderbufferParameteriv(target, pname, params);
}

inline void QOpenGLExtension_ARB_framebuffer_object::glRenderbufferStorage(GLenum target, GLenum internalformat, GLsizei width, GLsizei height)
{
    Q_D(QOpenGLExtension_ARB_framebuffer_object);
    d->RenderbufferStorage(target, internalformat, width, height);
}

inline void QOpenGLExtension_ARB_framebuffer_object::glGenRenderbuffers(GLsizei n, GLuint *renderbuffers)
{
    Q_D(QOpenGLExtension_ARB_framebuffer_object);
    d->GenRenderbuffers(n, renderbuffers);
}

inline void QOpenGLExtension_ARB_framebuffer_object::glDeleteRenderbuffers(GLsizei n, const GLuint *renderbuffers)
{
    Q_D(QOpenGLExtension_ARB_framebuffer_object);
    d->DeleteRenderbuffers(n, renderbuffers);
}

inline void QOpenGLExtension_ARB_framebuffer_object::glBindRenderbuffer(GLenum target, GLuint renderbuffer)
{
    Q_D(QOpenGLExtension_ARB_framebuffer_object);
    d->BindRenderbuffer(target, renderbuffer);
}

inline GLboolean QOpenGLExtension_ARB_framebuffer_object::glIsRenderbuffer(GLuint renderbuffer)
{
    Q_D(QOpenGLExtension_ARB_framebuffer_object);
    return d->IsRenderbuffer(renderbuffer);
}

class QOpenGLExtension_ARB_geometry_shader4Private : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP FramebufferTextureFaceARB)(GLenum target, GLenum attachment, GLuint texture, GLint level, GLenum face);
    void (QOPENGLF_APIENTRYP FramebufferTextureLayerARB)(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer);
    void (QOPENGLF_APIENTRYP FramebufferTextureARB)(GLenum target, GLenum attachment, GLuint texture, GLint level);
    void (QOPENGLF_APIENTRYP ProgramParameteriARB)(GLuint program, GLenum pname, GLint value);
};

class QOpenGLExtension_ARB_geometry_shader4 : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_geometry_shader4();

    bool initializeOpenGLFunctions() final;

    void glFramebufferTextureFaceARB(GLenum target, GLenum attachment, GLuint texture, GLint level, GLenum face);
    void glFramebufferTextureLayerARB(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer);
    void glFramebufferTextureARB(GLenum target, GLenum attachment, GLuint texture, GLint level);
    void glProgramParameteriARB(GLuint program, GLenum pname, GLint value);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_geometry_shader4)
};

inline void QOpenGLExtension_ARB_geometry_shader4::glFramebufferTextureFaceARB(GLenum target, GLenum attachment, GLuint texture, GLint level, GLenum face)
{
    Q_D(QOpenGLExtension_ARB_geometry_shader4);
    d->FramebufferTextureFaceARB(target, attachment, texture, level, face);
}

inline void QOpenGLExtension_ARB_geometry_shader4::glFramebufferTextureLayerARB(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer)
{
    Q_D(QOpenGLExtension_ARB_geometry_shader4);
    d->FramebufferTextureLayerARB(target, attachment, texture, level, layer);
}

inline void QOpenGLExtension_ARB_geometry_shader4::glFramebufferTextureARB(GLenum target, GLenum attachment, GLuint texture, GLint level)
{
    Q_D(QOpenGLExtension_ARB_geometry_shader4);
    d->FramebufferTextureARB(target, attachment, texture, level);
}

inline void QOpenGLExtension_ARB_geometry_shader4::glProgramParameteriARB(GLuint program, GLenum pname, GLint value)
{
    Q_D(QOpenGLExtension_ARB_geometry_shader4);
    d->ProgramParameteriARB(program, pname, value);
}

class QOpenGLExtension_ARB_get_program_binaryPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP ProgramParameteri)(GLuint program, GLenum pname, GLint value);
    void (QOPENGLF_APIENTRYP ProgramBinary)(GLuint program, GLenum binaryFormat, const GLvoid *binary, GLsizei length);
    void (QOPENGLF_APIENTRYP GetProgramBinary)(GLuint program, GLsizei bufSize, GLsizei *length, GLenum *binaryFormat, GLvoid *binary);
};

class QOpenGLExtension_ARB_get_program_binary : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_get_program_binary();

    bool initializeOpenGLFunctions() final;

    void glProgramParameteri(GLuint program, GLenum pname, GLint value);
    void glProgramBinary(GLuint program, GLenum binaryFormat, const GLvoid *binary, GLsizei length);
    void glGetProgramBinary(GLuint program, GLsizei bufSize, GLsizei *length, GLenum *binaryFormat, GLvoid *binary);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_get_program_binary)
};

inline void QOpenGLExtension_ARB_get_program_binary::glProgramParameteri(GLuint program, GLenum pname, GLint value)
{
    Q_D(QOpenGLExtension_ARB_get_program_binary);
    d->ProgramParameteri(program, pname, value);
}

inline void QOpenGLExtension_ARB_get_program_binary::glProgramBinary(GLuint program, GLenum binaryFormat, const GLvoid *binary, GLsizei length)
{
    Q_D(QOpenGLExtension_ARB_get_program_binary);
    d->ProgramBinary(program, binaryFormat, binary, length);
}

inline void QOpenGLExtension_ARB_get_program_binary::glGetProgramBinary(GLuint program, GLsizei bufSize, GLsizei *length, GLenum *binaryFormat, GLvoid *binary)
{
    Q_D(QOpenGLExtension_ARB_get_program_binary);
    d->GetProgramBinary(program, bufSize, length, binaryFormat, binary);
}

class QOpenGLExtension_ARB_gpu_shader_fp64Private : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetUniformdv)(GLuint program, GLint location, GLdouble *params);
    void (QOPENGLF_APIENTRYP UniformMatrix4x3dv)(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void (QOPENGLF_APIENTRYP UniformMatrix4x2dv)(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void (QOPENGLF_APIENTRYP UniformMatrix3x4dv)(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void (QOPENGLF_APIENTRYP UniformMatrix3x2dv)(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void (QOPENGLF_APIENTRYP UniformMatrix2x4dv)(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void (QOPENGLF_APIENTRYP UniformMatrix2x3dv)(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void (QOPENGLF_APIENTRYP UniformMatrix4dv)(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void (QOPENGLF_APIENTRYP UniformMatrix3dv)(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void (QOPENGLF_APIENTRYP UniformMatrix2dv)(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void (QOPENGLF_APIENTRYP Uniform4dv)(GLint location, GLsizei count, const GLdouble *value);
    void (QOPENGLF_APIENTRYP Uniform3dv)(GLint location, GLsizei count, const GLdouble *value);
    void (QOPENGLF_APIENTRYP Uniform2dv)(GLint location, GLsizei count, const GLdouble *value);
    void (QOPENGLF_APIENTRYP Uniform1dv)(GLint location, GLsizei count, const GLdouble *value);
    void (QOPENGLF_APIENTRYP Uniform4d)(GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
    void (QOPENGLF_APIENTRYP Uniform3d)(GLint location, GLdouble x, GLdouble y, GLdouble z);
    void (QOPENGLF_APIENTRYP Uniform2d)(GLint location, GLdouble x, GLdouble y);
    void (QOPENGLF_APIENTRYP Uniform1d)(GLint location, GLdouble x);
};

class QOpenGLExtension_ARB_gpu_shader_fp64 : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_gpu_shader_fp64();

    bool initializeOpenGLFunctions() final;

    void glGetUniformdv(GLuint program, GLint location, GLdouble *params);
    void glUniformMatrix4x3dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void glUniformMatrix4x2dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void glUniformMatrix3x4dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void glUniformMatrix3x2dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void glUniformMatrix2x4dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void glUniformMatrix2x3dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void glUniformMatrix4dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void glUniformMatrix3dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void glUniformMatrix2dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void glUniform4dv(GLint location, GLsizei count, const GLdouble *value);
    void glUniform3dv(GLint location, GLsizei count, const GLdouble *value);
    void glUniform2dv(GLint location, GLsizei count, const GLdouble *value);
    void glUniform1dv(GLint location, GLsizei count, const GLdouble *value);
    void glUniform4d(GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
    void glUniform3d(GLint location, GLdouble x, GLdouble y, GLdouble z);
    void glUniform2d(GLint location, GLdouble x, GLdouble y);
    void glUniform1d(GLint location, GLdouble x);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_gpu_shader_fp64)
};

inline void QOpenGLExtension_ARB_gpu_shader_fp64::glGetUniformdv(GLuint program, GLint location, GLdouble *params)
{
    Q_D(QOpenGLExtension_ARB_gpu_shader_fp64);
    d->GetUniformdv(program, location, params);
}

inline void QOpenGLExtension_ARB_gpu_shader_fp64::glUniformMatrix4x3dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
    Q_D(QOpenGLExtension_ARB_gpu_shader_fp64);
    d->UniformMatrix4x3dv(location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_gpu_shader_fp64::glUniformMatrix4x2dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
    Q_D(QOpenGLExtension_ARB_gpu_shader_fp64);
    d->UniformMatrix4x2dv(location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_gpu_shader_fp64::glUniformMatrix3x4dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
    Q_D(QOpenGLExtension_ARB_gpu_shader_fp64);
    d->UniformMatrix3x4dv(location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_gpu_shader_fp64::glUniformMatrix3x2dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
    Q_D(QOpenGLExtension_ARB_gpu_shader_fp64);
    d->UniformMatrix3x2dv(location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_gpu_shader_fp64::glUniformMatrix2x4dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
    Q_D(QOpenGLExtension_ARB_gpu_shader_fp64);
    d->UniformMatrix2x4dv(location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_gpu_shader_fp64::glUniformMatrix2x3dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
    Q_D(QOpenGLExtension_ARB_gpu_shader_fp64);
    d->UniformMatrix2x3dv(location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_gpu_shader_fp64::glUniformMatrix4dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
    Q_D(QOpenGLExtension_ARB_gpu_shader_fp64);
    d->UniformMatrix4dv(location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_gpu_shader_fp64::glUniformMatrix3dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
    Q_D(QOpenGLExtension_ARB_gpu_shader_fp64);
    d->UniformMatrix3dv(location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_gpu_shader_fp64::glUniformMatrix2dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
    Q_D(QOpenGLExtension_ARB_gpu_shader_fp64);
    d->UniformMatrix2dv(location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_gpu_shader_fp64::glUniform4dv(GLint location, GLsizei count, const GLdouble *value)
{
    Q_D(QOpenGLExtension_ARB_gpu_shader_fp64);
    d->Uniform4dv(location, count, value);
}

inline void QOpenGLExtension_ARB_gpu_shader_fp64::glUniform3dv(GLint location, GLsizei count, const GLdouble *value)
{
    Q_D(QOpenGLExtension_ARB_gpu_shader_fp64);
    d->Uniform3dv(location, count, value);
}

inline void QOpenGLExtension_ARB_gpu_shader_fp64::glUniform2dv(GLint location, GLsizei count, const GLdouble *value)
{
    Q_D(QOpenGLExtension_ARB_gpu_shader_fp64);
    d->Uniform2dv(location, count, value);
}

inline void QOpenGLExtension_ARB_gpu_shader_fp64::glUniform1dv(GLint location, GLsizei count, const GLdouble *value)
{
    Q_D(QOpenGLExtension_ARB_gpu_shader_fp64);
    d->Uniform1dv(location, count, value);
}

inline void QOpenGLExtension_ARB_gpu_shader_fp64::glUniform4d(GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    Q_D(QOpenGLExtension_ARB_gpu_shader_fp64);
    d->Uniform4d(location, x, y, z, w);
}

inline void QOpenGLExtension_ARB_gpu_shader_fp64::glUniform3d(GLint location, GLdouble x, GLdouble y, GLdouble z)
{
    Q_D(QOpenGLExtension_ARB_gpu_shader_fp64);
    d->Uniform3d(location, x, y, z);
}

inline void QOpenGLExtension_ARB_gpu_shader_fp64::glUniform2d(GLint location, GLdouble x, GLdouble y)
{
    Q_D(QOpenGLExtension_ARB_gpu_shader_fp64);
    d->Uniform2d(location, x, y);
}

inline void QOpenGLExtension_ARB_gpu_shader_fp64::glUniform1d(GLint location, GLdouble x)
{
    Q_D(QOpenGLExtension_ARB_gpu_shader_fp64);
    d->Uniform1d(location, x);
}

class QOpenGLExtension_ARB_instanced_arraysPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP VertexAttribDivisorARB)(GLuint index, GLuint divisor);
};

class QOpenGLExtension_ARB_instanced_arrays : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_instanced_arrays();

    bool initializeOpenGLFunctions() final;

    void glVertexAttribDivisorARB(GLuint index, GLuint divisor);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_instanced_arrays)
};

inline void QOpenGLExtension_ARB_instanced_arrays::glVertexAttribDivisorARB(GLuint index, GLuint divisor)
{
    Q_D(QOpenGLExtension_ARB_instanced_arrays);
    d->VertexAttribDivisorARB(index, divisor);
}

class QOpenGLExtension_ARB_internalformat_queryPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetInternalformativ)(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint *params);
};

class QOpenGLExtension_ARB_internalformat_query : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_internalformat_query();

    bool initializeOpenGLFunctions() final;

    void glGetInternalformativ(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint *params);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_internalformat_query)
};

inline void QOpenGLExtension_ARB_internalformat_query::glGetInternalformativ(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint *params)
{
    Q_D(QOpenGLExtension_ARB_internalformat_query);
    d->GetInternalformativ(target, internalformat, pname, bufSize, params);
}

class QOpenGLExtension_ARB_internalformat_query2Private : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetInternalformati64v)(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint64 *params);
};

class QOpenGLExtension_ARB_internalformat_query2 : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_internalformat_query2();

    bool initializeOpenGLFunctions() final;

    void glGetInternalformati64v(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint64 *params);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_internalformat_query2)
};

inline void QOpenGLExtension_ARB_internalformat_query2::glGetInternalformati64v(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint64 *params)
{
    Q_D(QOpenGLExtension_ARB_internalformat_query2);
    d->GetInternalformati64v(target, internalformat, pname, bufSize, params);
}

class QOpenGLExtension_ARB_invalidate_subdataPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP InvalidateSubFramebuffer)(GLenum target, GLsizei numAttachments, const GLenum *attachments, GLint x, GLint y, GLsizei width, GLsizei height);
    void (QOPENGLF_APIENTRYP InvalidateFramebuffer)(GLenum target, GLsizei numAttachments, const GLenum *attachments);
    void (QOPENGLF_APIENTRYP InvalidateBufferData)(GLuint buffer);
    void (QOPENGLF_APIENTRYP InvalidateBufferSubData)(GLuint buffer, GLintptr offset, GLsizeiptr length);
    void (QOPENGLF_APIENTRYP InvalidateTexImage)(GLuint texture, GLint level);
    void (QOPENGLF_APIENTRYP InvalidateTexSubImage)(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth);
};

class QOpenGLExtension_ARB_invalidate_subdata : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_invalidate_subdata();

    bool initializeOpenGLFunctions() final;

    void glInvalidateSubFramebuffer(GLenum target, GLsizei numAttachments, const GLenum *attachments, GLint x, GLint y, GLsizei width, GLsizei height);
    void glInvalidateFramebuffer(GLenum target, GLsizei numAttachments, const GLenum *attachments);
    void glInvalidateBufferData(GLuint buffer);
    void glInvalidateBufferSubData(GLuint buffer, GLintptr offset, GLsizeiptr length);
    void glInvalidateTexImage(GLuint texture, GLint level);
    void glInvalidateTexSubImage(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_invalidate_subdata)
};

inline void QOpenGLExtension_ARB_invalidate_subdata::glInvalidateSubFramebuffer(GLenum target, GLsizei numAttachments, const GLenum *attachments, GLint x, GLint y, GLsizei width, GLsizei height)
{
    Q_D(QOpenGLExtension_ARB_invalidate_subdata);
    d->InvalidateSubFramebuffer(target, numAttachments, attachments, x, y, width, height);
}

inline void QOpenGLExtension_ARB_invalidate_subdata::glInvalidateFramebuffer(GLenum target, GLsizei numAttachments, const GLenum *attachments)
{
    Q_D(QOpenGLExtension_ARB_invalidate_subdata);
    d->InvalidateFramebuffer(target, numAttachments, attachments);
}

inline void QOpenGLExtension_ARB_invalidate_subdata::glInvalidateBufferData(GLuint buffer)
{
    Q_D(QOpenGLExtension_ARB_invalidate_subdata);
    d->InvalidateBufferData(buffer);
}

inline void QOpenGLExtension_ARB_invalidate_subdata::glInvalidateBufferSubData(GLuint buffer, GLintptr offset, GLsizeiptr length)
{
    Q_D(QOpenGLExtension_ARB_invalidate_subdata);
    d->InvalidateBufferSubData(buffer, offset, length);
}

inline void QOpenGLExtension_ARB_invalidate_subdata::glInvalidateTexImage(GLuint texture, GLint level)
{
    Q_D(QOpenGLExtension_ARB_invalidate_subdata);
    d->InvalidateTexImage(texture, level);
}

inline void QOpenGLExtension_ARB_invalidate_subdata::glInvalidateTexSubImage(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth)
{
    Q_D(QOpenGLExtension_ARB_invalidate_subdata);
    d->InvalidateTexSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth);
}

class QOpenGLExtension_ARB_map_buffer_rangePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP FlushMappedBufferRange)(GLenum target, GLintptr offset, GLsizeiptr length);
    GLvoid* (QOPENGLF_APIENTRYP MapBufferRange)(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access);
};

class QOpenGLExtension_ARB_map_buffer_range : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_map_buffer_range();

    bool initializeOpenGLFunctions() final;

    void glFlushMappedBufferRange(GLenum target, GLintptr offset, GLsizeiptr length);
    GLvoid* glMapBufferRange(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_map_buffer_range)
};

inline void QOpenGLExtension_ARB_map_buffer_range::glFlushMappedBufferRange(GLenum target, GLintptr offset, GLsizeiptr length)
{
    Q_D(QOpenGLExtension_ARB_map_buffer_range);
    d->FlushMappedBufferRange(target, offset, length);
}

inline GLvoid* QOpenGLExtension_ARB_map_buffer_range::glMapBufferRange(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access)
{
    Q_D(QOpenGLExtension_ARB_map_buffer_range);
    return d->MapBufferRange(target, offset, length, access);
}

class QOpenGLExtension_ARB_matrix_palettePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP MatrixIndexPointerARB)(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
    void (QOPENGLF_APIENTRYP MatrixIndexuivARB)(GLint size, const GLuint *indices);
    void (QOPENGLF_APIENTRYP MatrixIndexusvARB)(GLint size, const GLushort *indices);
    void (QOPENGLF_APIENTRYP MatrixIndexubvARB)(GLint size, const GLubyte *indices);
    void (QOPENGLF_APIENTRYP CurrentPaletteMatrixARB)(GLint index);
};

class QOpenGLExtension_ARB_matrix_palette : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_matrix_palette();

    bool initializeOpenGLFunctions() final;

    void glMatrixIndexPointerARB(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
    void glMatrixIndexuivARB(GLint size, const GLuint *indices);
    void glMatrixIndexusvARB(GLint size, const GLushort *indices);
    void glMatrixIndexubvARB(GLint size, const GLubyte *indices);
    void glCurrentPaletteMatrixARB(GLint index);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_matrix_palette)
};

inline void QOpenGLExtension_ARB_matrix_palette::glMatrixIndexPointerARB(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
    Q_D(QOpenGLExtension_ARB_matrix_palette);
    d->MatrixIndexPointerARB(size, type, stride, pointer);
}

inline void QOpenGLExtension_ARB_matrix_palette::glMatrixIndexuivARB(GLint size, const GLuint *indices)
{
    Q_D(QOpenGLExtension_ARB_matrix_palette);
    d->MatrixIndexuivARB(size, indices);
}

inline void QOpenGLExtension_ARB_matrix_palette::glMatrixIndexusvARB(GLint size, const GLushort *indices)
{
    Q_D(QOpenGLExtension_ARB_matrix_palette);
    d->MatrixIndexusvARB(size, indices);
}

inline void QOpenGLExtension_ARB_matrix_palette::glMatrixIndexubvARB(GLint size, const GLubyte *indices)
{
    Q_D(QOpenGLExtension_ARB_matrix_palette);
    d->MatrixIndexubvARB(size, indices);
}

inline void QOpenGLExtension_ARB_matrix_palette::glCurrentPaletteMatrixARB(GLint index)
{
    Q_D(QOpenGLExtension_ARB_matrix_palette);
    d->CurrentPaletteMatrixARB(index);
}

class QOpenGLExtension_ARB_multi_draw_indirectPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP MultiDrawElementsIndirect)(GLenum mode, GLenum type, const void *indirect, GLsizei drawcount, GLsizei stride);
    void (QOPENGLF_APIENTRYP MultiDrawArraysIndirect)(GLenum mode, const void *indirect, GLsizei drawcount, GLsizei stride);
};

class QOpenGLExtension_ARB_multi_draw_indirect : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_multi_draw_indirect();

    bool initializeOpenGLFunctions() final;

    void glMultiDrawElementsIndirect(GLenum mode, GLenum type, const void *indirect, GLsizei drawcount, GLsizei stride);
    void glMultiDrawArraysIndirect(GLenum mode, const void *indirect, GLsizei drawcount, GLsizei stride);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_multi_draw_indirect)
};

inline void QOpenGLExtension_ARB_multi_draw_indirect::glMultiDrawElementsIndirect(GLenum mode, GLenum type, const void *indirect, GLsizei drawcount, GLsizei stride)
{
    Q_D(QOpenGLExtension_ARB_multi_draw_indirect);
    d->MultiDrawElementsIndirect(mode, type, indirect, drawcount, stride);
}

inline void QOpenGLExtension_ARB_multi_draw_indirect::glMultiDrawArraysIndirect(GLenum mode, const void *indirect, GLsizei drawcount, GLsizei stride)
{
    Q_D(QOpenGLExtension_ARB_multi_draw_indirect);
    d->MultiDrawArraysIndirect(mode, indirect, drawcount, stride);
}

class QOpenGLExtension_ARB_multisamplePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP SampleCoverageARB)(GLfloat value, GLboolean invert);
};

class QOpenGLExtension_ARB_multisample : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_multisample();

    bool initializeOpenGLFunctions() final;

    void glSampleCoverageARB(GLfloat value, GLboolean invert);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_multisample)
};

inline void QOpenGLExtension_ARB_multisample::glSampleCoverageARB(GLfloat value, GLboolean invert)
{
    Q_D(QOpenGLExtension_ARB_multisample);
    d->SampleCoverageARB(value, invert);
}

class QOpenGLExtension_ARB_multitexturePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP MultiTexCoord4svARB)(GLenum target, const GLshort *v);
    void (QOPENGLF_APIENTRYP MultiTexCoord4sARB)(GLenum target, GLshort s, GLshort t, GLshort r, GLshort q);
    void (QOPENGLF_APIENTRYP MultiTexCoord4ivARB)(GLenum target, const GLint *v);
    void (QOPENGLF_APIENTRYP MultiTexCoord4iARB)(GLenum target, GLint s, GLint t, GLint r, GLint q);
    void (QOPENGLF_APIENTRYP MultiTexCoord4fvARB)(GLenum target, const GLfloat *v);
    void (QOPENGLF_APIENTRYP MultiTexCoord4fARB)(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q);
    void (QOPENGLF_APIENTRYP MultiTexCoord4dvARB)(GLenum target, const GLdouble *v);
    void (QOPENGLF_APIENTRYP MultiTexCoord4dARB)(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q);
    void (QOPENGLF_APIENTRYP MultiTexCoord3svARB)(GLenum target, const GLshort *v);
    void (QOPENGLF_APIENTRYP MultiTexCoord3sARB)(GLenum target, GLshort s, GLshort t, GLshort r);
    void (QOPENGLF_APIENTRYP MultiTexCoord3ivARB)(GLenum target, const GLint *v);
    void (QOPENGLF_APIENTRYP MultiTexCoord3iARB)(GLenum target, GLint s, GLint t, GLint r);
    void (QOPENGLF_APIENTRYP MultiTexCoord3fvARB)(GLenum target, const GLfloat *v);
    void (QOPENGLF_APIENTRYP MultiTexCoord3fARB)(GLenum target, GLfloat s, GLfloat t, GLfloat r);
    void (QOPENGLF_APIENTRYP MultiTexCoord3dvARB)(GLenum target, const GLdouble *v);
    void (QOPENGLF_APIENTRYP MultiTexCoord3dARB)(GLenum target, GLdouble s, GLdouble t, GLdouble r);
    void (QOPENGLF_APIENTRYP MultiTexCoord2svARB)(GLenum target, const GLshort *v);
    void (QOPENGLF_APIENTRYP MultiTexCoord2sARB)(GLenum target, GLshort s, GLshort t);
    void (QOPENGLF_APIENTRYP MultiTexCoord2ivARB)(GLenum target, const GLint *v);
    void (QOPENGLF_APIENTRYP MultiTexCoord2iARB)(GLenum target, GLint s, GLint t);
    void (QOPENGLF_APIENTRYP MultiTexCoord2fvARB)(GLenum target, const GLfloat *v);
    void (QOPENGLF_APIENTRYP MultiTexCoord2fARB)(GLenum target, GLfloat s, GLfloat t);
    void (QOPENGLF_APIENTRYP MultiTexCoord2dvARB)(GLenum target, const GLdouble *v);
    void (QOPENGLF_APIENTRYP MultiTexCoord2dARB)(GLenum target, GLdouble s, GLdouble t);
    void (QOPENGLF_APIENTRYP MultiTexCoord1svARB)(GLenum target, const GLshort *v);
    void (QOPENGLF_APIENTRYP MultiTexCoord1sARB)(GLenum target, GLshort s);
    void (QOPENGLF_APIENTRYP MultiTexCoord1ivARB)(GLenum target, const GLint *v);
    void (QOPENGLF_APIENTRYP MultiTexCoord1iARB)(GLenum target, GLint s);
    void (QOPENGLF_APIENTRYP MultiTexCoord1fvARB)(GLenum target, const GLfloat *v);
    void (QOPENGLF_APIENTRYP MultiTexCoord1fARB)(GLenum target, GLfloat s);
    void (QOPENGLF_APIENTRYP MultiTexCoord1dvARB)(GLenum target, const GLdouble *v);
    void (QOPENGLF_APIENTRYP MultiTexCoord1dARB)(GLenum target, GLdouble s);
    void (QOPENGLF_APIENTRYP ClientActiveTextureARB)(GLenum texture);
    void (QOPENGLF_APIENTRYP ActiveTextureARB)(GLenum texture);
};

class QOpenGLExtension_ARB_multitexture : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_multitexture();

    bool initializeOpenGLFunctions() final;

    void glMultiTexCoord4svARB(GLenum target, const GLshort *v);
    void glMultiTexCoord4sARB(GLenum target, GLshort s, GLshort t, GLshort r, GLshort q);
    void glMultiTexCoord4ivARB(GLenum target, const GLint *v);
    void glMultiTexCoord4iARB(GLenum target, GLint s, GLint t, GLint r, GLint q);
    void glMultiTexCoord4fvARB(GLenum target, const GLfloat *v);
    void glMultiTexCoord4fARB(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q);
    void glMultiTexCoord4dvARB(GLenum target, const GLdouble *v);
    void glMultiTexCoord4dARB(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q);
    void glMultiTexCoord3svARB(GLenum target, const GLshort *v);
    void glMultiTexCoord3sARB(GLenum target, GLshort s, GLshort t, GLshort r);
    void glMultiTexCoord3ivARB(GLenum target, const GLint *v);
    void glMultiTexCoord3iARB(GLenum target, GLint s, GLint t, GLint r);
    void glMultiTexCoord3fvARB(GLenum target, const GLfloat *v);
    void glMultiTexCoord3fARB(GLenum target, GLfloat s, GLfloat t, GLfloat r);
    void glMultiTexCoord3dvARB(GLenum target, const GLdouble *v);
    void glMultiTexCoord3dARB(GLenum target, GLdouble s, GLdouble t, GLdouble r);
    void glMultiTexCoord2svARB(GLenum target, const GLshort *v);
    void glMultiTexCoord2sARB(GLenum target, GLshort s, GLshort t);
    void glMultiTexCoord2ivARB(GLenum target, const GLint *v);
    void glMultiTexCoord2iARB(GLenum target, GLint s, GLint t);
    void glMultiTexCoord2fvARB(GLenum target, const GLfloat *v);
    void glMultiTexCoord2fARB(GLenum target, GLfloat s, GLfloat t);
    void glMultiTexCoord2dvARB(GLenum target, const GLdouble *v);
    void glMultiTexCoord2dARB(GLenum target, GLdouble s, GLdouble t);
    void glMultiTexCoord1svARB(GLenum target, const GLshort *v);
    void glMultiTexCoord1sARB(GLenum target, GLshort s);
    void glMultiTexCoord1ivARB(GLenum target, const GLint *v);
    void glMultiTexCoord1iARB(GLenum target, GLint s);
    void glMultiTexCoord1fvARB(GLenum target, const GLfloat *v);
    void glMultiTexCoord1fARB(GLenum target, GLfloat s);
    void glMultiTexCoord1dvARB(GLenum target, const GLdouble *v);
    void glMultiTexCoord1dARB(GLenum target, GLdouble s);
    void glClientActiveTextureARB(GLenum texture);
    void glActiveTextureARB(GLenum texture);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_multitexture)
};

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord4svARB(GLenum target, const GLshort *v)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord4svARB(target, v);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord4sARB(GLenum target, GLshort s, GLshort t, GLshort r, GLshort q)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord4sARB(target, s, t, r, q);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord4ivARB(GLenum target, const GLint *v)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord4ivARB(target, v);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord4iARB(GLenum target, GLint s, GLint t, GLint r, GLint q)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord4iARB(target, s, t, r, q);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord4fvARB(GLenum target, const GLfloat *v)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord4fvARB(target, v);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord4fARB(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord4fARB(target, s, t, r, q);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord4dvARB(GLenum target, const GLdouble *v)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord4dvARB(target, v);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord4dARB(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord4dARB(target, s, t, r, q);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord3svARB(GLenum target, const GLshort *v)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord3svARB(target, v);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord3sARB(GLenum target, GLshort s, GLshort t, GLshort r)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord3sARB(target, s, t, r);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord3ivARB(GLenum target, const GLint *v)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord3ivARB(target, v);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord3iARB(GLenum target, GLint s, GLint t, GLint r)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord3iARB(target, s, t, r);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord3fvARB(GLenum target, const GLfloat *v)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord3fvARB(target, v);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord3fARB(GLenum target, GLfloat s, GLfloat t, GLfloat r)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord3fARB(target, s, t, r);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord3dvARB(GLenum target, const GLdouble *v)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord3dvARB(target, v);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord3dARB(GLenum target, GLdouble s, GLdouble t, GLdouble r)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord3dARB(target, s, t, r);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord2svARB(GLenum target, const GLshort *v)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord2svARB(target, v);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord2sARB(GLenum target, GLshort s, GLshort t)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord2sARB(target, s, t);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord2ivARB(GLenum target, const GLint *v)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord2ivARB(target, v);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord2iARB(GLenum target, GLint s, GLint t)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord2iARB(target, s, t);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord2fvARB(GLenum target, const GLfloat *v)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord2fvARB(target, v);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord2fARB(GLenum target, GLfloat s, GLfloat t)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord2fARB(target, s, t);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord2dvARB(GLenum target, const GLdouble *v)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord2dvARB(target, v);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord2dARB(GLenum target, GLdouble s, GLdouble t)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord2dARB(target, s, t);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord1svARB(GLenum target, const GLshort *v)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord1svARB(target, v);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord1sARB(GLenum target, GLshort s)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord1sARB(target, s);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord1ivARB(GLenum target, const GLint *v)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord1ivARB(target, v);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord1iARB(GLenum target, GLint s)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord1iARB(target, s);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord1fvARB(GLenum target, const GLfloat *v)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord1fvARB(target, v);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord1fARB(GLenum target, GLfloat s)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord1fARB(target, s);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord1dvARB(GLenum target, const GLdouble *v)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord1dvARB(target, v);
}

inline void QOpenGLExtension_ARB_multitexture::glMultiTexCoord1dARB(GLenum target, GLdouble s)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->MultiTexCoord1dARB(target, s);
}

inline void QOpenGLExtension_ARB_multitexture::glClientActiveTextureARB(GLenum texture)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->ClientActiveTextureARB(texture);
}

inline void QOpenGLExtension_ARB_multitexture::glActiveTextureARB(GLenum texture)
{
    Q_D(QOpenGLExtension_ARB_multitexture);
    d->ActiveTextureARB(texture);
}

class QOpenGLExtension_ARB_occlusion_queryPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetQueryObjectuivARB)(GLuint id, GLenum pname, GLuint *params);
    void (QOPENGLF_APIENTRYP GetQueryObjectivARB)(GLuint id, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetQueryivARB)(GLenum target, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP EndQueryARB)(GLenum target);
    void (QOPENGLF_APIENTRYP BeginQueryARB)(GLenum target, GLuint id);
    GLboolean (QOPENGLF_APIENTRYP IsQueryARB)(GLuint id);
    void (QOPENGLF_APIENTRYP DeleteQueriesARB)(GLsizei n, const GLuint *ids);
    void (QOPENGLF_APIENTRYP GenQueriesARB)(GLsizei n, GLuint *ids);
};

class QOpenGLExtension_ARB_occlusion_query : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_occlusion_query();

    bool initializeOpenGLFunctions() final;

    void glGetQueryObjectuivARB(GLuint id, GLenum pname, GLuint *params);
    void glGetQueryObjectivARB(GLuint id, GLenum pname, GLint *params);
    void glGetQueryivARB(GLenum target, GLenum pname, GLint *params);
    void glEndQueryARB(GLenum target);
    void glBeginQueryARB(GLenum target, GLuint id);
    GLboolean glIsQueryARB(GLuint id);
    void glDeleteQueriesARB(GLsizei n, const GLuint *ids);
    void glGenQueriesARB(GLsizei n, GLuint *ids);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_occlusion_query)
};

inline void QOpenGLExtension_ARB_occlusion_query::glGetQueryObjectuivARB(GLuint id, GLenum pname, GLuint *params)
{
    Q_D(QOpenGLExtension_ARB_occlusion_query);
    d->GetQueryObjectuivARB(id, pname, params);
}

inline void QOpenGLExtension_ARB_occlusion_query::glGetQueryObjectivARB(GLuint id, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_ARB_occlusion_query);
    d->GetQueryObjectivARB(id, pname, params);
}

inline void QOpenGLExtension_ARB_occlusion_query::glGetQueryivARB(GLenum target, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_ARB_occlusion_query);
    d->GetQueryivARB(target, pname, params);
}

inline void QOpenGLExtension_ARB_occlusion_query::glEndQueryARB(GLenum target)
{
    Q_D(QOpenGLExtension_ARB_occlusion_query);
    d->EndQueryARB(target);
}

inline void QOpenGLExtension_ARB_occlusion_query::glBeginQueryARB(GLenum target, GLuint id)
{
    Q_D(QOpenGLExtension_ARB_occlusion_query);
    d->BeginQueryARB(target, id);
}

inline GLboolean QOpenGLExtension_ARB_occlusion_query::glIsQueryARB(GLuint id)
{
    Q_D(QOpenGLExtension_ARB_occlusion_query);
    return d->IsQueryARB(id);
}

inline void QOpenGLExtension_ARB_occlusion_query::glDeleteQueriesARB(GLsizei n, const GLuint *ids)
{
    Q_D(QOpenGLExtension_ARB_occlusion_query);
    d->DeleteQueriesARB(n, ids);
}

inline void QOpenGLExtension_ARB_occlusion_query::glGenQueriesARB(GLsizei n, GLuint *ids)
{
    Q_D(QOpenGLExtension_ARB_occlusion_query);
    d->GenQueriesARB(n, ids);
}

class QOpenGLExtension_ARB_point_parametersPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP PointParameterfvARB)(GLenum pname, const GLfloat *params);
    void (QOPENGLF_APIENTRYP PointParameterfARB)(GLenum pname, GLfloat param);
};

class QOpenGLExtension_ARB_point_parameters : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_point_parameters();

    bool initializeOpenGLFunctions() final;

    void glPointParameterfvARB(GLenum pname, const GLfloat *params);
    void glPointParameterfARB(GLenum pname, GLfloat param);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_point_parameters)
};

inline void QOpenGLExtension_ARB_point_parameters::glPointParameterfvARB(GLenum pname, const GLfloat *params)
{
    Q_D(QOpenGLExtension_ARB_point_parameters);
    d->PointParameterfvARB(pname, params);
}

inline void QOpenGLExtension_ARB_point_parameters::glPointParameterfARB(GLenum pname, GLfloat param)
{
    Q_D(QOpenGLExtension_ARB_point_parameters);
    d->PointParameterfARB(pname, param);
}

class QOpenGLExtension_ARB_program_interface_queryPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    GLint (QOPENGLF_APIENTRYP GetProgramResourceLocationIndex)(GLuint program, GLenum programInterface, const GLchar *name);
    GLint (QOPENGLF_APIENTRYP GetProgramResourceLocation)(GLuint program, GLenum programInterface, const GLchar *name);
    void (QOPENGLF_APIENTRYP GetProgramResourceiv)(GLuint program, GLenum programInterface, GLuint index, GLsizei propCount, const GLenum *props, GLsizei bufSize, GLsizei *length, GLint *params);
    void (QOPENGLF_APIENTRYP GetProgramResourceName)(GLuint program, GLenum programInterface, GLuint index, GLsizei bufSize, GLsizei *length, GLchar *name);
    GLuint (QOPENGLF_APIENTRYP GetProgramResourceIndex)(GLuint program, GLenum programInterface, const GLchar *name);
    void (QOPENGLF_APIENTRYP GetProgramInterfaceiv)(GLuint program, GLenum programInterface, GLenum pname, GLint *params);
};

class QOpenGLExtension_ARB_program_interface_query : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_program_interface_query();

    bool initializeOpenGLFunctions() final;

    GLint glGetProgramResourceLocationIndex(GLuint program, GLenum programInterface, const GLchar *name);
    GLint glGetProgramResourceLocation(GLuint program, GLenum programInterface, const GLchar *name);
    void glGetProgramResourceiv(GLuint program, GLenum programInterface, GLuint index, GLsizei propCount, const GLenum *props, GLsizei bufSize, GLsizei *length, GLint *params);
    void glGetProgramResourceName(GLuint program, GLenum programInterface, GLuint index, GLsizei bufSize, GLsizei *length, GLchar *name);
    GLuint glGetProgramResourceIndex(GLuint program, GLenum programInterface, const GLchar *name);
    void glGetProgramInterfaceiv(GLuint program, GLenum programInterface, GLenum pname, GLint *params);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_program_interface_query)
};

inline GLint QOpenGLExtension_ARB_program_interface_query::glGetProgramResourceLocationIndex(GLuint program, GLenum programInterface, const GLchar *name)
{
    Q_D(QOpenGLExtension_ARB_program_interface_query);
    return d->GetProgramResourceLocationIndex(program, programInterface, name);
}

inline GLint QOpenGLExtension_ARB_program_interface_query::glGetProgramResourceLocation(GLuint program, GLenum programInterface, const GLchar *name)
{
    Q_D(QOpenGLExtension_ARB_program_interface_query);
    return d->GetProgramResourceLocation(program, programInterface, name);
}

inline void QOpenGLExtension_ARB_program_interface_query::glGetProgramResourceiv(GLuint program, GLenum programInterface, GLuint index, GLsizei propCount, const GLenum *props, GLsizei bufSize, GLsizei *length, GLint *params)
{
    Q_D(QOpenGLExtension_ARB_program_interface_query);
    d->GetProgramResourceiv(program, programInterface, index, propCount, props, bufSize, length, params);
}

inline void QOpenGLExtension_ARB_program_interface_query::glGetProgramResourceName(GLuint program, GLenum programInterface, GLuint index, GLsizei bufSize, GLsizei *length, GLchar *name)
{
    Q_D(QOpenGLExtension_ARB_program_interface_query);
    d->GetProgramResourceName(program, programInterface, index, bufSize, length, name);
}

inline GLuint QOpenGLExtension_ARB_program_interface_query::glGetProgramResourceIndex(GLuint program, GLenum programInterface, const GLchar *name)
{
    Q_D(QOpenGLExtension_ARB_program_interface_query);
    return d->GetProgramResourceIndex(program, programInterface, name);
}

inline void QOpenGLExtension_ARB_program_interface_query::glGetProgramInterfaceiv(GLuint program, GLenum programInterface, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_ARB_program_interface_query);
    d->GetProgramInterfaceiv(program, programInterface, pname, params);
}

class QOpenGLExtension_ARB_provoking_vertexPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP ProvokingVertex)(GLenum mode);
};

class QOpenGLExtension_ARB_provoking_vertex : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_provoking_vertex();

    bool initializeOpenGLFunctions() final;

    void glProvokingVertex(GLenum mode);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_provoking_vertex)
};

inline void QOpenGLExtension_ARB_provoking_vertex::glProvokingVertex(GLenum mode)
{
    Q_D(QOpenGLExtension_ARB_provoking_vertex);
    d->ProvokingVertex(mode);
}

class QOpenGLExtension_ARB_robustnessPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetnUniformdvARB)(GLuint program, GLint location, GLsizei bufSize, GLdouble *params);
    void (QOPENGLF_APIENTRYP GetnUniformuivARB)(GLuint program, GLint location, GLsizei bufSize, GLuint *params);
    void (QOPENGLF_APIENTRYP GetnUniformivARB)(GLuint program, GLint location, GLsizei bufSize, GLint *params);
    void (QOPENGLF_APIENTRYP GetnUniformfvARB)(GLuint program, GLint location, GLsizei bufSize, GLfloat *params);
    void (QOPENGLF_APIENTRYP GetnCompressedTexImageARB)(GLenum target, GLint lod, GLsizei bufSize, GLvoid *img);
    void (QOPENGLF_APIENTRYP ReadnPixelsARB)(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, GLvoid *data);
    void (QOPENGLF_APIENTRYP GetnTexImageARB)(GLenum target, GLint level, GLenum format, GLenum type, GLsizei bufSize, GLvoid *img);
    void (QOPENGLF_APIENTRYP GetnMinmaxARB)(GLenum target, GLboolean reset, GLenum format, GLenum type, GLsizei bufSize, GLvoid *values);
    void (QOPENGLF_APIENTRYP GetnHistogramARB)(GLenum target, GLboolean reset, GLenum format, GLenum type, GLsizei bufSize, GLvoid *values);
    void (QOPENGLF_APIENTRYP GetnSeparableFilterARB)(GLenum target, GLenum format, GLenum type, GLsizei rowBufSize, GLvoid *row, GLsizei columnBufSize, GLvoid *column, GLvoid *span);
    void (QOPENGLF_APIENTRYP GetnConvolutionFilterARB)(GLenum target, GLenum format, GLenum type, GLsizei bufSize, GLvoid *image);
    void (QOPENGLF_APIENTRYP GetnColorTableARB)(GLenum target, GLenum format, GLenum type, GLsizei bufSize, GLvoid *table);
    void (QOPENGLF_APIENTRYP GetnPolygonStippleARB)(GLsizei bufSize, GLubyte *pattern);
    void (QOPENGLF_APIENTRYP GetnPixelMapusvARB)(GLenum map, GLsizei bufSize, GLushort *values);
    void (QOPENGLF_APIENTRYP GetnPixelMapuivARB)(GLenum map, GLsizei bufSize, GLuint *values);
    void (QOPENGLF_APIENTRYP GetnPixelMapfvARB)(GLenum map, GLsizei bufSize, GLfloat *values);
    void (QOPENGLF_APIENTRYP GetnMapivARB)(GLenum target, GLenum query, GLsizei bufSize, GLint *v);
    void (QOPENGLF_APIENTRYP GetnMapfvARB)(GLenum target, GLenum query, GLsizei bufSize, GLfloat *v);
    void (QOPENGLF_APIENTRYP GetnMapdvARB)(GLenum target, GLenum query, GLsizei bufSize, GLdouble *v);
    GLenum (QOPENGLF_APIENTRYP GetGraphicsResetStatusARB)();
};

class QOpenGLExtension_ARB_robustness : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_robustness();

    bool initializeOpenGLFunctions() final;

    void glGetnUniformdvARB(GLuint program, GLint location, GLsizei bufSize, GLdouble *params);
    void glGetnUniformuivARB(GLuint program, GLint location, GLsizei bufSize, GLuint *params);
    void glGetnUniformivARB(GLuint program, GLint location, GLsizei bufSize, GLint *params);
    void glGetnUniformfvARB(GLuint program, GLint location, GLsizei bufSize, GLfloat *params);
    void glGetnCompressedTexImageARB(GLenum target, GLint lod, GLsizei bufSize, GLvoid *img);
    void glReadnPixelsARB(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, GLvoid *data);
    void glGetnTexImageARB(GLenum target, GLint level, GLenum format, GLenum type, GLsizei bufSize, GLvoid *img);
    void glGetnMinmaxARB(GLenum target, GLboolean reset, GLenum format, GLenum type, GLsizei bufSize, GLvoid *values);
    void glGetnHistogramARB(GLenum target, GLboolean reset, GLenum format, GLenum type, GLsizei bufSize, GLvoid *values);
    void glGetnSeparableFilterARB(GLenum target, GLenum format, GLenum type, GLsizei rowBufSize, GLvoid *row, GLsizei columnBufSize, GLvoid *column, GLvoid *span);
    void glGetnConvolutionFilterARB(GLenum target, GLenum format, GLenum type, GLsizei bufSize, GLvoid *image);
    void glGetnColorTableARB(GLenum target, GLenum format, GLenum type, GLsizei bufSize, GLvoid *table);
    void glGetnPolygonStippleARB(GLsizei bufSize, GLubyte *pattern);
    void glGetnPixelMapusvARB(GLenum map, GLsizei bufSize, GLushort *values);
    void glGetnPixelMapuivARB(GLenum map, GLsizei bufSize, GLuint *values);
    void glGetnPixelMapfvARB(GLenum map, GLsizei bufSize, GLfloat *values);
    void glGetnMapivARB(GLenum target, GLenum query, GLsizei bufSize, GLint *v);
    void glGetnMapfvARB(GLenum target, GLenum query, GLsizei bufSize, GLfloat *v);
    void glGetnMapdvARB(GLenum target, GLenum query, GLsizei bufSize, GLdouble *v);
    GLenum glGetGraphicsResetStatusARB();

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_robustness)
};

inline void QOpenGLExtension_ARB_robustness::glGetnUniformdvARB(GLuint program, GLint location, GLsizei bufSize, GLdouble *params)
{
    Q_D(QOpenGLExtension_ARB_robustness);
    d->GetnUniformdvARB(program, location, bufSize, params);
}

inline void QOpenGLExtension_ARB_robustness::glGetnUniformuivARB(GLuint program, GLint location, GLsizei bufSize, GLuint *params)
{
    Q_D(QOpenGLExtension_ARB_robustness);
    d->GetnUniformuivARB(program, location, bufSize, params);
}

inline void QOpenGLExtension_ARB_robustness::glGetnUniformivARB(GLuint program, GLint location, GLsizei bufSize, GLint *params)
{
    Q_D(QOpenGLExtension_ARB_robustness);
    d->GetnUniformivARB(program, location, bufSize, params);
}

inline void QOpenGLExtension_ARB_robustness::glGetnUniformfvARB(GLuint program, GLint location, GLsizei bufSize, GLfloat *params)
{
    Q_D(QOpenGLExtension_ARB_robustness);
    d->GetnUniformfvARB(program, location, bufSize, params);
}

inline void QOpenGLExtension_ARB_robustness::glGetnCompressedTexImageARB(GLenum target, GLint lod, GLsizei bufSize, GLvoid *img)
{
    Q_D(QOpenGLExtension_ARB_robustness);
    d->GetnCompressedTexImageARB(target, lod, bufSize, img);
}

inline void QOpenGLExtension_ARB_robustness::glReadnPixelsARB(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, GLvoid *data)
{
    Q_D(QOpenGLExtension_ARB_robustness);
    d->ReadnPixelsARB(x, y, width, height, format, type, bufSize, data);
}

inline void QOpenGLExtension_ARB_robustness::glGetnTexImageARB(GLenum target, GLint level, GLenum format, GLenum type, GLsizei bufSize, GLvoid *img)
{
    Q_D(QOpenGLExtension_ARB_robustness);
    d->GetnTexImageARB(target, level, format, type, bufSize, img);
}

inline void QOpenGLExtension_ARB_robustness::glGetnMinmaxARB(GLenum target, GLboolean reset, GLenum format, GLenum type, GLsizei bufSize, GLvoid *values)
{
    Q_D(QOpenGLExtension_ARB_robustness);
    d->GetnMinmaxARB(target, reset, format, type, bufSize, values);
}

inline void QOpenGLExtension_ARB_robustness::glGetnHistogramARB(GLenum target, GLboolean reset, GLenum format, GLenum type, GLsizei bufSize, GLvoid *values)
{
    Q_D(QOpenGLExtension_ARB_robustness);
    d->GetnHistogramARB(target, reset, format, type, bufSize, values);
}

inline void QOpenGLExtension_ARB_robustness::glGetnSeparableFilterARB(GLenum target, GLenum format, GLenum type, GLsizei rowBufSize, GLvoid *row, GLsizei columnBufSize, GLvoid *column, GLvoid *span)
{
    Q_D(QOpenGLExtension_ARB_robustness);
    d->GetnSeparableFilterARB(target, format, type, rowBufSize, row, columnBufSize, column, span);
}

inline void QOpenGLExtension_ARB_robustness::glGetnConvolutionFilterARB(GLenum target, GLenum format, GLenum type, GLsizei bufSize, GLvoid *image)
{
    Q_D(QOpenGLExtension_ARB_robustness);
    d->GetnConvolutionFilterARB(target, format, type, bufSize, image);
}

inline void QOpenGLExtension_ARB_robustness::glGetnColorTableARB(GLenum target, GLenum format, GLenum type, GLsizei bufSize, GLvoid *table)
{
    Q_D(QOpenGLExtension_ARB_robustness);
    d->GetnColorTableARB(target, format, type, bufSize, table);
}

inline void QOpenGLExtension_ARB_robustness::glGetnPolygonStippleARB(GLsizei bufSize, GLubyte *pattern)
{
    Q_D(QOpenGLExtension_ARB_robustness);
    d->GetnPolygonStippleARB(bufSize, pattern);
}

inline void QOpenGLExtension_ARB_robustness::glGetnPixelMapusvARB(GLenum map, GLsizei bufSize, GLushort *values)
{
    Q_D(QOpenGLExtension_ARB_robustness);
    d->GetnPixelMapusvARB(map, bufSize, values);
}

inline void QOpenGLExtension_ARB_robustness::glGetnPixelMapuivARB(GLenum map, GLsizei bufSize, GLuint *values)
{
    Q_D(QOpenGLExtension_ARB_robustness);
    d->GetnPixelMapuivARB(map, bufSize, values);
}

inline void QOpenGLExtension_ARB_robustness::glGetnPixelMapfvARB(GLenum map, GLsizei bufSize, GLfloat *values)
{
    Q_D(QOpenGLExtension_ARB_robustness);
    d->GetnPixelMapfvARB(map, bufSize, values);
}

inline void QOpenGLExtension_ARB_robustness::glGetnMapivARB(GLenum target, GLenum query, GLsizei bufSize, GLint *v)
{
    Q_D(QOpenGLExtension_ARB_robustness);
    d->GetnMapivARB(target, query, bufSize, v);
}

inline void QOpenGLExtension_ARB_robustness::glGetnMapfvARB(GLenum target, GLenum query, GLsizei bufSize, GLfloat *v)
{
    Q_D(QOpenGLExtension_ARB_robustness);
    d->GetnMapfvARB(target, query, bufSize, v);
}

inline void QOpenGLExtension_ARB_robustness::glGetnMapdvARB(GLenum target, GLenum query, GLsizei bufSize, GLdouble *v)
{
    Q_D(QOpenGLExtension_ARB_robustness);
    d->GetnMapdvARB(target, query, bufSize, v);
}

inline GLenum QOpenGLExtension_ARB_robustness::glGetGraphicsResetStatusARB()
{
    Q_D(QOpenGLExtension_ARB_robustness);
    return d->GetGraphicsResetStatusARB();
}

class QOpenGLExtension_ARB_sample_shadingPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP MinSampleShadingARB)(GLfloat value);
};

class QOpenGLExtension_ARB_sample_shading : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_sample_shading();

    bool initializeOpenGLFunctions() final;

    void glMinSampleShadingARB(GLfloat value);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_sample_shading)
};

inline void QOpenGLExtension_ARB_sample_shading::glMinSampleShadingARB(GLfloat value)
{
    Q_D(QOpenGLExtension_ARB_sample_shading);
    d->MinSampleShadingARB(value);
}

class QOpenGLExtension_ARB_sampler_objectsPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetSamplerParameterIuiv)(GLuint sampler, GLenum pname, GLuint *params);
    void (QOPENGLF_APIENTRYP GetSamplerParameterfv)(GLuint sampler, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP GetSamplerParameterIiv)(GLuint sampler, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetSamplerParameteriv)(GLuint sampler, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP SamplerParameterIuiv)(GLuint sampler, GLenum pname, const GLuint *param);
    void (QOPENGLF_APIENTRYP SamplerParameterIiv)(GLuint sampler, GLenum pname, const GLint *param);
    void (QOPENGLF_APIENTRYP SamplerParameterfv)(GLuint sampler, GLenum pname, const GLfloat *param);
    void (QOPENGLF_APIENTRYP SamplerParameterf)(GLuint sampler, GLenum pname, GLfloat param);
    void (QOPENGLF_APIENTRYP SamplerParameteriv)(GLuint sampler, GLenum pname, const GLint *param);
    void (QOPENGLF_APIENTRYP SamplerParameteri)(GLuint sampler, GLenum pname, GLint param);
    void (QOPENGLF_APIENTRYP BindSampler)(GLuint unit, GLuint sampler);
    GLboolean (QOPENGLF_APIENTRYP IsSampler)(GLuint sampler);
    void (QOPENGLF_APIENTRYP DeleteSamplers)(GLsizei count, const GLuint *samplers);
    void (QOPENGLF_APIENTRYP GenSamplers)(GLsizei count, GLuint *samplers);
};

class QOpenGLExtension_ARB_sampler_objects : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_sampler_objects();

    bool initializeOpenGLFunctions() final;

    void glGetSamplerParameterIuiv(GLuint sampler, GLenum pname, GLuint *params);
    void glGetSamplerParameterfv(GLuint sampler, GLenum pname, GLfloat *params);
    void glGetSamplerParameterIiv(GLuint sampler, GLenum pname, GLint *params);
    void glGetSamplerParameteriv(GLuint sampler, GLenum pname, GLint *params);
    void glSamplerParameterIuiv(GLuint sampler, GLenum pname, const GLuint *param);
    void glSamplerParameterIiv(GLuint sampler, GLenum pname, const GLint *param);
    void glSamplerParameterfv(GLuint sampler, GLenum pname, const GLfloat *param);
    void glSamplerParameterf(GLuint sampler, GLenum pname, GLfloat param);
    void glSamplerParameteriv(GLuint sampler, GLenum pname, const GLint *param);
    void glSamplerParameteri(GLuint sampler, GLenum pname, GLint param);
    void glBindSampler(GLuint unit, GLuint sampler);
    GLboolean glIsSampler(GLuint sampler);
    void glDeleteSamplers(GLsizei count, const GLuint *samplers);
    void glGenSamplers(GLsizei count, GLuint *samplers);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_sampler_objects)
};

inline void QOpenGLExtension_ARB_sampler_objects::glGetSamplerParameterIuiv(GLuint sampler, GLenum pname, GLuint *params)
{
    Q_D(QOpenGLExtension_ARB_sampler_objects);
    d->GetSamplerParameterIuiv(sampler, pname, params);
}

inline void QOpenGLExtension_ARB_sampler_objects::glGetSamplerParameterfv(GLuint sampler, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_ARB_sampler_objects);
    d->GetSamplerParameterfv(sampler, pname, params);
}

inline void QOpenGLExtension_ARB_sampler_objects::glGetSamplerParameterIiv(GLuint sampler, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_ARB_sampler_objects);
    d->GetSamplerParameterIiv(sampler, pname, params);
}

inline void QOpenGLExtension_ARB_sampler_objects::glGetSamplerParameteriv(GLuint sampler, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_ARB_sampler_objects);
    d->GetSamplerParameteriv(sampler, pname, params);
}

inline void QOpenGLExtension_ARB_sampler_objects::glSamplerParameterIuiv(GLuint sampler, GLenum pname, const GLuint *param)
{
    Q_D(QOpenGLExtension_ARB_sampler_objects);
    d->SamplerParameterIuiv(sampler, pname, param);
}

inline void QOpenGLExtension_ARB_sampler_objects::glSamplerParameterIiv(GLuint sampler, GLenum pname, const GLint *param)
{
    Q_D(QOpenGLExtension_ARB_sampler_objects);
    d->SamplerParameterIiv(sampler, pname, param);
}

inline void QOpenGLExtension_ARB_sampler_objects::glSamplerParameterfv(GLuint sampler, GLenum pname, const GLfloat *param)
{
    Q_D(QOpenGLExtension_ARB_sampler_objects);
    d->SamplerParameterfv(sampler, pname, param);
}

inline void QOpenGLExtension_ARB_sampler_objects::glSamplerParameterf(GLuint sampler, GLenum pname, GLfloat param)
{
    Q_D(QOpenGLExtension_ARB_sampler_objects);
    d->SamplerParameterf(sampler, pname, param);
}

inline void QOpenGLExtension_ARB_sampler_objects::glSamplerParameteriv(GLuint sampler, GLenum pname, const GLint *param)
{
    Q_D(QOpenGLExtension_ARB_sampler_objects);
    d->SamplerParameteriv(sampler, pname, param);
}

inline void QOpenGLExtension_ARB_sampler_objects::glSamplerParameteri(GLuint sampler, GLenum pname, GLint param)
{
    Q_D(QOpenGLExtension_ARB_sampler_objects);
    d->SamplerParameteri(sampler, pname, param);
}

inline void QOpenGLExtension_ARB_sampler_objects::glBindSampler(GLuint unit, GLuint sampler)
{
    Q_D(QOpenGLExtension_ARB_sampler_objects);
    d->BindSampler(unit, sampler);
}

inline GLboolean QOpenGLExtension_ARB_sampler_objects::glIsSampler(GLuint sampler)
{
    Q_D(QOpenGLExtension_ARB_sampler_objects);
    return d->IsSampler(sampler);
}

inline void QOpenGLExtension_ARB_sampler_objects::glDeleteSamplers(GLsizei count, const GLuint *samplers)
{
    Q_D(QOpenGLExtension_ARB_sampler_objects);
    d->DeleteSamplers(count, samplers);
}

inline void QOpenGLExtension_ARB_sampler_objects::glGenSamplers(GLsizei count, GLuint *samplers)
{
    Q_D(QOpenGLExtension_ARB_sampler_objects);
    d->GenSamplers(count, samplers);
}

class QOpenGLExtension_ARB_separate_shader_objectsPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetProgramPipelineInfoLog)(GLuint pipeline, GLsizei bufSize, GLsizei *length, GLchar *infoLog);
    void (QOPENGLF_APIENTRYP ValidateProgramPipeline)(GLuint pipeline);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix4x3dv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix3x4dv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix4x2dv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix2x4dv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix3x2dv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix2x3dv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix4x3fv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix3x4fv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix4x2fv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix2x4fv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix3x2fv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix2x3fv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix4dv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix3dv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix2dv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix4fv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix3fv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix2fv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniform4uiv)(GLuint program, GLint location, GLsizei count, const GLuint *value);
    void (QOPENGLF_APIENTRYP ProgramUniform4ui)(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3);
    void (QOPENGLF_APIENTRYP ProgramUniform4dv)(GLuint program, GLint location, GLsizei count, const GLdouble *value);
    void (QOPENGLF_APIENTRYP ProgramUniform4d)(GLuint program, GLint location, GLdouble v0, GLdouble v1, GLdouble v2, GLdouble v3);
    void (QOPENGLF_APIENTRYP ProgramUniform4fv)(GLuint program, GLint location, GLsizei count, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniform4f)(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3);
    void (QOPENGLF_APIENTRYP ProgramUniform4iv)(GLuint program, GLint location, GLsizei count, const GLint *value);
    void (QOPENGLF_APIENTRYP ProgramUniform4i)(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3);
    void (QOPENGLF_APIENTRYP ProgramUniform3uiv)(GLuint program, GLint location, GLsizei count, const GLuint *value);
    void (QOPENGLF_APIENTRYP ProgramUniform3ui)(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2);
    void (QOPENGLF_APIENTRYP ProgramUniform3dv)(GLuint program, GLint location, GLsizei count, const GLdouble *value);
    void (QOPENGLF_APIENTRYP ProgramUniform3d)(GLuint program, GLint location, GLdouble v0, GLdouble v1, GLdouble v2);
    void (QOPENGLF_APIENTRYP ProgramUniform3fv)(GLuint program, GLint location, GLsizei count, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniform3f)(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2);
    void (QOPENGLF_APIENTRYP ProgramUniform3iv)(GLuint program, GLint location, GLsizei count, const GLint *value);
    void (QOPENGLF_APIENTRYP ProgramUniform3i)(GLuint program, GLint location, GLint v0, GLint v1, GLint v2);
    void (QOPENGLF_APIENTRYP ProgramUniform2uiv)(GLuint program, GLint location, GLsizei count, const GLuint *value);
    void (QOPENGLF_APIENTRYP ProgramUniform2ui)(GLuint program, GLint location, GLuint v0, GLuint v1);
    void (QOPENGLF_APIENTRYP ProgramUniform2dv)(GLuint program, GLint location, GLsizei count, const GLdouble *value);
    void (QOPENGLF_APIENTRYP ProgramUniform2d)(GLuint program, GLint location, GLdouble v0, GLdouble v1);
    void (QOPENGLF_APIENTRYP ProgramUniform2fv)(GLuint program, GLint location, GLsizei count, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniform2f)(GLuint program, GLint location, GLfloat v0, GLfloat v1);
    void (QOPENGLF_APIENTRYP ProgramUniform2iv)(GLuint program, GLint location, GLsizei count, const GLint *value);
    void (QOPENGLF_APIENTRYP ProgramUniform2i)(GLuint program, GLint location, GLint v0, GLint v1);
    void (QOPENGLF_APIENTRYP ProgramUniform1uiv)(GLuint program, GLint location, GLsizei count, const GLuint *value);
    void (QOPENGLF_APIENTRYP ProgramUniform1ui)(GLuint program, GLint location, GLuint v0);
    void (QOPENGLF_APIENTRYP ProgramUniform1dv)(GLuint program, GLint location, GLsizei count, const GLdouble *value);
    void (QOPENGLF_APIENTRYP ProgramUniform1d)(GLuint program, GLint location, GLdouble v0);
    void (QOPENGLF_APIENTRYP ProgramUniform1fv)(GLuint program, GLint location, GLsizei count, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniform1f)(GLuint program, GLint location, GLfloat v0);
    void (QOPENGLF_APIENTRYP ProgramUniform1iv)(GLuint program, GLint location, GLsizei count, const GLint *value);
    void (QOPENGLF_APIENTRYP ProgramUniform1i)(GLuint program, GLint location, GLint v0);
    void (QOPENGLF_APIENTRYP GetProgramPipelineiv)(GLuint pipeline, GLenum pname, GLint *params);
    GLboolean (QOPENGLF_APIENTRYP IsProgramPipeline)(GLuint pipeline);
    void (QOPENGLF_APIENTRYP GenProgramPipelines)(GLsizei n, GLuint *pipelines);
    void (QOPENGLF_APIENTRYP DeleteProgramPipelines)(GLsizei n, const GLuint *pipelines);
    void (QOPENGLF_APIENTRYP BindProgramPipeline)(GLuint pipeline);
    GLuint (QOPENGLF_APIENTRYP CreateShaderProgramv)(GLenum type, GLsizei count, const GLchar* const *strings);
    void (QOPENGLF_APIENTRYP ActiveShaderProgram)(GLuint pipeline, GLuint program);
    void (QOPENGLF_APIENTRYP UseProgramStages)(GLuint pipeline, GLbitfield stages, GLuint program);
};

class QOpenGLExtension_ARB_separate_shader_objects : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_separate_shader_objects();

    bool initializeOpenGLFunctions() final;

    void glGetProgramPipelineInfoLog(GLuint pipeline, GLsizei bufSize, GLsizei *length, GLchar *infoLog);
    void glValidateProgramPipeline(GLuint pipeline);
    void glProgramUniformMatrix4x3dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void glProgramUniformMatrix3x4dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void glProgramUniformMatrix4x2dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void glProgramUniformMatrix2x4dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void glProgramUniformMatrix3x2dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void glProgramUniformMatrix2x3dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void glProgramUniformMatrix4x3fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glProgramUniformMatrix3x4fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glProgramUniformMatrix4x2fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glProgramUniformMatrix2x4fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glProgramUniformMatrix3x2fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glProgramUniformMatrix2x3fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glProgramUniformMatrix4dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void glProgramUniformMatrix3dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void glProgramUniformMatrix2dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void glProgramUniformMatrix4fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glProgramUniformMatrix3fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glProgramUniformMatrix2fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glProgramUniform4uiv(GLuint program, GLint location, GLsizei count, const GLuint *value);
    void glProgramUniform4ui(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3);
    void glProgramUniform4dv(GLuint program, GLint location, GLsizei count, const GLdouble *value);
    void glProgramUniform4d(GLuint program, GLint location, GLdouble v0, GLdouble v1, GLdouble v2, GLdouble v3);
    void glProgramUniform4fv(GLuint program, GLint location, GLsizei count, const GLfloat *value);
    void glProgramUniform4f(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3);
    void glProgramUniform4iv(GLuint program, GLint location, GLsizei count, const GLint *value);
    void glProgramUniform4i(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3);
    void glProgramUniform3uiv(GLuint program, GLint location, GLsizei count, const GLuint *value);
    void glProgramUniform3ui(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2);
    void glProgramUniform3dv(GLuint program, GLint location, GLsizei count, const GLdouble *value);
    void glProgramUniform3d(GLuint program, GLint location, GLdouble v0, GLdouble v1, GLdouble v2);
    void glProgramUniform3fv(GLuint program, GLint location, GLsizei count, const GLfloat *value);
    void glProgramUniform3f(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2);
    void glProgramUniform3iv(GLuint program, GLint location, GLsizei count, const GLint *value);
    void glProgramUniform3i(GLuint program, GLint location, GLint v0, GLint v1, GLint v2);
    void glProgramUniform2uiv(GLuint program, GLint location, GLsizei count, const GLuint *value);
    void glProgramUniform2ui(GLuint program, GLint location, GLuint v0, GLuint v1);
    void glProgramUniform2dv(GLuint program, GLint location, GLsizei count, const GLdouble *value);
    void glProgramUniform2d(GLuint program, GLint location, GLdouble v0, GLdouble v1);
    void glProgramUniform2fv(GLuint program, GLint location, GLsizei count, const GLfloat *value);
    void glProgramUniform2f(GLuint program, GLint location, GLfloat v0, GLfloat v1);
    void glProgramUniform2iv(GLuint program, GLint location, GLsizei count, const GLint *value);
    void glProgramUniform2i(GLuint program, GLint location, GLint v0, GLint v1);
    void glProgramUniform1uiv(GLuint program, GLint location, GLsizei count, const GLuint *value);
    void glProgramUniform1ui(GLuint program, GLint location, GLuint v0);
    void glProgramUniform1dv(GLuint program, GLint location, GLsizei count, const GLdouble *value);
    void glProgramUniform1d(GLuint program, GLint location, GLdouble v0);
    void glProgramUniform1fv(GLuint program, GLint location, GLsizei count, const GLfloat *value);
    void glProgramUniform1f(GLuint program, GLint location, GLfloat v0);
    void glProgramUniform1iv(GLuint program, GLint location, GLsizei count, const GLint *value);
    void glProgramUniform1i(GLuint program, GLint location, GLint v0);
    void glGetProgramPipelineiv(GLuint pipeline, GLenum pname, GLint *params);
    GLboolean glIsProgramPipeline(GLuint pipeline);
    void glGenProgramPipelines(GLsizei n, GLuint *pipelines);
    void glDeleteProgramPipelines(GLsizei n, const GLuint *pipelines);
    void glBindProgramPipeline(GLuint pipeline);
    GLuint glCreateShaderProgramv(GLenum type, GLsizei count, const GLchar* const *strings);
    void glActiveShaderProgram(GLuint pipeline, GLuint program);
    void glUseProgramStages(GLuint pipeline, GLbitfield stages, GLuint program);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_separate_shader_objects)
};

inline void QOpenGLExtension_ARB_separate_shader_objects::glGetProgramPipelineInfoLog(GLuint pipeline, GLsizei bufSize, GLsizei *length, GLchar *infoLog)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->GetProgramPipelineInfoLog(pipeline, bufSize, length, infoLog);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glValidateProgramPipeline(GLuint pipeline)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ValidateProgramPipeline(pipeline);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniformMatrix4x3dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniformMatrix4x3dv(program, location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniformMatrix3x4dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniformMatrix3x4dv(program, location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniformMatrix4x2dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniformMatrix4x2dv(program, location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniformMatrix2x4dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniformMatrix2x4dv(program, location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniformMatrix3x2dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniformMatrix3x2dv(program, location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniformMatrix2x3dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniformMatrix2x3dv(program, location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniformMatrix4x3fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniformMatrix4x3fv(program, location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniformMatrix3x4fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniformMatrix3x4fv(program, location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniformMatrix4x2fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniformMatrix4x2fv(program, location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniformMatrix2x4fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniformMatrix2x4fv(program, location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniformMatrix3x2fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniformMatrix3x2fv(program, location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniformMatrix2x3fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniformMatrix2x3fv(program, location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniformMatrix4dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniformMatrix4dv(program, location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniformMatrix3dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniformMatrix3dv(program, location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniformMatrix2dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniformMatrix2dv(program, location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniformMatrix4fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniformMatrix4fv(program, location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniformMatrix3fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniformMatrix3fv(program, location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniformMatrix2fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniformMatrix2fv(program, location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform4uiv(GLuint program, GLint location, GLsizei count, const GLuint *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform4uiv(program, location, count, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform4ui(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform4ui(program, location, v0, v1, v2, v3);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform4dv(GLuint program, GLint location, GLsizei count, const GLdouble *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform4dv(program, location, count, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform4d(GLuint program, GLint location, GLdouble v0, GLdouble v1, GLdouble v2, GLdouble v3)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform4d(program, location, v0, v1, v2, v3);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform4fv(GLuint program, GLint location, GLsizei count, const GLfloat *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform4fv(program, location, count, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform4f(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform4f(program, location, v0, v1, v2, v3);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform4iv(GLuint program, GLint location, GLsizei count, const GLint *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform4iv(program, location, count, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform4i(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform4i(program, location, v0, v1, v2, v3);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform3uiv(GLuint program, GLint location, GLsizei count, const GLuint *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform3uiv(program, location, count, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform3ui(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform3ui(program, location, v0, v1, v2);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform3dv(GLuint program, GLint location, GLsizei count, const GLdouble *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform3dv(program, location, count, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform3d(GLuint program, GLint location, GLdouble v0, GLdouble v1, GLdouble v2)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform3d(program, location, v0, v1, v2);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform3fv(GLuint program, GLint location, GLsizei count, const GLfloat *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform3fv(program, location, count, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform3f(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform3f(program, location, v0, v1, v2);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform3iv(GLuint program, GLint location, GLsizei count, const GLint *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform3iv(program, location, count, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform3i(GLuint program, GLint location, GLint v0, GLint v1, GLint v2)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform3i(program, location, v0, v1, v2);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform2uiv(GLuint program, GLint location, GLsizei count, const GLuint *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform2uiv(program, location, count, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform2ui(GLuint program, GLint location, GLuint v0, GLuint v1)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform2ui(program, location, v0, v1);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform2dv(GLuint program, GLint location, GLsizei count, const GLdouble *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform2dv(program, location, count, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform2d(GLuint program, GLint location, GLdouble v0, GLdouble v1)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform2d(program, location, v0, v1);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform2fv(GLuint program, GLint location, GLsizei count, const GLfloat *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform2fv(program, location, count, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform2f(GLuint program, GLint location, GLfloat v0, GLfloat v1)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform2f(program, location, v0, v1);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform2iv(GLuint program, GLint location, GLsizei count, const GLint *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform2iv(program, location, count, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform2i(GLuint program, GLint location, GLint v0, GLint v1)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform2i(program, location, v0, v1);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform1uiv(GLuint program, GLint location, GLsizei count, const GLuint *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform1uiv(program, location, count, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform1ui(GLuint program, GLint location, GLuint v0)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform1ui(program, location, v0);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform1dv(GLuint program, GLint location, GLsizei count, const GLdouble *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform1dv(program, location, count, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform1d(GLuint program, GLint location, GLdouble v0)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform1d(program, location, v0);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform1fv(GLuint program, GLint location, GLsizei count, const GLfloat *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform1fv(program, location, count, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform1f(GLuint program, GLint location, GLfloat v0)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform1f(program, location, v0);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform1iv(GLuint program, GLint location, GLsizei count, const GLint *value)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform1iv(program, location, count, value);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glProgramUniform1i(GLuint program, GLint location, GLint v0)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ProgramUniform1i(program, location, v0);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glGetProgramPipelineiv(GLuint pipeline, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->GetProgramPipelineiv(pipeline, pname, params);
}

inline GLboolean QOpenGLExtension_ARB_separate_shader_objects::glIsProgramPipeline(GLuint pipeline)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    return d->IsProgramPipeline(pipeline);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glGenProgramPipelines(GLsizei n, GLuint *pipelines)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->GenProgramPipelines(n, pipelines);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glDeleteProgramPipelines(GLsizei n, const GLuint *pipelines)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->DeleteProgramPipelines(n, pipelines);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glBindProgramPipeline(GLuint pipeline)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->BindProgramPipeline(pipeline);
}

inline GLuint QOpenGLExtension_ARB_separate_shader_objects::glCreateShaderProgramv(GLenum type, GLsizei count, const GLchar* const *strings)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    return d->CreateShaderProgramv(type, count, strings);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glActiveShaderProgram(GLuint pipeline, GLuint program)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->ActiveShaderProgram(pipeline, program);
}

inline void QOpenGLExtension_ARB_separate_shader_objects::glUseProgramStages(GLuint pipeline, GLbitfield stages, GLuint program)
{
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);
    d->UseProgramStages(pipeline, stages, program);
}

class QOpenGLExtension_ARB_shader_atomic_countersPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetActiveAtomicCounterBufferiv)(GLuint program, GLuint bufferIndex, GLenum pname, GLint *params);
};

class QOpenGLExtension_ARB_shader_atomic_counters : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_shader_atomic_counters();

    bool initializeOpenGLFunctions() final;

    void glGetActiveAtomicCounterBufferiv(GLuint program, GLuint bufferIndex, GLenum pname, GLint *params);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_shader_atomic_counters)
};

inline void QOpenGLExtension_ARB_shader_atomic_counters::glGetActiveAtomicCounterBufferiv(GLuint program, GLuint bufferIndex, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_ARB_shader_atomic_counters);
    d->GetActiveAtomicCounterBufferiv(program, bufferIndex, pname, params);
}

class QOpenGLExtension_ARB_shader_image_load_storePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP MemoryBarrier)(GLbitfield barriers);
    void (QOPENGLF_APIENTRYP BindImageTexture)(GLuint unit, GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum access, GLenum format);
};

class QOpenGLExtension_ARB_shader_image_load_store : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_shader_image_load_store();

    bool initializeOpenGLFunctions() final;

    void glMemoryBarrier(GLbitfield barriers);
    void glBindImageTexture(GLuint unit, GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum access, GLenum format);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_shader_image_load_store)
};

inline void QOpenGLExtension_ARB_shader_image_load_store::glMemoryBarrier(GLbitfield barriers)
{
    Q_D(QOpenGLExtension_ARB_shader_image_load_store);
    d->MemoryBarrier(barriers);
}

inline void QOpenGLExtension_ARB_shader_image_load_store::glBindImageTexture(GLuint unit, GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum access, GLenum format)
{
    Q_D(QOpenGLExtension_ARB_shader_image_load_store);
    d->BindImageTexture(unit, texture, level, layered, layer, access, format);
}

class QOpenGLExtension_ARB_shader_objectsPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetShaderSourceARB)(GLhandleARB obj, GLsizei maxLength, GLsizei *length, GLcharARB *source);
    void (QOPENGLF_APIENTRYP GetUniformivARB)(GLhandleARB programObj, GLint location, GLint *params);
    void (QOPENGLF_APIENTRYP GetUniformfvARB)(GLhandleARB programObj, GLint location, GLfloat *params);
    void (QOPENGLF_APIENTRYP GetActiveUniformARB)(GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei *length, GLint *size, GLenum *type, GLcharARB *name);
    GLint (QOPENGLF_APIENTRYP GetUniformLocationARB)(GLhandleARB programObj, const GLcharARB *name);
    void (QOPENGLF_APIENTRYP GetAttachedObjectsARB)(GLhandleARB containerObj, GLsizei maxCount, GLsizei *count, GLhandleARB *obj);
    void (QOPENGLF_APIENTRYP GetInfoLogARB)(GLhandleARB obj, GLsizei maxLength, GLsizei *length, GLcharARB *infoLog);
    void (QOPENGLF_APIENTRYP GetObjectParameterivARB)(GLhandleARB obj, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetObjectParameterfvARB)(GLhandleARB obj, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP UniformMatrix4fvARB)(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void (QOPENGLF_APIENTRYP UniformMatrix3fvARB)(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void (QOPENGLF_APIENTRYP UniformMatrix2fvARB)(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void (QOPENGLF_APIENTRYP Uniform4ivARB)(GLint location, GLsizei count, const GLint *value);
    void (QOPENGLF_APIENTRYP Uniform3ivARB)(GLint location, GLsizei count, const GLint *value);
    void (QOPENGLF_APIENTRYP Uniform2ivARB)(GLint location, GLsizei count, const GLint *value);
    void (QOPENGLF_APIENTRYP Uniform1ivARB)(GLint location, GLsizei count, const GLint *value);
    void (QOPENGLF_APIENTRYP Uniform4fvARB)(GLint location, GLsizei count, const GLfloat *value);
    void (QOPENGLF_APIENTRYP Uniform3fvARB)(GLint location, GLsizei count, const GLfloat *value);
    void (QOPENGLF_APIENTRYP Uniform2fvARB)(GLint location, GLsizei count, const GLfloat *value);
    void (QOPENGLF_APIENTRYP Uniform1fvARB)(GLint location, GLsizei count, const GLfloat *value);
    void (QOPENGLF_APIENTRYP Uniform4iARB)(GLint location, GLint v0, GLint v1, GLint v2, GLint v3);
    void (QOPENGLF_APIENTRYP Uniform3iARB)(GLint location, GLint v0, GLint v1, GLint v2);
    void (QOPENGLF_APIENTRYP Uniform2iARB)(GLint location, GLint v0, GLint v1);
    void (QOPENGLF_APIENTRYP Uniform1iARB)(GLint location, GLint v0);
    void (QOPENGLF_APIENTRYP Uniform4fARB)(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3);
    void (QOPENGLF_APIENTRYP Uniform3fARB)(GLint location, GLfloat v0, GLfloat v1, GLfloat v2);
    void (QOPENGLF_APIENTRYP Uniform2fARB)(GLint location, GLfloat v0, GLfloat v1);
    void (QOPENGLF_APIENTRYP Uniform1fARB)(GLint location, GLfloat v0);
    void (QOPENGLF_APIENTRYP ValidateProgramARB)(GLhandleARB programObj);
    void (QOPENGLF_APIENTRYP UseProgramObjectARB)(GLhandleARB programObj);
    void (QOPENGLF_APIENTRYP LinkProgramARB)(GLhandleARB programObj);
    void (QOPENGLF_APIENTRYP AttachObjectARB)(GLhandleARB containerObj, GLhandleARB obj);
    GLhandleARB (QOPENGLF_APIENTRYP CreateProgramObjectARB)();
    void (QOPENGLF_APIENTRYP CompileShaderARB)(GLhandleARB shaderObj);
    void (QOPENGLF_APIENTRYP ShaderSourceARB)(GLhandleARB shaderObj, GLsizei count, const GLcharARB* *string, const GLint *length);
    GLhandleARB (QOPENGLF_APIENTRYP CreateShaderObjectARB)(GLenum shaderType);
    void (QOPENGLF_APIENTRYP DetachObjectARB)(GLhandleARB containerObj, GLhandleARB attachedObj);
    GLhandleARB (QOPENGLF_APIENTRYP GetHandleARB)(GLenum pname);
    void (QOPENGLF_APIENTRYP DeleteObjectARB)(GLhandleARB obj);
};

class QOpenGLExtension_ARB_shader_objects : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_shader_objects();

    bool initializeOpenGLFunctions() final;

    void glGetShaderSourceARB(GLhandleARB obj, GLsizei maxLength, GLsizei *length, GLcharARB *source);
    void glGetUniformivARB(GLhandleARB programObj, GLint location, GLint *params);
    void glGetUniformfvARB(GLhandleARB programObj, GLint location, GLfloat *params);
    void glGetActiveUniformARB(GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei *length, GLint *size, GLenum *type, GLcharARB *name);
    GLint glGetUniformLocationARB(GLhandleARB programObj, const GLcharARB *name);
    void glGetAttachedObjectsARB(GLhandleARB containerObj, GLsizei maxCount, GLsizei *count, GLhandleARB *obj);
    void glGetInfoLogARB(GLhandleARB obj, GLsizei maxLength, GLsizei *length, GLcharARB *infoLog);
    void glGetObjectParameterivARB(GLhandleARB obj, GLenum pname, GLint *params);
    void glGetObjectParameterfvARB(GLhandleARB obj, GLenum pname, GLfloat *params);
    void glUniformMatrix4fvARB(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glUniformMatrix3fvARB(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glUniformMatrix2fvARB(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glUniform4ivARB(GLint location, GLsizei count, const GLint *value);
    void glUniform3ivARB(GLint location, GLsizei count, const GLint *value);
    void glUniform2ivARB(GLint location, GLsizei count, const GLint *value);
    void glUniform1ivARB(GLint location, GLsizei count, const GLint *value);
    void glUniform4fvARB(GLint location, GLsizei count, const GLfloat *value);
    void glUniform3fvARB(GLint location, GLsizei count, const GLfloat *value);
    void glUniform2fvARB(GLint location, GLsizei count, const GLfloat *value);
    void glUniform1fvARB(GLint location, GLsizei count, const GLfloat *value);
    void glUniform4iARB(GLint location, GLint v0, GLint v1, GLint v2, GLint v3);
    void glUniform3iARB(GLint location, GLint v0, GLint v1, GLint v2);
    void glUniform2iARB(GLint location, GLint v0, GLint v1);
    void glUniform1iARB(GLint location, GLint v0);
    void glUniform4fARB(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3);
    void glUniform3fARB(GLint location, GLfloat v0, GLfloat v1, GLfloat v2);
    void glUniform2fARB(GLint location, GLfloat v0, GLfloat v1);
    void glUniform1fARB(GLint location, GLfloat v0);
    void glValidateProgramARB(GLhandleARB programObj);
    void glUseProgramObjectARB(GLhandleARB programObj);
    void glLinkProgramARB(GLhandleARB programObj);
    void glAttachObjectARB(GLhandleARB containerObj, GLhandleARB obj);
    GLhandleARB glCreateProgramObjectARB();
    void glCompileShaderARB(GLhandleARB shaderObj);
    void glShaderSourceARB(GLhandleARB shaderObj, GLsizei count, const GLcharARB* *string, const GLint *length);
    GLhandleARB glCreateShaderObjectARB(GLenum shaderType);
    void glDetachObjectARB(GLhandleARB containerObj, GLhandleARB attachedObj);
    GLhandleARB glGetHandleARB(GLenum pname);
    void glDeleteObjectARB(GLhandleARB obj);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_shader_objects)
};

inline void QOpenGLExtension_ARB_shader_objects::glGetShaderSourceARB(GLhandleARB obj, GLsizei maxLength, GLsizei *length, GLcharARB *source)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->GetShaderSourceARB(obj, maxLength, length, source);
}

inline void QOpenGLExtension_ARB_shader_objects::glGetUniformivARB(GLhandleARB programObj, GLint location, GLint *params)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->GetUniformivARB(programObj, location, params);
}

inline void QOpenGLExtension_ARB_shader_objects::glGetUniformfvARB(GLhandleARB programObj, GLint location, GLfloat *params)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->GetUniformfvARB(programObj, location, params);
}

inline void QOpenGLExtension_ARB_shader_objects::glGetActiveUniformARB(GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei *length, GLint *size, GLenum *type, GLcharARB *name)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->GetActiveUniformARB(programObj, index, maxLength, length, size, type, name);
}

inline GLint QOpenGLExtension_ARB_shader_objects::glGetUniformLocationARB(GLhandleARB programObj, const GLcharARB *name)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    return d->GetUniformLocationARB(programObj, name);
}

inline void QOpenGLExtension_ARB_shader_objects::glGetAttachedObjectsARB(GLhandleARB containerObj, GLsizei maxCount, GLsizei *count, GLhandleARB *obj)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->GetAttachedObjectsARB(containerObj, maxCount, count, obj);
}

inline void QOpenGLExtension_ARB_shader_objects::glGetInfoLogARB(GLhandleARB obj, GLsizei maxLength, GLsizei *length, GLcharARB *infoLog)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->GetInfoLogARB(obj, maxLength, length, infoLog);
}

inline void QOpenGLExtension_ARB_shader_objects::glGetObjectParameterivARB(GLhandleARB obj, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->GetObjectParameterivARB(obj, pname, params);
}

inline void QOpenGLExtension_ARB_shader_objects::glGetObjectParameterfvARB(GLhandleARB obj, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->GetObjectParameterfvARB(obj, pname, params);
}

inline void QOpenGLExtension_ARB_shader_objects::glUniformMatrix4fvARB(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->UniformMatrix4fvARB(location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_shader_objects::glUniformMatrix3fvARB(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->UniformMatrix3fvARB(location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_shader_objects::glUniformMatrix2fvARB(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->UniformMatrix2fvARB(location, count, transpose, value);
}

inline void QOpenGLExtension_ARB_shader_objects::glUniform4ivARB(GLint location, GLsizei count, const GLint *value)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->Uniform4ivARB(location, count, value);
}

inline void QOpenGLExtension_ARB_shader_objects::glUniform3ivARB(GLint location, GLsizei count, const GLint *value)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->Uniform3ivARB(location, count, value);
}

inline void QOpenGLExtension_ARB_shader_objects::glUniform2ivARB(GLint location, GLsizei count, const GLint *value)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->Uniform2ivARB(location, count, value);
}

inline void QOpenGLExtension_ARB_shader_objects::glUniform1ivARB(GLint location, GLsizei count, const GLint *value)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->Uniform1ivARB(location, count, value);
}

inline void QOpenGLExtension_ARB_shader_objects::glUniform4fvARB(GLint location, GLsizei count, const GLfloat *value)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->Uniform4fvARB(location, count, value);
}

inline void QOpenGLExtension_ARB_shader_objects::glUniform3fvARB(GLint location, GLsizei count, const GLfloat *value)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->Uniform3fvARB(location, count, value);
}

inline void QOpenGLExtension_ARB_shader_objects::glUniform2fvARB(GLint location, GLsizei count, const GLfloat *value)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->Uniform2fvARB(location, count, value);
}

inline void QOpenGLExtension_ARB_shader_objects::glUniform1fvARB(GLint location, GLsizei count, const GLfloat *value)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->Uniform1fvARB(location, count, value);
}

inline void QOpenGLExtension_ARB_shader_objects::glUniform4iARB(GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->Uniform4iARB(location, v0, v1, v2, v3);
}

inline void QOpenGLExtension_ARB_shader_objects::glUniform3iARB(GLint location, GLint v0, GLint v1, GLint v2)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->Uniform3iARB(location, v0, v1, v2);
}

inline void QOpenGLExtension_ARB_shader_objects::glUniform2iARB(GLint location, GLint v0, GLint v1)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->Uniform2iARB(location, v0, v1);
}

inline void QOpenGLExtension_ARB_shader_objects::glUniform1iARB(GLint location, GLint v0)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->Uniform1iARB(location, v0);
}

inline void QOpenGLExtension_ARB_shader_objects::glUniform4fARB(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->Uniform4fARB(location, v0, v1, v2, v3);
}

inline void QOpenGLExtension_ARB_shader_objects::glUniform3fARB(GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->Uniform3fARB(location, v0, v1, v2);
}

inline void QOpenGLExtension_ARB_shader_objects::glUniform2fARB(GLint location, GLfloat v0, GLfloat v1)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->Uniform2fARB(location, v0, v1);
}

inline void QOpenGLExtension_ARB_shader_objects::glUniform1fARB(GLint location, GLfloat v0)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->Uniform1fARB(location, v0);
}

inline void QOpenGLExtension_ARB_shader_objects::glValidateProgramARB(GLhandleARB programObj)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->ValidateProgramARB(programObj);
}

inline void QOpenGLExtension_ARB_shader_objects::glUseProgramObjectARB(GLhandleARB programObj)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->UseProgramObjectARB(programObj);
}

inline void QOpenGLExtension_ARB_shader_objects::glLinkProgramARB(GLhandleARB programObj)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->LinkProgramARB(programObj);
}

inline void QOpenGLExtension_ARB_shader_objects::glAttachObjectARB(GLhandleARB containerObj, GLhandleARB obj)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->AttachObjectARB(containerObj, obj);
}

inline GLhandleARB QOpenGLExtension_ARB_shader_objects::glCreateProgramObjectARB()
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    return d->CreateProgramObjectARB();
}

inline void QOpenGLExtension_ARB_shader_objects::glCompileShaderARB(GLhandleARB shaderObj)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->CompileShaderARB(shaderObj);
}

inline void QOpenGLExtension_ARB_shader_objects::glShaderSourceARB(GLhandleARB shaderObj, GLsizei count, const GLcharARB* *string, const GLint *length)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->ShaderSourceARB(shaderObj, count, string, length);
}

inline GLhandleARB QOpenGLExtension_ARB_shader_objects::glCreateShaderObjectARB(GLenum shaderType)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    return d->CreateShaderObjectARB(shaderType);
}

inline void QOpenGLExtension_ARB_shader_objects::glDetachObjectARB(GLhandleARB containerObj, GLhandleARB attachedObj)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->DetachObjectARB(containerObj, attachedObj);
}

inline GLhandleARB QOpenGLExtension_ARB_shader_objects::glGetHandleARB(GLenum pname)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    return d->GetHandleARB(pname);
}

inline void QOpenGLExtension_ARB_shader_objects::glDeleteObjectARB(GLhandleARB obj)
{
    Q_D(QOpenGLExtension_ARB_shader_objects);
    d->DeleteObjectARB(obj);
}

class QOpenGLExtension_ARB_shader_storage_buffer_objectPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP ShaderStorageBlockBinding)(GLuint program, GLuint storageBlockIndex, GLuint storageBlockBinding);
};

class QOpenGLExtension_ARB_shader_storage_buffer_object : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_shader_storage_buffer_object();

    bool initializeOpenGLFunctions() final;

    void glShaderStorageBlockBinding(GLuint program, GLuint storageBlockIndex, GLuint storageBlockBinding);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_shader_storage_buffer_object)
};

inline void QOpenGLExtension_ARB_shader_storage_buffer_object::glShaderStorageBlockBinding(GLuint program, GLuint storageBlockIndex, GLuint storageBlockBinding)
{
    Q_D(QOpenGLExtension_ARB_shader_storage_buffer_object);
    d->ShaderStorageBlockBinding(program, storageBlockIndex, storageBlockBinding);
}

class QOpenGLExtension_ARB_shader_subroutinePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetProgramStageiv)(GLuint program, GLenum shadertype, GLenum pname, GLint *values);
    void (QOPENGLF_APIENTRYP GetUniformSubroutineuiv)(GLenum shadertype, GLint location, GLuint *params);
    void (QOPENGLF_APIENTRYP UniformSubroutinesuiv)(GLenum shadertype, GLsizei count, const GLuint *indices);
    void (QOPENGLF_APIENTRYP GetActiveSubroutineName)(GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei *length, GLchar *name);
    void (QOPENGLF_APIENTRYP GetActiveSubroutineUniformName)(GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei *length, GLchar *name);
    void (QOPENGLF_APIENTRYP GetActiveSubroutineUniformiv)(GLuint program, GLenum shadertype, GLuint index, GLenum pname, GLint *values);
    GLuint (QOPENGLF_APIENTRYP GetSubroutineIndex)(GLuint program, GLenum shadertype, const GLchar *name);
    GLint (QOPENGLF_APIENTRYP GetSubroutineUniformLocation)(GLuint program, GLenum shadertype, const GLchar *name);
};

class QOpenGLExtension_ARB_shader_subroutine : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_shader_subroutine();

    bool initializeOpenGLFunctions() final;

    void glGetProgramStageiv(GLuint program, GLenum shadertype, GLenum pname, GLint *values);
    void glGetUniformSubroutineuiv(GLenum shadertype, GLint location, GLuint *params);
    void glUniformSubroutinesuiv(GLenum shadertype, GLsizei count, const GLuint *indices);
    void glGetActiveSubroutineName(GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei *length, GLchar *name);
    void glGetActiveSubroutineUniformName(GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei *length, GLchar *name);
    void glGetActiveSubroutineUniformiv(GLuint program, GLenum shadertype, GLuint index, GLenum pname, GLint *values);
    GLuint glGetSubroutineIndex(GLuint program, GLenum shadertype, const GLchar *name);
    GLint glGetSubroutineUniformLocation(GLuint program, GLenum shadertype, const GLchar *name);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_shader_subroutine)
};

inline void QOpenGLExtension_ARB_shader_subroutine::glGetProgramStageiv(GLuint program, GLenum shadertype, GLenum pname, GLint *values)
{
    Q_D(QOpenGLExtension_ARB_shader_subroutine);
    d->GetProgramStageiv(program, shadertype, pname, values);
}

inline void QOpenGLExtension_ARB_shader_subroutine::glGetUniformSubroutineuiv(GLenum shadertype, GLint location, GLuint *params)
{
    Q_D(QOpenGLExtension_ARB_shader_subroutine);
    d->GetUniformSubroutineuiv(shadertype, location, params);
}

inline void QOpenGLExtension_ARB_shader_subroutine::glUniformSubroutinesuiv(GLenum shadertype, GLsizei count, const GLuint *indices)
{
    Q_D(QOpenGLExtension_ARB_shader_subroutine);
    d->UniformSubroutinesuiv(shadertype, count, indices);
}

inline void QOpenGLExtension_ARB_shader_subroutine::glGetActiveSubroutineName(GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei *length, GLchar *name)
{
    Q_D(QOpenGLExtension_ARB_shader_subroutine);
    d->GetActiveSubroutineName(program, shadertype, index, bufsize, length, name);
}

inline void QOpenGLExtension_ARB_shader_subroutine::glGetActiveSubroutineUniformName(GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei *length, GLchar *name)
{
    Q_D(QOpenGLExtension_ARB_shader_subroutine);
    d->GetActiveSubroutineUniformName(program, shadertype, index, bufsize, length, name);
}

inline void QOpenGLExtension_ARB_shader_subroutine::glGetActiveSubroutineUniformiv(GLuint program, GLenum shadertype, GLuint index, GLenum pname, GLint *values)
{
    Q_D(QOpenGLExtension_ARB_shader_subroutine);
    d->GetActiveSubroutineUniformiv(program, shadertype, index, pname, values);
}

inline GLuint QOpenGLExtension_ARB_shader_subroutine::glGetSubroutineIndex(GLuint program, GLenum shadertype, const GLchar *name)
{
    Q_D(QOpenGLExtension_ARB_shader_subroutine);
    return d->GetSubroutineIndex(program, shadertype, name);
}

inline GLint QOpenGLExtension_ARB_shader_subroutine::glGetSubroutineUniformLocation(GLuint program, GLenum shadertype, const GLchar *name)
{
    Q_D(QOpenGLExtension_ARB_shader_subroutine);
    return d->GetSubroutineUniformLocation(program, shadertype, name);
}

class QOpenGLExtension_ARB_shading_language_includePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetNamedStringivARB)(GLint namelen, const GLchar *name, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetNamedStringARB)(GLint namelen, const GLchar *name, GLsizei bufSize, GLint *stringlen, GLchar *string);
    GLboolean (QOPENGLF_APIENTRYP IsNamedStringARB)(GLint namelen, const GLchar *name);
    void (QOPENGLF_APIENTRYP CompileShaderIncludeARB)(GLuint shader, GLsizei count, const GLchar* *path, const GLint *length);
    void (QOPENGLF_APIENTRYP DeleteNamedStringARB)(GLint namelen, const GLchar *name);
    void (QOPENGLF_APIENTRYP NamedStringARB)(GLenum type, GLint namelen, const GLchar *name, GLint stringlen, const GLchar *string);
};

class QOpenGLExtension_ARB_shading_language_include : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_shading_language_include();

    bool initializeOpenGLFunctions() final;

    void glGetNamedStringivARB(GLint namelen, const GLchar *name, GLenum pname, GLint *params);
    void glGetNamedStringARB(GLint namelen, const GLchar *name, GLsizei bufSize, GLint *stringlen, GLchar *string);
    GLboolean glIsNamedStringARB(GLint namelen, const GLchar *name);
    void glCompileShaderIncludeARB(GLuint shader, GLsizei count, const GLchar* *path, const GLint *length);
    void glDeleteNamedStringARB(GLint namelen, const GLchar *name);
    void glNamedStringARB(GLenum type, GLint namelen, const GLchar *name, GLint stringlen, const GLchar *string);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_shading_language_include)
};

inline void QOpenGLExtension_ARB_shading_language_include::glGetNamedStringivARB(GLint namelen, const GLchar *name, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_ARB_shading_language_include);
    d->GetNamedStringivARB(namelen, name, pname, params);
}

inline void QOpenGLExtension_ARB_shading_language_include::glGetNamedStringARB(GLint namelen, const GLchar *name, GLsizei bufSize, GLint *stringlen, GLchar *string)
{
    Q_D(QOpenGLExtension_ARB_shading_language_include);
    d->GetNamedStringARB(namelen, name, bufSize, stringlen, string);
}

inline GLboolean QOpenGLExtension_ARB_shading_language_include::glIsNamedStringARB(GLint namelen, const GLchar *name)
{
    Q_D(QOpenGLExtension_ARB_shading_language_include);
    return d->IsNamedStringARB(namelen, name);
}

inline void QOpenGLExtension_ARB_shading_language_include::glCompileShaderIncludeARB(GLuint shader, GLsizei count, const GLchar* *path, const GLint *length)
{
    Q_D(QOpenGLExtension_ARB_shading_language_include);
    d->CompileShaderIncludeARB(shader, count, path, length);
}

inline void QOpenGLExtension_ARB_shading_language_include::glDeleteNamedStringARB(GLint namelen, const GLchar *name)
{
    Q_D(QOpenGLExtension_ARB_shading_language_include);
    d->DeleteNamedStringARB(namelen, name);
}

inline void QOpenGLExtension_ARB_shading_language_include::glNamedStringARB(GLenum type, GLint namelen, const GLchar *name, GLint stringlen, const GLchar *string)
{
    Q_D(QOpenGLExtension_ARB_shading_language_include);
    d->NamedStringARB(type, namelen, name, stringlen, string);
}

class QOpenGLExtension_ARB_syncPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetSynciv)(GLsync sync, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values);
    void (QOPENGLF_APIENTRYP GetInteger64v)(GLenum pname, GLint64 *params);
    void (QOPENGLF_APIENTRYP WaitSync)(GLsync sync, GLbitfield flags, GLuint64 timeout);
    GLenum (QOPENGLF_APIENTRYP ClientWaitSync)(GLsync sync, GLbitfield flags, GLuint64 timeout);
    void (QOPENGLF_APIENTRYP DeleteSync)(GLsync sync);
    GLboolean (QOPENGLF_APIENTRYP IsSync)(GLsync sync);
    GLsync (QOPENGLF_APIENTRYP FenceSync)(GLenum condition, GLbitfield flags);
};

class QOpenGLExtension_ARB_sync : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_sync();

    bool initializeOpenGLFunctions() final;

    void glGetSynciv(GLsync sync, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values);
    void glGetInteger64v(GLenum pname, GLint64 *params);
    void glWaitSync(GLsync sync, GLbitfield flags, GLuint64 timeout);
    GLenum glClientWaitSync(GLsync sync, GLbitfield flags, GLuint64 timeout);
    void glDeleteSync(GLsync sync);
    GLboolean glIsSync(GLsync sync);
    GLsync glFenceSync(GLenum condition, GLbitfield flags);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_sync)
};

inline void QOpenGLExtension_ARB_sync::glGetSynciv(GLsync sync, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values)
{
    Q_D(QOpenGLExtension_ARB_sync);
    d->GetSynciv(sync, pname, bufSize, length, values);
}

inline void QOpenGLExtension_ARB_sync::glGetInteger64v(GLenum pname, GLint64 *params)
{
    Q_D(QOpenGLExtension_ARB_sync);
    d->GetInteger64v(pname, params);
}

inline void QOpenGLExtension_ARB_sync::glWaitSync(GLsync sync, GLbitfield flags, GLuint64 timeout)
{
    Q_D(QOpenGLExtension_ARB_sync);
    d->WaitSync(sync, flags, timeout);
}

inline GLenum QOpenGLExtension_ARB_sync::glClientWaitSync(GLsync sync, GLbitfield flags, GLuint64 timeout)
{
    Q_D(QOpenGLExtension_ARB_sync);
    return d->ClientWaitSync(sync, flags, timeout);
}

inline void QOpenGLExtension_ARB_sync::glDeleteSync(GLsync sync)
{
    Q_D(QOpenGLExtension_ARB_sync);
    d->DeleteSync(sync);
}

inline GLboolean QOpenGLExtension_ARB_sync::glIsSync(GLsync sync)
{
    Q_D(QOpenGLExtension_ARB_sync);
    return d->IsSync(sync);
}

inline GLsync QOpenGLExtension_ARB_sync::glFenceSync(GLenum condition, GLbitfield flags)
{
    Q_D(QOpenGLExtension_ARB_sync);
    return d->FenceSync(condition, flags);
}

class QOpenGLExtension_ARB_tessellation_shaderPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP PatchParameterfv)(GLenum pname, const GLfloat *values);
    void (QOPENGLF_APIENTRYP PatchParameteri)(GLenum pname, GLint value);
};

class QOpenGLExtension_ARB_tessellation_shader : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_tessellation_shader();

    bool initializeOpenGLFunctions() final;

    void glPatchParameterfv(GLenum pname, const GLfloat *values);
    void glPatchParameteri(GLenum pname, GLint value);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_tessellation_shader)
};

inline void QOpenGLExtension_ARB_tessellation_shader::glPatchParameterfv(GLenum pname, const GLfloat *values)
{
    Q_D(QOpenGLExtension_ARB_tessellation_shader);
    d->PatchParameterfv(pname, values);
}

inline void QOpenGLExtension_ARB_tessellation_shader::glPatchParameteri(GLenum pname, GLint value)
{
    Q_D(QOpenGLExtension_ARB_tessellation_shader);
    d->PatchParameteri(pname, value);
}

class QOpenGLExtension_ARB_texture_buffer_objectPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP TexBufferARB)(GLenum target, GLenum internalformat, GLuint buffer);
};

class QOpenGLExtension_ARB_texture_buffer_object : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_texture_buffer_object();

    bool initializeOpenGLFunctions() final;

    void glTexBufferARB(GLenum target, GLenum internalformat, GLuint buffer);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_texture_buffer_object)
};

inline void QOpenGLExtension_ARB_texture_buffer_object::glTexBufferARB(GLenum target, GLenum internalformat, GLuint buffer)
{
    Q_D(QOpenGLExtension_ARB_texture_buffer_object);
    d->TexBufferARB(target, internalformat, buffer);
}

class QOpenGLExtension_ARB_texture_buffer_rangePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP TexBufferRange)(GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size);
};

class QOpenGLExtension_ARB_texture_buffer_range : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_texture_buffer_range();

    bool initializeOpenGLFunctions() final;

    void glTexBufferRange(GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_texture_buffer_range)
};

inline void QOpenGLExtension_ARB_texture_buffer_range::glTexBufferRange(GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size)
{
    Q_D(QOpenGLExtension_ARB_texture_buffer_range);
    d->TexBufferRange(target, internalformat, buffer, offset, size);
}

class QOpenGLExtension_ARB_texture_compressionPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetCompressedTexImageARB)(GLenum target, GLint level, GLvoid *img);
    void (QOPENGLF_APIENTRYP CompressedTexSubImage1DARB)(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data);
    void (QOPENGLF_APIENTRYP CompressedTexSubImage2DARB)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data);
    void (QOPENGLF_APIENTRYP CompressedTexSubImage3DARB)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data);
    void (QOPENGLF_APIENTRYP CompressedTexImage1DARB)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *data);
    void (QOPENGLF_APIENTRYP CompressedTexImage2DARB)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *data);
    void (QOPENGLF_APIENTRYP CompressedTexImage3DARB)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *data);
};

class QOpenGLExtension_ARB_texture_compression : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_texture_compression();

    bool initializeOpenGLFunctions() final;

    void glGetCompressedTexImageARB(GLenum target, GLint level, GLvoid *img);
    void glCompressedTexSubImage1DARB(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data);
    void glCompressedTexSubImage2DARB(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data);
    void glCompressedTexSubImage3DARB(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data);
    void glCompressedTexImage1DARB(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *data);
    void glCompressedTexImage2DARB(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *data);
    void glCompressedTexImage3DARB(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *data);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_texture_compression)
};

inline void QOpenGLExtension_ARB_texture_compression::glGetCompressedTexImageARB(GLenum target, GLint level, GLvoid *img)
{
    Q_D(QOpenGLExtension_ARB_texture_compression);
    d->GetCompressedTexImageARB(target, level, img);
}

inline void QOpenGLExtension_ARB_texture_compression::glCompressedTexSubImage1DARB(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data)
{
    Q_D(QOpenGLExtension_ARB_texture_compression);
    d->CompressedTexSubImage1DARB(target, level, xoffset, width, format, imageSize, data);
}

inline void QOpenGLExtension_ARB_texture_compression::glCompressedTexSubImage2DARB(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data)
{
    Q_D(QOpenGLExtension_ARB_texture_compression);
    d->CompressedTexSubImage2DARB(target, level, xoffset, yoffset, width, height, format, imageSize, data);
}

inline void QOpenGLExtension_ARB_texture_compression::glCompressedTexSubImage3DARB(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data)
{
    Q_D(QOpenGLExtension_ARB_texture_compression);
    d->CompressedTexSubImage3DARB(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
}

inline void QOpenGLExtension_ARB_texture_compression::glCompressedTexImage1DARB(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *data)
{
    Q_D(QOpenGLExtension_ARB_texture_compression);
    d->CompressedTexImage1DARB(target, level, internalformat, width, border, imageSize, data);
}

inline void QOpenGLExtension_ARB_texture_compression::glCompressedTexImage2DARB(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *data)
{
    Q_D(QOpenGLExtension_ARB_texture_compression);
    d->CompressedTexImage2DARB(target, level, internalformat, width, height, border, imageSize, data);
}

inline void QOpenGLExtension_ARB_texture_compression::glCompressedTexImage3DARB(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *data)
{
    Q_D(QOpenGLExtension_ARB_texture_compression);
    d->CompressedTexImage3DARB(target, level, internalformat, width, height, depth, border, imageSize, data);
}

class QOpenGLExtension_ARB_texture_multisamplePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP SampleMaski)(GLuint index, GLbitfield mask);
    void (QOPENGLF_APIENTRYP GetMultisamplefv)(GLenum pname, GLuint index, GLfloat *val);
    void (QOPENGLF_APIENTRYP TexImage3DMultisample)(GLenum target, GLsizei samples, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations);
    void (QOPENGLF_APIENTRYP TexImage2DMultisample)(GLenum target, GLsizei samples, GLint internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations);
};

class QOpenGLExtension_ARB_texture_multisample : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_texture_multisample();

    bool initializeOpenGLFunctions() final;

    void glSampleMaski(GLuint index, GLbitfield mask);
    void glGetMultisamplefv(GLenum pname, GLuint index, GLfloat *val);
    void glTexImage3DMultisample(GLenum target, GLsizei samples, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations);
    void glTexImage2DMultisample(GLenum target, GLsizei samples, GLint internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_texture_multisample)
};

inline void QOpenGLExtension_ARB_texture_multisample::glSampleMaski(GLuint index, GLbitfield mask)
{
    Q_D(QOpenGLExtension_ARB_texture_multisample);
    d->SampleMaski(index, mask);
}

inline void QOpenGLExtension_ARB_texture_multisample::glGetMultisamplefv(GLenum pname, GLuint index, GLfloat *val)
{
    Q_D(QOpenGLExtension_ARB_texture_multisample);
    d->GetMultisamplefv(pname, index, val);
}

inline void QOpenGLExtension_ARB_texture_multisample::glTexImage3DMultisample(GLenum target, GLsizei samples, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations)
{
    Q_D(QOpenGLExtension_ARB_texture_multisample);
    d->TexImage3DMultisample(target, samples, internalformat, width, height, depth, fixedsamplelocations);
}

inline void QOpenGLExtension_ARB_texture_multisample::glTexImage2DMultisample(GLenum target, GLsizei samples, GLint internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations)
{
    Q_D(QOpenGLExtension_ARB_texture_multisample);
    d->TexImage2DMultisample(target, samples, internalformat, width, height, fixedsamplelocations);
}

class QOpenGLExtension_ARB_texture_storagePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP TexStorage3D)(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth);
    void (QOPENGLF_APIENTRYP TexStorage2D)(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height);
    void (QOPENGLF_APIENTRYP TexStorage1D)(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width);
};

class QOpenGLExtension_ARB_texture_storage : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_texture_storage();

    bool initializeOpenGLFunctions() final;

    void glTexStorage3D(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth);
    void glTexStorage2D(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height);
    void glTexStorage1D(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_texture_storage)
};

inline void QOpenGLExtension_ARB_texture_storage::glTexStorage3D(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth)
{
    Q_D(QOpenGLExtension_ARB_texture_storage);
    d->TexStorage3D(target, levels, internalformat, width, height, depth);
}

inline void QOpenGLExtension_ARB_texture_storage::glTexStorage2D(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height)
{
    Q_D(QOpenGLExtension_ARB_texture_storage);
    d->TexStorage2D(target, levels, internalformat, width, height);
}

inline void QOpenGLExtension_ARB_texture_storage::glTexStorage1D(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width)
{
    Q_D(QOpenGLExtension_ARB_texture_storage);
    d->TexStorage1D(target, levels, internalformat, width);
}

class QOpenGLExtension_ARB_texture_storage_multisamplePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP TexStorage3DMultisample)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations);
    void (QOPENGLF_APIENTRYP TexStorage2DMultisample)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations);
};

class QOpenGLExtension_ARB_texture_storage_multisample : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_texture_storage_multisample();

    bool initializeOpenGLFunctions() final;

    void glTexStorage3DMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations);
    void glTexStorage2DMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_texture_storage_multisample)
};

inline void QOpenGLExtension_ARB_texture_storage_multisample::glTexStorage3DMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations)
{
    Q_D(QOpenGLExtension_ARB_texture_storage_multisample);
    d->TexStorage3DMultisample(target, samples, internalformat, width, height, depth, fixedsamplelocations);
}

inline void QOpenGLExtension_ARB_texture_storage_multisample::glTexStorage2DMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations)
{
    Q_D(QOpenGLExtension_ARB_texture_storage_multisample);
    d->TexStorage2DMultisample(target, samples, internalformat, width, height, fixedsamplelocations);
}

class QOpenGLExtension_ARB_texture_viewPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP TextureView)(GLuint texture, GLenum target, GLuint origtexture, GLenum internalformat, GLuint minlevel, GLuint numlevels, GLuint minlayer, GLuint numlayers);
};

class QOpenGLExtension_ARB_texture_view : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_texture_view();

    bool initializeOpenGLFunctions() final;

    void glTextureView(GLuint texture, GLenum target, GLuint origtexture, GLenum internalformat, GLuint minlevel, GLuint numlevels, GLuint minlayer, GLuint numlayers);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_texture_view)
};

inline void QOpenGLExtension_ARB_texture_view::glTextureView(GLuint texture, GLenum target, GLuint origtexture, GLenum internalformat, GLuint minlevel, GLuint numlevels, GLuint minlayer, GLuint numlayers)
{
    Q_D(QOpenGLExtension_ARB_texture_view);
    d->TextureView(texture, target, origtexture, internalformat, minlevel, numlevels, minlayer, numlayers);
}

class QOpenGLExtension_ARB_timer_queryPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetQueryObjectui64v)(GLuint id, GLenum pname, GLuint64 *params);
    void (QOPENGLF_APIENTRYP GetQueryObjecti64v)(GLuint id, GLenum pname, GLint64 *params);
    void (QOPENGLF_APIENTRYP QueryCounter)(GLuint id, GLenum target);
};

class QOpenGLExtension_ARB_timer_query : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_timer_query();

    bool initializeOpenGLFunctions() final;

    void glGetQueryObjectui64v(GLuint id, GLenum pname, GLuint64 *params);
    void glGetQueryObjecti64v(GLuint id, GLenum pname, GLint64 *params);
    void glQueryCounter(GLuint id, GLenum target);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_timer_query)
};

inline void QOpenGLExtension_ARB_timer_query::glGetQueryObjectui64v(GLuint id, GLenum pname, GLuint64 *params)
{
    Q_D(QOpenGLExtension_ARB_timer_query);
    d->GetQueryObjectui64v(id, pname, params);
}

inline void QOpenGLExtension_ARB_timer_query::glGetQueryObjecti64v(GLuint id, GLenum pname, GLint64 *params)
{
    Q_D(QOpenGLExtension_ARB_timer_query);
    d->GetQueryObjecti64v(id, pname, params);
}

inline void QOpenGLExtension_ARB_timer_query::glQueryCounter(GLuint id, GLenum target)
{
    Q_D(QOpenGLExtension_ARB_timer_query);
    d->QueryCounter(id, target);
}

class QOpenGLExtension_ARB_transform_feedback2Private : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP DrawTransformFeedback)(GLenum mode, GLuint id);
    void (QOPENGLF_APIENTRYP ResumeTransformFeedback)();
    void (QOPENGLF_APIENTRYP PauseTransformFeedback)();
    GLboolean (QOPENGLF_APIENTRYP IsTransformFeedback)(GLuint id);
    void (QOPENGLF_APIENTRYP GenTransformFeedbacks)(GLsizei n, GLuint *ids);
    void (QOPENGLF_APIENTRYP DeleteTransformFeedbacks)(GLsizei n, const GLuint *ids);
    void (QOPENGLF_APIENTRYP BindTransformFeedback)(GLenum target, GLuint id);
};

class QOpenGLExtension_ARB_transform_feedback2 : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_transform_feedback2();

    bool initializeOpenGLFunctions() final;

    void glDrawTransformFeedback(GLenum mode, GLuint id);
    void glResumeTransformFeedback();
    void glPauseTransformFeedback();
    GLboolean glIsTransformFeedback(GLuint id);
    void glGenTransformFeedbacks(GLsizei n, GLuint *ids);
    void glDeleteTransformFeedbacks(GLsizei n, const GLuint *ids);
    void glBindTransformFeedback(GLenum target, GLuint id);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_transform_feedback2)
};

inline void QOpenGLExtension_ARB_transform_feedback2::glDrawTransformFeedback(GLenum mode, GLuint id)
{
    Q_D(QOpenGLExtension_ARB_transform_feedback2);
    d->DrawTransformFeedback(mode, id);
}

inline void QOpenGLExtension_ARB_transform_feedback2::glResumeTransformFeedback()
{
    Q_D(QOpenGLExtension_ARB_transform_feedback2);
    d->ResumeTransformFeedback();
}

inline void QOpenGLExtension_ARB_transform_feedback2::glPauseTransformFeedback()
{
    Q_D(QOpenGLExtension_ARB_transform_feedback2);
    d->PauseTransformFeedback();
}

inline GLboolean QOpenGLExtension_ARB_transform_feedback2::glIsTransformFeedback(GLuint id)
{
    Q_D(QOpenGLExtension_ARB_transform_feedback2);
    return d->IsTransformFeedback(id);
}

inline void QOpenGLExtension_ARB_transform_feedback2::glGenTransformFeedbacks(GLsizei n, GLuint *ids)
{
    Q_D(QOpenGLExtension_ARB_transform_feedback2);
    d->GenTransformFeedbacks(n, ids);
}

inline void QOpenGLExtension_ARB_transform_feedback2::glDeleteTransformFeedbacks(GLsizei n, const GLuint *ids)
{
    Q_D(QOpenGLExtension_ARB_transform_feedback2);
    d->DeleteTransformFeedbacks(n, ids);
}

inline void QOpenGLExtension_ARB_transform_feedback2::glBindTransformFeedback(GLenum target, GLuint id)
{
    Q_D(QOpenGLExtension_ARB_transform_feedback2);
    d->BindTransformFeedback(target, id);
}

class QOpenGLExtension_ARB_transform_feedback3Private : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetQueryIndexediv)(GLenum target, GLuint index, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP EndQueryIndexed)(GLenum target, GLuint index);
    void (QOPENGLF_APIENTRYP BeginQueryIndexed)(GLenum target, GLuint index, GLuint id);
    void (QOPENGLF_APIENTRYP DrawTransformFeedbackStream)(GLenum mode, GLuint id, GLuint stream);
};

class QOpenGLExtension_ARB_transform_feedback3 : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_transform_feedback3();

    bool initializeOpenGLFunctions() final;

    void glGetQueryIndexediv(GLenum target, GLuint index, GLenum pname, GLint *params);
    void glEndQueryIndexed(GLenum target, GLuint index);
    void glBeginQueryIndexed(GLenum target, GLuint index, GLuint id);
    void glDrawTransformFeedbackStream(GLenum mode, GLuint id, GLuint stream);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_transform_feedback3)
};

inline void QOpenGLExtension_ARB_transform_feedback3::glGetQueryIndexediv(GLenum target, GLuint index, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_ARB_transform_feedback3);
    d->GetQueryIndexediv(target, index, pname, params);
}

inline void QOpenGLExtension_ARB_transform_feedback3::glEndQueryIndexed(GLenum target, GLuint index)
{
    Q_D(QOpenGLExtension_ARB_transform_feedback3);
    d->EndQueryIndexed(target, index);
}

inline void QOpenGLExtension_ARB_transform_feedback3::glBeginQueryIndexed(GLenum target, GLuint index, GLuint id)
{
    Q_D(QOpenGLExtension_ARB_transform_feedback3);
    d->BeginQueryIndexed(target, index, id);
}

inline void QOpenGLExtension_ARB_transform_feedback3::glDrawTransformFeedbackStream(GLenum mode, GLuint id, GLuint stream)
{
    Q_D(QOpenGLExtension_ARB_transform_feedback3);
    d->DrawTransformFeedbackStream(mode, id, stream);
}

class QOpenGLExtension_ARB_transform_feedback_instancedPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP DrawTransformFeedbackStreamInstanced)(GLenum mode, GLuint id, GLuint stream, GLsizei instancecount);
    void (QOPENGLF_APIENTRYP DrawTransformFeedbackInstanced)(GLenum mode, GLuint id, GLsizei instancecount);
};

class QOpenGLExtension_ARB_transform_feedback_instanced : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_transform_feedback_instanced();

    bool initializeOpenGLFunctions() final;

    void glDrawTransformFeedbackStreamInstanced(GLenum mode, GLuint id, GLuint stream, GLsizei instancecount);
    void glDrawTransformFeedbackInstanced(GLenum mode, GLuint id, GLsizei instancecount);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_transform_feedback_instanced)
};

inline void QOpenGLExtension_ARB_transform_feedback_instanced::glDrawTransformFeedbackStreamInstanced(GLenum mode, GLuint id, GLuint stream, GLsizei instancecount)
{
    Q_D(QOpenGLExtension_ARB_transform_feedback_instanced);
    d->DrawTransformFeedbackStreamInstanced(mode, id, stream, instancecount);
}

inline void QOpenGLExtension_ARB_transform_feedback_instanced::glDrawTransformFeedbackInstanced(GLenum mode, GLuint id, GLsizei instancecount)
{
    Q_D(QOpenGLExtension_ARB_transform_feedback_instanced);
    d->DrawTransformFeedbackInstanced(mode, id, instancecount);
}

class QOpenGLExtension_ARB_transpose_matrixPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP MultTransposeMatrixdARB)(const GLdouble *m);
    void (QOPENGLF_APIENTRYP MultTransposeMatrixfARB)(const GLfloat *m);
    void (QOPENGLF_APIENTRYP LoadTransposeMatrixdARB)(const GLdouble *m);
    void (QOPENGLF_APIENTRYP LoadTransposeMatrixfARB)(const GLfloat *m);
};

class QOpenGLExtension_ARB_transpose_matrix : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_transpose_matrix();

    bool initializeOpenGLFunctions() final;

    void glMultTransposeMatrixdARB(const GLdouble *m);
    void glMultTransposeMatrixfARB(const GLfloat *m);
    void glLoadTransposeMatrixdARB(const GLdouble *m);
    void glLoadTransposeMatrixfARB(const GLfloat *m);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_transpose_matrix)
};

inline void QOpenGLExtension_ARB_transpose_matrix::glMultTransposeMatrixdARB(const GLdouble *m)
{
    Q_D(QOpenGLExtension_ARB_transpose_matrix);
    d->MultTransposeMatrixdARB(m);
}

inline void QOpenGLExtension_ARB_transpose_matrix::glMultTransposeMatrixfARB(const GLfloat *m)
{
    Q_D(QOpenGLExtension_ARB_transpose_matrix);
    d->MultTransposeMatrixfARB(m);
}

inline void QOpenGLExtension_ARB_transpose_matrix::glLoadTransposeMatrixdARB(const GLdouble *m)
{
    Q_D(QOpenGLExtension_ARB_transpose_matrix);
    d->LoadTransposeMatrixdARB(m);
}

inline void QOpenGLExtension_ARB_transpose_matrix::glLoadTransposeMatrixfARB(const GLfloat *m)
{
    Q_D(QOpenGLExtension_ARB_transpose_matrix);
    d->LoadTransposeMatrixfARB(m);
}

class QOpenGLExtension_ARB_uniform_buffer_objectPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP UniformBlockBinding)(GLuint program, GLuint uniformBlockIndex, GLuint uniformBlockBinding);
    void (QOPENGLF_APIENTRYP GetActiveUniformBlockName)(GLuint program, GLuint uniformBlockIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformBlockName);
    void (QOPENGLF_APIENTRYP GetActiveUniformBlockiv)(GLuint program, GLuint uniformBlockIndex, GLenum pname, GLint *params);
    GLuint (QOPENGLF_APIENTRYP GetUniformBlockIndex)(GLuint program, const GLchar *uniformBlockName);
    void (QOPENGLF_APIENTRYP GetActiveUniformName)(GLuint program, GLuint uniformIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformName);
    void (QOPENGLF_APIENTRYP GetActiveUniformsiv)(GLuint program, GLsizei uniformCount, const GLuint *uniformIndices, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetUniformIndices)(GLuint program, GLsizei uniformCount, const GLchar* const *uniformNames, GLuint *uniformIndices);
};

class QOpenGLExtension_ARB_uniform_buffer_object : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_uniform_buffer_object();

    bool initializeOpenGLFunctions() final;

    void glUniformBlockBinding(GLuint program, GLuint uniformBlockIndex, GLuint uniformBlockBinding);
    void glGetActiveUniformBlockName(GLuint program, GLuint uniformBlockIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformBlockName);
    void glGetActiveUniformBlockiv(GLuint program, GLuint uniformBlockIndex, GLenum pname, GLint *params);
    GLuint glGetUniformBlockIndex(GLuint program, const GLchar *uniformBlockName);
    void glGetActiveUniformName(GLuint program, GLuint uniformIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformName);
    void glGetActiveUniformsiv(GLuint program, GLsizei uniformCount, const GLuint *uniformIndices, GLenum pname, GLint *params);
    void glGetUniformIndices(GLuint program, GLsizei uniformCount, const GLchar* const *uniformNames, GLuint *uniformIndices);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_uniform_buffer_object)
};

inline void QOpenGLExtension_ARB_uniform_buffer_object::glUniformBlockBinding(GLuint program, GLuint uniformBlockIndex, GLuint uniformBlockBinding)
{
    Q_D(QOpenGLExtension_ARB_uniform_buffer_object);
    d->UniformBlockBinding(program, uniformBlockIndex, uniformBlockBinding);
}

inline void QOpenGLExtension_ARB_uniform_buffer_object::glGetActiveUniformBlockName(GLuint program, GLuint uniformBlockIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformBlockName)
{
    Q_D(QOpenGLExtension_ARB_uniform_buffer_object);
    d->GetActiveUniformBlockName(program, uniformBlockIndex, bufSize, length, uniformBlockName);
}

inline void QOpenGLExtension_ARB_uniform_buffer_object::glGetActiveUniformBlockiv(GLuint program, GLuint uniformBlockIndex, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_ARB_uniform_buffer_object);
    d->GetActiveUniformBlockiv(program, uniformBlockIndex, pname, params);
}

inline GLuint QOpenGLExtension_ARB_uniform_buffer_object::glGetUniformBlockIndex(GLuint program, const GLchar *uniformBlockName)
{
    Q_D(QOpenGLExtension_ARB_uniform_buffer_object);
    return d->GetUniformBlockIndex(program, uniformBlockName);
}

inline void QOpenGLExtension_ARB_uniform_buffer_object::glGetActiveUniformName(GLuint program, GLuint uniformIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformName)
{
    Q_D(QOpenGLExtension_ARB_uniform_buffer_object);
    d->GetActiveUniformName(program, uniformIndex, bufSize, length, uniformName);
}

inline void QOpenGLExtension_ARB_uniform_buffer_object::glGetActiveUniformsiv(GLuint program, GLsizei uniformCount, const GLuint *uniformIndices, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_ARB_uniform_buffer_object);
    d->GetActiveUniformsiv(program, uniformCount, uniformIndices, pname, params);
}

inline void QOpenGLExtension_ARB_uniform_buffer_object::glGetUniformIndices(GLuint program, GLsizei uniformCount, const GLchar* const *uniformNames, GLuint *uniformIndices)
{
    Q_D(QOpenGLExtension_ARB_uniform_buffer_object);
    d->GetUniformIndices(program, uniformCount, uniformNames, uniformIndices);
}

class QOpenGLExtension_ARB_vertex_array_objectPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    GLboolean (QOPENGLF_APIENTRYP IsVertexArray)(GLuint array);
    void (QOPENGLF_APIENTRYP GenVertexArrays)(GLsizei n, GLuint *arrays);
    void (QOPENGLF_APIENTRYP DeleteVertexArrays)(GLsizei n, const GLuint *arrays);
    void (QOPENGLF_APIENTRYP BindVertexArray)(GLuint array);
};

class QOpenGLExtension_ARB_vertex_array_object : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_vertex_array_object();

    bool initializeOpenGLFunctions() final;

    GLboolean glIsVertexArray(GLuint array);
    void glGenVertexArrays(GLsizei n, GLuint *arrays);
    void glDeleteVertexArrays(GLsizei n, const GLuint *arrays);
    void glBindVertexArray(GLuint array);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_vertex_array_object)
};

inline GLboolean QOpenGLExtension_ARB_vertex_array_object::glIsVertexArray(GLuint array)
{
    Q_D(QOpenGLExtension_ARB_vertex_array_object);
    return d->IsVertexArray(array);
}

inline void QOpenGLExtension_ARB_vertex_array_object::glGenVertexArrays(GLsizei n, GLuint *arrays)
{
    Q_D(QOpenGLExtension_ARB_vertex_array_object);
    d->GenVertexArrays(n, arrays);
}

inline void QOpenGLExtension_ARB_vertex_array_object::glDeleteVertexArrays(GLsizei n, const GLuint *arrays)
{
    Q_D(QOpenGLExtension_ARB_vertex_array_object);
    d->DeleteVertexArrays(n, arrays);
}

inline void QOpenGLExtension_ARB_vertex_array_object::glBindVertexArray(GLuint array)
{
    Q_D(QOpenGLExtension_ARB_vertex_array_object);
    d->BindVertexArray(array);
}

class QOpenGLExtension_ARB_vertex_attrib_64bitPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetVertexAttribLdv)(GLuint index, GLenum pname, GLdouble *params);
    void (QOPENGLF_APIENTRYP VertexAttribLPointer)(GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
    void (QOPENGLF_APIENTRYP VertexAttribL4dv)(GLuint index, const GLdouble *v);
    void (QOPENGLF_APIENTRYP VertexAttribL3dv)(GLuint index, const GLdouble *v);
    void (QOPENGLF_APIENTRYP VertexAttribL2dv)(GLuint index, const GLdouble *v);
    void (QOPENGLF_APIENTRYP VertexAttribL1dv)(GLuint index, const GLdouble *v);
    void (QOPENGLF_APIENTRYP VertexAttribL4d)(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
    void (QOPENGLF_APIENTRYP VertexAttribL3d)(GLuint index, GLdouble x, GLdouble y, GLdouble z);
    void (QOPENGLF_APIENTRYP VertexAttribL2d)(GLuint index, GLdouble x, GLdouble y);
    void (QOPENGLF_APIENTRYP VertexAttribL1d)(GLuint index, GLdouble x);
};

class QOpenGLExtension_ARB_vertex_attrib_64bit : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_vertex_attrib_64bit();

    bool initializeOpenGLFunctions() final;

    void glGetVertexAttribLdv(GLuint index, GLenum pname, GLdouble *params);
    void glVertexAttribLPointer(GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
    void glVertexAttribL4dv(GLuint index, const GLdouble *v);
    void glVertexAttribL3dv(GLuint index, const GLdouble *v);
    void glVertexAttribL2dv(GLuint index, const GLdouble *v);
    void glVertexAttribL1dv(GLuint index, const GLdouble *v);
    void glVertexAttribL4d(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
    void glVertexAttribL3d(GLuint index, GLdouble x, GLdouble y, GLdouble z);
    void glVertexAttribL2d(GLuint index, GLdouble x, GLdouble y);
    void glVertexAttribL1d(GLuint index, GLdouble x);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_vertex_attrib_64bit)
};

inline void QOpenGLExtension_ARB_vertex_attrib_64bit::glGetVertexAttribLdv(GLuint index, GLenum pname, GLdouble *params)
{
    Q_D(QOpenGLExtension_ARB_vertex_attrib_64bit);
    d->GetVertexAttribLdv(index, pname, params);
}

inline void QOpenGLExtension_ARB_vertex_attrib_64bit::glVertexAttribLPointer(GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
    Q_D(QOpenGLExtension_ARB_vertex_attrib_64bit);
    d->VertexAttribLPointer(index, size, type, stride, pointer);
}

inline void QOpenGLExtension_ARB_vertex_attrib_64bit::glVertexAttribL4dv(GLuint index, const GLdouble *v)
{
    Q_D(QOpenGLExtension_ARB_vertex_attrib_64bit);
    d->VertexAttribL4dv(index, v);
}

inline void QOpenGLExtension_ARB_vertex_attrib_64bit::glVertexAttribL3dv(GLuint index, const GLdouble *v)
{
    Q_D(QOpenGLExtension_ARB_vertex_attrib_64bit);
    d->VertexAttribL3dv(index, v);
}

inline void QOpenGLExtension_ARB_vertex_attrib_64bit::glVertexAttribL2dv(GLuint index, const GLdouble *v)
{
    Q_D(QOpenGLExtension_ARB_vertex_attrib_64bit);
    d->VertexAttribL2dv(index, v);
}

inline void QOpenGLExtension_ARB_vertex_attrib_64bit::glVertexAttribL1dv(GLuint index, const GLdouble *v)
{
    Q_D(QOpenGLExtension_ARB_vertex_attrib_64bit);
    d->VertexAttribL1dv(index, v);
}

inline void QOpenGLExtension_ARB_vertex_attrib_64bit::glVertexAttribL4d(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    Q_D(QOpenGLExtension_ARB_vertex_attrib_64bit);
    d->VertexAttribL4d(index, x, y, z, w);
}

inline void QOpenGLExtension_ARB_vertex_attrib_64bit::glVertexAttribL3d(GLuint index, GLdouble x, GLdouble y, GLdouble z)
{
    Q_D(QOpenGLExtension_ARB_vertex_attrib_64bit);
    d->VertexAttribL3d(index, x, y, z);
}

inline void QOpenGLExtension_ARB_vertex_attrib_64bit::glVertexAttribL2d(GLuint index, GLdouble x, GLdouble y)
{
    Q_D(QOpenGLExtension_ARB_vertex_attrib_64bit);
    d->VertexAttribL2d(index, x, y);
}

inline void QOpenGLExtension_ARB_vertex_attrib_64bit::glVertexAttribL1d(GLuint index, GLdouble x)
{
    Q_D(QOpenGLExtension_ARB_vertex_attrib_64bit);
    d->VertexAttribL1d(index, x);
}

class QOpenGLExtension_ARB_vertex_attrib_bindingPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP VertexBindingDivisor)(GLuint bindingindex, GLuint divisor);
    void (QOPENGLF_APIENTRYP VertexAttribBinding)(GLuint attribindex, GLuint bindingindex);
    void (QOPENGLF_APIENTRYP VertexAttribLFormat)(GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
    void (QOPENGLF_APIENTRYP VertexAttribIFormat)(GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
    void (QOPENGLF_APIENTRYP VertexAttribFormat)(GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset);
    void (QOPENGLF_APIENTRYP BindVertexBuffer)(GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride);
};

class QOpenGLExtension_ARB_vertex_attrib_binding : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_vertex_attrib_binding();

    bool initializeOpenGLFunctions() final;

    void glVertexBindingDivisor(GLuint bindingindex, GLuint divisor);
    void glVertexAttribBinding(GLuint attribindex, GLuint bindingindex);
    void glVertexAttribLFormat(GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
    void glVertexAttribIFormat(GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
    void glVertexAttribFormat(GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset);
    void glBindVertexBuffer(GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_vertex_attrib_binding)
};

inline void QOpenGLExtension_ARB_vertex_attrib_binding::glVertexBindingDivisor(GLuint bindingindex, GLuint divisor)
{
    Q_D(QOpenGLExtension_ARB_vertex_attrib_binding);
    d->VertexBindingDivisor(bindingindex, divisor);
}

inline void QOpenGLExtension_ARB_vertex_attrib_binding::glVertexAttribBinding(GLuint attribindex, GLuint bindingindex)
{
    Q_D(QOpenGLExtension_ARB_vertex_attrib_binding);
    d->VertexAttribBinding(attribindex, bindingindex);
}

inline void QOpenGLExtension_ARB_vertex_attrib_binding::glVertexAttribLFormat(GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset)
{
    Q_D(QOpenGLExtension_ARB_vertex_attrib_binding);
    d->VertexAttribLFormat(attribindex, size, type, relativeoffset);
}

inline void QOpenGLExtension_ARB_vertex_attrib_binding::glVertexAttribIFormat(GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset)
{
    Q_D(QOpenGLExtension_ARB_vertex_attrib_binding);
    d->VertexAttribIFormat(attribindex, size, type, relativeoffset);
}

inline void QOpenGLExtension_ARB_vertex_attrib_binding::glVertexAttribFormat(GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset)
{
    Q_D(QOpenGLExtension_ARB_vertex_attrib_binding);
    d->VertexAttribFormat(attribindex, size, type, normalized, relativeoffset);
}

inline void QOpenGLExtension_ARB_vertex_attrib_binding::glBindVertexBuffer(GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride)
{
    Q_D(QOpenGLExtension_ARB_vertex_attrib_binding);
    d->BindVertexBuffer(bindingindex, buffer, offset, stride);
}

class QOpenGLExtension_ARB_vertex_blendPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP VertexBlendARB)(GLint count);
    void (QOPENGLF_APIENTRYP WeightPointerARB)(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
    void (QOPENGLF_APIENTRYP WeightuivARB)(GLint size, const GLuint *weights);
    void (QOPENGLF_APIENTRYP WeightusvARB)(GLint size, const GLushort *weights);
    void (QOPENGLF_APIENTRYP WeightubvARB)(GLint size, const GLubyte *weights);
    void (QOPENGLF_APIENTRYP WeightdvARB)(GLint size, const GLdouble *weights);
    void (QOPENGLF_APIENTRYP WeightfvARB)(GLint size, const GLfloat *weights);
    void (QOPENGLF_APIENTRYP WeightivARB)(GLint size, const GLint *weights);
    void (QOPENGLF_APIENTRYP WeightsvARB)(GLint size, const GLshort *weights);
    void (QOPENGLF_APIENTRYP WeightbvARB)(GLint size, const GLbyte *weights);
};

class QOpenGLExtension_ARB_vertex_blend : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_vertex_blend();

    bool initializeOpenGLFunctions() final;

    void glVertexBlendARB(GLint count);
    void glWeightPointerARB(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
    void glWeightuivARB(GLint size, const GLuint *weights);
    void glWeightusvARB(GLint size, const GLushort *weights);
    void glWeightubvARB(GLint size, const GLubyte *weights);
    void glWeightdvARB(GLint size, const GLdouble *weights);
    void glWeightfvARB(GLint size, const GLfloat *weights);
    void glWeightivARB(GLint size, const GLint *weights);
    void glWeightsvARB(GLint size, const GLshort *weights);
    void glWeightbvARB(GLint size, const GLbyte *weights);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_vertex_blend)
};

inline void QOpenGLExtension_ARB_vertex_blend::glVertexBlendARB(GLint count)
{
    Q_D(QOpenGLExtension_ARB_vertex_blend);
    d->VertexBlendARB(count);
}

inline void QOpenGLExtension_ARB_vertex_blend::glWeightPointerARB(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
    Q_D(QOpenGLExtension_ARB_vertex_blend);
    d->WeightPointerARB(size, type, stride, pointer);
}

inline void QOpenGLExtension_ARB_vertex_blend::glWeightuivARB(GLint size, const GLuint *weights)
{
    Q_D(QOpenGLExtension_ARB_vertex_blend);
    d->WeightuivARB(size, weights);
}

inline void QOpenGLExtension_ARB_vertex_blend::glWeightusvARB(GLint size, const GLushort *weights)
{
    Q_D(QOpenGLExtension_ARB_vertex_blend);
    d->WeightusvARB(size, weights);
}

inline void QOpenGLExtension_ARB_vertex_blend::glWeightubvARB(GLint size, const GLubyte *weights)
{
    Q_D(QOpenGLExtension_ARB_vertex_blend);
    d->WeightubvARB(size, weights);
}

inline void QOpenGLExtension_ARB_vertex_blend::glWeightdvARB(GLint size, const GLdouble *weights)
{
    Q_D(QOpenGLExtension_ARB_vertex_blend);
    d->WeightdvARB(size, weights);
}

inline void QOpenGLExtension_ARB_vertex_blend::glWeightfvARB(GLint size, const GLfloat *weights)
{
    Q_D(QOpenGLExtension_ARB_vertex_blend);
    d->WeightfvARB(size, weights);
}

inline void QOpenGLExtension_ARB_vertex_blend::glWeightivARB(GLint size, const GLint *weights)
{
    Q_D(QOpenGLExtension_ARB_vertex_blend);
    d->WeightivARB(size, weights);
}

inline void QOpenGLExtension_ARB_vertex_blend::glWeightsvARB(GLint size, const GLshort *weights)
{
    Q_D(QOpenGLExtension_ARB_vertex_blend);
    d->WeightsvARB(size, weights);
}

inline void QOpenGLExtension_ARB_vertex_blend::glWeightbvARB(GLint size, const GLbyte *weights)
{
    Q_D(QOpenGLExtension_ARB_vertex_blend);
    d->WeightbvARB(size, weights);
}

class QOpenGLExtension_ARB_vertex_buffer_objectPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetBufferPointervARB)(GLenum target, GLenum pname, GLvoid* *params);
    void (QOPENGLF_APIENTRYP GetBufferParameterivARB)(GLenum target, GLenum pname, GLint *params);
    GLboolean (QOPENGLF_APIENTRYP UnmapBufferARB)(GLenum target);
    GLvoid* (QOPENGLF_APIENTRYP MapBufferARB)(GLenum target, GLenum access);
    void (QOPENGLF_APIENTRYP GetBufferSubDataARB)(GLenum target, GLintptrARB offset, GLsizeiptrARB size, GLvoid *data);
    void (QOPENGLF_APIENTRYP BufferSubDataARB)(GLenum target, GLintptrARB offset, GLsizeiptrARB size, const GLvoid *data);
    void (QOPENGLF_APIENTRYP BufferDataARB)(GLenum target, GLsizeiptrARB size, const GLvoid *data, GLenum usage);
    GLboolean (QOPENGLF_APIENTRYP IsBufferARB)(GLuint buffer);
    void (QOPENGLF_APIENTRYP GenBuffersARB)(GLsizei n, GLuint *buffers);
    void (QOPENGLF_APIENTRYP DeleteBuffersARB)(GLsizei n, const GLuint *buffers);
    void (QOPENGLF_APIENTRYP BindBufferARB)(GLenum target, GLuint buffer);
};

class QOpenGLExtension_ARB_vertex_buffer_object : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_vertex_buffer_object();

    bool initializeOpenGLFunctions() final;

    void glGetBufferPointervARB(GLenum target, GLenum pname, GLvoid* *params);
    void glGetBufferParameterivARB(GLenum target, GLenum pname, GLint *params);
    GLboolean glUnmapBufferARB(GLenum target);
    GLvoid* glMapBufferARB(GLenum target, GLenum access);
    void glGetBufferSubDataARB(GLenum target, GLintptrARB offset, GLsizeiptrARB size, GLvoid *data);
    void glBufferSubDataARB(GLenum target, GLintptrARB offset, GLsizeiptrARB size, const GLvoid *data);
    void glBufferDataARB(GLenum target, GLsizeiptrARB size, const GLvoid *data, GLenum usage);
    GLboolean glIsBufferARB(GLuint buffer);
    void glGenBuffersARB(GLsizei n, GLuint *buffers);
    void glDeleteBuffersARB(GLsizei n, const GLuint *buffers);
    void glBindBufferARB(GLenum target, GLuint buffer);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_vertex_buffer_object)
};

inline void QOpenGLExtension_ARB_vertex_buffer_object::glGetBufferPointervARB(GLenum target, GLenum pname, GLvoid* *params)
{
    Q_D(QOpenGLExtension_ARB_vertex_buffer_object);
    d->GetBufferPointervARB(target, pname, params);
}

inline void QOpenGLExtension_ARB_vertex_buffer_object::glGetBufferParameterivARB(GLenum target, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_ARB_vertex_buffer_object);
    d->GetBufferParameterivARB(target, pname, params);
}

inline GLboolean QOpenGLExtension_ARB_vertex_buffer_object::glUnmapBufferARB(GLenum target)
{
    Q_D(QOpenGLExtension_ARB_vertex_buffer_object);
    return d->UnmapBufferARB(target);
}

inline GLvoid* QOpenGLExtension_ARB_vertex_buffer_object::glMapBufferARB(GLenum target, GLenum access)
{
    Q_D(QOpenGLExtension_ARB_vertex_buffer_object);
    return d->MapBufferARB(target, access);
}

inline void QOpenGLExtension_ARB_vertex_buffer_object::glGetBufferSubDataARB(GLenum target, GLintptrARB offset, GLsizeiptrARB size, GLvoid *data)
{
    Q_D(QOpenGLExtension_ARB_vertex_buffer_object);
    d->GetBufferSubDataARB(target, offset, size, data);
}

inline void QOpenGLExtension_ARB_vertex_buffer_object::glBufferSubDataARB(GLenum target, GLintptrARB offset, GLsizeiptrARB size, const GLvoid *data)
{
    Q_D(QOpenGLExtension_ARB_vertex_buffer_object);
    d->BufferSubDataARB(target, offset, size, data);
}

inline void QOpenGLExtension_ARB_vertex_buffer_object::glBufferDataARB(GLenum target, GLsizeiptrARB size, const GLvoid *data, GLenum usage)
{
    Q_D(QOpenGLExtension_ARB_vertex_buffer_object);
    d->BufferDataARB(target, size, data, usage);
}

inline GLboolean QOpenGLExtension_ARB_vertex_buffer_object::glIsBufferARB(GLuint buffer)
{
    Q_D(QOpenGLExtension_ARB_vertex_buffer_object);
    return d->IsBufferARB(buffer);
}

inline void QOpenGLExtension_ARB_vertex_buffer_object::glGenBuffersARB(GLsizei n, GLuint *buffers)
{
    Q_D(QOpenGLExtension_ARB_vertex_buffer_object);
    d->GenBuffersARB(n, buffers);
}

inline void QOpenGLExtension_ARB_vertex_buffer_object::glDeleteBuffersARB(GLsizei n, const GLuint *buffers)
{
    Q_D(QOpenGLExtension_ARB_vertex_buffer_object);
    d->DeleteBuffersARB(n, buffers);
}

inline void QOpenGLExtension_ARB_vertex_buffer_object::glBindBufferARB(GLenum target, GLuint buffer)
{
    Q_D(QOpenGLExtension_ARB_vertex_buffer_object);
    d->BindBufferARB(target, buffer);
}

class QOpenGLExtension_ARB_vertex_programPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    GLboolean (QOPENGLF_APIENTRYP IsProgramARB)(GLuint program);
    void (QOPENGLF_APIENTRYP GetVertexAttribPointervARB)(GLuint index, GLenum pname, GLvoid* *pointer);
    void (QOPENGLF_APIENTRYP GetVertexAttribivARB)(GLuint index, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetVertexAttribfvARB)(GLuint index, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP GetVertexAttribdvARB)(GLuint index, GLenum pname, GLdouble *params);
    void (QOPENGLF_APIENTRYP GetProgramStringARB)(GLenum target, GLenum pname, GLvoid *string);
    void (QOPENGLF_APIENTRYP GetProgramivARB)(GLenum target, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetProgramLocalParameterfvARB)(GLenum target, GLuint index, GLfloat *params);
    void (QOPENGLF_APIENTRYP GetProgramLocalParameterdvARB)(GLenum target, GLuint index, GLdouble *params);
    void (QOPENGLF_APIENTRYP GetProgramEnvParameterfvARB)(GLenum target, GLuint index, GLfloat *params);
    void (QOPENGLF_APIENTRYP GetProgramEnvParameterdvARB)(GLenum target, GLuint index, GLdouble *params);
    void (QOPENGLF_APIENTRYP ProgramLocalParameter4fvARB)(GLenum target, GLuint index, const GLfloat *params);
    void (QOPENGLF_APIENTRYP ProgramLocalParameter4fARB)(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
    void (QOPENGLF_APIENTRYP ProgramLocalParameter4dvARB)(GLenum target, GLuint index, const GLdouble *params);
    void (QOPENGLF_APIENTRYP ProgramLocalParameter4dARB)(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
    void (QOPENGLF_APIENTRYP ProgramEnvParameter4fvARB)(GLenum target, GLuint index, const GLfloat *params);
    void (QOPENGLF_APIENTRYP ProgramEnvParameter4fARB)(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
    void (QOPENGLF_APIENTRYP ProgramEnvParameter4dvARB)(GLenum target, GLuint index, const GLdouble *params);
    void (QOPENGLF_APIENTRYP ProgramEnvParameter4dARB)(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
    void (QOPENGLF_APIENTRYP GenProgramsARB)(GLsizei n, GLuint *programs);
    void (QOPENGLF_APIENTRYP DeleteProgramsARB)(GLsizei n, const GLuint *programs);
    void (QOPENGLF_APIENTRYP BindProgramARB)(GLenum target, GLuint program);
    void (QOPENGLF_APIENTRYP ProgramStringARB)(GLenum target, GLenum format, GLsizei len, const GLvoid *string);
    void (QOPENGLF_APIENTRYP DisableVertexAttribArrayARB)(GLuint index);
    void (QOPENGLF_APIENTRYP EnableVertexAttribArrayARB)(GLuint index);
    void (QOPENGLF_APIENTRYP VertexAttribPointerARB)(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid *pointer);
    void (QOPENGLF_APIENTRYP VertexAttrib4usvARB)(GLuint index, const GLushort *v);
    void (QOPENGLF_APIENTRYP VertexAttrib4uivARB)(GLuint index, const GLuint *v);
    void (QOPENGLF_APIENTRYP VertexAttrib4ubvARB)(GLuint index, const GLubyte *v);
    void (QOPENGLF_APIENTRYP VertexAttrib4svARB)(GLuint index, const GLshort *v);
    void (QOPENGLF_APIENTRYP VertexAttrib4sARB)(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w);
    void (QOPENGLF_APIENTRYP VertexAttrib4ivARB)(GLuint index, const GLint *v);
    void (QOPENGLF_APIENTRYP VertexAttrib4fvARB)(GLuint index, const GLfloat *v);
    void (QOPENGLF_APIENTRYP VertexAttrib4fARB)(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
    void (QOPENGLF_APIENTRYP VertexAttrib4dvARB)(GLuint index, const GLdouble *v);
    void (QOPENGLF_APIENTRYP VertexAttrib4dARB)(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
    void (QOPENGLF_APIENTRYP VertexAttrib4bvARB)(GLuint index, const GLbyte *v);
    void (QOPENGLF_APIENTRYP VertexAttrib4NusvARB)(GLuint index, const GLushort *v);
    void (QOPENGLF_APIENTRYP VertexAttrib4NuivARB)(GLuint index, const GLuint *v);
    void (QOPENGLF_APIENTRYP VertexAttrib4NubvARB)(GLuint index, const GLubyte *v);
    void (QOPENGLF_APIENTRYP VertexAttrib4NubARB)(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w);
    void (QOPENGLF_APIENTRYP VertexAttrib4NsvARB)(GLuint index, const GLshort *v);
    void (QOPENGLF_APIENTRYP VertexAttrib4NivARB)(GLuint index, const GLint *v);
    void (QOPENGLF_APIENTRYP VertexAttrib4NbvARB)(GLuint index, const GLbyte *v);
    void (QOPENGLF_APIENTRYP VertexAttrib3svARB)(GLuint index, const GLshort *v);
    void (QOPENGLF_APIENTRYP VertexAttrib3sARB)(GLuint index, GLshort x, GLshort y, GLshort z);
    void (QOPENGLF_APIENTRYP VertexAttrib3fvARB)(GLuint index, const GLfloat *v);
    void (QOPENGLF_APIENTRYP VertexAttrib3fARB)(GLuint index, GLfloat x, GLfloat y, GLfloat z);
    void (QOPENGLF_APIENTRYP VertexAttrib3dvARB)(GLuint index, const GLdouble *v);
    void (QOPENGLF_APIENTRYP VertexAttrib3dARB)(GLuint index, GLdouble x, GLdouble y, GLdouble z);
    void (QOPENGLF_APIENTRYP VertexAttrib2svARB)(GLuint index, const GLshort *v);
    void (QOPENGLF_APIENTRYP VertexAttrib2sARB)(GLuint index, GLshort x, GLshort y);
    void (QOPENGLF_APIENTRYP VertexAttrib2fvARB)(GLuint index, const GLfloat *v);
    void (QOPENGLF_APIENTRYP VertexAttrib2fARB)(GLuint index, GLfloat x, GLfloat y);
    void (QOPENGLF_APIENTRYP VertexAttrib2dvARB)(GLuint index, const GLdouble *v);
    void (QOPENGLF_APIENTRYP VertexAttrib2dARB)(GLuint index, GLdouble x, GLdouble y);
    void (QOPENGLF_APIENTRYP VertexAttrib1svARB)(GLuint index, const GLshort *v);
    void (QOPENGLF_APIENTRYP VertexAttrib1sARB)(GLuint index, GLshort x);
    void (QOPENGLF_APIENTRYP VertexAttrib1fvARB)(GLuint index, const GLfloat *v);
    void (QOPENGLF_APIENTRYP VertexAttrib1fARB)(GLuint index, GLfloat x);
    void (QOPENGLF_APIENTRYP VertexAttrib1dvARB)(GLuint index, const GLdouble *v);
    void (QOPENGLF_APIENTRYP VertexAttrib1dARB)(GLuint index, GLdouble x);
};

class QOpenGLExtension_ARB_vertex_program : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_vertex_program();

    bool initializeOpenGLFunctions() final;

    GLboolean glIsProgramARB(GLuint program);
    void glGetVertexAttribPointervARB(GLuint index, GLenum pname, GLvoid* *pointer);
    void glGetVertexAttribivARB(GLuint index, GLenum pname, GLint *params);
    void glGetVertexAttribfvARB(GLuint index, GLenum pname, GLfloat *params);
    void glGetVertexAttribdvARB(GLuint index, GLenum pname, GLdouble *params);
    void glGetProgramStringARB(GLenum target, GLenum pname, GLvoid *string);
    void glGetProgramivARB(GLenum target, GLenum pname, GLint *params);
    void glGetProgramLocalParameterfvARB(GLenum target, GLuint index, GLfloat *params);
    void glGetProgramLocalParameterdvARB(GLenum target, GLuint index, GLdouble *params);
    void glGetProgramEnvParameterfvARB(GLenum target, GLuint index, GLfloat *params);
    void glGetProgramEnvParameterdvARB(GLenum target, GLuint index, GLdouble *params);
    void glProgramLocalParameter4fvARB(GLenum target, GLuint index, const GLfloat *params);
    void glProgramLocalParameter4fARB(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
    void glProgramLocalParameter4dvARB(GLenum target, GLuint index, const GLdouble *params);
    void glProgramLocalParameter4dARB(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
    void glProgramEnvParameter4fvARB(GLenum target, GLuint index, const GLfloat *params);
    void glProgramEnvParameter4fARB(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
    void glProgramEnvParameter4dvARB(GLenum target, GLuint index, const GLdouble *params);
    void glProgramEnvParameter4dARB(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
    void glGenProgramsARB(GLsizei n, GLuint *programs);
    void glDeleteProgramsARB(GLsizei n, const GLuint *programs);
    void glBindProgramARB(GLenum target, GLuint program);
    void glProgramStringARB(GLenum target, GLenum format, GLsizei len, const GLvoid *string);
    void glDisableVertexAttribArrayARB(GLuint index);
    void glEnableVertexAttribArrayARB(GLuint index);
    void glVertexAttribPointerARB(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid *pointer);
    void glVertexAttrib4usvARB(GLuint index, const GLushort *v);
    void glVertexAttrib4uivARB(GLuint index, const GLuint *v);
    void glVertexAttrib4ubvARB(GLuint index, const GLubyte *v);
    void glVertexAttrib4svARB(GLuint index, const GLshort *v);
    void glVertexAttrib4sARB(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w);
    void glVertexAttrib4ivARB(GLuint index, const GLint *v);
    void glVertexAttrib4fvARB(GLuint index, const GLfloat *v);
    void glVertexAttrib4fARB(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
    void glVertexAttrib4dvARB(GLuint index, const GLdouble *v);
    void glVertexAttrib4dARB(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
    void glVertexAttrib4bvARB(GLuint index, const GLbyte *v);
    void glVertexAttrib4NusvARB(GLuint index, const GLushort *v);
    void glVertexAttrib4NuivARB(GLuint index, const GLuint *v);
    void glVertexAttrib4NubvARB(GLuint index, const GLubyte *v);
    void glVertexAttrib4NubARB(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w);
    void glVertexAttrib4NsvARB(GLuint index, const GLshort *v);
    void glVertexAttrib4NivARB(GLuint index, const GLint *v);
    void glVertexAttrib4NbvARB(GLuint index, const GLbyte *v);
    void glVertexAttrib3svARB(GLuint index, const GLshort *v);
    void glVertexAttrib3sARB(GLuint index, GLshort x, GLshort y, GLshort z);
    void glVertexAttrib3fvARB(GLuint index, const GLfloat *v);
    void glVertexAttrib3fARB(GLuint index, GLfloat x, GLfloat y, GLfloat z);
    void glVertexAttrib3dvARB(GLuint index, const GLdouble *v);
    void glVertexAttrib3dARB(GLuint index, GLdouble x, GLdouble y, GLdouble z);
    void glVertexAttrib2svARB(GLuint index, const GLshort *v);
    void glVertexAttrib2sARB(GLuint index, GLshort x, GLshort y);
    void glVertexAttrib2fvARB(GLuint index, const GLfloat *v);
    void glVertexAttrib2fARB(GLuint index, GLfloat x, GLfloat y);
    void glVertexAttrib2dvARB(GLuint index, const GLdouble *v);
    void glVertexAttrib2dARB(GLuint index, GLdouble x, GLdouble y);
    void glVertexAttrib1svARB(GLuint index, const GLshort *v);
    void glVertexAttrib1sARB(GLuint index, GLshort x);
    void glVertexAttrib1fvARB(GLuint index, const GLfloat *v);
    void glVertexAttrib1fARB(GLuint index, GLfloat x);
    void glVertexAttrib1dvARB(GLuint index, const GLdouble *v);
    void glVertexAttrib1dARB(GLuint index, GLdouble x);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_vertex_program)
};

inline GLboolean QOpenGLExtension_ARB_vertex_program::glIsProgramARB(GLuint program)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    return d->IsProgramARB(program);
}

inline void QOpenGLExtension_ARB_vertex_program::glGetVertexAttribPointervARB(GLuint index, GLenum pname, GLvoid* *pointer)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->GetVertexAttribPointervARB(index, pname, pointer);
}

inline void QOpenGLExtension_ARB_vertex_program::glGetVertexAttribivARB(GLuint index, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->GetVertexAttribivARB(index, pname, params);
}

inline void QOpenGLExtension_ARB_vertex_program::glGetVertexAttribfvARB(GLuint index, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->GetVertexAttribfvARB(index, pname, params);
}

inline void QOpenGLExtension_ARB_vertex_program::glGetVertexAttribdvARB(GLuint index, GLenum pname, GLdouble *params)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->GetVertexAttribdvARB(index, pname, params);
}

inline void QOpenGLExtension_ARB_vertex_program::glGetProgramStringARB(GLenum target, GLenum pname, GLvoid *string)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->GetProgramStringARB(target, pname, string);
}

inline void QOpenGLExtension_ARB_vertex_program::glGetProgramivARB(GLenum target, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->GetProgramivARB(target, pname, params);
}

inline void QOpenGLExtension_ARB_vertex_program::glGetProgramLocalParameterfvARB(GLenum target, GLuint index, GLfloat *params)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->GetProgramLocalParameterfvARB(target, index, params);
}

inline void QOpenGLExtension_ARB_vertex_program::glGetProgramLocalParameterdvARB(GLenum target, GLuint index, GLdouble *params)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->GetProgramLocalParameterdvARB(target, index, params);
}

inline void QOpenGLExtension_ARB_vertex_program::glGetProgramEnvParameterfvARB(GLenum target, GLuint index, GLfloat *params)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->GetProgramEnvParameterfvARB(target, index, params);
}

inline void QOpenGLExtension_ARB_vertex_program::glGetProgramEnvParameterdvARB(GLenum target, GLuint index, GLdouble *params)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->GetProgramEnvParameterdvARB(target, index, params);
}

inline void QOpenGLExtension_ARB_vertex_program::glProgramLocalParameter4fvARB(GLenum target, GLuint index, const GLfloat *params)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->ProgramLocalParameter4fvARB(target, index, params);
}

inline void QOpenGLExtension_ARB_vertex_program::glProgramLocalParameter4fARB(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->ProgramLocalParameter4fARB(target, index, x, y, z, w);
}

inline void QOpenGLExtension_ARB_vertex_program::glProgramLocalParameter4dvARB(GLenum target, GLuint index, const GLdouble *params)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->ProgramLocalParameter4dvARB(target, index, params);
}

inline void QOpenGLExtension_ARB_vertex_program::glProgramLocalParameter4dARB(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->ProgramLocalParameter4dARB(target, index, x, y, z, w);
}

inline void QOpenGLExtension_ARB_vertex_program::glProgramEnvParameter4fvARB(GLenum target, GLuint index, const GLfloat *params)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->ProgramEnvParameter4fvARB(target, index, params);
}

inline void QOpenGLExtension_ARB_vertex_program::glProgramEnvParameter4fARB(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->ProgramEnvParameter4fARB(target, index, x, y, z, w);
}

inline void QOpenGLExtension_ARB_vertex_program::glProgramEnvParameter4dvARB(GLenum target, GLuint index, const GLdouble *params)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->ProgramEnvParameter4dvARB(target, index, params);
}

inline void QOpenGLExtension_ARB_vertex_program::glProgramEnvParameter4dARB(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->ProgramEnvParameter4dARB(target, index, x, y, z, w);
}

inline void QOpenGLExtension_ARB_vertex_program::glGenProgramsARB(GLsizei n, GLuint *programs)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->GenProgramsARB(n, programs);
}

inline void QOpenGLExtension_ARB_vertex_program::glDeleteProgramsARB(GLsizei n, const GLuint *programs)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->DeleteProgramsARB(n, programs);
}

inline void QOpenGLExtension_ARB_vertex_program::glBindProgramARB(GLenum target, GLuint program)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->BindProgramARB(target, program);
}

inline void QOpenGLExtension_ARB_vertex_program::glProgramStringARB(GLenum target, GLenum format, GLsizei len, const GLvoid *string)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->ProgramStringARB(target, format, len, string);
}

inline void QOpenGLExtension_ARB_vertex_program::glDisableVertexAttribArrayARB(GLuint index)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->DisableVertexAttribArrayARB(index);
}

inline void QOpenGLExtension_ARB_vertex_program::glEnableVertexAttribArrayARB(GLuint index)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->EnableVertexAttribArrayARB(index);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttribPointerARB(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid *pointer)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttribPointerARB(index, size, type, normalized, stride, pointer);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib4usvARB(GLuint index, const GLushort *v)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib4usvARB(index, v);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib4uivARB(GLuint index, const GLuint *v)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib4uivARB(index, v);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib4ubvARB(GLuint index, const GLubyte *v)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib4ubvARB(index, v);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib4svARB(GLuint index, const GLshort *v)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib4svARB(index, v);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib4sARB(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib4sARB(index, x, y, z, w);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib4ivARB(GLuint index, const GLint *v)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib4ivARB(index, v);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib4fvARB(GLuint index, const GLfloat *v)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib4fvARB(index, v);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib4fARB(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib4fARB(index, x, y, z, w);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib4dvARB(GLuint index, const GLdouble *v)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib4dvARB(index, v);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib4dARB(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib4dARB(index, x, y, z, w);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib4bvARB(GLuint index, const GLbyte *v)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib4bvARB(index, v);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib4NusvARB(GLuint index, const GLushort *v)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib4NusvARB(index, v);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib4NuivARB(GLuint index, const GLuint *v)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib4NuivARB(index, v);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib4NubvARB(GLuint index, const GLubyte *v)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib4NubvARB(index, v);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib4NubARB(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib4NubARB(index, x, y, z, w);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib4NsvARB(GLuint index, const GLshort *v)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib4NsvARB(index, v);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib4NivARB(GLuint index, const GLint *v)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib4NivARB(index, v);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib4NbvARB(GLuint index, const GLbyte *v)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib4NbvARB(index, v);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib3svARB(GLuint index, const GLshort *v)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib3svARB(index, v);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib3sARB(GLuint index, GLshort x, GLshort y, GLshort z)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib3sARB(index, x, y, z);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib3fvARB(GLuint index, const GLfloat *v)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib3fvARB(index, v);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib3fARB(GLuint index, GLfloat x, GLfloat y, GLfloat z)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib3fARB(index, x, y, z);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib3dvARB(GLuint index, const GLdouble *v)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib3dvARB(index, v);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib3dARB(GLuint index, GLdouble x, GLdouble y, GLdouble z)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib3dARB(index, x, y, z);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib2svARB(GLuint index, const GLshort *v)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib2svARB(index, v);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib2sARB(GLuint index, GLshort x, GLshort y)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib2sARB(index, x, y);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib2fvARB(GLuint index, const GLfloat *v)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib2fvARB(index, v);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib2fARB(GLuint index, GLfloat x, GLfloat y)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib2fARB(index, x, y);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib2dvARB(GLuint index, const GLdouble *v)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib2dvARB(index, v);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib2dARB(GLuint index, GLdouble x, GLdouble y)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib2dARB(index, x, y);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib1svARB(GLuint index, const GLshort *v)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib1svARB(index, v);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib1sARB(GLuint index, GLshort x)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib1sARB(index, x);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib1fvARB(GLuint index, const GLfloat *v)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib1fvARB(index, v);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib1fARB(GLuint index, GLfloat x)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib1fARB(index, x);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib1dvARB(GLuint index, const GLdouble *v)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib1dvARB(index, v);
}

inline void QOpenGLExtension_ARB_vertex_program::glVertexAttrib1dARB(GLuint index, GLdouble x)
{
    Q_D(QOpenGLExtension_ARB_vertex_program);
    d->VertexAttrib1dARB(index, x);
}

class QOpenGLExtension_ARB_vertex_shaderPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    GLint (QOPENGLF_APIENTRYP GetAttribLocationARB)(GLhandleARB programObj, const GLcharARB *name);
    void (QOPENGLF_APIENTRYP GetActiveAttribARB)(GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei *length, GLint *size, GLenum *type, GLcharARB *name);
    void (QOPENGLF_APIENTRYP BindAttribLocationARB)(GLhandleARB programObj, GLuint index, const GLcharARB *name);
};

class QOpenGLExtension_ARB_vertex_shader : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_vertex_shader();

    bool initializeOpenGLFunctions() final;

    GLint glGetAttribLocationARB(GLhandleARB programObj, const GLcharARB *name);
    void glGetActiveAttribARB(GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei *length, GLint *size, GLenum *type, GLcharARB *name);
    void glBindAttribLocationARB(GLhandleARB programObj, GLuint index, const GLcharARB *name);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_vertex_shader)
};

inline GLint QOpenGLExtension_ARB_vertex_shader::glGetAttribLocationARB(GLhandleARB programObj, const GLcharARB *name)
{
    Q_D(QOpenGLExtension_ARB_vertex_shader);
    return d->GetAttribLocationARB(programObj, name);
}

inline void QOpenGLExtension_ARB_vertex_shader::glGetActiveAttribARB(GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei *length, GLint *size, GLenum *type, GLcharARB *name)
{
    Q_D(QOpenGLExtension_ARB_vertex_shader);
    d->GetActiveAttribARB(programObj, index, maxLength, length, size, type, name);
}

inline void QOpenGLExtension_ARB_vertex_shader::glBindAttribLocationARB(GLhandleARB programObj, GLuint index, const GLcharARB *name)
{
    Q_D(QOpenGLExtension_ARB_vertex_shader);
    d->BindAttribLocationARB(programObj, index, name);
}

class QOpenGLExtension_ARB_vertex_type_2_10_10_10_revPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP VertexAttribP4uiv)(GLuint index, GLenum type, GLboolean normalized, const GLuint *value);
    void (QOPENGLF_APIENTRYP VertexAttribP4ui)(GLuint index, GLenum type, GLboolean normalized, GLuint value);
    void (QOPENGLF_APIENTRYP VertexAttribP3uiv)(GLuint index, GLenum type, GLboolean normalized, const GLuint *value);
    void (QOPENGLF_APIENTRYP VertexAttribP3ui)(GLuint index, GLenum type, GLboolean normalized, GLuint value);
    void (QOPENGLF_APIENTRYP VertexAttribP2uiv)(GLuint index, GLenum type, GLboolean normalized, const GLuint *value);
    void (QOPENGLF_APIENTRYP VertexAttribP2ui)(GLuint index, GLenum type, GLboolean normalized, GLuint value);
    void (QOPENGLF_APIENTRYP VertexAttribP1uiv)(GLuint index, GLenum type, GLboolean normalized, const GLuint *value);
    void (QOPENGLF_APIENTRYP VertexAttribP1ui)(GLuint index, GLenum type, GLboolean normalized, GLuint value);
    void (QOPENGLF_APIENTRYP SecondaryColorP3uiv)(GLenum type, const GLuint *color);
    void (QOPENGLF_APIENTRYP SecondaryColorP3ui)(GLenum type, GLuint color);
    void (QOPENGLF_APIENTRYP ColorP4uiv)(GLenum type, const GLuint *color);
    void (QOPENGLF_APIENTRYP ColorP4ui)(GLenum type, GLuint color);
    void (QOPENGLF_APIENTRYP ColorP3uiv)(GLenum type, const GLuint *color);
    void (QOPENGLF_APIENTRYP ColorP3ui)(GLenum type, GLuint color);
    void (QOPENGLF_APIENTRYP NormalP3uiv)(GLenum type, const GLuint *coords);
    void (QOPENGLF_APIENTRYP NormalP3ui)(GLenum type, GLuint coords);
    void (QOPENGLF_APIENTRYP MultiTexCoordP4uiv)(GLenum texture, GLenum type, const GLuint *coords);
    void (QOPENGLF_APIENTRYP MultiTexCoordP4ui)(GLenum texture, GLenum type, GLuint coords);
    void (QOPENGLF_APIENTRYP MultiTexCoordP3uiv)(GLenum texture, GLenum type, const GLuint *coords);
    void (QOPENGLF_APIENTRYP MultiTexCoordP3ui)(GLenum texture, GLenum type, GLuint coords);
    void (QOPENGLF_APIENTRYP MultiTexCoordP2uiv)(GLenum texture, GLenum type, const GLuint *coords);
    void (QOPENGLF_APIENTRYP MultiTexCoordP2ui)(GLenum texture, GLenum type, GLuint coords);
    void (QOPENGLF_APIENTRYP MultiTexCoordP1uiv)(GLenum texture, GLenum type, const GLuint *coords);
    void (QOPENGLF_APIENTRYP MultiTexCoordP1ui)(GLenum texture, GLenum type, GLuint coords);
    void (QOPENGLF_APIENTRYP TexCoordP4uiv)(GLenum type, const GLuint *coords);
    void (QOPENGLF_APIENTRYP TexCoordP4ui)(GLenum type, GLuint coords);
    void (QOPENGLF_APIENTRYP TexCoordP3uiv)(GLenum type, const GLuint *coords);
    void (QOPENGLF_APIENTRYP TexCoordP3ui)(GLenum type, GLuint coords);
    void (QOPENGLF_APIENTRYP TexCoordP2uiv)(GLenum type, const GLuint *coords);
    void (QOPENGLF_APIENTRYP TexCoordP2ui)(GLenum type, GLuint coords);
    void (QOPENGLF_APIENTRYP TexCoordP1uiv)(GLenum type, const GLuint *coords);
    void (QOPENGLF_APIENTRYP TexCoordP1ui)(GLenum type, GLuint coords);
    void (QOPENGLF_APIENTRYP VertexP4uiv)(GLenum type, const GLuint *value);
    void (QOPENGLF_APIENTRYP VertexP4ui)(GLenum type, GLuint value);
    void (QOPENGLF_APIENTRYP VertexP3uiv)(GLenum type, const GLuint *value);
    void (QOPENGLF_APIENTRYP VertexP3ui)(GLenum type, GLuint value);
    void (QOPENGLF_APIENTRYP VertexP2uiv)(GLenum type, const GLuint *value);
    void (QOPENGLF_APIENTRYP VertexP2ui)(GLenum type, GLuint value);
};

class QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev();

    bool initializeOpenGLFunctions() final;

    void glVertexAttribP4uiv(GLuint index, GLenum type, GLboolean normalized, const GLuint *value);
    void glVertexAttribP4ui(GLuint index, GLenum type, GLboolean normalized, GLuint value);
    void glVertexAttribP3uiv(GLuint index, GLenum type, GLboolean normalized, const GLuint *value);
    void glVertexAttribP3ui(GLuint index, GLenum type, GLboolean normalized, GLuint value);
    void glVertexAttribP2uiv(GLuint index, GLenum type, GLboolean normalized, const GLuint *value);
    void glVertexAttribP2ui(GLuint index, GLenum type, GLboolean normalized, GLuint value);
    void glVertexAttribP1uiv(GLuint index, GLenum type, GLboolean normalized, const GLuint *value);
    void glVertexAttribP1ui(GLuint index, GLenum type, GLboolean normalized, GLuint value);
    void glSecondaryColorP3uiv(GLenum type, const GLuint *color);
    void glSecondaryColorP3ui(GLenum type, GLuint color);
    void glColorP4uiv(GLenum type, const GLuint *color);
    void glColorP4ui(GLenum type, GLuint color);
    void glColorP3uiv(GLenum type, const GLuint *color);
    void glColorP3ui(GLenum type, GLuint color);
    void glNormalP3uiv(GLenum type, const GLuint *coords);
    void glNormalP3ui(GLenum type, GLuint coords);
    void glMultiTexCoordP4uiv(GLenum texture, GLenum type, const GLuint *coords);
    void glMultiTexCoordP4ui(GLenum texture, GLenum type, GLuint coords);
    void glMultiTexCoordP3uiv(GLenum texture, GLenum type, const GLuint *coords);
    void glMultiTexCoordP3ui(GLenum texture, GLenum type, GLuint coords);
    void glMultiTexCoordP2uiv(GLenum texture, GLenum type, const GLuint *coords);
    void glMultiTexCoordP2ui(GLenum texture, GLenum type, GLuint coords);
    void glMultiTexCoordP1uiv(GLenum texture, GLenum type, const GLuint *coords);
    void glMultiTexCoordP1ui(GLenum texture, GLenum type, GLuint coords);
    void glTexCoordP4uiv(GLenum type, const GLuint *coords);
    void glTexCoordP4ui(GLenum type, GLuint coords);
    void glTexCoordP3uiv(GLenum type, const GLuint *coords);
    void glTexCoordP3ui(GLenum type, GLuint coords);
    void glTexCoordP2uiv(GLenum type, const GLuint *coords);
    void glTexCoordP2ui(GLenum type, GLuint coords);
    void glTexCoordP1uiv(GLenum type, const GLuint *coords);
    void glTexCoordP1ui(GLenum type, GLuint coords);
    void glVertexP4uiv(GLenum type, const GLuint *value);
    void glVertexP4ui(GLenum type, GLuint value);
    void glVertexP3uiv(GLenum type, const GLuint *value);
    void glVertexP3ui(GLenum type, GLuint value);
    void glVertexP2uiv(GLenum type, const GLuint *value);
    void glVertexP2ui(GLenum type, GLuint value);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev)
};

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glVertexAttribP4uiv(GLuint index, GLenum type, GLboolean normalized, const GLuint *value)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->VertexAttribP4uiv(index, type, normalized, value);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glVertexAttribP4ui(GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->VertexAttribP4ui(index, type, normalized, value);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glVertexAttribP3uiv(GLuint index, GLenum type, GLboolean normalized, const GLuint *value)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->VertexAttribP3uiv(index, type, normalized, value);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glVertexAttribP3ui(GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->VertexAttribP3ui(index, type, normalized, value);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glVertexAttribP2uiv(GLuint index, GLenum type, GLboolean normalized, const GLuint *value)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->VertexAttribP2uiv(index, type, normalized, value);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glVertexAttribP2ui(GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->VertexAttribP2ui(index, type, normalized, value);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glVertexAttribP1uiv(GLuint index, GLenum type, GLboolean normalized, const GLuint *value)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->VertexAttribP1uiv(index, type, normalized, value);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glVertexAttribP1ui(GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->VertexAttribP1ui(index, type, normalized, value);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glSecondaryColorP3uiv(GLenum type, const GLuint *color)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->SecondaryColorP3uiv(type, color);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glSecondaryColorP3ui(GLenum type, GLuint color)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->SecondaryColorP3ui(type, color);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glColorP4uiv(GLenum type, const GLuint *color)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->ColorP4uiv(type, color);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glColorP4ui(GLenum type, GLuint color)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->ColorP4ui(type, color);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glColorP3uiv(GLenum type, const GLuint *color)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->ColorP3uiv(type, color);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glColorP3ui(GLenum type, GLuint color)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->ColorP3ui(type, color);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glNormalP3uiv(GLenum type, const GLuint *coords)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->NormalP3uiv(type, coords);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glNormalP3ui(GLenum type, GLuint coords)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->NormalP3ui(type, coords);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glMultiTexCoordP4uiv(GLenum texture, GLenum type, const GLuint *coords)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->MultiTexCoordP4uiv(texture, type, coords);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glMultiTexCoordP4ui(GLenum texture, GLenum type, GLuint coords)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->MultiTexCoordP4ui(texture, type, coords);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glMultiTexCoordP3uiv(GLenum texture, GLenum type, const GLuint *coords)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->MultiTexCoordP3uiv(texture, type, coords);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glMultiTexCoordP3ui(GLenum texture, GLenum type, GLuint coords)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->MultiTexCoordP3ui(texture, type, coords);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glMultiTexCoordP2uiv(GLenum texture, GLenum type, const GLuint *coords)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->MultiTexCoordP2uiv(texture, type, coords);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glMultiTexCoordP2ui(GLenum texture, GLenum type, GLuint coords)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->MultiTexCoordP2ui(texture, type, coords);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glMultiTexCoordP1uiv(GLenum texture, GLenum type, const GLuint *coords)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->MultiTexCoordP1uiv(texture, type, coords);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glMultiTexCoordP1ui(GLenum texture, GLenum type, GLuint coords)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->MultiTexCoordP1ui(texture, type, coords);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glTexCoordP4uiv(GLenum type, const GLuint *coords)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->TexCoordP4uiv(type, coords);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glTexCoordP4ui(GLenum type, GLuint coords)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->TexCoordP4ui(type, coords);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glTexCoordP3uiv(GLenum type, const GLuint *coords)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->TexCoordP3uiv(type, coords);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glTexCoordP3ui(GLenum type, GLuint coords)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->TexCoordP3ui(type, coords);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glTexCoordP2uiv(GLenum type, const GLuint *coords)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->TexCoordP2uiv(type, coords);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glTexCoordP2ui(GLenum type, GLuint coords)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->TexCoordP2ui(type, coords);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glTexCoordP1uiv(GLenum type, const GLuint *coords)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->TexCoordP1uiv(type, coords);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glTexCoordP1ui(GLenum type, GLuint coords)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->TexCoordP1ui(type, coords);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glVertexP4uiv(GLenum type, const GLuint *value)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->VertexP4uiv(type, value);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glVertexP4ui(GLenum type, GLuint value)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->VertexP4ui(type, value);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glVertexP3uiv(GLenum type, const GLuint *value)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->VertexP3uiv(type, value);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glVertexP3ui(GLenum type, GLuint value)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->VertexP3ui(type, value);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glVertexP2uiv(GLenum type, const GLuint *value)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->VertexP2uiv(type, value);
}

inline void QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::glVertexP2ui(GLenum type, GLuint value)
{
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);
    d->VertexP2ui(type, value);
}

class QOpenGLExtension_ARB_viewport_arrayPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetDoublei_v)(GLenum target, GLuint index, GLdouble *data);
    void (QOPENGLF_APIENTRYP GetFloati_v)(GLenum target, GLuint index, GLfloat *data);
    void (QOPENGLF_APIENTRYP DepthRangeIndexed)(GLuint index, GLdouble n, GLdouble f);
    void (QOPENGLF_APIENTRYP DepthRangeArrayv)(GLuint first, GLsizei count, const GLdouble *v);
    void (QOPENGLF_APIENTRYP ScissorIndexedv)(GLuint index, const GLint *v);
    void (QOPENGLF_APIENTRYP ScissorIndexed)(GLuint index, GLint left, GLint bottom, GLsizei width, GLsizei height);
    void (QOPENGLF_APIENTRYP ScissorArrayv)(GLuint first, GLsizei count, const GLint *v);
    void (QOPENGLF_APIENTRYP ViewportIndexedfv)(GLuint index, const GLfloat *v);
    void (QOPENGLF_APIENTRYP ViewportIndexedf)(GLuint index, GLfloat x, GLfloat y, GLfloat w, GLfloat h);
    void (QOPENGLF_APIENTRYP ViewportArrayv)(GLuint first, GLsizei count, const GLfloat *v);
};

class QOpenGLExtension_ARB_viewport_array : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_viewport_array();

    bool initializeOpenGLFunctions() final;

    void glGetDoublei_v(GLenum target, GLuint index, GLdouble *data);
    void glGetFloati_v(GLenum target, GLuint index, GLfloat *data);
    void glDepthRangeIndexed(GLuint index, GLdouble n, GLdouble f);
    void glDepthRangeArrayv(GLuint first, GLsizei count, const GLdouble *v);
    void glScissorIndexedv(GLuint index, const GLint *v);
    void glScissorIndexed(GLuint index, GLint left, GLint bottom, GLsizei width, GLsizei height);
    void glScissorArrayv(GLuint first, GLsizei count, const GLint *v);
    void glViewportIndexedfv(GLuint index, const GLfloat *v);
    void glViewportIndexedf(GLuint index, GLfloat x, GLfloat y, GLfloat w, GLfloat h);
    void glViewportArrayv(GLuint first, GLsizei count, const GLfloat *v);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_viewport_array)
};

inline void QOpenGLExtension_ARB_viewport_array::glGetDoublei_v(GLenum target, GLuint index, GLdouble *data)
{
    Q_D(QOpenGLExtension_ARB_viewport_array);
    d->GetDoublei_v(target, index, data);
}

inline void QOpenGLExtension_ARB_viewport_array::glGetFloati_v(GLenum target, GLuint index, GLfloat *data)
{
    Q_D(QOpenGLExtension_ARB_viewport_array);
    d->GetFloati_v(target, index, data);
}

inline void QOpenGLExtension_ARB_viewport_array::glDepthRangeIndexed(GLuint index, GLdouble n, GLdouble f)
{
    Q_D(QOpenGLExtension_ARB_viewport_array);
    d->DepthRangeIndexed(index, n, f);
}

inline void QOpenGLExtension_ARB_viewport_array::glDepthRangeArrayv(GLuint first, GLsizei count, const GLdouble *v)
{
    Q_D(QOpenGLExtension_ARB_viewport_array);
    d->DepthRangeArrayv(first, count, v);
}

inline void QOpenGLExtension_ARB_viewport_array::glScissorIndexedv(GLuint index, const GLint *v)
{
    Q_D(QOpenGLExtension_ARB_viewport_array);
    d->ScissorIndexedv(index, v);
}

inline void QOpenGLExtension_ARB_viewport_array::glScissorIndexed(GLuint index, GLint left, GLint bottom, GLsizei width, GLsizei height)
{
    Q_D(QOpenGLExtension_ARB_viewport_array);
    d->ScissorIndexed(index, left, bottom, width, height);
}

inline void QOpenGLExtension_ARB_viewport_array::glScissorArrayv(GLuint first, GLsizei count, const GLint *v)
{
    Q_D(QOpenGLExtension_ARB_viewport_array);
    d->ScissorArrayv(first, count, v);
}

inline void QOpenGLExtension_ARB_viewport_array::glViewportIndexedfv(GLuint index, const GLfloat *v)
{
    Q_D(QOpenGLExtension_ARB_viewport_array);
    d->ViewportIndexedfv(index, v);
}

inline void QOpenGLExtension_ARB_viewport_array::glViewportIndexedf(GLuint index, GLfloat x, GLfloat y, GLfloat w, GLfloat h)
{
    Q_D(QOpenGLExtension_ARB_viewport_array);
    d->ViewportIndexedf(index, x, y, w, h);
}

inline void QOpenGLExtension_ARB_viewport_array::glViewportArrayv(GLuint first, GLsizei count, const GLfloat *v)
{
    Q_D(QOpenGLExtension_ARB_viewport_array);
    d->ViewportArrayv(first, count, v);
}

class QOpenGLExtension_ARB_window_posPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP WindowPos3svARB)(const GLshort *v);
    void (QOPENGLF_APIENTRYP WindowPos3sARB)(GLshort x, GLshort y, GLshort z);
    void (QOPENGLF_APIENTRYP WindowPos3ivARB)(const GLint *v);
    void (QOPENGLF_APIENTRYP WindowPos3iARB)(GLint x, GLint y, GLint z);
    void (QOPENGLF_APIENTRYP WindowPos3fvARB)(const GLfloat *v);
    void (QOPENGLF_APIENTRYP WindowPos3fARB)(GLfloat x, GLfloat y, GLfloat z);
    void (QOPENGLF_APIENTRYP WindowPos3dvARB)(const GLdouble *v);
    void (QOPENGLF_APIENTRYP WindowPos3dARB)(GLdouble x, GLdouble y, GLdouble z);
    void (QOPENGLF_APIENTRYP WindowPos2svARB)(const GLshort *v);
    void (QOPENGLF_APIENTRYP WindowPos2sARB)(GLshort x, GLshort y);
    void (QOPENGLF_APIENTRYP WindowPos2ivARB)(const GLint *v);
    void (QOPENGLF_APIENTRYP WindowPos2iARB)(GLint x, GLint y);
    void (QOPENGLF_APIENTRYP WindowPos2fvARB)(const GLfloat *v);
    void (QOPENGLF_APIENTRYP WindowPos2fARB)(GLfloat x, GLfloat y);
    void (QOPENGLF_APIENTRYP WindowPos2dvARB)(const GLdouble *v);
    void (QOPENGLF_APIENTRYP WindowPos2dARB)(GLdouble x, GLdouble y);
};

class QOpenGLExtension_ARB_window_pos : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ARB_window_pos();

    bool initializeOpenGLFunctions() final;

    void glWindowPos3svARB(const GLshort *v);
    void glWindowPos3sARB(GLshort x, GLshort y, GLshort z);
    void glWindowPos3ivARB(const GLint *v);
    void glWindowPos3iARB(GLint x, GLint y, GLint z);
    void glWindowPos3fvARB(const GLfloat *v);
    void glWindowPos3fARB(GLfloat x, GLfloat y, GLfloat z);
    void glWindowPos3dvARB(const GLdouble *v);
    void glWindowPos3dARB(GLdouble x, GLdouble y, GLdouble z);
    void glWindowPos2svARB(const GLshort *v);
    void glWindowPos2sARB(GLshort x, GLshort y);
    void glWindowPos2ivARB(const GLint *v);
    void glWindowPos2iARB(GLint x, GLint y);
    void glWindowPos2fvARB(const GLfloat *v);
    void glWindowPos2fARB(GLfloat x, GLfloat y);
    void glWindowPos2dvARB(const GLdouble *v);
    void glWindowPos2dARB(GLdouble x, GLdouble y);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ARB_window_pos)
};

inline void QOpenGLExtension_ARB_window_pos::glWindowPos3svARB(const GLshort *v)
{
    Q_D(QOpenGLExtension_ARB_window_pos);
    d->WindowPos3svARB(v);
}

inline void QOpenGLExtension_ARB_window_pos::glWindowPos3sARB(GLshort x, GLshort y, GLshort z)
{
    Q_D(QOpenGLExtension_ARB_window_pos);
    d->WindowPos3sARB(x, y, z);
}

inline void QOpenGLExtension_ARB_window_pos::glWindowPos3ivARB(const GLint *v)
{
    Q_D(QOpenGLExtension_ARB_window_pos);
    d->WindowPos3ivARB(v);
}

inline void QOpenGLExtension_ARB_window_pos::glWindowPos3iARB(GLint x, GLint y, GLint z)
{
    Q_D(QOpenGLExtension_ARB_window_pos);
    d->WindowPos3iARB(x, y, z);
}

inline void QOpenGLExtension_ARB_window_pos::glWindowPos3fvARB(const GLfloat *v)
{
    Q_D(QOpenGLExtension_ARB_window_pos);
    d->WindowPos3fvARB(v);
}

inline void QOpenGLExtension_ARB_window_pos::glWindowPos3fARB(GLfloat x, GLfloat y, GLfloat z)
{
    Q_D(QOpenGLExtension_ARB_window_pos);
    d->WindowPos3fARB(x, y, z);
}

inline void QOpenGLExtension_ARB_window_pos::glWindowPos3dvARB(const GLdouble *v)
{
    Q_D(QOpenGLExtension_ARB_window_pos);
    d->WindowPos3dvARB(v);
}

inline void QOpenGLExtension_ARB_window_pos::glWindowPos3dARB(GLdouble x, GLdouble y, GLdouble z)
{
    Q_D(QOpenGLExtension_ARB_window_pos);
    d->WindowPos3dARB(x, y, z);
}

inline void QOpenGLExtension_ARB_window_pos::glWindowPos2svARB(const GLshort *v)
{
    Q_D(QOpenGLExtension_ARB_window_pos);
    d->WindowPos2svARB(v);
}

inline void QOpenGLExtension_ARB_window_pos::glWindowPos2sARB(GLshort x, GLshort y)
{
    Q_D(QOpenGLExtension_ARB_window_pos);
    d->WindowPos2sARB(x, y);
}

inline void QOpenGLExtension_ARB_window_pos::glWindowPos2ivARB(const GLint *v)
{
    Q_D(QOpenGLExtension_ARB_window_pos);
    d->WindowPos2ivARB(v);
}

inline void QOpenGLExtension_ARB_window_pos::glWindowPos2iARB(GLint x, GLint y)
{
    Q_D(QOpenGLExtension_ARB_window_pos);
    d->WindowPos2iARB(x, y);
}

inline void QOpenGLExtension_ARB_window_pos::glWindowPos2fvARB(const GLfloat *v)
{
    Q_D(QOpenGLExtension_ARB_window_pos);
    d->WindowPos2fvARB(v);
}

inline void QOpenGLExtension_ARB_window_pos::glWindowPos2fARB(GLfloat x, GLfloat y)
{
    Q_D(QOpenGLExtension_ARB_window_pos);
    d->WindowPos2fARB(x, y);
}

inline void QOpenGLExtension_ARB_window_pos::glWindowPos2dvARB(const GLdouble *v)
{
    Q_D(QOpenGLExtension_ARB_window_pos);
    d->WindowPos2dvARB(v);
}

inline void QOpenGLExtension_ARB_window_pos::glWindowPos2dARB(GLdouble x, GLdouble y)
{
    Q_D(QOpenGLExtension_ARB_window_pos);
    d->WindowPos2dARB(x, y);
}

class QOpenGLExtension_ATI_draw_buffersPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP DrawBuffersATI)(GLsizei n, const GLenum *bufs);
};

class QOpenGLExtension_ATI_draw_buffers : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ATI_draw_buffers();

    bool initializeOpenGLFunctions() final;

    void glDrawBuffersATI(GLsizei n, const GLenum *bufs);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ATI_draw_buffers)
};

inline void QOpenGLExtension_ATI_draw_buffers::glDrawBuffersATI(GLsizei n, const GLenum *bufs)
{
    Q_D(QOpenGLExtension_ATI_draw_buffers);
    d->DrawBuffersATI(n, bufs);
}

class QOpenGLExtension_ATI_element_arrayPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP DrawRangeElementArrayATI)(GLenum mode, GLuint start, GLuint end, GLsizei count);
    void (QOPENGLF_APIENTRYP DrawElementArrayATI)(GLenum mode, GLsizei count);
    void (QOPENGLF_APIENTRYP ElementPointerATI)(GLenum type, const GLvoid *pointer);
};

class QOpenGLExtension_ATI_element_array : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ATI_element_array();

    bool initializeOpenGLFunctions() final;

    void glDrawRangeElementArrayATI(GLenum mode, GLuint start, GLuint end, GLsizei count);
    void glDrawElementArrayATI(GLenum mode, GLsizei count);
    void glElementPointerATI(GLenum type, const GLvoid *pointer);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ATI_element_array)
};

inline void QOpenGLExtension_ATI_element_array::glDrawRangeElementArrayATI(GLenum mode, GLuint start, GLuint end, GLsizei count)
{
    Q_D(QOpenGLExtension_ATI_element_array);
    d->DrawRangeElementArrayATI(mode, start, end, count);
}

inline void QOpenGLExtension_ATI_element_array::glDrawElementArrayATI(GLenum mode, GLsizei count)
{
    Q_D(QOpenGLExtension_ATI_element_array);
    d->DrawElementArrayATI(mode, count);
}

inline void QOpenGLExtension_ATI_element_array::glElementPointerATI(GLenum type, const GLvoid *pointer)
{
    Q_D(QOpenGLExtension_ATI_element_array);
    d->ElementPointerATI(type, pointer);
}

class QOpenGLExtension_ATI_envmap_bumpmapPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetTexBumpParameterfvATI)(GLenum pname, GLfloat *param);
    void (QOPENGLF_APIENTRYP GetTexBumpParameterivATI)(GLenum pname, GLint *param);
    void (QOPENGLF_APIENTRYP TexBumpParameterfvATI)(GLenum pname, const GLfloat *param);
    void (QOPENGLF_APIENTRYP TexBumpParameterivATI)(GLenum pname, const GLint *param);
};

class QOpenGLExtension_ATI_envmap_bumpmap : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ATI_envmap_bumpmap();

    bool initializeOpenGLFunctions() final;

    void glGetTexBumpParameterfvATI(GLenum pname, GLfloat *param);
    void glGetTexBumpParameterivATI(GLenum pname, GLint *param);
    void glTexBumpParameterfvATI(GLenum pname, const GLfloat *param);
    void glTexBumpParameterivATI(GLenum pname, const GLint *param);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ATI_envmap_bumpmap)
};

inline void QOpenGLExtension_ATI_envmap_bumpmap::glGetTexBumpParameterfvATI(GLenum pname, GLfloat *param)
{
    Q_D(QOpenGLExtension_ATI_envmap_bumpmap);
    d->GetTexBumpParameterfvATI(pname, param);
}

inline void QOpenGLExtension_ATI_envmap_bumpmap::glGetTexBumpParameterivATI(GLenum pname, GLint *param)
{
    Q_D(QOpenGLExtension_ATI_envmap_bumpmap);
    d->GetTexBumpParameterivATI(pname, param);
}

inline void QOpenGLExtension_ATI_envmap_bumpmap::glTexBumpParameterfvATI(GLenum pname, const GLfloat *param)
{
    Q_D(QOpenGLExtension_ATI_envmap_bumpmap);
    d->TexBumpParameterfvATI(pname, param);
}

inline void QOpenGLExtension_ATI_envmap_bumpmap::glTexBumpParameterivATI(GLenum pname, const GLint *param)
{
    Q_D(QOpenGLExtension_ATI_envmap_bumpmap);
    d->TexBumpParameterivATI(pname, param);
}

class QOpenGLExtension_ATI_fragment_shaderPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP SetFragmentShaderConstantATI)(GLuint dst, const GLfloat *value);
    void (QOPENGLF_APIENTRYP AlphaFragmentOp3ATI)(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod);
    void (QOPENGLF_APIENTRYP AlphaFragmentOp2ATI)(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod);
    void (QOPENGLF_APIENTRYP AlphaFragmentOp1ATI)(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod);
    void (QOPENGLF_APIENTRYP ColorFragmentOp3ATI)(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod);
    void (QOPENGLF_APIENTRYP ColorFragmentOp2ATI)(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod);
    void (QOPENGLF_APIENTRYP ColorFragmentOp1ATI)(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod);
    void (QOPENGLF_APIENTRYP SampleMapATI)(GLuint dst, GLuint interp, GLenum swizzle);
    void (QOPENGLF_APIENTRYP PassTexCoordATI)(GLuint dst, GLuint coord, GLenum swizzle);
    void (QOPENGLF_APIENTRYP EndFragmentShaderATI)();
    void (QOPENGLF_APIENTRYP BeginFragmentShaderATI)();
    void (QOPENGLF_APIENTRYP DeleteFragmentShaderATI)(GLuint id);
    void (QOPENGLF_APIENTRYP BindFragmentShaderATI)(GLuint id);
    GLuint (QOPENGLF_APIENTRYP GenFragmentShadersATI)(GLuint range);
};

class QOpenGLExtension_ATI_fragment_shader : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ATI_fragment_shader();

    bool initializeOpenGLFunctions() final;

    void glSetFragmentShaderConstantATI(GLuint dst, const GLfloat *value);
    void glAlphaFragmentOp3ATI(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod);
    void glAlphaFragmentOp2ATI(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod);
    void glAlphaFragmentOp1ATI(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod);
    void glColorFragmentOp3ATI(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod);
    void glColorFragmentOp2ATI(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod);
    void glColorFragmentOp1ATI(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod);
    void glSampleMapATI(GLuint dst, GLuint interp, GLenum swizzle);
    void glPassTexCoordATI(GLuint dst, GLuint coord, GLenum swizzle);
    void glEndFragmentShaderATI();
    void glBeginFragmentShaderATI();
    void glDeleteFragmentShaderATI(GLuint id);
    void glBindFragmentShaderATI(GLuint id);
    GLuint glGenFragmentShadersATI(GLuint range);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ATI_fragment_shader)
};

inline void QOpenGLExtension_ATI_fragment_shader::glSetFragmentShaderConstantATI(GLuint dst, const GLfloat *value)
{
    Q_D(QOpenGLExtension_ATI_fragment_shader);
    d->SetFragmentShaderConstantATI(dst, value);
}

inline void QOpenGLExtension_ATI_fragment_shader::glAlphaFragmentOp3ATI(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod)
{
    Q_D(QOpenGLExtension_ATI_fragment_shader);
    d->AlphaFragmentOp3ATI(op, dst, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod, arg3, arg3Rep, arg3Mod);
}

inline void QOpenGLExtension_ATI_fragment_shader::glAlphaFragmentOp2ATI(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod)
{
    Q_D(QOpenGLExtension_ATI_fragment_shader);
    d->AlphaFragmentOp2ATI(op, dst, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod);
}

inline void QOpenGLExtension_ATI_fragment_shader::glAlphaFragmentOp1ATI(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod)
{
    Q_D(QOpenGLExtension_ATI_fragment_shader);
    d->AlphaFragmentOp1ATI(op, dst, dstMod, arg1, arg1Rep, arg1Mod);
}

inline void QOpenGLExtension_ATI_fragment_shader::glColorFragmentOp3ATI(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod)
{
    Q_D(QOpenGLExtension_ATI_fragment_shader);
    d->ColorFragmentOp3ATI(op, dst, dstMask, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod, arg3, arg3Rep, arg3Mod);
}

inline void QOpenGLExtension_ATI_fragment_shader::glColorFragmentOp2ATI(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod)
{
    Q_D(QOpenGLExtension_ATI_fragment_shader);
    d->ColorFragmentOp2ATI(op, dst, dstMask, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod);
}

inline void QOpenGLExtension_ATI_fragment_shader::glColorFragmentOp1ATI(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod)
{
    Q_D(QOpenGLExtension_ATI_fragment_shader);
    d->ColorFragmentOp1ATI(op, dst, dstMask, dstMod, arg1, arg1Rep, arg1Mod);
}

inline void QOpenGLExtension_ATI_fragment_shader::glSampleMapATI(GLuint dst, GLuint interp, GLenum swizzle)
{
    Q_D(QOpenGLExtension_ATI_fragment_shader);
    d->SampleMapATI(dst, interp, swizzle);
}

inline void QOpenGLExtension_ATI_fragment_shader::glPassTexCoordATI(GLuint dst, GLuint coord, GLenum swizzle)
{
    Q_D(QOpenGLExtension_ATI_fragment_shader);
    d->PassTexCoordATI(dst, coord, swizzle);
}

inline void QOpenGLExtension_ATI_fragment_shader::glEndFragmentShaderATI()
{
    Q_D(QOpenGLExtension_ATI_fragment_shader);
    d->EndFragmentShaderATI();
}

inline void QOpenGLExtension_ATI_fragment_shader::glBeginFragmentShaderATI()
{
    Q_D(QOpenGLExtension_ATI_fragment_shader);
    d->BeginFragmentShaderATI();
}

inline void QOpenGLExtension_ATI_fragment_shader::glDeleteFragmentShaderATI(GLuint id)
{
    Q_D(QOpenGLExtension_ATI_fragment_shader);
    d->DeleteFragmentShaderATI(id);
}

inline void QOpenGLExtension_ATI_fragment_shader::glBindFragmentShaderATI(GLuint id)
{
    Q_D(QOpenGLExtension_ATI_fragment_shader);
    d->BindFragmentShaderATI(id);
}

inline GLuint QOpenGLExtension_ATI_fragment_shader::glGenFragmentShadersATI(GLuint range)
{
    Q_D(QOpenGLExtension_ATI_fragment_shader);
    return d->GenFragmentShadersATI(range);
}

class QOpenGLExtension_ATI_map_object_bufferPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP UnmapObjectBufferATI)(GLuint buffer);
    GLvoid* (QOPENGLF_APIENTRYP MapObjectBufferATI)(GLuint buffer);
};

class QOpenGLExtension_ATI_map_object_buffer : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ATI_map_object_buffer();

    bool initializeOpenGLFunctions() final;

    void glUnmapObjectBufferATI(GLuint buffer);
    GLvoid* glMapObjectBufferATI(GLuint buffer);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ATI_map_object_buffer)
};

inline void QOpenGLExtension_ATI_map_object_buffer::glUnmapObjectBufferATI(GLuint buffer)
{
    Q_D(QOpenGLExtension_ATI_map_object_buffer);
    d->UnmapObjectBufferATI(buffer);
}

inline GLvoid* QOpenGLExtension_ATI_map_object_buffer::glMapObjectBufferATI(GLuint buffer)
{
    Q_D(QOpenGLExtension_ATI_map_object_buffer);
    return d->MapObjectBufferATI(buffer);
}

class QOpenGLExtension_ATI_pn_trianglesPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP PNTrianglesfATI)(GLenum pname, GLfloat param);
    void (QOPENGLF_APIENTRYP PNTrianglesiATI)(GLenum pname, GLint param);
};

class QOpenGLExtension_ATI_pn_triangles : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ATI_pn_triangles();

    bool initializeOpenGLFunctions() final;

    void glPNTrianglesfATI(GLenum pname, GLfloat param);
    void glPNTrianglesiATI(GLenum pname, GLint param);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ATI_pn_triangles)
};

inline void QOpenGLExtension_ATI_pn_triangles::glPNTrianglesfATI(GLenum pname, GLfloat param)
{
    Q_D(QOpenGLExtension_ATI_pn_triangles);
    d->PNTrianglesfATI(pname, param);
}

inline void QOpenGLExtension_ATI_pn_triangles::glPNTrianglesiATI(GLenum pname, GLint param)
{
    Q_D(QOpenGLExtension_ATI_pn_triangles);
    d->PNTrianglesiATI(pname, param);
}

class QOpenGLExtension_ATI_separate_stencilPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP StencilFuncSeparateATI)(GLenum frontfunc, GLenum backfunc, GLint ref, GLuint mask);
    void (QOPENGLF_APIENTRYP StencilOpSeparateATI)(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass);
};

class QOpenGLExtension_ATI_separate_stencil : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ATI_separate_stencil();

    bool initializeOpenGLFunctions() final;

    void glStencilFuncSeparateATI(GLenum frontfunc, GLenum backfunc, GLint ref, GLuint mask);
    void glStencilOpSeparateATI(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ATI_separate_stencil)
};

inline void QOpenGLExtension_ATI_separate_stencil::glStencilFuncSeparateATI(GLenum frontfunc, GLenum backfunc, GLint ref, GLuint mask)
{
    Q_D(QOpenGLExtension_ATI_separate_stencil);
    d->StencilFuncSeparateATI(frontfunc, backfunc, ref, mask);
}

inline void QOpenGLExtension_ATI_separate_stencil::glStencilOpSeparateATI(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass)
{
    Q_D(QOpenGLExtension_ATI_separate_stencil);
    d->StencilOpSeparateATI(face, sfail, dpfail, dppass);
}

class QOpenGLExtension_ATI_vertex_array_objectPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetVariantArrayObjectivATI)(GLuint id, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetVariantArrayObjectfvATI)(GLuint id, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP VariantArrayObjectATI)(GLuint id, GLenum type, GLsizei stride, GLuint buffer, GLuint offset);
    void (QOPENGLF_APIENTRYP GetArrayObjectivATI)(GLenum array, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetArrayObjectfvATI)(GLenum array, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP ArrayObjectATI)(GLenum array, GLint size, GLenum type, GLsizei stride, GLuint buffer, GLuint offset);
    void (QOPENGLF_APIENTRYP FreeObjectBufferATI)(GLuint buffer);
    void (QOPENGLF_APIENTRYP GetObjectBufferivATI)(GLuint buffer, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetObjectBufferfvATI)(GLuint buffer, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP UpdateObjectBufferATI)(GLuint buffer, GLuint offset, GLsizei size, const GLvoid *pointer, GLenum preserve);
    GLboolean (QOPENGLF_APIENTRYP IsObjectBufferATI)(GLuint buffer);
    GLuint (QOPENGLF_APIENTRYP NewObjectBufferATI)(GLsizei size, const GLvoid *pointer, GLenum usage);
};

class QOpenGLExtension_ATI_vertex_array_object : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ATI_vertex_array_object();

    bool initializeOpenGLFunctions() final;

    void glGetVariantArrayObjectivATI(GLuint id, GLenum pname, GLint *params);
    void glGetVariantArrayObjectfvATI(GLuint id, GLenum pname, GLfloat *params);
    void glVariantArrayObjectATI(GLuint id, GLenum type, GLsizei stride, GLuint buffer, GLuint offset);
    void glGetArrayObjectivATI(GLenum array, GLenum pname, GLint *params);
    void glGetArrayObjectfvATI(GLenum array, GLenum pname, GLfloat *params);
    void glArrayObjectATI(GLenum array, GLint size, GLenum type, GLsizei stride, GLuint buffer, GLuint offset);
    void glFreeObjectBufferATI(GLuint buffer);
    void glGetObjectBufferivATI(GLuint buffer, GLenum pname, GLint *params);
    void glGetObjectBufferfvATI(GLuint buffer, GLenum pname, GLfloat *params);
    void glUpdateObjectBufferATI(GLuint buffer, GLuint offset, GLsizei size, const GLvoid *pointer, GLenum preserve);
    GLboolean glIsObjectBufferATI(GLuint buffer);
    GLuint glNewObjectBufferATI(GLsizei size, const GLvoid *pointer, GLenum usage);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ATI_vertex_array_object)
};

inline void QOpenGLExtension_ATI_vertex_array_object::glGetVariantArrayObjectivATI(GLuint id, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_ATI_vertex_array_object);
    d->GetVariantArrayObjectivATI(id, pname, params);
}

inline void QOpenGLExtension_ATI_vertex_array_object::glGetVariantArrayObjectfvATI(GLuint id, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_ATI_vertex_array_object);
    d->GetVariantArrayObjectfvATI(id, pname, params);
}

inline void QOpenGLExtension_ATI_vertex_array_object::glVariantArrayObjectATI(GLuint id, GLenum type, GLsizei stride, GLuint buffer, GLuint offset)
{
    Q_D(QOpenGLExtension_ATI_vertex_array_object);
    d->VariantArrayObjectATI(id, type, stride, buffer, offset);
}

inline void QOpenGLExtension_ATI_vertex_array_object::glGetArrayObjectivATI(GLenum array, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_ATI_vertex_array_object);
    d->GetArrayObjectivATI(array, pname, params);
}

inline void QOpenGLExtension_ATI_vertex_array_object::glGetArrayObjectfvATI(GLenum array, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_ATI_vertex_array_object);
    d->GetArrayObjectfvATI(array, pname, params);
}

inline void QOpenGLExtension_ATI_vertex_array_object::glArrayObjectATI(GLenum array, GLint size, GLenum type, GLsizei stride, GLuint buffer, GLuint offset)
{
    Q_D(QOpenGLExtension_ATI_vertex_array_object);
    d->ArrayObjectATI(array, size, type, stride, buffer, offset);
}

inline void QOpenGLExtension_ATI_vertex_array_object::glFreeObjectBufferATI(GLuint buffer)
{
    Q_D(QOpenGLExtension_ATI_vertex_array_object);
    d->FreeObjectBufferATI(buffer);
}

inline void QOpenGLExtension_ATI_vertex_array_object::glGetObjectBufferivATI(GLuint buffer, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_ATI_vertex_array_object);
    d->GetObjectBufferivATI(buffer, pname, params);
}

inline void QOpenGLExtension_ATI_vertex_array_object::glGetObjectBufferfvATI(GLuint buffer, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_ATI_vertex_array_object);
    d->GetObjectBufferfvATI(buffer, pname, params);
}

inline void QOpenGLExtension_ATI_vertex_array_object::glUpdateObjectBufferATI(GLuint buffer, GLuint offset, GLsizei size, const GLvoid *pointer, GLenum preserve)
{
    Q_D(QOpenGLExtension_ATI_vertex_array_object);
    d->UpdateObjectBufferATI(buffer, offset, size, pointer, preserve);
}

inline GLboolean QOpenGLExtension_ATI_vertex_array_object::glIsObjectBufferATI(GLuint buffer)
{
    Q_D(QOpenGLExtension_ATI_vertex_array_object);
    return d->IsObjectBufferATI(buffer);
}

inline GLuint QOpenGLExtension_ATI_vertex_array_object::glNewObjectBufferATI(GLsizei size, const GLvoid *pointer, GLenum usage)
{
    Q_D(QOpenGLExtension_ATI_vertex_array_object);
    return d->NewObjectBufferATI(size, pointer, usage);
}

class QOpenGLExtension_ATI_vertex_attrib_array_objectPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetVertexAttribArrayObjectivATI)(GLuint index, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetVertexAttribArrayObjectfvATI)(GLuint index, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP VertexAttribArrayObjectATI)(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, GLuint buffer, GLuint offset);
};

class QOpenGLExtension_ATI_vertex_attrib_array_object : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ATI_vertex_attrib_array_object();

    bool initializeOpenGLFunctions() final;

    void glGetVertexAttribArrayObjectivATI(GLuint index, GLenum pname, GLint *params);
    void glGetVertexAttribArrayObjectfvATI(GLuint index, GLenum pname, GLfloat *params);
    void glVertexAttribArrayObjectATI(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, GLuint buffer, GLuint offset);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ATI_vertex_attrib_array_object)
};

inline void QOpenGLExtension_ATI_vertex_attrib_array_object::glGetVertexAttribArrayObjectivATI(GLuint index, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_ATI_vertex_attrib_array_object);
    d->GetVertexAttribArrayObjectivATI(index, pname, params);
}

inline void QOpenGLExtension_ATI_vertex_attrib_array_object::glGetVertexAttribArrayObjectfvATI(GLuint index, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_ATI_vertex_attrib_array_object);
    d->GetVertexAttribArrayObjectfvATI(index, pname, params);
}

inline void QOpenGLExtension_ATI_vertex_attrib_array_object::glVertexAttribArrayObjectATI(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, GLuint buffer, GLuint offset)
{
    Q_D(QOpenGLExtension_ATI_vertex_attrib_array_object);
    d->VertexAttribArrayObjectATI(index, size, type, normalized, stride, buffer, offset);
}

class QOpenGLExtension_ATI_vertex_streamsPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP VertexBlendEnvfATI)(GLenum pname, GLfloat param);
    void (QOPENGLF_APIENTRYP VertexBlendEnviATI)(GLenum pname, GLint param);
    void (QOPENGLF_APIENTRYP ClientActiveVertexStreamATI)(GLenum stream);
    void (QOPENGLF_APIENTRYP NormalStream3dvATI)(GLenum stream, const GLdouble *coords);
    void (QOPENGLF_APIENTRYP NormalStream3dATI)(GLenum stream, GLdouble nx, GLdouble ny, GLdouble nz);
    void (QOPENGLF_APIENTRYP NormalStream3fvATI)(GLenum stream, const GLfloat *coords);
    void (QOPENGLF_APIENTRYP NormalStream3fATI)(GLenum stream, GLfloat nx, GLfloat ny, GLfloat nz);
    void (QOPENGLF_APIENTRYP NormalStream3ivATI)(GLenum stream, const GLint *coords);
    void (QOPENGLF_APIENTRYP NormalStream3iATI)(GLenum stream, GLint nx, GLint ny, GLint nz);
    void (QOPENGLF_APIENTRYP NormalStream3svATI)(GLenum stream, const GLshort *coords);
    void (QOPENGLF_APIENTRYP NormalStream3sATI)(GLenum stream, GLshort nx, GLshort ny, GLshort nz);
    void (QOPENGLF_APIENTRYP NormalStream3bvATI)(GLenum stream, const GLbyte *coords);
    void (QOPENGLF_APIENTRYP NormalStream3bATI)(GLenum stream, GLbyte nx, GLbyte ny, GLbyte nz);
    void (QOPENGLF_APIENTRYP VertexStream4dvATI)(GLenum stream, const GLdouble *coords);
    void (QOPENGLF_APIENTRYP VertexStream4dATI)(GLenum stream, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
    void (QOPENGLF_APIENTRYP VertexStream4fvATI)(GLenum stream, const GLfloat *coords);
    void (QOPENGLF_APIENTRYP VertexStream4fATI)(GLenum stream, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
    void (QOPENGLF_APIENTRYP VertexStream4ivATI)(GLenum stream, const GLint *coords);
    void (QOPENGLF_APIENTRYP VertexStream4iATI)(GLenum stream, GLint x, GLint y, GLint z, GLint w);
    void (QOPENGLF_APIENTRYP VertexStream4svATI)(GLenum stream, const GLshort *coords);
    void (QOPENGLF_APIENTRYP VertexStream4sATI)(GLenum stream, GLshort x, GLshort y, GLshort z, GLshort w);
    void (QOPENGLF_APIENTRYP VertexStream3dvATI)(GLenum stream, const GLdouble *coords);
    void (QOPENGLF_APIENTRYP VertexStream3dATI)(GLenum stream, GLdouble x, GLdouble y, GLdouble z);
    void (QOPENGLF_APIENTRYP VertexStream3fvATI)(GLenum stream, const GLfloat *coords);
    void (QOPENGLF_APIENTRYP VertexStream3fATI)(GLenum stream, GLfloat x, GLfloat y, GLfloat z);
    void (QOPENGLF_APIENTRYP VertexStream3ivATI)(GLenum stream, const GLint *coords);
    void (QOPENGLF_APIENTRYP VertexStream3iATI)(GLenum stream, GLint x, GLint y, GLint z);
    void (QOPENGLF_APIENTRYP VertexStream3svATI)(GLenum stream, const GLshort *coords);
    void (QOPENGLF_APIENTRYP VertexStream3sATI)(GLenum stream, GLshort x, GLshort y, GLshort z);
    void (QOPENGLF_APIENTRYP VertexStream2dvATI)(GLenum stream, const GLdouble *coords);
    void (QOPENGLF_APIENTRYP VertexStream2dATI)(GLenum stream, GLdouble x, GLdouble y);
    void (QOPENGLF_APIENTRYP VertexStream2fvATI)(GLenum stream, const GLfloat *coords);
    void (QOPENGLF_APIENTRYP VertexStream2fATI)(GLenum stream, GLfloat x, GLfloat y);
    void (QOPENGLF_APIENTRYP VertexStream2ivATI)(GLenum stream, const GLint *coords);
    void (QOPENGLF_APIENTRYP VertexStream2iATI)(GLenum stream, GLint x, GLint y);
    void (QOPENGLF_APIENTRYP VertexStream2svATI)(GLenum stream, const GLshort *coords);
    void (QOPENGLF_APIENTRYP VertexStream2sATI)(GLenum stream, GLshort x, GLshort y);
    void (QOPENGLF_APIENTRYP VertexStream1dvATI)(GLenum stream, const GLdouble *coords);
    void (QOPENGLF_APIENTRYP VertexStream1dATI)(GLenum stream, GLdouble x);
    void (QOPENGLF_APIENTRYP VertexStream1fvATI)(GLenum stream, const GLfloat *coords);
    void (QOPENGLF_APIENTRYP VertexStream1fATI)(GLenum stream, GLfloat x);
    void (QOPENGLF_APIENTRYP VertexStream1ivATI)(GLenum stream, const GLint *coords);
    void (QOPENGLF_APIENTRYP VertexStream1iATI)(GLenum stream, GLint x);
    void (QOPENGLF_APIENTRYP VertexStream1svATI)(GLenum stream, const GLshort *coords);
    void (QOPENGLF_APIENTRYP VertexStream1sATI)(GLenum stream, GLshort x);
};

class QOpenGLExtension_ATI_vertex_streams : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ATI_vertex_streams();

    bool initializeOpenGLFunctions() final;

    void glVertexBlendEnvfATI(GLenum pname, GLfloat param);
    void glVertexBlendEnviATI(GLenum pname, GLint param);
    void glClientActiveVertexStreamATI(GLenum stream);
    void glNormalStream3dvATI(GLenum stream, const GLdouble *coords);
    void glNormalStream3dATI(GLenum stream, GLdouble nx, GLdouble ny, GLdouble nz);
    void glNormalStream3fvATI(GLenum stream, const GLfloat *coords);
    void glNormalStream3fATI(GLenum stream, GLfloat nx, GLfloat ny, GLfloat nz);
    void glNormalStream3ivATI(GLenum stream, const GLint *coords);
    void glNormalStream3iATI(GLenum stream, GLint nx, GLint ny, GLint nz);
    void glNormalStream3svATI(GLenum stream, const GLshort *coords);
    void glNormalStream3sATI(GLenum stream, GLshort nx, GLshort ny, GLshort nz);
    void glNormalStream3bvATI(GLenum stream, const GLbyte *coords);
    void glNormalStream3bATI(GLenum stream, GLbyte nx, GLbyte ny, GLbyte nz);
    void glVertexStream4dvATI(GLenum stream, const GLdouble *coords);
    void glVertexStream4dATI(GLenum stream, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
    void glVertexStream4fvATI(GLenum stream, const GLfloat *coords);
    void glVertexStream4fATI(GLenum stream, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
    void glVertexStream4ivATI(GLenum stream, const GLint *coords);
    void glVertexStream4iATI(GLenum stream, GLint x, GLint y, GLint z, GLint w);
    void glVertexStream4svATI(GLenum stream, const GLshort *coords);
    void glVertexStream4sATI(GLenum stream, GLshort x, GLshort y, GLshort z, GLshort w);
    void glVertexStream3dvATI(GLenum stream, const GLdouble *coords);
    void glVertexStream3dATI(GLenum stream, GLdouble x, GLdouble y, GLdouble z);
    void glVertexStream3fvATI(GLenum stream, const GLfloat *coords);
    void glVertexStream3fATI(GLenum stream, GLfloat x, GLfloat y, GLfloat z);
    void glVertexStream3ivATI(GLenum stream, const GLint *coords);
    void glVertexStream3iATI(GLenum stream, GLint x, GLint y, GLint z);
    void glVertexStream3svATI(GLenum stream, const GLshort *coords);
    void glVertexStream3sATI(GLenum stream, GLshort x, GLshort y, GLshort z);
    void glVertexStream2dvATI(GLenum stream, const GLdouble *coords);
    void glVertexStream2dATI(GLenum stream, GLdouble x, GLdouble y);
    void glVertexStream2fvATI(GLenum stream, const GLfloat *coords);
    void glVertexStream2fATI(GLenum stream, GLfloat x, GLfloat y);
    void glVertexStream2ivATI(GLenum stream, const GLint *coords);
    void glVertexStream2iATI(GLenum stream, GLint x, GLint y);
    void glVertexStream2svATI(GLenum stream, const GLshort *coords);
    void glVertexStream2sATI(GLenum stream, GLshort x, GLshort y);
    void glVertexStream1dvATI(GLenum stream, const GLdouble *coords);
    void glVertexStream1dATI(GLenum stream, GLdouble x);
    void glVertexStream1fvATI(GLenum stream, const GLfloat *coords);
    void glVertexStream1fATI(GLenum stream, GLfloat x);
    void glVertexStream1ivATI(GLenum stream, const GLint *coords);
    void glVertexStream1iATI(GLenum stream, GLint x);
    void glVertexStream1svATI(GLenum stream, const GLshort *coords);
    void glVertexStream1sATI(GLenum stream, GLshort x);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ATI_vertex_streams)
};

inline void QOpenGLExtension_ATI_vertex_streams::glVertexBlendEnvfATI(GLenum pname, GLfloat param)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexBlendEnvfATI(pname, param);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexBlendEnviATI(GLenum pname, GLint param)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexBlendEnviATI(pname, param);
}

inline void QOpenGLExtension_ATI_vertex_streams::glClientActiveVertexStreamATI(GLenum stream)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->ClientActiveVertexStreamATI(stream);
}

inline void QOpenGLExtension_ATI_vertex_streams::glNormalStream3dvATI(GLenum stream, const GLdouble *coords)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->NormalStream3dvATI(stream, coords);
}

inline void QOpenGLExtension_ATI_vertex_streams::glNormalStream3dATI(GLenum stream, GLdouble nx, GLdouble ny, GLdouble nz)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->NormalStream3dATI(stream, nx, ny, nz);
}

inline void QOpenGLExtension_ATI_vertex_streams::glNormalStream3fvATI(GLenum stream, const GLfloat *coords)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->NormalStream3fvATI(stream, coords);
}

inline void QOpenGLExtension_ATI_vertex_streams::glNormalStream3fATI(GLenum stream, GLfloat nx, GLfloat ny, GLfloat nz)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->NormalStream3fATI(stream, nx, ny, nz);
}

inline void QOpenGLExtension_ATI_vertex_streams::glNormalStream3ivATI(GLenum stream, const GLint *coords)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->NormalStream3ivATI(stream, coords);
}

inline void QOpenGLExtension_ATI_vertex_streams::glNormalStream3iATI(GLenum stream, GLint nx, GLint ny, GLint nz)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->NormalStream3iATI(stream, nx, ny, nz);
}

inline void QOpenGLExtension_ATI_vertex_streams::glNormalStream3svATI(GLenum stream, const GLshort *coords)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->NormalStream3svATI(stream, coords);
}

inline void QOpenGLExtension_ATI_vertex_streams::glNormalStream3sATI(GLenum stream, GLshort nx, GLshort ny, GLshort nz)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->NormalStream3sATI(stream, nx, ny, nz);
}

inline void QOpenGLExtension_ATI_vertex_streams::glNormalStream3bvATI(GLenum stream, const GLbyte *coords)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->NormalStream3bvATI(stream, coords);
}

inline void QOpenGLExtension_ATI_vertex_streams::glNormalStream3bATI(GLenum stream, GLbyte nx, GLbyte ny, GLbyte nz)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->NormalStream3bATI(stream, nx, ny, nz);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream4dvATI(GLenum stream, const GLdouble *coords)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream4dvATI(stream, coords);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream4dATI(GLenum stream, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream4dATI(stream, x, y, z, w);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream4fvATI(GLenum stream, const GLfloat *coords)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream4fvATI(stream, coords);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream4fATI(GLenum stream, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream4fATI(stream, x, y, z, w);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream4ivATI(GLenum stream, const GLint *coords)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream4ivATI(stream, coords);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream4iATI(GLenum stream, GLint x, GLint y, GLint z, GLint w)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream4iATI(stream, x, y, z, w);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream4svATI(GLenum stream, const GLshort *coords)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream4svATI(stream, coords);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream4sATI(GLenum stream, GLshort x, GLshort y, GLshort z, GLshort w)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream4sATI(stream, x, y, z, w);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream3dvATI(GLenum stream, const GLdouble *coords)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream3dvATI(stream, coords);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream3dATI(GLenum stream, GLdouble x, GLdouble y, GLdouble z)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream3dATI(stream, x, y, z);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream3fvATI(GLenum stream, const GLfloat *coords)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream3fvATI(stream, coords);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream3fATI(GLenum stream, GLfloat x, GLfloat y, GLfloat z)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream3fATI(stream, x, y, z);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream3ivATI(GLenum stream, const GLint *coords)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream3ivATI(stream, coords);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream3iATI(GLenum stream, GLint x, GLint y, GLint z)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream3iATI(stream, x, y, z);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream3svATI(GLenum stream, const GLshort *coords)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream3svATI(stream, coords);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream3sATI(GLenum stream, GLshort x, GLshort y, GLshort z)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream3sATI(stream, x, y, z);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream2dvATI(GLenum stream, const GLdouble *coords)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream2dvATI(stream, coords);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream2dATI(GLenum stream, GLdouble x, GLdouble y)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream2dATI(stream, x, y);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream2fvATI(GLenum stream, const GLfloat *coords)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream2fvATI(stream, coords);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream2fATI(GLenum stream, GLfloat x, GLfloat y)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream2fATI(stream, x, y);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream2ivATI(GLenum stream, const GLint *coords)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream2ivATI(stream, coords);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream2iATI(GLenum stream, GLint x, GLint y)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream2iATI(stream, x, y);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream2svATI(GLenum stream, const GLshort *coords)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream2svATI(stream, coords);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream2sATI(GLenum stream, GLshort x, GLshort y)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream2sATI(stream, x, y);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream1dvATI(GLenum stream, const GLdouble *coords)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream1dvATI(stream, coords);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream1dATI(GLenum stream, GLdouble x)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream1dATI(stream, x);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream1fvATI(GLenum stream, const GLfloat *coords)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream1fvATI(stream, coords);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream1fATI(GLenum stream, GLfloat x)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream1fATI(stream, x);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream1ivATI(GLenum stream, const GLint *coords)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream1ivATI(stream, coords);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream1iATI(GLenum stream, GLint x)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream1iATI(stream, x);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream1svATI(GLenum stream, const GLshort *coords)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream1svATI(stream, coords);
}

inline void QOpenGLExtension_ATI_vertex_streams::glVertexStream1sATI(GLenum stream, GLshort x)
{
    Q_D(QOpenGLExtension_ATI_vertex_streams);
    d->VertexStream1sATI(stream, x);
}

class QOpenGLExtension_EXT_bindable_uniformPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    GLintptr (QOPENGLF_APIENTRYP GetUniformOffsetEXT)(GLuint program, GLint location);
    GLint (QOPENGLF_APIENTRYP GetUniformBufferSizeEXT)(GLuint program, GLint location);
    void (QOPENGLF_APIENTRYP UniformBufferEXT)(GLuint program, GLint location, GLuint buffer);
};

class QOpenGLExtension_EXT_bindable_uniform : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_bindable_uniform();

    bool initializeOpenGLFunctions() final;

    GLintptr glGetUniformOffsetEXT(GLuint program, GLint location);
    GLint glGetUniformBufferSizeEXT(GLuint program, GLint location);
    void glUniformBufferEXT(GLuint program, GLint location, GLuint buffer);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_bindable_uniform)
};

inline GLintptr QOpenGLExtension_EXT_bindable_uniform::glGetUniformOffsetEXT(GLuint program, GLint location)
{
    Q_D(QOpenGLExtension_EXT_bindable_uniform);
    return d->GetUniformOffsetEXT(program, location);
}

inline GLint QOpenGLExtension_EXT_bindable_uniform::glGetUniformBufferSizeEXT(GLuint program, GLint location)
{
    Q_D(QOpenGLExtension_EXT_bindable_uniform);
    return d->GetUniformBufferSizeEXT(program, location);
}

inline void QOpenGLExtension_EXT_bindable_uniform::glUniformBufferEXT(GLuint program, GLint location, GLuint buffer)
{
    Q_D(QOpenGLExtension_EXT_bindable_uniform);
    d->UniformBufferEXT(program, location, buffer);
}

class QOpenGLExtension_EXT_blend_colorPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP BlendColorEXT)(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
};

class QOpenGLExtension_EXT_blend_color : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_blend_color();

    bool initializeOpenGLFunctions() final;

    void glBlendColorEXT(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_blend_color)
};

inline void QOpenGLExtension_EXT_blend_color::glBlendColorEXT(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    Q_D(QOpenGLExtension_EXT_blend_color);
    d->BlendColorEXT(red, green, blue, alpha);
}

class QOpenGLExtension_EXT_blend_equation_separatePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP BlendEquationSeparateEXT)(GLenum modeRGB, GLenum modeAlpha);
};

class QOpenGLExtension_EXT_blend_equation_separate : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_blend_equation_separate();

    bool initializeOpenGLFunctions() final;

    void glBlendEquationSeparateEXT(GLenum modeRGB, GLenum modeAlpha);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_blend_equation_separate)
};

inline void QOpenGLExtension_EXT_blend_equation_separate::glBlendEquationSeparateEXT(GLenum modeRGB, GLenum modeAlpha)
{
    Q_D(QOpenGLExtension_EXT_blend_equation_separate);
    d->BlendEquationSeparateEXT(modeRGB, modeAlpha);
}

class QOpenGLExtension_EXT_blend_func_separatePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP BlendFuncSeparateEXT)(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha);
};

class QOpenGLExtension_EXT_blend_func_separate : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_blend_func_separate();

    bool initializeOpenGLFunctions() final;

    void glBlendFuncSeparateEXT(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_blend_func_separate)
};

inline void QOpenGLExtension_EXT_blend_func_separate::glBlendFuncSeparateEXT(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha)
{
    Q_D(QOpenGLExtension_EXT_blend_func_separate);
    d->BlendFuncSeparateEXT(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
}

class QOpenGLExtension_EXT_blend_minmaxPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP BlendEquationEXT)(GLenum mode);
};

class QOpenGLExtension_EXT_blend_minmax : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_blend_minmax();

    bool initializeOpenGLFunctions() final;

    void glBlendEquationEXT(GLenum mode);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_blend_minmax)
};

inline void QOpenGLExtension_EXT_blend_minmax::glBlendEquationEXT(GLenum mode)
{
    Q_D(QOpenGLExtension_EXT_blend_minmax);
    d->BlendEquationEXT(mode);
}

class QOpenGLExtension_EXT_color_subtablePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP CopyColorSubTableEXT)(GLenum target, GLsizei start, GLint x, GLint y, GLsizei width);
    void (QOPENGLF_APIENTRYP ColorSubTableEXT)(GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const GLvoid *data);
};

class QOpenGLExtension_EXT_color_subtable : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_color_subtable();

    bool initializeOpenGLFunctions() final;

    void glCopyColorSubTableEXT(GLenum target, GLsizei start, GLint x, GLint y, GLsizei width);
    void glColorSubTableEXT(GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const GLvoid *data);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_color_subtable)
};

inline void QOpenGLExtension_EXT_color_subtable::glCopyColorSubTableEXT(GLenum target, GLsizei start, GLint x, GLint y, GLsizei width)
{
    Q_D(QOpenGLExtension_EXT_color_subtable);
    d->CopyColorSubTableEXT(target, start, x, y, width);
}

inline void QOpenGLExtension_EXT_color_subtable::glColorSubTableEXT(GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const GLvoid *data)
{
    Q_D(QOpenGLExtension_EXT_color_subtable);
    d->ColorSubTableEXT(target, start, count, format, type, data);
}

class QOpenGLExtension_EXT_compiled_vertex_arrayPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP UnlockArraysEXT)();
    void (QOPENGLF_APIENTRYP LockArraysEXT)(GLint first, GLsizei count);
};

class QOpenGLExtension_EXT_compiled_vertex_array : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_compiled_vertex_array();

    bool initializeOpenGLFunctions() final;

    void glUnlockArraysEXT();
    void glLockArraysEXT(GLint first, GLsizei count);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_compiled_vertex_array)
};

inline void QOpenGLExtension_EXT_compiled_vertex_array::glUnlockArraysEXT()
{
    Q_D(QOpenGLExtension_EXT_compiled_vertex_array);
    d->UnlockArraysEXT();
}

inline void QOpenGLExtension_EXT_compiled_vertex_array::glLockArraysEXT(GLint first, GLsizei count)
{
    Q_D(QOpenGLExtension_EXT_compiled_vertex_array);
    d->LockArraysEXT(first, count);
}

class QOpenGLExtension_EXT_convolutionPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP SeparableFilter2DEXT)(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *row, const GLvoid *column);
    void (QOPENGLF_APIENTRYP GetSeparableFilterEXT)(GLenum target, GLenum format, GLenum type, GLvoid *row, GLvoid *column, GLvoid *span);
    void (QOPENGLF_APIENTRYP GetConvolutionParameterivEXT)(GLenum target, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetConvolutionParameterfvEXT)(GLenum target, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP GetConvolutionFilterEXT)(GLenum target, GLenum format, GLenum type, GLvoid *image);
    void (QOPENGLF_APIENTRYP CopyConvolutionFilter2DEXT)(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height);
    void (QOPENGLF_APIENTRYP CopyConvolutionFilter1DEXT)(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width);
    void (QOPENGLF_APIENTRYP ConvolutionParameterivEXT)(GLenum target, GLenum pname, const GLint *params);
    void (QOPENGLF_APIENTRYP ConvolutionParameteriEXT)(GLenum target, GLenum pname, GLint params);
    void (QOPENGLF_APIENTRYP ConvolutionParameterfvEXT)(GLenum target, GLenum pname, const GLfloat *params);
    void (QOPENGLF_APIENTRYP ConvolutionParameterfEXT)(GLenum target, GLenum pname, GLfloat params);
    void (QOPENGLF_APIENTRYP ConvolutionFilter2DEXT)(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *image);
    void (QOPENGLF_APIENTRYP ConvolutionFilter1DEXT)(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *image);
};

class QOpenGLExtension_EXT_convolution : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_convolution();

    bool initializeOpenGLFunctions() final;

    void glSeparableFilter2DEXT(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *row, const GLvoid *column);
    void glGetSeparableFilterEXT(GLenum target, GLenum format, GLenum type, GLvoid *row, GLvoid *column, GLvoid *span);
    void glGetConvolutionParameterivEXT(GLenum target, GLenum pname, GLint *params);
    void glGetConvolutionParameterfvEXT(GLenum target, GLenum pname, GLfloat *params);
    void glGetConvolutionFilterEXT(GLenum target, GLenum format, GLenum type, GLvoid *image);
    void glCopyConvolutionFilter2DEXT(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height);
    void glCopyConvolutionFilter1DEXT(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width);
    void glConvolutionParameterivEXT(GLenum target, GLenum pname, const GLint *params);
    void glConvolutionParameteriEXT(GLenum target, GLenum pname, GLint params);
    void glConvolutionParameterfvEXT(GLenum target, GLenum pname, const GLfloat *params);
    void glConvolutionParameterfEXT(GLenum target, GLenum pname, GLfloat params);
    void glConvolutionFilter2DEXT(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *image);
    void glConvolutionFilter1DEXT(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *image);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_convolution)
};

inline void QOpenGLExtension_EXT_convolution::glSeparableFilter2DEXT(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *row, const GLvoid *column)
{
    Q_D(QOpenGLExtension_EXT_convolution);
    d->SeparableFilter2DEXT(target, internalformat, width, height, format, type, row, column);
}

inline void QOpenGLExtension_EXT_convolution::glGetSeparableFilterEXT(GLenum target, GLenum format, GLenum type, GLvoid *row, GLvoid *column, GLvoid *span)
{
    Q_D(QOpenGLExtension_EXT_convolution);
    d->GetSeparableFilterEXT(target, format, type, row, column, span);
}

inline void QOpenGLExtension_EXT_convolution::glGetConvolutionParameterivEXT(GLenum target, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_EXT_convolution);
    d->GetConvolutionParameterivEXT(target, pname, params);
}

inline void QOpenGLExtension_EXT_convolution::glGetConvolutionParameterfvEXT(GLenum target, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_EXT_convolution);
    d->GetConvolutionParameterfvEXT(target, pname, params);
}

inline void QOpenGLExtension_EXT_convolution::glGetConvolutionFilterEXT(GLenum target, GLenum format, GLenum type, GLvoid *image)
{
    Q_D(QOpenGLExtension_EXT_convolution);
    d->GetConvolutionFilterEXT(target, format, type, image);
}

inline void QOpenGLExtension_EXT_convolution::glCopyConvolutionFilter2DEXT(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height)
{
    Q_D(QOpenGLExtension_EXT_convolution);
    d->CopyConvolutionFilter2DEXT(target, internalformat, x, y, width, height);
}

inline void QOpenGLExtension_EXT_convolution::glCopyConvolutionFilter1DEXT(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width)
{
    Q_D(QOpenGLExtension_EXT_convolution);
    d->CopyConvolutionFilter1DEXT(target, internalformat, x, y, width);
}

inline void QOpenGLExtension_EXT_convolution::glConvolutionParameterivEXT(GLenum target, GLenum pname, const GLint *params)
{
    Q_D(QOpenGLExtension_EXT_convolution);
    d->ConvolutionParameterivEXT(target, pname, params);
}

inline void QOpenGLExtension_EXT_convolution::glConvolutionParameteriEXT(GLenum target, GLenum pname, GLint params)
{
    Q_D(QOpenGLExtension_EXT_convolution);
    d->ConvolutionParameteriEXT(target, pname, params);
}

inline void QOpenGLExtension_EXT_convolution::glConvolutionParameterfvEXT(GLenum target, GLenum pname, const GLfloat *params)
{
    Q_D(QOpenGLExtension_EXT_convolution);
    d->ConvolutionParameterfvEXT(target, pname, params);
}

inline void QOpenGLExtension_EXT_convolution::glConvolutionParameterfEXT(GLenum target, GLenum pname, GLfloat params)
{
    Q_D(QOpenGLExtension_EXT_convolution);
    d->ConvolutionParameterfEXT(target, pname, params);
}

inline void QOpenGLExtension_EXT_convolution::glConvolutionFilter2DEXT(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *image)
{
    Q_D(QOpenGLExtension_EXT_convolution);
    d->ConvolutionFilter2DEXT(target, internalformat, width, height, format, type, image);
}

inline void QOpenGLExtension_EXT_convolution::glConvolutionFilter1DEXT(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *image)
{
    Q_D(QOpenGLExtension_EXT_convolution);
    d->ConvolutionFilter1DEXT(target, internalformat, width, format, type, image);
}

class QOpenGLExtension_EXT_coordinate_framePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP BinormalPointerEXT)(GLenum type, GLsizei stride, const GLvoid *pointer);
    void (QOPENGLF_APIENTRYP TangentPointerEXT)(GLenum type, GLsizei stride, const GLvoid *pointer);
    void (QOPENGLF_APIENTRYP Binormal3svEXT)(const GLshort *v);
    void (QOPENGLF_APIENTRYP Binormal3sEXT)(GLshort bx, GLshort by, GLshort bz);
    void (QOPENGLF_APIENTRYP Binormal3ivEXT)(const GLint *v);
    void (QOPENGLF_APIENTRYP Binormal3iEXT)(GLint bx, GLint by, GLint bz);
    void (QOPENGLF_APIENTRYP Binormal3fvEXT)(const GLfloat *v);
    void (QOPENGLF_APIENTRYP Binormal3fEXT)(GLfloat bx, GLfloat by, GLfloat bz);
    void (QOPENGLF_APIENTRYP Binormal3dvEXT)(const GLdouble *v);
    void (QOPENGLF_APIENTRYP Binormal3dEXT)(GLdouble bx, GLdouble by, GLdouble bz);
    void (QOPENGLF_APIENTRYP Binormal3bvEXT)(const GLbyte *v);
    void (QOPENGLF_APIENTRYP Binormal3bEXT)(GLbyte bx, GLbyte by, GLbyte bz);
    void (QOPENGLF_APIENTRYP Tangent3svEXT)(const GLshort *v);
    void (QOPENGLF_APIENTRYP Tangent3sEXT)(GLshort tx, GLshort ty, GLshort tz);
    void (QOPENGLF_APIENTRYP Tangent3ivEXT)(const GLint *v);
    void (QOPENGLF_APIENTRYP Tangent3iEXT)(GLint tx, GLint ty, GLint tz);
    void (QOPENGLF_APIENTRYP Tangent3fvEXT)(const GLfloat *v);
    void (QOPENGLF_APIENTRYP Tangent3fEXT)(GLfloat tx, GLfloat ty, GLfloat tz);
    void (QOPENGLF_APIENTRYP Tangent3dvEXT)(const GLdouble *v);
    void (QOPENGLF_APIENTRYP Tangent3dEXT)(GLdouble tx, GLdouble ty, GLdouble tz);
    void (QOPENGLF_APIENTRYP Tangent3bvEXT)(const GLbyte *v);
    void (QOPENGLF_APIENTRYP Tangent3bEXT)(GLbyte tx, GLbyte ty, GLbyte tz);
};

class QOpenGLExtension_EXT_coordinate_frame : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_coordinate_frame();

    bool initializeOpenGLFunctions() final;

    void glBinormalPointerEXT(GLenum type, GLsizei stride, const GLvoid *pointer);
    void glTangentPointerEXT(GLenum type, GLsizei stride, const GLvoid *pointer);
    void glBinormal3svEXT(const GLshort *v);
    void glBinormal3sEXT(GLshort bx, GLshort by, GLshort bz);
    void glBinormal3ivEXT(const GLint *v);
    void glBinormal3iEXT(GLint bx, GLint by, GLint bz);
    void glBinormal3fvEXT(const GLfloat *v);
    void glBinormal3fEXT(GLfloat bx, GLfloat by, GLfloat bz);
    void glBinormal3dvEXT(const GLdouble *v);
    void glBinormal3dEXT(GLdouble bx, GLdouble by, GLdouble bz);
    void glBinormal3bvEXT(const GLbyte *v);
    void glBinormal3bEXT(GLbyte bx, GLbyte by, GLbyte bz);
    void glTangent3svEXT(const GLshort *v);
    void glTangent3sEXT(GLshort tx, GLshort ty, GLshort tz);
    void glTangent3ivEXT(const GLint *v);
    void glTangent3iEXT(GLint tx, GLint ty, GLint tz);
    void glTangent3fvEXT(const GLfloat *v);
    void glTangent3fEXT(GLfloat tx, GLfloat ty, GLfloat tz);
    void glTangent3dvEXT(const GLdouble *v);
    void glTangent3dEXT(GLdouble tx, GLdouble ty, GLdouble tz);
    void glTangent3bvEXT(const GLbyte *v);
    void glTangent3bEXT(GLbyte tx, GLbyte ty, GLbyte tz);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_coordinate_frame)
};

inline void QOpenGLExtension_EXT_coordinate_frame::glBinormalPointerEXT(GLenum type, GLsizei stride, const GLvoid *pointer)
{
    Q_D(QOpenGLExtension_EXT_coordinate_frame);
    d->BinormalPointerEXT(type, stride, pointer);
}

inline void QOpenGLExtension_EXT_coordinate_frame::glTangentPointerEXT(GLenum type, GLsizei stride, const GLvoid *pointer)
{
    Q_D(QOpenGLExtension_EXT_coordinate_frame);
    d->TangentPointerEXT(type, stride, pointer);
}

inline void QOpenGLExtension_EXT_coordinate_frame::glBinormal3svEXT(const GLshort *v)
{
    Q_D(QOpenGLExtension_EXT_coordinate_frame);
    d->Binormal3svEXT(v);
}

inline void QOpenGLExtension_EXT_coordinate_frame::glBinormal3sEXT(GLshort bx, GLshort by, GLshort bz)
{
    Q_D(QOpenGLExtension_EXT_coordinate_frame);
    d->Binormal3sEXT(bx, by, bz);
}

inline void QOpenGLExtension_EXT_coordinate_frame::glBinormal3ivEXT(const GLint *v)
{
    Q_D(QOpenGLExtension_EXT_coordinate_frame);
    d->Binormal3ivEXT(v);
}

inline void QOpenGLExtension_EXT_coordinate_frame::glBinormal3iEXT(GLint bx, GLint by, GLint bz)
{
    Q_D(QOpenGLExtension_EXT_coordinate_frame);
    d->Binormal3iEXT(bx, by, bz);
}

inline void QOpenGLExtension_EXT_coordinate_frame::glBinormal3fvEXT(const GLfloat *v)
{
    Q_D(QOpenGLExtension_EXT_coordinate_frame);
    d->Binormal3fvEXT(v);
}

inline void QOpenGLExtension_EXT_coordinate_frame::glBinormal3fEXT(GLfloat bx, GLfloat by, GLfloat bz)
{
    Q_D(QOpenGLExtension_EXT_coordinate_frame);
    d->Binormal3fEXT(bx, by, bz);
}

inline void QOpenGLExtension_EXT_coordinate_frame::glBinormal3dvEXT(const GLdouble *v)
{
    Q_D(QOpenGLExtension_EXT_coordinate_frame);
    d->Binormal3dvEXT(v);
}

inline void QOpenGLExtension_EXT_coordinate_frame::glBinormal3dEXT(GLdouble bx, GLdouble by, GLdouble bz)
{
    Q_D(QOpenGLExtension_EXT_coordinate_frame);
    d->Binormal3dEXT(bx, by, bz);
}

inline void QOpenGLExtension_EXT_coordinate_frame::glBinormal3bvEXT(const GLbyte *v)
{
    Q_D(QOpenGLExtension_EXT_coordinate_frame);
    d->Binormal3bvEXT(v);
}

inline void QOpenGLExtension_EXT_coordinate_frame::glBinormal3bEXT(GLbyte bx, GLbyte by, GLbyte bz)
{
    Q_D(QOpenGLExtension_EXT_coordinate_frame);
    d->Binormal3bEXT(bx, by, bz);
}

inline void QOpenGLExtension_EXT_coordinate_frame::glTangent3svEXT(const GLshort *v)
{
    Q_D(QOpenGLExtension_EXT_coordinate_frame);
    d->Tangent3svEXT(v);
}

inline void QOpenGLExtension_EXT_coordinate_frame::glTangent3sEXT(GLshort tx, GLshort ty, GLshort tz)
{
    Q_D(QOpenGLExtension_EXT_coordinate_frame);
    d->Tangent3sEXT(tx, ty, tz);
}

inline void QOpenGLExtension_EXT_coordinate_frame::glTangent3ivEXT(const GLint *v)
{
    Q_D(QOpenGLExtension_EXT_coordinate_frame);
    d->Tangent3ivEXT(v);
}

inline void QOpenGLExtension_EXT_coordinate_frame::glTangent3iEXT(GLint tx, GLint ty, GLint tz)
{
    Q_D(QOpenGLExtension_EXT_coordinate_frame);
    d->Tangent3iEXT(tx, ty, tz);
}

inline void QOpenGLExtension_EXT_coordinate_frame::glTangent3fvEXT(const GLfloat *v)
{
    Q_D(QOpenGLExtension_EXT_coordinate_frame);
    d->Tangent3fvEXT(v);
}

inline void QOpenGLExtension_EXT_coordinate_frame::glTangent3fEXT(GLfloat tx, GLfloat ty, GLfloat tz)
{
    Q_D(QOpenGLExtension_EXT_coordinate_frame);
    d->Tangent3fEXT(tx, ty, tz);
}

inline void QOpenGLExtension_EXT_coordinate_frame::glTangent3dvEXT(const GLdouble *v)
{
    Q_D(QOpenGLExtension_EXT_coordinate_frame);
    d->Tangent3dvEXT(v);
}

inline void QOpenGLExtension_EXT_coordinate_frame::glTangent3dEXT(GLdouble tx, GLdouble ty, GLdouble tz)
{
    Q_D(QOpenGLExtension_EXT_coordinate_frame);
    d->Tangent3dEXT(tx, ty, tz);
}

inline void QOpenGLExtension_EXT_coordinate_frame::glTangent3bvEXT(const GLbyte *v)
{
    Q_D(QOpenGLExtension_EXT_coordinate_frame);
    d->Tangent3bvEXT(v);
}

inline void QOpenGLExtension_EXT_coordinate_frame::glTangent3bEXT(GLbyte tx, GLbyte ty, GLbyte tz)
{
    Q_D(QOpenGLExtension_EXT_coordinate_frame);
    d->Tangent3bEXT(tx, ty, tz);
}

class QOpenGLExtension_EXT_copy_texturePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP CopyTexSubImage3DEXT)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
    void (QOPENGLF_APIENTRYP CopyTexSubImage2DEXT)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
    void (QOPENGLF_APIENTRYP CopyTexSubImage1DEXT)(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
    void (QOPENGLF_APIENTRYP CopyTexImage2DEXT)(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
    void (QOPENGLF_APIENTRYP CopyTexImage1DEXT)(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border);
};

class QOpenGLExtension_EXT_copy_texture : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_copy_texture();

    bool initializeOpenGLFunctions() final;

    void glCopyTexSubImage3DEXT(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
    void glCopyTexSubImage2DEXT(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
    void glCopyTexSubImage1DEXT(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
    void glCopyTexImage2DEXT(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
    void glCopyTexImage1DEXT(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_copy_texture)
};

inline void QOpenGLExtension_EXT_copy_texture::glCopyTexSubImage3DEXT(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
    Q_D(QOpenGLExtension_EXT_copy_texture);
    d->CopyTexSubImage3DEXT(target, level, xoffset, yoffset, zoffset, x, y, width, height);
}

inline void QOpenGLExtension_EXT_copy_texture::glCopyTexSubImage2DEXT(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
    Q_D(QOpenGLExtension_EXT_copy_texture);
    d->CopyTexSubImage2DEXT(target, level, xoffset, yoffset, x, y, width, height);
}

inline void QOpenGLExtension_EXT_copy_texture::glCopyTexSubImage1DEXT(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)
{
    Q_D(QOpenGLExtension_EXT_copy_texture);
    d->CopyTexSubImage1DEXT(target, level, xoffset, x, y, width);
}

inline void QOpenGLExtension_EXT_copy_texture::glCopyTexImage2DEXT(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)
{
    Q_D(QOpenGLExtension_EXT_copy_texture);
    d->CopyTexImage2DEXT(target, level, internalformat, x, y, width, height, border);
}

inline void QOpenGLExtension_EXT_copy_texture::glCopyTexImage1DEXT(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border)
{
    Q_D(QOpenGLExtension_EXT_copy_texture);
    d->CopyTexImage1DEXT(target, level, internalformat, x, y, width, border);
}

class QOpenGLExtension_EXT_cull_vertexPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP CullParameterfvEXT)(GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP CullParameterdvEXT)(GLenum pname, GLdouble *params);
};

class QOpenGLExtension_EXT_cull_vertex : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_cull_vertex();

    bool initializeOpenGLFunctions() final;

    void glCullParameterfvEXT(GLenum pname, GLfloat *params);
    void glCullParameterdvEXT(GLenum pname, GLdouble *params);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_cull_vertex)
};

inline void QOpenGLExtension_EXT_cull_vertex::glCullParameterfvEXT(GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_EXT_cull_vertex);
    d->CullParameterfvEXT(pname, params);
}

inline void QOpenGLExtension_EXT_cull_vertex::glCullParameterdvEXT(GLenum pname, GLdouble *params)
{
    Q_D(QOpenGLExtension_EXT_cull_vertex);
    d->CullParameterdvEXT(pname, params);
}

class QOpenGLExtension_EXT_depth_bounds_testPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP DepthBoundsEXT)(GLclampd zmin, GLclampd zmax);
};

class QOpenGLExtension_EXT_depth_bounds_test : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_depth_bounds_test();

    bool initializeOpenGLFunctions() final;

    void glDepthBoundsEXT(GLclampd zmin, GLclampd zmax);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_depth_bounds_test)
};

inline void QOpenGLExtension_EXT_depth_bounds_test::glDepthBoundsEXT(GLclampd zmin, GLclampd zmax)
{
    Q_D(QOpenGLExtension_EXT_depth_bounds_test);
    d->DepthBoundsEXT(zmin, zmax);
}

class QOpenGLExtension_EXT_direct_state_accessPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix4x3dvEXT)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix4x2dvEXT)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix3x4dvEXT)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix3x2dvEXT)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix2x4dvEXT)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix2x3dvEXT)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix4dvEXT)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix3dvEXT)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix2dvEXT)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void (QOPENGLF_APIENTRYP ProgramUniform4dvEXT)(GLuint program, GLint location, GLsizei count, const GLdouble *value);
    void (QOPENGLF_APIENTRYP ProgramUniform3dvEXT)(GLuint program, GLint location, GLsizei count, const GLdouble *value);
    void (QOPENGLF_APIENTRYP ProgramUniform2dvEXT)(GLuint program, GLint location, GLsizei count, const GLdouble *value);
    void (QOPENGLF_APIENTRYP ProgramUniform1dvEXT)(GLuint program, GLint location, GLsizei count, const GLdouble *value);
    void (QOPENGLF_APIENTRYP ProgramUniform4dEXT)(GLuint program, GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
    void (QOPENGLF_APIENTRYP ProgramUniform3dEXT)(GLuint program, GLint location, GLdouble x, GLdouble y, GLdouble z);
    void (QOPENGLF_APIENTRYP ProgramUniform2dEXT)(GLuint program, GLint location, GLdouble x, GLdouble y);
    void (QOPENGLF_APIENTRYP ProgramUniform1dEXT)(GLuint program, GLint location, GLdouble x);
    void (QOPENGLF_APIENTRYP MultiTexRenderbufferEXT)(GLenum texunit, GLenum target, GLuint renderbuffer);
    void (QOPENGLF_APIENTRYP TextureRenderbufferEXT)(GLuint texture, GLenum target, GLuint renderbuffer);
    void (QOPENGLF_APIENTRYP NamedFramebufferTextureFaceEXT)(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLenum face);
    void (QOPENGLF_APIENTRYP NamedFramebufferTextureLayerEXT)(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLint layer);
    void (QOPENGLF_APIENTRYP NamedFramebufferTextureEXT)(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level);
    void (QOPENGLF_APIENTRYP NamedRenderbufferStorageMultisampleCoverageEXT)(GLuint renderbuffer, GLsizei coverageSamples, GLsizei colorSamples, GLenum internalformat, GLsizei width, GLsizei height);
    void (QOPENGLF_APIENTRYP NamedRenderbufferStorageMultisampleEXT)(GLuint renderbuffer, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
    void (QOPENGLF_APIENTRYP GetFramebufferParameterivEXT)(GLuint framebuffer, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP FramebufferReadBufferEXT)(GLuint framebuffer, GLenum mode);
    void (QOPENGLF_APIENTRYP FramebufferDrawBuffersEXT)(GLuint framebuffer, GLsizei n, const GLenum *bufs);
    void (QOPENGLF_APIENTRYP FramebufferDrawBufferEXT)(GLuint framebuffer, GLenum mode);
    void (QOPENGLF_APIENTRYP GenerateMultiTexMipmapEXT)(GLenum texunit, GLenum target);
    void (QOPENGLF_APIENTRYP GenerateTextureMipmapEXT)(GLuint texture, GLenum target);
    void (QOPENGLF_APIENTRYP GetNamedFramebufferAttachmentParameterivEXT)(GLuint framebuffer, GLenum attachment, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP NamedFramebufferRenderbufferEXT)(GLuint framebuffer, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
    void (QOPENGLF_APIENTRYP NamedFramebufferTexture3DEXT)(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset);
    void (QOPENGLF_APIENTRYP NamedFramebufferTexture2DEXT)(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
    void (QOPENGLF_APIENTRYP NamedFramebufferTexture1DEXT)(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
    GLenum (QOPENGLF_APIENTRYP CheckNamedFramebufferStatusEXT)(GLuint framebuffer, GLenum target);
    void (QOPENGLF_APIENTRYP GetNamedRenderbufferParameterivEXT)(GLuint renderbuffer, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP NamedRenderbufferStorageEXT)(GLuint renderbuffer, GLenum internalformat, GLsizei width, GLsizei height);
    void (QOPENGLF_APIENTRYP MultiTexBufferEXT)(GLenum texunit, GLenum target, GLenum internalformat, GLuint buffer);
    void (QOPENGLF_APIENTRYP TextureBufferEXT)(GLuint texture, GLenum target, GLenum internalformat, GLuint buffer);
    void (QOPENGLF_APIENTRYP GetNamedBufferSubDataEXT)(GLuint buffer, GLintptr offset, GLsizeiptr size, GLvoid *data);
    void (QOPENGLF_APIENTRYP GetNamedBufferPointervEXT)(GLuint buffer, GLenum pname, GLvoid* *params);
    void (QOPENGLF_APIENTRYP GetNamedBufferParameterivEXT)(GLuint buffer, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP NamedCopyBufferSubDataEXT)(GLuint readBuffer, GLuint writeBuffer, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size);
    void (QOPENGLF_APIENTRYP FlushMappedNamedBufferRangeEXT)(GLuint buffer, GLintptr offset, GLsizeiptr length);
    GLvoid* (QOPENGLF_APIENTRYP MapNamedBufferRangeEXT)(GLuint buffer, GLintptr offset, GLsizeiptr length, GLbitfield access);
    GLboolean (QOPENGLF_APIENTRYP UnmapNamedBufferEXT)(GLuint buffer);
    GLvoid* (QOPENGLF_APIENTRYP MapNamedBufferEXT)(GLuint buffer, GLenum access);
    void (QOPENGLF_APIENTRYP NamedBufferSubDataEXT)(GLuint buffer, GLintptr offset, GLsizeiptr size, const GLvoid *data);
    void (QOPENGLF_APIENTRYP NamedBufferDataEXT)(GLuint buffer, GLsizeiptr size, const GLvoid *data, GLenum usage);
    void (QOPENGLF_APIENTRYP ProgramUniform4uivEXT)(GLuint program, GLint location, GLsizei count, const GLuint *value);
    void (QOPENGLF_APIENTRYP ProgramUniform3uivEXT)(GLuint program, GLint location, GLsizei count, const GLuint *value);
    void (QOPENGLF_APIENTRYP ProgramUniform2uivEXT)(GLuint program, GLint location, GLsizei count, const GLuint *value);
    void (QOPENGLF_APIENTRYP ProgramUniform1uivEXT)(GLuint program, GLint location, GLsizei count, const GLuint *value);
    void (QOPENGLF_APIENTRYP ProgramUniform4uiEXT)(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3);
    void (QOPENGLF_APIENTRYP ProgramUniform3uiEXT)(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2);
    void (QOPENGLF_APIENTRYP ProgramUniform2uiEXT)(GLuint program, GLint location, GLuint v0, GLuint v1);
    void (QOPENGLF_APIENTRYP ProgramUniform1uiEXT)(GLuint program, GLint location, GLuint v0);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix4x3fvEXT)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix3x4fvEXT)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix4x2fvEXT)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix2x4fvEXT)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix3x2fvEXT)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix2x3fvEXT)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix4fvEXT)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix3fvEXT)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix2fvEXT)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniform4ivEXT)(GLuint program, GLint location, GLsizei count, const GLint *value);
    void (QOPENGLF_APIENTRYP ProgramUniform3ivEXT)(GLuint program, GLint location, GLsizei count, const GLint *value);
    void (QOPENGLF_APIENTRYP ProgramUniform2ivEXT)(GLuint program, GLint location, GLsizei count, const GLint *value);
    void (QOPENGLF_APIENTRYP ProgramUniform1ivEXT)(GLuint program, GLint location, GLsizei count, const GLint *value);
    void (QOPENGLF_APIENTRYP ProgramUniform4fvEXT)(GLuint program, GLint location, GLsizei count, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniform3fvEXT)(GLuint program, GLint location, GLsizei count, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniform2fvEXT)(GLuint program, GLint location, GLsizei count, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniform1fvEXT)(GLuint program, GLint location, GLsizei count, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniform4iEXT)(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3);
    void (QOPENGLF_APIENTRYP ProgramUniform3iEXT)(GLuint program, GLint location, GLint v0, GLint v1, GLint v2);
    void (QOPENGLF_APIENTRYP ProgramUniform2iEXT)(GLuint program, GLint location, GLint v0, GLint v1);
    void (QOPENGLF_APIENTRYP ProgramUniform1iEXT)(GLuint program, GLint location, GLint v0);
    void (QOPENGLF_APIENTRYP ProgramUniform4fEXT)(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3);
    void (QOPENGLF_APIENTRYP ProgramUniform3fEXT)(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2);
    void (QOPENGLF_APIENTRYP ProgramUniform2fEXT)(GLuint program, GLint location, GLfloat v0, GLfloat v1);
    void (QOPENGLF_APIENTRYP ProgramUniform1fEXT)(GLuint program, GLint location, GLfloat v0);
    void (QOPENGLF_APIENTRYP GetMultiTexParameterIuivEXT)(GLenum texunit, GLenum target, GLenum pname, GLuint *params);
    void (QOPENGLF_APIENTRYP GetMultiTexParameterIivEXT)(GLenum texunit, GLenum target, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP MultiTexParameterIuivEXT)(GLenum texunit, GLenum target, GLenum pname, const GLuint *params);
    void (QOPENGLF_APIENTRYP MultiTexParameterIivEXT)(GLenum texunit, GLenum target, GLenum pname, const GLint *params);
    void (QOPENGLF_APIENTRYP GetTextureParameterIuivEXT)(GLuint texture, GLenum target, GLenum pname, GLuint *params);
    void (QOPENGLF_APIENTRYP GetTextureParameterIivEXT)(GLuint texture, GLenum target, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP TextureParameterIuivEXT)(GLuint texture, GLenum target, GLenum pname, const GLuint *params);
    void (QOPENGLF_APIENTRYP TextureParameterIivEXT)(GLuint texture, GLenum target, GLenum pname, const GLint *params);
    void (QOPENGLF_APIENTRYP GetNamedProgramLocalParameterIuivEXT)(GLuint program, GLenum target, GLuint index, GLuint *params);
    void (QOPENGLF_APIENTRYP GetNamedProgramLocalParameterIivEXT)(GLuint program, GLenum target, GLuint index, GLint *params);
    void (QOPENGLF_APIENTRYP NamedProgramLocalParametersI4uivEXT)(GLuint program, GLenum target, GLuint index, GLsizei count, const GLuint *params);
    void (QOPENGLF_APIENTRYP NamedProgramLocalParameterI4uivEXT)(GLuint program, GLenum target, GLuint index, const GLuint *params);
    void (QOPENGLF_APIENTRYP NamedProgramLocalParameterI4uiEXT)(GLuint program, GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w);
    void (QOPENGLF_APIENTRYP NamedProgramLocalParametersI4ivEXT)(GLuint program, GLenum target, GLuint index, GLsizei count, const GLint *params);
    void (QOPENGLF_APIENTRYP NamedProgramLocalParameterI4ivEXT)(GLuint program, GLenum target, GLuint index, const GLint *params);
    void (QOPENGLF_APIENTRYP NamedProgramLocalParameterI4iEXT)(GLuint program, GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w);
    void (QOPENGLF_APIENTRYP NamedProgramLocalParameters4fvEXT)(GLuint program, GLenum target, GLuint index, GLsizei count, const GLfloat *params);
    void (QOPENGLF_APIENTRYP GetNamedProgramStringEXT)(GLuint program, GLenum target, GLenum pname, GLvoid *string);
    void (QOPENGLF_APIENTRYP GetNamedProgramivEXT)(GLuint program, GLenum target, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetNamedProgramLocalParameterfvEXT)(GLuint program, GLenum target, GLuint index, GLfloat *params);
    void (QOPENGLF_APIENTRYP GetNamedProgramLocalParameterdvEXT)(GLuint program, GLenum target, GLuint index, GLdouble *params);
    void (QOPENGLF_APIENTRYP NamedProgramLocalParameter4fvEXT)(GLuint program, GLenum target, GLuint index, const GLfloat *params);
    void (QOPENGLF_APIENTRYP NamedProgramLocalParameter4fEXT)(GLuint program, GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
    void (QOPENGLF_APIENTRYP NamedProgramLocalParameter4dvEXT)(GLuint program, GLenum target, GLuint index, const GLdouble *params);
    void (QOPENGLF_APIENTRYP NamedProgramLocalParameter4dEXT)(GLuint program, GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
    void (QOPENGLF_APIENTRYP NamedProgramStringEXT)(GLuint program, GLenum target, GLenum format, GLsizei len, const GLvoid *string);
    void (QOPENGLF_APIENTRYP GetCompressedMultiTexImageEXT)(GLenum texunit, GLenum target, GLint lod, GLvoid *img);
    void (QOPENGLF_APIENTRYP CompressedMultiTexSubImage1DEXT)(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *bits);
    void (QOPENGLF_APIENTRYP CompressedMultiTexSubImage2DEXT)(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *bits);
    void (QOPENGLF_APIENTRYP CompressedMultiTexSubImage3DEXT)(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *bits);
    void (QOPENGLF_APIENTRYP CompressedMultiTexImage1DEXT)(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *bits);
    void (QOPENGLF_APIENTRYP CompressedMultiTexImage2DEXT)(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *bits);
    void (QOPENGLF_APIENTRYP CompressedMultiTexImage3DEXT)(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *bits);
    void (QOPENGLF_APIENTRYP GetCompressedTextureImageEXT)(GLuint texture, GLenum target, GLint lod, GLvoid *img);
    void (QOPENGLF_APIENTRYP CompressedTextureSubImage1DEXT)(GLuint texture, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *bits);
    void (QOPENGLF_APIENTRYP CompressedTextureSubImage2DEXT)(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *bits);
    void (QOPENGLF_APIENTRYP CompressedTextureSubImage3DEXT)(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *bits);
    void (QOPENGLF_APIENTRYP CompressedTextureImage1DEXT)(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *bits);
    void (QOPENGLF_APIENTRYP CompressedTextureImage2DEXT)(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *bits);
    void (QOPENGLF_APIENTRYP CompressedTextureImage3DEXT)(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *bits);
    void (QOPENGLF_APIENTRYP GetPointerIndexedvEXT)(GLenum target, GLuint index, GLvoid* *data);
    void (QOPENGLF_APIENTRYP GetDoubleIndexedvEXT)(GLenum target, GLuint index, GLdouble *data);
    void (QOPENGLF_APIENTRYP GetFloatIndexedvEXT)(GLenum target, GLuint index, GLfloat *data);
    void (QOPENGLF_APIENTRYP GetMultiTexGenivEXT)(GLenum texunit, GLenum coord, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetMultiTexGenfvEXT)(GLenum texunit, GLenum coord, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP GetMultiTexGendvEXT)(GLenum texunit, GLenum coord, GLenum pname, GLdouble *params);
    void (QOPENGLF_APIENTRYP GetMultiTexEnvivEXT)(GLenum texunit, GLenum target, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetMultiTexEnvfvEXT)(GLenum texunit, GLenum target, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP MultiTexGenivEXT)(GLenum texunit, GLenum coord, GLenum pname, const GLint *params);
    void (QOPENGLF_APIENTRYP MultiTexGeniEXT)(GLenum texunit, GLenum coord, GLenum pname, GLint param);
    void (QOPENGLF_APIENTRYP MultiTexGenfvEXT)(GLenum texunit, GLenum coord, GLenum pname, const GLfloat *params);
    void (QOPENGLF_APIENTRYP MultiTexGenfEXT)(GLenum texunit, GLenum coord, GLenum pname, GLfloat param);
    void (QOPENGLF_APIENTRYP MultiTexGendvEXT)(GLenum texunit, GLenum coord, GLenum pname, const GLdouble *params);
    void (QOPENGLF_APIENTRYP MultiTexGendEXT)(GLenum texunit, GLenum coord, GLenum pname, GLdouble param);
    void (QOPENGLF_APIENTRYP MultiTexEnvivEXT)(GLenum texunit, GLenum target, GLenum pname, const GLint *params);
    void (QOPENGLF_APIENTRYP MultiTexEnviEXT)(GLenum texunit, GLenum target, GLenum pname, GLint param);
    void (QOPENGLF_APIENTRYP MultiTexEnvfvEXT)(GLenum texunit, GLenum target, GLenum pname, const GLfloat *params);
    void (QOPENGLF_APIENTRYP MultiTexEnvfEXT)(GLenum texunit, GLenum target, GLenum pname, GLfloat param);
    void (QOPENGLF_APIENTRYP MultiTexCoordPointerEXT)(GLenum texunit, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
    void (QOPENGLF_APIENTRYP DisableClientStateIndexedEXT)(GLenum array, GLuint index);
    void (QOPENGLF_APIENTRYP EnableClientStateIndexedEXT)(GLenum array, GLuint index);
    void (QOPENGLF_APIENTRYP BindMultiTextureEXT)(GLenum texunit, GLenum target, GLuint texture);
    void (QOPENGLF_APIENTRYP CopyMultiTexSubImage3DEXT)(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
    void (QOPENGLF_APIENTRYP MultiTexSubImage3DEXT)(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels);
    void (QOPENGLF_APIENTRYP MultiTexImage3DEXT)(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
    void (QOPENGLF_APIENTRYP GetMultiTexLevelParameterivEXT)(GLenum texunit, GLenum target, GLint level, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetMultiTexLevelParameterfvEXT)(GLenum texunit, GLenum target, GLint level, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP GetMultiTexParameterivEXT)(GLenum texunit, GLenum target, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetMultiTexParameterfvEXT)(GLenum texunit, GLenum target, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP GetMultiTexImageEXT)(GLenum texunit, GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels);
    void (QOPENGLF_APIENTRYP CopyMultiTexSubImage2DEXT)(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
    void (QOPENGLF_APIENTRYP CopyMultiTexSubImage1DEXT)(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
    void (QOPENGLF_APIENTRYP CopyMultiTexImage2DEXT)(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
    void (QOPENGLF_APIENTRYP CopyMultiTexImage1DEXT)(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border);
    void (QOPENGLF_APIENTRYP MultiTexSubImage2DEXT)(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
    void (QOPENGLF_APIENTRYP MultiTexSubImage1DEXT)(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels);
    void (QOPENGLF_APIENTRYP MultiTexImage2DEXT)(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
    void (QOPENGLF_APIENTRYP MultiTexImage1DEXT)(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
    void (QOPENGLF_APIENTRYP MultiTexParameterivEXT)(GLenum texunit, GLenum target, GLenum pname, const GLint *params);
    void (QOPENGLF_APIENTRYP MultiTexParameteriEXT)(GLenum texunit, GLenum target, GLenum pname, GLint param);
    void (QOPENGLF_APIENTRYP MultiTexParameterfvEXT)(GLenum texunit, GLenum target, GLenum pname, const GLfloat *params);
    void (QOPENGLF_APIENTRYP MultiTexParameterfEXT)(GLenum texunit, GLenum target, GLenum pname, GLfloat param);
    void (QOPENGLF_APIENTRYP CopyTextureSubImage3DEXT)(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
    void (QOPENGLF_APIENTRYP TextureSubImage3DEXT)(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels);
    void (QOPENGLF_APIENTRYP TextureImage3DEXT)(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
    void (QOPENGLF_APIENTRYP GetTextureLevelParameterivEXT)(GLuint texture, GLenum target, GLint level, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetTextureLevelParameterfvEXT)(GLuint texture, GLenum target, GLint level, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP GetTextureParameterivEXT)(GLuint texture, GLenum target, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetTextureParameterfvEXT)(GLuint texture, GLenum target, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP GetTextureImageEXT)(GLuint texture, GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels);
    void (QOPENGLF_APIENTRYP CopyTextureSubImage2DEXT)(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
    void (QOPENGLF_APIENTRYP CopyTextureSubImage1DEXT)(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
    void (QOPENGLF_APIENTRYP CopyTextureImage2DEXT)(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
    void (QOPENGLF_APIENTRYP CopyTextureImage1DEXT)(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border);
    void (QOPENGLF_APIENTRYP TextureSubImage2DEXT)(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
    void (QOPENGLF_APIENTRYP TextureSubImage1DEXT)(GLuint texture, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels);
    void (QOPENGLF_APIENTRYP TextureImage2DEXT)(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
    void (QOPENGLF_APIENTRYP TextureImage1DEXT)(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
    void (QOPENGLF_APIENTRYP TextureParameterivEXT)(GLuint texture, GLenum target, GLenum pname, const GLint *params);
    void (QOPENGLF_APIENTRYP TextureParameteriEXT)(GLuint texture, GLenum target, GLenum pname, GLint param);
    void (QOPENGLF_APIENTRYP TextureParameterfvEXT)(GLuint texture, GLenum target, GLenum pname, const GLfloat *params);
    void (QOPENGLF_APIENTRYP TextureParameterfEXT)(GLuint texture, GLenum target, GLenum pname, GLfloat param);
    void (QOPENGLF_APIENTRYP MatrixMultTransposedEXT)(GLenum mode, const GLdouble *m);
    void (QOPENGLF_APIENTRYP MatrixMultTransposefEXT)(GLenum mode, const GLfloat *m);
    void (QOPENGLF_APIENTRYP MatrixLoadTransposedEXT)(GLenum mode, const GLdouble *m);
    void (QOPENGLF_APIENTRYP MatrixLoadTransposefEXT)(GLenum mode, const GLfloat *m);
    void (QOPENGLF_APIENTRYP MatrixPushEXT)(GLenum mode);
    void (QOPENGLF_APIENTRYP MatrixPopEXT)(GLenum mode);
    void (QOPENGLF_APIENTRYP MatrixOrthoEXT)(GLenum mode, GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
    void (QOPENGLF_APIENTRYP MatrixFrustumEXT)(GLenum mode, GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
    void (QOPENGLF_APIENTRYP MatrixTranslatedEXT)(GLenum mode, GLdouble x, GLdouble y, GLdouble z);
    void (QOPENGLF_APIENTRYP MatrixTranslatefEXT)(GLenum mode, GLfloat x, GLfloat y, GLfloat z);
    void (QOPENGLF_APIENTRYP MatrixScaledEXT)(GLenum mode, GLdouble x, GLdouble y, GLdouble z);
    void (QOPENGLF_APIENTRYP MatrixScalefEXT)(GLenum mode, GLfloat x, GLfloat y, GLfloat z);
    void (QOPENGLF_APIENTRYP MatrixRotatedEXT)(GLenum mode, GLdouble angle, GLdouble x, GLdouble y, GLdouble z);
    void (QOPENGLF_APIENTRYP MatrixRotatefEXT)(GLenum mode, GLfloat angle, GLfloat x, GLfloat y, GLfloat z);
    void (QOPENGLF_APIENTRYP MatrixLoadIdentityEXT)(GLenum mode);
    void (QOPENGLF_APIENTRYP MatrixMultdEXT)(GLenum mode, const GLdouble *m);
    void (QOPENGLF_APIENTRYP MatrixMultfEXT)(GLenum mode, const GLfloat *m);
    void (QOPENGLF_APIENTRYP MatrixLoaddEXT)(GLenum mode, const GLdouble *m);
    void (QOPENGLF_APIENTRYP MatrixLoadfEXT)(GLenum mode, const GLfloat *m);
    void (QOPENGLF_APIENTRYP PushClientAttribDefaultEXT)(GLbitfield mask);
    void (QOPENGLF_APIENTRYP ClientAttribDefaultEXT)(GLbitfield mask);
    void (QOPENGLF_APIENTRYP TextureStorage3DMultisampleEXT)(GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations);
    void (QOPENGLF_APIENTRYP TextureStorage2DMultisampleEXT)(GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations);
    void (QOPENGLF_APIENTRYP TextureBufferRangeEXT)(GLuint texture, GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size);
    void (QOPENGLF_APIENTRYP GetNamedFramebufferParameterivEXT)(GLuint framebuffer, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP NamedFramebufferParameteriEXT)(GLuint framebuffer, GLenum pname, GLint param);
    void (QOPENGLF_APIENTRYP VertexArrayVertexBindingDivisorEXT)(GLuint vaobj, GLuint bindingindex, GLuint divisor);
    void (QOPENGLF_APIENTRYP VertexArrayVertexAttribBindingEXT)(GLuint vaobj, GLuint attribindex, GLuint bindingindex);
    void (QOPENGLF_APIENTRYP VertexArrayVertexAttribLFormatEXT)(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
    void (QOPENGLF_APIENTRYP VertexArrayVertexAttribIFormatEXT)(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
    void (QOPENGLF_APIENTRYP VertexArrayVertexAttribFormatEXT)(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset);
    void (QOPENGLF_APIENTRYP VertexArrayBindVertexBufferEXT)(GLuint vaobj, GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride);
    void (QOPENGLF_APIENTRYP ClearNamedBufferSubDataEXT)(GLuint buffer, GLenum internalformat, GLsizeiptr offset, GLsizeiptr size, GLenum format, GLenum type, const void *data);
    void (QOPENGLF_APIENTRYP ClearNamedBufferDataEXT)(GLuint buffer, GLenum internalformat, GLenum format, GLenum type, const void *data);
    void (QOPENGLF_APIENTRYP TextureStorage3DEXT)(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth);
    void (QOPENGLF_APIENTRYP TextureStorage2DEXT)(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height);
    void (QOPENGLF_APIENTRYP TextureStorage1DEXT)(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width);
};

class QOpenGLExtension_EXT_direct_state_access : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_direct_state_access();

    bool initializeOpenGLFunctions() final;

    void glProgramUniformMatrix4x3dvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void glProgramUniformMatrix4x2dvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void glProgramUniformMatrix3x4dvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void glProgramUniformMatrix3x2dvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void glProgramUniformMatrix2x4dvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void glProgramUniformMatrix2x3dvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void glProgramUniformMatrix4dvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void glProgramUniformMatrix3dvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void glProgramUniformMatrix2dvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
    void glProgramUniform4dvEXT(GLuint program, GLint location, GLsizei count, const GLdouble *value);
    void glProgramUniform3dvEXT(GLuint program, GLint location, GLsizei count, const GLdouble *value);
    void glProgramUniform2dvEXT(GLuint program, GLint location, GLsizei count, const GLdouble *value);
    void glProgramUniform1dvEXT(GLuint program, GLint location, GLsizei count, const GLdouble *value);
    void glProgramUniform4dEXT(GLuint program, GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
    void glProgramUniform3dEXT(GLuint program, GLint location, GLdouble x, GLdouble y, GLdouble z);
    void glProgramUniform2dEXT(GLuint program, GLint location, GLdouble x, GLdouble y);
    void glProgramUniform1dEXT(GLuint program, GLint location, GLdouble x);
    void glMultiTexRenderbufferEXT(GLenum texunit, GLenum target, GLuint renderbuffer);
    void glTextureRenderbufferEXT(GLuint texture, GLenum target, GLuint renderbuffer);
    void glNamedFramebufferTextureFaceEXT(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLenum face);
    void glNamedFramebufferTextureLayerEXT(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLint layer);
    void glNamedFramebufferTextureEXT(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level);
    void glNamedRenderbufferStorageMultisampleCoverageEXT(GLuint renderbuffer, GLsizei coverageSamples, GLsizei colorSamples, GLenum internalformat, GLsizei width, GLsizei height);
    void glNamedRenderbufferStorageMultisampleEXT(GLuint renderbuffer, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
    void glGetFramebufferParameterivEXT(GLuint framebuffer, GLenum pname, GLint *params);
    void glFramebufferReadBufferEXT(GLuint framebuffer, GLenum mode);
    void glFramebufferDrawBuffersEXT(GLuint framebuffer, GLsizei n, const GLenum *bufs);
    void glFramebufferDrawBufferEXT(GLuint framebuffer, GLenum mode);
    void glGenerateMultiTexMipmapEXT(GLenum texunit, GLenum target);
    void glGenerateTextureMipmapEXT(GLuint texture, GLenum target);
    void glGetNamedFramebufferAttachmentParameterivEXT(GLuint framebuffer, GLenum attachment, GLenum pname, GLint *params);
    void glNamedFramebufferRenderbufferEXT(GLuint framebuffer, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
    void glNamedFramebufferTexture3DEXT(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset);
    void glNamedFramebufferTexture2DEXT(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
    void glNamedFramebufferTexture1DEXT(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
    GLenum glCheckNamedFramebufferStatusEXT(GLuint framebuffer, GLenum target);
    void glGetNamedRenderbufferParameterivEXT(GLuint renderbuffer, GLenum pname, GLint *params);
    void glNamedRenderbufferStorageEXT(GLuint renderbuffer, GLenum internalformat, GLsizei width, GLsizei height);
    void glMultiTexBufferEXT(GLenum texunit, GLenum target, GLenum internalformat, GLuint buffer);
    void glTextureBufferEXT(GLuint texture, GLenum target, GLenum internalformat, GLuint buffer);
    void glGetNamedBufferSubDataEXT(GLuint buffer, GLintptr offset, GLsizeiptr size, GLvoid *data);
    void glGetNamedBufferPointervEXT(GLuint buffer, GLenum pname, GLvoid* *params);
    void glGetNamedBufferParameterivEXT(GLuint buffer, GLenum pname, GLint *params);
    void glNamedCopyBufferSubDataEXT(GLuint readBuffer, GLuint writeBuffer, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size);
    void glFlushMappedNamedBufferRangeEXT(GLuint buffer, GLintptr offset, GLsizeiptr length);
    GLvoid* glMapNamedBufferRangeEXT(GLuint buffer, GLintptr offset, GLsizeiptr length, GLbitfield access);
    GLboolean glUnmapNamedBufferEXT(GLuint buffer);
    GLvoid* glMapNamedBufferEXT(GLuint buffer, GLenum access);
    void glNamedBufferSubDataEXT(GLuint buffer, GLintptr offset, GLsizeiptr size, const GLvoid *data);
    void glNamedBufferDataEXT(GLuint buffer, GLsizeiptr size, const GLvoid *data, GLenum usage);
    void glProgramUniform4uivEXT(GLuint program, GLint location, GLsizei count, const GLuint *value);
    void glProgramUniform3uivEXT(GLuint program, GLint location, GLsizei count, const GLuint *value);
    void glProgramUniform2uivEXT(GLuint program, GLint location, GLsizei count, const GLuint *value);
    void glProgramUniform1uivEXT(GLuint program, GLint location, GLsizei count, const GLuint *value);
    void glProgramUniform4uiEXT(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3);
    void glProgramUniform3uiEXT(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2);
    void glProgramUniform2uiEXT(GLuint program, GLint location, GLuint v0, GLuint v1);
    void glProgramUniform1uiEXT(GLuint program, GLint location, GLuint v0);
    void glProgramUniformMatrix4x3fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glProgramUniformMatrix3x4fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glProgramUniformMatrix4x2fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glProgramUniformMatrix2x4fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glProgramUniformMatrix3x2fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glProgramUniformMatrix2x3fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glProgramUniformMatrix4fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glProgramUniformMatrix3fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glProgramUniformMatrix2fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glProgramUniform4ivEXT(GLuint program, GLint location, GLsizei count, const GLint *value);
    void glProgramUniform3ivEXT(GLuint program, GLint location, GLsizei count, const GLint *value);
    void glProgramUniform2ivEXT(GLuint program, GLint location, GLsizei count, const GLint *value);
    void glProgramUniform1ivEXT(GLuint program, GLint location, GLsizei count, const GLint *value);
    void glProgramUniform4fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat *value);
    void glProgramUniform3fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat *value);
    void glProgramUniform2fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat *value);
    void glProgramUniform1fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat *value);
    void glProgramUniform4iEXT(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3);
    void glProgramUniform3iEXT(GLuint program, GLint location, GLint v0, GLint v1, GLint v2);
    void glProgramUniform2iEXT(GLuint program, GLint location, GLint v0, GLint v1);
    void glProgramUniform1iEXT(GLuint program, GLint location, GLint v0);
    void glProgramUniform4fEXT(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3);
    void glProgramUniform3fEXT(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2);
    void glProgramUniform2fEXT(GLuint program, GLint location, GLfloat v0, GLfloat v1);
    void glProgramUniform1fEXT(GLuint program, GLint location, GLfloat v0);
    void glGetMultiTexParameterIuivEXT(GLenum texunit, GLenum target, GLenum pname, GLuint *params);
    void glGetMultiTexParameterIivEXT(GLenum texunit, GLenum target, GLenum pname, GLint *params);
    void glMultiTexParameterIuivEXT(GLenum texunit, GLenum target, GLenum pname, const GLuint *params);
    void glMultiTexParameterIivEXT(GLenum texunit, GLenum target, GLenum pname, const GLint *params);
    void glGetTextureParameterIuivEXT(GLuint texture, GLenum target, GLenum pname, GLuint *params);
    void glGetTextureParameterIivEXT(GLuint texture, GLenum target, GLenum pname, GLint *params);
    void glTextureParameterIuivEXT(GLuint texture, GLenum target, GLenum pname, const GLuint *params);
    void glTextureParameterIivEXT(GLuint texture, GLenum target, GLenum pname, const GLint *params);
    void glGetNamedProgramLocalParameterIuivEXT(GLuint program, GLenum target, GLuint index, GLuint *params);
    void glGetNamedProgramLocalParameterIivEXT(GLuint program, GLenum target, GLuint index, GLint *params);
    void glNamedProgramLocalParametersI4uivEXT(GLuint program, GLenum target, GLuint index, GLsizei count, const GLuint *params);
    void glNamedProgramLocalParameterI4uivEXT(GLuint program, GLenum target, GLuint index, const GLuint *params);
    void glNamedProgramLocalParameterI4uiEXT(GLuint program, GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w);
    void glNamedProgramLocalParametersI4ivEXT(GLuint program, GLenum target, GLuint index, GLsizei count, const GLint *params);
    void glNamedProgramLocalParameterI4ivEXT(GLuint program, GLenum target, GLuint index, const GLint *params);
    void glNamedProgramLocalParameterI4iEXT(GLuint program, GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w);
    void glNamedProgramLocalParameters4fvEXT(GLuint program, GLenum target, GLuint index, GLsizei count, const GLfloat *params);
    void glGetNamedProgramStringEXT(GLuint program, GLenum target, GLenum pname, GLvoid *string);
    void glGetNamedProgramivEXT(GLuint program, GLenum target, GLenum pname, GLint *params);
    void glGetNamedProgramLocalParameterfvEXT(GLuint program, GLenum target, GLuint index, GLfloat *params);
    void glGetNamedProgramLocalParameterdvEXT(GLuint program, GLenum target, GLuint index, GLdouble *params);
    void glNamedProgramLocalParameter4fvEXT(GLuint program, GLenum target, GLuint index, const GLfloat *params);
    void glNamedProgramLocalParameter4fEXT(GLuint program, GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
    void glNamedProgramLocalParameter4dvEXT(GLuint program, GLenum target, GLuint index, const GLdouble *params);
    void glNamedProgramLocalParameter4dEXT(GLuint program, GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
    void glNamedProgramStringEXT(GLuint program, GLenum target, GLenum format, GLsizei len, const GLvoid *string);
    void glGetCompressedMultiTexImageEXT(GLenum texunit, GLenum target, GLint lod, GLvoid *img);
    void glCompressedMultiTexSubImage1DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *bits);
    void glCompressedMultiTexSubImage2DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *bits);
    void glCompressedMultiTexSubImage3DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *bits);
    void glCompressedMultiTexImage1DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *bits);
    void glCompressedMultiTexImage2DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *bits);
    void glCompressedMultiTexImage3DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *bits);
    void glGetCompressedTextureImageEXT(GLuint texture, GLenum target, GLint lod, GLvoid *img);
    void glCompressedTextureSubImage1DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *bits);
    void glCompressedTextureSubImage2DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *bits);
    void glCompressedTextureSubImage3DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *bits);
    void glCompressedTextureImage1DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *bits);
    void glCompressedTextureImage2DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *bits);
    void glCompressedTextureImage3DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *bits);
    void glGetPointerIndexedvEXT(GLenum target, GLuint index, GLvoid* *data);
    void glGetDoubleIndexedvEXT(GLenum target, GLuint index, GLdouble *data);
    void glGetFloatIndexedvEXT(GLenum target, GLuint index, GLfloat *data);
    void glGetMultiTexGenivEXT(GLenum texunit, GLenum coord, GLenum pname, GLint *params);
    void glGetMultiTexGenfvEXT(GLenum texunit, GLenum coord, GLenum pname, GLfloat *params);
    void glGetMultiTexGendvEXT(GLenum texunit, GLenum coord, GLenum pname, GLdouble *params);
    void glGetMultiTexEnvivEXT(GLenum texunit, GLenum target, GLenum pname, GLint *params);
    void glGetMultiTexEnvfvEXT(GLenum texunit, GLenum target, GLenum pname, GLfloat *params);
    void glMultiTexGenivEXT(GLenum texunit, GLenum coord, GLenum pname, const GLint *params);
    void glMultiTexGeniEXT(GLenum texunit, GLenum coord, GLenum pname, GLint param);
    void glMultiTexGenfvEXT(GLenum texunit, GLenum coord, GLenum pname, const GLfloat *params);
    void glMultiTexGenfEXT(GLenum texunit, GLenum coord, GLenum pname, GLfloat param);
    void glMultiTexGendvEXT(GLenum texunit, GLenum coord, GLenum pname, const GLdouble *params);
    void glMultiTexGendEXT(GLenum texunit, GLenum coord, GLenum pname, GLdouble param);
    void glMultiTexEnvivEXT(GLenum texunit, GLenum target, GLenum pname, const GLint *params);
    void glMultiTexEnviEXT(GLenum texunit, GLenum target, GLenum pname, GLint param);
    void glMultiTexEnvfvEXT(GLenum texunit, GLenum target, GLenum pname, const GLfloat *params);
    void glMultiTexEnvfEXT(GLenum texunit, GLenum target, GLenum pname, GLfloat param);
    void glMultiTexCoordPointerEXT(GLenum texunit, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
    void glDisableClientStateIndexedEXT(GLenum array, GLuint index);
    void glEnableClientStateIndexedEXT(GLenum array, GLuint index);
    void glBindMultiTextureEXT(GLenum texunit, GLenum target, GLuint texture);
    void glCopyMultiTexSubImage3DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
    void glMultiTexSubImage3DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels);
    void glMultiTexImage3DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
    void glGetMultiTexLevelParameterivEXT(GLenum texunit, GLenum target, GLint level, GLenum pname, GLint *params);
    void glGetMultiTexLevelParameterfvEXT(GLenum texunit, GLenum target, GLint level, GLenum pname, GLfloat *params);
    void glGetMultiTexParameterivEXT(GLenum texunit, GLenum target, GLenum pname, GLint *params);
    void glGetMultiTexParameterfvEXT(GLenum texunit, GLenum target, GLenum pname, GLfloat *params);
    void glGetMultiTexImageEXT(GLenum texunit, GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels);
    void glCopyMultiTexSubImage2DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
    void glCopyMultiTexSubImage1DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
    void glCopyMultiTexImage2DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
    void glCopyMultiTexImage1DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border);
    void glMultiTexSubImage2DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
    void glMultiTexSubImage1DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels);
    void glMultiTexImage2DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
    void glMultiTexImage1DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
    void glMultiTexParameterivEXT(GLenum texunit, GLenum target, GLenum pname, const GLint *params);
    void glMultiTexParameteriEXT(GLenum texunit, GLenum target, GLenum pname, GLint param);
    void glMultiTexParameterfvEXT(GLenum texunit, GLenum target, GLenum pname, const GLfloat *params);
    void glMultiTexParameterfEXT(GLenum texunit, GLenum target, GLenum pname, GLfloat param);
    void glCopyTextureSubImage3DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
    void glTextureSubImage3DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels);
    void glTextureImage3DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
    void glGetTextureLevelParameterivEXT(GLuint texture, GLenum target, GLint level, GLenum pname, GLint *params);
    void glGetTextureLevelParameterfvEXT(GLuint texture, GLenum target, GLint level, GLenum pname, GLfloat *params);
    void glGetTextureParameterivEXT(GLuint texture, GLenum target, GLenum pname, GLint *params);
    void glGetTextureParameterfvEXT(GLuint texture, GLenum target, GLenum pname, GLfloat *params);
    void glGetTextureImageEXT(GLuint texture, GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels);
    void glCopyTextureSubImage2DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
    void glCopyTextureSubImage1DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
    void glCopyTextureImage2DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
    void glCopyTextureImage1DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border);
    void glTextureSubImage2DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
    void glTextureSubImage1DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels);
    void glTextureImage2DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
    void glTextureImage1DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
    void glTextureParameterivEXT(GLuint texture, GLenum target, GLenum pname, const GLint *params);
    void glTextureParameteriEXT(GLuint texture, GLenum target, GLenum pname, GLint param);
    void glTextureParameterfvEXT(GLuint texture, GLenum target, GLenum pname, const GLfloat *params);
    void glTextureParameterfEXT(GLuint texture, GLenum target, GLenum pname, GLfloat param);
    void glMatrixMultTransposedEXT(GLenum mode, const GLdouble *m);
    void glMatrixMultTransposefEXT(GLenum mode, const GLfloat *m);
    void glMatrixLoadTransposedEXT(GLenum mode, const GLdouble *m);
    void glMatrixLoadTransposefEXT(GLenum mode, const GLfloat *m);
    void glMatrixPushEXT(GLenum mode);
    void glMatrixPopEXT(GLenum mode);
    void glMatrixOrthoEXT(GLenum mode, GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
    void glMatrixFrustumEXT(GLenum mode, GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
    void glMatrixTranslatedEXT(GLenum mode, GLdouble x, GLdouble y, GLdouble z);
    void glMatrixTranslatefEXT(GLenum mode, GLfloat x, GLfloat y, GLfloat z);
    void glMatrixScaledEXT(GLenum mode, GLdouble x, GLdouble y, GLdouble z);
    void glMatrixScalefEXT(GLenum mode, GLfloat x, GLfloat y, GLfloat z);
    void glMatrixRotatedEXT(GLenum mode, GLdouble angle, GLdouble x, GLdouble y, GLdouble z);
    void glMatrixRotatefEXT(GLenum mode, GLfloat angle, GLfloat x, GLfloat y, GLfloat z);
    void glMatrixLoadIdentityEXT(GLenum mode);
    void glMatrixMultdEXT(GLenum mode, const GLdouble *m);
    void glMatrixMultfEXT(GLenum mode, const GLfloat *m);
    void glMatrixLoaddEXT(GLenum mode, const GLdouble *m);
    void glMatrixLoadfEXT(GLenum mode, const GLfloat *m);
    void glPushClientAttribDefaultEXT(GLbitfield mask);
    void glClientAttribDefaultEXT(GLbitfield mask);
    void glTextureStorage3DMultisampleEXT(GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations);
    void glTextureStorage2DMultisampleEXT(GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations);
    void glTextureBufferRangeEXT(GLuint texture, GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size);
    void glGetNamedFramebufferParameterivEXT(GLuint framebuffer, GLenum pname, GLint *params);
    void glNamedFramebufferParameteriEXT(GLuint framebuffer, GLenum pname, GLint param);
    void glVertexArrayVertexBindingDivisorEXT(GLuint vaobj, GLuint bindingindex, GLuint divisor);
    void glVertexArrayVertexAttribBindingEXT(GLuint vaobj, GLuint attribindex, GLuint bindingindex);
    void glVertexArrayVertexAttribLFormatEXT(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
    void glVertexArrayVertexAttribIFormatEXT(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
    void glVertexArrayVertexAttribFormatEXT(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset);
    void glVertexArrayBindVertexBufferEXT(GLuint vaobj, GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride);
    void glClearNamedBufferSubDataEXT(GLuint buffer, GLenum internalformat, GLsizeiptr offset, GLsizeiptr size, GLenum format, GLenum type, const void *data);
    void glClearNamedBufferDataEXT(GLuint buffer, GLenum internalformat, GLenum format, GLenum type, const void *data);
    void glTextureStorage3DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth);
    void glTextureStorage2DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height);
    void glTextureStorage1DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_direct_state_access)
};

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniformMatrix4x3dvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniformMatrix4x3dvEXT(program, location, count, transpose, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniformMatrix4x2dvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniformMatrix4x2dvEXT(program, location, count, transpose, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniformMatrix3x4dvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniformMatrix3x4dvEXT(program, location, count, transpose, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniformMatrix3x2dvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniformMatrix3x2dvEXT(program, location, count, transpose, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniformMatrix2x4dvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniformMatrix2x4dvEXT(program, location, count, transpose, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniformMatrix2x3dvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniformMatrix2x3dvEXT(program, location, count, transpose, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniformMatrix4dvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniformMatrix4dvEXT(program, location, count, transpose, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniformMatrix3dvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniformMatrix3dvEXT(program, location, count, transpose, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniformMatrix2dvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniformMatrix2dvEXT(program, location, count, transpose, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform4dvEXT(GLuint program, GLint location, GLsizei count, const GLdouble *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform4dvEXT(program, location, count, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform3dvEXT(GLuint program, GLint location, GLsizei count, const GLdouble *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform3dvEXT(program, location, count, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform2dvEXT(GLuint program, GLint location, GLsizei count, const GLdouble *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform2dvEXT(program, location, count, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform1dvEXT(GLuint program, GLint location, GLsizei count, const GLdouble *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform1dvEXT(program, location, count, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform4dEXT(GLuint program, GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform4dEXT(program, location, x, y, z, w);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform3dEXT(GLuint program, GLint location, GLdouble x, GLdouble y, GLdouble z)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform3dEXT(program, location, x, y, z);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform2dEXT(GLuint program, GLint location, GLdouble x, GLdouble y)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform2dEXT(program, location, x, y);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform1dEXT(GLuint program, GLint location, GLdouble x)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform1dEXT(program, location, x);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMultiTexRenderbufferEXT(GLenum texunit, GLenum target, GLuint renderbuffer)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MultiTexRenderbufferEXT(texunit, target, renderbuffer);
}

inline void QOpenGLExtension_EXT_direct_state_access::glTextureRenderbufferEXT(GLuint texture, GLenum target, GLuint renderbuffer)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->TextureRenderbufferEXT(texture, target, renderbuffer);
}

inline void QOpenGLExtension_EXT_direct_state_access::glNamedFramebufferTextureFaceEXT(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLenum face)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->NamedFramebufferTextureFaceEXT(framebuffer, attachment, texture, level, face);
}

inline void QOpenGLExtension_EXT_direct_state_access::glNamedFramebufferTextureLayerEXT(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLint layer)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->NamedFramebufferTextureLayerEXT(framebuffer, attachment, texture, level, layer);
}

inline void QOpenGLExtension_EXT_direct_state_access::glNamedFramebufferTextureEXT(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->NamedFramebufferTextureEXT(framebuffer, attachment, texture, level);
}

inline void QOpenGLExtension_EXT_direct_state_access::glNamedRenderbufferStorageMultisampleCoverageEXT(GLuint renderbuffer, GLsizei coverageSamples, GLsizei colorSamples, GLenum internalformat, GLsizei width, GLsizei height)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->NamedRenderbufferStorageMultisampleCoverageEXT(renderbuffer, coverageSamples, colorSamples, internalformat, width, height);
}

inline void QOpenGLExtension_EXT_direct_state_access::glNamedRenderbufferStorageMultisampleEXT(GLuint renderbuffer, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->NamedRenderbufferStorageMultisampleEXT(renderbuffer, samples, internalformat, width, height);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetFramebufferParameterivEXT(GLuint framebuffer, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetFramebufferParameterivEXT(framebuffer, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glFramebufferReadBufferEXT(GLuint framebuffer, GLenum mode)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->FramebufferReadBufferEXT(framebuffer, mode);
}

inline void QOpenGLExtension_EXT_direct_state_access::glFramebufferDrawBuffersEXT(GLuint framebuffer, GLsizei n, const GLenum *bufs)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->FramebufferDrawBuffersEXT(framebuffer, n, bufs);
}

inline void QOpenGLExtension_EXT_direct_state_access::glFramebufferDrawBufferEXT(GLuint framebuffer, GLenum mode)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->FramebufferDrawBufferEXT(framebuffer, mode);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGenerateMultiTexMipmapEXT(GLenum texunit, GLenum target)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GenerateMultiTexMipmapEXT(texunit, target);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGenerateTextureMipmapEXT(GLuint texture, GLenum target)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GenerateTextureMipmapEXT(texture, target);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetNamedFramebufferAttachmentParameterivEXT(GLuint framebuffer, GLenum attachment, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetNamedFramebufferAttachmentParameterivEXT(framebuffer, attachment, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glNamedFramebufferRenderbufferEXT(GLuint framebuffer, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->NamedFramebufferRenderbufferEXT(framebuffer, attachment, renderbuffertarget, renderbuffer);
}

inline void QOpenGLExtension_EXT_direct_state_access::glNamedFramebufferTexture3DEXT(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->NamedFramebufferTexture3DEXT(framebuffer, attachment, textarget, texture, level, zoffset);
}

inline void QOpenGLExtension_EXT_direct_state_access::glNamedFramebufferTexture2DEXT(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->NamedFramebufferTexture2DEXT(framebuffer, attachment, textarget, texture, level);
}

inline void QOpenGLExtension_EXT_direct_state_access::glNamedFramebufferTexture1DEXT(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->NamedFramebufferTexture1DEXT(framebuffer, attachment, textarget, texture, level);
}

inline GLenum QOpenGLExtension_EXT_direct_state_access::glCheckNamedFramebufferStatusEXT(GLuint framebuffer, GLenum target)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    return d->CheckNamedFramebufferStatusEXT(framebuffer, target);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetNamedRenderbufferParameterivEXT(GLuint renderbuffer, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetNamedRenderbufferParameterivEXT(renderbuffer, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glNamedRenderbufferStorageEXT(GLuint renderbuffer, GLenum internalformat, GLsizei width, GLsizei height)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->NamedRenderbufferStorageEXT(renderbuffer, internalformat, width, height);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMultiTexBufferEXT(GLenum texunit, GLenum target, GLenum internalformat, GLuint buffer)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MultiTexBufferEXT(texunit, target, internalformat, buffer);
}

inline void QOpenGLExtension_EXT_direct_state_access::glTextureBufferEXT(GLuint texture, GLenum target, GLenum internalformat, GLuint buffer)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->TextureBufferEXT(texture, target, internalformat, buffer);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetNamedBufferSubDataEXT(GLuint buffer, GLintptr offset, GLsizeiptr size, GLvoid *data)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetNamedBufferSubDataEXT(buffer, offset, size, data);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetNamedBufferPointervEXT(GLuint buffer, GLenum pname, GLvoid* *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetNamedBufferPointervEXT(buffer, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetNamedBufferParameterivEXT(GLuint buffer, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetNamedBufferParameterivEXT(buffer, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glNamedCopyBufferSubDataEXT(GLuint readBuffer, GLuint writeBuffer, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->NamedCopyBufferSubDataEXT(readBuffer, writeBuffer, readOffset, writeOffset, size);
}

inline void QOpenGLExtension_EXT_direct_state_access::glFlushMappedNamedBufferRangeEXT(GLuint buffer, GLintptr offset, GLsizeiptr length)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->FlushMappedNamedBufferRangeEXT(buffer, offset, length);
}

inline GLvoid* QOpenGLExtension_EXT_direct_state_access::glMapNamedBufferRangeEXT(GLuint buffer, GLintptr offset, GLsizeiptr length, GLbitfield access)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    return d->MapNamedBufferRangeEXT(buffer, offset, length, access);
}

inline GLboolean QOpenGLExtension_EXT_direct_state_access::glUnmapNamedBufferEXT(GLuint buffer)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    return d->UnmapNamedBufferEXT(buffer);
}

inline GLvoid* QOpenGLExtension_EXT_direct_state_access::glMapNamedBufferEXT(GLuint buffer, GLenum access)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    return d->MapNamedBufferEXT(buffer, access);
}

inline void QOpenGLExtension_EXT_direct_state_access::glNamedBufferSubDataEXT(GLuint buffer, GLintptr offset, GLsizeiptr size, const GLvoid *data)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->NamedBufferSubDataEXT(buffer, offset, size, data);
}

inline void QOpenGLExtension_EXT_direct_state_access::glNamedBufferDataEXT(GLuint buffer, GLsizeiptr size, const GLvoid *data, GLenum usage)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->NamedBufferDataEXT(buffer, size, data, usage);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform4uivEXT(GLuint program, GLint location, GLsizei count, const GLuint *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform4uivEXT(program, location, count, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform3uivEXT(GLuint program, GLint location, GLsizei count, const GLuint *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform3uivEXT(program, location, count, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform2uivEXT(GLuint program, GLint location, GLsizei count, const GLuint *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform2uivEXT(program, location, count, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform1uivEXT(GLuint program, GLint location, GLsizei count, const GLuint *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform1uivEXT(program, location, count, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform4uiEXT(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform4uiEXT(program, location, v0, v1, v2, v3);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform3uiEXT(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform3uiEXT(program, location, v0, v1, v2);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform2uiEXT(GLuint program, GLint location, GLuint v0, GLuint v1)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform2uiEXT(program, location, v0, v1);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform1uiEXT(GLuint program, GLint location, GLuint v0)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform1uiEXT(program, location, v0);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniformMatrix4x3fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniformMatrix4x3fvEXT(program, location, count, transpose, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniformMatrix3x4fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniformMatrix3x4fvEXT(program, location, count, transpose, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniformMatrix4x2fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniformMatrix4x2fvEXT(program, location, count, transpose, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniformMatrix2x4fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniformMatrix2x4fvEXT(program, location, count, transpose, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniformMatrix3x2fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniformMatrix3x2fvEXT(program, location, count, transpose, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniformMatrix2x3fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniformMatrix2x3fvEXT(program, location, count, transpose, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniformMatrix4fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniformMatrix4fvEXT(program, location, count, transpose, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniformMatrix3fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniformMatrix3fvEXT(program, location, count, transpose, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniformMatrix2fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniformMatrix2fvEXT(program, location, count, transpose, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform4ivEXT(GLuint program, GLint location, GLsizei count, const GLint *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform4ivEXT(program, location, count, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform3ivEXT(GLuint program, GLint location, GLsizei count, const GLint *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform3ivEXT(program, location, count, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform2ivEXT(GLuint program, GLint location, GLsizei count, const GLint *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform2ivEXT(program, location, count, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform1ivEXT(GLuint program, GLint location, GLsizei count, const GLint *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform1ivEXT(program, location, count, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform4fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform4fvEXT(program, location, count, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform3fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform3fvEXT(program, location, count, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform2fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform2fvEXT(program, location, count, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform1fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat *value)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform1fvEXT(program, location, count, value);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform4iEXT(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform4iEXT(program, location, v0, v1, v2, v3);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform3iEXT(GLuint program, GLint location, GLint v0, GLint v1, GLint v2)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform3iEXT(program, location, v0, v1, v2);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform2iEXT(GLuint program, GLint location, GLint v0, GLint v1)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform2iEXT(program, location, v0, v1);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform1iEXT(GLuint program, GLint location, GLint v0)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform1iEXT(program, location, v0);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform4fEXT(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform4fEXT(program, location, v0, v1, v2, v3);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform3fEXT(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform3fEXT(program, location, v0, v1, v2);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform2fEXT(GLuint program, GLint location, GLfloat v0, GLfloat v1)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform2fEXT(program, location, v0, v1);
}

inline void QOpenGLExtension_EXT_direct_state_access::glProgramUniform1fEXT(GLuint program, GLint location, GLfloat v0)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ProgramUniform1fEXT(program, location, v0);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetMultiTexParameterIuivEXT(GLenum texunit, GLenum target, GLenum pname, GLuint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetMultiTexParameterIuivEXT(texunit, target, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetMultiTexParameterIivEXT(GLenum texunit, GLenum target, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetMultiTexParameterIivEXT(texunit, target, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMultiTexParameterIuivEXT(GLenum texunit, GLenum target, GLenum pname, const GLuint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MultiTexParameterIuivEXT(texunit, target, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMultiTexParameterIivEXT(GLenum texunit, GLenum target, GLenum pname, const GLint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MultiTexParameterIivEXT(texunit, target, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetTextureParameterIuivEXT(GLuint texture, GLenum target, GLenum pname, GLuint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetTextureParameterIuivEXT(texture, target, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetTextureParameterIivEXT(GLuint texture, GLenum target, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetTextureParameterIivEXT(texture, target, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glTextureParameterIuivEXT(GLuint texture, GLenum target, GLenum pname, const GLuint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->TextureParameterIuivEXT(texture, target, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glTextureParameterIivEXT(GLuint texture, GLenum target, GLenum pname, const GLint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->TextureParameterIivEXT(texture, target, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetNamedProgramLocalParameterIuivEXT(GLuint program, GLenum target, GLuint index, GLuint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetNamedProgramLocalParameterIuivEXT(program, target, index, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetNamedProgramLocalParameterIivEXT(GLuint program, GLenum target, GLuint index, GLint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetNamedProgramLocalParameterIivEXT(program, target, index, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glNamedProgramLocalParametersI4uivEXT(GLuint program, GLenum target, GLuint index, GLsizei count, const GLuint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->NamedProgramLocalParametersI4uivEXT(program, target, index, count, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glNamedProgramLocalParameterI4uivEXT(GLuint program, GLenum target, GLuint index, const GLuint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->NamedProgramLocalParameterI4uivEXT(program, target, index, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glNamedProgramLocalParameterI4uiEXT(GLuint program, GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->NamedProgramLocalParameterI4uiEXT(program, target, index, x, y, z, w);
}

inline void QOpenGLExtension_EXT_direct_state_access::glNamedProgramLocalParametersI4ivEXT(GLuint program, GLenum target, GLuint index, GLsizei count, const GLint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->NamedProgramLocalParametersI4ivEXT(program, target, index, count, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glNamedProgramLocalParameterI4ivEXT(GLuint program, GLenum target, GLuint index, const GLint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->NamedProgramLocalParameterI4ivEXT(program, target, index, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glNamedProgramLocalParameterI4iEXT(GLuint program, GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->NamedProgramLocalParameterI4iEXT(program, target, index, x, y, z, w);
}

inline void QOpenGLExtension_EXT_direct_state_access::glNamedProgramLocalParameters4fvEXT(GLuint program, GLenum target, GLuint index, GLsizei count, const GLfloat *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->NamedProgramLocalParameters4fvEXT(program, target, index, count, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetNamedProgramStringEXT(GLuint program, GLenum target, GLenum pname, GLvoid *string)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetNamedProgramStringEXT(program, target, pname, string);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetNamedProgramivEXT(GLuint program, GLenum target, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetNamedProgramivEXT(program, target, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetNamedProgramLocalParameterfvEXT(GLuint program, GLenum target, GLuint index, GLfloat *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetNamedProgramLocalParameterfvEXT(program, target, index, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetNamedProgramLocalParameterdvEXT(GLuint program, GLenum target, GLuint index, GLdouble *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetNamedProgramLocalParameterdvEXT(program, target, index, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glNamedProgramLocalParameter4fvEXT(GLuint program, GLenum target, GLuint index, const GLfloat *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->NamedProgramLocalParameter4fvEXT(program, target, index, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glNamedProgramLocalParameter4fEXT(GLuint program, GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->NamedProgramLocalParameter4fEXT(program, target, index, x, y, z, w);
}

inline void QOpenGLExtension_EXT_direct_state_access::glNamedProgramLocalParameter4dvEXT(GLuint program, GLenum target, GLuint index, const GLdouble *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->NamedProgramLocalParameter4dvEXT(program, target, index, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glNamedProgramLocalParameter4dEXT(GLuint program, GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->NamedProgramLocalParameter4dEXT(program, target, index, x, y, z, w);
}

inline void QOpenGLExtension_EXT_direct_state_access::glNamedProgramStringEXT(GLuint program, GLenum target, GLenum format, GLsizei len, const GLvoid *string)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->NamedProgramStringEXT(program, target, format, len, string);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetCompressedMultiTexImageEXT(GLenum texunit, GLenum target, GLint lod, GLvoid *img)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetCompressedMultiTexImageEXT(texunit, target, lod, img);
}

inline void QOpenGLExtension_EXT_direct_state_access::glCompressedMultiTexSubImage1DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *bits)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->CompressedMultiTexSubImage1DEXT(texunit, target, level, xoffset, width, format, imageSize, bits);
}

inline void QOpenGLExtension_EXT_direct_state_access::glCompressedMultiTexSubImage2DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *bits)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->CompressedMultiTexSubImage2DEXT(texunit, target, level, xoffset, yoffset, width, height, format, imageSize, bits);
}

inline void QOpenGLExtension_EXT_direct_state_access::glCompressedMultiTexSubImage3DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *bits)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->CompressedMultiTexSubImage3DEXT(texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, bits);
}

inline void QOpenGLExtension_EXT_direct_state_access::glCompressedMultiTexImage1DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *bits)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->CompressedMultiTexImage1DEXT(texunit, target, level, internalformat, width, border, imageSize, bits);
}

inline void QOpenGLExtension_EXT_direct_state_access::glCompressedMultiTexImage2DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *bits)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->CompressedMultiTexImage2DEXT(texunit, target, level, internalformat, width, height, border, imageSize, bits);
}

inline void QOpenGLExtension_EXT_direct_state_access::glCompressedMultiTexImage3DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *bits)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->CompressedMultiTexImage3DEXT(texunit, target, level, internalformat, width, height, depth, border, imageSize, bits);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetCompressedTextureImageEXT(GLuint texture, GLenum target, GLint lod, GLvoid *img)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetCompressedTextureImageEXT(texture, target, lod, img);
}

inline void QOpenGLExtension_EXT_direct_state_access::glCompressedTextureSubImage1DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *bits)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->CompressedTextureSubImage1DEXT(texture, target, level, xoffset, width, format, imageSize, bits);
}

inline void QOpenGLExtension_EXT_direct_state_access::glCompressedTextureSubImage2DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *bits)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->CompressedTextureSubImage2DEXT(texture, target, level, xoffset, yoffset, width, height, format, imageSize, bits);
}

inline void QOpenGLExtension_EXT_direct_state_access::glCompressedTextureSubImage3DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *bits)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->CompressedTextureSubImage3DEXT(texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, bits);
}

inline void QOpenGLExtension_EXT_direct_state_access::glCompressedTextureImage1DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *bits)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->CompressedTextureImage1DEXT(texture, target, level, internalformat, width, border, imageSize, bits);
}

inline void QOpenGLExtension_EXT_direct_state_access::glCompressedTextureImage2DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *bits)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->CompressedTextureImage2DEXT(texture, target, level, internalformat, width, height, border, imageSize, bits);
}

inline void QOpenGLExtension_EXT_direct_state_access::glCompressedTextureImage3DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *bits)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->CompressedTextureImage3DEXT(texture, target, level, internalformat, width, height, depth, border, imageSize, bits);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetPointerIndexedvEXT(GLenum target, GLuint index, GLvoid* *data)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetPointerIndexedvEXT(target, index, data);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetDoubleIndexedvEXT(GLenum target, GLuint index, GLdouble *data)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetDoubleIndexedvEXT(target, index, data);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetFloatIndexedvEXT(GLenum target, GLuint index, GLfloat *data)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetFloatIndexedvEXT(target, index, data);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetMultiTexGenivEXT(GLenum texunit, GLenum coord, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetMultiTexGenivEXT(texunit, coord, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetMultiTexGenfvEXT(GLenum texunit, GLenum coord, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetMultiTexGenfvEXT(texunit, coord, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetMultiTexGendvEXT(GLenum texunit, GLenum coord, GLenum pname, GLdouble *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetMultiTexGendvEXT(texunit, coord, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetMultiTexEnvivEXT(GLenum texunit, GLenum target, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetMultiTexEnvivEXT(texunit, target, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetMultiTexEnvfvEXT(GLenum texunit, GLenum target, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetMultiTexEnvfvEXT(texunit, target, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMultiTexGenivEXT(GLenum texunit, GLenum coord, GLenum pname, const GLint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MultiTexGenivEXT(texunit, coord, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMultiTexGeniEXT(GLenum texunit, GLenum coord, GLenum pname, GLint param)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MultiTexGeniEXT(texunit, coord, pname, param);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMultiTexGenfvEXT(GLenum texunit, GLenum coord, GLenum pname, const GLfloat *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MultiTexGenfvEXT(texunit, coord, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMultiTexGenfEXT(GLenum texunit, GLenum coord, GLenum pname, GLfloat param)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MultiTexGenfEXT(texunit, coord, pname, param);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMultiTexGendvEXT(GLenum texunit, GLenum coord, GLenum pname, const GLdouble *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MultiTexGendvEXT(texunit, coord, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMultiTexGendEXT(GLenum texunit, GLenum coord, GLenum pname, GLdouble param)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MultiTexGendEXT(texunit, coord, pname, param);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMultiTexEnvivEXT(GLenum texunit, GLenum target, GLenum pname, const GLint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MultiTexEnvivEXT(texunit, target, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMultiTexEnviEXT(GLenum texunit, GLenum target, GLenum pname, GLint param)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MultiTexEnviEXT(texunit, target, pname, param);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMultiTexEnvfvEXT(GLenum texunit, GLenum target, GLenum pname, const GLfloat *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MultiTexEnvfvEXT(texunit, target, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMultiTexEnvfEXT(GLenum texunit, GLenum target, GLenum pname, GLfloat param)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MultiTexEnvfEXT(texunit, target, pname, param);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMultiTexCoordPointerEXT(GLenum texunit, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MultiTexCoordPointerEXT(texunit, size, type, stride, pointer);
}

inline void QOpenGLExtension_EXT_direct_state_access::glDisableClientStateIndexedEXT(GLenum array, GLuint index)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->DisableClientStateIndexedEXT(array, index);
}

inline void QOpenGLExtension_EXT_direct_state_access::glEnableClientStateIndexedEXT(GLenum array, GLuint index)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->EnableClientStateIndexedEXT(array, index);
}

inline void QOpenGLExtension_EXT_direct_state_access::glBindMultiTextureEXT(GLenum texunit, GLenum target, GLuint texture)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->BindMultiTextureEXT(texunit, target, texture);
}

inline void QOpenGLExtension_EXT_direct_state_access::glCopyMultiTexSubImage3DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->CopyMultiTexSubImage3DEXT(texunit, target, level, xoffset, yoffset, zoffset, x, y, width, height);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMultiTexSubImage3DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MultiTexSubImage3DEXT(texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMultiTexImage3DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MultiTexImage3DEXT(texunit, target, level, internalformat, width, height, depth, border, format, type, pixels);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetMultiTexLevelParameterivEXT(GLenum texunit, GLenum target, GLint level, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetMultiTexLevelParameterivEXT(texunit, target, level, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetMultiTexLevelParameterfvEXT(GLenum texunit, GLenum target, GLint level, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetMultiTexLevelParameterfvEXT(texunit, target, level, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetMultiTexParameterivEXT(GLenum texunit, GLenum target, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetMultiTexParameterivEXT(texunit, target, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetMultiTexParameterfvEXT(GLenum texunit, GLenum target, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetMultiTexParameterfvEXT(texunit, target, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetMultiTexImageEXT(GLenum texunit, GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetMultiTexImageEXT(texunit, target, level, format, type, pixels);
}

inline void QOpenGLExtension_EXT_direct_state_access::glCopyMultiTexSubImage2DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->CopyMultiTexSubImage2DEXT(texunit, target, level, xoffset, yoffset, x, y, width, height);
}

inline void QOpenGLExtension_EXT_direct_state_access::glCopyMultiTexSubImage1DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->CopyMultiTexSubImage1DEXT(texunit, target, level, xoffset, x, y, width);
}

inline void QOpenGLExtension_EXT_direct_state_access::glCopyMultiTexImage2DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->CopyMultiTexImage2DEXT(texunit, target, level, internalformat, x, y, width, height, border);
}

inline void QOpenGLExtension_EXT_direct_state_access::glCopyMultiTexImage1DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->CopyMultiTexImage1DEXT(texunit, target, level, internalformat, x, y, width, border);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMultiTexSubImage2DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MultiTexSubImage2DEXT(texunit, target, level, xoffset, yoffset, width, height, format, type, pixels);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMultiTexSubImage1DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MultiTexSubImage1DEXT(texunit, target, level, xoffset, width, format, type, pixels);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMultiTexImage2DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MultiTexImage2DEXT(texunit, target, level, internalformat, width, height, border, format, type, pixels);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMultiTexImage1DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MultiTexImage1DEXT(texunit, target, level, internalformat, width, border, format, type, pixels);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMultiTexParameterivEXT(GLenum texunit, GLenum target, GLenum pname, const GLint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MultiTexParameterivEXT(texunit, target, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMultiTexParameteriEXT(GLenum texunit, GLenum target, GLenum pname, GLint param)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MultiTexParameteriEXT(texunit, target, pname, param);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMultiTexParameterfvEXT(GLenum texunit, GLenum target, GLenum pname, const GLfloat *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MultiTexParameterfvEXT(texunit, target, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMultiTexParameterfEXT(GLenum texunit, GLenum target, GLenum pname, GLfloat param)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MultiTexParameterfEXT(texunit, target, pname, param);
}

inline void QOpenGLExtension_EXT_direct_state_access::glCopyTextureSubImage3DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->CopyTextureSubImage3DEXT(texture, target, level, xoffset, yoffset, zoffset, x, y, width, height);
}

inline void QOpenGLExtension_EXT_direct_state_access::glTextureSubImage3DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->TextureSubImage3DEXT(texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
}

inline void QOpenGLExtension_EXT_direct_state_access::glTextureImage3DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->TextureImage3DEXT(texture, target, level, internalformat, width, height, depth, border, format, type, pixels);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetTextureLevelParameterivEXT(GLuint texture, GLenum target, GLint level, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetTextureLevelParameterivEXT(texture, target, level, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetTextureLevelParameterfvEXT(GLuint texture, GLenum target, GLint level, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetTextureLevelParameterfvEXT(texture, target, level, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetTextureParameterivEXT(GLuint texture, GLenum target, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetTextureParameterivEXT(texture, target, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetTextureParameterfvEXT(GLuint texture, GLenum target, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetTextureParameterfvEXT(texture, target, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetTextureImageEXT(GLuint texture, GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetTextureImageEXT(texture, target, level, format, type, pixels);
}

inline void QOpenGLExtension_EXT_direct_state_access::glCopyTextureSubImage2DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->CopyTextureSubImage2DEXT(texture, target, level, xoffset, yoffset, x, y, width, height);
}

inline void QOpenGLExtension_EXT_direct_state_access::glCopyTextureSubImage1DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->CopyTextureSubImage1DEXT(texture, target, level, xoffset, x, y, width);
}

inline void QOpenGLExtension_EXT_direct_state_access::glCopyTextureImage2DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->CopyTextureImage2DEXT(texture, target, level, internalformat, x, y, width, height, border);
}

inline void QOpenGLExtension_EXT_direct_state_access::glCopyTextureImage1DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->CopyTextureImage1DEXT(texture, target, level, internalformat, x, y, width, border);
}

inline void QOpenGLExtension_EXT_direct_state_access::glTextureSubImage2DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->TextureSubImage2DEXT(texture, target, level, xoffset, yoffset, width, height, format, type, pixels);
}

inline void QOpenGLExtension_EXT_direct_state_access::glTextureSubImage1DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->TextureSubImage1DEXT(texture, target, level, xoffset, width, format, type, pixels);
}

inline void QOpenGLExtension_EXT_direct_state_access::glTextureImage2DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->TextureImage2DEXT(texture, target, level, internalformat, width, height, border, format, type, pixels);
}

inline void QOpenGLExtension_EXT_direct_state_access::glTextureImage1DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->TextureImage1DEXT(texture, target, level, internalformat, width, border, format, type, pixels);
}

inline void QOpenGLExtension_EXT_direct_state_access::glTextureParameterivEXT(GLuint texture, GLenum target, GLenum pname, const GLint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->TextureParameterivEXT(texture, target, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glTextureParameteriEXT(GLuint texture, GLenum target, GLenum pname, GLint param)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->TextureParameteriEXT(texture, target, pname, param);
}

inline void QOpenGLExtension_EXT_direct_state_access::glTextureParameterfvEXT(GLuint texture, GLenum target, GLenum pname, const GLfloat *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->TextureParameterfvEXT(texture, target, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glTextureParameterfEXT(GLuint texture, GLenum target, GLenum pname, GLfloat param)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->TextureParameterfEXT(texture, target, pname, param);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMatrixMultTransposedEXT(GLenum mode, const GLdouble *m)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MatrixMultTransposedEXT(mode, m);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMatrixMultTransposefEXT(GLenum mode, const GLfloat *m)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MatrixMultTransposefEXT(mode, m);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMatrixLoadTransposedEXT(GLenum mode, const GLdouble *m)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MatrixLoadTransposedEXT(mode, m);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMatrixLoadTransposefEXT(GLenum mode, const GLfloat *m)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MatrixLoadTransposefEXT(mode, m);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMatrixPushEXT(GLenum mode)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MatrixPushEXT(mode);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMatrixPopEXT(GLenum mode)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MatrixPopEXT(mode);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMatrixOrthoEXT(GLenum mode, GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MatrixOrthoEXT(mode, left, right, bottom, top, zNear, zFar);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMatrixFrustumEXT(GLenum mode, GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MatrixFrustumEXT(mode, left, right, bottom, top, zNear, zFar);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMatrixTranslatedEXT(GLenum mode, GLdouble x, GLdouble y, GLdouble z)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MatrixTranslatedEXT(mode, x, y, z);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMatrixTranslatefEXT(GLenum mode, GLfloat x, GLfloat y, GLfloat z)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MatrixTranslatefEXT(mode, x, y, z);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMatrixScaledEXT(GLenum mode, GLdouble x, GLdouble y, GLdouble z)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MatrixScaledEXT(mode, x, y, z);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMatrixScalefEXT(GLenum mode, GLfloat x, GLfloat y, GLfloat z)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MatrixScalefEXT(mode, x, y, z);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMatrixRotatedEXT(GLenum mode, GLdouble angle, GLdouble x, GLdouble y, GLdouble z)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MatrixRotatedEXT(mode, angle, x, y, z);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMatrixRotatefEXT(GLenum mode, GLfloat angle, GLfloat x, GLfloat y, GLfloat z)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MatrixRotatefEXT(mode, angle, x, y, z);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMatrixLoadIdentityEXT(GLenum mode)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MatrixLoadIdentityEXT(mode);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMatrixMultdEXT(GLenum mode, const GLdouble *m)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MatrixMultdEXT(mode, m);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMatrixMultfEXT(GLenum mode, const GLfloat *m)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MatrixMultfEXT(mode, m);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMatrixLoaddEXT(GLenum mode, const GLdouble *m)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MatrixLoaddEXT(mode, m);
}

inline void QOpenGLExtension_EXT_direct_state_access::glMatrixLoadfEXT(GLenum mode, const GLfloat *m)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->MatrixLoadfEXT(mode, m);
}

inline void QOpenGLExtension_EXT_direct_state_access::glPushClientAttribDefaultEXT(GLbitfield mask)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->PushClientAttribDefaultEXT(mask);
}

inline void QOpenGLExtension_EXT_direct_state_access::glClientAttribDefaultEXT(GLbitfield mask)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ClientAttribDefaultEXT(mask);
}

inline void QOpenGLExtension_EXT_direct_state_access::glTextureStorage3DMultisampleEXT(GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->TextureStorage3DMultisampleEXT(texture, target, samples, internalformat, width, height, depth, fixedsamplelocations);
}

inline void QOpenGLExtension_EXT_direct_state_access::glTextureStorage2DMultisampleEXT(GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->TextureStorage2DMultisampleEXT(texture, target, samples, internalformat, width, height, fixedsamplelocations);
}

inline void QOpenGLExtension_EXT_direct_state_access::glTextureBufferRangeEXT(GLuint texture, GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->TextureBufferRangeEXT(texture, target, internalformat, buffer, offset, size);
}

inline void QOpenGLExtension_EXT_direct_state_access::glGetNamedFramebufferParameterivEXT(GLuint framebuffer, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->GetNamedFramebufferParameterivEXT(framebuffer, pname, params);
}

inline void QOpenGLExtension_EXT_direct_state_access::glNamedFramebufferParameteriEXT(GLuint framebuffer, GLenum pname, GLint param)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->NamedFramebufferParameteriEXT(framebuffer, pname, param);
}

inline void QOpenGLExtension_EXT_direct_state_access::glVertexArrayVertexBindingDivisorEXT(GLuint vaobj, GLuint bindingindex, GLuint divisor)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->VertexArrayVertexBindingDivisorEXT(vaobj, bindingindex, divisor);
}

inline void QOpenGLExtension_EXT_direct_state_access::glVertexArrayVertexAttribBindingEXT(GLuint vaobj, GLuint attribindex, GLuint bindingindex)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->VertexArrayVertexAttribBindingEXT(vaobj, attribindex, bindingindex);
}

inline void QOpenGLExtension_EXT_direct_state_access::glVertexArrayVertexAttribLFormatEXT(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->VertexArrayVertexAttribLFormatEXT(vaobj, attribindex, size, type, relativeoffset);
}

inline void QOpenGLExtension_EXT_direct_state_access::glVertexArrayVertexAttribIFormatEXT(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->VertexArrayVertexAttribIFormatEXT(vaobj, attribindex, size, type, relativeoffset);
}

inline void QOpenGLExtension_EXT_direct_state_access::glVertexArrayVertexAttribFormatEXT(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->VertexArrayVertexAttribFormatEXT(vaobj, attribindex, size, type, normalized, relativeoffset);
}

inline void QOpenGLExtension_EXT_direct_state_access::glVertexArrayBindVertexBufferEXT(GLuint vaobj, GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->VertexArrayBindVertexBufferEXT(vaobj, bindingindex, buffer, offset, stride);
}

inline void QOpenGLExtension_EXT_direct_state_access::glClearNamedBufferSubDataEXT(GLuint buffer, GLenum internalformat, GLsizeiptr offset, GLsizeiptr size, GLenum format, GLenum type, const void *data)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ClearNamedBufferSubDataEXT(buffer, internalformat, offset, size, format, type, data);
}

inline void QOpenGLExtension_EXT_direct_state_access::glClearNamedBufferDataEXT(GLuint buffer, GLenum internalformat, GLenum format, GLenum type, const void *data)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->ClearNamedBufferDataEXT(buffer, internalformat, format, type, data);
}

inline void QOpenGLExtension_EXT_direct_state_access::glTextureStorage3DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->TextureStorage3DEXT(texture, target, levels, internalformat, width, height, depth);
}

inline void QOpenGLExtension_EXT_direct_state_access::glTextureStorage2DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->TextureStorage2DEXT(texture, target, levels, internalformat, width, height);
}

inline void QOpenGLExtension_EXT_direct_state_access::glTextureStorage1DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width)
{
    Q_D(QOpenGLExtension_EXT_direct_state_access);
    d->TextureStorage1DEXT(texture, target, levels, internalformat, width);
}

class QOpenGLExtension_EXT_draw_buffers2Private : public QAbstractOpenGLExtensionPrivate
{
public:
    GLboolean (QOPENGLF_APIENTRYP IsEnabledIndexedEXT)(GLenum target, GLuint index);
    void (QOPENGLF_APIENTRYP DisableIndexedEXT)(GLenum target, GLuint index);
    void (QOPENGLF_APIENTRYP EnableIndexedEXT)(GLenum target, GLuint index);
    void (QOPENGLF_APIENTRYP GetIntegerIndexedvEXT)(GLenum target, GLuint index, GLint *data);
    void (QOPENGLF_APIENTRYP GetBooleanIndexedvEXT)(GLenum target, GLuint index, GLboolean *data);
    void (QOPENGLF_APIENTRYP ColorMaskIndexedEXT)(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a);
};

class QOpenGLExtension_EXT_draw_buffers2 : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_draw_buffers2();

    bool initializeOpenGLFunctions() final;

    GLboolean glIsEnabledIndexedEXT(GLenum target, GLuint index);
    void glDisableIndexedEXT(GLenum target, GLuint index);
    void glEnableIndexedEXT(GLenum target, GLuint index);
    void glGetIntegerIndexedvEXT(GLenum target, GLuint index, GLint *data);
    void glGetBooleanIndexedvEXT(GLenum target, GLuint index, GLboolean *data);
    void glColorMaskIndexedEXT(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_draw_buffers2)
};

inline GLboolean QOpenGLExtension_EXT_draw_buffers2::glIsEnabledIndexedEXT(GLenum target, GLuint index)
{
    Q_D(QOpenGLExtension_EXT_draw_buffers2);
    return d->IsEnabledIndexedEXT(target, index);
}

inline void QOpenGLExtension_EXT_draw_buffers2::glDisableIndexedEXT(GLenum target, GLuint index)
{
    Q_D(QOpenGLExtension_EXT_draw_buffers2);
    d->DisableIndexedEXT(target, index);
}

inline void QOpenGLExtension_EXT_draw_buffers2::glEnableIndexedEXT(GLenum target, GLuint index)
{
    Q_D(QOpenGLExtension_EXT_draw_buffers2);
    d->EnableIndexedEXT(target, index);
}

inline void QOpenGLExtension_EXT_draw_buffers2::glGetIntegerIndexedvEXT(GLenum target, GLuint index, GLint *data)
{
    Q_D(QOpenGLExtension_EXT_draw_buffers2);
    d->GetIntegerIndexedvEXT(target, index, data);
}

inline void QOpenGLExtension_EXT_draw_buffers2::glGetBooleanIndexedvEXT(GLenum target, GLuint index, GLboolean *data)
{
    Q_D(QOpenGLExtension_EXT_draw_buffers2);
    d->GetBooleanIndexedvEXT(target, index, data);
}

inline void QOpenGLExtension_EXT_draw_buffers2::glColorMaskIndexedEXT(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a)
{
    Q_D(QOpenGLExtension_EXT_draw_buffers2);
    d->ColorMaskIndexedEXT(index, r, g, b, a);
}

class QOpenGLExtension_EXT_draw_instancedPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP DrawElementsInstancedEXT)(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei primcount);
    void (QOPENGLF_APIENTRYP DrawArraysInstancedEXT)(GLenum mode, GLint start, GLsizei count, GLsizei primcount);
};

class QOpenGLExtension_EXT_draw_instanced : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_draw_instanced();

    bool initializeOpenGLFunctions() final;

    void glDrawElementsInstancedEXT(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei primcount);
    void glDrawArraysInstancedEXT(GLenum mode, GLint start, GLsizei count, GLsizei primcount);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_draw_instanced)
};

inline void QOpenGLExtension_EXT_draw_instanced::glDrawElementsInstancedEXT(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei primcount)
{
    Q_D(QOpenGLExtension_EXT_draw_instanced);
    d->DrawElementsInstancedEXT(mode, count, type, indices, primcount);
}

inline void QOpenGLExtension_EXT_draw_instanced::glDrawArraysInstancedEXT(GLenum mode, GLint start, GLsizei count, GLsizei primcount)
{
    Q_D(QOpenGLExtension_EXT_draw_instanced);
    d->DrawArraysInstancedEXT(mode, start, count, primcount);
}

class QOpenGLExtension_EXT_draw_range_elementsPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP DrawRangeElementsEXT)(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices);
};

class QOpenGLExtension_EXT_draw_range_elements : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_draw_range_elements();

    bool initializeOpenGLFunctions() final;

    void glDrawRangeElementsEXT(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_draw_range_elements)
};

inline void QOpenGLExtension_EXT_draw_range_elements::glDrawRangeElementsEXT(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices)
{
    Q_D(QOpenGLExtension_EXT_draw_range_elements);
    d->DrawRangeElementsEXT(mode, start, end, count, type, indices);
}

class QOpenGLExtension_EXT_fog_coordPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP FogCoordPointerEXT)(GLenum type, GLsizei stride, const GLvoid *pointer);
    void (QOPENGLF_APIENTRYP FogCoorddvEXT)(const GLdouble *coord);
    void (QOPENGLF_APIENTRYP FogCoorddEXT)(GLdouble coord);
    void (QOPENGLF_APIENTRYP FogCoordfvEXT)(const GLfloat *coord);
    void (QOPENGLF_APIENTRYP FogCoordfEXT)(GLfloat coord);
};

class QOpenGLExtension_EXT_fog_coord : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_fog_coord();

    bool initializeOpenGLFunctions() final;

    void glFogCoordPointerEXT(GLenum type, GLsizei stride, const GLvoid *pointer);
    void glFogCoorddvEXT(const GLdouble *coord);
    void glFogCoorddEXT(GLdouble coord);
    void glFogCoordfvEXT(const GLfloat *coord);
    void glFogCoordfEXT(GLfloat coord);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_fog_coord)
};

inline void QOpenGLExtension_EXT_fog_coord::glFogCoordPointerEXT(GLenum type, GLsizei stride, const GLvoid *pointer)
{
    Q_D(QOpenGLExtension_EXT_fog_coord);
    d->FogCoordPointerEXT(type, stride, pointer);
}

inline void QOpenGLExtension_EXT_fog_coord::glFogCoorddvEXT(const GLdouble *coord)
{
    Q_D(QOpenGLExtension_EXT_fog_coord);
    d->FogCoorddvEXT(coord);
}

inline void QOpenGLExtension_EXT_fog_coord::glFogCoorddEXT(GLdouble coord)
{
    Q_D(QOpenGLExtension_EXT_fog_coord);
    d->FogCoorddEXT(coord);
}

inline void QOpenGLExtension_EXT_fog_coord::glFogCoordfvEXT(const GLfloat *coord)
{
    Q_D(QOpenGLExtension_EXT_fog_coord);
    d->FogCoordfvEXT(coord);
}

inline void QOpenGLExtension_EXT_fog_coord::glFogCoordfEXT(GLfloat coord)
{
    Q_D(QOpenGLExtension_EXT_fog_coord);
    d->FogCoordfEXT(coord);
}

class QOpenGLExtension_EXT_framebuffer_blitPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP BlitFramebufferEXT)(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter);
};

class QOpenGLExtension_EXT_framebuffer_blit : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_framebuffer_blit();

    bool initializeOpenGLFunctions() final;

    void glBlitFramebufferEXT(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_framebuffer_blit)
};

inline void QOpenGLExtension_EXT_framebuffer_blit::glBlitFramebufferEXT(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter)
{
    Q_D(QOpenGLExtension_EXT_framebuffer_blit);
    d->BlitFramebufferEXT(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
}

class QOpenGLExtension_EXT_framebuffer_multisamplePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP RenderbufferStorageMultisampleEXT)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
};

class QOpenGLExtension_EXT_framebuffer_multisample : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_framebuffer_multisample();

    bool initializeOpenGLFunctions() final;

    void glRenderbufferStorageMultisampleEXT(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_framebuffer_multisample)
};

inline void QOpenGLExtension_EXT_framebuffer_multisample::glRenderbufferStorageMultisampleEXT(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height)
{
    Q_D(QOpenGLExtension_EXT_framebuffer_multisample);
    d->RenderbufferStorageMultisampleEXT(target, samples, internalformat, width, height);
}

class QOpenGLExtension_EXT_framebuffer_objectPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GenerateMipmapEXT)(GLenum target);
    void (QOPENGLF_APIENTRYP GetFramebufferAttachmentParameterivEXT)(GLenum target, GLenum attachment, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP FramebufferRenderbufferEXT)(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
    void (QOPENGLF_APIENTRYP FramebufferTexture3DEXT)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset);
    void (QOPENGLF_APIENTRYP FramebufferTexture2DEXT)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
    void (QOPENGLF_APIENTRYP FramebufferTexture1DEXT)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
    GLenum (QOPENGLF_APIENTRYP CheckFramebufferStatusEXT)(GLenum target);
    void (QOPENGLF_APIENTRYP GenFramebuffersEXT)(GLsizei n, GLuint *framebuffers);
    void (QOPENGLF_APIENTRYP DeleteFramebuffersEXT)(GLsizei n, const GLuint *framebuffers);
    void (QOPENGLF_APIENTRYP BindFramebufferEXT)(GLenum target, GLuint framebuffer);
    GLboolean (QOPENGLF_APIENTRYP IsFramebufferEXT)(GLuint framebuffer);
    void (QOPENGLF_APIENTRYP GetRenderbufferParameterivEXT)(GLenum target, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP RenderbufferStorageEXT)(GLenum target, GLenum internalformat, GLsizei width, GLsizei height);
    void (QOPENGLF_APIENTRYP GenRenderbuffersEXT)(GLsizei n, GLuint *renderbuffers);
    void (QOPENGLF_APIENTRYP DeleteRenderbuffersEXT)(GLsizei n, const GLuint *renderbuffers);
    void (QOPENGLF_APIENTRYP BindRenderbufferEXT)(GLenum target, GLuint renderbuffer);
    GLboolean (QOPENGLF_APIENTRYP IsRenderbufferEXT)(GLuint renderbuffer);
};

class QOpenGLExtension_EXT_framebuffer_object : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_framebuffer_object();

    bool initializeOpenGLFunctions() final;

    void glGenerateMipmapEXT(GLenum target);
    void glGetFramebufferAttachmentParameterivEXT(GLenum target, GLenum attachment, GLenum pname, GLint *params);
    void glFramebufferRenderbufferEXT(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
    void glFramebufferTexture3DEXT(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset);
    void glFramebufferTexture2DEXT(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
    void glFramebufferTexture1DEXT(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
    GLenum glCheckFramebufferStatusEXT(GLenum target);
    void glGenFramebuffersEXT(GLsizei n, GLuint *framebuffers);
    void glDeleteFramebuffersEXT(GLsizei n, const GLuint *framebuffers);
    void glBindFramebufferEXT(GLenum target, GLuint framebuffer);
    GLboolean glIsFramebufferEXT(GLuint framebuffer);
    void glGetRenderbufferParameterivEXT(GLenum target, GLenum pname, GLint *params);
    void glRenderbufferStorageEXT(GLenum target, GLenum internalformat, GLsizei width, GLsizei height);
    void glGenRenderbuffersEXT(GLsizei n, GLuint *renderbuffers);
    void glDeleteRenderbuffersEXT(GLsizei n, const GLuint *renderbuffers);
    void glBindRenderbufferEXT(GLenum target, GLuint renderbuffer);
    GLboolean glIsRenderbufferEXT(GLuint renderbuffer);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_framebuffer_object)
};

inline void QOpenGLExtension_EXT_framebuffer_object::glGenerateMipmapEXT(GLenum target)
{
    Q_D(QOpenGLExtension_EXT_framebuffer_object);
    d->GenerateMipmapEXT(target);
}

inline void QOpenGLExtension_EXT_framebuffer_object::glGetFramebufferAttachmentParameterivEXT(GLenum target, GLenum attachment, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_EXT_framebuffer_object);
    d->GetFramebufferAttachmentParameterivEXT(target, attachment, pname, params);
}

inline void QOpenGLExtension_EXT_framebuffer_object::glFramebufferRenderbufferEXT(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer)
{
    Q_D(QOpenGLExtension_EXT_framebuffer_object);
    d->FramebufferRenderbufferEXT(target, attachment, renderbuffertarget, renderbuffer);
}

inline void QOpenGLExtension_EXT_framebuffer_object::glFramebufferTexture3DEXT(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset)
{
    Q_D(QOpenGLExtension_EXT_framebuffer_object);
    d->FramebufferTexture3DEXT(target, attachment, textarget, texture, level, zoffset);
}

inline void QOpenGLExtension_EXT_framebuffer_object::glFramebufferTexture2DEXT(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)
{
    Q_D(QOpenGLExtension_EXT_framebuffer_object);
    d->FramebufferTexture2DEXT(target, attachment, textarget, texture, level);
}

inline void QOpenGLExtension_EXT_framebuffer_object::glFramebufferTexture1DEXT(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)
{
    Q_D(QOpenGLExtension_EXT_framebuffer_object);
    d->FramebufferTexture1DEXT(target, attachment, textarget, texture, level);
}

inline GLenum QOpenGLExtension_EXT_framebuffer_object::glCheckFramebufferStatusEXT(GLenum target)
{
    Q_D(QOpenGLExtension_EXT_framebuffer_object);
    return d->CheckFramebufferStatusEXT(target);
}

inline void QOpenGLExtension_EXT_framebuffer_object::glGenFramebuffersEXT(GLsizei n, GLuint *framebuffers)
{
    Q_D(QOpenGLExtension_EXT_framebuffer_object);
    d->GenFramebuffersEXT(n, framebuffers);
}

inline void QOpenGLExtension_EXT_framebuffer_object::glDeleteFramebuffersEXT(GLsizei n, const GLuint *framebuffers)
{
    Q_D(QOpenGLExtension_EXT_framebuffer_object);
    d->DeleteFramebuffersEXT(n, framebuffers);
}

inline void QOpenGLExtension_EXT_framebuffer_object::glBindFramebufferEXT(GLenum target, GLuint framebuffer)
{
    Q_D(QOpenGLExtension_EXT_framebuffer_object);
    d->BindFramebufferEXT(target, framebuffer);
}

inline GLboolean QOpenGLExtension_EXT_framebuffer_object::glIsFramebufferEXT(GLuint framebuffer)
{
    Q_D(QOpenGLExtension_EXT_framebuffer_object);
    return d->IsFramebufferEXT(framebuffer);
}

inline void QOpenGLExtension_EXT_framebuffer_object::glGetRenderbufferParameterivEXT(GLenum target, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_EXT_framebuffer_object);
    d->GetRenderbufferParameterivEXT(target, pname, params);
}

inline void QOpenGLExtension_EXT_framebuffer_object::glRenderbufferStorageEXT(GLenum target, GLenum internalformat, GLsizei width, GLsizei height)
{
    Q_D(QOpenGLExtension_EXT_framebuffer_object);
    d->RenderbufferStorageEXT(target, internalformat, width, height);
}

inline void QOpenGLExtension_EXT_framebuffer_object::glGenRenderbuffersEXT(GLsizei n, GLuint *renderbuffers)
{
    Q_D(QOpenGLExtension_EXT_framebuffer_object);
    d->GenRenderbuffersEXT(n, renderbuffers);
}

inline void QOpenGLExtension_EXT_framebuffer_object::glDeleteRenderbuffersEXT(GLsizei n, const GLuint *renderbuffers)
{
    Q_D(QOpenGLExtension_EXT_framebuffer_object);
    d->DeleteRenderbuffersEXT(n, renderbuffers);
}

inline void QOpenGLExtension_EXT_framebuffer_object::glBindRenderbufferEXT(GLenum target, GLuint renderbuffer)
{
    Q_D(QOpenGLExtension_EXT_framebuffer_object);
    d->BindRenderbufferEXT(target, renderbuffer);
}

inline GLboolean QOpenGLExtension_EXT_framebuffer_object::glIsRenderbufferEXT(GLuint renderbuffer)
{
    Q_D(QOpenGLExtension_EXT_framebuffer_object);
    return d->IsRenderbufferEXT(renderbuffer);
}

class QOpenGLExtension_EXT_geometry_shader4Private : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP ProgramParameteriEXT)(GLuint program, GLenum pname, GLint value);
};

class QOpenGLExtension_EXT_geometry_shader4 : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_geometry_shader4();

    bool initializeOpenGLFunctions() final;

    void glProgramParameteriEXT(GLuint program, GLenum pname, GLint value);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_geometry_shader4)
};

inline void QOpenGLExtension_EXT_geometry_shader4::glProgramParameteriEXT(GLuint program, GLenum pname, GLint value)
{
    Q_D(QOpenGLExtension_EXT_geometry_shader4);
    d->ProgramParameteriEXT(program, pname, value);
}

class QOpenGLExtension_EXT_gpu_program_parametersPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP ProgramLocalParameters4fvEXT)(GLenum target, GLuint index, GLsizei count, const GLfloat *params);
    void (QOPENGLF_APIENTRYP ProgramEnvParameters4fvEXT)(GLenum target, GLuint index, GLsizei count, const GLfloat *params);
};

class QOpenGLExtension_EXT_gpu_program_parameters : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_gpu_program_parameters();

    bool initializeOpenGLFunctions() final;

    void glProgramLocalParameters4fvEXT(GLenum target, GLuint index, GLsizei count, const GLfloat *params);
    void glProgramEnvParameters4fvEXT(GLenum target, GLuint index, GLsizei count, const GLfloat *params);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_gpu_program_parameters)
};

inline void QOpenGLExtension_EXT_gpu_program_parameters::glProgramLocalParameters4fvEXT(GLenum target, GLuint index, GLsizei count, const GLfloat *params)
{
    Q_D(QOpenGLExtension_EXT_gpu_program_parameters);
    d->ProgramLocalParameters4fvEXT(target, index, count, params);
}

inline void QOpenGLExtension_EXT_gpu_program_parameters::glProgramEnvParameters4fvEXT(GLenum target, GLuint index, GLsizei count, const GLfloat *params)
{
    Q_D(QOpenGLExtension_EXT_gpu_program_parameters);
    d->ProgramEnvParameters4fvEXT(target, index, count, params);
}

class QOpenGLExtension_EXT_gpu_shader4Private : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP Uniform4uivEXT)(GLint location, GLsizei count, const GLuint *value);
    void (QOPENGLF_APIENTRYP Uniform3uivEXT)(GLint location, GLsizei count, const GLuint *value);
    void (QOPENGLF_APIENTRYP Uniform2uivEXT)(GLint location, GLsizei count, const GLuint *value);
    void (QOPENGLF_APIENTRYP Uniform1uivEXT)(GLint location, GLsizei count, const GLuint *value);
    void (QOPENGLF_APIENTRYP Uniform4uiEXT)(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3);
    void (QOPENGLF_APIENTRYP Uniform3uiEXT)(GLint location, GLuint v0, GLuint v1, GLuint v2);
    void (QOPENGLF_APIENTRYP Uniform2uiEXT)(GLint location, GLuint v0, GLuint v1);
    void (QOPENGLF_APIENTRYP Uniform1uiEXT)(GLint location, GLuint v0);
    GLint (QOPENGLF_APIENTRYP GetFragDataLocationEXT)(GLuint program, const GLchar *name);
    void (QOPENGLF_APIENTRYP BindFragDataLocationEXT)(GLuint program, GLuint color, const GLchar *name);
    void (QOPENGLF_APIENTRYP GetUniformuivEXT)(GLuint program, GLint location, GLuint *params);
};

class QOpenGLExtension_EXT_gpu_shader4 : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_gpu_shader4();

    bool initializeOpenGLFunctions() final;

    void glUniform4uivEXT(GLint location, GLsizei count, const GLuint *value);
    void glUniform3uivEXT(GLint location, GLsizei count, const GLuint *value);
    void glUniform2uivEXT(GLint location, GLsizei count, const GLuint *value);
    void glUniform1uivEXT(GLint location, GLsizei count, const GLuint *value);
    void glUniform4uiEXT(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3);
    void glUniform3uiEXT(GLint location, GLuint v0, GLuint v1, GLuint v2);
    void glUniform2uiEXT(GLint location, GLuint v0, GLuint v1);
    void glUniform1uiEXT(GLint location, GLuint v0);
    GLint glGetFragDataLocationEXT(GLuint program, const GLchar *name);
    void glBindFragDataLocationEXT(GLuint program, GLuint color, const GLchar *name);
    void glGetUniformuivEXT(GLuint program, GLint location, GLuint *params);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_gpu_shader4)
};

inline void QOpenGLExtension_EXT_gpu_shader4::glUniform4uivEXT(GLint location, GLsizei count, const GLuint *value)
{
    Q_D(QOpenGLExtension_EXT_gpu_shader4);
    d->Uniform4uivEXT(location, count, value);
}

inline void QOpenGLExtension_EXT_gpu_shader4::glUniform3uivEXT(GLint location, GLsizei count, const GLuint *value)
{
    Q_D(QOpenGLExtension_EXT_gpu_shader4);
    d->Uniform3uivEXT(location, count, value);
}

inline void QOpenGLExtension_EXT_gpu_shader4::glUniform2uivEXT(GLint location, GLsizei count, const GLuint *value)
{
    Q_D(QOpenGLExtension_EXT_gpu_shader4);
    d->Uniform2uivEXT(location, count, value);
}

inline void QOpenGLExtension_EXT_gpu_shader4::glUniform1uivEXT(GLint location, GLsizei count, const GLuint *value)
{
    Q_D(QOpenGLExtension_EXT_gpu_shader4);
    d->Uniform1uivEXT(location, count, value);
}

inline void QOpenGLExtension_EXT_gpu_shader4::glUniform4uiEXT(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)
{
    Q_D(QOpenGLExtension_EXT_gpu_shader4);
    d->Uniform4uiEXT(location, v0, v1, v2, v3);
}

inline void QOpenGLExtension_EXT_gpu_shader4::glUniform3uiEXT(GLint location, GLuint v0, GLuint v1, GLuint v2)
{
    Q_D(QOpenGLExtension_EXT_gpu_shader4);
    d->Uniform3uiEXT(location, v0, v1, v2);
}

inline void QOpenGLExtension_EXT_gpu_shader4::glUniform2uiEXT(GLint location, GLuint v0, GLuint v1)
{
    Q_D(QOpenGLExtension_EXT_gpu_shader4);
    d->Uniform2uiEXT(location, v0, v1);
}

inline void QOpenGLExtension_EXT_gpu_shader4::glUniform1uiEXT(GLint location, GLuint v0)
{
    Q_D(QOpenGLExtension_EXT_gpu_shader4);
    d->Uniform1uiEXT(location, v0);
}

inline GLint QOpenGLExtension_EXT_gpu_shader4::glGetFragDataLocationEXT(GLuint program, const GLchar *name)
{
    Q_D(QOpenGLExtension_EXT_gpu_shader4);
    return d->GetFragDataLocationEXT(program, name);
}

inline void QOpenGLExtension_EXT_gpu_shader4::glBindFragDataLocationEXT(GLuint program, GLuint color, const GLchar *name)
{
    Q_D(QOpenGLExtension_EXT_gpu_shader4);
    d->BindFragDataLocationEXT(program, color, name);
}

inline void QOpenGLExtension_EXT_gpu_shader4::glGetUniformuivEXT(GLuint program, GLint location, GLuint *params)
{
    Q_D(QOpenGLExtension_EXT_gpu_shader4);
    d->GetUniformuivEXT(program, location, params);
}

class QOpenGLExtension_EXT_histogramPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP ResetMinmaxEXT)(GLenum target);
    void (QOPENGLF_APIENTRYP ResetHistogramEXT)(GLenum target);
    void (QOPENGLF_APIENTRYP MinmaxEXT)(GLenum target, GLenum internalformat, GLboolean sink);
    void (QOPENGLF_APIENTRYP HistogramEXT)(GLenum target, GLsizei width, GLenum internalformat, GLboolean sink);
    void (QOPENGLF_APIENTRYP GetMinmaxParameterivEXT)(GLenum target, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetMinmaxParameterfvEXT)(GLenum target, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP GetMinmaxEXT)(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values);
    void (QOPENGLF_APIENTRYP GetHistogramParameterivEXT)(GLenum target, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetHistogramParameterfvEXT)(GLenum target, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP GetHistogramEXT)(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values);
};

class QOpenGLExtension_EXT_histogram : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_histogram();

    bool initializeOpenGLFunctions() final;

    void glResetMinmaxEXT(GLenum target);
    void glResetHistogramEXT(GLenum target);
    void glMinmaxEXT(GLenum target, GLenum internalformat, GLboolean sink);
    void glHistogramEXT(GLenum target, GLsizei width, GLenum internalformat, GLboolean sink);
    void glGetMinmaxParameterivEXT(GLenum target, GLenum pname, GLint *params);
    void glGetMinmaxParameterfvEXT(GLenum target, GLenum pname, GLfloat *params);
    void glGetMinmaxEXT(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values);
    void glGetHistogramParameterivEXT(GLenum target, GLenum pname, GLint *params);
    void glGetHistogramParameterfvEXT(GLenum target, GLenum pname, GLfloat *params);
    void glGetHistogramEXT(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_histogram)
};

inline void QOpenGLExtension_EXT_histogram::glResetMinmaxEXT(GLenum target)
{
    Q_D(QOpenGLExtension_EXT_histogram);
    d->ResetMinmaxEXT(target);
}

inline void QOpenGLExtension_EXT_histogram::glResetHistogramEXT(GLenum target)
{
    Q_D(QOpenGLExtension_EXT_histogram);
    d->ResetHistogramEXT(target);
}

inline void QOpenGLExtension_EXT_histogram::glMinmaxEXT(GLenum target, GLenum internalformat, GLboolean sink)
{
    Q_D(QOpenGLExtension_EXT_histogram);
    d->MinmaxEXT(target, internalformat, sink);
}

inline void QOpenGLExtension_EXT_histogram::glHistogramEXT(GLenum target, GLsizei width, GLenum internalformat, GLboolean sink)
{
    Q_D(QOpenGLExtension_EXT_histogram);
    d->HistogramEXT(target, width, internalformat, sink);
}

inline void QOpenGLExtension_EXT_histogram::glGetMinmaxParameterivEXT(GLenum target, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_EXT_histogram);
    d->GetMinmaxParameterivEXT(target, pname, params);
}

inline void QOpenGLExtension_EXT_histogram::glGetMinmaxParameterfvEXT(GLenum target, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_EXT_histogram);
    d->GetMinmaxParameterfvEXT(target, pname, params);
}

inline void QOpenGLExtension_EXT_histogram::glGetMinmaxEXT(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values)
{
    Q_D(QOpenGLExtension_EXT_histogram);
    d->GetMinmaxEXT(target, reset, format, type, values);
}

inline void QOpenGLExtension_EXT_histogram::glGetHistogramParameterivEXT(GLenum target, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_EXT_histogram);
    d->GetHistogramParameterivEXT(target, pname, params);
}

inline void QOpenGLExtension_EXT_histogram::glGetHistogramParameterfvEXT(GLenum target, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_EXT_histogram);
    d->GetHistogramParameterfvEXT(target, pname, params);
}

inline void QOpenGLExtension_EXT_histogram::glGetHistogramEXT(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values)
{
    Q_D(QOpenGLExtension_EXT_histogram);
    d->GetHistogramEXT(target, reset, format, type, values);
}

class QOpenGLExtension_EXT_index_funcPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP IndexFuncEXT)(GLenum func, GLclampf ref);
};

class QOpenGLExtension_EXT_index_func : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_index_func();

    bool initializeOpenGLFunctions() final;

    void glIndexFuncEXT(GLenum func, GLclampf ref);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_index_func)
};

inline void QOpenGLExtension_EXT_index_func::glIndexFuncEXT(GLenum func, GLclampf ref)
{
    Q_D(QOpenGLExtension_EXT_index_func);
    d->IndexFuncEXT(func, ref);
}

class QOpenGLExtension_EXT_index_materialPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP IndexMaterialEXT)(GLenum face, GLenum mode);
};

class QOpenGLExtension_EXT_index_material : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_index_material();

    bool initializeOpenGLFunctions() final;

    void glIndexMaterialEXT(GLenum face, GLenum mode);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_index_material)
};

inline void QOpenGLExtension_EXT_index_material::glIndexMaterialEXT(GLenum face, GLenum mode)
{
    Q_D(QOpenGLExtension_EXT_index_material);
    d->IndexMaterialEXT(face, mode);
}

class QOpenGLExtension_EXT_light_texturePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP TextureMaterialEXT)(GLenum face, GLenum mode);
    void (QOPENGLF_APIENTRYP TextureLightEXT)(GLenum pname);
    void (QOPENGLF_APIENTRYP ApplyTextureEXT)(GLenum mode);
};

class QOpenGLExtension_EXT_light_texture : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_light_texture();

    bool initializeOpenGLFunctions() final;

    void glTextureMaterialEXT(GLenum face, GLenum mode);
    void glTextureLightEXT(GLenum pname);
    void glApplyTextureEXT(GLenum mode);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_light_texture)
};

inline void QOpenGLExtension_EXT_light_texture::glTextureMaterialEXT(GLenum face, GLenum mode)
{
    Q_D(QOpenGLExtension_EXT_light_texture);
    d->TextureMaterialEXT(face, mode);
}

inline void QOpenGLExtension_EXT_light_texture::glTextureLightEXT(GLenum pname)
{
    Q_D(QOpenGLExtension_EXT_light_texture);
    d->TextureLightEXT(pname);
}

inline void QOpenGLExtension_EXT_light_texture::glApplyTextureEXT(GLenum mode)
{
    Q_D(QOpenGLExtension_EXT_light_texture);
    d->ApplyTextureEXT(mode);
}

class QOpenGLExtension_EXT_multi_draw_arraysPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP MultiDrawElementsEXT)(GLenum mode, const GLsizei *count, GLenum type, const GLvoid* *indices, GLsizei primcount);
    void (QOPENGLF_APIENTRYP MultiDrawArraysEXT)(GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount);
};

class QOpenGLExtension_EXT_multi_draw_arrays : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_multi_draw_arrays();

    bool initializeOpenGLFunctions() final;

    void glMultiDrawElementsEXT(GLenum mode, const GLsizei *count, GLenum type, const GLvoid* *indices, GLsizei primcount);
    void glMultiDrawArraysEXT(GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_multi_draw_arrays)
};

inline void QOpenGLExtension_EXT_multi_draw_arrays::glMultiDrawElementsEXT(GLenum mode, const GLsizei *count, GLenum type, const GLvoid* *indices, GLsizei primcount)
{
    Q_D(QOpenGLExtension_EXT_multi_draw_arrays);
    d->MultiDrawElementsEXT(mode, count, type, indices, primcount);
}

inline void QOpenGLExtension_EXT_multi_draw_arrays::glMultiDrawArraysEXT(GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount)
{
    Q_D(QOpenGLExtension_EXT_multi_draw_arrays);
    d->MultiDrawArraysEXT(mode, first, count, primcount);
}

class QOpenGLExtension_EXT_multisamplePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP SamplePatternEXT)(GLenum pattern);
    void (QOPENGLF_APIENTRYP SampleMaskEXT)(GLclampf value, GLboolean invert);
};

class QOpenGLExtension_EXT_multisample : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_multisample();

    bool initializeOpenGLFunctions() final;

    void glSamplePatternEXT(GLenum pattern);
    void glSampleMaskEXT(GLclampf value, GLboolean invert);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_multisample)
};

inline void QOpenGLExtension_EXT_multisample::glSamplePatternEXT(GLenum pattern)
{
    Q_D(QOpenGLExtension_EXT_multisample);
    d->SamplePatternEXT(pattern);
}

inline void QOpenGLExtension_EXT_multisample::glSampleMaskEXT(GLclampf value, GLboolean invert)
{
    Q_D(QOpenGLExtension_EXT_multisample);
    d->SampleMaskEXT(value, invert);
}

class QOpenGLExtension_EXT_paletted_texturePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetColorTableParameterfvEXT)(GLenum target, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP GetColorTableParameterivEXT)(GLenum target, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetColorTableEXT)(GLenum target, GLenum format, GLenum type, GLvoid *data);
    void (QOPENGLF_APIENTRYP ColorTableEXT)(GLenum target, GLenum internalFormat, GLsizei width, GLenum format, GLenum type, const GLvoid *table);
};

class QOpenGLExtension_EXT_paletted_texture : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_paletted_texture();

    bool initializeOpenGLFunctions() final;

    void glGetColorTableParameterfvEXT(GLenum target, GLenum pname, GLfloat *params);
    void glGetColorTableParameterivEXT(GLenum target, GLenum pname, GLint *params);
    void glGetColorTableEXT(GLenum target, GLenum format, GLenum type, GLvoid *data);
    void glColorTableEXT(GLenum target, GLenum internalFormat, GLsizei width, GLenum format, GLenum type, const GLvoid *table);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_paletted_texture)
};

inline void QOpenGLExtension_EXT_paletted_texture::glGetColorTableParameterfvEXT(GLenum target, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_EXT_paletted_texture);
    d->GetColorTableParameterfvEXT(target, pname, params);
}

inline void QOpenGLExtension_EXT_paletted_texture::glGetColorTableParameterivEXT(GLenum target, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_EXT_paletted_texture);
    d->GetColorTableParameterivEXT(target, pname, params);
}

inline void QOpenGLExtension_EXT_paletted_texture::glGetColorTableEXT(GLenum target, GLenum format, GLenum type, GLvoid *data)
{
    Q_D(QOpenGLExtension_EXT_paletted_texture);
    d->GetColorTableEXT(target, format, type, data);
}

inline void QOpenGLExtension_EXT_paletted_texture::glColorTableEXT(GLenum target, GLenum internalFormat, GLsizei width, GLenum format, GLenum type, const GLvoid *table)
{
    Q_D(QOpenGLExtension_EXT_paletted_texture);
    d->ColorTableEXT(target, internalFormat, width, format, type, table);
}

class QOpenGLExtension_EXT_pixel_transformPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetPixelTransformParameterfvEXT)(GLenum target, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP GetPixelTransformParameterivEXT)(GLenum target, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP PixelTransformParameterfvEXT)(GLenum target, GLenum pname, const GLfloat *params);
    void (QOPENGLF_APIENTRYP PixelTransformParameterivEXT)(GLenum target, GLenum pname, const GLint *params);
    void (QOPENGLF_APIENTRYP PixelTransformParameterfEXT)(GLenum target, GLenum pname, GLfloat param);
    void (QOPENGLF_APIENTRYP PixelTransformParameteriEXT)(GLenum target, GLenum pname, GLint param);
};

class QOpenGLExtension_EXT_pixel_transform : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_pixel_transform();

    bool initializeOpenGLFunctions() final;

    void glGetPixelTransformParameterfvEXT(GLenum target, GLenum pname, GLfloat *params);
    void glGetPixelTransformParameterivEXT(GLenum target, GLenum pname, GLint *params);
    void glPixelTransformParameterfvEXT(GLenum target, GLenum pname, const GLfloat *params);
    void glPixelTransformParameterivEXT(GLenum target, GLenum pname, const GLint *params);
    void glPixelTransformParameterfEXT(GLenum target, GLenum pname, GLfloat param);
    void glPixelTransformParameteriEXT(GLenum target, GLenum pname, GLint param);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_pixel_transform)
};

inline void QOpenGLExtension_EXT_pixel_transform::glGetPixelTransformParameterfvEXT(GLenum target, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_EXT_pixel_transform);
    d->GetPixelTransformParameterfvEXT(target, pname, params);
}

inline void QOpenGLExtension_EXT_pixel_transform::glGetPixelTransformParameterivEXT(GLenum target, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_EXT_pixel_transform);
    d->GetPixelTransformParameterivEXT(target, pname, params);
}

inline void QOpenGLExtension_EXT_pixel_transform::glPixelTransformParameterfvEXT(GLenum target, GLenum pname, const GLfloat *params)
{
    Q_D(QOpenGLExtension_EXT_pixel_transform);
    d->PixelTransformParameterfvEXT(target, pname, params);
}

inline void QOpenGLExtension_EXT_pixel_transform::glPixelTransformParameterivEXT(GLenum target, GLenum pname, const GLint *params)
{
    Q_D(QOpenGLExtension_EXT_pixel_transform);
    d->PixelTransformParameterivEXT(target, pname, params);
}

inline void QOpenGLExtension_EXT_pixel_transform::glPixelTransformParameterfEXT(GLenum target, GLenum pname, GLfloat param)
{
    Q_D(QOpenGLExtension_EXT_pixel_transform);
    d->PixelTransformParameterfEXT(target, pname, param);
}

inline void QOpenGLExtension_EXT_pixel_transform::glPixelTransformParameteriEXT(GLenum target, GLenum pname, GLint param)
{
    Q_D(QOpenGLExtension_EXT_pixel_transform);
    d->PixelTransformParameteriEXT(target, pname, param);
}

class QOpenGLExtension_EXT_point_parametersPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP PointParameterfvEXT)(GLenum pname, const GLfloat *params);
    void (QOPENGLF_APIENTRYP PointParameterfEXT)(GLenum pname, GLfloat param);
};

class QOpenGLExtension_EXT_point_parameters : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_point_parameters();

    bool initializeOpenGLFunctions() final;

    void glPointParameterfvEXT(GLenum pname, const GLfloat *params);
    void glPointParameterfEXT(GLenum pname, GLfloat param);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_point_parameters)
};

inline void QOpenGLExtension_EXT_point_parameters::glPointParameterfvEXT(GLenum pname, const GLfloat *params)
{
    Q_D(QOpenGLExtension_EXT_point_parameters);
    d->PointParameterfvEXT(pname, params);
}

inline void QOpenGLExtension_EXT_point_parameters::glPointParameterfEXT(GLenum pname, GLfloat param)
{
    Q_D(QOpenGLExtension_EXT_point_parameters);
    d->PointParameterfEXT(pname, param);
}

class QOpenGLExtension_EXT_polygon_offsetPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP PolygonOffsetEXT)(GLfloat factor, GLfloat bias);
};

class QOpenGLExtension_EXT_polygon_offset : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_polygon_offset();

    bool initializeOpenGLFunctions() final;

    void glPolygonOffsetEXT(GLfloat factor, GLfloat bias);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_polygon_offset)
};

inline void QOpenGLExtension_EXT_polygon_offset::glPolygonOffsetEXT(GLfloat factor, GLfloat bias)
{
    Q_D(QOpenGLExtension_EXT_polygon_offset);
    d->PolygonOffsetEXT(factor, bias);
}

class QOpenGLExtension_EXT_provoking_vertexPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP ProvokingVertexEXT)(GLenum mode);
};

class QOpenGLExtension_EXT_provoking_vertex : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_provoking_vertex();

    bool initializeOpenGLFunctions() final;

    void glProvokingVertexEXT(GLenum mode);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_provoking_vertex)
};

inline void QOpenGLExtension_EXT_provoking_vertex::glProvokingVertexEXT(GLenum mode)
{
    Q_D(QOpenGLExtension_EXT_provoking_vertex);
    d->ProvokingVertexEXT(mode);
}

class QOpenGLExtension_EXT_secondary_colorPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP SecondaryColorPointerEXT)(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
    void (QOPENGLF_APIENTRYP SecondaryColor3usvEXT)(const GLushort *v);
    void (QOPENGLF_APIENTRYP SecondaryColor3usEXT)(GLushort red, GLushort green, GLushort blue);
    void (QOPENGLF_APIENTRYP SecondaryColor3uivEXT)(const GLuint *v);
    void (QOPENGLF_APIENTRYP SecondaryColor3uiEXT)(GLuint red, GLuint green, GLuint blue);
    void (QOPENGLF_APIENTRYP SecondaryColor3ubvEXT)(const GLubyte *v);
    void (QOPENGLF_APIENTRYP SecondaryColor3ubEXT)(GLubyte red, GLubyte green, GLubyte blue);
    void (QOPENGLF_APIENTRYP SecondaryColor3svEXT)(const GLshort *v);
    void (QOPENGLF_APIENTRYP SecondaryColor3sEXT)(GLshort red, GLshort green, GLshort blue);
    void (QOPENGLF_APIENTRYP SecondaryColor3ivEXT)(const GLint *v);
    void (QOPENGLF_APIENTRYP SecondaryColor3iEXT)(GLint red, GLint green, GLint blue);
    void (QOPENGLF_APIENTRYP SecondaryColor3fvEXT)(const GLfloat *v);
    void (QOPENGLF_APIENTRYP SecondaryColor3fEXT)(GLfloat red, GLfloat green, GLfloat blue);
    void (QOPENGLF_APIENTRYP SecondaryColor3dvEXT)(const GLdouble *v);
    void (QOPENGLF_APIENTRYP SecondaryColor3dEXT)(GLdouble red, GLdouble green, GLdouble blue);
    void (QOPENGLF_APIENTRYP SecondaryColor3bvEXT)(const GLbyte *v);
    void (QOPENGLF_APIENTRYP SecondaryColor3bEXT)(GLbyte red, GLbyte green, GLbyte blue);
};

class QOpenGLExtension_EXT_secondary_color : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_secondary_color();

    bool initializeOpenGLFunctions() final;

    void glSecondaryColorPointerEXT(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
    void glSecondaryColor3usvEXT(const GLushort *v);
    void glSecondaryColor3usEXT(GLushort red, GLushort green, GLushort blue);
    void glSecondaryColor3uivEXT(const GLuint *v);
    void glSecondaryColor3uiEXT(GLuint red, GLuint green, GLuint blue);
    void glSecondaryColor3ubvEXT(const GLubyte *v);
    void glSecondaryColor3ubEXT(GLubyte red, GLubyte green, GLubyte blue);
    void glSecondaryColor3svEXT(const GLshort *v);
    void glSecondaryColor3sEXT(GLshort red, GLshort green, GLshort blue);
    void glSecondaryColor3ivEXT(const GLint *v);
    void glSecondaryColor3iEXT(GLint red, GLint green, GLint blue);
    void glSecondaryColor3fvEXT(const GLfloat *v);
    void glSecondaryColor3fEXT(GLfloat red, GLfloat green, GLfloat blue);
    void glSecondaryColor3dvEXT(const GLdouble *v);
    void glSecondaryColor3dEXT(GLdouble red, GLdouble green, GLdouble blue);
    void glSecondaryColor3bvEXT(const GLbyte *v);
    void glSecondaryColor3bEXT(GLbyte red, GLbyte green, GLbyte blue);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_secondary_color)
};

inline void QOpenGLExtension_EXT_secondary_color::glSecondaryColorPointerEXT(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
    Q_D(QOpenGLExtension_EXT_secondary_color);
    d->SecondaryColorPointerEXT(size, type, stride, pointer);
}

inline void QOpenGLExtension_EXT_secondary_color::glSecondaryColor3usvEXT(const GLushort *v)
{
    Q_D(QOpenGLExtension_EXT_secondary_color);
    d->SecondaryColor3usvEXT(v);
}

inline void QOpenGLExtension_EXT_secondary_color::glSecondaryColor3usEXT(GLushort red, GLushort green, GLushort blue)
{
    Q_D(QOpenGLExtension_EXT_secondary_color);
    d->SecondaryColor3usEXT(red, green, blue);
}

inline void QOpenGLExtension_EXT_secondary_color::glSecondaryColor3uivEXT(const GLuint *v)
{
    Q_D(QOpenGLExtension_EXT_secondary_color);
    d->SecondaryColor3uivEXT(v);
}

inline void QOpenGLExtension_EXT_secondary_color::glSecondaryColor3uiEXT(GLuint red, GLuint green, GLuint blue)
{
    Q_D(QOpenGLExtension_EXT_secondary_color);
    d->SecondaryColor3uiEXT(red, green, blue);
}

inline void QOpenGLExtension_EXT_secondary_color::glSecondaryColor3ubvEXT(const GLubyte *v)
{
    Q_D(QOpenGLExtension_EXT_secondary_color);
    d->SecondaryColor3ubvEXT(v);
}

inline void QOpenGLExtension_EXT_secondary_color::glSecondaryColor3ubEXT(GLubyte red, GLubyte green, GLubyte blue)
{
    Q_D(QOpenGLExtension_EXT_secondary_color);
    d->SecondaryColor3ubEXT(red, green, blue);
}

inline void QOpenGLExtension_EXT_secondary_color::glSecondaryColor3svEXT(const GLshort *v)
{
    Q_D(QOpenGLExtension_EXT_secondary_color);
    d->SecondaryColor3svEXT(v);
}

inline void QOpenGLExtension_EXT_secondary_color::glSecondaryColor3sEXT(GLshort red, GLshort green, GLshort blue)
{
    Q_D(QOpenGLExtension_EXT_secondary_color);
    d->SecondaryColor3sEXT(red, green, blue);
}

inline void QOpenGLExtension_EXT_secondary_color::glSecondaryColor3ivEXT(const GLint *v)
{
    Q_D(QOpenGLExtension_EXT_secondary_color);
    d->SecondaryColor3ivEXT(v);
}

inline void QOpenGLExtension_EXT_secondary_color::glSecondaryColor3iEXT(GLint red, GLint green, GLint blue)
{
    Q_D(QOpenGLExtension_EXT_secondary_color);
    d->SecondaryColor3iEXT(red, green, blue);
}

inline void QOpenGLExtension_EXT_secondary_color::glSecondaryColor3fvEXT(const GLfloat *v)
{
    Q_D(QOpenGLExtension_EXT_secondary_color);
    d->SecondaryColor3fvEXT(v);
}

inline void QOpenGLExtension_EXT_secondary_color::glSecondaryColor3fEXT(GLfloat red, GLfloat green, GLfloat blue)
{
    Q_D(QOpenGLExtension_EXT_secondary_color);
    d->SecondaryColor3fEXT(red, green, blue);
}

inline void QOpenGLExtension_EXT_secondary_color::glSecondaryColor3dvEXT(const GLdouble *v)
{
    Q_D(QOpenGLExtension_EXT_secondary_color);
    d->SecondaryColor3dvEXT(v);
}

inline void QOpenGLExtension_EXT_secondary_color::glSecondaryColor3dEXT(GLdouble red, GLdouble green, GLdouble blue)
{
    Q_D(QOpenGLExtension_EXT_secondary_color);
    d->SecondaryColor3dEXT(red, green, blue);
}

inline void QOpenGLExtension_EXT_secondary_color::glSecondaryColor3bvEXT(const GLbyte *v)
{
    Q_D(QOpenGLExtension_EXT_secondary_color);
    d->SecondaryColor3bvEXT(v);
}

inline void QOpenGLExtension_EXT_secondary_color::glSecondaryColor3bEXT(GLbyte red, GLbyte green, GLbyte blue)
{
    Q_D(QOpenGLExtension_EXT_secondary_color);
    d->SecondaryColor3bEXT(red, green, blue);
}

class QOpenGLExtension_EXT_separate_shader_objectsPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    GLuint (QOPENGLF_APIENTRYP CreateShaderProgramEXT)(GLenum type, const GLchar *string);
    void (QOPENGLF_APIENTRYP ActiveProgramEXT)(GLuint program);
    void (QOPENGLF_APIENTRYP UseShaderProgramEXT)(GLenum type, GLuint program);
};

class QOpenGLExtension_EXT_separate_shader_objects : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_separate_shader_objects();

    bool initializeOpenGLFunctions() final;

    GLuint glCreateShaderProgramEXT(GLenum type, const GLchar *string);
    void glActiveProgramEXT(GLuint program);
    void glUseShaderProgramEXT(GLenum type, GLuint program);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_separate_shader_objects)
};

inline GLuint QOpenGLExtension_EXT_separate_shader_objects::glCreateShaderProgramEXT(GLenum type, const GLchar *string)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    return d->CreateShaderProgramEXT(type, string);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glActiveProgramEXT(GLuint program)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->ActiveProgramEXT(program);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glUseShaderProgramEXT(GLenum type, GLuint program)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->UseShaderProgramEXT(type, program);
}

class QOpenGLExtension_EXT_shader_image_load_storePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP MemoryBarrierEXT)(GLbitfield barriers);
    void (QOPENGLF_APIENTRYP BindImageTextureEXT)(GLuint index, GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum access, GLint format);
};

class QOpenGLExtension_EXT_shader_image_load_store : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_shader_image_load_store();

    bool initializeOpenGLFunctions() final;

    void glMemoryBarrierEXT(GLbitfield barriers);
    void glBindImageTextureEXT(GLuint index, GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum access, GLint format);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_shader_image_load_store)
};

inline void QOpenGLExtension_EXT_shader_image_load_store::glMemoryBarrierEXT(GLbitfield barriers)
{
    Q_D(QOpenGLExtension_EXT_shader_image_load_store);
    d->MemoryBarrierEXT(barriers);
}

inline void QOpenGLExtension_EXT_shader_image_load_store::glBindImageTextureEXT(GLuint index, GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum access, GLint format)
{
    Q_D(QOpenGLExtension_EXT_shader_image_load_store);
    d->BindImageTextureEXT(index, texture, level, layered, layer, access, format);
}

class QOpenGLExtension_EXT_stencil_clear_tagPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP StencilClearTagEXT)(GLsizei stencilTagBits, GLuint stencilClearTag);
};

class QOpenGLExtension_EXT_stencil_clear_tag : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_stencil_clear_tag();

    bool initializeOpenGLFunctions() final;

    void glStencilClearTagEXT(GLsizei stencilTagBits, GLuint stencilClearTag);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_stencil_clear_tag)
};

inline void QOpenGLExtension_EXT_stencil_clear_tag::glStencilClearTagEXT(GLsizei stencilTagBits, GLuint stencilClearTag)
{
    Q_D(QOpenGLExtension_EXT_stencil_clear_tag);
    d->StencilClearTagEXT(stencilTagBits, stencilClearTag);
}

class QOpenGLExtension_EXT_stencil_two_sidePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP ActiveStencilFaceEXT)(GLenum face);
};

class QOpenGLExtension_EXT_stencil_two_side : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_stencil_two_side();

    bool initializeOpenGLFunctions() final;

    void glActiveStencilFaceEXT(GLenum face);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_stencil_two_side)
};

inline void QOpenGLExtension_EXT_stencil_two_side::glActiveStencilFaceEXT(GLenum face)
{
    Q_D(QOpenGLExtension_EXT_stencil_two_side);
    d->ActiveStencilFaceEXT(face);
}

class QOpenGLExtension_EXT_subtexturePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP TexSubImage2DEXT)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
    void (QOPENGLF_APIENTRYP TexSubImage1DEXT)(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels);
};

class QOpenGLExtension_EXT_subtexture : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_subtexture();

    bool initializeOpenGLFunctions() final;

    void glTexSubImage2DEXT(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
    void glTexSubImage1DEXT(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_subtexture)
};

inline void QOpenGLExtension_EXT_subtexture::glTexSubImage2DEXT(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)
{
    Q_D(QOpenGLExtension_EXT_subtexture);
    d->TexSubImage2DEXT(target, level, xoffset, yoffset, width, height, format, type, pixels);
}

inline void QOpenGLExtension_EXT_subtexture::glTexSubImage1DEXT(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels)
{
    Q_D(QOpenGLExtension_EXT_subtexture);
    d->TexSubImage1DEXT(target, level, xoffset, width, format, type, pixels);
}

class QOpenGLExtension_EXT_texture3DPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP TexSubImage3DEXT)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels);
    void (QOPENGLF_APIENTRYP TexImage3DEXT)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
};

class QOpenGLExtension_EXT_texture3D : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_texture3D();

    bool initializeOpenGLFunctions() final;

    void glTexSubImage3DEXT(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels);
    void glTexImage3DEXT(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_texture3D)
};

inline void QOpenGLExtension_EXT_texture3D::glTexSubImage3DEXT(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels)
{
    Q_D(QOpenGLExtension_EXT_texture3D);
    d->TexSubImage3DEXT(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
}

inline void QOpenGLExtension_EXT_texture3D::glTexImage3DEXT(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
    Q_D(QOpenGLExtension_EXT_texture3D);
    d->TexImage3DEXT(target, level, internalformat, width, height, depth, border, format, type, pixels);
}

class QOpenGLExtension_EXT_texture_buffer_objectPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP TexBufferEXT)(GLenum target, GLenum internalformat, GLuint buffer);
};

class QOpenGLExtension_EXT_texture_buffer_object : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_texture_buffer_object();

    bool initializeOpenGLFunctions() final;

    void glTexBufferEXT(GLenum target, GLenum internalformat, GLuint buffer);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_texture_buffer_object)
};

inline void QOpenGLExtension_EXT_texture_buffer_object::glTexBufferEXT(GLenum target, GLenum internalformat, GLuint buffer)
{
    Q_D(QOpenGLExtension_EXT_texture_buffer_object);
    d->TexBufferEXT(target, internalformat, buffer);
}

class QOpenGLExtension_EXT_texture_integerPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP ClearColorIuiEXT)(GLuint red, GLuint green, GLuint blue, GLuint alpha);
    void (QOPENGLF_APIENTRYP ClearColorIiEXT)(GLint red, GLint green, GLint blue, GLint alpha);
    void (QOPENGLF_APIENTRYP GetTexParameterIuivEXT)(GLenum target, GLenum pname, GLuint *params);
    void (QOPENGLF_APIENTRYP GetTexParameterIivEXT)(GLenum target, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP TexParameterIuivEXT)(GLenum target, GLenum pname, const GLuint *params);
    void (QOPENGLF_APIENTRYP TexParameterIivEXT)(GLenum target, GLenum pname, const GLint *params);
};

class QOpenGLExtension_EXT_texture_integer : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_texture_integer();

    bool initializeOpenGLFunctions() final;

    void glClearColorIuiEXT(GLuint red, GLuint green, GLuint blue, GLuint alpha);
    void glClearColorIiEXT(GLint red, GLint green, GLint blue, GLint alpha);
    void glGetTexParameterIuivEXT(GLenum target, GLenum pname, GLuint *params);
    void glGetTexParameterIivEXT(GLenum target, GLenum pname, GLint *params);
    void glTexParameterIuivEXT(GLenum target, GLenum pname, const GLuint *params);
    void glTexParameterIivEXT(GLenum target, GLenum pname, const GLint *params);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_texture_integer)
};

inline void QOpenGLExtension_EXT_texture_integer::glClearColorIuiEXT(GLuint red, GLuint green, GLuint blue, GLuint alpha)
{
    Q_D(QOpenGLExtension_EXT_texture_integer);
    d->ClearColorIuiEXT(red, green, blue, alpha);
}

inline void QOpenGLExtension_EXT_texture_integer::glClearColorIiEXT(GLint red, GLint green, GLint blue, GLint alpha)
{
    Q_D(QOpenGLExtension_EXT_texture_integer);
    d->ClearColorIiEXT(red, green, blue, alpha);
}

inline void QOpenGLExtension_EXT_texture_integer::glGetTexParameterIuivEXT(GLenum target, GLenum pname, GLuint *params)
{
    Q_D(QOpenGLExtension_EXT_texture_integer);
    d->GetTexParameterIuivEXT(target, pname, params);
}

inline void QOpenGLExtension_EXT_texture_integer::glGetTexParameterIivEXT(GLenum target, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_EXT_texture_integer);
    d->GetTexParameterIivEXT(target, pname, params);
}

inline void QOpenGLExtension_EXT_texture_integer::glTexParameterIuivEXT(GLenum target, GLenum pname, const GLuint *params)
{
    Q_D(QOpenGLExtension_EXT_texture_integer);
    d->TexParameterIuivEXT(target, pname, params);
}

inline void QOpenGLExtension_EXT_texture_integer::glTexParameterIivEXT(GLenum target, GLenum pname, const GLint *params)
{
    Q_D(QOpenGLExtension_EXT_texture_integer);
    d->TexParameterIivEXT(target, pname, params);
}

class QOpenGLExtension_EXT_texture_objectPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP PrioritizeTexturesEXT)(GLsizei n, const GLuint *textures, const GLclampf *priorities);
    GLboolean (QOPENGLF_APIENTRYP IsTextureEXT)(GLuint texture);
    void (QOPENGLF_APIENTRYP GenTexturesEXT)(GLsizei n, GLuint *textures);
    void (QOPENGLF_APIENTRYP DeleteTexturesEXT)(GLsizei n, const GLuint *textures);
    void (QOPENGLF_APIENTRYP BindTextureEXT)(GLenum target, GLuint texture);
    GLboolean (QOPENGLF_APIENTRYP AreTexturesResidentEXT)(GLsizei n, const GLuint *textures, GLboolean *residences);
};

class QOpenGLExtension_EXT_texture_object : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_texture_object();

    bool initializeOpenGLFunctions() final;

    void glPrioritizeTexturesEXT(GLsizei n, const GLuint *textures, const GLclampf *priorities);
    GLboolean glIsTextureEXT(GLuint texture);
    void glGenTexturesEXT(GLsizei n, GLuint *textures);
    void glDeleteTexturesEXT(GLsizei n, const GLuint *textures);
    void glBindTextureEXT(GLenum target, GLuint texture);
    GLboolean glAreTexturesResidentEXT(GLsizei n, const GLuint *textures, GLboolean *residences);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_texture_object)
};

inline void QOpenGLExtension_EXT_texture_object::glPrioritizeTexturesEXT(GLsizei n, const GLuint *textures, const GLclampf *priorities)
{
    Q_D(QOpenGLExtension_EXT_texture_object);
    d->PrioritizeTexturesEXT(n, textures, priorities);
}

inline GLboolean QOpenGLExtension_EXT_texture_object::glIsTextureEXT(GLuint texture)
{
    Q_D(QOpenGLExtension_EXT_texture_object);
    return d->IsTextureEXT(texture);
}

inline void QOpenGLExtension_EXT_texture_object::glGenTexturesEXT(GLsizei n, GLuint *textures)
{
    Q_D(QOpenGLExtension_EXT_texture_object);
    d->GenTexturesEXT(n, textures);
}

inline void QOpenGLExtension_EXT_texture_object::glDeleteTexturesEXT(GLsizei n, const GLuint *textures)
{
    Q_D(QOpenGLExtension_EXT_texture_object);
    d->DeleteTexturesEXT(n, textures);
}

inline void QOpenGLExtension_EXT_texture_object::glBindTextureEXT(GLenum target, GLuint texture)
{
    Q_D(QOpenGLExtension_EXT_texture_object);
    d->BindTextureEXT(target, texture);
}

inline GLboolean QOpenGLExtension_EXT_texture_object::glAreTexturesResidentEXT(GLsizei n, const GLuint *textures, GLboolean *residences)
{
    Q_D(QOpenGLExtension_EXT_texture_object);
    return d->AreTexturesResidentEXT(n, textures, residences);
}

class QOpenGLExtension_EXT_texture_perturb_normalPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP TextureNormalEXT)(GLenum mode);
};

class QOpenGLExtension_EXT_texture_perturb_normal : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_texture_perturb_normal();

    bool initializeOpenGLFunctions() final;

    void glTextureNormalEXT(GLenum mode);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_texture_perturb_normal)
};

inline void QOpenGLExtension_EXT_texture_perturb_normal::glTextureNormalEXT(GLenum mode)
{
    Q_D(QOpenGLExtension_EXT_texture_perturb_normal);
    d->TextureNormalEXT(mode);
}

class QOpenGLExtension_EXT_timer_queryPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetQueryObjectui64vEXT)(GLuint id, GLenum pname, GLuint64EXT *params);
    void (QOPENGLF_APIENTRYP GetQueryObjecti64vEXT)(GLuint id, GLenum pname, GLint64EXT *params);
};

class QOpenGLExtension_EXT_timer_query : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_timer_query();

    bool initializeOpenGLFunctions() final;

    void glGetQueryObjectui64vEXT(GLuint id, GLenum pname, GLuint64EXT *params);
    void glGetQueryObjecti64vEXT(GLuint id, GLenum pname, GLint64EXT *params);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_timer_query)
};

inline void QOpenGLExtension_EXT_timer_query::glGetQueryObjectui64vEXT(GLuint id, GLenum pname, GLuint64EXT *params)
{
    Q_D(QOpenGLExtension_EXT_timer_query);
    d->GetQueryObjectui64vEXT(id, pname, params);
}

inline void QOpenGLExtension_EXT_timer_query::glGetQueryObjecti64vEXT(GLuint id, GLenum pname, GLint64EXT *params)
{
    Q_D(QOpenGLExtension_EXT_timer_query);
    d->GetQueryObjecti64vEXT(id, pname, params);
}

class QOpenGLExtension_EXT_transform_feedbackPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetTransformFeedbackVaryingEXT)(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name);
    void (QOPENGLF_APIENTRYP TransformFeedbackVaryingsEXT)(GLuint program, GLsizei count, const GLchar* *varyings, GLenum bufferMode);
    void (QOPENGLF_APIENTRYP BindBufferBaseEXT)(GLenum target, GLuint index, GLuint buffer);
    void (QOPENGLF_APIENTRYP BindBufferOffsetEXT)(GLenum target, GLuint index, GLuint buffer, GLintptr offset);
    void (QOPENGLF_APIENTRYP BindBufferRangeEXT)(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size);
    void (QOPENGLF_APIENTRYP EndTransformFeedbackEXT)();
    void (QOPENGLF_APIENTRYP BeginTransformFeedbackEXT)(GLenum primitiveMode);
};

class QOpenGLExtension_EXT_transform_feedback : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_transform_feedback();

    bool initializeOpenGLFunctions() final;

    void glGetTransformFeedbackVaryingEXT(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name);
    void glTransformFeedbackVaryingsEXT(GLuint program, GLsizei count, const GLchar* *varyings, GLenum bufferMode);
    void glBindBufferBaseEXT(GLenum target, GLuint index, GLuint buffer);
    void glBindBufferOffsetEXT(GLenum target, GLuint index, GLuint buffer, GLintptr offset);
    void glBindBufferRangeEXT(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size);
    void glEndTransformFeedbackEXT();
    void glBeginTransformFeedbackEXT(GLenum primitiveMode);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_transform_feedback)
};

inline void QOpenGLExtension_EXT_transform_feedback::glGetTransformFeedbackVaryingEXT(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name)
{
    Q_D(QOpenGLExtension_EXT_transform_feedback);
    d->GetTransformFeedbackVaryingEXT(program, index, bufSize, length, size, type, name);
}

inline void QOpenGLExtension_EXT_transform_feedback::glTransformFeedbackVaryingsEXT(GLuint program, GLsizei count, const GLchar* *varyings, GLenum bufferMode)
{
    Q_D(QOpenGLExtension_EXT_transform_feedback);
    d->TransformFeedbackVaryingsEXT(program, count, varyings, bufferMode);
}

inline void QOpenGLExtension_EXT_transform_feedback::glBindBufferBaseEXT(GLenum target, GLuint index, GLuint buffer)
{
    Q_D(QOpenGLExtension_EXT_transform_feedback);
    d->BindBufferBaseEXT(target, index, buffer);
}

inline void QOpenGLExtension_EXT_transform_feedback::glBindBufferOffsetEXT(GLenum target, GLuint index, GLuint buffer, GLintptr offset)
{
    Q_D(QOpenGLExtension_EXT_transform_feedback);
    d->BindBufferOffsetEXT(target, index, buffer, offset);
}

inline void QOpenGLExtension_EXT_transform_feedback::glBindBufferRangeEXT(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size)
{
    Q_D(QOpenGLExtension_EXT_transform_feedback);
    d->BindBufferRangeEXT(target, index, buffer, offset, size);
}

inline void QOpenGLExtension_EXT_transform_feedback::glEndTransformFeedbackEXT()
{
    Q_D(QOpenGLExtension_EXT_transform_feedback);
    d->EndTransformFeedbackEXT();
}

inline void QOpenGLExtension_EXT_transform_feedback::glBeginTransformFeedbackEXT(GLenum primitiveMode)
{
    Q_D(QOpenGLExtension_EXT_transform_feedback);
    d->BeginTransformFeedbackEXT(primitiveMode);
}

class QOpenGLExtension_EXT_vertex_arrayPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP VertexPointerEXT)(GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
    void (QOPENGLF_APIENTRYP TexCoordPointerEXT)(GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
    void (QOPENGLF_APIENTRYP NormalPointerEXT)(GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
    void (QOPENGLF_APIENTRYP IndexPointerEXT)(GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
    void (QOPENGLF_APIENTRYP GetPointervEXT)(GLenum pname, GLvoid* *params);
    void (QOPENGLF_APIENTRYP EdgeFlagPointerEXT)(GLsizei stride, GLsizei count, const GLboolean *pointer);
    void (QOPENGLF_APIENTRYP DrawArraysEXT)(GLenum mode, GLint first, GLsizei count);
    void (QOPENGLF_APIENTRYP ColorPointerEXT)(GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
    void (QOPENGLF_APIENTRYP ArrayElementEXT)(GLint i);
};

class QOpenGLExtension_EXT_vertex_array : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_vertex_array();

    bool initializeOpenGLFunctions() final;

    void glVertexPointerEXT(GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
    void glTexCoordPointerEXT(GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
    void glNormalPointerEXT(GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
    void glIndexPointerEXT(GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
    void glGetPointervEXT(GLenum pname, GLvoid* *params);
    void glEdgeFlagPointerEXT(GLsizei stride, GLsizei count, const GLboolean *pointer);
    void glDrawArraysEXT(GLenum mode, GLint first, GLsizei count);
    void glColorPointerEXT(GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
    void glArrayElementEXT(GLint i);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_vertex_array)
};

inline void QOpenGLExtension_EXT_vertex_array::glVertexPointerEXT(GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer)
{
    Q_D(QOpenGLExtension_EXT_vertex_array);
    d->VertexPointerEXT(size, type, stride, count, pointer);
}

inline void QOpenGLExtension_EXT_vertex_array::glTexCoordPointerEXT(GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer)
{
    Q_D(QOpenGLExtension_EXT_vertex_array);
    d->TexCoordPointerEXT(size, type, stride, count, pointer);
}

inline void QOpenGLExtension_EXT_vertex_array::glNormalPointerEXT(GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer)
{
    Q_D(QOpenGLExtension_EXT_vertex_array);
    d->NormalPointerEXT(type, stride, count, pointer);
}

inline void QOpenGLExtension_EXT_vertex_array::glIndexPointerEXT(GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer)
{
    Q_D(QOpenGLExtension_EXT_vertex_array);
    d->IndexPointerEXT(type, stride, count, pointer);
}

inline void QOpenGLExtension_EXT_vertex_array::glGetPointervEXT(GLenum pname, GLvoid* *params)
{
    Q_D(QOpenGLExtension_EXT_vertex_array);
    d->GetPointervEXT(pname, params);
}

inline void QOpenGLExtension_EXT_vertex_array::glEdgeFlagPointerEXT(GLsizei stride, GLsizei count, const GLboolean *pointer)
{
    Q_D(QOpenGLExtension_EXT_vertex_array);
    d->EdgeFlagPointerEXT(stride, count, pointer);
}

inline void QOpenGLExtension_EXT_vertex_array::glDrawArraysEXT(GLenum mode, GLint first, GLsizei count)
{
    Q_D(QOpenGLExtension_EXT_vertex_array);
    d->DrawArraysEXT(mode, first, count);
}

inline void QOpenGLExtension_EXT_vertex_array::glColorPointerEXT(GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer)
{
    Q_D(QOpenGLExtension_EXT_vertex_array);
    d->ColorPointerEXT(size, type, stride, count, pointer);
}

inline void QOpenGLExtension_EXT_vertex_array::glArrayElementEXT(GLint i)
{
    Q_D(QOpenGLExtension_EXT_vertex_array);
    d->ArrayElementEXT(i);
}

class QOpenGLExtension_EXT_vertex_attrib_64bitPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP VertexArrayVertexAttribLOffsetEXT)(GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLsizei stride, GLintptr offset);
    void (QOPENGLF_APIENTRYP GetVertexAttribLdvEXT)(GLuint index, GLenum pname, GLdouble *params);
    void (QOPENGLF_APIENTRYP VertexAttribLPointerEXT)(GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
    void (QOPENGLF_APIENTRYP VertexAttribL4dvEXT)(GLuint index, const GLdouble *v);
    void (QOPENGLF_APIENTRYP VertexAttribL3dvEXT)(GLuint index, const GLdouble *v);
    void (QOPENGLF_APIENTRYP VertexAttribL2dvEXT)(GLuint index, const GLdouble *v);
    void (QOPENGLF_APIENTRYP VertexAttribL1dvEXT)(GLuint index, const GLdouble *v);
    void (QOPENGLF_APIENTRYP VertexAttribL4dEXT)(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
    void (QOPENGLF_APIENTRYP VertexAttribL3dEXT)(GLuint index, GLdouble x, GLdouble y, GLdouble z);
    void (QOPENGLF_APIENTRYP VertexAttribL2dEXT)(GLuint index, GLdouble x, GLdouble y);
    void (QOPENGLF_APIENTRYP VertexAttribL1dEXT)(GLuint index, GLdouble x);
};

class QOpenGLExtension_EXT_vertex_attrib_64bit : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_vertex_attrib_64bit();

    bool initializeOpenGLFunctions() final;

    void glVertexArrayVertexAttribLOffsetEXT(GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLsizei stride, GLintptr offset);
    void glGetVertexAttribLdvEXT(GLuint index, GLenum pname, GLdouble *params);
    void glVertexAttribLPointerEXT(GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
    void glVertexAttribL4dvEXT(GLuint index, const GLdouble *v);
    void glVertexAttribL3dvEXT(GLuint index, const GLdouble *v);
    void glVertexAttribL2dvEXT(GLuint index, const GLdouble *v);
    void glVertexAttribL1dvEXT(GLuint index, const GLdouble *v);
    void glVertexAttribL4dEXT(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
    void glVertexAttribL3dEXT(GLuint index, GLdouble x, GLdouble y, GLdouble z);
    void glVertexAttribL2dEXT(GLuint index, GLdouble x, GLdouble y);
    void glVertexAttribL1dEXT(GLuint index, GLdouble x);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_vertex_attrib_64bit)
};

inline void QOpenGLExtension_EXT_vertex_attrib_64bit::glVertexArrayVertexAttribLOffsetEXT(GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLsizei stride, GLintptr offset)
{
    Q_D(QOpenGLExtension_EXT_vertex_attrib_64bit);
    d->VertexArrayVertexAttribLOffsetEXT(vaobj, buffer, index, size, type, stride, offset);
}

inline void QOpenGLExtension_EXT_vertex_attrib_64bit::glGetVertexAttribLdvEXT(GLuint index, GLenum pname, GLdouble *params)
{
    Q_D(QOpenGLExtension_EXT_vertex_attrib_64bit);
    d->GetVertexAttribLdvEXT(index, pname, params);
}

inline void QOpenGLExtension_EXT_vertex_attrib_64bit::glVertexAttribLPointerEXT(GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
    Q_D(QOpenGLExtension_EXT_vertex_attrib_64bit);
    d->VertexAttribLPointerEXT(index, size, type, stride, pointer);
}

inline void QOpenGLExtension_EXT_vertex_attrib_64bit::glVertexAttribL4dvEXT(GLuint index, const GLdouble *v)
{
    Q_D(QOpenGLExtension_EXT_vertex_attrib_64bit);
    d->VertexAttribL4dvEXT(index, v);
}

inline void QOpenGLExtension_EXT_vertex_attrib_64bit::glVertexAttribL3dvEXT(GLuint index, const GLdouble *v)
{
    Q_D(QOpenGLExtension_EXT_vertex_attrib_64bit);
    d->VertexAttribL3dvEXT(index, v);
}

inline void QOpenGLExtension_EXT_vertex_attrib_64bit::glVertexAttribL2dvEXT(GLuint index, const GLdouble *v)
{
    Q_D(QOpenGLExtension_EXT_vertex_attrib_64bit);
    d->VertexAttribL2dvEXT(index, v);
}

inline void QOpenGLExtension_EXT_vertex_attrib_64bit::glVertexAttribL1dvEXT(GLuint index, const GLdouble *v)
{
    Q_D(QOpenGLExtension_EXT_vertex_attrib_64bit);
    d->VertexAttribL1dvEXT(index, v);
}

inline void QOpenGLExtension_EXT_vertex_attrib_64bit::glVertexAttribL4dEXT(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    Q_D(QOpenGLExtension_EXT_vertex_attrib_64bit);
    d->VertexAttribL4dEXT(index, x, y, z, w);
}

inline void QOpenGLExtension_EXT_vertex_attrib_64bit::glVertexAttribL3dEXT(GLuint index, GLdouble x, GLdouble y, GLdouble z)
{
    Q_D(QOpenGLExtension_EXT_vertex_attrib_64bit);
    d->VertexAttribL3dEXT(index, x, y, z);
}

inline void QOpenGLExtension_EXT_vertex_attrib_64bit::glVertexAttribL2dEXT(GLuint index, GLdouble x, GLdouble y)
{
    Q_D(QOpenGLExtension_EXT_vertex_attrib_64bit);
    d->VertexAttribL2dEXT(index, x, y);
}

inline void QOpenGLExtension_EXT_vertex_attrib_64bit::glVertexAttribL1dEXT(GLuint index, GLdouble x)
{
    Q_D(QOpenGLExtension_EXT_vertex_attrib_64bit);
    d->VertexAttribL1dEXT(index, x);
}

class QOpenGLExtension_EXT_vertex_shaderPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetLocalConstantFloatvEXT)(GLuint id, GLenum value, GLfloat *data);
    void (QOPENGLF_APIENTRYP GetLocalConstantIntegervEXT)(GLuint id, GLenum value, GLint *data);
    void (QOPENGLF_APIENTRYP GetLocalConstantBooleanvEXT)(GLuint id, GLenum value, GLboolean *data);
    void (QOPENGLF_APIENTRYP GetInvariantFloatvEXT)(GLuint id, GLenum value, GLfloat *data);
    void (QOPENGLF_APIENTRYP GetInvariantIntegervEXT)(GLuint id, GLenum value, GLint *data);
    void (QOPENGLF_APIENTRYP GetInvariantBooleanvEXT)(GLuint id, GLenum value, GLboolean *data);
    void (QOPENGLF_APIENTRYP GetVariantPointervEXT)(GLuint id, GLenum value, GLvoid* *data);
    void (QOPENGLF_APIENTRYP GetVariantFloatvEXT)(GLuint id, GLenum value, GLfloat *data);
    void (QOPENGLF_APIENTRYP GetVariantIntegervEXT)(GLuint id, GLenum value, GLint *data);
    void (QOPENGLF_APIENTRYP GetVariantBooleanvEXT)(GLuint id, GLenum value, GLboolean *data);
    GLboolean (QOPENGLF_APIENTRYP IsVariantEnabledEXT)(GLuint id, GLenum cap);
    GLuint (QOPENGLF_APIENTRYP BindParameterEXT)(GLenum value);
    GLuint (QOPENGLF_APIENTRYP BindTextureUnitParameterEXT)(GLenum unit, GLenum value);
    GLuint (QOPENGLF_APIENTRYP BindTexGenParameterEXT)(GLenum unit, GLenum coord, GLenum value);
    GLuint (QOPENGLF_APIENTRYP BindMaterialParameterEXT)(GLenum face, GLenum value);
    GLuint (QOPENGLF_APIENTRYP BindLightParameterEXT)(GLenum light, GLenum value);
    void (QOPENGLF_APIENTRYP DisableVariantClientStateEXT)(GLuint id);
    void (QOPENGLF_APIENTRYP EnableVariantClientStateEXT)(GLuint id);
    void (QOPENGLF_APIENTRYP VariantPointerEXT)(GLuint id, GLenum type, GLuint stride, const GLvoid *addr);
    void (QOPENGLF_APIENTRYP VariantuivEXT)(GLuint id, const GLuint *addr);
    void (QOPENGLF_APIENTRYP VariantusvEXT)(GLuint id, const GLushort *addr);
    void (QOPENGLF_APIENTRYP VariantubvEXT)(GLuint id, const GLubyte *addr);
    void (QOPENGLF_APIENTRYP VariantdvEXT)(GLuint id, const GLdouble *addr);
    void (QOPENGLF_APIENTRYP VariantfvEXT)(GLuint id, const GLfloat *addr);
    void (QOPENGLF_APIENTRYP VariantivEXT)(GLuint id, const GLint *addr);
    void (QOPENGLF_APIENTRYP VariantsvEXT)(GLuint id, const GLshort *addr);
    void (QOPENGLF_APIENTRYP VariantbvEXT)(GLuint id, const GLbyte *addr);
    void (QOPENGLF_APIENTRYP SetLocalConstantEXT)(GLuint id, GLenum type, const GLvoid *addr);
    void (QOPENGLF_APIENTRYP SetInvariantEXT)(GLuint id, GLenum type, const GLvoid *addr);
    GLuint (QOPENGLF_APIENTRYP GenSymbolsEXT)(GLenum datatype, GLenum storagetype, GLenum range, GLuint components);
    void (QOPENGLF_APIENTRYP ExtractComponentEXT)(GLuint res, GLuint src, GLuint num);
    void (QOPENGLF_APIENTRYP InsertComponentEXT)(GLuint res, GLuint src, GLuint num);
    void (QOPENGLF_APIENTRYP WriteMaskEXT)(GLuint res, GLuint in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW);
    void (QOPENGLF_APIENTRYP SwizzleEXT)(GLuint res, GLuint in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW);
    void (QOPENGLF_APIENTRYP ShaderOp3EXT)(GLenum op, GLuint res, GLuint arg1, GLuint arg2, GLuint arg3);
    void (QOPENGLF_APIENTRYP ShaderOp2EXT)(GLenum op, GLuint res, GLuint arg1, GLuint arg2);
    void (QOPENGLF_APIENTRYP ShaderOp1EXT)(GLenum op, GLuint res, GLuint arg1);
    void (QOPENGLF_APIENTRYP DeleteVertexShaderEXT)(GLuint id);
    GLuint (QOPENGLF_APIENTRYP GenVertexShadersEXT)(GLuint range);
    void (QOPENGLF_APIENTRYP BindVertexShaderEXT)(GLuint id);
    void (QOPENGLF_APIENTRYP EndVertexShaderEXT)();
    void (QOPENGLF_APIENTRYP BeginVertexShaderEXT)();
};

class QOpenGLExtension_EXT_vertex_shader : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_vertex_shader();

    bool initializeOpenGLFunctions() final;

    void glGetLocalConstantFloatvEXT(GLuint id, GLenum value, GLfloat *data);
    void glGetLocalConstantIntegervEXT(GLuint id, GLenum value, GLint *data);
    void glGetLocalConstantBooleanvEXT(GLuint id, GLenum value, GLboolean *data);
    void glGetInvariantFloatvEXT(GLuint id, GLenum value, GLfloat *data);
    void glGetInvariantIntegervEXT(GLuint id, GLenum value, GLint *data);
    void glGetInvariantBooleanvEXT(GLuint id, GLenum value, GLboolean *data);
    void glGetVariantPointervEXT(GLuint id, GLenum value, GLvoid* *data);
    void glGetVariantFloatvEXT(GLuint id, GLenum value, GLfloat *data);
    void glGetVariantIntegervEXT(GLuint id, GLenum value, GLint *data);
    void glGetVariantBooleanvEXT(GLuint id, GLenum value, GLboolean *data);
    GLboolean glIsVariantEnabledEXT(GLuint id, GLenum cap);
    GLuint glBindParameterEXT(GLenum value);
    GLuint glBindTextureUnitParameterEXT(GLenum unit, GLenum value);
    GLuint glBindTexGenParameterEXT(GLenum unit, GLenum coord, GLenum value);
    GLuint glBindMaterialParameterEXT(GLenum face, GLenum value);
    GLuint glBindLightParameterEXT(GLenum light, GLenum value);
    void glDisableVariantClientStateEXT(GLuint id);
    void glEnableVariantClientStateEXT(GLuint id);
    void glVariantPointerEXT(GLuint id, GLenum type, GLuint stride, const GLvoid *addr);
    void glVariantuivEXT(GLuint id, const GLuint *addr);
    void glVariantusvEXT(GLuint id, const GLushort *addr);
    void glVariantubvEXT(GLuint id, const GLubyte *addr);
    void glVariantdvEXT(GLuint id, const GLdouble *addr);
    void glVariantfvEXT(GLuint id, const GLfloat *addr);
    void glVariantivEXT(GLuint id, const GLint *addr);
    void glVariantsvEXT(GLuint id, const GLshort *addr);
    void glVariantbvEXT(GLuint id, const GLbyte *addr);
    void glSetLocalConstantEXT(GLuint id, GLenum type, const GLvoid *addr);
    void glSetInvariantEXT(GLuint id, GLenum type, const GLvoid *addr);
    GLuint glGenSymbolsEXT(GLenum datatype, GLenum storagetype, GLenum range, GLuint components);
    void glExtractComponentEXT(GLuint res, GLuint src, GLuint num);
    void glInsertComponentEXT(GLuint res, GLuint src, GLuint num);
    void glWriteMaskEXT(GLuint res, GLuint in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW);
    void glSwizzleEXT(GLuint res, GLuint in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW);
    void glShaderOp3EXT(GLenum op, GLuint res, GLuint arg1, GLuint arg2, GLuint arg3);
    void glShaderOp2EXT(GLenum op, GLuint res, GLuint arg1, GLuint arg2);
    void glShaderOp1EXT(GLenum op, GLuint res, GLuint arg1);
    void glDeleteVertexShaderEXT(GLuint id);
    GLuint glGenVertexShadersEXT(GLuint range);
    void glBindVertexShaderEXT(GLuint id);
    void glEndVertexShaderEXT();
    void glBeginVertexShaderEXT();

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_vertex_shader)
};

inline void QOpenGLExtension_EXT_vertex_shader::glGetLocalConstantFloatvEXT(GLuint id, GLenum value, GLfloat *data)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->GetLocalConstantFloatvEXT(id, value, data);
}

inline void QOpenGLExtension_EXT_vertex_shader::glGetLocalConstantIntegervEXT(GLuint id, GLenum value, GLint *data)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->GetLocalConstantIntegervEXT(id, value, data);
}

inline void QOpenGLExtension_EXT_vertex_shader::glGetLocalConstantBooleanvEXT(GLuint id, GLenum value, GLboolean *data)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->GetLocalConstantBooleanvEXT(id, value, data);
}

inline void QOpenGLExtension_EXT_vertex_shader::glGetInvariantFloatvEXT(GLuint id, GLenum value, GLfloat *data)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->GetInvariantFloatvEXT(id, value, data);
}

inline void QOpenGLExtension_EXT_vertex_shader::glGetInvariantIntegervEXT(GLuint id, GLenum value, GLint *data)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->GetInvariantIntegervEXT(id, value, data);
}

inline void QOpenGLExtension_EXT_vertex_shader::glGetInvariantBooleanvEXT(GLuint id, GLenum value, GLboolean *data)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->GetInvariantBooleanvEXT(id, value, data);
}

inline void QOpenGLExtension_EXT_vertex_shader::glGetVariantPointervEXT(GLuint id, GLenum value, GLvoid* *data)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->GetVariantPointervEXT(id, value, data);
}

inline void QOpenGLExtension_EXT_vertex_shader::glGetVariantFloatvEXT(GLuint id, GLenum value, GLfloat *data)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->GetVariantFloatvEXT(id, value, data);
}

inline void QOpenGLExtension_EXT_vertex_shader::glGetVariantIntegervEXT(GLuint id, GLenum value, GLint *data)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->GetVariantIntegervEXT(id, value, data);
}

inline void QOpenGLExtension_EXT_vertex_shader::glGetVariantBooleanvEXT(GLuint id, GLenum value, GLboolean *data)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->GetVariantBooleanvEXT(id, value, data);
}

inline GLboolean QOpenGLExtension_EXT_vertex_shader::glIsVariantEnabledEXT(GLuint id, GLenum cap)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    return d->IsVariantEnabledEXT(id, cap);
}

inline GLuint QOpenGLExtension_EXT_vertex_shader::glBindParameterEXT(GLenum value)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    return d->BindParameterEXT(value);
}

inline GLuint QOpenGLExtension_EXT_vertex_shader::glBindTextureUnitParameterEXT(GLenum unit, GLenum value)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    return d->BindTextureUnitParameterEXT(unit, value);
}

inline GLuint QOpenGLExtension_EXT_vertex_shader::glBindTexGenParameterEXT(GLenum unit, GLenum coord, GLenum value)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    return d->BindTexGenParameterEXT(unit, coord, value);
}

inline GLuint QOpenGLExtension_EXT_vertex_shader::glBindMaterialParameterEXT(GLenum face, GLenum value)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    return d->BindMaterialParameterEXT(face, value);
}

inline GLuint QOpenGLExtension_EXT_vertex_shader::glBindLightParameterEXT(GLenum light, GLenum value)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    return d->BindLightParameterEXT(light, value);
}

inline void QOpenGLExtension_EXT_vertex_shader::glDisableVariantClientStateEXT(GLuint id)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->DisableVariantClientStateEXT(id);
}

inline void QOpenGLExtension_EXT_vertex_shader::glEnableVariantClientStateEXT(GLuint id)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->EnableVariantClientStateEXT(id);
}

inline void QOpenGLExtension_EXT_vertex_shader::glVariantPointerEXT(GLuint id, GLenum type, GLuint stride, const GLvoid *addr)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->VariantPointerEXT(id, type, stride, addr);
}

inline void QOpenGLExtension_EXT_vertex_shader::glVariantuivEXT(GLuint id, const GLuint *addr)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->VariantuivEXT(id, addr);
}

inline void QOpenGLExtension_EXT_vertex_shader::glVariantusvEXT(GLuint id, const GLushort *addr)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->VariantusvEXT(id, addr);
}

inline void QOpenGLExtension_EXT_vertex_shader::glVariantubvEXT(GLuint id, const GLubyte *addr)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->VariantubvEXT(id, addr);
}

inline void QOpenGLExtension_EXT_vertex_shader::glVariantdvEXT(GLuint id, const GLdouble *addr)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->VariantdvEXT(id, addr);
}

inline void QOpenGLExtension_EXT_vertex_shader::glVariantfvEXT(GLuint id, const GLfloat *addr)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->VariantfvEXT(id, addr);
}

inline void QOpenGLExtension_EXT_vertex_shader::glVariantivEXT(GLuint id, const GLint *addr)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->VariantivEXT(id, addr);
}

inline void QOpenGLExtension_EXT_vertex_shader::glVariantsvEXT(GLuint id, const GLshort *addr)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->VariantsvEXT(id, addr);
}

inline void QOpenGLExtension_EXT_vertex_shader::glVariantbvEXT(GLuint id, const GLbyte *addr)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->VariantbvEXT(id, addr);
}

inline void QOpenGLExtension_EXT_vertex_shader::glSetLocalConstantEXT(GLuint id, GLenum type, const GLvoid *addr)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->SetLocalConstantEXT(id, type, addr);
}

inline void QOpenGLExtension_EXT_vertex_shader::glSetInvariantEXT(GLuint id, GLenum type, const GLvoid *addr)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->SetInvariantEXT(id, type, addr);
}

inline GLuint QOpenGLExtension_EXT_vertex_shader::glGenSymbolsEXT(GLenum datatype, GLenum storagetype, GLenum range, GLuint components)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    return d->GenSymbolsEXT(datatype, storagetype, range, components);
}

inline void QOpenGLExtension_EXT_vertex_shader::glExtractComponentEXT(GLuint res, GLuint src, GLuint num)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->ExtractComponentEXT(res, src, num);
}

inline void QOpenGLExtension_EXT_vertex_shader::glInsertComponentEXT(GLuint res, GLuint src, GLuint num)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->InsertComponentEXT(res, src, num);
}

inline void QOpenGLExtension_EXT_vertex_shader::glWriteMaskEXT(GLuint res, GLuint in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->WriteMaskEXT(res, in, outX, outY, outZ, outW);
}

inline void QOpenGLExtension_EXT_vertex_shader::glSwizzleEXT(GLuint res, GLuint in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->SwizzleEXT(res, in, outX, outY, outZ, outW);
}

inline void QOpenGLExtension_EXT_vertex_shader::glShaderOp3EXT(GLenum op, GLuint res, GLuint arg1, GLuint arg2, GLuint arg3)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->ShaderOp3EXT(op, res, arg1, arg2, arg3);
}

inline void QOpenGLExtension_EXT_vertex_shader::glShaderOp2EXT(GLenum op, GLuint res, GLuint arg1, GLuint arg2)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->ShaderOp2EXT(op, res, arg1, arg2);
}

inline void QOpenGLExtension_EXT_vertex_shader::glShaderOp1EXT(GLenum op, GLuint res, GLuint arg1)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->ShaderOp1EXT(op, res, arg1);
}

inline void QOpenGLExtension_EXT_vertex_shader::glDeleteVertexShaderEXT(GLuint id)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->DeleteVertexShaderEXT(id);
}

inline GLuint QOpenGLExtension_EXT_vertex_shader::glGenVertexShadersEXT(GLuint range)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    return d->GenVertexShadersEXT(range);
}

inline void QOpenGLExtension_EXT_vertex_shader::glBindVertexShaderEXT(GLuint id)
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->BindVertexShaderEXT(id);
}

inline void QOpenGLExtension_EXT_vertex_shader::glEndVertexShaderEXT()
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->EndVertexShaderEXT();
}

inline void QOpenGLExtension_EXT_vertex_shader::glBeginVertexShaderEXT()
{
    Q_D(QOpenGLExtension_EXT_vertex_shader);
    d->BeginVertexShaderEXT();
}

class QOpenGLExtension_EXT_vertex_weightingPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP VertexWeightPointerEXT)(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
    void (QOPENGLF_APIENTRYP VertexWeightfvEXT)(const GLfloat *weight);
    void (QOPENGLF_APIENTRYP VertexWeightfEXT)(GLfloat weight);
};

class QOpenGLExtension_EXT_vertex_weighting : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_vertex_weighting();

    bool initializeOpenGLFunctions() final;

    void glVertexWeightPointerEXT(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
    void glVertexWeightfvEXT(const GLfloat *weight);
    void glVertexWeightfEXT(GLfloat weight);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_vertex_weighting)
};

inline void QOpenGLExtension_EXT_vertex_weighting::glVertexWeightPointerEXT(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
    Q_D(QOpenGLExtension_EXT_vertex_weighting);
    d->VertexWeightPointerEXT(size, type, stride, pointer);
}

inline void QOpenGLExtension_EXT_vertex_weighting::glVertexWeightfvEXT(const GLfloat *weight)
{
    Q_D(QOpenGLExtension_EXT_vertex_weighting);
    d->VertexWeightfvEXT(weight);
}

inline void QOpenGLExtension_EXT_vertex_weighting::glVertexWeightfEXT(GLfloat weight)
{
    Q_D(QOpenGLExtension_EXT_vertex_weighting);
    d->VertexWeightfEXT(weight);
}

class QOpenGLExtension_EXT_x11_sync_objectPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    GLsync (QOPENGLF_APIENTRYP ImportSyncEXT)(GLenum external_sync_type, GLintptr external_sync, GLbitfield flags);
};

class QOpenGLExtension_EXT_x11_sync_object : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_x11_sync_object();

    bool initializeOpenGLFunctions() final;

    GLsync glImportSyncEXT(GLenum external_sync_type, GLintptr external_sync, GLbitfield flags);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_x11_sync_object)
};

inline GLsync QOpenGLExtension_EXT_x11_sync_object::glImportSyncEXT(GLenum external_sync_type, GLintptr external_sync, GLbitfield flags)
{
    Q_D(QOpenGLExtension_EXT_x11_sync_object);
    return d->ImportSyncEXT(external_sync_type, external_sync, flags);
}

class QOpenGLExtension_GREMEDY_frame_terminatorPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP FrameTerminatorGREMEDY)();
};

class QOpenGLExtension_GREMEDY_frame_terminator : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_GREMEDY_frame_terminator();

    bool initializeOpenGLFunctions() final;

    void glFrameTerminatorGREMEDY();

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_GREMEDY_frame_terminator)
};

inline void QOpenGLExtension_GREMEDY_frame_terminator::glFrameTerminatorGREMEDY()
{
    Q_D(QOpenGLExtension_GREMEDY_frame_terminator);
    d->FrameTerminatorGREMEDY();
}

class QOpenGLExtension_GREMEDY_string_markerPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP StringMarkerGREMEDY)(GLsizei len, const GLvoid *string);
};

class QOpenGLExtension_GREMEDY_string_marker : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_GREMEDY_string_marker();

    bool initializeOpenGLFunctions() final;

    void glStringMarkerGREMEDY(GLsizei len, const GLvoid *string);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_GREMEDY_string_marker)
};

inline void QOpenGLExtension_GREMEDY_string_marker::glStringMarkerGREMEDY(GLsizei len, const GLvoid *string)
{
    Q_D(QOpenGLExtension_GREMEDY_string_marker);
    d->StringMarkerGREMEDY(len, string);
}

class QOpenGLExtension_HP_image_transformPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetImageTransformParameterfvHP)(GLenum target, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP GetImageTransformParameterivHP)(GLenum target, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP ImageTransformParameterfvHP)(GLenum target, GLenum pname, const GLfloat *params);
    void (QOPENGLF_APIENTRYP ImageTransformParameterivHP)(GLenum target, GLenum pname, const GLint *params);
    void (QOPENGLF_APIENTRYP ImageTransformParameterfHP)(GLenum target, GLenum pname, GLfloat param);
    void (QOPENGLF_APIENTRYP ImageTransformParameteriHP)(GLenum target, GLenum pname, GLint param);
};

class QOpenGLExtension_HP_image_transform : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_HP_image_transform();

    bool initializeOpenGLFunctions() final;

    void glGetImageTransformParameterfvHP(GLenum target, GLenum pname, GLfloat *params);
    void glGetImageTransformParameterivHP(GLenum target, GLenum pname, GLint *params);
    void glImageTransformParameterfvHP(GLenum target, GLenum pname, const GLfloat *params);
    void glImageTransformParameterivHP(GLenum target, GLenum pname, const GLint *params);
    void glImageTransformParameterfHP(GLenum target, GLenum pname, GLfloat param);
    void glImageTransformParameteriHP(GLenum target, GLenum pname, GLint param);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_HP_image_transform)
};

inline void QOpenGLExtension_HP_image_transform::glGetImageTransformParameterfvHP(GLenum target, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_HP_image_transform);
    d->GetImageTransformParameterfvHP(target, pname, params);
}

inline void QOpenGLExtension_HP_image_transform::glGetImageTransformParameterivHP(GLenum target, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_HP_image_transform);
    d->GetImageTransformParameterivHP(target, pname, params);
}

inline void QOpenGLExtension_HP_image_transform::glImageTransformParameterfvHP(GLenum target, GLenum pname, const GLfloat *params)
{
    Q_D(QOpenGLExtension_HP_image_transform);
    d->ImageTransformParameterfvHP(target, pname, params);
}

inline void QOpenGLExtension_HP_image_transform::glImageTransformParameterivHP(GLenum target, GLenum pname, const GLint *params)
{
    Q_D(QOpenGLExtension_HP_image_transform);
    d->ImageTransformParameterivHP(target, pname, params);
}

inline void QOpenGLExtension_HP_image_transform::glImageTransformParameterfHP(GLenum target, GLenum pname, GLfloat param)
{
    Q_D(QOpenGLExtension_HP_image_transform);
    d->ImageTransformParameterfHP(target, pname, param);
}

inline void QOpenGLExtension_HP_image_transform::glImageTransformParameteriHP(GLenum target, GLenum pname, GLint param)
{
    Q_D(QOpenGLExtension_HP_image_transform);
    d->ImageTransformParameteriHP(target, pname, param);
}

class QOpenGLExtension_IBM_multimode_draw_arraysPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP MultiModeDrawElementsIBM)(const GLenum *mode, const GLsizei *count, GLenum type, const GLvoid* const *indices, GLsizei primcount, GLint modestride);
    void (QOPENGLF_APIENTRYP MultiModeDrawArraysIBM)(const GLenum *mode, const GLint *first, const GLsizei *count, GLsizei primcount, GLint modestride);
};

class QOpenGLExtension_IBM_multimode_draw_arrays : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_IBM_multimode_draw_arrays();

    bool initializeOpenGLFunctions() final;

    void glMultiModeDrawElementsIBM(const GLenum *mode, const GLsizei *count, GLenum type, const GLvoid* const *indices, GLsizei primcount, GLint modestride);
    void glMultiModeDrawArraysIBM(const GLenum *mode, const GLint *first, const GLsizei *count, GLsizei primcount, GLint modestride);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_IBM_multimode_draw_arrays)
};

inline void QOpenGLExtension_IBM_multimode_draw_arrays::glMultiModeDrawElementsIBM(const GLenum *mode, const GLsizei *count, GLenum type, const GLvoid* const *indices, GLsizei primcount, GLint modestride)
{
    Q_D(QOpenGLExtension_IBM_multimode_draw_arrays);
    d->MultiModeDrawElementsIBM(mode, count, type, indices, primcount, modestride);
}

inline void QOpenGLExtension_IBM_multimode_draw_arrays::glMultiModeDrawArraysIBM(const GLenum *mode, const GLint *first, const GLsizei *count, GLsizei primcount, GLint modestride)
{
    Q_D(QOpenGLExtension_IBM_multimode_draw_arrays);
    d->MultiModeDrawArraysIBM(mode, first, count, primcount, modestride);
}

class QOpenGLExtension_IBM_vertex_array_listsPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP VertexPointerListIBM)(GLint size, GLenum type, GLint stride, const GLvoid* *pointer, GLint ptrstride);
    void (QOPENGLF_APIENTRYP TexCoordPointerListIBM)(GLint size, GLenum type, GLint stride, const GLvoid* *pointer, GLint ptrstride);
    void (QOPENGLF_APIENTRYP NormalPointerListIBM)(GLenum type, GLint stride, const GLvoid* *pointer, GLint ptrstride);
    void (QOPENGLF_APIENTRYP IndexPointerListIBM)(GLenum type, GLint stride, const GLvoid* *pointer, GLint ptrstride);
    void (QOPENGLF_APIENTRYP FogCoordPointerListIBM)(GLenum type, GLint stride, const GLvoid* *pointer, GLint ptrstride);
    void (QOPENGLF_APIENTRYP EdgeFlagPointerListIBM)(GLint stride, const GLboolean* *pointer, GLint ptrstride);
    void (QOPENGLF_APIENTRYP SecondaryColorPointerListIBM)(GLint size, GLenum type, GLint stride, const GLvoid* *pointer, GLint ptrstride);
    void (QOPENGLF_APIENTRYP ColorPointerListIBM)(GLint size, GLenum type, GLint stride, const GLvoid* *pointer, GLint ptrstride);
};

class QOpenGLExtension_IBM_vertex_array_lists : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_IBM_vertex_array_lists();

    bool initializeOpenGLFunctions() final;

    void glVertexPointerListIBM(GLint size, GLenum type, GLint stride, const GLvoid* *pointer, GLint ptrstride);
    void glTexCoordPointerListIBM(GLint size, GLenum type, GLint stride, const GLvoid* *pointer, GLint ptrstride);
    void glNormalPointerListIBM(GLenum type, GLint stride, const GLvoid* *pointer, GLint ptrstride);
    void glIndexPointerListIBM(GLenum type, GLint stride, const GLvoid* *pointer, GLint ptrstride);
    void glFogCoordPointerListIBM(GLenum type, GLint stride, const GLvoid* *pointer, GLint ptrstride);
    void glEdgeFlagPointerListIBM(GLint stride, const GLboolean* *pointer, GLint ptrstride);
    void glSecondaryColorPointerListIBM(GLint size, GLenum type, GLint stride, const GLvoid* *pointer, GLint ptrstride);
    void glColorPointerListIBM(GLint size, GLenum type, GLint stride, const GLvoid* *pointer, GLint ptrstride);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_IBM_vertex_array_lists)
};

inline void QOpenGLExtension_IBM_vertex_array_lists::glVertexPointerListIBM(GLint size, GLenum type, GLint stride, const GLvoid* *pointer, GLint ptrstride)
{
    Q_D(QOpenGLExtension_IBM_vertex_array_lists);
    d->VertexPointerListIBM(size, type, stride, pointer, ptrstride);
}

inline void QOpenGLExtension_IBM_vertex_array_lists::glTexCoordPointerListIBM(GLint size, GLenum type, GLint stride, const GLvoid* *pointer, GLint ptrstride)
{
    Q_D(QOpenGLExtension_IBM_vertex_array_lists);
    d->TexCoordPointerListIBM(size, type, stride, pointer, ptrstride);
}

inline void QOpenGLExtension_IBM_vertex_array_lists::glNormalPointerListIBM(GLenum type, GLint stride, const GLvoid* *pointer, GLint ptrstride)
{
    Q_D(QOpenGLExtension_IBM_vertex_array_lists);
    d->NormalPointerListIBM(type, stride, pointer, ptrstride);
}

inline void QOpenGLExtension_IBM_vertex_array_lists::glIndexPointerListIBM(GLenum type, GLint stride, const GLvoid* *pointer, GLint ptrstride)
{
    Q_D(QOpenGLExtension_IBM_vertex_array_lists);
    d->IndexPointerListIBM(type, stride, pointer, ptrstride);
}

inline void QOpenGLExtension_IBM_vertex_array_lists::glFogCoordPointerListIBM(GLenum type, GLint stride, const GLvoid* *pointer, GLint ptrstride)
{
    Q_D(QOpenGLExtension_IBM_vertex_array_lists);
    d->FogCoordPointerListIBM(type, stride, pointer, ptrstride);
}

inline void QOpenGLExtension_IBM_vertex_array_lists::glEdgeFlagPointerListIBM(GLint stride, const GLboolean* *pointer, GLint ptrstride)
{
    Q_D(QOpenGLExtension_IBM_vertex_array_lists);
    d->EdgeFlagPointerListIBM(stride, pointer, ptrstride);
}

inline void QOpenGLExtension_IBM_vertex_array_lists::glSecondaryColorPointerListIBM(GLint size, GLenum type, GLint stride, const GLvoid* *pointer, GLint ptrstride)
{
    Q_D(QOpenGLExtension_IBM_vertex_array_lists);
    d->SecondaryColorPointerListIBM(size, type, stride, pointer, ptrstride);
}

inline void QOpenGLExtension_IBM_vertex_array_lists::glColorPointerListIBM(GLint size, GLenum type, GLint stride, const GLvoid* *pointer, GLint ptrstride)
{
    Q_D(QOpenGLExtension_IBM_vertex_array_lists);
    d->ColorPointerListIBM(size, type, stride, pointer, ptrstride);
}

class QOpenGLExtension_INGR_blend_func_separatePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP BlendFuncSeparateINGR)(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha);
};

class QOpenGLExtension_INGR_blend_func_separate : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_INGR_blend_func_separate();

    bool initializeOpenGLFunctions() final;

    void glBlendFuncSeparateINGR(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_INGR_blend_func_separate)
};

inline void QOpenGLExtension_INGR_blend_func_separate::glBlendFuncSeparateINGR(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha)
{
    Q_D(QOpenGLExtension_INGR_blend_func_separate);
    d->BlendFuncSeparateINGR(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
}

class QOpenGLExtension_INTEL_parallel_arraysPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP TexCoordPointervINTEL)(GLint size, GLenum type, const GLvoid* *pointer);
    void (QOPENGLF_APIENTRYP ColorPointervINTEL)(GLint size, GLenum type, const GLvoid* *pointer);
    void (QOPENGLF_APIENTRYP NormalPointervINTEL)(GLenum type, const GLvoid* *pointer);
    void (QOPENGLF_APIENTRYP VertexPointervINTEL)(GLint size, GLenum type, const GLvoid* *pointer);
};

class QOpenGLExtension_INTEL_parallel_arrays : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_INTEL_parallel_arrays();

    bool initializeOpenGLFunctions() final;

    void glTexCoordPointervINTEL(GLint size, GLenum type, const GLvoid* *pointer);
    void glColorPointervINTEL(GLint size, GLenum type, const GLvoid* *pointer);
    void glNormalPointervINTEL(GLenum type, const GLvoid* *pointer);
    void glVertexPointervINTEL(GLint size, GLenum type, const GLvoid* *pointer);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_INTEL_parallel_arrays)
};

inline void QOpenGLExtension_INTEL_parallel_arrays::glTexCoordPointervINTEL(GLint size, GLenum type, const GLvoid* *pointer)
{
    Q_D(QOpenGLExtension_INTEL_parallel_arrays);
    d->TexCoordPointervINTEL(size, type, pointer);
}

inline void QOpenGLExtension_INTEL_parallel_arrays::glColorPointervINTEL(GLint size, GLenum type, const GLvoid* *pointer)
{
    Q_D(QOpenGLExtension_INTEL_parallel_arrays);
    d->ColorPointervINTEL(size, type, pointer);
}

inline void QOpenGLExtension_INTEL_parallel_arrays::glNormalPointervINTEL(GLenum type, const GLvoid* *pointer)
{
    Q_D(QOpenGLExtension_INTEL_parallel_arrays);
    d->NormalPointervINTEL(type, pointer);
}

inline void QOpenGLExtension_INTEL_parallel_arrays::glVertexPointervINTEL(GLint size, GLenum type, const GLvoid* *pointer)
{
    Q_D(QOpenGLExtension_INTEL_parallel_arrays);
    d->VertexPointervINTEL(size, type, pointer);
}

class QOpenGLExtension_KHR_debugPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetObjectPtrLabel)(const void *ptr, GLsizei bufSize, GLsizei *length, GLchar *label);
    void (QOPENGLF_APIENTRYP ObjectPtrLabel)(const void *ptr, GLsizei length, const GLchar *label);
    void (QOPENGLF_APIENTRYP GetObjectLabel)(GLenum identifier, GLuint name, GLsizei bufSize, GLsizei *length, GLchar *label);
    void (QOPENGLF_APIENTRYP ObjectLabel)(GLenum identifier, GLuint name, GLsizei length, const GLchar *label);
    void (QOPENGLF_APIENTRYP PopDebugGroup)();
    void (QOPENGLF_APIENTRYP PushDebugGroup)(GLenum source, GLuint id, GLsizei length, const GLchar *message);
    GLuint (QOPENGLF_APIENTRYP GetDebugMessageLog)(GLuint count, GLsizei bufsize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog);
    void (QOPENGLF_APIENTRYP DebugMessageCallback)(GLDEBUGPROC callback, const void *userParam);
    void (QOPENGLF_APIENTRYP DebugMessageInsert)(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *buf);
    void (QOPENGLF_APIENTRYP DebugMessageControl)(GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled);
};

class QOpenGLExtension_KHR_debug : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_KHR_debug();

    bool initializeOpenGLFunctions() final;

    void glGetObjectPtrLabel(const void *ptr, GLsizei bufSize, GLsizei *length, GLchar *label);
    void glObjectPtrLabel(const void *ptr, GLsizei length, const GLchar *label);
    void glGetObjectLabel(GLenum identifier, GLuint name, GLsizei bufSize, GLsizei *length, GLchar *label);
    void glObjectLabel(GLenum identifier, GLuint name, GLsizei length, const GLchar *label);
    void glPopDebugGroup();
    void glPushDebugGroup(GLenum source, GLuint id, GLsizei length, const GLchar *message);
    GLuint glGetDebugMessageLog(GLuint count, GLsizei bufsize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog);
    void glDebugMessageCallback(GLDEBUGPROC callback, const void *userParam);
    void glDebugMessageInsert(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *buf);
    void glDebugMessageControl(GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_KHR_debug)
};

inline void QOpenGLExtension_KHR_debug::glGetObjectPtrLabel(const void *ptr, GLsizei bufSize, GLsizei *length, GLchar *label)
{
    Q_D(QOpenGLExtension_KHR_debug);
    d->GetObjectPtrLabel(ptr, bufSize, length, label);
}

inline void QOpenGLExtension_KHR_debug::glObjectPtrLabel(const void *ptr, GLsizei length, const GLchar *label)
{
    Q_D(QOpenGLExtension_KHR_debug);
    d->ObjectPtrLabel(ptr, length, label);
}

inline void QOpenGLExtension_KHR_debug::glGetObjectLabel(GLenum identifier, GLuint name, GLsizei bufSize, GLsizei *length, GLchar *label)
{
    Q_D(QOpenGLExtension_KHR_debug);
    d->GetObjectLabel(identifier, name, bufSize, length, label);
}

inline void QOpenGLExtension_KHR_debug::glObjectLabel(GLenum identifier, GLuint name, GLsizei length, const GLchar *label)
{
    Q_D(QOpenGLExtension_KHR_debug);
    d->ObjectLabel(identifier, name, length, label);
}

inline void QOpenGLExtension_KHR_debug::glPopDebugGroup()
{
    Q_D(QOpenGLExtension_KHR_debug);
    d->PopDebugGroup();
}

inline void QOpenGLExtension_KHR_debug::glPushDebugGroup(GLenum source, GLuint id, GLsizei length, const GLchar *message)
{
    Q_D(QOpenGLExtension_KHR_debug);
    d->PushDebugGroup(source, id, length, message);
}

inline GLuint QOpenGLExtension_KHR_debug::glGetDebugMessageLog(GLuint count, GLsizei bufsize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog)
{
    Q_D(QOpenGLExtension_KHR_debug);
    return d->GetDebugMessageLog(count, bufsize, sources, types, ids, severities, lengths, messageLog);
}

inline void QOpenGLExtension_KHR_debug::glDebugMessageCallback(GLDEBUGPROC callback, const void *userParam)
{
    Q_D(QOpenGLExtension_KHR_debug);
    d->DebugMessageCallback(callback, userParam);
}

inline void QOpenGLExtension_KHR_debug::glDebugMessageInsert(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *buf)
{
    Q_D(QOpenGLExtension_KHR_debug);
    d->DebugMessageInsert(source, type, id, severity, length, buf);
}

inline void QOpenGLExtension_KHR_debug::glDebugMessageControl(GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled)
{
    Q_D(QOpenGLExtension_KHR_debug);
    d->DebugMessageControl(source, type, severity, count, ids, enabled);
}

class QOpenGLExtension_MESA_resize_buffersPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP ResizeBuffersMESA)();
};

class QOpenGLExtension_MESA_resize_buffers : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_MESA_resize_buffers();

    bool initializeOpenGLFunctions() final;

    void glResizeBuffersMESA();

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_MESA_resize_buffers)
};

inline void QOpenGLExtension_MESA_resize_buffers::glResizeBuffersMESA()
{
    Q_D(QOpenGLExtension_MESA_resize_buffers);
    d->ResizeBuffersMESA();
}

class QOpenGLExtension_MESA_window_posPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP WindowPos4svMESA)(const GLshort *v);
    void (QOPENGLF_APIENTRYP WindowPos4sMESA)(GLshort x, GLshort y, GLshort z, GLshort w);
    void (QOPENGLF_APIENTRYP WindowPos4ivMESA)(const GLint *v);
    void (QOPENGLF_APIENTRYP WindowPos4iMESA)(GLint x, GLint y, GLint z, GLint w);
    void (QOPENGLF_APIENTRYP WindowPos4fvMESA)(const GLfloat *v);
    void (QOPENGLF_APIENTRYP WindowPos4fMESA)(GLfloat x, GLfloat y, GLfloat z, GLfloat w);
    void (QOPENGLF_APIENTRYP WindowPos4dvMESA)(const GLdouble *v);
    void (QOPENGLF_APIENTRYP WindowPos4dMESA)(GLdouble x, GLdouble y, GLdouble z, GLdouble w);
    void (QOPENGLF_APIENTRYP WindowPos3svMESA)(const GLshort *v);
    void (QOPENGLF_APIENTRYP WindowPos3sMESA)(GLshort x, GLshort y, GLshort z);
    void (QOPENGLF_APIENTRYP WindowPos3ivMESA)(const GLint *v);
    void (QOPENGLF_APIENTRYP WindowPos3iMESA)(GLint x, GLint y, GLint z);
    void (QOPENGLF_APIENTRYP WindowPos3fvMESA)(const GLfloat *v);
    void (QOPENGLF_APIENTRYP WindowPos3fMESA)(GLfloat x, GLfloat y, GLfloat z);
    void (QOPENGLF_APIENTRYP WindowPos3dvMESA)(const GLdouble *v);
    void (QOPENGLF_APIENTRYP WindowPos3dMESA)(GLdouble x, GLdouble y, GLdouble z);
    void (QOPENGLF_APIENTRYP WindowPos2svMESA)(const GLshort *v);
    void (QOPENGLF_APIENTRYP WindowPos2sMESA)(GLshort x, GLshort y);
    void (QOPENGLF_APIENTRYP WindowPos2ivMESA)(const GLint *v);
    void (QOPENGLF_APIENTRYP WindowPos2iMESA)(GLint x, GLint y);
    void (QOPENGLF_APIENTRYP WindowPos2fvMESA)(const GLfloat *v);
    void (QOPENGLF_APIENTRYP WindowPos2fMESA)(GLfloat x, GLfloat y);
    void (QOPENGLF_APIENTRYP WindowPos2dvMESA)(const GLdouble *v);
    void (QOPENGLF_APIENTRYP WindowPos2dMESA)(GLdouble x, GLdouble y);
};

class QOpenGLExtension_MESA_window_pos : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_MESA_window_pos();

    bool initializeOpenGLFunctions() final;

    void glWindowPos4svMESA(const GLshort *v);
    void glWindowPos4sMESA(GLshort x, GLshort y, GLshort z, GLshort w);
    void glWindowPos4ivMESA(const GLint *v);
    void glWindowPos4iMESA(GLint x, GLint y, GLint z, GLint w);
    void glWindowPos4fvMESA(const GLfloat *v);
    void glWindowPos4fMESA(GLfloat x, GLfloat y, GLfloat z, GLfloat w);
    void glWindowPos4dvMESA(const GLdouble *v);
    void glWindowPos4dMESA(GLdouble x, GLdouble y, GLdouble z, GLdouble w);
    void glWindowPos3svMESA(const GLshort *v);
    void glWindowPos3sMESA(GLshort x, GLshort y, GLshort z);
    void glWindowPos3ivMESA(const GLint *v);
    void glWindowPos3iMESA(GLint x, GLint y, GLint z);
    void glWindowPos3fvMESA(const GLfloat *v);
    void glWindowPos3fMESA(GLfloat x, GLfloat y, GLfloat z);
    void glWindowPos3dvMESA(const GLdouble *v);
    void glWindowPos3dMESA(GLdouble x, GLdouble y, GLdouble z);
    void glWindowPos2svMESA(const GLshort *v);
    void glWindowPos2sMESA(GLshort x, GLshort y);
    void glWindowPos2ivMESA(const GLint *v);
    void glWindowPos2iMESA(GLint x, GLint y);
    void glWindowPos2fvMESA(const GLfloat *v);
    void glWindowPos2fMESA(GLfloat x, GLfloat y);
    void glWindowPos2dvMESA(const GLdouble *v);
    void glWindowPos2dMESA(GLdouble x, GLdouble y);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_MESA_window_pos)
};

inline void QOpenGLExtension_MESA_window_pos::glWindowPos4svMESA(const GLshort *v)
{
    Q_D(QOpenGLExtension_MESA_window_pos);
    d->WindowPos4svMESA(v);
}

inline void QOpenGLExtension_MESA_window_pos::glWindowPos4sMESA(GLshort x, GLshort y, GLshort z, GLshort w)
{
    Q_D(QOpenGLExtension_MESA_window_pos);
    d->WindowPos4sMESA(x, y, z, w);
}

inline void QOpenGLExtension_MESA_window_pos::glWindowPos4ivMESA(const GLint *v)
{
    Q_D(QOpenGLExtension_MESA_window_pos);
    d->WindowPos4ivMESA(v);
}

inline void QOpenGLExtension_MESA_window_pos::glWindowPos4iMESA(GLint x, GLint y, GLint z, GLint w)
{
    Q_D(QOpenGLExtension_MESA_window_pos);
    d->WindowPos4iMESA(x, y, z, w);
}

inline void QOpenGLExtension_MESA_window_pos::glWindowPos4fvMESA(const GLfloat *v)
{
    Q_D(QOpenGLExtension_MESA_window_pos);
    d->WindowPos4fvMESA(v);
}

inline void QOpenGLExtension_MESA_window_pos::glWindowPos4fMESA(GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
    Q_D(QOpenGLExtension_MESA_window_pos);
    d->WindowPos4fMESA(x, y, z, w);
}

inline void QOpenGLExtension_MESA_window_pos::glWindowPos4dvMESA(const GLdouble *v)
{
    Q_D(QOpenGLExtension_MESA_window_pos);
    d->WindowPos4dvMESA(v);
}

inline void QOpenGLExtension_MESA_window_pos::glWindowPos4dMESA(GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    Q_D(QOpenGLExtension_MESA_window_pos);
    d->WindowPos4dMESA(x, y, z, w);
}

inline void QOpenGLExtension_MESA_window_pos::glWindowPos3svMESA(const GLshort *v)
{
    Q_D(QOpenGLExtension_MESA_window_pos);
    d->WindowPos3svMESA(v);
}

inline void QOpenGLExtension_MESA_window_pos::glWindowPos3sMESA(GLshort x, GLshort y, GLshort z)
{
    Q_D(QOpenGLExtension_MESA_window_pos);
    d->WindowPos3sMESA(x, y, z);
}

inline void QOpenGLExtension_MESA_window_pos::glWindowPos3ivMESA(const GLint *v)
{
    Q_D(QOpenGLExtension_MESA_window_pos);
    d->WindowPos3ivMESA(v);
}

inline void QOpenGLExtension_MESA_window_pos::glWindowPos3iMESA(GLint x, GLint y, GLint z)
{
    Q_D(QOpenGLExtension_MESA_window_pos);
    d->WindowPos3iMESA(x, y, z);
}

inline void QOpenGLExtension_MESA_window_pos::glWindowPos3fvMESA(const GLfloat *v)
{
    Q_D(QOpenGLExtension_MESA_window_pos);
    d->WindowPos3fvMESA(v);
}

inline void QOpenGLExtension_MESA_window_pos::glWindowPos3fMESA(GLfloat x, GLfloat y, GLfloat z)
{
    Q_D(QOpenGLExtension_MESA_window_pos);
    d->WindowPos3fMESA(x, y, z);
}

inline void QOpenGLExtension_MESA_window_pos::glWindowPos3dvMESA(const GLdouble *v)
{
    Q_D(QOpenGLExtension_MESA_window_pos);
    d->WindowPos3dvMESA(v);
}

inline void QOpenGLExtension_MESA_window_pos::glWindowPos3dMESA(GLdouble x, GLdouble y, GLdouble z)
{
    Q_D(QOpenGLExtension_MESA_window_pos);
    d->WindowPos3dMESA(x, y, z);
}

inline void QOpenGLExtension_MESA_window_pos::glWindowPos2svMESA(const GLshort *v)
{
    Q_D(QOpenGLExtension_MESA_window_pos);
    d->WindowPos2svMESA(v);
}

inline void QOpenGLExtension_MESA_window_pos::glWindowPos2sMESA(GLshort x, GLshort y)
{
    Q_D(QOpenGLExtension_MESA_window_pos);
    d->WindowPos2sMESA(x, y);
}

inline void QOpenGLExtension_MESA_window_pos::glWindowPos2ivMESA(const GLint *v)
{
    Q_D(QOpenGLExtension_MESA_window_pos);
    d->WindowPos2ivMESA(v);
}

inline void QOpenGLExtension_MESA_window_pos::glWindowPos2iMESA(GLint x, GLint y)
{
    Q_D(QOpenGLExtension_MESA_window_pos);
    d->WindowPos2iMESA(x, y);
}

inline void QOpenGLExtension_MESA_window_pos::glWindowPos2fvMESA(const GLfloat *v)
{
    Q_D(QOpenGLExtension_MESA_window_pos);
    d->WindowPos2fvMESA(v);
}

inline void QOpenGLExtension_MESA_window_pos::glWindowPos2fMESA(GLfloat x, GLfloat y)
{
    Q_D(QOpenGLExtension_MESA_window_pos);
    d->WindowPos2fMESA(x, y);
}

inline void QOpenGLExtension_MESA_window_pos::glWindowPos2dvMESA(const GLdouble *v)
{
    Q_D(QOpenGLExtension_MESA_window_pos);
    d->WindowPos2dvMESA(v);
}

inline void QOpenGLExtension_MESA_window_pos::glWindowPos2dMESA(GLdouble x, GLdouble y)
{
    Q_D(QOpenGLExtension_MESA_window_pos);
    d->WindowPos2dMESA(x, y);
}

class QOpenGLExtension_NV_bindless_texturePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    GLboolean (QOPENGLF_APIENTRYP IsImageHandleResidentNV)(GLuint64 handle);
    GLboolean (QOPENGLF_APIENTRYP IsTextureHandleResidentNV)(GLuint64 handle);
    void (QOPENGLF_APIENTRYP ProgramUniformHandleui64vNV)(GLuint program, GLint location, GLsizei count, const GLuint64 *values);
    void (QOPENGLF_APIENTRYP ProgramUniformHandleui64NV)(GLuint program, GLint location, GLuint64 value);
    void (QOPENGLF_APIENTRYP UniformHandleui64vNV)(GLint location, GLsizei count, const GLuint64 *value);
    void (QOPENGLF_APIENTRYP UniformHandleui64NV)(GLint location, GLuint64 value);
    void (QOPENGLF_APIENTRYP MakeImageHandleNonResidentNV)(GLuint64 handle);
    void (QOPENGLF_APIENTRYP MakeImageHandleResidentNV)(GLuint64 handle, GLenum access);
    GLuint64 (QOPENGLF_APIENTRYP GetImageHandleNV)(GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum format);
    void (QOPENGLF_APIENTRYP MakeTextureHandleNonResidentNV)(GLuint64 handle);
    void (QOPENGLF_APIENTRYP MakeTextureHandleResidentNV)(GLuint64 handle);
    GLuint64 (QOPENGLF_APIENTRYP GetTextureSamplerHandleNV)(GLuint texture, GLuint sampler);
    GLuint64 (QOPENGLF_APIENTRYP GetTextureHandleNV)(GLuint texture);
};

class QOpenGLExtension_NV_bindless_texture : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_bindless_texture();

    bool initializeOpenGLFunctions() final;

    GLboolean glIsImageHandleResidentNV(GLuint64 handle);
    GLboolean glIsTextureHandleResidentNV(GLuint64 handle);
    void glProgramUniformHandleui64vNV(GLuint program, GLint location, GLsizei count, const GLuint64 *values);
    void glProgramUniformHandleui64NV(GLuint program, GLint location, GLuint64 value);
    void glUniformHandleui64vNV(GLint location, GLsizei count, const GLuint64 *value);
    void glUniformHandleui64NV(GLint location, GLuint64 value);
    void glMakeImageHandleNonResidentNV(GLuint64 handle);
    void glMakeImageHandleResidentNV(GLuint64 handle, GLenum access);
    GLuint64 glGetImageHandleNV(GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum format);
    void glMakeTextureHandleNonResidentNV(GLuint64 handle);
    void glMakeTextureHandleResidentNV(GLuint64 handle);
    GLuint64 glGetTextureSamplerHandleNV(GLuint texture, GLuint sampler);
    GLuint64 glGetTextureHandleNV(GLuint texture);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_bindless_texture)
};

inline GLboolean QOpenGLExtension_NV_bindless_texture::glIsImageHandleResidentNV(GLuint64 handle)
{
    Q_D(QOpenGLExtension_NV_bindless_texture);
    return d->IsImageHandleResidentNV(handle);
}

inline GLboolean QOpenGLExtension_NV_bindless_texture::glIsTextureHandleResidentNV(GLuint64 handle)
{
    Q_D(QOpenGLExtension_NV_bindless_texture);
    return d->IsTextureHandleResidentNV(handle);
}

inline void QOpenGLExtension_NV_bindless_texture::glProgramUniformHandleui64vNV(GLuint program, GLint location, GLsizei count, const GLuint64 *values)
{
    Q_D(QOpenGLExtension_NV_bindless_texture);
    d->ProgramUniformHandleui64vNV(program, location, count, values);
}

inline void QOpenGLExtension_NV_bindless_texture::glProgramUniformHandleui64NV(GLuint program, GLint location, GLuint64 value)
{
    Q_D(QOpenGLExtension_NV_bindless_texture);
    d->ProgramUniformHandleui64NV(program, location, value);
}

inline void QOpenGLExtension_NV_bindless_texture::glUniformHandleui64vNV(GLint location, GLsizei count, const GLuint64 *value)
{
    Q_D(QOpenGLExtension_NV_bindless_texture);
    d->UniformHandleui64vNV(location, count, value);
}

inline void QOpenGLExtension_NV_bindless_texture::glUniformHandleui64NV(GLint location, GLuint64 value)
{
    Q_D(QOpenGLExtension_NV_bindless_texture);
    d->UniformHandleui64NV(location, value);
}

inline void QOpenGLExtension_NV_bindless_texture::glMakeImageHandleNonResidentNV(GLuint64 handle)
{
    Q_D(QOpenGLExtension_NV_bindless_texture);
    d->MakeImageHandleNonResidentNV(handle);
}

inline void QOpenGLExtension_NV_bindless_texture::glMakeImageHandleResidentNV(GLuint64 handle, GLenum access)
{
    Q_D(QOpenGLExtension_NV_bindless_texture);
    d->MakeImageHandleResidentNV(handle, access);
}

inline GLuint64 QOpenGLExtension_NV_bindless_texture::glGetImageHandleNV(GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum format)
{
    Q_D(QOpenGLExtension_NV_bindless_texture);
    return d->GetImageHandleNV(texture, level, layered, layer, format);
}

inline void QOpenGLExtension_NV_bindless_texture::glMakeTextureHandleNonResidentNV(GLuint64 handle)
{
    Q_D(QOpenGLExtension_NV_bindless_texture);
    d->MakeTextureHandleNonResidentNV(handle);
}

inline void QOpenGLExtension_NV_bindless_texture::glMakeTextureHandleResidentNV(GLuint64 handle)
{
    Q_D(QOpenGLExtension_NV_bindless_texture);
    d->MakeTextureHandleResidentNV(handle);
}

inline GLuint64 QOpenGLExtension_NV_bindless_texture::glGetTextureSamplerHandleNV(GLuint texture, GLuint sampler)
{
    Q_D(QOpenGLExtension_NV_bindless_texture);
    return d->GetTextureSamplerHandleNV(texture, sampler);
}

inline GLuint64 QOpenGLExtension_NV_bindless_texture::glGetTextureHandleNV(GLuint texture)
{
    Q_D(QOpenGLExtension_NV_bindless_texture);
    return d->GetTextureHandleNV(texture);
}

class QOpenGLExtension_NV_conditional_renderPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP EndConditionalRenderNV)();
    void (QOPENGLF_APIENTRYP BeginConditionalRenderNV)(GLuint id, GLenum mode);
};

class QOpenGLExtension_NV_conditional_render : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_conditional_render();

    bool initializeOpenGLFunctions() final;

    void glEndConditionalRenderNV();
    void glBeginConditionalRenderNV(GLuint id, GLenum mode);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_conditional_render)
};

inline void QOpenGLExtension_NV_conditional_render::glEndConditionalRenderNV()
{
    Q_D(QOpenGLExtension_NV_conditional_render);
    d->EndConditionalRenderNV();
}

inline void QOpenGLExtension_NV_conditional_render::glBeginConditionalRenderNV(GLuint id, GLenum mode)
{
    Q_D(QOpenGLExtension_NV_conditional_render);
    d->BeginConditionalRenderNV(id, mode);
}

class QOpenGLExtension_NV_copy_imagePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP CopyImageSubDataNV)(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei width, GLsizei height, GLsizei depth);
};

class QOpenGLExtension_NV_copy_image : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_copy_image();

    bool initializeOpenGLFunctions() final;

    void glCopyImageSubDataNV(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei width, GLsizei height, GLsizei depth);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_copy_image)
};

inline void QOpenGLExtension_NV_copy_image::glCopyImageSubDataNV(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei width, GLsizei height, GLsizei depth)
{
    Q_D(QOpenGLExtension_NV_copy_image);
    d->CopyImageSubDataNV(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, width, height, depth);
}

class QOpenGLExtension_NV_depth_buffer_floatPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP DepthBoundsdNV)(GLdouble zmin, GLdouble zmax);
    void (QOPENGLF_APIENTRYP ClearDepthdNV)(GLdouble depth);
    void (QOPENGLF_APIENTRYP DepthRangedNV)(GLdouble zNear, GLdouble zFar);
};

class QOpenGLExtension_NV_depth_buffer_float : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_depth_buffer_float();

    bool initializeOpenGLFunctions() final;

    void glDepthBoundsdNV(GLdouble zmin, GLdouble zmax);
    void glClearDepthdNV(GLdouble depth);
    void glDepthRangedNV(GLdouble zNear, GLdouble zFar);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_depth_buffer_float)
};

inline void QOpenGLExtension_NV_depth_buffer_float::glDepthBoundsdNV(GLdouble zmin, GLdouble zmax)
{
    Q_D(QOpenGLExtension_NV_depth_buffer_float);
    d->DepthBoundsdNV(zmin, zmax);
}

inline void QOpenGLExtension_NV_depth_buffer_float::glClearDepthdNV(GLdouble depth)
{
    Q_D(QOpenGLExtension_NV_depth_buffer_float);
    d->ClearDepthdNV(depth);
}

inline void QOpenGLExtension_NV_depth_buffer_float::glDepthRangedNV(GLdouble zNear, GLdouble zFar)
{
    Q_D(QOpenGLExtension_NV_depth_buffer_float);
    d->DepthRangedNV(zNear, zFar);
}

class QOpenGLExtension_NV_evaluatorsPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP EvalMapsNV)(GLenum target, GLenum mode);
    void (QOPENGLF_APIENTRYP GetMapAttribParameterfvNV)(GLenum target, GLuint index, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP GetMapAttribParameterivNV)(GLenum target, GLuint index, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetMapParameterfvNV)(GLenum target, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP GetMapParameterivNV)(GLenum target, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetMapControlPointsNV)(GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLboolean packed, GLvoid *points);
    void (QOPENGLF_APIENTRYP MapParameterfvNV)(GLenum target, GLenum pname, const GLfloat *params);
    void (QOPENGLF_APIENTRYP MapParameterivNV)(GLenum target, GLenum pname, const GLint *params);
    void (QOPENGLF_APIENTRYP MapControlPointsNV)(GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLint uorder, GLint vorder, GLboolean packed, const GLvoid *points);
};

class QOpenGLExtension_NV_evaluators : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_evaluators();

    bool initializeOpenGLFunctions() final;

    void glEvalMapsNV(GLenum target, GLenum mode);
    void glGetMapAttribParameterfvNV(GLenum target, GLuint index, GLenum pname, GLfloat *params);
    void glGetMapAttribParameterivNV(GLenum target, GLuint index, GLenum pname, GLint *params);
    void glGetMapParameterfvNV(GLenum target, GLenum pname, GLfloat *params);
    void glGetMapParameterivNV(GLenum target, GLenum pname, GLint *params);
    void glGetMapControlPointsNV(GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLboolean packed, GLvoid *points);
    void glMapParameterfvNV(GLenum target, GLenum pname, const GLfloat *params);
    void glMapParameterivNV(GLenum target, GLenum pname, const GLint *params);
    void glMapControlPointsNV(GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLint uorder, GLint vorder, GLboolean packed, const GLvoid *points);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_evaluators)
};

inline void QOpenGLExtension_NV_evaluators::glEvalMapsNV(GLenum target, GLenum mode)
{
    Q_D(QOpenGLExtension_NV_evaluators);
    d->EvalMapsNV(target, mode);
}

inline void QOpenGLExtension_NV_evaluators::glGetMapAttribParameterfvNV(GLenum target, GLuint index, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_NV_evaluators);
    d->GetMapAttribParameterfvNV(target, index, pname, params);
}

inline void QOpenGLExtension_NV_evaluators::glGetMapAttribParameterivNV(GLenum target, GLuint index, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_NV_evaluators);
    d->GetMapAttribParameterivNV(target, index, pname, params);
}

inline void QOpenGLExtension_NV_evaluators::glGetMapParameterfvNV(GLenum target, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_NV_evaluators);
    d->GetMapParameterfvNV(target, pname, params);
}

inline void QOpenGLExtension_NV_evaluators::glGetMapParameterivNV(GLenum target, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_NV_evaluators);
    d->GetMapParameterivNV(target, pname, params);
}

inline void QOpenGLExtension_NV_evaluators::glGetMapControlPointsNV(GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLboolean packed, GLvoid *points)
{
    Q_D(QOpenGLExtension_NV_evaluators);
    d->GetMapControlPointsNV(target, index, type, ustride, vstride, packed, points);
}

inline void QOpenGLExtension_NV_evaluators::glMapParameterfvNV(GLenum target, GLenum pname, const GLfloat *params)
{
    Q_D(QOpenGLExtension_NV_evaluators);
    d->MapParameterfvNV(target, pname, params);
}

inline void QOpenGLExtension_NV_evaluators::glMapParameterivNV(GLenum target, GLenum pname, const GLint *params)
{
    Q_D(QOpenGLExtension_NV_evaluators);
    d->MapParameterivNV(target, pname, params);
}

inline void QOpenGLExtension_NV_evaluators::glMapControlPointsNV(GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLint uorder, GLint vorder, GLboolean packed, const GLvoid *points)
{
    Q_D(QOpenGLExtension_NV_evaluators);
    d->MapControlPointsNV(target, index, type, ustride, vstride, uorder, vorder, packed, points);
}

class QOpenGLExtension_NV_explicit_multisamplePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP TexRenderbufferNV)(GLenum target, GLuint renderbuffer);
    void (QOPENGLF_APIENTRYP SampleMaskIndexedNV)(GLuint index, GLbitfield mask);
    void (QOPENGLF_APIENTRYP GetMultisamplefvNV)(GLenum pname, GLuint index, GLfloat *val);
};

class QOpenGLExtension_NV_explicit_multisample : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_explicit_multisample();

    bool initializeOpenGLFunctions() final;

    void glTexRenderbufferNV(GLenum target, GLuint renderbuffer);
    void glSampleMaskIndexedNV(GLuint index, GLbitfield mask);
    void glGetMultisamplefvNV(GLenum pname, GLuint index, GLfloat *val);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_explicit_multisample)
};

inline void QOpenGLExtension_NV_explicit_multisample::glTexRenderbufferNV(GLenum target, GLuint renderbuffer)
{
    Q_D(QOpenGLExtension_NV_explicit_multisample);
    d->TexRenderbufferNV(target, renderbuffer);
}

inline void QOpenGLExtension_NV_explicit_multisample::glSampleMaskIndexedNV(GLuint index, GLbitfield mask)
{
    Q_D(QOpenGLExtension_NV_explicit_multisample);
    d->SampleMaskIndexedNV(index, mask);
}

inline void QOpenGLExtension_NV_explicit_multisample::glGetMultisamplefvNV(GLenum pname, GLuint index, GLfloat *val)
{
    Q_D(QOpenGLExtension_NV_explicit_multisample);
    d->GetMultisamplefvNV(pname, index, val);
}

class QOpenGLExtension_NV_fencePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP SetFenceNV)(GLuint fence, GLenum condition);
    void (QOPENGLF_APIENTRYP FinishFenceNV)(GLuint fence);
    void (QOPENGLF_APIENTRYP GetFenceivNV)(GLuint fence, GLenum pname, GLint *params);
    GLboolean (QOPENGLF_APIENTRYP TestFenceNV)(GLuint fence);
    GLboolean (QOPENGLF_APIENTRYP IsFenceNV)(GLuint fence);
    void (QOPENGLF_APIENTRYP GenFencesNV)(GLsizei n, GLuint *fences);
    void (QOPENGLF_APIENTRYP DeleteFencesNV)(GLsizei n, const GLuint *fences);
};

class QOpenGLExtension_NV_fence : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_fence();

    bool initializeOpenGLFunctions() final;

    void glSetFenceNV(GLuint fence, GLenum condition);
    void glFinishFenceNV(GLuint fence);
    void glGetFenceivNV(GLuint fence, GLenum pname, GLint *params);
    GLboolean glTestFenceNV(GLuint fence);
    GLboolean glIsFenceNV(GLuint fence);
    void glGenFencesNV(GLsizei n, GLuint *fences);
    void glDeleteFencesNV(GLsizei n, const GLuint *fences);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_fence)
};

inline void QOpenGLExtension_NV_fence::glSetFenceNV(GLuint fence, GLenum condition)
{
    Q_D(QOpenGLExtension_NV_fence);
    d->SetFenceNV(fence, condition);
}

inline void QOpenGLExtension_NV_fence::glFinishFenceNV(GLuint fence)
{
    Q_D(QOpenGLExtension_NV_fence);
    d->FinishFenceNV(fence);
}

inline void QOpenGLExtension_NV_fence::glGetFenceivNV(GLuint fence, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_NV_fence);
    d->GetFenceivNV(fence, pname, params);
}

inline GLboolean QOpenGLExtension_NV_fence::glTestFenceNV(GLuint fence)
{
    Q_D(QOpenGLExtension_NV_fence);
    return d->TestFenceNV(fence);
}

inline GLboolean QOpenGLExtension_NV_fence::glIsFenceNV(GLuint fence)
{
    Q_D(QOpenGLExtension_NV_fence);
    return d->IsFenceNV(fence);
}

inline void QOpenGLExtension_NV_fence::glGenFencesNV(GLsizei n, GLuint *fences)
{
    Q_D(QOpenGLExtension_NV_fence);
    d->GenFencesNV(n, fences);
}

inline void QOpenGLExtension_NV_fence::glDeleteFencesNV(GLsizei n, const GLuint *fences)
{
    Q_D(QOpenGLExtension_NV_fence);
    d->DeleteFencesNV(n, fences);
}

class QOpenGLExtension_NV_fragment_programPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetProgramNamedParameterdvNV)(GLuint id, GLsizei len, const GLubyte *name, GLdouble *params);
    void (QOPENGLF_APIENTRYP GetProgramNamedParameterfvNV)(GLuint id, GLsizei len, const GLubyte *name, GLfloat *params);
    void (QOPENGLF_APIENTRYP ProgramNamedParameter4dvNV)(GLuint id, GLsizei len, const GLubyte *name, const GLdouble *v);
    void (QOPENGLF_APIENTRYP ProgramNamedParameter4fvNV)(GLuint id, GLsizei len, const GLubyte *name, const GLfloat *v);
    void (QOPENGLF_APIENTRYP ProgramNamedParameter4dNV)(GLuint id, GLsizei len, const GLubyte *name, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
    void (QOPENGLF_APIENTRYP ProgramNamedParameter4fNV)(GLuint id, GLsizei len, const GLubyte *name, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
};

class QOpenGLExtension_NV_fragment_program : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_fragment_program();

    bool initializeOpenGLFunctions() final;

    void glGetProgramNamedParameterdvNV(GLuint id, GLsizei len, const GLubyte *name, GLdouble *params);
    void glGetProgramNamedParameterfvNV(GLuint id, GLsizei len, const GLubyte *name, GLfloat *params);
    void glProgramNamedParameter4dvNV(GLuint id, GLsizei len, const GLubyte *name, const GLdouble *v);
    void glProgramNamedParameter4fvNV(GLuint id, GLsizei len, const GLubyte *name, const GLfloat *v);
    void glProgramNamedParameter4dNV(GLuint id, GLsizei len, const GLubyte *name, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
    void glProgramNamedParameter4fNV(GLuint id, GLsizei len, const GLubyte *name, GLfloat x, GLfloat y, GLfloat z, GLfloat w);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_fragment_program)
};

inline void QOpenGLExtension_NV_fragment_program::glGetProgramNamedParameterdvNV(GLuint id, GLsizei len, const GLubyte *name, GLdouble *params)
{
    Q_D(QOpenGLExtension_NV_fragment_program);
    d->GetProgramNamedParameterdvNV(id, len, name, params);
}

inline void QOpenGLExtension_NV_fragment_program::glGetProgramNamedParameterfvNV(GLuint id, GLsizei len, const GLubyte *name, GLfloat *params)
{
    Q_D(QOpenGLExtension_NV_fragment_program);
    d->GetProgramNamedParameterfvNV(id, len, name, params);
}

inline void QOpenGLExtension_NV_fragment_program::glProgramNamedParameter4dvNV(GLuint id, GLsizei len, const GLubyte *name, const GLdouble *v)
{
    Q_D(QOpenGLExtension_NV_fragment_program);
    d->ProgramNamedParameter4dvNV(id, len, name, v);
}

inline void QOpenGLExtension_NV_fragment_program::glProgramNamedParameter4fvNV(GLuint id, GLsizei len, const GLubyte *name, const GLfloat *v)
{
    Q_D(QOpenGLExtension_NV_fragment_program);
    d->ProgramNamedParameter4fvNV(id, len, name, v);
}

inline void QOpenGLExtension_NV_fragment_program::glProgramNamedParameter4dNV(GLuint id, GLsizei len, const GLubyte *name, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    Q_D(QOpenGLExtension_NV_fragment_program);
    d->ProgramNamedParameter4dNV(id, len, name, x, y, z, w);
}

inline void QOpenGLExtension_NV_fragment_program::glProgramNamedParameter4fNV(GLuint id, GLsizei len, const GLubyte *name, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
    Q_D(QOpenGLExtension_NV_fragment_program);
    d->ProgramNamedParameter4fNV(id, len, name, x, y, z, w);
}

class QOpenGLExtension_NV_framebuffer_multisample_coveragePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP RenderbufferStorageMultisampleCoverageNV)(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLenum internalformat, GLsizei width, GLsizei height);
};

class QOpenGLExtension_NV_framebuffer_multisample_coverage : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_framebuffer_multisample_coverage();

    bool initializeOpenGLFunctions() final;

    void glRenderbufferStorageMultisampleCoverageNV(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLenum internalformat, GLsizei width, GLsizei height);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_framebuffer_multisample_coverage)
};

inline void QOpenGLExtension_NV_framebuffer_multisample_coverage::glRenderbufferStorageMultisampleCoverageNV(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLenum internalformat, GLsizei width, GLsizei height)
{
    Q_D(QOpenGLExtension_NV_framebuffer_multisample_coverage);
    d->RenderbufferStorageMultisampleCoverageNV(target, coverageSamples, colorSamples, internalformat, width, height);
}

class QOpenGLExtension_NV_geometry_program4Private : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP FramebufferTextureFaceEXT)(GLenum target, GLenum attachment, GLuint texture, GLint level, GLenum face);
    void (QOPENGLF_APIENTRYP FramebufferTextureLayerEXT)(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer);
    void (QOPENGLF_APIENTRYP FramebufferTextureEXT)(GLenum target, GLenum attachment, GLuint texture, GLint level);
    void (QOPENGLF_APIENTRYP ProgramVertexLimitNV)(GLenum target, GLint limit);
};

class QOpenGLExtension_NV_geometry_program4 : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_geometry_program4();

    bool initializeOpenGLFunctions() final;

    void glFramebufferTextureFaceEXT(GLenum target, GLenum attachment, GLuint texture, GLint level, GLenum face);
    void glFramebufferTextureLayerEXT(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer);
    void glFramebufferTextureEXT(GLenum target, GLenum attachment, GLuint texture, GLint level);
    void glProgramVertexLimitNV(GLenum target, GLint limit);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_geometry_program4)
};

inline void QOpenGLExtension_NV_geometry_program4::glFramebufferTextureFaceEXT(GLenum target, GLenum attachment, GLuint texture, GLint level, GLenum face)
{
    Q_D(QOpenGLExtension_NV_geometry_program4);
    d->FramebufferTextureFaceEXT(target, attachment, texture, level, face);
}

inline void QOpenGLExtension_NV_geometry_program4::glFramebufferTextureLayerEXT(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer)
{
    Q_D(QOpenGLExtension_NV_geometry_program4);
    d->FramebufferTextureLayerEXT(target, attachment, texture, level, layer);
}

inline void QOpenGLExtension_NV_geometry_program4::glFramebufferTextureEXT(GLenum target, GLenum attachment, GLuint texture, GLint level)
{
    Q_D(QOpenGLExtension_NV_geometry_program4);
    d->FramebufferTextureEXT(target, attachment, texture, level);
}

inline void QOpenGLExtension_NV_geometry_program4::glProgramVertexLimitNV(GLenum target, GLint limit)
{
    Q_D(QOpenGLExtension_NV_geometry_program4);
    d->ProgramVertexLimitNV(target, limit);
}

class QOpenGLExtension_NV_gpu_program4Private : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetProgramEnvParameterIuivNV)(GLenum target, GLuint index, GLuint *params);
    void (QOPENGLF_APIENTRYP GetProgramEnvParameterIivNV)(GLenum target, GLuint index, GLint *params);
    void (QOPENGLF_APIENTRYP GetProgramLocalParameterIuivNV)(GLenum target, GLuint index, GLuint *params);
    void (QOPENGLF_APIENTRYP GetProgramLocalParameterIivNV)(GLenum target, GLuint index, GLint *params);
    void (QOPENGLF_APIENTRYP ProgramEnvParametersI4uivNV)(GLenum target, GLuint index, GLsizei count, const GLuint *params);
    void (QOPENGLF_APIENTRYP ProgramEnvParameterI4uivNV)(GLenum target, GLuint index, const GLuint *params);
    void (QOPENGLF_APIENTRYP ProgramEnvParameterI4uiNV)(GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w);
    void (QOPENGLF_APIENTRYP ProgramEnvParametersI4ivNV)(GLenum target, GLuint index, GLsizei count, const GLint *params);
    void (QOPENGLF_APIENTRYP ProgramEnvParameterI4ivNV)(GLenum target, GLuint index, const GLint *params);
    void (QOPENGLF_APIENTRYP ProgramEnvParameterI4iNV)(GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w);
    void (QOPENGLF_APIENTRYP ProgramLocalParametersI4uivNV)(GLenum target, GLuint index, GLsizei count, const GLuint *params);
    void (QOPENGLF_APIENTRYP ProgramLocalParameterI4uivNV)(GLenum target, GLuint index, const GLuint *params);
    void (QOPENGLF_APIENTRYP ProgramLocalParameterI4uiNV)(GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w);
    void (QOPENGLF_APIENTRYP ProgramLocalParametersI4ivNV)(GLenum target, GLuint index, GLsizei count, const GLint *params);
    void (QOPENGLF_APIENTRYP ProgramLocalParameterI4ivNV)(GLenum target, GLuint index, const GLint *params);
    void (QOPENGLF_APIENTRYP ProgramLocalParameterI4iNV)(GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w);
};

class QOpenGLExtension_NV_gpu_program4 : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_gpu_program4();

    bool initializeOpenGLFunctions() final;

    void glGetProgramEnvParameterIuivNV(GLenum target, GLuint index, GLuint *params);
    void glGetProgramEnvParameterIivNV(GLenum target, GLuint index, GLint *params);
    void glGetProgramLocalParameterIuivNV(GLenum target, GLuint index, GLuint *params);
    void glGetProgramLocalParameterIivNV(GLenum target, GLuint index, GLint *params);
    void glProgramEnvParametersI4uivNV(GLenum target, GLuint index, GLsizei count, const GLuint *params);
    void glProgramEnvParameterI4uivNV(GLenum target, GLuint index, const GLuint *params);
    void glProgramEnvParameterI4uiNV(GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w);
    void glProgramEnvParametersI4ivNV(GLenum target, GLuint index, GLsizei count, const GLint *params);
    void glProgramEnvParameterI4ivNV(GLenum target, GLuint index, const GLint *params);
    void glProgramEnvParameterI4iNV(GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w);
    void glProgramLocalParametersI4uivNV(GLenum target, GLuint index, GLsizei count, const GLuint *params);
    void glProgramLocalParameterI4uivNV(GLenum target, GLuint index, const GLuint *params);
    void glProgramLocalParameterI4uiNV(GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w);
    void glProgramLocalParametersI4ivNV(GLenum target, GLuint index, GLsizei count, const GLint *params);
    void glProgramLocalParameterI4ivNV(GLenum target, GLuint index, const GLint *params);
    void glProgramLocalParameterI4iNV(GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_gpu_program4)
};

inline void QOpenGLExtension_NV_gpu_program4::glGetProgramEnvParameterIuivNV(GLenum target, GLuint index, GLuint *params)
{
    Q_D(QOpenGLExtension_NV_gpu_program4);
    d->GetProgramEnvParameterIuivNV(target, index, params);
}

inline void QOpenGLExtension_NV_gpu_program4::glGetProgramEnvParameterIivNV(GLenum target, GLuint index, GLint *params)
{
    Q_D(QOpenGLExtension_NV_gpu_program4);
    d->GetProgramEnvParameterIivNV(target, index, params);
}

inline void QOpenGLExtension_NV_gpu_program4::glGetProgramLocalParameterIuivNV(GLenum target, GLuint index, GLuint *params)
{
    Q_D(QOpenGLExtension_NV_gpu_program4);
    d->GetProgramLocalParameterIuivNV(target, index, params);
}

inline void QOpenGLExtension_NV_gpu_program4::glGetProgramLocalParameterIivNV(GLenum target, GLuint index, GLint *params)
{
    Q_D(QOpenGLExtension_NV_gpu_program4);
    d->GetProgramLocalParameterIivNV(target, index, params);
}

inline void QOpenGLExtension_NV_gpu_program4::glProgramEnvParametersI4uivNV(GLenum target, GLuint index, GLsizei count, const GLuint *params)
{
    Q_D(QOpenGLExtension_NV_gpu_program4);
    d->ProgramEnvParametersI4uivNV(target, index, count, params);
}

inline void QOpenGLExtension_NV_gpu_program4::glProgramEnvParameterI4uivNV(GLenum target, GLuint index, const GLuint *params)
{
    Q_D(QOpenGLExtension_NV_gpu_program4);
    d->ProgramEnvParameterI4uivNV(target, index, params);
}

inline void QOpenGLExtension_NV_gpu_program4::glProgramEnvParameterI4uiNV(GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)
{
    Q_D(QOpenGLExtension_NV_gpu_program4);
    d->ProgramEnvParameterI4uiNV(target, index, x, y, z, w);
}

inline void QOpenGLExtension_NV_gpu_program4::glProgramEnvParametersI4ivNV(GLenum target, GLuint index, GLsizei count, const GLint *params)
{
    Q_D(QOpenGLExtension_NV_gpu_program4);
    d->ProgramEnvParametersI4ivNV(target, index, count, params);
}

inline void QOpenGLExtension_NV_gpu_program4::glProgramEnvParameterI4ivNV(GLenum target, GLuint index, const GLint *params)
{
    Q_D(QOpenGLExtension_NV_gpu_program4);
    d->ProgramEnvParameterI4ivNV(target, index, params);
}

inline void QOpenGLExtension_NV_gpu_program4::glProgramEnvParameterI4iNV(GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w)
{
    Q_D(QOpenGLExtension_NV_gpu_program4);
    d->ProgramEnvParameterI4iNV(target, index, x, y, z, w);
}

inline void QOpenGLExtension_NV_gpu_program4::glProgramLocalParametersI4uivNV(GLenum target, GLuint index, GLsizei count, const GLuint *params)
{
    Q_D(QOpenGLExtension_NV_gpu_program4);
    d->ProgramLocalParametersI4uivNV(target, index, count, params);
}

inline void QOpenGLExtension_NV_gpu_program4::glProgramLocalParameterI4uivNV(GLenum target, GLuint index, const GLuint *params)
{
    Q_D(QOpenGLExtension_NV_gpu_program4);
    d->ProgramLocalParameterI4uivNV(target, index, params);
}

inline void QOpenGLExtension_NV_gpu_program4::glProgramLocalParameterI4uiNV(GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)
{
    Q_D(QOpenGLExtension_NV_gpu_program4);
    d->ProgramLocalParameterI4uiNV(target, index, x, y, z, w);
}

inline void QOpenGLExtension_NV_gpu_program4::glProgramLocalParametersI4ivNV(GLenum target, GLuint index, GLsizei count, const GLint *params)
{
    Q_D(QOpenGLExtension_NV_gpu_program4);
    d->ProgramLocalParametersI4ivNV(target, index, count, params);
}

inline void QOpenGLExtension_NV_gpu_program4::glProgramLocalParameterI4ivNV(GLenum target, GLuint index, const GLint *params)
{
    Q_D(QOpenGLExtension_NV_gpu_program4);
    d->ProgramLocalParameterI4ivNV(target, index, params);
}

inline void QOpenGLExtension_NV_gpu_program4::glProgramLocalParameterI4iNV(GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w)
{
    Q_D(QOpenGLExtension_NV_gpu_program4);
    d->ProgramLocalParameterI4iNV(target, index, x, y, z, w);
}

class QOpenGLExtension_NV_gpu_program5Private : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetProgramSubroutineParameteruivNV)(GLenum target, GLuint index, GLuint *param);
    void (QOPENGLF_APIENTRYP ProgramSubroutineParametersuivNV)(GLenum target, GLsizei count, const GLuint *params);
};

class QOpenGLExtension_NV_gpu_program5 : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_gpu_program5();

    bool initializeOpenGLFunctions() final;

    void glGetProgramSubroutineParameteruivNV(GLenum target, GLuint index, GLuint *param);
    void glProgramSubroutineParametersuivNV(GLenum target, GLsizei count, const GLuint *params);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_gpu_program5)
};

inline void QOpenGLExtension_NV_gpu_program5::glGetProgramSubroutineParameteruivNV(GLenum target, GLuint index, GLuint *param)
{
    Q_D(QOpenGLExtension_NV_gpu_program5);
    d->GetProgramSubroutineParameteruivNV(target, index, param);
}

inline void QOpenGLExtension_NV_gpu_program5::glProgramSubroutineParametersuivNV(GLenum target, GLsizei count, const GLuint *params)
{
    Q_D(QOpenGLExtension_NV_gpu_program5);
    d->ProgramSubroutineParametersuivNV(target, count, params);
}

class QOpenGLExtension_NV_gpu_shader5Private : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP ProgramUniform4ui64vNV)(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value);
    void (QOPENGLF_APIENTRYP ProgramUniform3ui64vNV)(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value);
    void (QOPENGLF_APIENTRYP ProgramUniform2ui64vNV)(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value);
    void (QOPENGLF_APIENTRYP ProgramUniform1ui64vNV)(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value);
    void (QOPENGLF_APIENTRYP ProgramUniform4ui64NV)(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w);
    void (QOPENGLF_APIENTRYP ProgramUniform3ui64NV)(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z);
    void (QOPENGLF_APIENTRYP ProgramUniform2ui64NV)(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y);
    void (QOPENGLF_APIENTRYP ProgramUniform1ui64NV)(GLuint program, GLint location, GLuint64EXT x);
    void (QOPENGLF_APIENTRYP ProgramUniform4i64vNV)(GLuint program, GLint location, GLsizei count, const GLint64EXT *value);
    void (QOPENGLF_APIENTRYP ProgramUniform3i64vNV)(GLuint program, GLint location, GLsizei count, const GLint64EXT *value);
    void (QOPENGLF_APIENTRYP ProgramUniform2i64vNV)(GLuint program, GLint location, GLsizei count, const GLint64EXT *value);
    void (QOPENGLF_APIENTRYP ProgramUniform1i64vNV)(GLuint program, GLint location, GLsizei count, const GLint64EXT *value);
    void (QOPENGLF_APIENTRYP ProgramUniform4i64NV)(GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w);
    void (QOPENGLF_APIENTRYP ProgramUniform3i64NV)(GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z);
    void (QOPENGLF_APIENTRYP ProgramUniform2i64NV)(GLuint program, GLint location, GLint64EXT x, GLint64EXT y);
    void (QOPENGLF_APIENTRYP ProgramUniform1i64NV)(GLuint program, GLint location, GLint64EXT x);
    void (QOPENGLF_APIENTRYP GetUniformi64vNV)(GLuint program, GLint location, GLint64EXT *params);
    void (QOPENGLF_APIENTRYP Uniform4ui64vNV)(GLint location, GLsizei count, const GLuint64EXT *value);
    void (QOPENGLF_APIENTRYP Uniform3ui64vNV)(GLint location, GLsizei count, const GLuint64EXT *value);
    void (QOPENGLF_APIENTRYP Uniform2ui64vNV)(GLint location, GLsizei count, const GLuint64EXT *value);
    void (QOPENGLF_APIENTRYP Uniform1ui64vNV)(GLint location, GLsizei count, const GLuint64EXT *value);
    void (QOPENGLF_APIENTRYP Uniform4ui64NV)(GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w);
    void (QOPENGLF_APIENTRYP Uniform3ui64NV)(GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z);
    void (QOPENGLF_APIENTRYP Uniform2ui64NV)(GLint location, GLuint64EXT x, GLuint64EXT y);
    void (QOPENGLF_APIENTRYP Uniform1ui64NV)(GLint location, GLuint64EXT x);
    void (QOPENGLF_APIENTRYP Uniform4i64vNV)(GLint location, GLsizei count, const GLint64EXT *value);
    void (QOPENGLF_APIENTRYP Uniform3i64vNV)(GLint location, GLsizei count, const GLint64EXT *value);
    void (QOPENGLF_APIENTRYP Uniform2i64vNV)(GLint location, GLsizei count, const GLint64EXT *value);
    void (QOPENGLF_APIENTRYP Uniform1i64vNV)(GLint location, GLsizei count, const GLint64EXT *value);
    void (QOPENGLF_APIENTRYP Uniform4i64NV)(GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w);
    void (QOPENGLF_APIENTRYP Uniform3i64NV)(GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z);
    void (QOPENGLF_APIENTRYP Uniform2i64NV)(GLint location, GLint64EXT x, GLint64EXT y);
    void (QOPENGLF_APIENTRYP Uniform1i64NV)(GLint location, GLint64EXT x);
};

class QOpenGLExtension_NV_gpu_shader5 : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_gpu_shader5();

    bool initializeOpenGLFunctions() final;

    void glProgramUniform4ui64vNV(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value);
    void glProgramUniform3ui64vNV(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value);
    void glProgramUniform2ui64vNV(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value);
    void glProgramUniform1ui64vNV(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value);
    void glProgramUniform4ui64NV(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w);
    void glProgramUniform3ui64NV(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z);
    void glProgramUniform2ui64NV(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y);
    void glProgramUniform1ui64NV(GLuint program, GLint location, GLuint64EXT x);
    void glProgramUniform4i64vNV(GLuint program, GLint location, GLsizei count, const GLint64EXT *value);
    void glProgramUniform3i64vNV(GLuint program, GLint location, GLsizei count, const GLint64EXT *value);
    void glProgramUniform2i64vNV(GLuint program, GLint location, GLsizei count, const GLint64EXT *value);
    void glProgramUniform1i64vNV(GLuint program, GLint location, GLsizei count, const GLint64EXT *value);
    void glProgramUniform4i64NV(GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w);
    void glProgramUniform3i64NV(GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z);
    void glProgramUniform2i64NV(GLuint program, GLint location, GLint64EXT x, GLint64EXT y);
    void glProgramUniform1i64NV(GLuint program, GLint location, GLint64EXT x);
    void glGetUniformi64vNV(GLuint program, GLint location, GLint64EXT *params);
    void glUniform4ui64vNV(GLint location, GLsizei count, const GLuint64EXT *value);
    void glUniform3ui64vNV(GLint location, GLsizei count, const GLuint64EXT *value);
    void glUniform2ui64vNV(GLint location, GLsizei count, const GLuint64EXT *value);
    void glUniform1ui64vNV(GLint location, GLsizei count, const GLuint64EXT *value);
    void glUniform4ui64NV(GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w);
    void glUniform3ui64NV(GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z);
    void glUniform2ui64NV(GLint location, GLuint64EXT x, GLuint64EXT y);
    void glUniform1ui64NV(GLint location, GLuint64EXT x);
    void glUniform4i64vNV(GLint location, GLsizei count, const GLint64EXT *value);
    void glUniform3i64vNV(GLint location, GLsizei count, const GLint64EXT *value);
    void glUniform2i64vNV(GLint location, GLsizei count, const GLint64EXT *value);
    void glUniform1i64vNV(GLint location, GLsizei count, const GLint64EXT *value);
    void glUniform4i64NV(GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w);
    void glUniform3i64NV(GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z);
    void glUniform2i64NV(GLint location, GLint64EXT x, GLint64EXT y);
    void glUniform1i64NV(GLint location, GLint64EXT x);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_gpu_shader5)
};

inline void QOpenGLExtension_NV_gpu_shader5::glProgramUniform4ui64vNV(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->ProgramUniform4ui64vNV(program, location, count, value);
}

inline void QOpenGLExtension_NV_gpu_shader5::glProgramUniform3ui64vNV(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->ProgramUniform3ui64vNV(program, location, count, value);
}

inline void QOpenGLExtension_NV_gpu_shader5::glProgramUniform2ui64vNV(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->ProgramUniform2ui64vNV(program, location, count, value);
}

inline void QOpenGLExtension_NV_gpu_shader5::glProgramUniform1ui64vNV(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->ProgramUniform1ui64vNV(program, location, count, value);
}

inline void QOpenGLExtension_NV_gpu_shader5::glProgramUniform4ui64NV(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->ProgramUniform4ui64NV(program, location, x, y, z, w);
}

inline void QOpenGLExtension_NV_gpu_shader5::glProgramUniform3ui64NV(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->ProgramUniform3ui64NV(program, location, x, y, z);
}

inline void QOpenGLExtension_NV_gpu_shader5::glProgramUniform2ui64NV(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->ProgramUniform2ui64NV(program, location, x, y);
}

inline void QOpenGLExtension_NV_gpu_shader5::glProgramUniform1ui64NV(GLuint program, GLint location, GLuint64EXT x)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->ProgramUniform1ui64NV(program, location, x);
}

inline void QOpenGLExtension_NV_gpu_shader5::glProgramUniform4i64vNV(GLuint program, GLint location, GLsizei count, const GLint64EXT *value)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->ProgramUniform4i64vNV(program, location, count, value);
}

inline void QOpenGLExtension_NV_gpu_shader5::glProgramUniform3i64vNV(GLuint program, GLint location, GLsizei count, const GLint64EXT *value)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->ProgramUniform3i64vNV(program, location, count, value);
}

inline void QOpenGLExtension_NV_gpu_shader5::glProgramUniform2i64vNV(GLuint program, GLint location, GLsizei count, const GLint64EXT *value)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->ProgramUniform2i64vNV(program, location, count, value);
}

inline void QOpenGLExtension_NV_gpu_shader5::glProgramUniform1i64vNV(GLuint program, GLint location, GLsizei count, const GLint64EXT *value)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->ProgramUniform1i64vNV(program, location, count, value);
}

inline void QOpenGLExtension_NV_gpu_shader5::glProgramUniform4i64NV(GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->ProgramUniform4i64NV(program, location, x, y, z, w);
}

inline void QOpenGLExtension_NV_gpu_shader5::glProgramUniform3i64NV(GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->ProgramUniform3i64NV(program, location, x, y, z);
}

inline void QOpenGLExtension_NV_gpu_shader5::glProgramUniform2i64NV(GLuint program, GLint location, GLint64EXT x, GLint64EXT y)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->ProgramUniform2i64NV(program, location, x, y);
}

inline void QOpenGLExtension_NV_gpu_shader5::glProgramUniform1i64NV(GLuint program, GLint location, GLint64EXT x)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->ProgramUniform1i64NV(program, location, x);
}

inline void QOpenGLExtension_NV_gpu_shader5::glGetUniformi64vNV(GLuint program, GLint location, GLint64EXT *params)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->GetUniformi64vNV(program, location, params);
}

inline void QOpenGLExtension_NV_gpu_shader5::glUniform4ui64vNV(GLint location, GLsizei count, const GLuint64EXT *value)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->Uniform4ui64vNV(location, count, value);
}

inline void QOpenGLExtension_NV_gpu_shader5::glUniform3ui64vNV(GLint location, GLsizei count, const GLuint64EXT *value)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->Uniform3ui64vNV(location, count, value);
}

inline void QOpenGLExtension_NV_gpu_shader5::glUniform2ui64vNV(GLint location, GLsizei count, const GLuint64EXT *value)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->Uniform2ui64vNV(location, count, value);
}

inline void QOpenGLExtension_NV_gpu_shader5::glUniform1ui64vNV(GLint location, GLsizei count, const GLuint64EXT *value)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->Uniform1ui64vNV(location, count, value);
}

inline void QOpenGLExtension_NV_gpu_shader5::glUniform4ui64NV(GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->Uniform4ui64NV(location, x, y, z, w);
}

inline void QOpenGLExtension_NV_gpu_shader5::glUniform3ui64NV(GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->Uniform3ui64NV(location, x, y, z);
}

inline void QOpenGLExtension_NV_gpu_shader5::glUniform2ui64NV(GLint location, GLuint64EXT x, GLuint64EXT y)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->Uniform2ui64NV(location, x, y);
}

inline void QOpenGLExtension_NV_gpu_shader5::glUniform1ui64NV(GLint location, GLuint64EXT x)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->Uniform1ui64NV(location, x);
}

inline void QOpenGLExtension_NV_gpu_shader5::glUniform4i64vNV(GLint location, GLsizei count, const GLint64EXT *value)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->Uniform4i64vNV(location, count, value);
}

inline void QOpenGLExtension_NV_gpu_shader5::glUniform3i64vNV(GLint location, GLsizei count, const GLint64EXT *value)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->Uniform3i64vNV(location, count, value);
}

inline void QOpenGLExtension_NV_gpu_shader5::glUniform2i64vNV(GLint location, GLsizei count, const GLint64EXT *value)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->Uniform2i64vNV(location, count, value);
}

inline void QOpenGLExtension_NV_gpu_shader5::glUniform1i64vNV(GLint location, GLsizei count, const GLint64EXT *value)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->Uniform1i64vNV(location, count, value);
}

inline void QOpenGLExtension_NV_gpu_shader5::glUniform4i64NV(GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->Uniform4i64NV(location, x, y, z, w);
}

inline void QOpenGLExtension_NV_gpu_shader5::glUniform3i64NV(GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->Uniform3i64NV(location, x, y, z);
}

inline void QOpenGLExtension_NV_gpu_shader5::glUniform2i64NV(GLint location, GLint64EXT x, GLint64EXT y)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->Uniform2i64NV(location, x, y);
}

inline void QOpenGLExtension_NV_gpu_shader5::glUniform1i64NV(GLint location, GLint64EXT x)
{
    Q_D(QOpenGLExtension_NV_gpu_shader5);
    d->Uniform1i64NV(location, x);
}

class QOpenGLExtension_NV_half_floatPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP VertexAttribs4hvNV)(GLuint index, GLsizei n, const GLhalfNV *v);
    void (QOPENGLF_APIENTRYP VertexAttribs3hvNV)(GLuint index, GLsizei n, const GLhalfNV *v);
    void (QOPENGLF_APIENTRYP VertexAttribs2hvNV)(GLuint index, GLsizei n, const GLhalfNV *v);
    void (QOPENGLF_APIENTRYP VertexAttribs1hvNV)(GLuint index, GLsizei n, const GLhalfNV *v);
    void (QOPENGLF_APIENTRYP VertexAttrib4hvNV)(GLuint index, const GLhalfNV *v);
    void (QOPENGLF_APIENTRYP VertexAttrib4hNV)(GLuint index, GLhalfNV x, GLhalfNV y, GLhalfNV z, GLhalfNV w);
    void (QOPENGLF_APIENTRYP VertexAttrib3hvNV)(GLuint index, const GLhalfNV *v);
    void (QOPENGLF_APIENTRYP VertexAttrib3hNV)(GLuint index, GLhalfNV x, GLhalfNV y, GLhalfNV z);
    void (QOPENGLF_APIENTRYP VertexAttrib2hvNV)(GLuint index, const GLhalfNV *v);
    void (QOPENGLF_APIENTRYP VertexAttrib2hNV)(GLuint index, GLhalfNV x, GLhalfNV y);
    void (QOPENGLF_APIENTRYP VertexAttrib1hvNV)(GLuint index, const GLhalfNV *v);
    void (QOPENGLF_APIENTRYP VertexAttrib1hNV)(GLuint index, GLhalfNV x);
    void (QOPENGLF_APIENTRYP VertexWeighthvNV)(const GLhalfNV *weight);
    void (QOPENGLF_APIENTRYP VertexWeighthNV)(GLhalfNV weight);
    void (QOPENGLF_APIENTRYP SecondaryColor3hvNV)(const GLhalfNV *v);
    void (QOPENGLF_APIENTRYP SecondaryColor3hNV)(GLhalfNV red, GLhalfNV green, GLhalfNV blue);
    void (QOPENGLF_APIENTRYP FogCoordhvNV)(const GLhalfNV *fog);
    void (QOPENGLF_APIENTRYP FogCoordhNV)(GLhalfNV fog);
    void (QOPENGLF_APIENTRYP MultiTexCoord4hvNV)(GLenum target, const GLhalfNV *v);
    void (QOPENGLF_APIENTRYP MultiTexCoord4hNV)(GLenum target, GLhalfNV s, GLhalfNV t, GLhalfNV r, GLhalfNV q);
    void (QOPENGLF_APIENTRYP MultiTexCoord3hvNV)(GLenum target, const GLhalfNV *v);
    void (QOPENGLF_APIENTRYP MultiTexCoord3hNV)(GLenum target, GLhalfNV s, GLhalfNV t, GLhalfNV r);
    void (QOPENGLF_APIENTRYP MultiTexCoord2hvNV)(GLenum target, const GLhalfNV *v);
    void (QOPENGLF_APIENTRYP MultiTexCoord2hNV)(GLenum target, GLhalfNV s, GLhalfNV t);
    void (QOPENGLF_APIENTRYP MultiTexCoord1hvNV)(GLenum target, const GLhalfNV *v);
    void (QOPENGLF_APIENTRYP MultiTexCoord1hNV)(GLenum target, GLhalfNV s);
    void (QOPENGLF_APIENTRYP TexCoord4hvNV)(const GLhalfNV *v);
    void (QOPENGLF_APIENTRYP TexCoord4hNV)(GLhalfNV s, GLhalfNV t, GLhalfNV r, GLhalfNV q);
    void (QOPENGLF_APIENTRYP TexCoord3hvNV)(const GLhalfNV *v);
    void (QOPENGLF_APIENTRYP TexCoord3hNV)(GLhalfNV s, GLhalfNV t, GLhalfNV r);
    void (QOPENGLF_APIENTRYP TexCoord2hvNV)(const GLhalfNV *v);
    void (QOPENGLF_APIENTRYP TexCoord2hNV)(GLhalfNV s, GLhalfNV t);
    void (QOPENGLF_APIENTRYP TexCoord1hvNV)(const GLhalfNV *v);
    void (QOPENGLF_APIENTRYP TexCoord1hNV)(GLhalfNV s);
    void (QOPENGLF_APIENTRYP Color4hvNV)(const GLhalfNV *v);
    void (QOPENGLF_APIENTRYP Color4hNV)(GLhalfNV red, GLhalfNV green, GLhalfNV blue, GLhalfNV alpha);
    void (QOPENGLF_APIENTRYP Color3hvNV)(const GLhalfNV *v);
    void (QOPENGLF_APIENTRYP Color3hNV)(GLhalfNV red, GLhalfNV green, GLhalfNV blue);
    void (QOPENGLF_APIENTRYP Normal3hvNV)(const GLhalfNV *v);
    void (QOPENGLF_APIENTRYP Normal3hNV)(GLhalfNV nx, GLhalfNV ny, GLhalfNV nz);
    void (QOPENGLF_APIENTRYP Vertex4hvNV)(const GLhalfNV *v);
    void (QOPENGLF_APIENTRYP Vertex4hNV)(GLhalfNV x, GLhalfNV y, GLhalfNV z, GLhalfNV w);
    void (QOPENGLF_APIENTRYP Vertex3hvNV)(const GLhalfNV *v);
    void (QOPENGLF_APIENTRYP Vertex3hNV)(GLhalfNV x, GLhalfNV y, GLhalfNV z);
    void (QOPENGLF_APIENTRYP Vertex2hvNV)(const GLhalfNV *v);
    void (QOPENGLF_APIENTRYP Vertex2hNV)(GLhalfNV x, GLhalfNV y);
};

class QOpenGLExtension_NV_half_float : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_half_float();

    bool initializeOpenGLFunctions() final;

    void glVertexAttribs4hvNV(GLuint index, GLsizei n, const GLhalfNV *v);
    void glVertexAttribs3hvNV(GLuint index, GLsizei n, const GLhalfNV *v);
    void glVertexAttribs2hvNV(GLuint index, GLsizei n, const GLhalfNV *v);
    void glVertexAttribs1hvNV(GLuint index, GLsizei n, const GLhalfNV *v);
    void glVertexAttrib4hvNV(GLuint index, const GLhalfNV *v);
    void glVertexAttrib4hNV(GLuint index, GLhalfNV x, GLhalfNV y, GLhalfNV z, GLhalfNV w);
    void glVertexAttrib3hvNV(GLuint index, const GLhalfNV *v);
    void glVertexAttrib3hNV(GLuint index, GLhalfNV x, GLhalfNV y, GLhalfNV z);
    void glVertexAttrib2hvNV(GLuint index, const GLhalfNV *v);
    void glVertexAttrib2hNV(GLuint index, GLhalfNV x, GLhalfNV y);
    void glVertexAttrib1hvNV(GLuint index, const GLhalfNV *v);
    void glVertexAttrib1hNV(GLuint index, GLhalfNV x);
    void glVertexWeighthvNV(const GLhalfNV *weight);
    void glVertexWeighthNV(GLhalfNV weight);
    void glSecondaryColor3hvNV(const GLhalfNV *v);
    void glSecondaryColor3hNV(GLhalfNV red, GLhalfNV green, GLhalfNV blue);
    void glFogCoordhvNV(const GLhalfNV *fog);
    void glFogCoordhNV(GLhalfNV fog);
    void glMultiTexCoord4hvNV(GLenum target, const GLhalfNV *v);
    void glMultiTexCoord4hNV(GLenum target, GLhalfNV s, GLhalfNV t, GLhalfNV r, GLhalfNV q);
    void glMultiTexCoord3hvNV(GLenum target, const GLhalfNV *v);
    void glMultiTexCoord3hNV(GLenum target, GLhalfNV s, GLhalfNV t, GLhalfNV r);
    void glMultiTexCoord2hvNV(GLenum target, const GLhalfNV *v);
    void glMultiTexCoord2hNV(GLenum target, GLhalfNV s, GLhalfNV t);
    void glMultiTexCoord1hvNV(GLenum target, const GLhalfNV *v);
    void glMultiTexCoord1hNV(GLenum target, GLhalfNV s);
    void glTexCoord4hvNV(const GLhalfNV *v);
    void glTexCoord4hNV(GLhalfNV s, GLhalfNV t, GLhalfNV r, GLhalfNV q);
    void glTexCoord3hvNV(const GLhalfNV *v);
    void glTexCoord3hNV(GLhalfNV s, GLhalfNV t, GLhalfNV r);
    void glTexCoord2hvNV(const GLhalfNV *v);
    void glTexCoord2hNV(GLhalfNV s, GLhalfNV t);
    void glTexCoord1hvNV(const GLhalfNV *v);
    void glTexCoord1hNV(GLhalfNV s);
    void glColor4hvNV(const GLhalfNV *v);
    void glColor4hNV(GLhalfNV red, GLhalfNV green, GLhalfNV blue, GLhalfNV alpha);
    void glColor3hvNV(const GLhalfNV *v);
    void glColor3hNV(GLhalfNV red, GLhalfNV green, GLhalfNV blue);
    void glNormal3hvNV(const GLhalfNV *v);
    void glNormal3hNV(GLhalfNV nx, GLhalfNV ny, GLhalfNV nz);
    void glVertex4hvNV(const GLhalfNV *v);
    void glVertex4hNV(GLhalfNV x, GLhalfNV y, GLhalfNV z, GLhalfNV w);
    void glVertex3hvNV(const GLhalfNV *v);
    void glVertex3hNV(GLhalfNV x, GLhalfNV y, GLhalfNV z);
    void glVertex2hvNV(const GLhalfNV *v);
    void glVertex2hNV(GLhalfNV x, GLhalfNV y);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_half_float)
};

inline void QOpenGLExtension_NV_half_float::glVertexAttribs4hvNV(GLuint index, GLsizei n, const GLhalfNV *v)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->VertexAttribs4hvNV(index, n, v);
}

inline void QOpenGLExtension_NV_half_float::glVertexAttribs3hvNV(GLuint index, GLsizei n, const GLhalfNV *v)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->VertexAttribs3hvNV(index, n, v);
}

inline void QOpenGLExtension_NV_half_float::glVertexAttribs2hvNV(GLuint index, GLsizei n, const GLhalfNV *v)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->VertexAttribs2hvNV(index, n, v);
}

inline void QOpenGLExtension_NV_half_float::glVertexAttribs1hvNV(GLuint index, GLsizei n, const GLhalfNV *v)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->VertexAttribs1hvNV(index, n, v);
}

inline void QOpenGLExtension_NV_half_float::glVertexAttrib4hvNV(GLuint index, const GLhalfNV *v)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->VertexAttrib4hvNV(index, v);
}

inline void QOpenGLExtension_NV_half_float::glVertexAttrib4hNV(GLuint index, GLhalfNV x, GLhalfNV y, GLhalfNV z, GLhalfNV w)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->VertexAttrib4hNV(index, x, y, z, w);
}

inline void QOpenGLExtension_NV_half_float::glVertexAttrib3hvNV(GLuint index, const GLhalfNV *v)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->VertexAttrib3hvNV(index, v);
}

inline void QOpenGLExtension_NV_half_float::glVertexAttrib3hNV(GLuint index, GLhalfNV x, GLhalfNV y, GLhalfNV z)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->VertexAttrib3hNV(index, x, y, z);
}

inline void QOpenGLExtension_NV_half_float::glVertexAttrib2hvNV(GLuint index, const GLhalfNV *v)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->VertexAttrib2hvNV(index, v);
}

inline void QOpenGLExtension_NV_half_float::glVertexAttrib2hNV(GLuint index, GLhalfNV x, GLhalfNV y)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->VertexAttrib2hNV(index, x, y);
}

inline void QOpenGLExtension_NV_half_float::glVertexAttrib1hvNV(GLuint index, const GLhalfNV *v)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->VertexAttrib1hvNV(index, v);
}

inline void QOpenGLExtension_NV_half_float::glVertexAttrib1hNV(GLuint index, GLhalfNV x)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->VertexAttrib1hNV(index, x);
}

inline void QOpenGLExtension_NV_half_float::glVertexWeighthvNV(const GLhalfNV *weight)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->VertexWeighthvNV(weight);
}

inline void QOpenGLExtension_NV_half_float::glVertexWeighthNV(GLhalfNV weight)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->VertexWeighthNV(weight);
}

inline void QOpenGLExtension_NV_half_float::glSecondaryColor3hvNV(const GLhalfNV *v)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->SecondaryColor3hvNV(v);
}

inline void QOpenGLExtension_NV_half_float::glSecondaryColor3hNV(GLhalfNV red, GLhalfNV green, GLhalfNV blue)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->SecondaryColor3hNV(red, green, blue);
}

inline void QOpenGLExtension_NV_half_float::glFogCoordhvNV(const GLhalfNV *fog)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->FogCoordhvNV(fog);
}

inline void QOpenGLExtension_NV_half_float::glFogCoordhNV(GLhalfNV fog)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->FogCoordhNV(fog);
}

inline void QOpenGLExtension_NV_half_float::glMultiTexCoord4hvNV(GLenum target, const GLhalfNV *v)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->MultiTexCoord4hvNV(target, v);
}

inline void QOpenGLExtension_NV_half_float::glMultiTexCoord4hNV(GLenum target, GLhalfNV s, GLhalfNV t, GLhalfNV r, GLhalfNV q)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->MultiTexCoord4hNV(target, s, t, r, q);
}

inline void QOpenGLExtension_NV_half_float::glMultiTexCoord3hvNV(GLenum target, const GLhalfNV *v)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->MultiTexCoord3hvNV(target, v);
}

inline void QOpenGLExtension_NV_half_float::glMultiTexCoord3hNV(GLenum target, GLhalfNV s, GLhalfNV t, GLhalfNV r)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->MultiTexCoord3hNV(target, s, t, r);
}

inline void QOpenGLExtension_NV_half_float::glMultiTexCoord2hvNV(GLenum target, const GLhalfNV *v)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->MultiTexCoord2hvNV(target, v);
}

inline void QOpenGLExtension_NV_half_float::glMultiTexCoord2hNV(GLenum target, GLhalfNV s, GLhalfNV t)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->MultiTexCoord2hNV(target, s, t);
}

inline void QOpenGLExtension_NV_half_float::glMultiTexCoord1hvNV(GLenum target, const GLhalfNV *v)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->MultiTexCoord1hvNV(target, v);
}

inline void QOpenGLExtension_NV_half_float::glMultiTexCoord1hNV(GLenum target, GLhalfNV s)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->MultiTexCoord1hNV(target, s);
}

inline void QOpenGLExtension_NV_half_float::glTexCoord4hvNV(const GLhalfNV *v)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->TexCoord4hvNV(v);
}

inline void QOpenGLExtension_NV_half_float::glTexCoord4hNV(GLhalfNV s, GLhalfNV t, GLhalfNV r, GLhalfNV q)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->TexCoord4hNV(s, t, r, q);
}

inline void QOpenGLExtension_NV_half_float::glTexCoord3hvNV(const GLhalfNV *v)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->TexCoord3hvNV(v);
}

inline void QOpenGLExtension_NV_half_float::glTexCoord3hNV(GLhalfNV s, GLhalfNV t, GLhalfNV r)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->TexCoord3hNV(s, t, r);
}

inline void QOpenGLExtension_NV_half_float::glTexCoord2hvNV(const GLhalfNV *v)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->TexCoord2hvNV(v);
}

inline void QOpenGLExtension_NV_half_float::glTexCoord2hNV(GLhalfNV s, GLhalfNV t)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->TexCoord2hNV(s, t);
}

inline void QOpenGLExtension_NV_half_float::glTexCoord1hvNV(const GLhalfNV *v)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->TexCoord1hvNV(v);
}

inline void QOpenGLExtension_NV_half_float::glTexCoord1hNV(GLhalfNV s)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->TexCoord1hNV(s);
}

inline void QOpenGLExtension_NV_half_float::glColor4hvNV(const GLhalfNV *v)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->Color4hvNV(v);
}

inline void QOpenGLExtension_NV_half_float::glColor4hNV(GLhalfNV red, GLhalfNV green, GLhalfNV blue, GLhalfNV alpha)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->Color4hNV(red, green, blue, alpha);
}

inline void QOpenGLExtension_NV_half_float::glColor3hvNV(const GLhalfNV *v)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->Color3hvNV(v);
}

inline void QOpenGLExtension_NV_half_float::glColor3hNV(GLhalfNV red, GLhalfNV green, GLhalfNV blue)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->Color3hNV(red, green, blue);
}

inline void QOpenGLExtension_NV_half_float::glNormal3hvNV(const GLhalfNV *v)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->Normal3hvNV(v);
}

inline void QOpenGLExtension_NV_half_float::glNormal3hNV(GLhalfNV nx, GLhalfNV ny, GLhalfNV nz)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->Normal3hNV(nx, ny, nz);
}

inline void QOpenGLExtension_NV_half_float::glVertex4hvNV(const GLhalfNV *v)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->Vertex4hvNV(v);
}

inline void QOpenGLExtension_NV_half_float::glVertex4hNV(GLhalfNV x, GLhalfNV y, GLhalfNV z, GLhalfNV w)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->Vertex4hNV(x, y, z, w);
}

inline void QOpenGLExtension_NV_half_float::glVertex3hvNV(const GLhalfNV *v)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->Vertex3hvNV(v);
}

inline void QOpenGLExtension_NV_half_float::glVertex3hNV(GLhalfNV x, GLhalfNV y, GLhalfNV z)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->Vertex3hNV(x, y, z);
}

inline void QOpenGLExtension_NV_half_float::glVertex2hvNV(const GLhalfNV *v)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->Vertex2hvNV(v);
}

inline void QOpenGLExtension_NV_half_float::glVertex2hNV(GLhalfNV x, GLhalfNV y)
{
    Q_D(QOpenGLExtension_NV_half_float);
    d->Vertex2hNV(x, y);
}

class QOpenGLExtension_NV_occlusion_queryPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetOcclusionQueryuivNV)(GLuint id, GLenum pname, GLuint *params);
    void (QOPENGLF_APIENTRYP GetOcclusionQueryivNV)(GLuint id, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP EndOcclusionQueryNV)();
    void (QOPENGLF_APIENTRYP BeginOcclusionQueryNV)(GLuint id);
    GLboolean (QOPENGLF_APIENTRYP IsOcclusionQueryNV)(GLuint id);
    void (QOPENGLF_APIENTRYP DeleteOcclusionQueriesNV)(GLsizei n, const GLuint *ids);
    void (QOPENGLF_APIENTRYP GenOcclusionQueriesNV)(GLsizei n, GLuint *ids);
};

class QOpenGLExtension_NV_occlusion_query : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_occlusion_query();

    bool initializeOpenGLFunctions() final;

    void glGetOcclusionQueryuivNV(GLuint id, GLenum pname, GLuint *params);
    void glGetOcclusionQueryivNV(GLuint id, GLenum pname, GLint *params);
    void glEndOcclusionQueryNV();
    void glBeginOcclusionQueryNV(GLuint id);
    GLboolean glIsOcclusionQueryNV(GLuint id);
    void glDeleteOcclusionQueriesNV(GLsizei n, const GLuint *ids);
    void glGenOcclusionQueriesNV(GLsizei n, GLuint *ids);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_occlusion_query)
};

inline void QOpenGLExtension_NV_occlusion_query::glGetOcclusionQueryuivNV(GLuint id, GLenum pname, GLuint *params)
{
    Q_D(QOpenGLExtension_NV_occlusion_query);
    d->GetOcclusionQueryuivNV(id, pname, params);
}

inline void QOpenGLExtension_NV_occlusion_query::glGetOcclusionQueryivNV(GLuint id, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_NV_occlusion_query);
    d->GetOcclusionQueryivNV(id, pname, params);
}

inline void QOpenGLExtension_NV_occlusion_query::glEndOcclusionQueryNV()
{
    Q_D(QOpenGLExtension_NV_occlusion_query);
    d->EndOcclusionQueryNV();
}

inline void QOpenGLExtension_NV_occlusion_query::glBeginOcclusionQueryNV(GLuint id)
{
    Q_D(QOpenGLExtension_NV_occlusion_query);
    d->BeginOcclusionQueryNV(id);
}

inline GLboolean QOpenGLExtension_NV_occlusion_query::glIsOcclusionQueryNV(GLuint id)
{
    Q_D(QOpenGLExtension_NV_occlusion_query);
    return d->IsOcclusionQueryNV(id);
}

inline void QOpenGLExtension_NV_occlusion_query::glDeleteOcclusionQueriesNV(GLsizei n, const GLuint *ids)
{
    Q_D(QOpenGLExtension_NV_occlusion_query);
    d->DeleteOcclusionQueriesNV(n, ids);
}

inline void QOpenGLExtension_NV_occlusion_query::glGenOcclusionQueriesNV(GLsizei n, GLuint *ids)
{
    Q_D(QOpenGLExtension_NV_occlusion_query);
    d->GenOcclusionQueriesNV(n, ids);
}

class QOpenGLExtension_NV_parameter_buffer_objectPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP ProgramBufferParametersIuivNV)(GLenum target, GLuint buffer, GLuint index, GLsizei count, const GLuint *params);
    void (QOPENGLF_APIENTRYP ProgramBufferParametersIivNV)(GLenum target, GLuint buffer, GLuint index, GLsizei count, const GLint *params);
    void (QOPENGLF_APIENTRYP ProgramBufferParametersfvNV)(GLenum target, GLuint buffer, GLuint index, GLsizei count, const GLfloat *params);
};

class QOpenGLExtension_NV_parameter_buffer_object : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_parameter_buffer_object();

    bool initializeOpenGLFunctions() final;

    void glProgramBufferParametersIuivNV(GLenum target, GLuint buffer, GLuint index, GLsizei count, const GLuint *params);
    void glProgramBufferParametersIivNV(GLenum target, GLuint buffer, GLuint index, GLsizei count, const GLint *params);
    void glProgramBufferParametersfvNV(GLenum target, GLuint buffer, GLuint index, GLsizei count, const GLfloat *params);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_parameter_buffer_object)
};

inline void QOpenGLExtension_NV_parameter_buffer_object::glProgramBufferParametersIuivNV(GLenum target, GLuint buffer, GLuint index, GLsizei count, const GLuint *params)
{
    Q_D(QOpenGLExtension_NV_parameter_buffer_object);
    d->ProgramBufferParametersIuivNV(target, buffer, index, count, params);
}

inline void QOpenGLExtension_NV_parameter_buffer_object::glProgramBufferParametersIivNV(GLenum target, GLuint buffer, GLuint index, GLsizei count, const GLint *params)
{
    Q_D(QOpenGLExtension_NV_parameter_buffer_object);
    d->ProgramBufferParametersIivNV(target, buffer, index, count, params);
}

inline void QOpenGLExtension_NV_parameter_buffer_object::glProgramBufferParametersfvNV(GLenum target, GLuint buffer, GLuint index, GLsizei count, const GLfloat *params)
{
    Q_D(QOpenGLExtension_NV_parameter_buffer_object);
    d->ProgramBufferParametersfvNV(target, buffer, index, count, params);
}

class QOpenGLExtension_NV_path_renderingPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    GLboolean (QOPENGLF_APIENTRYP PointAlongPathNV)(GLuint path, GLsizei startSegment, GLsizei numSegments, GLfloat distance, GLfloat *x, GLfloat *y, GLfloat *tangentX, GLfloat *tangentY);
    GLfloat (QOPENGLF_APIENTRYP GetPathLengthNV)(GLuint path, GLsizei startSegment, GLsizei numSegments);
    GLboolean (QOPENGLF_APIENTRYP IsPointInStrokePathNV)(GLuint path, GLfloat x, GLfloat y);
    GLboolean (QOPENGLF_APIENTRYP IsPointInFillPathNV)(GLuint path, GLuint mask, GLfloat x, GLfloat y);
    void (QOPENGLF_APIENTRYP GetPathTexGenfvNV)(GLenum texCoordSet, GLenum pname, GLfloat *value);
    void (QOPENGLF_APIENTRYP GetPathTexGenivNV)(GLenum texCoordSet, GLenum pname, GLint *value);
    void (QOPENGLF_APIENTRYP GetPathColorGenfvNV)(GLenum color, GLenum pname, GLfloat *value);
    void (QOPENGLF_APIENTRYP GetPathColorGenivNV)(GLenum color, GLenum pname, GLint *value);
    void (QOPENGLF_APIENTRYP GetPathSpacingNV)(GLenum pathListMode, GLsizei numPaths, GLenum pathNameType, const GLvoid *paths, GLuint pathBase, GLfloat advanceScale, GLfloat kerningScale, GLenum transformType, GLfloat *returnedSpacing);
    void (QOPENGLF_APIENTRYP GetPathMetricRangeNV)(GLbitfield metricQueryMask, GLuint firstPathName, GLsizei numPaths, GLsizei stride, GLfloat *metrics);
    void (QOPENGLF_APIENTRYP GetPathMetricsNV)(GLbitfield metricQueryMask, GLsizei numPaths, GLenum pathNameType, const GLvoid *paths, GLuint pathBase, GLsizei stride, GLfloat *metrics);
    void (QOPENGLF_APIENTRYP GetPathDashArrayNV)(GLuint path, GLfloat *dashArray);
    void (QOPENGLF_APIENTRYP GetPathCoordsNV)(GLuint path, GLfloat *coords);
    void (QOPENGLF_APIENTRYP GetPathCommandsNV)(GLuint path, GLubyte *commands);
    void (QOPENGLF_APIENTRYP GetPathParameterfvNV)(GLuint path, GLenum pname, GLfloat *value);
    void (QOPENGLF_APIENTRYP GetPathParameterivNV)(GLuint path, GLenum pname, GLint *value);
    void (QOPENGLF_APIENTRYP CoverStrokePathInstancedNV)(GLsizei numPaths, GLenum pathNameType, const GLvoid *paths, GLuint pathBase, GLenum coverMode, GLenum transformType, const GLfloat *transformValues);
    void (QOPENGLF_APIENTRYP CoverFillPathInstancedNV)(GLsizei numPaths, GLenum pathNameType, const GLvoid *paths, GLuint pathBase, GLenum coverMode, GLenum transformType, const GLfloat *transformValues);
    void (QOPENGLF_APIENTRYP CoverStrokePathNV)(GLuint path, GLenum coverMode);
    void (QOPENGLF_APIENTRYP CoverFillPathNV)(GLuint path, GLenum coverMode);
    void (QOPENGLF_APIENTRYP PathFogGenNV)(GLenum genMode);
    void (QOPENGLF_APIENTRYP PathTexGenNV)(GLenum texCoordSet, GLenum genMode, GLint components, const GLfloat *coeffs);
    void (QOPENGLF_APIENTRYP PathColorGenNV)(GLenum color, GLenum genMode, GLenum colorFormat, const GLfloat *coeffs);
    void (QOPENGLF_APIENTRYP PathCoverDepthFuncNV)(GLenum func);
    void (QOPENGLF_APIENTRYP StencilStrokePathInstancedNV)(GLsizei numPaths, GLenum pathNameType, const GLvoid *paths, GLuint pathBase, GLint reference, GLuint mask, GLenum transformType, const GLfloat *transformValues);
    void (QOPENGLF_APIENTRYP StencilFillPathInstancedNV)(GLsizei numPaths, GLenum pathNameType, const GLvoid *paths, GLuint pathBase, GLenum fillMode, GLuint mask, GLenum transformType, const GLfloat *transformValues);
    void (QOPENGLF_APIENTRYP StencilStrokePathNV)(GLuint path, GLint reference, GLuint mask);
    void (QOPENGLF_APIENTRYP StencilFillPathNV)(GLuint path, GLenum fillMode, GLuint mask);
    void (QOPENGLF_APIENTRYP PathStencilDepthOffsetNV)(GLfloat factor, GLfloat units);
    void (QOPENGLF_APIENTRYP PathStencilFuncNV)(GLenum func, GLint ref, GLuint mask);
    void (QOPENGLF_APIENTRYP PathDashArrayNV)(GLuint path, GLsizei dashCount, const GLfloat *dashArray);
    void (QOPENGLF_APIENTRYP PathParameterfNV)(GLuint path, GLenum pname, GLfloat value);
    void (QOPENGLF_APIENTRYP PathParameterfvNV)(GLuint path, GLenum pname, const GLfloat *value);
    void (QOPENGLF_APIENTRYP PathParameteriNV)(GLuint path, GLenum pname, GLint value);
    void (QOPENGLF_APIENTRYP PathParameterivNV)(GLuint path, GLenum pname, const GLint *value);
    void (QOPENGLF_APIENTRYP TransformPathNV)(GLuint resultPath, GLuint srcPath, GLenum transformType, const GLfloat *transformValues);
    void (QOPENGLF_APIENTRYP InterpolatePathsNV)(GLuint resultPath, GLuint pathA, GLuint pathB, GLfloat weight);
    void (QOPENGLF_APIENTRYP CopyPathNV)(GLuint resultPath, GLuint srcPath);
    void (QOPENGLF_APIENTRYP WeightPathsNV)(GLuint resultPath, GLsizei numPaths, const GLuint *paths, const GLfloat *weights);
    void (QOPENGLF_APIENTRYP PathGlyphRangeNV)(GLuint firstPathName, GLenum fontTarget, const GLvoid *fontName, GLbitfield fontStyle, GLuint firstGlyph, GLsizei numGlyphs, GLenum handleMissingGlyphs, GLuint pathParameterTemplate, GLfloat emScale);
    void (QOPENGLF_APIENTRYP PathGlyphsNV)(GLuint firstPathName, GLenum fontTarget, const GLvoid *fontName, GLbitfield fontStyle, GLsizei numGlyphs, GLenum type, const GLvoid *charcodes, GLenum handleMissingGlyphs, GLuint pathParameterTemplate, GLfloat emScale);
    void (QOPENGLF_APIENTRYP PathStringNV)(GLuint path, GLenum format, GLsizei length, const GLvoid *pathString);
    void (QOPENGLF_APIENTRYP PathSubCoordsNV)(GLuint path, GLsizei coordStart, GLsizei numCoords, GLenum coordType, const GLvoid *coords);
    void (QOPENGLF_APIENTRYP PathSubCommandsNV)(GLuint path, GLsizei commandStart, GLsizei commandsToDelete, GLsizei numCommands, const GLubyte *commands, GLsizei numCoords, GLenum coordType, const GLvoid *coords);
    void (QOPENGLF_APIENTRYP PathCoordsNV)(GLuint path, GLsizei numCoords, GLenum coordType, const GLvoid *coords);
    void (QOPENGLF_APIENTRYP PathCommandsNV)(GLuint path, GLsizei numCommands, const GLubyte *commands, GLsizei numCoords, GLenum coordType, const GLvoid *coords);
    GLboolean (QOPENGLF_APIENTRYP IsPathNV)(GLuint path);
    void (QOPENGLF_APIENTRYP DeletePathsNV)(GLuint path, GLsizei range);
    GLuint (QOPENGLF_APIENTRYP GenPathsNV)(GLsizei range);
};

class QOpenGLExtension_NV_path_rendering : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_path_rendering();

    bool initializeOpenGLFunctions() final;

    GLboolean glPointAlongPathNV(GLuint path, GLsizei startSegment, GLsizei numSegments, GLfloat distance, GLfloat *x, GLfloat *y, GLfloat *tangentX, GLfloat *tangentY);
    GLfloat glGetPathLengthNV(GLuint path, GLsizei startSegment, GLsizei numSegments);
    GLboolean glIsPointInStrokePathNV(GLuint path, GLfloat x, GLfloat y);
    GLboolean glIsPointInFillPathNV(GLuint path, GLuint mask, GLfloat x, GLfloat y);
    void glGetPathTexGenfvNV(GLenum texCoordSet, GLenum pname, GLfloat *value);
    void glGetPathTexGenivNV(GLenum texCoordSet, GLenum pname, GLint *value);
    void glGetPathColorGenfvNV(GLenum color, GLenum pname, GLfloat *value);
    void glGetPathColorGenivNV(GLenum color, GLenum pname, GLint *value);
    void glGetPathSpacingNV(GLenum pathListMode, GLsizei numPaths, GLenum pathNameType, const GLvoid *paths, GLuint pathBase, GLfloat advanceScale, GLfloat kerningScale, GLenum transformType, GLfloat *returnedSpacing);
    void glGetPathMetricRangeNV(GLbitfield metricQueryMask, GLuint firstPathName, GLsizei numPaths, GLsizei stride, GLfloat *metrics);
    void glGetPathMetricsNV(GLbitfield metricQueryMask, GLsizei numPaths, GLenum pathNameType, const GLvoid *paths, GLuint pathBase, GLsizei stride, GLfloat *metrics);
    void glGetPathDashArrayNV(GLuint path, GLfloat *dashArray);
    void glGetPathCoordsNV(GLuint path, GLfloat *coords);
    void glGetPathCommandsNV(GLuint path, GLubyte *commands);
    void glGetPathParameterfvNV(GLuint path, GLenum pname, GLfloat *value);
    void glGetPathParameterivNV(GLuint path, GLenum pname, GLint *value);
    void glCoverStrokePathInstancedNV(GLsizei numPaths, GLenum pathNameType, const GLvoid *paths, GLuint pathBase, GLenum coverMode, GLenum transformType, const GLfloat *transformValues);
    void glCoverFillPathInstancedNV(GLsizei numPaths, GLenum pathNameType, const GLvoid *paths, GLuint pathBase, GLenum coverMode, GLenum transformType, const GLfloat *transformValues);
    void glCoverStrokePathNV(GLuint path, GLenum coverMode);
    void glCoverFillPathNV(GLuint path, GLenum coverMode);
    void glPathFogGenNV(GLenum genMode);
    void glPathTexGenNV(GLenum texCoordSet, GLenum genMode, GLint components, const GLfloat *coeffs);
    void glPathColorGenNV(GLenum color, GLenum genMode, GLenum colorFormat, const GLfloat *coeffs);
    void glPathCoverDepthFuncNV(GLenum func);
    void glStencilStrokePathInstancedNV(GLsizei numPaths, GLenum pathNameType, const GLvoid *paths, GLuint pathBase, GLint reference, GLuint mask, GLenum transformType, const GLfloat *transformValues);
    void glStencilFillPathInstancedNV(GLsizei numPaths, GLenum pathNameType, const GLvoid *paths, GLuint pathBase, GLenum fillMode, GLuint mask, GLenum transformType, const GLfloat *transformValues);
    void glStencilStrokePathNV(GLuint path, GLint reference, GLuint mask);
    void glStencilFillPathNV(GLuint path, GLenum fillMode, GLuint mask);
    void glPathStencilDepthOffsetNV(GLfloat factor, GLfloat units);
    void glPathStencilFuncNV(GLenum func, GLint ref, GLuint mask);
    void glPathDashArrayNV(GLuint path, GLsizei dashCount, const GLfloat *dashArray);
    void glPathParameterfNV(GLuint path, GLenum pname, GLfloat value);
    void glPathParameterfvNV(GLuint path, GLenum pname, const GLfloat *value);
    void glPathParameteriNV(GLuint path, GLenum pname, GLint value);
    void glPathParameterivNV(GLuint path, GLenum pname, const GLint *value);
    void glTransformPathNV(GLuint resultPath, GLuint srcPath, GLenum transformType, const GLfloat *transformValues);
    void glInterpolatePathsNV(GLuint resultPath, GLuint pathA, GLuint pathB, GLfloat weight);
    void glCopyPathNV(GLuint resultPath, GLuint srcPath);
    void glWeightPathsNV(GLuint resultPath, GLsizei numPaths, const GLuint *paths, const GLfloat *weights);
    void glPathGlyphRangeNV(GLuint firstPathName, GLenum fontTarget, const GLvoid *fontName, GLbitfield fontStyle, GLuint firstGlyph, GLsizei numGlyphs, GLenum handleMissingGlyphs, GLuint pathParameterTemplate, GLfloat emScale);
    void glPathGlyphsNV(GLuint firstPathName, GLenum fontTarget, const GLvoid *fontName, GLbitfield fontStyle, GLsizei numGlyphs, GLenum type, const GLvoid *charcodes, GLenum handleMissingGlyphs, GLuint pathParameterTemplate, GLfloat emScale);
    void glPathStringNV(GLuint path, GLenum format, GLsizei length, const GLvoid *pathString);
    void glPathSubCoordsNV(GLuint path, GLsizei coordStart, GLsizei numCoords, GLenum coordType, const GLvoid *coords);
    void glPathSubCommandsNV(GLuint path, GLsizei commandStart, GLsizei commandsToDelete, GLsizei numCommands, const GLubyte *commands, GLsizei numCoords, GLenum coordType, const GLvoid *coords);
    void glPathCoordsNV(GLuint path, GLsizei numCoords, GLenum coordType, const GLvoid *coords);
    void glPathCommandsNV(GLuint path, GLsizei numCommands, const GLubyte *commands, GLsizei numCoords, GLenum coordType, const GLvoid *coords);
    GLboolean glIsPathNV(GLuint path);
    void glDeletePathsNV(GLuint path, GLsizei range);
    GLuint glGenPathsNV(GLsizei range);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_path_rendering)
};

inline GLboolean QOpenGLExtension_NV_path_rendering::glPointAlongPathNV(GLuint path, GLsizei startSegment, GLsizei numSegments, GLfloat distance, GLfloat *x, GLfloat *y, GLfloat *tangentX, GLfloat *tangentY)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    return d->PointAlongPathNV(path, startSegment, numSegments, distance, x, y, tangentX, tangentY);
}

inline GLfloat QOpenGLExtension_NV_path_rendering::glGetPathLengthNV(GLuint path, GLsizei startSegment, GLsizei numSegments)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    return d->GetPathLengthNV(path, startSegment, numSegments);
}

inline GLboolean QOpenGLExtension_NV_path_rendering::glIsPointInStrokePathNV(GLuint path, GLfloat x, GLfloat y)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    return d->IsPointInStrokePathNV(path, x, y);
}

inline GLboolean QOpenGLExtension_NV_path_rendering::glIsPointInFillPathNV(GLuint path, GLuint mask, GLfloat x, GLfloat y)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    return d->IsPointInFillPathNV(path, mask, x, y);
}

inline void QOpenGLExtension_NV_path_rendering::glGetPathTexGenfvNV(GLenum texCoordSet, GLenum pname, GLfloat *value)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->GetPathTexGenfvNV(texCoordSet, pname, value);
}

inline void QOpenGLExtension_NV_path_rendering::glGetPathTexGenivNV(GLenum texCoordSet, GLenum pname, GLint *value)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->GetPathTexGenivNV(texCoordSet, pname, value);
}

inline void QOpenGLExtension_NV_path_rendering::glGetPathColorGenfvNV(GLenum color, GLenum pname, GLfloat *value)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->GetPathColorGenfvNV(color, pname, value);
}

inline void QOpenGLExtension_NV_path_rendering::glGetPathColorGenivNV(GLenum color, GLenum pname, GLint *value)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->GetPathColorGenivNV(color, pname, value);
}

inline void QOpenGLExtension_NV_path_rendering::glGetPathSpacingNV(GLenum pathListMode, GLsizei numPaths, GLenum pathNameType, const GLvoid *paths, GLuint pathBase, GLfloat advanceScale, GLfloat kerningScale, GLenum transformType, GLfloat *returnedSpacing)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->GetPathSpacingNV(pathListMode, numPaths, pathNameType, paths, pathBase, advanceScale, kerningScale, transformType, returnedSpacing);
}

inline void QOpenGLExtension_NV_path_rendering::glGetPathMetricRangeNV(GLbitfield metricQueryMask, GLuint firstPathName, GLsizei numPaths, GLsizei stride, GLfloat *metrics)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->GetPathMetricRangeNV(metricQueryMask, firstPathName, numPaths, stride, metrics);
}

inline void QOpenGLExtension_NV_path_rendering::glGetPathMetricsNV(GLbitfield metricQueryMask, GLsizei numPaths, GLenum pathNameType, const GLvoid *paths, GLuint pathBase, GLsizei stride, GLfloat *metrics)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->GetPathMetricsNV(metricQueryMask, numPaths, pathNameType, paths, pathBase, stride, metrics);
}

inline void QOpenGLExtension_NV_path_rendering::glGetPathDashArrayNV(GLuint path, GLfloat *dashArray)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->GetPathDashArrayNV(path, dashArray);
}

inline void QOpenGLExtension_NV_path_rendering::glGetPathCoordsNV(GLuint path, GLfloat *coords)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->GetPathCoordsNV(path, coords);
}

inline void QOpenGLExtension_NV_path_rendering::glGetPathCommandsNV(GLuint path, GLubyte *commands)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->GetPathCommandsNV(path, commands);
}

inline void QOpenGLExtension_NV_path_rendering::glGetPathParameterfvNV(GLuint path, GLenum pname, GLfloat *value)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->GetPathParameterfvNV(path, pname, value);
}

inline void QOpenGLExtension_NV_path_rendering::glGetPathParameterivNV(GLuint path, GLenum pname, GLint *value)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->GetPathParameterivNV(path, pname, value);
}

inline void QOpenGLExtension_NV_path_rendering::glCoverStrokePathInstancedNV(GLsizei numPaths, GLenum pathNameType, const GLvoid *paths, GLuint pathBase, GLenum coverMode, GLenum transformType, const GLfloat *transformValues)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->CoverStrokePathInstancedNV(numPaths, pathNameType, paths, pathBase, coverMode, transformType, transformValues);
}

inline void QOpenGLExtension_NV_path_rendering::glCoverFillPathInstancedNV(GLsizei numPaths, GLenum pathNameType, const GLvoid *paths, GLuint pathBase, GLenum coverMode, GLenum transformType, const GLfloat *transformValues)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->CoverFillPathInstancedNV(numPaths, pathNameType, paths, pathBase, coverMode, transformType, transformValues);
}

inline void QOpenGLExtension_NV_path_rendering::glCoverStrokePathNV(GLuint path, GLenum coverMode)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->CoverStrokePathNV(path, coverMode);
}

inline void QOpenGLExtension_NV_path_rendering::glCoverFillPathNV(GLuint path, GLenum coverMode)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->CoverFillPathNV(path, coverMode);
}

inline void QOpenGLExtension_NV_path_rendering::glPathFogGenNV(GLenum genMode)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->PathFogGenNV(genMode);
}

inline void QOpenGLExtension_NV_path_rendering::glPathTexGenNV(GLenum texCoordSet, GLenum genMode, GLint components, const GLfloat *coeffs)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->PathTexGenNV(texCoordSet, genMode, components, coeffs);
}

inline void QOpenGLExtension_NV_path_rendering::glPathColorGenNV(GLenum color, GLenum genMode, GLenum colorFormat, const GLfloat *coeffs)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->PathColorGenNV(color, genMode, colorFormat, coeffs);
}

inline void QOpenGLExtension_NV_path_rendering::glPathCoverDepthFuncNV(GLenum func)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->PathCoverDepthFuncNV(func);
}

inline void QOpenGLExtension_NV_path_rendering::glStencilStrokePathInstancedNV(GLsizei numPaths, GLenum pathNameType, const GLvoid *paths, GLuint pathBase, GLint reference, GLuint mask, GLenum transformType, const GLfloat *transformValues)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->StencilStrokePathInstancedNV(numPaths, pathNameType, paths, pathBase, reference, mask, transformType, transformValues);
}

inline void QOpenGLExtension_NV_path_rendering::glStencilFillPathInstancedNV(GLsizei numPaths, GLenum pathNameType, const GLvoid *paths, GLuint pathBase, GLenum fillMode, GLuint mask, GLenum transformType, const GLfloat *transformValues)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->StencilFillPathInstancedNV(numPaths, pathNameType, paths, pathBase, fillMode, mask, transformType, transformValues);
}

inline void QOpenGLExtension_NV_path_rendering::glStencilStrokePathNV(GLuint path, GLint reference, GLuint mask)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->StencilStrokePathNV(path, reference, mask);
}

inline void QOpenGLExtension_NV_path_rendering::glStencilFillPathNV(GLuint path, GLenum fillMode, GLuint mask)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->StencilFillPathNV(path, fillMode, mask);
}

inline void QOpenGLExtension_NV_path_rendering::glPathStencilDepthOffsetNV(GLfloat factor, GLfloat units)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->PathStencilDepthOffsetNV(factor, units);
}

inline void QOpenGLExtension_NV_path_rendering::glPathStencilFuncNV(GLenum func, GLint ref, GLuint mask)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->PathStencilFuncNV(func, ref, mask);
}

inline void QOpenGLExtension_NV_path_rendering::glPathDashArrayNV(GLuint path, GLsizei dashCount, const GLfloat *dashArray)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->PathDashArrayNV(path, dashCount, dashArray);
}

inline void QOpenGLExtension_NV_path_rendering::glPathParameterfNV(GLuint path, GLenum pname, GLfloat value)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->PathParameterfNV(path, pname, value);
}

inline void QOpenGLExtension_NV_path_rendering::glPathParameterfvNV(GLuint path, GLenum pname, const GLfloat *value)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->PathParameterfvNV(path, pname, value);
}

inline void QOpenGLExtension_NV_path_rendering::glPathParameteriNV(GLuint path, GLenum pname, GLint value)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->PathParameteriNV(path, pname, value);
}

inline void QOpenGLExtension_NV_path_rendering::glPathParameterivNV(GLuint path, GLenum pname, const GLint *value)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->PathParameterivNV(path, pname, value);
}

inline void QOpenGLExtension_NV_path_rendering::glTransformPathNV(GLuint resultPath, GLuint srcPath, GLenum transformType, const GLfloat *transformValues)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->TransformPathNV(resultPath, srcPath, transformType, transformValues);
}

inline void QOpenGLExtension_NV_path_rendering::glInterpolatePathsNV(GLuint resultPath, GLuint pathA, GLuint pathB, GLfloat weight)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->InterpolatePathsNV(resultPath, pathA, pathB, weight);
}

inline void QOpenGLExtension_NV_path_rendering::glCopyPathNV(GLuint resultPath, GLuint srcPath)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->CopyPathNV(resultPath, srcPath);
}

inline void QOpenGLExtension_NV_path_rendering::glWeightPathsNV(GLuint resultPath, GLsizei numPaths, const GLuint *paths, const GLfloat *weights)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->WeightPathsNV(resultPath, numPaths, paths, weights);
}

inline void QOpenGLExtension_NV_path_rendering::glPathGlyphRangeNV(GLuint firstPathName, GLenum fontTarget, const GLvoid *fontName, GLbitfield fontStyle, GLuint firstGlyph, GLsizei numGlyphs, GLenum handleMissingGlyphs, GLuint pathParameterTemplate, GLfloat emScale)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->PathGlyphRangeNV(firstPathName, fontTarget, fontName, fontStyle, firstGlyph, numGlyphs, handleMissingGlyphs, pathParameterTemplate, emScale);
}

inline void QOpenGLExtension_NV_path_rendering::glPathGlyphsNV(GLuint firstPathName, GLenum fontTarget, const GLvoid *fontName, GLbitfield fontStyle, GLsizei numGlyphs, GLenum type, const GLvoid *charcodes, GLenum handleMissingGlyphs, GLuint pathParameterTemplate, GLfloat emScale)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->PathGlyphsNV(firstPathName, fontTarget, fontName, fontStyle, numGlyphs, type, charcodes, handleMissingGlyphs, pathParameterTemplate, emScale);
}

inline void QOpenGLExtension_NV_path_rendering::glPathStringNV(GLuint path, GLenum format, GLsizei length, const GLvoid *pathString)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->PathStringNV(path, format, length, pathString);
}

inline void QOpenGLExtension_NV_path_rendering::glPathSubCoordsNV(GLuint path, GLsizei coordStart, GLsizei numCoords, GLenum coordType, const GLvoid *coords)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->PathSubCoordsNV(path, coordStart, numCoords, coordType, coords);
}

inline void QOpenGLExtension_NV_path_rendering::glPathSubCommandsNV(GLuint path, GLsizei commandStart, GLsizei commandsToDelete, GLsizei numCommands, const GLubyte *commands, GLsizei numCoords, GLenum coordType, const GLvoid *coords)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->PathSubCommandsNV(path, commandStart, commandsToDelete, numCommands, commands, numCoords, coordType, coords);
}

inline void QOpenGLExtension_NV_path_rendering::glPathCoordsNV(GLuint path, GLsizei numCoords, GLenum coordType, const GLvoid *coords)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->PathCoordsNV(path, numCoords, coordType, coords);
}

inline void QOpenGLExtension_NV_path_rendering::glPathCommandsNV(GLuint path, GLsizei numCommands, const GLubyte *commands, GLsizei numCoords, GLenum coordType, const GLvoid *coords)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->PathCommandsNV(path, numCommands, commands, numCoords, coordType, coords);
}

inline GLboolean QOpenGLExtension_NV_path_rendering::glIsPathNV(GLuint path)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    return d->IsPathNV(path);
}

inline void QOpenGLExtension_NV_path_rendering::glDeletePathsNV(GLuint path, GLsizei range)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    d->DeletePathsNV(path, range);
}

inline GLuint QOpenGLExtension_NV_path_rendering::glGenPathsNV(GLsizei range)
{
    Q_D(QOpenGLExtension_NV_path_rendering);
    return d->GenPathsNV(range);
}

class QOpenGLExtension_NV_pixel_data_rangePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP FlushPixelDataRangeNV)(GLenum target);
    void (QOPENGLF_APIENTRYP PixelDataRangeNV)(GLenum target, GLsizei length, const GLvoid *pointer);
};

class QOpenGLExtension_NV_pixel_data_range : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_pixel_data_range();

    bool initializeOpenGLFunctions() final;

    void glFlushPixelDataRangeNV(GLenum target);
    void glPixelDataRangeNV(GLenum target, GLsizei length, const GLvoid *pointer);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_pixel_data_range)
};

inline void QOpenGLExtension_NV_pixel_data_range::glFlushPixelDataRangeNV(GLenum target)
{
    Q_D(QOpenGLExtension_NV_pixel_data_range);
    d->FlushPixelDataRangeNV(target);
}

inline void QOpenGLExtension_NV_pixel_data_range::glPixelDataRangeNV(GLenum target, GLsizei length, const GLvoid *pointer)
{
    Q_D(QOpenGLExtension_NV_pixel_data_range);
    d->PixelDataRangeNV(target, length, pointer);
}

class QOpenGLExtension_NV_point_spritePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP PointParameterivNV)(GLenum pname, const GLint *params);
    void (QOPENGLF_APIENTRYP PointParameteriNV)(GLenum pname, GLint param);
};

class QOpenGLExtension_NV_point_sprite : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_point_sprite();

    bool initializeOpenGLFunctions() final;

    void glPointParameterivNV(GLenum pname, const GLint *params);
    void glPointParameteriNV(GLenum pname, GLint param);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_point_sprite)
};

inline void QOpenGLExtension_NV_point_sprite::glPointParameterivNV(GLenum pname, const GLint *params)
{
    Q_D(QOpenGLExtension_NV_point_sprite);
    d->PointParameterivNV(pname, params);
}

inline void QOpenGLExtension_NV_point_sprite::glPointParameteriNV(GLenum pname, GLint param)
{
    Q_D(QOpenGLExtension_NV_point_sprite);
    d->PointParameteriNV(pname, param);
}

class QOpenGLExtension_NV_present_videoPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetVideoui64vNV)(GLuint video_slot, GLenum pname, GLuint64EXT *params);
    void (QOPENGLF_APIENTRYP GetVideoi64vNV)(GLuint video_slot, GLenum pname, GLint64EXT *params);
    void (QOPENGLF_APIENTRYP GetVideouivNV)(GLuint video_slot, GLenum pname, GLuint *params);
    void (QOPENGLF_APIENTRYP GetVideoivNV)(GLuint video_slot, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP PresentFrameDualFillNV)(GLuint video_slot, GLuint64EXT minPresentTime, GLuint beginPresentTimeId, GLuint presentDurationId, GLenum type, GLenum target0, GLuint fill0, GLenum target1, GLuint fill1, GLenum target2, GLuint fill2, GLenum target3, GLuint fill3);
    void (QOPENGLF_APIENTRYP PresentFrameKeyedNV)(GLuint video_slot, GLuint64EXT minPresentTime, GLuint beginPresentTimeId, GLuint presentDurationId, GLenum type, GLenum target0, GLuint fill0, GLuint key0, GLenum target1, GLuint fill1, GLuint key1);
};

class QOpenGLExtension_NV_present_video : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_present_video();

    bool initializeOpenGLFunctions() final;

    void glGetVideoui64vNV(GLuint video_slot, GLenum pname, GLuint64EXT *params);
    void glGetVideoi64vNV(GLuint video_slot, GLenum pname, GLint64EXT *params);
    void glGetVideouivNV(GLuint video_slot, GLenum pname, GLuint *params);
    void glGetVideoivNV(GLuint video_slot, GLenum pname, GLint *params);
    void glPresentFrameDualFillNV(GLuint video_slot, GLuint64EXT minPresentTime, GLuint beginPresentTimeId, GLuint presentDurationId, GLenum type, GLenum target0, GLuint fill0, GLenum target1, GLuint fill1, GLenum target2, GLuint fill2, GLenum target3, GLuint fill3);
    void glPresentFrameKeyedNV(GLuint video_slot, GLuint64EXT minPresentTime, GLuint beginPresentTimeId, GLuint presentDurationId, GLenum type, GLenum target0, GLuint fill0, GLuint key0, GLenum target1, GLuint fill1, GLuint key1);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_present_video)
};

inline void QOpenGLExtension_NV_present_video::glGetVideoui64vNV(GLuint video_slot, GLenum pname, GLuint64EXT *params)
{
    Q_D(QOpenGLExtension_NV_present_video);
    d->GetVideoui64vNV(video_slot, pname, params);
}

inline void QOpenGLExtension_NV_present_video::glGetVideoi64vNV(GLuint video_slot, GLenum pname, GLint64EXT *params)
{
    Q_D(QOpenGLExtension_NV_present_video);
    d->GetVideoi64vNV(video_slot, pname, params);
}

inline void QOpenGLExtension_NV_present_video::glGetVideouivNV(GLuint video_slot, GLenum pname, GLuint *params)
{
    Q_D(QOpenGLExtension_NV_present_video);
    d->GetVideouivNV(video_slot, pname, params);
}

inline void QOpenGLExtension_NV_present_video::glGetVideoivNV(GLuint video_slot, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_NV_present_video);
    d->GetVideoivNV(video_slot, pname, params);
}

inline void QOpenGLExtension_NV_present_video::glPresentFrameDualFillNV(GLuint video_slot, GLuint64EXT minPresentTime, GLuint beginPresentTimeId, GLuint presentDurationId, GLenum type, GLenum target0, GLuint fill0, GLenum target1, GLuint fill1, GLenum target2, GLuint fill2, GLenum target3, GLuint fill3)
{
    Q_D(QOpenGLExtension_NV_present_video);
    d->PresentFrameDualFillNV(video_slot, minPresentTime, beginPresentTimeId, presentDurationId, type, target0, fill0, target1, fill1, target2, fill2, target3, fill3);
}

inline void QOpenGLExtension_NV_present_video::glPresentFrameKeyedNV(GLuint video_slot, GLuint64EXT minPresentTime, GLuint beginPresentTimeId, GLuint presentDurationId, GLenum type, GLenum target0, GLuint fill0, GLuint key0, GLenum target1, GLuint fill1, GLuint key1)
{
    Q_D(QOpenGLExtension_NV_present_video);
    d->PresentFrameKeyedNV(video_slot, minPresentTime, beginPresentTimeId, presentDurationId, type, target0, fill0, key0, target1, fill1, key1);
}

class QOpenGLExtension_NV_primitive_restartPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP PrimitiveRestartIndexNV)(GLuint index);
    void (QOPENGLF_APIENTRYP PrimitiveRestartNV)();
};

class QOpenGLExtension_NV_primitive_restart : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_primitive_restart();

    bool initializeOpenGLFunctions() final;

    void glPrimitiveRestartIndexNV(GLuint index);
    void glPrimitiveRestartNV();

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_primitive_restart)
};

inline void QOpenGLExtension_NV_primitive_restart::glPrimitiveRestartIndexNV(GLuint index)
{
    Q_D(QOpenGLExtension_NV_primitive_restart);
    d->PrimitiveRestartIndexNV(index);
}

inline void QOpenGLExtension_NV_primitive_restart::glPrimitiveRestartNV()
{
    Q_D(QOpenGLExtension_NV_primitive_restart);
    d->PrimitiveRestartNV();
}

class QOpenGLExtension_NV_register_combinersPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetFinalCombinerInputParameterivNV)(GLenum variable, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetFinalCombinerInputParameterfvNV)(GLenum variable, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP GetCombinerOutputParameterivNV)(GLenum stage, GLenum portion, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetCombinerOutputParameterfvNV)(GLenum stage, GLenum portion, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP GetCombinerInputParameterivNV)(GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetCombinerInputParameterfvNV)(GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP FinalCombinerInputNV)(GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage);
    void (QOPENGLF_APIENTRYP CombinerOutputNV)(GLenum stage, GLenum portion, GLenum abOutput, GLenum cdOutput, GLenum sumOutput, GLenum scale, GLenum bias, GLboolean abDotProduct, GLboolean cdDotProduct, GLboolean muxSum);
    void (QOPENGLF_APIENTRYP CombinerInputNV)(GLenum stage, GLenum portion, GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage);
    void (QOPENGLF_APIENTRYP CombinerParameteriNV)(GLenum pname, GLint param);
    void (QOPENGLF_APIENTRYP CombinerParameterivNV)(GLenum pname, const GLint *params);
    void (QOPENGLF_APIENTRYP CombinerParameterfNV)(GLenum pname, GLfloat param);
    void (QOPENGLF_APIENTRYP CombinerParameterfvNV)(GLenum pname, const GLfloat *params);
};

class QOpenGLExtension_NV_register_combiners : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_register_combiners();

    bool initializeOpenGLFunctions() final;

    void glGetFinalCombinerInputParameterivNV(GLenum variable, GLenum pname, GLint *params);
    void glGetFinalCombinerInputParameterfvNV(GLenum variable, GLenum pname, GLfloat *params);
    void glGetCombinerOutputParameterivNV(GLenum stage, GLenum portion, GLenum pname, GLint *params);
    void glGetCombinerOutputParameterfvNV(GLenum stage, GLenum portion, GLenum pname, GLfloat *params);
    void glGetCombinerInputParameterivNV(GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLint *params);
    void glGetCombinerInputParameterfvNV(GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLfloat *params);
    void glFinalCombinerInputNV(GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage);
    void glCombinerOutputNV(GLenum stage, GLenum portion, GLenum abOutput, GLenum cdOutput, GLenum sumOutput, GLenum scale, GLenum bias, GLboolean abDotProduct, GLboolean cdDotProduct, GLboolean muxSum);
    void glCombinerInputNV(GLenum stage, GLenum portion, GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage);
    void glCombinerParameteriNV(GLenum pname, GLint param);
    void glCombinerParameterivNV(GLenum pname, const GLint *params);
    void glCombinerParameterfNV(GLenum pname, GLfloat param);
    void glCombinerParameterfvNV(GLenum pname, const GLfloat *params);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_register_combiners)
};

inline void QOpenGLExtension_NV_register_combiners::glGetFinalCombinerInputParameterivNV(GLenum variable, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_NV_register_combiners);
    d->GetFinalCombinerInputParameterivNV(variable, pname, params);
}

inline void QOpenGLExtension_NV_register_combiners::glGetFinalCombinerInputParameterfvNV(GLenum variable, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_NV_register_combiners);
    d->GetFinalCombinerInputParameterfvNV(variable, pname, params);
}

inline void QOpenGLExtension_NV_register_combiners::glGetCombinerOutputParameterivNV(GLenum stage, GLenum portion, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_NV_register_combiners);
    d->GetCombinerOutputParameterivNV(stage, portion, pname, params);
}

inline void QOpenGLExtension_NV_register_combiners::glGetCombinerOutputParameterfvNV(GLenum stage, GLenum portion, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_NV_register_combiners);
    d->GetCombinerOutputParameterfvNV(stage, portion, pname, params);
}

inline void QOpenGLExtension_NV_register_combiners::glGetCombinerInputParameterivNV(GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_NV_register_combiners);
    d->GetCombinerInputParameterivNV(stage, portion, variable, pname, params);
}

inline void QOpenGLExtension_NV_register_combiners::glGetCombinerInputParameterfvNV(GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_NV_register_combiners);
    d->GetCombinerInputParameterfvNV(stage, portion, variable, pname, params);
}

inline void QOpenGLExtension_NV_register_combiners::glFinalCombinerInputNV(GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage)
{
    Q_D(QOpenGLExtension_NV_register_combiners);
    d->FinalCombinerInputNV(variable, input, mapping, componentUsage);
}

inline void QOpenGLExtension_NV_register_combiners::glCombinerOutputNV(GLenum stage, GLenum portion, GLenum abOutput, GLenum cdOutput, GLenum sumOutput, GLenum scale, GLenum bias, GLboolean abDotProduct, GLboolean cdDotProduct, GLboolean muxSum)
{
    Q_D(QOpenGLExtension_NV_register_combiners);
    d->CombinerOutputNV(stage, portion, abOutput, cdOutput, sumOutput, scale, bias, abDotProduct, cdDotProduct, muxSum);
}

inline void QOpenGLExtension_NV_register_combiners::glCombinerInputNV(GLenum stage, GLenum portion, GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage)
{
    Q_D(QOpenGLExtension_NV_register_combiners);
    d->CombinerInputNV(stage, portion, variable, input, mapping, componentUsage);
}

inline void QOpenGLExtension_NV_register_combiners::glCombinerParameteriNV(GLenum pname, GLint param)
{
    Q_D(QOpenGLExtension_NV_register_combiners);
    d->CombinerParameteriNV(pname, param);
}

inline void QOpenGLExtension_NV_register_combiners::glCombinerParameterivNV(GLenum pname, const GLint *params)
{
    Q_D(QOpenGLExtension_NV_register_combiners);
    d->CombinerParameterivNV(pname, params);
}

inline void QOpenGLExtension_NV_register_combiners::glCombinerParameterfNV(GLenum pname, GLfloat param)
{
    Q_D(QOpenGLExtension_NV_register_combiners);
    d->CombinerParameterfNV(pname, param);
}

inline void QOpenGLExtension_NV_register_combiners::glCombinerParameterfvNV(GLenum pname, const GLfloat *params)
{
    Q_D(QOpenGLExtension_NV_register_combiners);
    d->CombinerParameterfvNV(pname, params);
}

class QOpenGLExtension_NV_register_combiners2Private : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetCombinerStageParameterfvNV)(GLenum stage, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP CombinerStageParameterfvNV)(GLenum stage, GLenum pname, const GLfloat *params);
};

class QOpenGLExtension_NV_register_combiners2 : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_register_combiners2();

    bool initializeOpenGLFunctions() final;

    void glGetCombinerStageParameterfvNV(GLenum stage, GLenum pname, GLfloat *params);
    void glCombinerStageParameterfvNV(GLenum stage, GLenum pname, const GLfloat *params);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_register_combiners2)
};

inline void QOpenGLExtension_NV_register_combiners2::glGetCombinerStageParameterfvNV(GLenum stage, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_NV_register_combiners2);
    d->GetCombinerStageParameterfvNV(stage, pname, params);
}

inline void QOpenGLExtension_NV_register_combiners2::glCombinerStageParameterfvNV(GLenum stage, GLenum pname, const GLfloat *params)
{
    Q_D(QOpenGLExtension_NV_register_combiners2);
    d->CombinerStageParameterfvNV(stage, pname, params);
}

class QOpenGLExtension_NV_shader_buffer_loadPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP ProgramUniformui64vNV)(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value);
    void (QOPENGLF_APIENTRYP ProgramUniformui64NV)(GLuint program, GLint location, GLuint64EXT value);
    void (QOPENGLF_APIENTRYP GetUniformui64vNV)(GLuint program, GLint location, GLuint64EXT *params);
    void (QOPENGLF_APIENTRYP Uniformui64vNV)(GLint location, GLsizei count, const GLuint64EXT *value);
    void (QOPENGLF_APIENTRYP Uniformui64NV)(GLint location, GLuint64EXT value);
    void (QOPENGLF_APIENTRYP GetIntegerui64vNV)(GLenum value, GLuint64EXT *result);
    void (QOPENGLF_APIENTRYP GetNamedBufferParameterui64vNV)(GLuint buffer, GLenum pname, GLuint64EXT *params);
    void (QOPENGLF_APIENTRYP GetBufferParameterui64vNV)(GLenum target, GLenum pname, GLuint64EXT *params);
    GLboolean (QOPENGLF_APIENTRYP IsNamedBufferResidentNV)(GLuint buffer);
    void (QOPENGLF_APIENTRYP MakeNamedBufferNonResidentNV)(GLuint buffer);
    void (QOPENGLF_APIENTRYP MakeNamedBufferResidentNV)(GLuint buffer, GLenum access);
    GLboolean (QOPENGLF_APIENTRYP IsBufferResidentNV)(GLenum target);
    void (QOPENGLF_APIENTRYP MakeBufferNonResidentNV)(GLenum target);
    void (QOPENGLF_APIENTRYP MakeBufferResidentNV)(GLenum target, GLenum access);
};

class QOpenGLExtension_NV_shader_buffer_load : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_shader_buffer_load();

    bool initializeOpenGLFunctions() final;

    void glProgramUniformui64vNV(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value);
    void glProgramUniformui64NV(GLuint program, GLint location, GLuint64EXT value);
    void glGetUniformui64vNV(GLuint program, GLint location, GLuint64EXT *params);
    void glUniformui64vNV(GLint location, GLsizei count, const GLuint64EXT *value);
    void glUniformui64NV(GLint location, GLuint64EXT value);
    void glGetIntegerui64vNV(GLenum value, GLuint64EXT *result);
    void glGetNamedBufferParameterui64vNV(GLuint buffer, GLenum pname, GLuint64EXT *params);
    void glGetBufferParameterui64vNV(GLenum target, GLenum pname, GLuint64EXT *params);
    GLboolean glIsNamedBufferResidentNV(GLuint buffer);
    void glMakeNamedBufferNonResidentNV(GLuint buffer);
    void glMakeNamedBufferResidentNV(GLuint buffer, GLenum access);
    GLboolean glIsBufferResidentNV(GLenum target);
    void glMakeBufferNonResidentNV(GLenum target);
    void glMakeBufferResidentNV(GLenum target, GLenum access);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_shader_buffer_load)
};

inline void QOpenGLExtension_NV_shader_buffer_load::glProgramUniformui64vNV(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value)
{
    Q_D(QOpenGLExtension_NV_shader_buffer_load);
    d->ProgramUniformui64vNV(program, location, count, value);
}

inline void QOpenGLExtension_NV_shader_buffer_load::glProgramUniformui64NV(GLuint program, GLint location, GLuint64EXT value)
{
    Q_D(QOpenGLExtension_NV_shader_buffer_load);
    d->ProgramUniformui64NV(program, location, value);
}

inline void QOpenGLExtension_NV_shader_buffer_load::glGetUniformui64vNV(GLuint program, GLint location, GLuint64EXT *params)
{
    Q_D(QOpenGLExtension_NV_shader_buffer_load);
    d->GetUniformui64vNV(program, location, params);
}

inline void QOpenGLExtension_NV_shader_buffer_load::glUniformui64vNV(GLint location, GLsizei count, const GLuint64EXT *value)
{
    Q_D(QOpenGLExtension_NV_shader_buffer_load);
    d->Uniformui64vNV(location, count, value);
}

inline void QOpenGLExtension_NV_shader_buffer_load::glUniformui64NV(GLint location, GLuint64EXT value)
{
    Q_D(QOpenGLExtension_NV_shader_buffer_load);
    d->Uniformui64NV(location, value);
}

inline void QOpenGLExtension_NV_shader_buffer_load::glGetIntegerui64vNV(GLenum value, GLuint64EXT *result)
{
    Q_D(QOpenGLExtension_NV_shader_buffer_load);
    d->GetIntegerui64vNV(value, result);
}

inline void QOpenGLExtension_NV_shader_buffer_load::glGetNamedBufferParameterui64vNV(GLuint buffer, GLenum pname, GLuint64EXT *params)
{
    Q_D(QOpenGLExtension_NV_shader_buffer_load);
    d->GetNamedBufferParameterui64vNV(buffer, pname, params);
}

inline void QOpenGLExtension_NV_shader_buffer_load::glGetBufferParameterui64vNV(GLenum target, GLenum pname, GLuint64EXT *params)
{
    Q_D(QOpenGLExtension_NV_shader_buffer_load);
    d->GetBufferParameterui64vNV(target, pname, params);
}

inline GLboolean QOpenGLExtension_NV_shader_buffer_load::glIsNamedBufferResidentNV(GLuint buffer)
{
    Q_D(QOpenGLExtension_NV_shader_buffer_load);
    return d->IsNamedBufferResidentNV(buffer);
}

inline void QOpenGLExtension_NV_shader_buffer_load::glMakeNamedBufferNonResidentNV(GLuint buffer)
{
    Q_D(QOpenGLExtension_NV_shader_buffer_load);
    d->MakeNamedBufferNonResidentNV(buffer);
}

inline void QOpenGLExtension_NV_shader_buffer_load::glMakeNamedBufferResidentNV(GLuint buffer, GLenum access)
{
    Q_D(QOpenGLExtension_NV_shader_buffer_load);
    d->MakeNamedBufferResidentNV(buffer, access);
}

inline GLboolean QOpenGLExtension_NV_shader_buffer_load::glIsBufferResidentNV(GLenum target)
{
    Q_D(QOpenGLExtension_NV_shader_buffer_load);
    return d->IsBufferResidentNV(target);
}

inline void QOpenGLExtension_NV_shader_buffer_load::glMakeBufferNonResidentNV(GLenum target)
{
    Q_D(QOpenGLExtension_NV_shader_buffer_load);
    d->MakeBufferNonResidentNV(target);
}

inline void QOpenGLExtension_NV_shader_buffer_load::glMakeBufferResidentNV(GLenum target, GLenum access)
{
    Q_D(QOpenGLExtension_NV_shader_buffer_load);
    d->MakeBufferResidentNV(target, access);
}

class QOpenGLExtension_NV_texture_barrierPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP TextureBarrierNV)();
};

class QOpenGLExtension_NV_texture_barrier : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_texture_barrier();

    bool initializeOpenGLFunctions() final;

    void glTextureBarrierNV();

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_texture_barrier)
};

inline void QOpenGLExtension_NV_texture_barrier::glTextureBarrierNV()
{
    Q_D(QOpenGLExtension_NV_texture_barrier);
    d->TextureBarrierNV();
}

class QOpenGLExtension_NV_texture_multisamplePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP TextureImage3DMultisampleCoverageNV)(GLuint texture, GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations);
    void (QOPENGLF_APIENTRYP TextureImage2DMultisampleCoverageNV)(GLuint texture, GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations);
    void (QOPENGLF_APIENTRYP TextureImage3DMultisampleNV)(GLuint texture, GLenum target, GLsizei samples, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations);
    void (QOPENGLF_APIENTRYP TextureImage2DMultisampleNV)(GLuint texture, GLenum target, GLsizei samples, GLint internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations);
    void (QOPENGLF_APIENTRYP TexImage3DMultisampleCoverageNV)(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations);
    void (QOPENGLF_APIENTRYP TexImage2DMultisampleCoverageNV)(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations);
};

class QOpenGLExtension_NV_texture_multisample : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_texture_multisample();

    bool initializeOpenGLFunctions() final;

    void glTextureImage3DMultisampleCoverageNV(GLuint texture, GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations);
    void glTextureImage2DMultisampleCoverageNV(GLuint texture, GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations);
    void glTextureImage3DMultisampleNV(GLuint texture, GLenum target, GLsizei samples, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations);
    void glTextureImage2DMultisampleNV(GLuint texture, GLenum target, GLsizei samples, GLint internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations);
    void glTexImage3DMultisampleCoverageNV(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations);
    void glTexImage2DMultisampleCoverageNV(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_texture_multisample)
};

inline void QOpenGLExtension_NV_texture_multisample::glTextureImage3DMultisampleCoverageNV(GLuint texture, GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations)
{
    Q_D(QOpenGLExtension_NV_texture_multisample);
    d->TextureImage3DMultisampleCoverageNV(texture, target, coverageSamples, colorSamples, internalFormat, width, height, depth, fixedSampleLocations);
}

inline void QOpenGLExtension_NV_texture_multisample::glTextureImage2DMultisampleCoverageNV(GLuint texture, GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations)
{
    Q_D(QOpenGLExtension_NV_texture_multisample);
    d->TextureImage2DMultisampleCoverageNV(texture, target, coverageSamples, colorSamples, internalFormat, width, height, fixedSampleLocations);
}

inline void QOpenGLExtension_NV_texture_multisample::glTextureImage3DMultisampleNV(GLuint texture, GLenum target, GLsizei samples, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations)
{
    Q_D(QOpenGLExtension_NV_texture_multisample);
    d->TextureImage3DMultisampleNV(texture, target, samples, internalFormat, width, height, depth, fixedSampleLocations);
}

inline void QOpenGLExtension_NV_texture_multisample::glTextureImage2DMultisampleNV(GLuint texture, GLenum target, GLsizei samples, GLint internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations)
{
    Q_D(QOpenGLExtension_NV_texture_multisample);
    d->TextureImage2DMultisampleNV(texture, target, samples, internalFormat, width, height, fixedSampleLocations);
}

inline void QOpenGLExtension_NV_texture_multisample::glTexImage3DMultisampleCoverageNV(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations)
{
    Q_D(QOpenGLExtension_NV_texture_multisample);
    d->TexImage3DMultisampleCoverageNV(target, coverageSamples, colorSamples, internalFormat, width, height, depth, fixedSampleLocations);
}

inline void QOpenGLExtension_NV_texture_multisample::glTexImage2DMultisampleCoverageNV(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations)
{
    Q_D(QOpenGLExtension_NV_texture_multisample);
    d->TexImage2DMultisampleCoverageNV(target, coverageSamples, colorSamples, internalFormat, width, height, fixedSampleLocations);
}

class QOpenGLExtension_NV_transform_feedbackPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP TransformFeedbackStreamAttribsNV)(GLsizei count, const GLint *attribs, GLsizei nbuffers, const GLint *bufstreams, GLenum bufferMode);
    void (QOPENGLF_APIENTRYP GetTransformFeedbackVaryingNV)(GLuint program, GLuint index, GLint *location);
    void (QOPENGLF_APIENTRYP GetActiveVaryingNV)(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name);
    GLint (QOPENGLF_APIENTRYP GetVaryingLocationNV)(GLuint program, const GLchar *name);
    void (QOPENGLF_APIENTRYP ActiveVaryingNV)(GLuint program, const GLchar *name);
    void (QOPENGLF_APIENTRYP TransformFeedbackVaryingsNV)(GLuint program, GLsizei count, const GLint *locations, GLenum bufferMode);
    void (QOPENGLF_APIENTRYP BindBufferBaseNV)(GLenum target, GLuint index, GLuint buffer);
    void (QOPENGLF_APIENTRYP BindBufferOffsetNV)(GLenum target, GLuint index, GLuint buffer, GLintptr offset);
    void (QOPENGLF_APIENTRYP BindBufferRangeNV)(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size);
    void (QOPENGLF_APIENTRYP TransformFeedbackAttribsNV)(GLuint count, const GLint *attribs, GLenum bufferMode);
    void (QOPENGLF_APIENTRYP EndTransformFeedbackNV)();
    void (QOPENGLF_APIENTRYP BeginTransformFeedbackNV)(GLenum primitiveMode);
};

class QOpenGLExtension_NV_transform_feedback : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_transform_feedback();

    bool initializeOpenGLFunctions() final;

    void glTransformFeedbackStreamAttribsNV(GLsizei count, const GLint *attribs, GLsizei nbuffers, const GLint *bufstreams, GLenum bufferMode);
    void glGetTransformFeedbackVaryingNV(GLuint program, GLuint index, GLint *location);
    void glGetActiveVaryingNV(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name);
    GLint glGetVaryingLocationNV(GLuint program, const GLchar *name);
    void glActiveVaryingNV(GLuint program, const GLchar *name);
    void glTransformFeedbackVaryingsNV(GLuint program, GLsizei count, const GLint *locations, GLenum bufferMode);
    void glBindBufferBaseNV(GLenum target, GLuint index, GLuint buffer);
    void glBindBufferOffsetNV(GLenum target, GLuint index, GLuint buffer, GLintptr offset);
    void glBindBufferRangeNV(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size);
    void glTransformFeedbackAttribsNV(GLuint count, const GLint *attribs, GLenum bufferMode);
    void glEndTransformFeedbackNV();
    void glBeginTransformFeedbackNV(GLenum primitiveMode);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_transform_feedback)
};

inline void QOpenGLExtension_NV_transform_feedback::glTransformFeedbackStreamAttribsNV(GLsizei count, const GLint *attribs, GLsizei nbuffers, const GLint *bufstreams, GLenum bufferMode)
{
    Q_D(QOpenGLExtension_NV_transform_feedback);
    d->TransformFeedbackStreamAttribsNV(count, attribs, nbuffers, bufstreams, bufferMode);
}

inline void QOpenGLExtension_NV_transform_feedback::glGetTransformFeedbackVaryingNV(GLuint program, GLuint index, GLint *location)
{
    Q_D(QOpenGLExtension_NV_transform_feedback);
    d->GetTransformFeedbackVaryingNV(program, index, location);
}

inline void QOpenGLExtension_NV_transform_feedback::glGetActiveVaryingNV(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name)
{
    Q_D(QOpenGLExtension_NV_transform_feedback);
    d->GetActiveVaryingNV(program, index, bufSize, length, size, type, name);
}

inline GLint QOpenGLExtension_NV_transform_feedback::glGetVaryingLocationNV(GLuint program, const GLchar *name)
{
    Q_D(QOpenGLExtension_NV_transform_feedback);
    return d->GetVaryingLocationNV(program, name);
}

inline void QOpenGLExtension_NV_transform_feedback::glActiveVaryingNV(GLuint program, const GLchar *name)
{
    Q_D(QOpenGLExtension_NV_transform_feedback);
    d->ActiveVaryingNV(program, name);
}

inline void QOpenGLExtension_NV_transform_feedback::glTransformFeedbackVaryingsNV(GLuint program, GLsizei count, const GLint *locations, GLenum bufferMode)
{
    Q_D(QOpenGLExtension_NV_transform_feedback);
    d->TransformFeedbackVaryingsNV(program, count, locations, bufferMode);
}

inline void QOpenGLExtension_NV_transform_feedback::glBindBufferBaseNV(GLenum target, GLuint index, GLuint buffer)
{
    Q_D(QOpenGLExtension_NV_transform_feedback);
    d->BindBufferBaseNV(target, index, buffer);
}

inline void QOpenGLExtension_NV_transform_feedback::glBindBufferOffsetNV(GLenum target, GLuint index, GLuint buffer, GLintptr offset)
{
    Q_D(QOpenGLExtension_NV_transform_feedback);
    d->BindBufferOffsetNV(target, index, buffer, offset);
}

inline void QOpenGLExtension_NV_transform_feedback::glBindBufferRangeNV(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size)
{
    Q_D(QOpenGLExtension_NV_transform_feedback);
    d->BindBufferRangeNV(target, index, buffer, offset, size);
}

inline void QOpenGLExtension_NV_transform_feedback::glTransformFeedbackAttribsNV(GLuint count, const GLint *attribs, GLenum bufferMode)
{
    Q_D(QOpenGLExtension_NV_transform_feedback);
    d->TransformFeedbackAttribsNV(count, attribs, bufferMode);
}

inline void QOpenGLExtension_NV_transform_feedback::glEndTransformFeedbackNV()
{
    Q_D(QOpenGLExtension_NV_transform_feedback);
    d->EndTransformFeedbackNV();
}

inline void QOpenGLExtension_NV_transform_feedback::glBeginTransformFeedbackNV(GLenum primitiveMode)
{
    Q_D(QOpenGLExtension_NV_transform_feedback);
    d->BeginTransformFeedbackNV(primitiveMode);
}

class QOpenGLExtension_NV_transform_feedback2Private : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP DrawTransformFeedbackNV)(GLenum mode, GLuint id);
    void (QOPENGLF_APIENTRYP ResumeTransformFeedbackNV)();
    void (QOPENGLF_APIENTRYP PauseTransformFeedbackNV)();
    GLboolean (QOPENGLF_APIENTRYP IsTransformFeedbackNV)(GLuint id);
    void (QOPENGLF_APIENTRYP GenTransformFeedbacksNV)(GLsizei n, GLuint *ids);
    void (QOPENGLF_APIENTRYP DeleteTransformFeedbacksNV)(GLsizei n, const GLuint *ids);
    void (QOPENGLF_APIENTRYP BindTransformFeedbackNV)(GLenum target, GLuint id);
};

class QOpenGLExtension_NV_transform_feedback2 : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_transform_feedback2();

    bool initializeOpenGLFunctions() final;

    void glDrawTransformFeedbackNV(GLenum mode, GLuint id);
    void glResumeTransformFeedbackNV();
    void glPauseTransformFeedbackNV();
    GLboolean glIsTransformFeedbackNV(GLuint id);
    void glGenTransformFeedbacksNV(GLsizei n, GLuint *ids);
    void glDeleteTransformFeedbacksNV(GLsizei n, const GLuint *ids);
    void glBindTransformFeedbackNV(GLenum target, GLuint id);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_transform_feedback2)
};

inline void QOpenGLExtension_NV_transform_feedback2::glDrawTransformFeedbackNV(GLenum mode, GLuint id)
{
    Q_D(QOpenGLExtension_NV_transform_feedback2);
    d->DrawTransformFeedbackNV(mode, id);
}

inline void QOpenGLExtension_NV_transform_feedback2::glResumeTransformFeedbackNV()
{
    Q_D(QOpenGLExtension_NV_transform_feedback2);
    d->ResumeTransformFeedbackNV();
}

inline void QOpenGLExtension_NV_transform_feedback2::glPauseTransformFeedbackNV()
{
    Q_D(QOpenGLExtension_NV_transform_feedback2);
    d->PauseTransformFeedbackNV();
}

inline GLboolean QOpenGLExtension_NV_transform_feedback2::glIsTransformFeedbackNV(GLuint id)
{
    Q_D(QOpenGLExtension_NV_transform_feedback2);
    return d->IsTransformFeedbackNV(id);
}

inline void QOpenGLExtension_NV_transform_feedback2::glGenTransformFeedbacksNV(GLsizei n, GLuint *ids)
{
    Q_D(QOpenGLExtension_NV_transform_feedback2);
    d->GenTransformFeedbacksNV(n, ids);
}

inline void QOpenGLExtension_NV_transform_feedback2::glDeleteTransformFeedbacksNV(GLsizei n, const GLuint *ids)
{
    Q_D(QOpenGLExtension_NV_transform_feedback2);
    d->DeleteTransformFeedbacksNV(n, ids);
}

inline void QOpenGLExtension_NV_transform_feedback2::glBindTransformFeedbackNV(GLenum target, GLuint id)
{
    Q_D(QOpenGLExtension_NV_transform_feedback2);
    d->BindTransformFeedbackNV(target, id);
}

class QOpenGLExtension_NV_vdpau_interopPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP VDPAUUnmapSurfacesNV)(GLsizei numSurface, const GLvdpauSurfaceNV *surfaces);
    void (QOPENGLF_APIENTRYP VDPAUMapSurfacesNV)(GLsizei numSurfaces, const GLvdpauSurfaceNV *surfaces);
    void (QOPENGLF_APIENTRYP VDPAUSurfaceAccessNV)(GLvdpauSurfaceNV surface, GLenum access);
    void (QOPENGLF_APIENTRYP VDPAUGetSurfaceivNV)(GLvdpauSurfaceNV surface, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values);
    void (QOPENGLF_APIENTRYP VDPAUUnregisterSurfaceNV)(GLvdpauSurfaceNV surface);
    void (QOPENGLF_APIENTRYP VDPAUIsSurfaceNV)(GLvdpauSurfaceNV surface);
    GLvdpauSurfaceNV (QOPENGLF_APIENTRYP VDPAURegisterOutputSurfaceNV)(GLvoid *vdpSurface, GLenum target, GLsizei numTextureNames, const GLuint *textureNames);
    GLvdpauSurfaceNV (QOPENGLF_APIENTRYP VDPAURegisterVideoSurfaceNV)(const GLvoid *vdpSurface, GLenum target, GLsizei numTextureNames, const GLuint *textureNames);
    void (QOPENGLF_APIENTRYP VDPAUFiniNV)();
    void (QOPENGLF_APIENTRYP VDPAUInitNV)(const GLvoid *vdpDevice, const GLvoid *getProcAddress);
};

class QOpenGLExtension_NV_vdpau_interop : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_vdpau_interop();

    bool initializeOpenGLFunctions() final;

    void glVDPAUUnmapSurfacesNV(GLsizei numSurface, const GLvdpauSurfaceNV *surfaces);
    void glVDPAUMapSurfacesNV(GLsizei numSurfaces, const GLvdpauSurfaceNV *surfaces);
    void glVDPAUSurfaceAccessNV(GLvdpauSurfaceNV surface, GLenum access);
    void glVDPAUGetSurfaceivNV(GLvdpauSurfaceNV surface, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values);
    void glVDPAUUnregisterSurfaceNV(GLvdpauSurfaceNV surface);
    void glVDPAUIsSurfaceNV(GLvdpauSurfaceNV surface);
    GLvdpauSurfaceNV glVDPAURegisterOutputSurfaceNV(GLvoid *vdpSurface, GLenum target, GLsizei numTextureNames, const GLuint *textureNames);
    GLvdpauSurfaceNV glVDPAURegisterVideoSurfaceNV(const GLvoid *vdpSurface, GLenum target, GLsizei numTextureNames, const GLuint *textureNames);
    void glVDPAUFiniNV();
    void glVDPAUInitNV(const GLvoid *vdpDevice, const GLvoid *getProcAddress);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_vdpau_interop)
};

inline void QOpenGLExtension_NV_vdpau_interop::glVDPAUUnmapSurfacesNV(GLsizei numSurface, const GLvdpauSurfaceNV *surfaces)
{
    Q_D(QOpenGLExtension_NV_vdpau_interop);
    d->VDPAUUnmapSurfacesNV(numSurface, surfaces);
}

inline void QOpenGLExtension_NV_vdpau_interop::glVDPAUMapSurfacesNV(GLsizei numSurfaces, const GLvdpauSurfaceNV *surfaces)
{
    Q_D(QOpenGLExtension_NV_vdpau_interop);
    d->VDPAUMapSurfacesNV(numSurfaces, surfaces);
}

inline void QOpenGLExtension_NV_vdpau_interop::glVDPAUSurfaceAccessNV(GLvdpauSurfaceNV surface, GLenum access)
{
    Q_D(QOpenGLExtension_NV_vdpau_interop);
    d->VDPAUSurfaceAccessNV(surface, access);
}

inline void QOpenGLExtension_NV_vdpau_interop::glVDPAUGetSurfaceivNV(GLvdpauSurfaceNV surface, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values)
{
    Q_D(QOpenGLExtension_NV_vdpau_interop);
    d->VDPAUGetSurfaceivNV(surface, pname, bufSize, length, values);
}

inline void QOpenGLExtension_NV_vdpau_interop::glVDPAUUnregisterSurfaceNV(GLvdpauSurfaceNV surface)
{
    Q_D(QOpenGLExtension_NV_vdpau_interop);
    d->VDPAUUnregisterSurfaceNV(surface);
}

inline void QOpenGLExtension_NV_vdpau_interop::glVDPAUIsSurfaceNV(GLvdpauSurfaceNV surface)
{
    Q_D(QOpenGLExtension_NV_vdpau_interop);
    d->VDPAUIsSurfaceNV(surface);
}

inline GLvdpauSurfaceNV QOpenGLExtension_NV_vdpau_interop::glVDPAURegisterOutputSurfaceNV(GLvoid *vdpSurface, GLenum target, GLsizei numTextureNames, const GLuint *textureNames)
{
    Q_D(QOpenGLExtension_NV_vdpau_interop);
    return d->VDPAURegisterOutputSurfaceNV(vdpSurface, target, numTextureNames, textureNames);
}

inline GLvdpauSurfaceNV QOpenGLExtension_NV_vdpau_interop::glVDPAURegisterVideoSurfaceNV(const GLvoid *vdpSurface, GLenum target, GLsizei numTextureNames, const GLuint *textureNames)
{
    Q_D(QOpenGLExtension_NV_vdpau_interop);
    return d->VDPAURegisterVideoSurfaceNV(vdpSurface, target, numTextureNames, textureNames);
}

inline void QOpenGLExtension_NV_vdpau_interop::glVDPAUFiniNV()
{
    Q_D(QOpenGLExtension_NV_vdpau_interop);
    d->VDPAUFiniNV();
}

inline void QOpenGLExtension_NV_vdpau_interop::glVDPAUInitNV(const GLvoid *vdpDevice, const GLvoid *getProcAddress)
{
    Q_D(QOpenGLExtension_NV_vdpau_interop);
    d->VDPAUInitNV(vdpDevice, getProcAddress);
}

class QOpenGLExtension_NV_vertex_array_rangePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP VertexArrayRangeNV)(GLsizei length, const GLvoid *pointer);
    void (QOPENGLF_APIENTRYP FlushVertexArrayRangeNV)();
};

class QOpenGLExtension_NV_vertex_array_range : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_vertex_array_range();

    bool initializeOpenGLFunctions() final;

    void glVertexArrayRangeNV(GLsizei length, const GLvoid *pointer);
    void glFlushVertexArrayRangeNV();

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_vertex_array_range)
};

inline void QOpenGLExtension_NV_vertex_array_range::glVertexArrayRangeNV(GLsizei length, const GLvoid *pointer)
{
    Q_D(QOpenGLExtension_NV_vertex_array_range);
    d->VertexArrayRangeNV(length, pointer);
}

inline void QOpenGLExtension_NV_vertex_array_range::glFlushVertexArrayRangeNV()
{
    Q_D(QOpenGLExtension_NV_vertex_array_range);
    d->FlushVertexArrayRangeNV();
}

class QOpenGLExtension_NV_vertex_attrib_integer_64bitPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP VertexAttribLFormatNV)(GLuint index, GLint size, GLenum type, GLsizei stride);
    void (QOPENGLF_APIENTRYP GetVertexAttribLui64vNV)(GLuint index, GLenum pname, GLuint64EXT *params);
    void (QOPENGLF_APIENTRYP GetVertexAttribLi64vNV)(GLuint index, GLenum pname, GLint64EXT *params);
    void (QOPENGLF_APIENTRYP VertexAttribL4ui64vNV)(GLuint index, const GLuint64EXT *v);
    void (QOPENGLF_APIENTRYP VertexAttribL3ui64vNV)(GLuint index, const GLuint64EXT *v);
    void (QOPENGLF_APIENTRYP VertexAttribL2ui64vNV)(GLuint index, const GLuint64EXT *v);
    void (QOPENGLF_APIENTRYP VertexAttribL1ui64vNV)(GLuint index, const GLuint64EXT *v);
    void (QOPENGLF_APIENTRYP VertexAttribL4ui64NV)(GLuint index, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w);
    void (QOPENGLF_APIENTRYP VertexAttribL3ui64NV)(GLuint index, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z);
    void (QOPENGLF_APIENTRYP VertexAttribL2ui64NV)(GLuint index, GLuint64EXT x, GLuint64EXT y);
    void (QOPENGLF_APIENTRYP VertexAttribL1ui64NV)(GLuint index, GLuint64EXT x);
    void (QOPENGLF_APIENTRYP VertexAttribL4i64vNV)(GLuint index, const GLint64EXT *v);
    void (QOPENGLF_APIENTRYP VertexAttribL3i64vNV)(GLuint index, const GLint64EXT *v);
    void (QOPENGLF_APIENTRYP VertexAttribL2i64vNV)(GLuint index, const GLint64EXT *v);
    void (QOPENGLF_APIENTRYP VertexAttribL1i64vNV)(GLuint index, const GLint64EXT *v);
    void (QOPENGLF_APIENTRYP VertexAttribL4i64NV)(GLuint index, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w);
    void (QOPENGLF_APIENTRYP VertexAttribL3i64NV)(GLuint index, GLint64EXT x, GLint64EXT y, GLint64EXT z);
    void (QOPENGLF_APIENTRYP VertexAttribL2i64NV)(GLuint index, GLint64EXT x, GLint64EXT y);
    void (QOPENGLF_APIENTRYP VertexAttribL1i64NV)(GLuint index, GLint64EXT x);
};

class QOpenGLExtension_NV_vertex_attrib_integer_64bit : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_vertex_attrib_integer_64bit();

    bool initializeOpenGLFunctions() final;

    void glVertexAttribLFormatNV(GLuint index, GLint size, GLenum type, GLsizei stride);
    void glGetVertexAttribLui64vNV(GLuint index, GLenum pname, GLuint64EXT *params);
    void glGetVertexAttribLi64vNV(GLuint index, GLenum pname, GLint64EXT *params);
    void glVertexAttribL4ui64vNV(GLuint index, const GLuint64EXT *v);
    void glVertexAttribL3ui64vNV(GLuint index, const GLuint64EXT *v);
    void glVertexAttribL2ui64vNV(GLuint index, const GLuint64EXT *v);
    void glVertexAttribL1ui64vNV(GLuint index, const GLuint64EXT *v);
    void glVertexAttribL4ui64NV(GLuint index, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w);
    void glVertexAttribL3ui64NV(GLuint index, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z);
    void glVertexAttribL2ui64NV(GLuint index, GLuint64EXT x, GLuint64EXT y);
    void glVertexAttribL1ui64NV(GLuint index, GLuint64EXT x);
    void glVertexAttribL4i64vNV(GLuint index, const GLint64EXT *v);
    void glVertexAttribL3i64vNV(GLuint index, const GLint64EXT *v);
    void glVertexAttribL2i64vNV(GLuint index, const GLint64EXT *v);
    void glVertexAttribL1i64vNV(GLuint index, const GLint64EXT *v);
    void glVertexAttribL4i64NV(GLuint index, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w);
    void glVertexAttribL3i64NV(GLuint index, GLint64EXT x, GLint64EXT y, GLint64EXT z);
    void glVertexAttribL2i64NV(GLuint index, GLint64EXT x, GLint64EXT y);
    void glVertexAttribL1i64NV(GLuint index, GLint64EXT x);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_vertex_attrib_integer_64bit)
};

inline void QOpenGLExtension_NV_vertex_attrib_integer_64bit::glVertexAttribLFormatNV(GLuint index, GLint size, GLenum type, GLsizei stride)
{
    Q_D(QOpenGLExtension_NV_vertex_attrib_integer_64bit);
    d->VertexAttribLFormatNV(index, size, type, stride);
}

inline void QOpenGLExtension_NV_vertex_attrib_integer_64bit::glGetVertexAttribLui64vNV(GLuint index, GLenum pname, GLuint64EXT *params)
{
    Q_D(QOpenGLExtension_NV_vertex_attrib_integer_64bit);
    d->GetVertexAttribLui64vNV(index, pname, params);
}

inline void QOpenGLExtension_NV_vertex_attrib_integer_64bit::glGetVertexAttribLi64vNV(GLuint index, GLenum pname, GLint64EXT *params)
{
    Q_D(QOpenGLExtension_NV_vertex_attrib_integer_64bit);
    d->GetVertexAttribLi64vNV(index, pname, params);
}

inline void QOpenGLExtension_NV_vertex_attrib_integer_64bit::glVertexAttribL4ui64vNV(GLuint index, const GLuint64EXT *v)
{
    Q_D(QOpenGLExtension_NV_vertex_attrib_integer_64bit);
    d->VertexAttribL4ui64vNV(index, v);
}

inline void QOpenGLExtension_NV_vertex_attrib_integer_64bit::glVertexAttribL3ui64vNV(GLuint index, const GLuint64EXT *v)
{
    Q_D(QOpenGLExtension_NV_vertex_attrib_integer_64bit);
    d->VertexAttribL3ui64vNV(index, v);
}

inline void QOpenGLExtension_NV_vertex_attrib_integer_64bit::glVertexAttribL2ui64vNV(GLuint index, const GLuint64EXT *v)
{
    Q_D(QOpenGLExtension_NV_vertex_attrib_integer_64bit);
    d->VertexAttribL2ui64vNV(index, v);
}

inline void QOpenGLExtension_NV_vertex_attrib_integer_64bit::glVertexAttribL1ui64vNV(GLuint index, const GLuint64EXT *v)
{
    Q_D(QOpenGLExtension_NV_vertex_attrib_integer_64bit);
    d->VertexAttribL1ui64vNV(index, v);
}

inline void QOpenGLExtension_NV_vertex_attrib_integer_64bit::glVertexAttribL4ui64NV(GLuint index, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w)
{
    Q_D(QOpenGLExtension_NV_vertex_attrib_integer_64bit);
    d->VertexAttribL4ui64NV(index, x, y, z, w);
}

inline void QOpenGLExtension_NV_vertex_attrib_integer_64bit::glVertexAttribL3ui64NV(GLuint index, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z)
{
    Q_D(QOpenGLExtension_NV_vertex_attrib_integer_64bit);
    d->VertexAttribL3ui64NV(index, x, y, z);
}

inline void QOpenGLExtension_NV_vertex_attrib_integer_64bit::glVertexAttribL2ui64NV(GLuint index, GLuint64EXT x, GLuint64EXT y)
{
    Q_D(QOpenGLExtension_NV_vertex_attrib_integer_64bit);
    d->VertexAttribL2ui64NV(index, x, y);
}

inline void QOpenGLExtension_NV_vertex_attrib_integer_64bit::glVertexAttribL1ui64NV(GLuint index, GLuint64EXT x)
{
    Q_D(QOpenGLExtension_NV_vertex_attrib_integer_64bit);
    d->VertexAttribL1ui64NV(index, x);
}

inline void QOpenGLExtension_NV_vertex_attrib_integer_64bit::glVertexAttribL4i64vNV(GLuint index, const GLint64EXT *v)
{
    Q_D(QOpenGLExtension_NV_vertex_attrib_integer_64bit);
    d->VertexAttribL4i64vNV(index, v);
}

inline void QOpenGLExtension_NV_vertex_attrib_integer_64bit::glVertexAttribL3i64vNV(GLuint index, const GLint64EXT *v)
{
    Q_D(QOpenGLExtension_NV_vertex_attrib_integer_64bit);
    d->VertexAttribL3i64vNV(index, v);
}

inline void QOpenGLExtension_NV_vertex_attrib_integer_64bit::glVertexAttribL2i64vNV(GLuint index, const GLint64EXT *v)
{
    Q_D(QOpenGLExtension_NV_vertex_attrib_integer_64bit);
    d->VertexAttribL2i64vNV(index, v);
}

inline void QOpenGLExtension_NV_vertex_attrib_integer_64bit::glVertexAttribL1i64vNV(GLuint index, const GLint64EXT *v)
{
    Q_D(QOpenGLExtension_NV_vertex_attrib_integer_64bit);
    d->VertexAttribL1i64vNV(index, v);
}

inline void QOpenGLExtension_NV_vertex_attrib_integer_64bit::glVertexAttribL4i64NV(GLuint index, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w)
{
    Q_D(QOpenGLExtension_NV_vertex_attrib_integer_64bit);
    d->VertexAttribL4i64NV(index, x, y, z, w);
}

inline void QOpenGLExtension_NV_vertex_attrib_integer_64bit::glVertexAttribL3i64NV(GLuint index, GLint64EXT x, GLint64EXT y, GLint64EXT z)
{
    Q_D(QOpenGLExtension_NV_vertex_attrib_integer_64bit);
    d->VertexAttribL3i64NV(index, x, y, z);
}

inline void QOpenGLExtension_NV_vertex_attrib_integer_64bit::glVertexAttribL2i64NV(GLuint index, GLint64EXT x, GLint64EXT y)
{
    Q_D(QOpenGLExtension_NV_vertex_attrib_integer_64bit);
    d->VertexAttribL2i64NV(index, x, y);
}

inline void QOpenGLExtension_NV_vertex_attrib_integer_64bit::glVertexAttribL1i64NV(GLuint index, GLint64EXT x)
{
    Q_D(QOpenGLExtension_NV_vertex_attrib_integer_64bit);
    d->VertexAttribL1i64NV(index, x);
}

class QOpenGLExtension_NV_vertex_buffer_unified_memoryPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetIntegerui64i_vNV)(GLenum value, GLuint index, GLuint64EXT *result);
    void (QOPENGLF_APIENTRYP VertexAttribIFormatNV)(GLuint index, GLint size, GLenum type, GLsizei stride);
    void (QOPENGLF_APIENTRYP VertexAttribFormatNV)(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride);
    void (QOPENGLF_APIENTRYP FogCoordFormatNV)(GLenum type, GLsizei stride);
    void (QOPENGLF_APIENTRYP SecondaryColorFormatNV)(GLint size, GLenum type, GLsizei stride);
    void (QOPENGLF_APIENTRYP EdgeFlagFormatNV)(GLsizei stride);
    void (QOPENGLF_APIENTRYP TexCoordFormatNV)(GLint size, GLenum type, GLsizei stride);
    void (QOPENGLF_APIENTRYP IndexFormatNV)(GLenum type, GLsizei stride);
    void (QOPENGLF_APIENTRYP ColorFormatNV)(GLint size, GLenum type, GLsizei stride);
    void (QOPENGLF_APIENTRYP NormalFormatNV)(GLenum type, GLsizei stride);
    void (QOPENGLF_APIENTRYP VertexFormatNV)(GLint size, GLenum type, GLsizei stride);
    void (QOPENGLF_APIENTRYP BufferAddressRangeNV)(GLenum pname, GLuint index, GLuint64EXT address, GLsizeiptr length);
};

class QOpenGLExtension_NV_vertex_buffer_unified_memory : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_vertex_buffer_unified_memory();

    bool initializeOpenGLFunctions() final;

    void glGetIntegerui64i_vNV(GLenum value, GLuint index, GLuint64EXT *result);
    void glVertexAttribIFormatNV(GLuint index, GLint size, GLenum type, GLsizei stride);
    void glVertexAttribFormatNV(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride);
    void glFogCoordFormatNV(GLenum type, GLsizei stride);
    void glSecondaryColorFormatNV(GLint size, GLenum type, GLsizei stride);
    void glEdgeFlagFormatNV(GLsizei stride);
    void glTexCoordFormatNV(GLint size, GLenum type, GLsizei stride);
    void glIndexFormatNV(GLenum type, GLsizei stride);
    void glColorFormatNV(GLint size, GLenum type, GLsizei stride);
    void glNormalFormatNV(GLenum type, GLsizei stride);
    void glVertexFormatNV(GLint size, GLenum type, GLsizei stride);
    void glBufferAddressRangeNV(GLenum pname, GLuint index, GLuint64EXT address, GLsizeiptr length);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_vertex_buffer_unified_memory)
};

inline void QOpenGLExtension_NV_vertex_buffer_unified_memory::glGetIntegerui64i_vNV(GLenum value, GLuint index, GLuint64EXT *result)
{
    Q_D(QOpenGLExtension_NV_vertex_buffer_unified_memory);
    d->GetIntegerui64i_vNV(value, index, result);
}

inline void QOpenGLExtension_NV_vertex_buffer_unified_memory::glVertexAttribIFormatNV(GLuint index, GLint size, GLenum type, GLsizei stride)
{
    Q_D(QOpenGLExtension_NV_vertex_buffer_unified_memory);
    d->VertexAttribIFormatNV(index, size, type, stride);
}

inline void QOpenGLExtension_NV_vertex_buffer_unified_memory::glVertexAttribFormatNV(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride)
{
    Q_D(QOpenGLExtension_NV_vertex_buffer_unified_memory);
    d->VertexAttribFormatNV(index, size, type, normalized, stride);
}

inline void QOpenGLExtension_NV_vertex_buffer_unified_memory::glFogCoordFormatNV(GLenum type, GLsizei stride)
{
    Q_D(QOpenGLExtension_NV_vertex_buffer_unified_memory);
    d->FogCoordFormatNV(type, stride);
}

inline void QOpenGLExtension_NV_vertex_buffer_unified_memory::glSecondaryColorFormatNV(GLint size, GLenum type, GLsizei stride)
{
    Q_D(QOpenGLExtension_NV_vertex_buffer_unified_memory);
    d->SecondaryColorFormatNV(size, type, stride);
}

inline void QOpenGLExtension_NV_vertex_buffer_unified_memory::glEdgeFlagFormatNV(GLsizei stride)
{
    Q_D(QOpenGLExtension_NV_vertex_buffer_unified_memory);
    d->EdgeFlagFormatNV(stride);
}

inline void QOpenGLExtension_NV_vertex_buffer_unified_memory::glTexCoordFormatNV(GLint size, GLenum type, GLsizei stride)
{
    Q_D(QOpenGLExtension_NV_vertex_buffer_unified_memory);
    d->TexCoordFormatNV(size, type, stride);
}

inline void QOpenGLExtension_NV_vertex_buffer_unified_memory::glIndexFormatNV(GLenum type, GLsizei stride)
{
    Q_D(QOpenGLExtension_NV_vertex_buffer_unified_memory);
    d->IndexFormatNV(type, stride);
}

inline void QOpenGLExtension_NV_vertex_buffer_unified_memory::glColorFormatNV(GLint size, GLenum type, GLsizei stride)
{
    Q_D(QOpenGLExtension_NV_vertex_buffer_unified_memory);
    d->ColorFormatNV(size, type, stride);
}

inline void QOpenGLExtension_NV_vertex_buffer_unified_memory::glNormalFormatNV(GLenum type, GLsizei stride)
{
    Q_D(QOpenGLExtension_NV_vertex_buffer_unified_memory);
    d->NormalFormatNV(type, stride);
}

inline void QOpenGLExtension_NV_vertex_buffer_unified_memory::glVertexFormatNV(GLint size, GLenum type, GLsizei stride)
{
    Q_D(QOpenGLExtension_NV_vertex_buffer_unified_memory);
    d->VertexFormatNV(size, type, stride);
}

inline void QOpenGLExtension_NV_vertex_buffer_unified_memory::glBufferAddressRangeNV(GLenum pname, GLuint index, GLuint64EXT address, GLsizeiptr length)
{
    Q_D(QOpenGLExtension_NV_vertex_buffer_unified_memory);
    d->BufferAddressRangeNV(pname, index, address, length);
}

class QOpenGLExtension_NV_vertex_programPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP VertexAttribs4ubvNV)(GLuint index, GLsizei count, const GLubyte *v);
    void (QOPENGLF_APIENTRYP VertexAttribs4svNV)(GLuint index, GLsizei count, const GLshort *v);
    void (QOPENGLF_APIENTRYP VertexAttribs4fvNV)(GLuint index, GLsizei count, const GLfloat *v);
    void (QOPENGLF_APIENTRYP VertexAttribs4dvNV)(GLuint index, GLsizei count, const GLdouble *v);
    void (QOPENGLF_APIENTRYP VertexAttribs3svNV)(GLuint index, GLsizei count, const GLshort *v);
    void (QOPENGLF_APIENTRYP VertexAttribs3fvNV)(GLuint index, GLsizei count, const GLfloat *v);
    void (QOPENGLF_APIENTRYP VertexAttribs3dvNV)(GLuint index, GLsizei count, const GLdouble *v);
    void (QOPENGLF_APIENTRYP VertexAttribs2svNV)(GLuint index, GLsizei count, const GLshort *v);
    void (QOPENGLF_APIENTRYP VertexAttribs2fvNV)(GLuint index, GLsizei count, const GLfloat *v);
    void (QOPENGLF_APIENTRYP VertexAttribs2dvNV)(GLuint index, GLsizei count, const GLdouble *v);
    void (QOPENGLF_APIENTRYP VertexAttribs1svNV)(GLuint index, GLsizei count, const GLshort *v);
    void (QOPENGLF_APIENTRYP VertexAttribs1fvNV)(GLuint index, GLsizei count, const GLfloat *v);
    void (QOPENGLF_APIENTRYP VertexAttribs1dvNV)(GLuint index, GLsizei count, const GLdouble *v);
    void (QOPENGLF_APIENTRYP VertexAttrib4ubvNV)(GLuint index, const GLubyte *v);
    void (QOPENGLF_APIENTRYP VertexAttrib4ubNV)(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w);
    void (QOPENGLF_APIENTRYP VertexAttrib4svNV)(GLuint index, const GLshort *v);
    void (QOPENGLF_APIENTRYP VertexAttrib4sNV)(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w);
    void (QOPENGLF_APIENTRYP VertexAttrib4fvNV)(GLuint index, const GLfloat *v);
    void (QOPENGLF_APIENTRYP VertexAttrib4fNV)(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
    void (QOPENGLF_APIENTRYP VertexAttrib4dvNV)(GLuint index, const GLdouble *v);
    void (QOPENGLF_APIENTRYP VertexAttrib4dNV)(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
    void (QOPENGLF_APIENTRYP VertexAttrib3svNV)(GLuint index, const GLshort *v);
    void (QOPENGLF_APIENTRYP VertexAttrib3sNV)(GLuint index, GLshort x, GLshort y, GLshort z);
    void (QOPENGLF_APIENTRYP VertexAttrib3fvNV)(GLuint index, const GLfloat *v);
    void (QOPENGLF_APIENTRYP VertexAttrib3fNV)(GLuint index, GLfloat x, GLfloat y, GLfloat z);
    void (QOPENGLF_APIENTRYP VertexAttrib3dvNV)(GLuint index, const GLdouble *v);
    void (QOPENGLF_APIENTRYP VertexAttrib3dNV)(GLuint index, GLdouble x, GLdouble y, GLdouble z);
    void (QOPENGLF_APIENTRYP VertexAttrib2svNV)(GLuint index, const GLshort *v);
    void (QOPENGLF_APIENTRYP VertexAttrib2sNV)(GLuint index, GLshort x, GLshort y);
    void (QOPENGLF_APIENTRYP VertexAttrib2fvNV)(GLuint index, const GLfloat *v);
    void (QOPENGLF_APIENTRYP VertexAttrib2fNV)(GLuint index, GLfloat x, GLfloat y);
    void (QOPENGLF_APIENTRYP VertexAttrib2dvNV)(GLuint index, const GLdouble *v);
    void (QOPENGLF_APIENTRYP VertexAttrib2dNV)(GLuint index, GLdouble x, GLdouble y);
    void (QOPENGLF_APIENTRYP VertexAttrib1svNV)(GLuint index, const GLshort *v);
    void (QOPENGLF_APIENTRYP VertexAttrib1sNV)(GLuint index, GLshort x);
    void (QOPENGLF_APIENTRYP VertexAttrib1fvNV)(GLuint index, const GLfloat *v);
    void (QOPENGLF_APIENTRYP VertexAttrib1fNV)(GLuint index, GLfloat x);
    void (QOPENGLF_APIENTRYP VertexAttrib1dvNV)(GLuint index, const GLdouble *v);
    void (QOPENGLF_APIENTRYP VertexAttrib1dNV)(GLuint index, GLdouble x);
    void (QOPENGLF_APIENTRYP VertexAttribPointerNV)(GLuint index, GLint fsize, GLenum type, GLsizei stride, const GLvoid *pointer);
    void (QOPENGLF_APIENTRYP TrackMatrixNV)(GLenum target, GLuint address, GLenum matrix, GLenum transform);
    void (QOPENGLF_APIENTRYP RequestResidentProgramsNV)(GLsizei n, const GLuint *programs);
    void (QOPENGLF_APIENTRYP ProgramParameters4fvNV)(GLenum target, GLuint index, GLsizei count, const GLfloat *v);
    void (QOPENGLF_APIENTRYP ProgramParameters4dvNV)(GLenum target, GLuint index, GLsizei count, const GLdouble *v);
    void (QOPENGLF_APIENTRYP ProgramParameter4fvNV)(GLenum target, GLuint index, const GLfloat *v);
    void (QOPENGLF_APIENTRYP ProgramParameter4fNV)(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
    void (QOPENGLF_APIENTRYP ProgramParameter4dvNV)(GLenum target, GLuint index, const GLdouble *v);
    void (QOPENGLF_APIENTRYP ProgramParameter4dNV)(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
    void (QOPENGLF_APIENTRYP LoadProgramNV)(GLenum target, GLuint id, GLsizei len, const GLubyte *program);
    GLboolean (QOPENGLF_APIENTRYP IsProgramNV)(GLuint id);
    void (QOPENGLF_APIENTRYP GetVertexAttribPointervNV)(GLuint index, GLenum pname, GLvoid* *pointer);
    void (QOPENGLF_APIENTRYP GetVertexAttribivNV)(GLuint index, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetVertexAttribfvNV)(GLuint index, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP GetVertexAttribdvNV)(GLuint index, GLenum pname, GLdouble *params);
    void (QOPENGLF_APIENTRYP GetTrackMatrixivNV)(GLenum target, GLuint address, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetProgramStringNV)(GLuint id, GLenum pname, GLubyte *program);
    void (QOPENGLF_APIENTRYP GetProgramivNV)(GLuint id, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetProgramParameterfvNV)(GLenum target, GLuint index, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP GetProgramParameterdvNV)(GLenum target, GLuint index, GLenum pname, GLdouble *params);
    void (QOPENGLF_APIENTRYP GenProgramsNV)(GLsizei n, GLuint *programs);
    void (QOPENGLF_APIENTRYP ExecuteProgramNV)(GLenum target, GLuint id, const GLfloat *params);
    void (QOPENGLF_APIENTRYP DeleteProgramsNV)(GLsizei n, const GLuint *programs);
    void (QOPENGLF_APIENTRYP BindProgramNV)(GLenum target, GLuint id);
    GLboolean (QOPENGLF_APIENTRYP AreProgramsResidentNV)(GLsizei n, const GLuint *programs, GLboolean *residences);
};

class QOpenGLExtension_NV_vertex_program : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_vertex_program();

    bool initializeOpenGLFunctions() final;

    void glVertexAttribs4ubvNV(GLuint index, GLsizei count, const GLubyte *v);
    void glVertexAttribs4svNV(GLuint index, GLsizei count, const GLshort *v);
    void glVertexAttribs4fvNV(GLuint index, GLsizei count, const GLfloat *v);
    void glVertexAttribs4dvNV(GLuint index, GLsizei count, const GLdouble *v);
    void glVertexAttribs3svNV(GLuint index, GLsizei count, const GLshort *v);
    void glVertexAttribs3fvNV(GLuint index, GLsizei count, const GLfloat *v);
    void glVertexAttribs3dvNV(GLuint index, GLsizei count, const GLdouble *v);
    void glVertexAttribs2svNV(GLuint index, GLsizei count, const GLshort *v);
    void glVertexAttribs2fvNV(GLuint index, GLsizei count, const GLfloat *v);
    void glVertexAttribs2dvNV(GLuint index, GLsizei count, const GLdouble *v);
    void glVertexAttribs1svNV(GLuint index, GLsizei count, const GLshort *v);
    void glVertexAttribs1fvNV(GLuint index, GLsizei count, const GLfloat *v);
    void glVertexAttribs1dvNV(GLuint index, GLsizei count, const GLdouble *v);
    void glVertexAttrib4ubvNV(GLuint index, const GLubyte *v);
    void glVertexAttrib4ubNV(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w);
    void glVertexAttrib4svNV(GLuint index, const GLshort *v);
    void glVertexAttrib4sNV(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w);
    void glVertexAttrib4fvNV(GLuint index, const GLfloat *v);
    void glVertexAttrib4fNV(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
    void glVertexAttrib4dvNV(GLuint index, const GLdouble *v);
    void glVertexAttrib4dNV(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
    void glVertexAttrib3svNV(GLuint index, const GLshort *v);
    void glVertexAttrib3sNV(GLuint index, GLshort x, GLshort y, GLshort z);
    void glVertexAttrib3fvNV(GLuint index, const GLfloat *v);
    void glVertexAttrib3fNV(GLuint index, GLfloat x, GLfloat y, GLfloat z);
    void glVertexAttrib3dvNV(GLuint index, const GLdouble *v);
    void glVertexAttrib3dNV(GLuint index, GLdouble x, GLdouble y, GLdouble z);
    void glVertexAttrib2svNV(GLuint index, const GLshort *v);
    void glVertexAttrib2sNV(GLuint index, GLshort x, GLshort y);
    void glVertexAttrib2fvNV(GLuint index, const GLfloat *v);
    void glVertexAttrib2fNV(GLuint index, GLfloat x, GLfloat y);
    void glVertexAttrib2dvNV(GLuint index, const GLdouble *v);
    void glVertexAttrib2dNV(GLuint index, GLdouble x, GLdouble y);
    void glVertexAttrib1svNV(GLuint index, const GLshort *v);
    void glVertexAttrib1sNV(GLuint index, GLshort x);
    void glVertexAttrib1fvNV(GLuint index, const GLfloat *v);
    void glVertexAttrib1fNV(GLuint index, GLfloat x);
    void glVertexAttrib1dvNV(GLuint index, const GLdouble *v);
    void glVertexAttrib1dNV(GLuint index, GLdouble x);
    void glVertexAttribPointerNV(GLuint index, GLint fsize, GLenum type, GLsizei stride, const GLvoid *pointer);
    void glTrackMatrixNV(GLenum target, GLuint address, GLenum matrix, GLenum transform);
    void glRequestResidentProgramsNV(GLsizei n, const GLuint *programs);
    void glProgramParameters4fvNV(GLenum target, GLuint index, GLsizei count, const GLfloat *v);
    void glProgramParameters4dvNV(GLenum target, GLuint index, GLsizei count, const GLdouble *v);
    void glProgramParameter4fvNV(GLenum target, GLuint index, const GLfloat *v);
    void glProgramParameter4fNV(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
    void glProgramParameter4dvNV(GLenum target, GLuint index, const GLdouble *v);
    void glProgramParameter4dNV(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
    void glLoadProgramNV(GLenum target, GLuint id, GLsizei len, const GLubyte *program);
    GLboolean glIsProgramNV(GLuint id);
    void glGetVertexAttribPointervNV(GLuint index, GLenum pname, GLvoid* *pointer);
    void glGetVertexAttribivNV(GLuint index, GLenum pname, GLint *params);
    void glGetVertexAttribfvNV(GLuint index, GLenum pname, GLfloat *params);
    void glGetVertexAttribdvNV(GLuint index, GLenum pname, GLdouble *params);
    void glGetTrackMatrixivNV(GLenum target, GLuint address, GLenum pname, GLint *params);
    void glGetProgramStringNV(GLuint id, GLenum pname, GLubyte *program);
    void glGetProgramivNV(GLuint id, GLenum pname, GLint *params);
    void glGetProgramParameterfvNV(GLenum target, GLuint index, GLenum pname, GLfloat *params);
    void glGetProgramParameterdvNV(GLenum target, GLuint index, GLenum pname, GLdouble *params);
    void glGenProgramsNV(GLsizei n, GLuint *programs);
    void glExecuteProgramNV(GLenum target, GLuint id, const GLfloat *params);
    void glDeleteProgramsNV(GLsizei n, const GLuint *programs);
    void glBindProgramNV(GLenum target, GLuint id);
    GLboolean glAreProgramsResidentNV(GLsizei n, const GLuint *programs, GLboolean *residences);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_vertex_program)
};

inline void QOpenGLExtension_NV_vertex_program::glVertexAttribs4ubvNV(GLuint index, GLsizei count, const GLubyte *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttribs4ubvNV(index, count, v);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttribs4svNV(GLuint index, GLsizei count, const GLshort *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttribs4svNV(index, count, v);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttribs4fvNV(GLuint index, GLsizei count, const GLfloat *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttribs4fvNV(index, count, v);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttribs4dvNV(GLuint index, GLsizei count, const GLdouble *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttribs4dvNV(index, count, v);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttribs3svNV(GLuint index, GLsizei count, const GLshort *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttribs3svNV(index, count, v);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttribs3fvNV(GLuint index, GLsizei count, const GLfloat *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttribs3fvNV(index, count, v);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttribs3dvNV(GLuint index, GLsizei count, const GLdouble *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttribs3dvNV(index, count, v);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttribs2svNV(GLuint index, GLsizei count, const GLshort *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttribs2svNV(index, count, v);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttribs2fvNV(GLuint index, GLsizei count, const GLfloat *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttribs2fvNV(index, count, v);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttribs2dvNV(GLuint index, GLsizei count, const GLdouble *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttribs2dvNV(index, count, v);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttribs1svNV(GLuint index, GLsizei count, const GLshort *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttribs1svNV(index, count, v);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttribs1fvNV(GLuint index, GLsizei count, const GLfloat *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttribs1fvNV(index, count, v);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttribs1dvNV(GLuint index, GLsizei count, const GLdouble *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttribs1dvNV(index, count, v);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttrib4ubvNV(GLuint index, const GLubyte *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttrib4ubvNV(index, v);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttrib4ubNV(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttrib4ubNV(index, x, y, z, w);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttrib4svNV(GLuint index, const GLshort *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttrib4svNV(index, v);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttrib4sNV(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttrib4sNV(index, x, y, z, w);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttrib4fvNV(GLuint index, const GLfloat *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttrib4fvNV(index, v);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttrib4fNV(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttrib4fNV(index, x, y, z, w);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttrib4dvNV(GLuint index, const GLdouble *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttrib4dvNV(index, v);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttrib4dNV(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttrib4dNV(index, x, y, z, w);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttrib3svNV(GLuint index, const GLshort *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttrib3svNV(index, v);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttrib3sNV(GLuint index, GLshort x, GLshort y, GLshort z)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttrib3sNV(index, x, y, z);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttrib3fvNV(GLuint index, const GLfloat *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttrib3fvNV(index, v);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttrib3fNV(GLuint index, GLfloat x, GLfloat y, GLfloat z)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttrib3fNV(index, x, y, z);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttrib3dvNV(GLuint index, const GLdouble *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttrib3dvNV(index, v);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttrib3dNV(GLuint index, GLdouble x, GLdouble y, GLdouble z)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttrib3dNV(index, x, y, z);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttrib2svNV(GLuint index, const GLshort *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttrib2svNV(index, v);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttrib2sNV(GLuint index, GLshort x, GLshort y)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttrib2sNV(index, x, y);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttrib2fvNV(GLuint index, const GLfloat *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttrib2fvNV(index, v);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttrib2fNV(GLuint index, GLfloat x, GLfloat y)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttrib2fNV(index, x, y);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttrib2dvNV(GLuint index, const GLdouble *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttrib2dvNV(index, v);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttrib2dNV(GLuint index, GLdouble x, GLdouble y)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttrib2dNV(index, x, y);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttrib1svNV(GLuint index, const GLshort *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttrib1svNV(index, v);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttrib1sNV(GLuint index, GLshort x)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttrib1sNV(index, x);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttrib1fvNV(GLuint index, const GLfloat *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttrib1fvNV(index, v);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttrib1fNV(GLuint index, GLfloat x)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttrib1fNV(index, x);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttrib1dvNV(GLuint index, const GLdouble *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttrib1dvNV(index, v);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttrib1dNV(GLuint index, GLdouble x)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttrib1dNV(index, x);
}

inline void QOpenGLExtension_NV_vertex_program::glVertexAttribPointerNV(GLuint index, GLint fsize, GLenum type, GLsizei stride, const GLvoid *pointer)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->VertexAttribPointerNV(index, fsize, type, stride, pointer);
}

inline void QOpenGLExtension_NV_vertex_program::glTrackMatrixNV(GLenum target, GLuint address, GLenum matrix, GLenum transform)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->TrackMatrixNV(target, address, matrix, transform);
}

inline void QOpenGLExtension_NV_vertex_program::glRequestResidentProgramsNV(GLsizei n, const GLuint *programs)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->RequestResidentProgramsNV(n, programs);
}

inline void QOpenGLExtension_NV_vertex_program::glProgramParameters4fvNV(GLenum target, GLuint index, GLsizei count, const GLfloat *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->ProgramParameters4fvNV(target, index, count, v);
}

inline void QOpenGLExtension_NV_vertex_program::glProgramParameters4dvNV(GLenum target, GLuint index, GLsizei count, const GLdouble *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->ProgramParameters4dvNV(target, index, count, v);
}

inline void QOpenGLExtension_NV_vertex_program::glProgramParameter4fvNV(GLenum target, GLuint index, const GLfloat *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->ProgramParameter4fvNV(target, index, v);
}

inline void QOpenGLExtension_NV_vertex_program::glProgramParameter4fNV(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->ProgramParameter4fNV(target, index, x, y, z, w);
}

inline void QOpenGLExtension_NV_vertex_program::glProgramParameter4dvNV(GLenum target, GLuint index, const GLdouble *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->ProgramParameter4dvNV(target, index, v);
}

inline void QOpenGLExtension_NV_vertex_program::glProgramParameter4dNV(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->ProgramParameter4dNV(target, index, x, y, z, w);
}

inline void QOpenGLExtension_NV_vertex_program::glLoadProgramNV(GLenum target, GLuint id, GLsizei len, const GLubyte *program)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->LoadProgramNV(target, id, len, program);
}

inline GLboolean QOpenGLExtension_NV_vertex_program::glIsProgramNV(GLuint id)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    return d->IsProgramNV(id);
}

inline void QOpenGLExtension_NV_vertex_program::glGetVertexAttribPointervNV(GLuint index, GLenum pname, GLvoid* *pointer)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->GetVertexAttribPointervNV(index, pname, pointer);
}

inline void QOpenGLExtension_NV_vertex_program::glGetVertexAttribivNV(GLuint index, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->GetVertexAttribivNV(index, pname, params);
}

inline void QOpenGLExtension_NV_vertex_program::glGetVertexAttribfvNV(GLuint index, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->GetVertexAttribfvNV(index, pname, params);
}

inline void QOpenGLExtension_NV_vertex_program::glGetVertexAttribdvNV(GLuint index, GLenum pname, GLdouble *params)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->GetVertexAttribdvNV(index, pname, params);
}

inline void QOpenGLExtension_NV_vertex_program::glGetTrackMatrixivNV(GLenum target, GLuint address, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->GetTrackMatrixivNV(target, address, pname, params);
}

inline void QOpenGLExtension_NV_vertex_program::glGetProgramStringNV(GLuint id, GLenum pname, GLubyte *program)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->GetProgramStringNV(id, pname, program);
}

inline void QOpenGLExtension_NV_vertex_program::glGetProgramivNV(GLuint id, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->GetProgramivNV(id, pname, params);
}

inline void QOpenGLExtension_NV_vertex_program::glGetProgramParameterfvNV(GLenum target, GLuint index, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->GetProgramParameterfvNV(target, index, pname, params);
}

inline void QOpenGLExtension_NV_vertex_program::glGetProgramParameterdvNV(GLenum target, GLuint index, GLenum pname, GLdouble *params)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->GetProgramParameterdvNV(target, index, pname, params);
}

inline void QOpenGLExtension_NV_vertex_program::glGenProgramsNV(GLsizei n, GLuint *programs)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->GenProgramsNV(n, programs);
}

inline void QOpenGLExtension_NV_vertex_program::glExecuteProgramNV(GLenum target, GLuint id, const GLfloat *params)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->ExecuteProgramNV(target, id, params);
}

inline void QOpenGLExtension_NV_vertex_program::glDeleteProgramsNV(GLsizei n, const GLuint *programs)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->DeleteProgramsNV(n, programs);
}

inline void QOpenGLExtension_NV_vertex_program::glBindProgramNV(GLenum target, GLuint id)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    d->BindProgramNV(target, id);
}

inline GLboolean QOpenGLExtension_NV_vertex_program::glAreProgramsResidentNV(GLsizei n, const GLuint *programs, GLboolean *residences)
{
    Q_D(QOpenGLExtension_NV_vertex_program);
    return d->AreProgramsResidentNV(n, programs, residences);
}

class QOpenGLExtension_NV_vertex_program4Private : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetVertexAttribIuivEXT)(GLuint index, GLenum pname, GLuint *params);
    void (QOPENGLF_APIENTRYP GetVertexAttribIivEXT)(GLuint index, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP VertexAttribIPointerEXT)(GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
    void (QOPENGLF_APIENTRYP VertexAttribI4usvEXT)(GLuint index, const GLushort *v);
    void (QOPENGLF_APIENTRYP VertexAttribI4ubvEXT)(GLuint index, const GLubyte *v);
    void (QOPENGLF_APIENTRYP VertexAttribI4svEXT)(GLuint index, const GLshort *v);
    void (QOPENGLF_APIENTRYP VertexAttribI4bvEXT)(GLuint index, const GLbyte *v);
    void (QOPENGLF_APIENTRYP VertexAttribI4uivEXT)(GLuint index, const GLuint *v);
    void (QOPENGLF_APIENTRYP VertexAttribI3uivEXT)(GLuint index, const GLuint *v);
    void (QOPENGLF_APIENTRYP VertexAttribI2uivEXT)(GLuint index, const GLuint *v);
    void (QOPENGLF_APIENTRYP VertexAttribI1uivEXT)(GLuint index, const GLuint *v);
    void (QOPENGLF_APIENTRYP VertexAttribI4ivEXT)(GLuint index, const GLint *v);
    void (QOPENGLF_APIENTRYP VertexAttribI3ivEXT)(GLuint index, const GLint *v);
    void (QOPENGLF_APIENTRYP VertexAttribI2ivEXT)(GLuint index, const GLint *v);
    void (QOPENGLF_APIENTRYP VertexAttribI1ivEXT)(GLuint index, const GLint *v);
    void (QOPENGLF_APIENTRYP VertexAttribI4uiEXT)(GLuint index, GLuint x, GLuint y, GLuint z, GLuint w);
    void (QOPENGLF_APIENTRYP VertexAttribI3uiEXT)(GLuint index, GLuint x, GLuint y, GLuint z);
    void (QOPENGLF_APIENTRYP VertexAttribI2uiEXT)(GLuint index, GLuint x, GLuint y);
    void (QOPENGLF_APIENTRYP VertexAttribI1uiEXT)(GLuint index, GLuint x);
    void (QOPENGLF_APIENTRYP VertexAttribI4iEXT)(GLuint index, GLint x, GLint y, GLint z, GLint w);
    void (QOPENGLF_APIENTRYP VertexAttribI3iEXT)(GLuint index, GLint x, GLint y, GLint z);
    void (QOPENGLF_APIENTRYP VertexAttribI2iEXT)(GLuint index, GLint x, GLint y);
    void (QOPENGLF_APIENTRYP VertexAttribI1iEXT)(GLuint index, GLint x);
};

class QOpenGLExtension_NV_vertex_program4 : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_vertex_program4();

    bool initializeOpenGLFunctions() final;

    void glGetVertexAttribIuivEXT(GLuint index, GLenum pname, GLuint *params);
    void glGetVertexAttribIivEXT(GLuint index, GLenum pname, GLint *params);
    void glVertexAttribIPointerEXT(GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
    void glVertexAttribI4usvEXT(GLuint index, const GLushort *v);
    void glVertexAttribI4ubvEXT(GLuint index, const GLubyte *v);
    void glVertexAttribI4svEXT(GLuint index, const GLshort *v);
    void glVertexAttribI4bvEXT(GLuint index, const GLbyte *v);
    void glVertexAttribI4uivEXT(GLuint index, const GLuint *v);
    void glVertexAttribI3uivEXT(GLuint index, const GLuint *v);
    void glVertexAttribI2uivEXT(GLuint index, const GLuint *v);
    void glVertexAttribI1uivEXT(GLuint index, const GLuint *v);
    void glVertexAttribI4ivEXT(GLuint index, const GLint *v);
    void glVertexAttribI3ivEXT(GLuint index, const GLint *v);
    void glVertexAttribI2ivEXT(GLuint index, const GLint *v);
    void glVertexAttribI1ivEXT(GLuint index, const GLint *v);
    void glVertexAttribI4uiEXT(GLuint index, GLuint x, GLuint y, GLuint z, GLuint w);
    void glVertexAttribI3uiEXT(GLuint index, GLuint x, GLuint y, GLuint z);
    void glVertexAttribI2uiEXT(GLuint index, GLuint x, GLuint y);
    void glVertexAttribI1uiEXT(GLuint index, GLuint x);
    void glVertexAttribI4iEXT(GLuint index, GLint x, GLint y, GLint z, GLint w);
    void glVertexAttribI3iEXT(GLuint index, GLint x, GLint y, GLint z);
    void glVertexAttribI2iEXT(GLuint index, GLint x, GLint y);
    void glVertexAttribI1iEXT(GLuint index, GLint x);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_vertex_program4)
};

inline void QOpenGLExtension_NV_vertex_program4::glGetVertexAttribIuivEXT(GLuint index, GLenum pname, GLuint *params)
{
    Q_D(QOpenGLExtension_NV_vertex_program4);
    d->GetVertexAttribIuivEXT(index, pname, params);
}

inline void QOpenGLExtension_NV_vertex_program4::glGetVertexAttribIivEXT(GLuint index, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_NV_vertex_program4);
    d->GetVertexAttribIivEXT(index, pname, params);
}

inline void QOpenGLExtension_NV_vertex_program4::glVertexAttribIPointerEXT(GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
    Q_D(QOpenGLExtension_NV_vertex_program4);
    d->VertexAttribIPointerEXT(index, size, type, stride, pointer);
}

inline void QOpenGLExtension_NV_vertex_program4::glVertexAttribI4usvEXT(GLuint index, const GLushort *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program4);
    d->VertexAttribI4usvEXT(index, v);
}

inline void QOpenGLExtension_NV_vertex_program4::glVertexAttribI4ubvEXT(GLuint index, const GLubyte *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program4);
    d->VertexAttribI4ubvEXT(index, v);
}

inline void QOpenGLExtension_NV_vertex_program4::glVertexAttribI4svEXT(GLuint index, const GLshort *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program4);
    d->VertexAttribI4svEXT(index, v);
}

inline void QOpenGLExtension_NV_vertex_program4::glVertexAttribI4bvEXT(GLuint index, const GLbyte *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program4);
    d->VertexAttribI4bvEXT(index, v);
}

inline void QOpenGLExtension_NV_vertex_program4::glVertexAttribI4uivEXT(GLuint index, const GLuint *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program4);
    d->VertexAttribI4uivEXT(index, v);
}

inline void QOpenGLExtension_NV_vertex_program4::glVertexAttribI3uivEXT(GLuint index, const GLuint *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program4);
    d->VertexAttribI3uivEXT(index, v);
}

inline void QOpenGLExtension_NV_vertex_program4::glVertexAttribI2uivEXT(GLuint index, const GLuint *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program4);
    d->VertexAttribI2uivEXT(index, v);
}

inline void QOpenGLExtension_NV_vertex_program4::glVertexAttribI1uivEXT(GLuint index, const GLuint *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program4);
    d->VertexAttribI1uivEXT(index, v);
}

inline void QOpenGLExtension_NV_vertex_program4::glVertexAttribI4ivEXT(GLuint index, const GLint *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program4);
    d->VertexAttribI4ivEXT(index, v);
}

inline void QOpenGLExtension_NV_vertex_program4::glVertexAttribI3ivEXT(GLuint index, const GLint *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program4);
    d->VertexAttribI3ivEXT(index, v);
}

inline void QOpenGLExtension_NV_vertex_program4::glVertexAttribI2ivEXT(GLuint index, const GLint *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program4);
    d->VertexAttribI2ivEXT(index, v);
}

inline void QOpenGLExtension_NV_vertex_program4::glVertexAttribI1ivEXT(GLuint index, const GLint *v)
{
    Q_D(QOpenGLExtension_NV_vertex_program4);
    d->VertexAttribI1ivEXT(index, v);
}

inline void QOpenGLExtension_NV_vertex_program4::glVertexAttribI4uiEXT(GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)
{
    Q_D(QOpenGLExtension_NV_vertex_program4);
    d->VertexAttribI4uiEXT(index, x, y, z, w);
}

inline void QOpenGLExtension_NV_vertex_program4::glVertexAttribI3uiEXT(GLuint index, GLuint x, GLuint y, GLuint z)
{
    Q_D(QOpenGLExtension_NV_vertex_program4);
    d->VertexAttribI3uiEXT(index, x, y, z);
}

inline void QOpenGLExtension_NV_vertex_program4::glVertexAttribI2uiEXT(GLuint index, GLuint x, GLuint y)
{
    Q_D(QOpenGLExtension_NV_vertex_program4);
    d->VertexAttribI2uiEXT(index, x, y);
}

inline void QOpenGLExtension_NV_vertex_program4::glVertexAttribI1uiEXT(GLuint index, GLuint x)
{
    Q_D(QOpenGLExtension_NV_vertex_program4);
    d->VertexAttribI1uiEXT(index, x);
}

inline void QOpenGLExtension_NV_vertex_program4::glVertexAttribI4iEXT(GLuint index, GLint x, GLint y, GLint z, GLint w)
{
    Q_D(QOpenGLExtension_NV_vertex_program4);
    d->VertexAttribI4iEXT(index, x, y, z, w);
}

inline void QOpenGLExtension_NV_vertex_program4::glVertexAttribI3iEXT(GLuint index, GLint x, GLint y, GLint z)
{
    Q_D(QOpenGLExtension_NV_vertex_program4);
    d->VertexAttribI3iEXT(index, x, y, z);
}

inline void QOpenGLExtension_NV_vertex_program4::glVertexAttribI2iEXT(GLuint index, GLint x, GLint y)
{
    Q_D(QOpenGLExtension_NV_vertex_program4);
    d->VertexAttribI2iEXT(index, x, y);
}

inline void QOpenGLExtension_NV_vertex_program4::glVertexAttribI1iEXT(GLuint index, GLint x)
{
    Q_D(QOpenGLExtension_NV_vertex_program4);
    d->VertexAttribI1iEXT(index, x);
}

class QOpenGLExtension_NV_video_capturePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP VideoCaptureStreamParameterdvNV)(GLuint video_capture_slot, GLuint stream, GLenum pname, const GLdouble *params);
    void (QOPENGLF_APIENTRYP VideoCaptureStreamParameterfvNV)(GLuint video_capture_slot, GLuint stream, GLenum pname, const GLfloat *params);
    void (QOPENGLF_APIENTRYP VideoCaptureStreamParameterivNV)(GLuint video_capture_slot, GLuint stream, GLenum pname, const GLint *params);
    GLenum (QOPENGLF_APIENTRYP VideoCaptureNV)(GLuint video_capture_slot, GLuint *sequence_num, GLuint64EXT *capture_time);
    void (QOPENGLF_APIENTRYP GetVideoCaptureStreamdvNV)(GLuint video_capture_slot, GLuint stream, GLenum pname, GLdouble *params);
    void (QOPENGLF_APIENTRYP GetVideoCaptureStreamfvNV)(GLuint video_capture_slot, GLuint stream, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP GetVideoCaptureStreamivNV)(GLuint video_capture_slot, GLuint stream, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetVideoCaptureivNV)(GLuint video_capture_slot, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP EndVideoCaptureNV)(GLuint video_capture_slot);
    void (QOPENGLF_APIENTRYP BindVideoCaptureStreamTextureNV)(GLuint video_capture_slot, GLuint stream, GLenum frame_region, GLenum target, GLuint texture);
    void (QOPENGLF_APIENTRYP BindVideoCaptureStreamBufferNV)(GLuint video_capture_slot, GLuint stream, GLenum frame_region, GLintptrARB offset);
    void (QOPENGLF_APIENTRYP BeginVideoCaptureNV)(GLuint video_capture_slot);
};

class QOpenGLExtension_NV_video_capture : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_video_capture();

    bool initializeOpenGLFunctions() final;

    void glVideoCaptureStreamParameterdvNV(GLuint video_capture_slot, GLuint stream, GLenum pname, const GLdouble *params);
    void glVideoCaptureStreamParameterfvNV(GLuint video_capture_slot, GLuint stream, GLenum pname, const GLfloat *params);
    void glVideoCaptureStreamParameterivNV(GLuint video_capture_slot, GLuint stream, GLenum pname, const GLint *params);
    GLenum glVideoCaptureNV(GLuint video_capture_slot, GLuint *sequence_num, GLuint64EXT *capture_time);
    void glGetVideoCaptureStreamdvNV(GLuint video_capture_slot, GLuint stream, GLenum pname, GLdouble *params);
    void glGetVideoCaptureStreamfvNV(GLuint video_capture_slot, GLuint stream, GLenum pname, GLfloat *params);
    void glGetVideoCaptureStreamivNV(GLuint video_capture_slot, GLuint stream, GLenum pname, GLint *params);
    void glGetVideoCaptureivNV(GLuint video_capture_slot, GLenum pname, GLint *params);
    void glEndVideoCaptureNV(GLuint video_capture_slot);
    void glBindVideoCaptureStreamTextureNV(GLuint video_capture_slot, GLuint stream, GLenum frame_region, GLenum target, GLuint texture);
    void glBindVideoCaptureStreamBufferNV(GLuint video_capture_slot, GLuint stream, GLenum frame_region, GLintptrARB offset);
    void glBeginVideoCaptureNV(GLuint video_capture_slot);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_video_capture)
};

inline void QOpenGLExtension_NV_video_capture::glVideoCaptureStreamParameterdvNV(GLuint video_capture_slot, GLuint stream, GLenum pname, const GLdouble *params)
{
    Q_D(QOpenGLExtension_NV_video_capture);
    d->VideoCaptureStreamParameterdvNV(video_capture_slot, stream, pname, params);
}

inline void QOpenGLExtension_NV_video_capture::glVideoCaptureStreamParameterfvNV(GLuint video_capture_slot, GLuint stream, GLenum pname, const GLfloat *params)
{
    Q_D(QOpenGLExtension_NV_video_capture);
    d->VideoCaptureStreamParameterfvNV(video_capture_slot, stream, pname, params);
}

inline void QOpenGLExtension_NV_video_capture::glVideoCaptureStreamParameterivNV(GLuint video_capture_slot, GLuint stream, GLenum pname, const GLint *params)
{
    Q_D(QOpenGLExtension_NV_video_capture);
    d->VideoCaptureStreamParameterivNV(video_capture_slot, stream, pname, params);
}

inline GLenum QOpenGLExtension_NV_video_capture::glVideoCaptureNV(GLuint video_capture_slot, GLuint *sequence_num, GLuint64EXT *capture_time)
{
    Q_D(QOpenGLExtension_NV_video_capture);
    return d->VideoCaptureNV(video_capture_slot, sequence_num, capture_time);
}

inline void QOpenGLExtension_NV_video_capture::glGetVideoCaptureStreamdvNV(GLuint video_capture_slot, GLuint stream, GLenum pname, GLdouble *params)
{
    Q_D(QOpenGLExtension_NV_video_capture);
    d->GetVideoCaptureStreamdvNV(video_capture_slot, stream, pname, params);
}

inline void QOpenGLExtension_NV_video_capture::glGetVideoCaptureStreamfvNV(GLuint video_capture_slot, GLuint stream, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_NV_video_capture);
    d->GetVideoCaptureStreamfvNV(video_capture_slot, stream, pname, params);
}

inline void QOpenGLExtension_NV_video_capture::glGetVideoCaptureStreamivNV(GLuint video_capture_slot, GLuint stream, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_NV_video_capture);
    d->GetVideoCaptureStreamivNV(video_capture_slot, stream, pname, params);
}

inline void QOpenGLExtension_NV_video_capture::glGetVideoCaptureivNV(GLuint video_capture_slot, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_NV_video_capture);
    d->GetVideoCaptureivNV(video_capture_slot, pname, params);
}

inline void QOpenGLExtension_NV_video_capture::glEndVideoCaptureNV(GLuint video_capture_slot)
{
    Q_D(QOpenGLExtension_NV_video_capture);
    d->EndVideoCaptureNV(video_capture_slot);
}

inline void QOpenGLExtension_NV_video_capture::glBindVideoCaptureStreamTextureNV(GLuint video_capture_slot, GLuint stream, GLenum frame_region, GLenum target, GLuint texture)
{
    Q_D(QOpenGLExtension_NV_video_capture);
    d->BindVideoCaptureStreamTextureNV(video_capture_slot, stream, frame_region, target, texture);
}

inline void QOpenGLExtension_NV_video_capture::glBindVideoCaptureStreamBufferNV(GLuint video_capture_slot, GLuint stream, GLenum frame_region, GLintptrARB offset)
{
    Q_D(QOpenGLExtension_NV_video_capture);
    d->BindVideoCaptureStreamBufferNV(video_capture_slot, stream, frame_region, offset);
}

inline void QOpenGLExtension_NV_video_capture::glBeginVideoCaptureNV(GLuint video_capture_slot)
{
    Q_D(QOpenGLExtension_NV_video_capture);
    d->BeginVideoCaptureNV(video_capture_slot);
}

class QOpenGLExtension_PGI_misc_hintsPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP HintPGI)(GLenum target, GLint mode);
};

class QOpenGLExtension_PGI_misc_hints : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_PGI_misc_hints();

    bool initializeOpenGLFunctions() final;

    void glHintPGI(GLenum target, GLint mode);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_PGI_misc_hints)
};

inline void QOpenGLExtension_PGI_misc_hints::glHintPGI(GLenum target, GLint mode)
{
    Q_D(QOpenGLExtension_PGI_misc_hints);
    d->HintPGI(target, mode);
}

class QOpenGLExtension_SGIS_detail_texturePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetDetailTexFuncSGIS)(GLenum target, GLfloat *points);
    void (QOPENGLF_APIENTRYP DetailTexFuncSGIS)(GLenum target, GLsizei n, const GLfloat *points);
};

class QOpenGLExtension_SGIS_detail_texture : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_SGIS_detail_texture();

    bool initializeOpenGLFunctions() final;

    void glGetDetailTexFuncSGIS(GLenum target, GLfloat *points);
    void glDetailTexFuncSGIS(GLenum target, GLsizei n, const GLfloat *points);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_SGIS_detail_texture)
};

inline void QOpenGLExtension_SGIS_detail_texture::glGetDetailTexFuncSGIS(GLenum target, GLfloat *points)
{
    Q_D(QOpenGLExtension_SGIS_detail_texture);
    d->GetDetailTexFuncSGIS(target, points);
}

inline void QOpenGLExtension_SGIS_detail_texture::glDetailTexFuncSGIS(GLenum target, GLsizei n, const GLfloat *points)
{
    Q_D(QOpenGLExtension_SGIS_detail_texture);
    d->DetailTexFuncSGIS(target, n, points);
}

class QOpenGLExtension_SGIS_fog_functionPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetFogFuncSGIS)(GLfloat *points);
    void (QOPENGLF_APIENTRYP FogFuncSGIS)(GLsizei n, const GLfloat *points);
};

class QOpenGLExtension_SGIS_fog_function : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_SGIS_fog_function();

    bool initializeOpenGLFunctions() final;

    void glGetFogFuncSGIS(GLfloat *points);
    void glFogFuncSGIS(GLsizei n, const GLfloat *points);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_SGIS_fog_function)
};

inline void QOpenGLExtension_SGIS_fog_function::glGetFogFuncSGIS(GLfloat *points)
{
    Q_D(QOpenGLExtension_SGIS_fog_function);
    d->GetFogFuncSGIS(points);
}

inline void QOpenGLExtension_SGIS_fog_function::glFogFuncSGIS(GLsizei n, const GLfloat *points)
{
    Q_D(QOpenGLExtension_SGIS_fog_function);
    d->FogFuncSGIS(n, points);
}

class QOpenGLExtension_SGIS_multisamplePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP SamplePatternSGIS)(GLenum pattern);
    void (QOPENGLF_APIENTRYP SampleMaskSGIS)(GLclampf value, GLboolean invert);
};

class QOpenGLExtension_SGIS_multisample : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_SGIS_multisample();

    bool initializeOpenGLFunctions() final;

    void glSamplePatternSGIS(GLenum pattern);
    void glSampleMaskSGIS(GLclampf value, GLboolean invert);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_SGIS_multisample)
};

inline void QOpenGLExtension_SGIS_multisample::glSamplePatternSGIS(GLenum pattern)
{
    Q_D(QOpenGLExtension_SGIS_multisample);
    d->SamplePatternSGIS(pattern);
}

inline void QOpenGLExtension_SGIS_multisample::glSampleMaskSGIS(GLclampf value, GLboolean invert)
{
    Q_D(QOpenGLExtension_SGIS_multisample);
    d->SampleMaskSGIS(value, invert);
}

class QOpenGLExtension_SGIS_pixel_texturePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetPixelTexGenParameterfvSGIS)(GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP GetPixelTexGenParameterivSGIS)(GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP PixelTexGenParameterfvSGIS)(GLenum pname, const GLfloat *params);
    void (QOPENGLF_APIENTRYP PixelTexGenParameterfSGIS)(GLenum pname, GLfloat param);
    void (QOPENGLF_APIENTRYP PixelTexGenParameterivSGIS)(GLenum pname, const GLint *params);
    void (QOPENGLF_APIENTRYP PixelTexGenParameteriSGIS)(GLenum pname, GLint param);
};

class QOpenGLExtension_SGIS_pixel_texture : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_SGIS_pixel_texture();

    bool initializeOpenGLFunctions() final;

    void glGetPixelTexGenParameterfvSGIS(GLenum pname, GLfloat *params);
    void glGetPixelTexGenParameterivSGIS(GLenum pname, GLint *params);
    void glPixelTexGenParameterfvSGIS(GLenum pname, const GLfloat *params);
    void glPixelTexGenParameterfSGIS(GLenum pname, GLfloat param);
    void glPixelTexGenParameterivSGIS(GLenum pname, const GLint *params);
    void glPixelTexGenParameteriSGIS(GLenum pname, GLint param);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_SGIS_pixel_texture)
};

inline void QOpenGLExtension_SGIS_pixel_texture::glGetPixelTexGenParameterfvSGIS(GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_SGIS_pixel_texture);
    d->GetPixelTexGenParameterfvSGIS(pname, params);
}

inline void QOpenGLExtension_SGIS_pixel_texture::glGetPixelTexGenParameterivSGIS(GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_SGIS_pixel_texture);
    d->GetPixelTexGenParameterivSGIS(pname, params);
}

inline void QOpenGLExtension_SGIS_pixel_texture::glPixelTexGenParameterfvSGIS(GLenum pname, const GLfloat *params)
{
    Q_D(QOpenGLExtension_SGIS_pixel_texture);
    d->PixelTexGenParameterfvSGIS(pname, params);
}

inline void QOpenGLExtension_SGIS_pixel_texture::glPixelTexGenParameterfSGIS(GLenum pname, GLfloat param)
{
    Q_D(QOpenGLExtension_SGIS_pixel_texture);
    d->PixelTexGenParameterfSGIS(pname, param);
}

inline void QOpenGLExtension_SGIS_pixel_texture::glPixelTexGenParameterivSGIS(GLenum pname, const GLint *params)
{
    Q_D(QOpenGLExtension_SGIS_pixel_texture);
    d->PixelTexGenParameterivSGIS(pname, params);
}

inline void QOpenGLExtension_SGIS_pixel_texture::glPixelTexGenParameteriSGIS(GLenum pname, GLint param)
{
    Q_D(QOpenGLExtension_SGIS_pixel_texture);
    d->PixelTexGenParameteriSGIS(pname, param);
}

class QOpenGLExtension_SGIS_point_parametersPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP PointParameterfvSGIS)(GLenum pname, const GLfloat *params);
    void (QOPENGLF_APIENTRYP PointParameterfSGIS)(GLenum pname, GLfloat param);
};

class QOpenGLExtension_SGIS_point_parameters : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_SGIS_point_parameters();

    bool initializeOpenGLFunctions() final;

    void glPointParameterfvSGIS(GLenum pname, const GLfloat *params);
    void glPointParameterfSGIS(GLenum pname, GLfloat param);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_SGIS_point_parameters)
};

inline void QOpenGLExtension_SGIS_point_parameters::glPointParameterfvSGIS(GLenum pname, const GLfloat *params)
{
    Q_D(QOpenGLExtension_SGIS_point_parameters);
    d->PointParameterfvSGIS(pname, params);
}

inline void QOpenGLExtension_SGIS_point_parameters::glPointParameterfSGIS(GLenum pname, GLfloat param)
{
    Q_D(QOpenGLExtension_SGIS_point_parameters);
    d->PointParameterfSGIS(pname, param);
}

class QOpenGLExtension_SGIS_sharpen_texturePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetSharpenTexFuncSGIS)(GLenum target, GLfloat *points);
    void (QOPENGLF_APIENTRYP SharpenTexFuncSGIS)(GLenum target, GLsizei n, const GLfloat *points);
};

class QOpenGLExtension_SGIS_sharpen_texture : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_SGIS_sharpen_texture();

    bool initializeOpenGLFunctions() final;

    void glGetSharpenTexFuncSGIS(GLenum target, GLfloat *points);
    void glSharpenTexFuncSGIS(GLenum target, GLsizei n, const GLfloat *points);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_SGIS_sharpen_texture)
};

inline void QOpenGLExtension_SGIS_sharpen_texture::glGetSharpenTexFuncSGIS(GLenum target, GLfloat *points)
{
    Q_D(QOpenGLExtension_SGIS_sharpen_texture);
    d->GetSharpenTexFuncSGIS(target, points);
}

inline void QOpenGLExtension_SGIS_sharpen_texture::glSharpenTexFuncSGIS(GLenum target, GLsizei n, const GLfloat *points)
{
    Q_D(QOpenGLExtension_SGIS_sharpen_texture);
    d->SharpenTexFuncSGIS(target, n, points);
}

class QOpenGLExtension_SGIS_texture4DPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP TexSubImage4DSGIS)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint woffset, GLsizei width, GLsizei height, GLsizei depth, GLsizei size4d, GLenum format, GLenum type, const GLvoid *pixels);
    void (QOPENGLF_APIENTRYP TexImage4DSGIS)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLsizei size4d, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
};

class QOpenGLExtension_SGIS_texture4D : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_SGIS_texture4D();

    bool initializeOpenGLFunctions() final;

    void glTexSubImage4DSGIS(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint woffset, GLsizei width, GLsizei height, GLsizei depth, GLsizei size4d, GLenum format, GLenum type, const GLvoid *pixels);
    void glTexImage4DSGIS(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLsizei size4d, GLint border, GLenum format, GLenum type, const GLvoid *pixels);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_SGIS_texture4D)
};

inline void QOpenGLExtension_SGIS_texture4D::glTexSubImage4DSGIS(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint woffset, GLsizei width, GLsizei height, GLsizei depth, GLsizei size4d, GLenum format, GLenum type, const GLvoid *pixels)
{
    Q_D(QOpenGLExtension_SGIS_texture4D);
    d->TexSubImage4DSGIS(target, level, xoffset, yoffset, zoffset, woffset, width, height, depth, size4d, format, type, pixels);
}

inline void QOpenGLExtension_SGIS_texture4D::glTexImage4DSGIS(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLsizei size4d, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
    Q_D(QOpenGLExtension_SGIS_texture4D);
    d->TexImage4DSGIS(target, level, internalformat, width, height, depth, size4d, border, format, type, pixels);
}

class QOpenGLExtension_SGIS_texture_color_maskPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP TextureColorMaskSGIS)(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);
};

class QOpenGLExtension_SGIS_texture_color_mask : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_SGIS_texture_color_mask();

    bool initializeOpenGLFunctions() final;

    void glTextureColorMaskSGIS(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_SGIS_texture_color_mask)
};

inline void QOpenGLExtension_SGIS_texture_color_mask::glTextureColorMaskSGIS(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha)
{
    Q_D(QOpenGLExtension_SGIS_texture_color_mask);
    d->TextureColorMaskSGIS(red, green, blue, alpha);
}

class QOpenGLExtension_SGIS_texture_filter4Private : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP TexFilterFuncSGIS)(GLenum target, GLenum filter, GLsizei n, const GLfloat *weights);
    void (QOPENGLF_APIENTRYP GetTexFilterFuncSGIS)(GLenum target, GLenum filter, GLfloat *weights);
};

class QOpenGLExtension_SGIS_texture_filter4 : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_SGIS_texture_filter4();

    bool initializeOpenGLFunctions() final;

    void glTexFilterFuncSGIS(GLenum target, GLenum filter, GLsizei n, const GLfloat *weights);
    void glGetTexFilterFuncSGIS(GLenum target, GLenum filter, GLfloat *weights);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_SGIS_texture_filter4)
};

inline void QOpenGLExtension_SGIS_texture_filter4::glTexFilterFuncSGIS(GLenum target, GLenum filter, GLsizei n, const GLfloat *weights)
{
    Q_D(QOpenGLExtension_SGIS_texture_filter4);
    d->TexFilterFuncSGIS(target, filter, n, weights);
}

inline void QOpenGLExtension_SGIS_texture_filter4::glGetTexFilterFuncSGIS(GLenum target, GLenum filter, GLfloat *weights)
{
    Q_D(QOpenGLExtension_SGIS_texture_filter4);
    d->GetTexFilterFuncSGIS(target, filter, weights);
}

class QOpenGLExtension_SGIX_asyncPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    GLboolean (QOPENGLF_APIENTRYP IsAsyncMarkerSGIX)(GLuint marker);
    void (QOPENGLF_APIENTRYP DeleteAsyncMarkersSGIX)(GLuint marker, GLsizei range);
    GLuint (QOPENGLF_APIENTRYP GenAsyncMarkersSGIX)(GLsizei range);
    GLint (QOPENGLF_APIENTRYP PollAsyncSGIX)(GLuint *markerp);
    GLint (QOPENGLF_APIENTRYP FinishAsyncSGIX)(GLuint *markerp);
    void (QOPENGLF_APIENTRYP AsyncMarkerSGIX)(GLuint marker);
};

class QOpenGLExtension_SGIX_async : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_SGIX_async();

    bool initializeOpenGLFunctions() final;

    GLboolean glIsAsyncMarkerSGIX(GLuint marker);
    void glDeleteAsyncMarkersSGIX(GLuint marker, GLsizei range);
    GLuint glGenAsyncMarkersSGIX(GLsizei range);
    GLint glPollAsyncSGIX(GLuint *markerp);
    GLint glFinishAsyncSGIX(GLuint *markerp);
    void glAsyncMarkerSGIX(GLuint marker);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_SGIX_async)
};

inline GLboolean QOpenGLExtension_SGIX_async::glIsAsyncMarkerSGIX(GLuint marker)
{
    Q_D(QOpenGLExtension_SGIX_async);
    return d->IsAsyncMarkerSGIX(marker);
}

inline void QOpenGLExtension_SGIX_async::glDeleteAsyncMarkersSGIX(GLuint marker, GLsizei range)
{
    Q_D(QOpenGLExtension_SGIX_async);
    d->DeleteAsyncMarkersSGIX(marker, range);
}

inline GLuint QOpenGLExtension_SGIX_async::glGenAsyncMarkersSGIX(GLsizei range)
{
    Q_D(QOpenGLExtension_SGIX_async);
    return d->GenAsyncMarkersSGIX(range);
}

inline GLint QOpenGLExtension_SGIX_async::glPollAsyncSGIX(GLuint *markerp)
{
    Q_D(QOpenGLExtension_SGIX_async);
    return d->PollAsyncSGIX(markerp);
}

inline GLint QOpenGLExtension_SGIX_async::glFinishAsyncSGIX(GLuint *markerp)
{
    Q_D(QOpenGLExtension_SGIX_async);
    return d->FinishAsyncSGIX(markerp);
}

inline void QOpenGLExtension_SGIX_async::glAsyncMarkerSGIX(GLuint marker)
{
    Q_D(QOpenGLExtension_SGIX_async);
    d->AsyncMarkerSGIX(marker);
}

class QOpenGLExtension_SGIX_flush_rasterPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP FlushRasterSGIX)();
};

class QOpenGLExtension_SGIX_flush_raster : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_SGIX_flush_raster();

    bool initializeOpenGLFunctions() final;

    void glFlushRasterSGIX();

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_SGIX_flush_raster)
};

inline void QOpenGLExtension_SGIX_flush_raster::glFlushRasterSGIX()
{
    Q_D(QOpenGLExtension_SGIX_flush_raster);
    d->FlushRasterSGIX();
}

class QOpenGLExtension_SGIX_fragment_lightingPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP LightEnviSGIX)(GLenum pname, GLint param);
    void (QOPENGLF_APIENTRYP GetFragmentMaterialivSGIX)(GLenum face, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetFragmentMaterialfvSGIX)(GLenum face, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP GetFragmentLightivSGIX)(GLenum light, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetFragmentLightfvSGIX)(GLenum light, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP FragmentMaterialivSGIX)(GLenum face, GLenum pname, const GLint *params);
    void (QOPENGLF_APIENTRYP FragmentMaterialiSGIX)(GLenum face, GLenum pname, GLint param);
    void (QOPENGLF_APIENTRYP FragmentMaterialfvSGIX)(GLenum face, GLenum pname, const GLfloat *params);
    void (QOPENGLF_APIENTRYP FragmentMaterialfSGIX)(GLenum face, GLenum pname, GLfloat param);
    void (QOPENGLF_APIENTRYP FragmentLightModelivSGIX)(GLenum pname, const GLint *params);
    void (QOPENGLF_APIENTRYP FragmentLightModeliSGIX)(GLenum pname, GLint param);
    void (QOPENGLF_APIENTRYP FragmentLightModelfvSGIX)(GLenum pname, const GLfloat *params);
    void (QOPENGLF_APIENTRYP FragmentLightModelfSGIX)(GLenum pname, GLfloat param);
    void (QOPENGLF_APIENTRYP FragmentLightivSGIX)(GLenum light, GLenum pname, const GLint *params);
    void (QOPENGLF_APIENTRYP FragmentLightiSGIX)(GLenum light, GLenum pname, GLint param);
    void (QOPENGLF_APIENTRYP FragmentLightfvSGIX)(GLenum light, GLenum pname, const GLfloat *params);
    void (QOPENGLF_APIENTRYP FragmentLightfSGIX)(GLenum light, GLenum pname, GLfloat param);
    void (QOPENGLF_APIENTRYP FragmentColorMaterialSGIX)(GLenum face, GLenum mode);
};

class QOpenGLExtension_SGIX_fragment_lighting : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_SGIX_fragment_lighting();

    bool initializeOpenGLFunctions() final;

    void glLightEnviSGIX(GLenum pname, GLint param);
    void glGetFragmentMaterialivSGIX(GLenum face, GLenum pname, GLint *params);
    void glGetFragmentMaterialfvSGIX(GLenum face, GLenum pname, GLfloat *params);
    void glGetFragmentLightivSGIX(GLenum light, GLenum pname, GLint *params);
    void glGetFragmentLightfvSGIX(GLenum light, GLenum pname, GLfloat *params);
    void glFragmentMaterialivSGIX(GLenum face, GLenum pname, const GLint *params);
    void glFragmentMaterialiSGIX(GLenum face, GLenum pname, GLint param);
    void glFragmentMaterialfvSGIX(GLenum face, GLenum pname, const GLfloat *params);
    void glFragmentMaterialfSGIX(GLenum face, GLenum pname, GLfloat param);
    void glFragmentLightModelivSGIX(GLenum pname, const GLint *params);
    void glFragmentLightModeliSGIX(GLenum pname, GLint param);
    void glFragmentLightModelfvSGIX(GLenum pname, const GLfloat *params);
    void glFragmentLightModelfSGIX(GLenum pname, GLfloat param);
    void glFragmentLightivSGIX(GLenum light, GLenum pname, const GLint *params);
    void glFragmentLightiSGIX(GLenum light, GLenum pname, GLint param);
    void glFragmentLightfvSGIX(GLenum light, GLenum pname, const GLfloat *params);
    void glFragmentLightfSGIX(GLenum light, GLenum pname, GLfloat param);
    void glFragmentColorMaterialSGIX(GLenum face, GLenum mode);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_SGIX_fragment_lighting)
};

inline void QOpenGLExtension_SGIX_fragment_lighting::glLightEnviSGIX(GLenum pname, GLint param)
{
    Q_D(QOpenGLExtension_SGIX_fragment_lighting);
    d->LightEnviSGIX(pname, param);
}

inline void QOpenGLExtension_SGIX_fragment_lighting::glGetFragmentMaterialivSGIX(GLenum face, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_SGIX_fragment_lighting);
    d->GetFragmentMaterialivSGIX(face, pname, params);
}

inline void QOpenGLExtension_SGIX_fragment_lighting::glGetFragmentMaterialfvSGIX(GLenum face, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_SGIX_fragment_lighting);
    d->GetFragmentMaterialfvSGIX(face, pname, params);
}

inline void QOpenGLExtension_SGIX_fragment_lighting::glGetFragmentLightivSGIX(GLenum light, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_SGIX_fragment_lighting);
    d->GetFragmentLightivSGIX(light, pname, params);
}

inline void QOpenGLExtension_SGIX_fragment_lighting::glGetFragmentLightfvSGIX(GLenum light, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_SGIX_fragment_lighting);
    d->GetFragmentLightfvSGIX(light, pname, params);
}

inline void QOpenGLExtension_SGIX_fragment_lighting::glFragmentMaterialivSGIX(GLenum face, GLenum pname, const GLint *params)
{
    Q_D(QOpenGLExtension_SGIX_fragment_lighting);
    d->FragmentMaterialivSGIX(face, pname, params);
}

inline void QOpenGLExtension_SGIX_fragment_lighting::glFragmentMaterialiSGIX(GLenum face, GLenum pname, GLint param)
{
    Q_D(QOpenGLExtension_SGIX_fragment_lighting);
    d->FragmentMaterialiSGIX(face, pname, param);
}

inline void QOpenGLExtension_SGIX_fragment_lighting::glFragmentMaterialfvSGIX(GLenum face, GLenum pname, const GLfloat *params)
{
    Q_D(QOpenGLExtension_SGIX_fragment_lighting);
    d->FragmentMaterialfvSGIX(face, pname, params);
}

inline void QOpenGLExtension_SGIX_fragment_lighting::glFragmentMaterialfSGIX(GLenum face, GLenum pname, GLfloat param)
{
    Q_D(QOpenGLExtension_SGIX_fragment_lighting);
    d->FragmentMaterialfSGIX(face, pname, param);
}

inline void QOpenGLExtension_SGIX_fragment_lighting::glFragmentLightModelivSGIX(GLenum pname, const GLint *params)
{
    Q_D(QOpenGLExtension_SGIX_fragment_lighting);
    d->FragmentLightModelivSGIX(pname, params);
}

inline void QOpenGLExtension_SGIX_fragment_lighting::glFragmentLightModeliSGIX(GLenum pname, GLint param)
{
    Q_D(QOpenGLExtension_SGIX_fragment_lighting);
    d->FragmentLightModeliSGIX(pname, param);
}

inline void QOpenGLExtension_SGIX_fragment_lighting::glFragmentLightModelfvSGIX(GLenum pname, const GLfloat *params)
{
    Q_D(QOpenGLExtension_SGIX_fragment_lighting);
    d->FragmentLightModelfvSGIX(pname, params);
}

inline void QOpenGLExtension_SGIX_fragment_lighting::glFragmentLightModelfSGIX(GLenum pname, GLfloat param)
{
    Q_D(QOpenGLExtension_SGIX_fragment_lighting);
    d->FragmentLightModelfSGIX(pname, param);
}

inline void QOpenGLExtension_SGIX_fragment_lighting::glFragmentLightivSGIX(GLenum light, GLenum pname, const GLint *params)
{
    Q_D(QOpenGLExtension_SGIX_fragment_lighting);
    d->FragmentLightivSGIX(light, pname, params);
}

inline void QOpenGLExtension_SGIX_fragment_lighting::glFragmentLightiSGIX(GLenum light, GLenum pname, GLint param)
{
    Q_D(QOpenGLExtension_SGIX_fragment_lighting);
    d->FragmentLightiSGIX(light, pname, param);
}

inline void QOpenGLExtension_SGIX_fragment_lighting::glFragmentLightfvSGIX(GLenum light, GLenum pname, const GLfloat *params)
{
    Q_D(QOpenGLExtension_SGIX_fragment_lighting);
    d->FragmentLightfvSGIX(light, pname, params);
}

inline void QOpenGLExtension_SGIX_fragment_lighting::glFragmentLightfSGIX(GLenum light, GLenum pname, GLfloat param)
{
    Q_D(QOpenGLExtension_SGIX_fragment_lighting);
    d->FragmentLightfSGIX(light, pname, param);
}

inline void QOpenGLExtension_SGIX_fragment_lighting::glFragmentColorMaterialSGIX(GLenum face, GLenum mode)
{
    Q_D(QOpenGLExtension_SGIX_fragment_lighting);
    d->FragmentColorMaterialSGIX(face, mode);
}

class QOpenGLExtension_SGIX_framezoomPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP FrameZoomSGIX)(GLint factor);
};

class QOpenGLExtension_SGIX_framezoom : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_SGIX_framezoom();

    bool initializeOpenGLFunctions() final;

    void glFrameZoomSGIX(GLint factor);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_SGIX_framezoom)
};

inline void QOpenGLExtension_SGIX_framezoom::glFrameZoomSGIX(GLint factor)
{
    Q_D(QOpenGLExtension_SGIX_framezoom);
    d->FrameZoomSGIX(factor);
}

class QOpenGLExtension_SGIX_igloo_interfacePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP IglooInterfaceSGIX)(GLenum pname, const GLvoid *params);
};

class QOpenGLExtension_SGIX_igloo_interface : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_SGIX_igloo_interface();

    bool initializeOpenGLFunctions() final;

    void glIglooInterfaceSGIX(GLenum pname, const GLvoid *params);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_SGIX_igloo_interface)
};

inline void QOpenGLExtension_SGIX_igloo_interface::glIglooInterfaceSGIX(GLenum pname, const GLvoid *params)
{
    Q_D(QOpenGLExtension_SGIX_igloo_interface);
    d->IglooInterfaceSGIX(pname, params);
}

class QOpenGLExtension_SGIX_instrumentsPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP StopInstrumentsSGIX)(GLint marker);
    void (QOPENGLF_APIENTRYP StartInstrumentsSGIX)();
    void (QOPENGLF_APIENTRYP ReadInstrumentsSGIX)(GLint marker);
    GLint (QOPENGLF_APIENTRYP PollInstrumentsSGIX)(GLint *marker_p);
    void (QOPENGLF_APIENTRYP InstrumentsBufferSGIX)(GLsizei size, GLint *buffer);
    GLint (QOPENGLF_APIENTRYP GetInstrumentsSGIX)();
};

class QOpenGLExtension_SGIX_instruments : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_SGIX_instruments();

    bool initializeOpenGLFunctions() final;

    void glStopInstrumentsSGIX(GLint marker);
    void glStartInstrumentsSGIX();
    void glReadInstrumentsSGIX(GLint marker);
    GLint glPollInstrumentsSGIX(GLint *marker_p);
    void glInstrumentsBufferSGIX(GLsizei size, GLint *buffer);
    GLint glGetInstrumentsSGIX();

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_SGIX_instruments)
};

inline void QOpenGLExtension_SGIX_instruments::glStopInstrumentsSGIX(GLint marker)
{
    Q_D(QOpenGLExtension_SGIX_instruments);
    d->StopInstrumentsSGIX(marker);
}

inline void QOpenGLExtension_SGIX_instruments::glStartInstrumentsSGIX()
{
    Q_D(QOpenGLExtension_SGIX_instruments);
    d->StartInstrumentsSGIX();
}

inline void QOpenGLExtension_SGIX_instruments::glReadInstrumentsSGIX(GLint marker)
{
    Q_D(QOpenGLExtension_SGIX_instruments);
    d->ReadInstrumentsSGIX(marker);
}

inline GLint QOpenGLExtension_SGIX_instruments::glPollInstrumentsSGIX(GLint *marker_p)
{
    Q_D(QOpenGLExtension_SGIX_instruments);
    return d->PollInstrumentsSGIX(marker_p);
}

inline void QOpenGLExtension_SGIX_instruments::glInstrumentsBufferSGIX(GLsizei size, GLint *buffer)
{
    Q_D(QOpenGLExtension_SGIX_instruments);
    d->InstrumentsBufferSGIX(size, buffer);
}

inline GLint QOpenGLExtension_SGIX_instruments::glGetInstrumentsSGIX()
{
    Q_D(QOpenGLExtension_SGIX_instruments);
    return d->GetInstrumentsSGIX();
}

class QOpenGLExtension_SGIX_list_priorityPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP ListParameterivSGIX)(GLuint list, GLenum pname, const GLint *params);
    void (QOPENGLF_APIENTRYP ListParameteriSGIX)(GLuint list, GLenum pname, GLint param);
    void (QOPENGLF_APIENTRYP ListParameterfvSGIX)(GLuint list, GLenum pname, const GLfloat *params);
    void (QOPENGLF_APIENTRYP ListParameterfSGIX)(GLuint list, GLenum pname, GLfloat param);
    void (QOPENGLF_APIENTRYP GetListParameterivSGIX)(GLuint list, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetListParameterfvSGIX)(GLuint list, GLenum pname, GLfloat *params);
};

class QOpenGLExtension_SGIX_list_priority : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_SGIX_list_priority();

    bool initializeOpenGLFunctions() final;

    void glListParameterivSGIX(GLuint list, GLenum pname, const GLint *params);
    void glListParameteriSGIX(GLuint list, GLenum pname, GLint param);
    void glListParameterfvSGIX(GLuint list, GLenum pname, const GLfloat *params);
    void glListParameterfSGIX(GLuint list, GLenum pname, GLfloat param);
    void glGetListParameterivSGIX(GLuint list, GLenum pname, GLint *params);
    void glGetListParameterfvSGIX(GLuint list, GLenum pname, GLfloat *params);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_SGIX_list_priority)
};

inline void QOpenGLExtension_SGIX_list_priority::glListParameterivSGIX(GLuint list, GLenum pname, const GLint *params)
{
    Q_D(QOpenGLExtension_SGIX_list_priority);
    d->ListParameterivSGIX(list, pname, params);
}

inline void QOpenGLExtension_SGIX_list_priority::glListParameteriSGIX(GLuint list, GLenum pname, GLint param)
{
    Q_D(QOpenGLExtension_SGIX_list_priority);
    d->ListParameteriSGIX(list, pname, param);
}

inline void QOpenGLExtension_SGIX_list_priority::glListParameterfvSGIX(GLuint list, GLenum pname, const GLfloat *params)
{
    Q_D(QOpenGLExtension_SGIX_list_priority);
    d->ListParameterfvSGIX(list, pname, params);
}

inline void QOpenGLExtension_SGIX_list_priority::glListParameterfSGIX(GLuint list, GLenum pname, GLfloat param)
{
    Q_D(QOpenGLExtension_SGIX_list_priority);
    d->ListParameterfSGIX(list, pname, param);
}

inline void QOpenGLExtension_SGIX_list_priority::glGetListParameterivSGIX(GLuint list, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_SGIX_list_priority);
    d->GetListParameterivSGIX(list, pname, params);
}

inline void QOpenGLExtension_SGIX_list_priority::glGetListParameterfvSGIX(GLuint list, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_SGIX_list_priority);
    d->GetListParameterfvSGIX(list, pname, params);
}

class QOpenGLExtension_SGIX_pixel_texturePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP PixelTexGenSGIX)(GLenum mode);
};

class QOpenGLExtension_SGIX_pixel_texture : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_SGIX_pixel_texture();

    bool initializeOpenGLFunctions() final;

    void glPixelTexGenSGIX(GLenum mode);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_SGIX_pixel_texture)
};

inline void QOpenGLExtension_SGIX_pixel_texture::glPixelTexGenSGIX(GLenum mode)
{
    Q_D(QOpenGLExtension_SGIX_pixel_texture);
    d->PixelTexGenSGIX(mode);
}

class QOpenGLExtension_SGIX_polynomial_ffdPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP LoadIdentityDeformationMapSGIX)(GLbitfield mask);
    void (QOPENGLF_APIENTRYP DeformSGIX)(GLbitfield mask);
    void (QOPENGLF_APIENTRYP DeformationMap3fSGIX)(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, GLfloat w1, GLfloat w2, GLint wstride, GLint worder, const GLfloat *points);
    void (QOPENGLF_APIENTRYP DeformationMap3dSGIX)(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, GLdouble w1, GLdouble w2, GLint wstride, GLint worder, const GLdouble *points);
};

class QOpenGLExtension_SGIX_polynomial_ffd : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_SGIX_polynomial_ffd();

    bool initializeOpenGLFunctions() final;

    void glLoadIdentityDeformationMapSGIX(GLbitfield mask);
    void glDeformSGIX(GLbitfield mask);
    void glDeformationMap3fSGIX(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, GLfloat w1, GLfloat w2, GLint wstride, GLint worder, const GLfloat *points);
    void glDeformationMap3dSGIX(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, GLdouble w1, GLdouble w2, GLint wstride, GLint worder, const GLdouble *points);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_SGIX_polynomial_ffd)
};

inline void QOpenGLExtension_SGIX_polynomial_ffd::glLoadIdentityDeformationMapSGIX(GLbitfield mask)
{
    Q_D(QOpenGLExtension_SGIX_polynomial_ffd);
    d->LoadIdentityDeformationMapSGIX(mask);
}

inline void QOpenGLExtension_SGIX_polynomial_ffd::glDeformSGIX(GLbitfield mask)
{
    Q_D(QOpenGLExtension_SGIX_polynomial_ffd);
    d->DeformSGIX(mask);
}

inline void QOpenGLExtension_SGIX_polynomial_ffd::glDeformationMap3fSGIX(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, GLfloat w1, GLfloat w2, GLint wstride, GLint worder, const GLfloat *points)
{
    Q_D(QOpenGLExtension_SGIX_polynomial_ffd);
    d->DeformationMap3fSGIX(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, w1, w2, wstride, worder, points);
}

inline void QOpenGLExtension_SGIX_polynomial_ffd::glDeformationMap3dSGIX(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, GLdouble w1, GLdouble w2, GLint wstride, GLint worder, const GLdouble *points)
{
    Q_D(QOpenGLExtension_SGIX_polynomial_ffd);
    d->DeformationMap3dSGIX(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, w1, w2, wstride, worder, points);
}

class QOpenGLExtension_SGIX_reference_planePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP ReferencePlaneSGIX)(const GLdouble *equation);
};

class QOpenGLExtension_SGIX_reference_plane : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_SGIX_reference_plane();

    bool initializeOpenGLFunctions() final;

    void glReferencePlaneSGIX(const GLdouble *equation);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_SGIX_reference_plane)
};

inline void QOpenGLExtension_SGIX_reference_plane::glReferencePlaneSGIX(const GLdouble *equation)
{
    Q_D(QOpenGLExtension_SGIX_reference_plane);
    d->ReferencePlaneSGIX(equation);
}

class QOpenGLExtension_SGIX_spritePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP SpriteParameterivSGIX)(GLenum pname, const GLint *params);
    void (QOPENGLF_APIENTRYP SpriteParameteriSGIX)(GLenum pname, GLint param);
    void (QOPENGLF_APIENTRYP SpriteParameterfvSGIX)(GLenum pname, const GLfloat *params);
    void (QOPENGLF_APIENTRYP SpriteParameterfSGIX)(GLenum pname, GLfloat param);
};

class QOpenGLExtension_SGIX_sprite : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_SGIX_sprite();

    bool initializeOpenGLFunctions() final;

    void glSpriteParameterivSGIX(GLenum pname, const GLint *params);
    void glSpriteParameteriSGIX(GLenum pname, GLint param);
    void glSpriteParameterfvSGIX(GLenum pname, const GLfloat *params);
    void glSpriteParameterfSGIX(GLenum pname, GLfloat param);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_SGIX_sprite)
};

inline void QOpenGLExtension_SGIX_sprite::glSpriteParameterivSGIX(GLenum pname, const GLint *params)
{
    Q_D(QOpenGLExtension_SGIX_sprite);
    d->SpriteParameterivSGIX(pname, params);
}

inline void QOpenGLExtension_SGIX_sprite::glSpriteParameteriSGIX(GLenum pname, GLint param)
{
    Q_D(QOpenGLExtension_SGIX_sprite);
    d->SpriteParameteriSGIX(pname, param);
}

inline void QOpenGLExtension_SGIX_sprite::glSpriteParameterfvSGIX(GLenum pname, const GLfloat *params)
{
    Q_D(QOpenGLExtension_SGIX_sprite);
    d->SpriteParameterfvSGIX(pname, params);
}

inline void QOpenGLExtension_SGIX_sprite::glSpriteParameterfSGIX(GLenum pname, GLfloat param)
{
    Q_D(QOpenGLExtension_SGIX_sprite);
    d->SpriteParameterfSGIX(pname, param);
}

class QOpenGLExtension_SGIX_tag_sample_bufferPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP TagSampleBufferSGIX)();
};

class QOpenGLExtension_SGIX_tag_sample_buffer : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_SGIX_tag_sample_buffer();

    bool initializeOpenGLFunctions() final;

    void glTagSampleBufferSGIX();

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_SGIX_tag_sample_buffer)
};

inline void QOpenGLExtension_SGIX_tag_sample_buffer::glTagSampleBufferSGIX()
{
    Q_D(QOpenGLExtension_SGIX_tag_sample_buffer);
    d->TagSampleBufferSGIX();
}

class QOpenGLExtension_SGI_color_tablePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetColorTableParameterivSGI)(GLenum target, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetColorTableParameterfvSGI)(GLenum target, GLenum pname, GLfloat *params);
    void (QOPENGLF_APIENTRYP GetColorTableSGI)(GLenum target, GLenum format, GLenum type, GLvoid *table);
    void (QOPENGLF_APIENTRYP CopyColorTableSGI)(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width);
    void (QOPENGLF_APIENTRYP ColorTableParameterivSGI)(GLenum target, GLenum pname, const GLint *params);
    void (QOPENGLF_APIENTRYP ColorTableParameterfvSGI)(GLenum target, GLenum pname, const GLfloat *params);
    void (QOPENGLF_APIENTRYP ColorTableSGI)(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *table);
};

class QOpenGLExtension_SGI_color_table : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_SGI_color_table();

    bool initializeOpenGLFunctions() final;

    void glGetColorTableParameterivSGI(GLenum target, GLenum pname, GLint *params);
    void glGetColorTableParameterfvSGI(GLenum target, GLenum pname, GLfloat *params);
    void glGetColorTableSGI(GLenum target, GLenum format, GLenum type, GLvoid *table);
    void glCopyColorTableSGI(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width);
    void glColorTableParameterivSGI(GLenum target, GLenum pname, const GLint *params);
    void glColorTableParameterfvSGI(GLenum target, GLenum pname, const GLfloat *params);
    void glColorTableSGI(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *table);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_SGI_color_table)
};

inline void QOpenGLExtension_SGI_color_table::glGetColorTableParameterivSGI(GLenum target, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_SGI_color_table);
    d->GetColorTableParameterivSGI(target, pname, params);
}

inline void QOpenGLExtension_SGI_color_table::glGetColorTableParameterfvSGI(GLenum target, GLenum pname, GLfloat *params)
{
    Q_D(QOpenGLExtension_SGI_color_table);
    d->GetColorTableParameterfvSGI(target, pname, params);
}

inline void QOpenGLExtension_SGI_color_table::glGetColorTableSGI(GLenum target, GLenum format, GLenum type, GLvoid *table)
{
    Q_D(QOpenGLExtension_SGI_color_table);
    d->GetColorTableSGI(target, format, type, table);
}

inline void QOpenGLExtension_SGI_color_table::glCopyColorTableSGI(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width)
{
    Q_D(QOpenGLExtension_SGI_color_table);
    d->CopyColorTableSGI(target, internalformat, x, y, width);
}

inline void QOpenGLExtension_SGI_color_table::glColorTableParameterivSGI(GLenum target, GLenum pname, const GLint *params)
{
    Q_D(QOpenGLExtension_SGI_color_table);
    d->ColorTableParameterivSGI(target, pname, params);
}

inline void QOpenGLExtension_SGI_color_table::glColorTableParameterfvSGI(GLenum target, GLenum pname, const GLfloat *params)
{
    Q_D(QOpenGLExtension_SGI_color_table);
    d->ColorTableParameterfvSGI(target, pname, params);
}

inline void QOpenGLExtension_SGI_color_table::glColorTableSGI(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *table)
{
    Q_D(QOpenGLExtension_SGI_color_table);
    d->ColorTableSGI(target, internalformat, width, format, type, table);
}

class QOpenGLExtension_SUNX_constant_dataPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP FinishTextureSUNX)();
};

class QOpenGLExtension_SUNX_constant_data : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_SUNX_constant_data();

    bool initializeOpenGLFunctions() final;

    void glFinishTextureSUNX();

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_SUNX_constant_data)
};

inline void QOpenGLExtension_SUNX_constant_data::glFinishTextureSUNX()
{
    Q_D(QOpenGLExtension_SUNX_constant_data);
    d->FinishTextureSUNX();
}

class QOpenGLExtension_SUN_global_alphaPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GlobalAlphaFactoruiSUN)(GLuint factor);
    void (QOPENGLF_APIENTRYP GlobalAlphaFactorusSUN)(GLushort factor);
    void (QOPENGLF_APIENTRYP GlobalAlphaFactorubSUN)(GLubyte factor);
    void (QOPENGLF_APIENTRYP GlobalAlphaFactordSUN)(GLdouble factor);
    void (QOPENGLF_APIENTRYP GlobalAlphaFactorfSUN)(GLfloat factor);
    void (QOPENGLF_APIENTRYP GlobalAlphaFactoriSUN)(GLint factor);
    void (QOPENGLF_APIENTRYP GlobalAlphaFactorsSUN)(GLshort factor);
    void (QOPENGLF_APIENTRYP GlobalAlphaFactorbSUN)(GLbyte factor);
};

class QOpenGLExtension_SUN_global_alpha : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_SUN_global_alpha();

    bool initializeOpenGLFunctions() final;

    void glGlobalAlphaFactoruiSUN(GLuint factor);
    void glGlobalAlphaFactorusSUN(GLushort factor);
    void glGlobalAlphaFactorubSUN(GLubyte factor);
    void glGlobalAlphaFactordSUN(GLdouble factor);
    void glGlobalAlphaFactorfSUN(GLfloat factor);
    void glGlobalAlphaFactoriSUN(GLint factor);
    void glGlobalAlphaFactorsSUN(GLshort factor);
    void glGlobalAlphaFactorbSUN(GLbyte factor);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_SUN_global_alpha)
};

inline void QOpenGLExtension_SUN_global_alpha::glGlobalAlphaFactoruiSUN(GLuint factor)
{
    Q_D(QOpenGLExtension_SUN_global_alpha);
    d->GlobalAlphaFactoruiSUN(factor);
}

inline void QOpenGLExtension_SUN_global_alpha::glGlobalAlphaFactorusSUN(GLushort factor)
{
    Q_D(QOpenGLExtension_SUN_global_alpha);
    d->GlobalAlphaFactorusSUN(factor);
}

inline void QOpenGLExtension_SUN_global_alpha::glGlobalAlphaFactorubSUN(GLubyte factor)
{
    Q_D(QOpenGLExtension_SUN_global_alpha);
    d->GlobalAlphaFactorubSUN(factor);
}

inline void QOpenGLExtension_SUN_global_alpha::glGlobalAlphaFactordSUN(GLdouble factor)
{
    Q_D(QOpenGLExtension_SUN_global_alpha);
    d->GlobalAlphaFactordSUN(factor);
}

inline void QOpenGLExtension_SUN_global_alpha::glGlobalAlphaFactorfSUN(GLfloat factor)
{
    Q_D(QOpenGLExtension_SUN_global_alpha);
    d->GlobalAlphaFactorfSUN(factor);
}

inline void QOpenGLExtension_SUN_global_alpha::glGlobalAlphaFactoriSUN(GLint factor)
{
    Q_D(QOpenGLExtension_SUN_global_alpha);
    d->GlobalAlphaFactoriSUN(factor);
}

inline void QOpenGLExtension_SUN_global_alpha::glGlobalAlphaFactorsSUN(GLshort factor)
{
    Q_D(QOpenGLExtension_SUN_global_alpha);
    d->GlobalAlphaFactorsSUN(factor);
}

inline void QOpenGLExtension_SUN_global_alpha::glGlobalAlphaFactorbSUN(GLbyte factor)
{
    Q_D(QOpenGLExtension_SUN_global_alpha);
    d->GlobalAlphaFactorbSUN(factor);
}

class QOpenGLExtension_SUN_mesh_arrayPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP DrawMeshArraysSUN)(GLenum mode, GLint first, GLsizei count, GLsizei width);
};

class QOpenGLExtension_SUN_mesh_array : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_SUN_mesh_array();

    bool initializeOpenGLFunctions() final;

    void glDrawMeshArraysSUN(GLenum mode, GLint first, GLsizei count, GLsizei width);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_SUN_mesh_array)
};

inline void QOpenGLExtension_SUN_mesh_array::glDrawMeshArraysSUN(GLenum mode, GLint first, GLsizei count, GLsizei width)
{
    Q_D(QOpenGLExtension_SUN_mesh_array);
    d->DrawMeshArraysSUN(mode, first, count, width);
}

class QOpenGLExtension_SUN_triangle_listPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP ReplacementCodePointerSUN)(GLenum type, GLsizei stride, const GLvoid* *pointer);
    void (QOPENGLF_APIENTRYP ReplacementCodeubvSUN)(const GLubyte *code);
    void (QOPENGLF_APIENTRYP ReplacementCodeusvSUN)(const GLushort *code);
    void (QOPENGLF_APIENTRYP ReplacementCodeuivSUN)(const GLuint *code);
    void (QOPENGLF_APIENTRYP ReplacementCodeubSUN)(GLubyte code);
    void (QOPENGLF_APIENTRYP ReplacementCodeusSUN)(GLushort code);
    void (QOPENGLF_APIENTRYP ReplacementCodeuiSUN)(GLuint code);
};

class QOpenGLExtension_SUN_triangle_list : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_SUN_triangle_list();

    bool initializeOpenGLFunctions() final;

    void glReplacementCodePointerSUN(GLenum type, GLsizei stride, const GLvoid* *pointer);
    void glReplacementCodeubvSUN(const GLubyte *code);
    void glReplacementCodeusvSUN(const GLushort *code);
    void glReplacementCodeuivSUN(const GLuint *code);
    void glReplacementCodeubSUN(GLubyte code);
    void glReplacementCodeusSUN(GLushort code);
    void glReplacementCodeuiSUN(GLuint code);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_SUN_triangle_list)
};

inline void QOpenGLExtension_SUN_triangle_list::glReplacementCodePointerSUN(GLenum type, GLsizei stride, const GLvoid* *pointer)
{
    Q_D(QOpenGLExtension_SUN_triangle_list);
    d->ReplacementCodePointerSUN(type, stride, pointer);
}

inline void QOpenGLExtension_SUN_triangle_list::glReplacementCodeubvSUN(const GLubyte *code)
{
    Q_D(QOpenGLExtension_SUN_triangle_list);
    d->ReplacementCodeubvSUN(code);
}

inline void QOpenGLExtension_SUN_triangle_list::glReplacementCodeusvSUN(const GLushort *code)
{
    Q_D(QOpenGLExtension_SUN_triangle_list);
    d->ReplacementCodeusvSUN(code);
}

inline void QOpenGLExtension_SUN_triangle_list::glReplacementCodeuivSUN(const GLuint *code)
{
    Q_D(QOpenGLExtension_SUN_triangle_list);
    d->ReplacementCodeuivSUN(code);
}

inline void QOpenGLExtension_SUN_triangle_list::glReplacementCodeubSUN(GLubyte code)
{
    Q_D(QOpenGLExtension_SUN_triangle_list);
    d->ReplacementCodeubSUN(code);
}

inline void QOpenGLExtension_SUN_triangle_list::glReplacementCodeusSUN(GLushort code)
{
    Q_D(QOpenGLExtension_SUN_triangle_list);
    d->ReplacementCodeusSUN(code);
}

inline void QOpenGLExtension_SUN_triangle_list::glReplacementCodeuiSUN(GLuint code)
{
    Q_D(QOpenGLExtension_SUN_triangle_list);
    d->ReplacementCodeuiSUN(code);
}

class QOpenGLExtension_SUN_vertexPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP ReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN)(const GLuint *rc, const GLfloat *tc, const GLfloat *c, const GLfloat *n, const GLfloat *v);
    void (QOPENGLF_APIENTRYP ReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN)(GLuint rc, GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z);
    void (QOPENGLF_APIENTRYP ReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN)(const GLuint *rc, const GLfloat *tc, const GLfloat *n, const GLfloat *v);
    void (QOPENGLF_APIENTRYP ReplacementCodeuiTexCoord2fNormal3fVertex3fSUN)(GLuint rc, GLfloat s, GLfloat t, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z);
    void (QOPENGLF_APIENTRYP ReplacementCodeuiTexCoord2fVertex3fvSUN)(const GLuint *rc, const GLfloat *tc, const GLfloat *v);
    void (QOPENGLF_APIENTRYP ReplacementCodeuiTexCoord2fVertex3fSUN)(GLuint rc, GLfloat s, GLfloat t, GLfloat x, GLfloat y, GLfloat z);
    void (QOPENGLF_APIENTRYP ReplacementCodeuiColor4fNormal3fVertex3fvSUN)(const GLuint *rc, const GLfloat *c, const GLfloat *n, const GLfloat *v);
    void (QOPENGLF_APIENTRYP ReplacementCodeuiColor4fNormal3fVertex3fSUN)(GLuint rc, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z);
    void (QOPENGLF_APIENTRYP ReplacementCodeuiNormal3fVertex3fvSUN)(const GLuint *rc, const GLfloat *n, const GLfloat *v);
    void (QOPENGLF_APIENTRYP ReplacementCodeuiNormal3fVertex3fSUN)(GLuint rc, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z);
    void (QOPENGLF_APIENTRYP ReplacementCodeuiColor3fVertex3fvSUN)(const GLuint *rc, const GLfloat *c, const GLfloat *v);
    void (QOPENGLF_APIENTRYP ReplacementCodeuiColor3fVertex3fSUN)(GLuint rc, GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z);
    void (QOPENGLF_APIENTRYP ReplacementCodeuiColor4ubVertex3fvSUN)(const GLuint *rc, const GLubyte *c, const GLfloat *v);
    void (QOPENGLF_APIENTRYP ReplacementCodeuiColor4ubVertex3fSUN)(GLuint rc, GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y, GLfloat z);
    void (QOPENGLF_APIENTRYP ReplacementCodeuiVertex3fvSUN)(const GLuint *rc, const GLfloat *v);
    void (QOPENGLF_APIENTRYP ReplacementCodeuiVertex3fSUN)(GLuint rc, GLfloat x, GLfloat y, GLfloat z);
    void (QOPENGLF_APIENTRYP TexCoord4fColor4fNormal3fVertex4fvSUN)(const GLfloat *tc, const GLfloat *c, const GLfloat *n, const GLfloat *v);
    void (QOPENGLF_APIENTRYP TexCoord4fColor4fNormal3fVertex4fSUN)(GLfloat s, GLfloat t, GLfloat p, GLfloat q, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
    void (QOPENGLF_APIENTRYP TexCoord2fColor4fNormal3fVertex3fvSUN)(const GLfloat *tc, const GLfloat *c, const GLfloat *n, const GLfloat *v);
    void (QOPENGLF_APIENTRYP TexCoord2fColor4fNormal3fVertex3fSUN)(GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z);
    void (QOPENGLF_APIENTRYP TexCoord2fNormal3fVertex3fvSUN)(const GLfloat *tc, const GLfloat *n, const GLfloat *v);
    void (QOPENGLF_APIENTRYP TexCoord2fNormal3fVertex3fSUN)(GLfloat s, GLfloat t, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z);
    void (QOPENGLF_APIENTRYP TexCoord2fColor3fVertex3fvSUN)(const GLfloat *tc, const GLfloat *c, const GLfloat *v);
    void (QOPENGLF_APIENTRYP TexCoord2fColor3fVertex3fSUN)(GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z);
    void (QOPENGLF_APIENTRYP TexCoord2fColor4ubVertex3fvSUN)(const GLfloat *tc, const GLubyte *c, const GLfloat *v);
    void (QOPENGLF_APIENTRYP TexCoord2fColor4ubVertex3fSUN)(GLfloat s, GLfloat t, GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y, GLfloat z);
    void (QOPENGLF_APIENTRYP TexCoord4fVertex4fvSUN)(const GLfloat *tc, const GLfloat *v);
    void (QOPENGLF_APIENTRYP TexCoord4fVertex4fSUN)(GLfloat s, GLfloat t, GLfloat p, GLfloat q, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
    void (QOPENGLF_APIENTRYP TexCoord2fVertex3fvSUN)(const GLfloat *tc, const GLfloat *v);
    void (QOPENGLF_APIENTRYP TexCoord2fVertex3fSUN)(GLfloat s, GLfloat t, GLfloat x, GLfloat y, GLfloat z);
    void (QOPENGLF_APIENTRYP Color4fNormal3fVertex3fvSUN)(const GLfloat *c, const GLfloat *n, const GLfloat *v);
    void (QOPENGLF_APIENTRYP Color4fNormal3fVertex3fSUN)(GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z);
    void (QOPENGLF_APIENTRYP Normal3fVertex3fvSUN)(const GLfloat *n, const GLfloat *v);
    void (QOPENGLF_APIENTRYP Normal3fVertex3fSUN)(GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z);
    void (QOPENGLF_APIENTRYP Color3fVertex3fvSUN)(const GLfloat *c, const GLfloat *v);
    void (QOPENGLF_APIENTRYP Color3fVertex3fSUN)(GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z);
    void (QOPENGLF_APIENTRYP Color4ubVertex3fvSUN)(const GLubyte *c, const GLfloat *v);
    void (QOPENGLF_APIENTRYP Color4ubVertex3fSUN)(GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y, GLfloat z);
    void (QOPENGLF_APIENTRYP Color4ubVertex2fvSUN)(const GLubyte *c, const GLfloat *v);
    void (QOPENGLF_APIENTRYP Color4ubVertex2fSUN)(GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y);
};

class QOpenGLExtension_SUN_vertex : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_SUN_vertex();

    bool initializeOpenGLFunctions() final;

    void glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN(const GLuint *rc, const GLfloat *tc, const GLfloat *c, const GLfloat *n, const GLfloat *v);
    void glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN(GLuint rc, GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z);
    void glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN(const GLuint *rc, const GLfloat *tc, const GLfloat *n, const GLfloat *v);
    void glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN(GLuint rc, GLfloat s, GLfloat t, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z);
    void glReplacementCodeuiTexCoord2fVertex3fvSUN(const GLuint *rc, const GLfloat *tc, const GLfloat *v);
    void glReplacementCodeuiTexCoord2fVertex3fSUN(GLuint rc, GLfloat s, GLfloat t, GLfloat x, GLfloat y, GLfloat z);
    void glReplacementCodeuiColor4fNormal3fVertex3fvSUN(const GLuint *rc, const GLfloat *c, const GLfloat *n, const GLfloat *v);
    void glReplacementCodeuiColor4fNormal3fVertex3fSUN(GLuint rc, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z);
    void glReplacementCodeuiNormal3fVertex3fvSUN(const GLuint *rc, const GLfloat *n, const GLfloat *v);
    void glReplacementCodeuiNormal3fVertex3fSUN(GLuint rc, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z);
    void glReplacementCodeuiColor3fVertex3fvSUN(const GLuint *rc, const GLfloat *c, const GLfloat *v);
    void glReplacementCodeuiColor3fVertex3fSUN(GLuint rc, GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z);
    void glReplacementCodeuiColor4ubVertex3fvSUN(const GLuint *rc, const GLubyte *c, const GLfloat *v);
    void glReplacementCodeuiColor4ubVertex3fSUN(GLuint rc, GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y, GLfloat z);
    void glReplacementCodeuiVertex3fvSUN(const GLuint *rc, const GLfloat *v);
    void glReplacementCodeuiVertex3fSUN(GLuint rc, GLfloat x, GLfloat y, GLfloat z);
    void glTexCoord4fColor4fNormal3fVertex4fvSUN(const GLfloat *tc, const GLfloat *c, const GLfloat *n, const GLfloat *v);
    void glTexCoord4fColor4fNormal3fVertex4fSUN(GLfloat s, GLfloat t, GLfloat p, GLfloat q, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
    void glTexCoord2fColor4fNormal3fVertex3fvSUN(const GLfloat *tc, const GLfloat *c, const GLfloat *n, const GLfloat *v);
    void glTexCoord2fColor4fNormal3fVertex3fSUN(GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z);
    void glTexCoord2fNormal3fVertex3fvSUN(const GLfloat *tc, const GLfloat *n, const GLfloat *v);
    void glTexCoord2fNormal3fVertex3fSUN(GLfloat s, GLfloat t, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z);
    void glTexCoord2fColor3fVertex3fvSUN(const GLfloat *tc, const GLfloat *c, const GLfloat *v);
    void glTexCoord2fColor3fVertex3fSUN(GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z);
    void glTexCoord2fColor4ubVertex3fvSUN(const GLfloat *tc, const GLubyte *c, const GLfloat *v);
    void glTexCoord2fColor4ubVertex3fSUN(GLfloat s, GLfloat t, GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y, GLfloat z);
    void glTexCoord4fVertex4fvSUN(const GLfloat *tc, const GLfloat *v);
    void glTexCoord4fVertex4fSUN(GLfloat s, GLfloat t, GLfloat p, GLfloat q, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
    void glTexCoord2fVertex3fvSUN(const GLfloat *tc, const GLfloat *v);
    void glTexCoord2fVertex3fSUN(GLfloat s, GLfloat t, GLfloat x, GLfloat y, GLfloat z);
    void glColor4fNormal3fVertex3fvSUN(const GLfloat *c, const GLfloat *n, const GLfloat *v);
    void glColor4fNormal3fVertex3fSUN(GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z);
    void glNormal3fVertex3fvSUN(const GLfloat *n, const GLfloat *v);
    void glNormal3fVertex3fSUN(GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z);
    void glColor3fVertex3fvSUN(const GLfloat *c, const GLfloat *v);
    void glColor3fVertex3fSUN(GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z);
    void glColor4ubVertex3fvSUN(const GLubyte *c, const GLfloat *v);
    void glColor4ubVertex3fSUN(GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y, GLfloat z);
    void glColor4ubVertex2fvSUN(const GLubyte *c, const GLfloat *v);
    void glColor4ubVertex2fSUN(GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_SUN_vertex)
};

inline void QOpenGLExtension_SUN_vertex::glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN(const GLuint *rc, const GLfloat *tc, const GLfloat *c, const GLfloat *n, const GLfloat *v)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->ReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN(rc, tc, c, n, v);
}

inline void QOpenGLExtension_SUN_vertex::glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN(GLuint rc, GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->ReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN(rc, s, t, r, g, b, a, nx, ny, nz, x, y, z);
}

inline void QOpenGLExtension_SUN_vertex::glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN(const GLuint *rc, const GLfloat *tc, const GLfloat *n, const GLfloat *v)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->ReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN(rc, tc, n, v);
}

inline void QOpenGLExtension_SUN_vertex::glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN(GLuint rc, GLfloat s, GLfloat t, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->ReplacementCodeuiTexCoord2fNormal3fVertex3fSUN(rc, s, t, nx, ny, nz, x, y, z);
}

inline void QOpenGLExtension_SUN_vertex::glReplacementCodeuiTexCoord2fVertex3fvSUN(const GLuint *rc, const GLfloat *tc, const GLfloat *v)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->ReplacementCodeuiTexCoord2fVertex3fvSUN(rc, tc, v);
}

inline void QOpenGLExtension_SUN_vertex::glReplacementCodeuiTexCoord2fVertex3fSUN(GLuint rc, GLfloat s, GLfloat t, GLfloat x, GLfloat y, GLfloat z)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->ReplacementCodeuiTexCoord2fVertex3fSUN(rc, s, t, x, y, z);
}

inline void QOpenGLExtension_SUN_vertex::glReplacementCodeuiColor4fNormal3fVertex3fvSUN(const GLuint *rc, const GLfloat *c, const GLfloat *n, const GLfloat *v)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->ReplacementCodeuiColor4fNormal3fVertex3fvSUN(rc, c, n, v);
}

inline void QOpenGLExtension_SUN_vertex::glReplacementCodeuiColor4fNormal3fVertex3fSUN(GLuint rc, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->ReplacementCodeuiColor4fNormal3fVertex3fSUN(rc, r, g, b, a, nx, ny, nz, x, y, z);
}

inline void QOpenGLExtension_SUN_vertex::glReplacementCodeuiNormal3fVertex3fvSUN(const GLuint *rc, const GLfloat *n, const GLfloat *v)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->ReplacementCodeuiNormal3fVertex3fvSUN(rc, n, v);
}

inline void QOpenGLExtension_SUN_vertex::glReplacementCodeuiNormal3fVertex3fSUN(GLuint rc, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->ReplacementCodeuiNormal3fVertex3fSUN(rc, nx, ny, nz, x, y, z);
}

inline void QOpenGLExtension_SUN_vertex::glReplacementCodeuiColor3fVertex3fvSUN(const GLuint *rc, const GLfloat *c, const GLfloat *v)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->ReplacementCodeuiColor3fVertex3fvSUN(rc, c, v);
}

inline void QOpenGLExtension_SUN_vertex::glReplacementCodeuiColor3fVertex3fSUN(GLuint rc, GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->ReplacementCodeuiColor3fVertex3fSUN(rc, r, g, b, x, y, z);
}

inline void QOpenGLExtension_SUN_vertex::glReplacementCodeuiColor4ubVertex3fvSUN(const GLuint *rc, const GLubyte *c, const GLfloat *v)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->ReplacementCodeuiColor4ubVertex3fvSUN(rc, c, v);
}

inline void QOpenGLExtension_SUN_vertex::glReplacementCodeuiColor4ubVertex3fSUN(GLuint rc, GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y, GLfloat z)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->ReplacementCodeuiColor4ubVertex3fSUN(rc, r, g, b, a, x, y, z);
}

inline void QOpenGLExtension_SUN_vertex::glReplacementCodeuiVertex3fvSUN(const GLuint *rc, const GLfloat *v)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->ReplacementCodeuiVertex3fvSUN(rc, v);
}

inline void QOpenGLExtension_SUN_vertex::glReplacementCodeuiVertex3fSUN(GLuint rc, GLfloat x, GLfloat y, GLfloat z)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->ReplacementCodeuiVertex3fSUN(rc, x, y, z);
}

inline void QOpenGLExtension_SUN_vertex::glTexCoord4fColor4fNormal3fVertex4fvSUN(const GLfloat *tc, const GLfloat *c, const GLfloat *n, const GLfloat *v)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->TexCoord4fColor4fNormal3fVertex4fvSUN(tc, c, n, v);
}

inline void QOpenGLExtension_SUN_vertex::glTexCoord4fColor4fNormal3fVertex4fSUN(GLfloat s, GLfloat t, GLfloat p, GLfloat q, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->TexCoord4fColor4fNormal3fVertex4fSUN(s, t, p, q, r, g, b, a, nx, ny, nz, x, y, z, w);
}

inline void QOpenGLExtension_SUN_vertex::glTexCoord2fColor4fNormal3fVertex3fvSUN(const GLfloat *tc, const GLfloat *c, const GLfloat *n, const GLfloat *v)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->TexCoord2fColor4fNormal3fVertex3fvSUN(tc, c, n, v);
}

inline void QOpenGLExtension_SUN_vertex::glTexCoord2fColor4fNormal3fVertex3fSUN(GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->TexCoord2fColor4fNormal3fVertex3fSUN(s, t, r, g, b, a, nx, ny, nz, x, y, z);
}

inline void QOpenGLExtension_SUN_vertex::glTexCoord2fNormal3fVertex3fvSUN(const GLfloat *tc, const GLfloat *n, const GLfloat *v)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->TexCoord2fNormal3fVertex3fvSUN(tc, n, v);
}

inline void QOpenGLExtension_SUN_vertex::glTexCoord2fNormal3fVertex3fSUN(GLfloat s, GLfloat t, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->TexCoord2fNormal3fVertex3fSUN(s, t, nx, ny, nz, x, y, z);
}

inline void QOpenGLExtension_SUN_vertex::glTexCoord2fColor3fVertex3fvSUN(const GLfloat *tc, const GLfloat *c, const GLfloat *v)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->TexCoord2fColor3fVertex3fvSUN(tc, c, v);
}

inline void QOpenGLExtension_SUN_vertex::glTexCoord2fColor3fVertex3fSUN(GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->TexCoord2fColor3fVertex3fSUN(s, t, r, g, b, x, y, z);
}

inline void QOpenGLExtension_SUN_vertex::glTexCoord2fColor4ubVertex3fvSUN(const GLfloat *tc, const GLubyte *c, const GLfloat *v)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->TexCoord2fColor4ubVertex3fvSUN(tc, c, v);
}

inline void QOpenGLExtension_SUN_vertex::glTexCoord2fColor4ubVertex3fSUN(GLfloat s, GLfloat t, GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y, GLfloat z)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->TexCoord2fColor4ubVertex3fSUN(s, t, r, g, b, a, x, y, z);
}

inline void QOpenGLExtension_SUN_vertex::glTexCoord4fVertex4fvSUN(const GLfloat *tc, const GLfloat *v)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->TexCoord4fVertex4fvSUN(tc, v);
}

inline void QOpenGLExtension_SUN_vertex::glTexCoord4fVertex4fSUN(GLfloat s, GLfloat t, GLfloat p, GLfloat q, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->TexCoord4fVertex4fSUN(s, t, p, q, x, y, z, w);
}

inline void QOpenGLExtension_SUN_vertex::glTexCoord2fVertex3fvSUN(const GLfloat *tc, const GLfloat *v)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->TexCoord2fVertex3fvSUN(tc, v);
}

inline void QOpenGLExtension_SUN_vertex::glTexCoord2fVertex3fSUN(GLfloat s, GLfloat t, GLfloat x, GLfloat y, GLfloat z)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->TexCoord2fVertex3fSUN(s, t, x, y, z);
}

inline void QOpenGLExtension_SUN_vertex::glColor4fNormal3fVertex3fvSUN(const GLfloat *c, const GLfloat *n, const GLfloat *v)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->Color4fNormal3fVertex3fvSUN(c, n, v);
}

inline void QOpenGLExtension_SUN_vertex::glColor4fNormal3fVertex3fSUN(GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->Color4fNormal3fVertex3fSUN(r, g, b, a, nx, ny, nz, x, y, z);
}

inline void QOpenGLExtension_SUN_vertex::glNormal3fVertex3fvSUN(const GLfloat *n, const GLfloat *v)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->Normal3fVertex3fvSUN(n, v);
}

inline void QOpenGLExtension_SUN_vertex::glNormal3fVertex3fSUN(GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->Normal3fVertex3fSUN(nx, ny, nz, x, y, z);
}

inline void QOpenGLExtension_SUN_vertex::glColor3fVertex3fvSUN(const GLfloat *c, const GLfloat *v)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->Color3fVertex3fvSUN(c, v);
}

inline void QOpenGLExtension_SUN_vertex::glColor3fVertex3fSUN(GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->Color3fVertex3fSUN(r, g, b, x, y, z);
}

inline void QOpenGLExtension_SUN_vertex::glColor4ubVertex3fvSUN(const GLubyte *c, const GLfloat *v)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->Color4ubVertex3fvSUN(c, v);
}

inline void QOpenGLExtension_SUN_vertex::glColor4ubVertex3fSUN(GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y, GLfloat z)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->Color4ubVertex3fSUN(r, g, b, a, x, y, z);
}

inline void QOpenGLExtension_SUN_vertex::glColor4ubVertex2fvSUN(const GLubyte *c, const GLfloat *v)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->Color4ubVertex2fvSUN(c, v);
}

inline void QOpenGLExtension_SUN_vertex::glColor4ubVertex2fSUN(GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y)
{
    Q_D(QOpenGLExtension_SUN_vertex);
    d->Color4ubVertex2fSUN(r, g, b, a, x, y);
}


#else

class QOpenGLExtension_OES_EGL_imagePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP EGLImageTargetTexture2DOES)(GLenum target, GLeglImageOES image);
    void (QOPENGLF_APIENTRYP EGLImageTargetRenderbufferStorageOES)(GLenum target, GLeglImageOES image);
};

class QOpenGLExtension_OES_EGL_image : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_OES_EGL_image();

    bool initializeOpenGLFunctions() final;

    void glEGLImageTargetTexture2DOES(GLenum target, GLeglImageOES image);
    void glEGLImageTargetRenderbufferStorageOES(GLenum target, GLeglImageOES image);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_OES_EGL_image)
};

inline void QOpenGLExtension_OES_EGL_image::glEGLImageTargetTexture2DOES(GLenum target, GLeglImageOES image)
{
    Q_D(QOpenGLExtension_OES_EGL_image);
    d->EGLImageTargetTexture2DOES(target, image);
}

inline void QOpenGLExtension_OES_EGL_image::glEGLImageTargetRenderbufferStorageOES(GLenum target, GLeglImageOES image)
{
    Q_D(QOpenGLExtension_OES_EGL_image);
    d->EGLImageTargetRenderbufferStorageOES(target, image);
}

class QOpenGLExtension_OES_get_program_binaryPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetProgramBinaryOES)(GLuint program, GLsizei bufSize, GLsizei *length, GLenum *binaryFormat, GLvoid *binary);
    void (QOPENGLF_APIENTRYP ProgramBinaryOES)(GLuint program, GLenum binaryFormat, const GLvoid *binary, GLint length);
};

class QOpenGLExtension_OES_get_program_binary : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_OES_get_program_binary();

    bool initializeOpenGLFunctions() final;

    void glGetProgramBinaryOES(GLuint program, GLsizei bufSize, GLsizei *length, GLenum *binaryFormat, GLvoid *binary);
    void glProgramBinaryOES(GLuint program, GLenum binaryFormat, const GLvoid *binary, GLint length);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_OES_get_program_binary)
};

inline void QOpenGLExtension_OES_get_program_binary::glGetProgramBinaryOES(GLuint program, GLsizei bufSize, GLsizei *length, GLenum *binaryFormat, GLvoid *binary)
{
    Q_D(QOpenGLExtension_OES_get_program_binary);
    d->GetProgramBinaryOES(program, bufSize, length, binaryFormat, binary);
}

inline void QOpenGLExtension_OES_get_program_binary::glProgramBinaryOES(GLuint program, GLenum binaryFormat, const GLvoid *binary, GLint length)
{
    Q_D(QOpenGLExtension_OES_get_program_binary);
    d->ProgramBinaryOES(program, binaryFormat, binary, length);
}

class QOpenGLExtension_OES_mapbufferPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void* (QOPENGLF_APIENTRYP MapBufferOES)(GLenum target, GLenum access);
    GLboolean (QOPENGLF_APIENTRYP UnmapBufferOES)(GLenum target);
    void (QOPENGLF_APIENTRYP GetBufferPointervOES)(GLenum target, GLenum pname, GLvoid** params);
};

class QOpenGLExtension_OES_mapbuffer : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_OES_mapbuffer();

    bool initializeOpenGLFunctions() final;

    void* glMapBufferOES(GLenum target, GLenum access);
    GLboolean glUnmapBufferOES(GLenum target);
    void glGetBufferPointervOES(GLenum target, GLenum pname, GLvoid** params);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_OES_mapbuffer)
};

inline void *QOpenGLExtension_OES_mapbuffer::glMapBufferOES(GLenum target, GLenum access)
{
    Q_D(QOpenGLExtension_OES_mapbuffer);
    return d->MapBufferOES(target, access);
}

inline GLboolean QOpenGLExtension_OES_mapbuffer::glUnmapBufferOES(GLenum target)
{
    Q_D(QOpenGLExtension_OES_mapbuffer);
    return d->UnmapBufferOES(target);
}

inline void QOpenGLExtension_OES_mapbuffer::glGetBufferPointervOES(GLenum target, GLenum pname, GLvoid** params)
{
    Q_D(QOpenGLExtension_OES_mapbuffer);
    d->GetBufferPointervOES(target, pname, params);
}

class QOpenGLExtension_OES_texture_3DPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP TexImage3DOES)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid* pixels);
    void (QOPENGLF_APIENTRYP TexSubImage3DOES)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid* pixels);
    void (QOPENGLF_APIENTRYP CopyTexSubImage3DOES)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
    void (QOPENGLF_APIENTRYP CompressedTexImage3DOES)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid* data);
    void (QOPENGLF_APIENTRYP CompressedTexSubImage3DOES)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid* data);
    void (QOPENGLF_APIENTRYP FramebufferTexture3DOES)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset);
};

class QOpenGLExtension_OES_texture_3D : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_OES_texture_3D();

    bool initializeOpenGLFunctions() final;

    void glTexImage3DOES(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid* pixels);
    void glTexSubImage3DOES(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid* pixels);
    void glCopyTexSubImage3DOES(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
    void glCompressedTexImage3DOES(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid* data);
    void glCompressedTexSubImage3DOES(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid* data);
    void glFramebufferTexture3DOES(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_OES_texture_3D)
};

inline void QOpenGLExtension_OES_texture_3D::glTexImage3DOES(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid* pixels)
{
    Q_D(QOpenGLExtension_OES_texture_3D);
    d->TexImage3DOES(target, level, internalformat, width, height, depth, border, format, type, pixels);
}

inline void QOpenGLExtension_OES_texture_3D::glTexSubImage3DOES(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid* pixels)
{
    Q_D(QOpenGLExtension_OES_texture_3D);
    d->TexSubImage3DOES(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
}

inline void QOpenGLExtension_OES_texture_3D::glCopyTexSubImage3DOES(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
    Q_D(QOpenGLExtension_OES_texture_3D);
    d->CopyTexSubImage3DOES(target, level, xoffset, yoffset, zoffset, x, y, width, height);
}

inline void QOpenGLExtension_OES_texture_3D::glCompressedTexImage3DOES(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid* data)
{
    Q_D(QOpenGLExtension_OES_texture_3D);
    d->CompressedTexImage3DOES(target, level, internalformat, width, height, depth, border, imageSize, data);
}

inline void QOpenGLExtension_OES_texture_3D::glCompressedTexSubImage3DOES(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid* data)
{
    Q_D(QOpenGLExtension_OES_texture_3D);
    d->CompressedTexSubImage3DOES(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
}

inline void QOpenGLExtension_OES_texture_3D::glFramebufferTexture3DOES(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset)
{
    Q_D(QOpenGLExtension_OES_texture_3D);
    d->FramebufferTexture3DOES(target, attachment, textarget, texture, level, zoffset);
}

class QOpenGLExtension_OES_vertex_array_objectPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP BindVertexArrayOES)(GLuint array);
    void (QOPENGLF_APIENTRYP DeleteVertexArraysOES)(GLsizei n, const GLuint *arrays);
    void (QOPENGLF_APIENTRYP GenVertexArraysOES)(GLsizei n, GLuint *arrays);
    GLboolean (QOPENGLF_APIENTRYP IsVertexArrayOES)(GLuint array);
};

class QOpenGLExtension_OES_vertex_array_object : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_OES_vertex_array_object();

    bool initializeOpenGLFunctions() final;

    void glBindVertexArrayOES(GLuint array);
    void glDeleteVertexArraysOES(GLsizei n, const GLuint *arrays);
    void glGenVertexArraysOES(GLsizei n, GLuint *arrays);
    GLboolean glIsVertexArrayOES(GLuint array);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_OES_vertex_array_object)
};

inline void QOpenGLExtension_OES_vertex_array_object::glBindVertexArrayOES(GLuint array)
{
    Q_D(QOpenGLExtension_OES_vertex_array_object);
    d->BindVertexArrayOES(array);
}

inline void QOpenGLExtension_OES_vertex_array_object::glDeleteVertexArraysOES(GLsizei n, const GLuint *arrays)
{
    Q_D(QOpenGLExtension_OES_vertex_array_object);
    d->DeleteVertexArraysOES(n, arrays);
}

inline void QOpenGLExtension_OES_vertex_array_object::glGenVertexArraysOES(GLsizei n, GLuint *arrays)
{
    Q_D(QOpenGLExtension_OES_vertex_array_object);
    d->GenVertexArraysOES(n, arrays);
}

inline GLboolean QOpenGLExtension_OES_vertex_array_object::glIsVertexArrayOES(GLuint array)
{
    Q_D(QOpenGLExtension_OES_vertex_array_object);
    return d->IsVertexArrayOES(array);
}

class QOpenGLExtension_AMD_performance_monitorPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetPerfMonitorGroupsAMD)(GLint *numGroups, GLsizei groupsSize, GLuint *groups);
    void (QOPENGLF_APIENTRYP GetPerfMonitorCountersAMD)(GLuint group, GLint *numCounters, GLint *maxActiveCounters, GLsizei counterSize, GLuint *counters);
    void (QOPENGLF_APIENTRYP GetPerfMonitorGroupStringAMD)(GLuint group, GLsizei bufSize, GLsizei *length, GLchar *groupString);
    void (QOPENGLF_APIENTRYP GetPerfMonitorCounterStringAMD)(GLuint group, GLuint counter, GLsizei bufSize, GLsizei *length, GLchar *counterString);
    void (QOPENGLF_APIENTRYP GetPerfMonitorCounterInfoAMD)(GLuint group, GLuint counter, GLenum pname, GLvoid *data);
    void (QOPENGLF_APIENTRYP GenPerfMonitorsAMD)(GLsizei n, GLuint *monitors);
    void (QOPENGLF_APIENTRYP DeletePerfMonitorsAMD)(GLsizei n, GLuint *monitors);
    void (QOPENGLF_APIENTRYP SelectPerfMonitorCountersAMD)(GLuint monitor, GLboolean enable, GLuint group, GLint numCounters, GLuint *countersList);
    void (QOPENGLF_APIENTRYP BeginPerfMonitorAMD)(GLuint monitor);
    void (QOPENGLF_APIENTRYP EndPerfMonitorAMD)(GLuint monitor);
    void (QOPENGLF_APIENTRYP GetPerfMonitorCounterDataAMD)(GLuint monitor, GLenum pname, GLsizei dataSize, GLuint *data, GLint *bytesWritten);
};

class QOpenGLExtension_AMD_performance_monitor : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_AMD_performance_monitor();

    bool initializeOpenGLFunctions() final;

    void glGetPerfMonitorGroupsAMD(GLint *numGroups, GLsizei groupsSize, GLuint *groups);
    void glGetPerfMonitorCountersAMD(GLuint group, GLint *numCounters, GLint *maxActiveCounters, GLsizei counterSize, GLuint *counters);
    void glGetPerfMonitorGroupStringAMD(GLuint group, GLsizei bufSize, GLsizei *length, GLchar *groupString);
    void glGetPerfMonitorCounterStringAMD(GLuint group, GLuint counter, GLsizei bufSize, GLsizei *length, GLchar *counterString);
    void glGetPerfMonitorCounterInfoAMD(GLuint group, GLuint counter, GLenum pname, GLvoid *data);
    void glGenPerfMonitorsAMD(GLsizei n, GLuint *monitors);
    void glDeletePerfMonitorsAMD(GLsizei n, GLuint *monitors);
    void glSelectPerfMonitorCountersAMD(GLuint monitor, GLboolean enable, GLuint group, GLint numCounters, GLuint *countersList);
    void glBeginPerfMonitorAMD(GLuint monitor);
    void glEndPerfMonitorAMD(GLuint monitor);
    void glGetPerfMonitorCounterDataAMD(GLuint monitor, GLenum pname, GLsizei dataSize, GLuint *data, GLint *bytesWritten);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_AMD_performance_monitor)
};

inline void QOpenGLExtension_AMD_performance_monitor::glGetPerfMonitorGroupsAMD(GLint *numGroups, GLsizei groupsSize, GLuint *groups)
{
    Q_D(QOpenGLExtension_AMD_performance_monitor);
    d->GetPerfMonitorGroupsAMD(numGroups, groupsSize, groups);
}

inline void QOpenGLExtension_AMD_performance_monitor::glGetPerfMonitorCountersAMD(GLuint group, GLint *numCounters, GLint *maxActiveCounters, GLsizei counterSize, GLuint *counters)
{
    Q_D(QOpenGLExtension_AMD_performance_monitor);
    d->GetPerfMonitorCountersAMD(group, numCounters, maxActiveCounters, counterSize, counters);
}

inline void QOpenGLExtension_AMD_performance_monitor::glGetPerfMonitorGroupStringAMD(GLuint group, GLsizei bufSize, GLsizei *length, GLchar *groupString)
{
    Q_D(QOpenGLExtension_AMD_performance_monitor);
    d->GetPerfMonitorGroupStringAMD(group, bufSize, length, groupString);
}

inline void QOpenGLExtension_AMD_performance_monitor::glGetPerfMonitorCounterStringAMD(GLuint group, GLuint counter, GLsizei bufSize, GLsizei *length, GLchar *counterString)
{
    Q_D(QOpenGLExtension_AMD_performance_monitor);
    d->GetPerfMonitorCounterStringAMD(group, counter, bufSize, length, counterString);
}

inline void QOpenGLExtension_AMD_performance_monitor::glGetPerfMonitorCounterInfoAMD(GLuint group, GLuint counter, GLenum pname, GLvoid *data)
{
    Q_D(QOpenGLExtension_AMD_performance_monitor);
    d->GetPerfMonitorCounterInfoAMD(group, counter, pname, data);
}

inline void QOpenGLExtension_AMD_performance_monitor::glGenPerfMonitorsAMD(GLsizei n, GLuint *monitors)
{
    Q_D(QOpenGLExtension_AMD_performance_monitor);
    d->GenPerfMonitorsAMD(n, monitors);
}

inline void QOpenGLExtension_AMD_performance_monitor::glDeletePerfMonitorsAMD(GLsizei n, GLuint *monitors)
{
    Q_D(QOpenGLExtension_AMD_performance_monitor);
    d->DeletePerfMonitorsAMD(n, monitors);
}

inline void QOpenGLExtension_AMD_performance_monitor::glSelectPerfMonitorCountersAMD(GLuint monitor, GLboolean enable, GLuint group, GLint numCounters, GLuint *countersList)
{
    Q_D(QOpenGLExtension_AMD_performance_monitor);
    d->SelectPerfMonitorCountersAMD(monitor, enable, group, numCounters, countersList);
}

inline void QOpenGLExtension_AMD_performance_monitor::glBeginPerfMonitorAMD(GLuint monitor)
{
    Q_D(QOpenGLExtension_AMD_performance_monitor);
    d->BeginPerfMonitorAMD(monitor);
}

inline void QOpenGLExtension_AMD_performance_monitor::glEndPerfMonitorAMD(GLuint monitor)
{
    Q_D(QOpenGLExtension_AMD_performance_monitor);
    d->EndPerfMonitorAMD(monitor);
}

inline void QOpenGLExtension_AMD_performance_monitor::glGetPerfMonitorCounterDataAMD(GLuint monitor, GLenum pname, GLsizei dataSize, GLuint *data, GLint *bytesWritten)
{
    Q_D(QOpenGLExtension_AMD_performance_monitor);
    d->GetPerfMonitorCounterDataAMD(monitor, pname, dataSize, data, bytesWritten);
}

class QOpenGLExtension_ANGLE_framebuffer_blitPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP BlitFramebufferANGLE)(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter);
};

class QOpenGLExtension_ANGLE_framebuffer_blit : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ANGLE_framebuffer_blit();

    bool initializeOpenGLFunctions() final;

    void glBlitFramebufferANGLE(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ANGLE_framebuffer_blit)
};

inline void QOpenGLExtension_ANGLE_framebuffer_blit::glBlitFramebufferANGLE(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter)
{
    Q_D(QOpenGLExtension_ANGLE_framebuffer_blit);
    d->BlitFramebufferANGLE(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
}

class QOpenGLExtension_ANGLE_framebuffer_multisamplePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP RenderbufferStorageMultisampleANGLE)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
};

class QOpenGLExtension_ANGLE_framebuffer_multisample : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ANGLE_framebuffer_multisample();

    bool initializeOpenGLFunctions() final;

    void glRenderbufferStorageMultisampleANGLE(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ANGLE_framebuffer_multisample)
};

inline void QOpenGLExtension_ANGLE_framebuffer_multisample::glRenderbufferStorageMultisampleANGLE(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height)
{
    Q_D(QOpenGLExtension_ANGLE_framebuffer_multisample);
    d->RenderbufferStorageMultisampleANGLE(target, samples, internalformat, width, height);
}

class QOpenGLExtension_ANGLE_instanced_arraysPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP DrawArraysInstancedANGLE)(GLenum mode, GLint first, GLsizei count, GLsizei primcount);
    void (QOPENGLF_APIENTRYP DrawElementsInstancedANGLE)(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount);
    void (QOPENGLF_APIENTRYP VertexAttribDivisorANGLE)(GLuint index, GLuint divisor);
};

class QOpenGLExtension_ANGLE_instanced_arrays : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ANGLE_instanced_arrays();

    bool initializeOpenGLFunctions() final;

    void glDrawArraysInstancedANGLE(GLenum mode, GLint first, GLsizei count, GLsizei primcount);
    void glDrawElementsInstancedANGLE(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount);
    void glVertexAttribDivisorANGLE(GLuint index, GLuint divisor);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ANGLE_instanced_arrays)
};

inline void QOpenGLExtension_ANGLE_instanced_arrays::glDrawArraysInstancedANGLE(GLenum mode, GLint first, GLsizei count, GLsizei primcount)
{
    Q_D(QOpenGLExtension_ANGLE_instanced_arrays);
    d->DrawArraysInstancedANGLE(mode, first, count, primcount);
}

inline void QOpenGLExtension_ANGLE_instanced_arrays::glDrawElementsInstancedANGLE(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount)
{
    Q_D(QOpenGLExtension_ANGLE_instanced_arrays);
    d->DrawElementsInstancedANGLE(mode, count, type, indices, primcount);
}

inline void QOpenGLExtension_ANGLE_instanced_arrays::glVertexAttribDivisorANGLE(GLuint index, GLuint divisor)
{
    Q_D(QOpenGLExtension_ANGLE_instanced_arrays);
    d->VertexAttribDivisorANGLE(index, divisor);
}

class QOpenGLExtension_ANGLE_translated_shader_sourcePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetTranslatedShaderSourceANGLE)(GLuint shader, GLsizei bufsize, GLsizei *length, GLchar *source);
};

class QOpenGLExtension_ANGLE_translated_shader_source : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_ANGLE_translated_shader_source();

    bool initializeOpenGLFunctions() final;

    void glGetTranslatedShaderSourceANGLE(GLuint shader, GLsizei bufsize, GLsizei *length, GLchar *source);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_ANGLE_translated_shader_source)
};

inline void QOpenGLExtension_ANGLE_translated_shader_source::glGetTranslatedShaderSourceANGLE(GLuint shader, GLsizei bufsize, GLsizei *length, GLchar *source)
{
    Q_D(QOpenGLExtension_ANGLE_translated_shader_source);
    d->GetTranslatedShaderSourceANGLE(shader, bufsize, length, source);
}

class QOpenGLExtension_APPLE_framebuffer_multisamplePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP RenderbufferStorageMultisampleAPPLE)(GLenum, GLsizei, GLenum, GLsizei, GLsizei);
    void (QOPENGLF_APIENTRYP ResolveMultisampleFramebufferAPPLE)(void);
};

class QOpenGLExtension_APPLE_framebuffer_multisample : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_APPLE_framebuffer_multisample();

    bool initializeOpenGLFunctions() final;

    void glRenderbufferStorageMultisampleAPPLE(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
    void glResolveMultisampleFramebufferAPPLE(void);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_APPLE_framebuffer_multisample)
};

inline void QOpenGLExtension_APPLE_framebuffer_multisample::glRenderbufferStorageMultisampleAPPLE(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height)
{
    Q_D(QOpenGLExtension_APPLE_framebuffer_multisample);
    d->RenderbufferStorageMultisampleAPPLE(target, samples, internalformat, width, height);
}

inline void QOpenGLExtension_APPLE_framebuffer_multisample::glResolveMultisampleFramebufferAPPLE(void)
{
    Q_D(QOpenGLExtension_APPLE_framebuffer_multisample);
    d->ResolveMultisampleFramebufferAPPLE();
}

class QOpenGLExtension_EXT_debug_labelPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP LabelObjectEXT)(GLenum type, GLuint object, GLsizei length, const GLchar *label);
    void (QOPENGLF_APIENTRYP GetObjectLabelEXT)(GLenum type, GLuint object, GLsizei bufSize, GLsizei *length, GLchar *label);
};

class QOpenGLExtension_EXT_debug_label : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_debug_label();

    bool initializeOpenGLFunctions() final;

    void glLabelObjectEXT(GLenum type, GLuint object, GLsizei length, const GLchar *label);
    void glGetObjectLabelEXT(GLenum type, GLuint object, GLsizei bufSize, GLsizei *length, GLchar *label);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_debug_label)
};

inline void QOpenGLExtension_EXT_debug_label::glLabelObjectEXT(GLenum type, GLuint object, GLsizei length, const GLchar *label)
{
    Q_D(QOpenGLExtension_EXT_debug_label);
    d->LabelObjectEXT(type, object, length, label);
}

inline void QOpenGLExtension_EXT_debug_label::glGetObjectLabelEXT(GLenum type, GLuint object, GLsizei bufSize, GLsizei *length, GLchar *label)
{
    Q_D(QOpenGLExtension_EXT_debug_label);
    d->GetObjectLabelEXT(type, object, bufSize, length, label);
}

class QOpenGLExtension_EXT_debug_markerPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP InsertEventMarkerEXT)(GLsizei length, const GLchar *marker);
    void (QOPENGLF_APIENTRYP PushGroupMarkerEXT)(GLsizei length, const GLchar *marker);
    void (QOPENGLF_APIENTRYP PopGroupMarkerEXT)(void);
};

class QOpenGLExtension_EXT_debug_marker : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_debug_marker();

    bool initializeOpenGLFunctions() final;

    void glInsertEventMarkerEXT(GLsizei length, const GLchar *marker);
    void glPushGroupMarkerEXT(GLsizei length, const GLchar *marker);
    void glPopGroupMarkerEXT(void);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_debug_marker)
};

inline void QOpenGLExtension_EXT_debug_marker::glInsertEventMarkerEXT(GLsizei length, const GLchar *marker)
{
    Q_D(QOpenGLExtension_EXT_debug_marker);
    d->InsertEventMarkerEXT(length, marker);
}

inline void QOpenGLExtension_EXT_debug_marker::glPushGroupMarkerEXT(GLsizei length, const GLchar *marker)
{
    Q_D(QOpenGLExtension_EXT_debug_marker);
    d->PushGroupMarkerEXT(length, marker);
}

inline void QOpenGLExtension_EXT_debug_marker::glPopGroupMarkerEXT(void)
{
    Q_D(QOpenGLExtension_EXT_debug_marker);
    d->PopGroupMarkerEXT();
}

class QOpenGLExtension_EXT_discard_framebufferPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP DiscardFramebufferEXT)(GLenum target, GLsizei numAttachments, const GLenum *attachments);
};

class QOpenGLExtension_EXT_discard_framebuffer : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_discard_framebuffer();

    bool initializeOpenGLFunctions() final;

    void glDiscardFramebufferEXT(GLenum target, GLsizei numAttachments, const GLenum *attachments);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_discard_framebuffer)
};

inline void QOpenGLExtension_EXT_discard_framebuffer::glDiscardFramebufferEXT(GLenum target, GLsizei numAttachments, const GLenum *attachments)
{
    Q_D(QOpenGLExtension_EXT_discard_framebuffer);
    d->DiscardFramebufferEXT(target, numAttachments, attachments);
}

class QOpenGLExtension_EXT_multisampled_render_to_texturePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP RenderbufferStorageMultisampleEXT)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
    void (QOPENGLF_APIENTRYP FramebufferTexture2DMultisampleEXT)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLsizei samples);
};

class QOpenGLExtension_EXT_multisampled_render_to_texture : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_multisampled_render_to_texture();

    bool initializeOpenGLFunctions() final;

    void glRenderbufferStorageMultisampleEXT(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
    void glFramebufferTexture2DMultisampleEXT(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLsizei samples);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_multisampled_render_to_texture)
};

inline void QOpenGLExtension_EXT_multisampled_render_to_texture::glRenderbufferStorageMultisampleEXT(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height)
{
    Q_D(QOpenGLExtension_EXT_multisampled_render_to_texture);
    d->RenderbufferStorageMultisampleEXT(target, samples, internalformat, width, height);
}

inline void QOpenGLExtension_EXT_multisampled_render_to_texture::glFramebufferTexture2DMultisampleEXT(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLsizei samples)
{
    Q_D(QOpenGLExtension_EXT_multisampled_render_to_texture);
    d->FramebufferTexture2DMultisampleEXT(target, attachment, textarget, texture, level, samples);
}

class QOpenGLExtension_EXT_multi_draw_arraysPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP MultiDrawArraysEXT)(GLenum mode, GLint *first, GLsizei *count, GLsizei primcount);
    void (QOPENGLF_APIENTRYP MultiDrawElementsEXT)(GLenum mode, const GLsizei *count, GLenum type, const GLvoid* *indices, GLsizei primcount);
};

class QOpenGLExtension_EXT_multi_draw_arrays : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_multi_draw_arrays();

    bool initializeOpenGLFunctions() final;

    void glMultiDrawArraysEXT(GLenum mode, GLint *first, GLsizei *count, GLsizei primcount);
    void glMultiDrawElementsEXT(GLenum mode, const GLsizei *count, GLenum type, const GLvoid* *indices, GLsizei primcount);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_multi_draw_arrays)
};

inline void QOpenGLExtension_EXT_multi_draw_arrays::glMultiDrawArraysEXT(GLenum mode, GLint *first, GLsizei *count, GLsizei primcount)
{
    Q_D(QOpenGLExtension_EXT_multi_draw_arrays);
    d->MultiDrawArraysEXT(mode, first, count, primcount);
}

inline void QOpenGLExtension_EXT_multi_draw_arrays::glMultiDrawElementsEXT(GLenum mode, const GLsizei *count, GLenum type, const GLvoid* *indices, GLsizei primcount)
{
    Q_D(QOpenGLExtension_EXT_multi_draw_arrays);
    d->MultiDrawElementsEXT(mode, count, type, indices, primcount);
}

class QOpenGLExtension_EXT_occlusion_query_booleanPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GenQueriesEXT)(GLsizei n, GLuint *ids);
    void (QOPENGLF_APIENTRYP DeleteQueriesEXT)(GLsizei n, const GLuint *ids);
    GLboolean (QOPENGLF_APIENTRYP IsQueryEXT)(GLuint id);
    void (QOPENGLF_APIENTRYP BeginQueryEXT)(GLenum target, GLuint id);
    void (QOPENGLF_APIENTRYP EndQueryEXT)(GLenum target);
    void (QOPENGLF_APIENTRYP GetQueryivEXT)(GLenum target, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP GetQueryObjectuivEXT)(GLuint id, GLenum pname, GLuint *params);
};

class QOpenGLExtension_EXT_occlusion_query_boolean : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_occlusion_query_boolean();

    bool initializeOpenGLFunctions() final;

    void glGenQueriesEXT(GLsizei n, GLuint *ids);
    void glDeleteQueriesEXT(GLsizei n, const GLuint *ids);
    GLboolean glIsQueryEXT(GLuint id);
    void glBeginQueryEXT(GLenum target, GLuint id);
    void glEndQueryEXT(GLenum target);
    void glGetQueryivEXT(GLenum target, GLenum pname, GLint *params);
    void glGetQueryObjectuivEXT(GLuint id, GLenum pname, GLuint *params);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_occlusion_query_boolean)
};

inline void QOpenGLExtension_EXT_occlusion_query_boolean::glGenQueriesEXT(GLsizei n, GLuint *ids)
{
    Q_D(QOpenGLExtension_EXT_occlusion_query_boolean);
    d->GenQueriesEXT(n, ids);
}

inline void QOpenGLExtension_EXT_occlusion_query_boolean::glDeleteQueriesEXT(GLsizei n, const GLuint *ids)
{
    Q_D(QOpenGLExtension_EXT_occlusion_query_boolean);
    d->DeleteQueriesEXT(n, ids);
}

inline GLboolean QOpenGLExtension_EXT_occlusion_query_boolean::glIsQueryEXT(GLuint id)
{
    Q_D(QOpenGLExtension_EXT_occlusion_query_boolean);
    return d->IsQueryEXT(id);
}

inline void QOpenGLExtension_EXT_occlusion_query_boolean::glBeginQueryEXT(GLenum target, GLuint id)
{
    Q_D(QOpenGLExtension_EXT_occlusion_query_boolean);
    d->BeginQueryEXT(target, id);
}

inline void QOpenGLExtension_EXT_occlusion_query_boolean::glEndQueryEXT(GLenum target)
{
    Q_D(QOpenGLExtension_EXT_occlusion_query_boolean);
    d->EndQueryEXT(target);
}

inline void QOpenGLExtension_EXT_occlusion_query_boolean::glGetQueryivEXT(GLenum target, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_EXT_occlusion_query_boolean);
    d->GetQueryivEXT(target, pname, params);
}

inline void QOpenGLExtension_EXT_occlusion_query_boolean::glGetQueryObjectuivEXT(GLuint id, GLenum pname, GLuint *params)
{
    Q_D(QOpenGLExtension_EXT_occlusion_query_boolean);
    d->GetQueryObjectuivEXT(id, pname, params);
}

class QOpenGLExtension_EXT_robustnessPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    GLenum (QOPENGLF_APIENTRYP GetGraphicsResetStatusEXT)(void);
    void (QOPENGLF_APIENTRYP ReadnPixelsEXT)(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, void *data);
    void (QOPENGLF_APIENTRYP GetnUniformfvEXT)(GLuint program, GLint location, GLsizei bufSize, float *params);
    void (QOPENGLF_APIENTRYP GetnUniformivEXT)(GLuint program, GLint location, GLsizei bufSize, GLint *params);
};

class QOpenGLExtension_EXT_robustness : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_robustness();

    bool initializeOpenGLFunctions() final;

    GLenum glGetGraphicsResetStatusEXT(void);
    void glReadnPixelsEXT(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, void *data);
    void glGetnUniformfvEXT(GLuint program, GLint location, GLsizei bufSize, float *params);
    void glGetnUniformivEXT(GLuint program, GLint location, GLsizei bufSize, GLint *params);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_robustness)
};

inline GLenum QOpenGLExtension_EXT_robustness::glGetGraphicsResetStatusEXT(void)
{
    Q_D(QOpenGLExtension_EXT_robustness);
    return d->GetGraphicsResetStatusEXT();
}

inline void QOpenGLExtension_EXT_robustness::glReadnPixelsEXT(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, void *data)
{
    Q_D(QOpenGLExtension_EXT_robustness);
    d->ReadnPixelsEXT(x, y, width, height, format, type, bufSize, data);
}

inline void QOpenGLExtension_EXT_robustness::glGetnUniformfvEXT(GLuint program, GLint location, GLsizei bufSize, float *params)
{
    Q_D(QOpenGLExtension_EXT_robustness);
    d->GetnUniformfvEXT(program, location, bufSize, params);
}

inline void QOpenGLExtension_EXT_robustness::glGetnUniformivEXT(GLuint program, GLint location, GLsizei bufSize, GLint *params)
{
    Q_D(QOpenGLExtension_EXT_robustness);
    d->GetnUniformivEXT(program, location, bufSize, params);
}

class QOpenGLExtension_EXT_separate_shader_objectsPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP UseProgramStagesEXT)(GLuint pipeline, GLbitfield stages, GLuint program);
    void (QOPENGLF_APIENTRYP ActiveShaderProgramEXT)(GLuint pipeline, GLuint program);
    GLuint (QOPENGLF_APIENTRYP CreateShaderProgramvEXT)(GLenum type, GLsizei count, const GLchar **strings);
    void (QOPENGLF_APIENTRYP BindProgramPipelineEXT)(GLuint pipeline);
    void (QOPENGLF_APIENTRYP DeleteProgramPipelinesEXT)(GLsizei n, const GLuint *pipelines);
    void (QOPENGLF_APIENTRYP GenProgramPipelinesEXT)(GLsizei n, GLuint *pipelines);
    GLboolean (QOPENGLF_APIENTRYP IsProgramPipelineEXT)(GLuint pipeline);
    void (QOPENGLF_APIENTRYP ProgramParameteriEXT)(GLuint program, GLenum pname, GLint value);
    void (QOPENGLF_APIENTRYP GetProgramPipelineivEXT)(GLuint pipeline, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP ProgramUniform1iEXT)(GLuint program, GLint location, GLint x);
    void (QOPENGLF_APIENTRYP ProgramUniform2iEXT)(GLuint program, GLint location, GLint x, GLint y);
    void (QOPENGLF_APIENTRYP ProgramUniform3iEXT)(GLuint program, GLint location, GLint x, GLint y, GLint z);
    void (QOPENGLF_APIENTRYP ProgramUniform4iEXT)(GLuint program, GLint location, GLint x, GLint y, GLint z, GLint w);
    void (QOPENGLF_APIENTRYP ProgramUniform1fEXT)(GLuint program, GLint location, GLfloat x);
    void (QOPENGLF_APIENTRYP ProgramUniform2fEXT)(GLuint program, GLint location, GLfloat x, GLfloat y);
    void (QOPENGLF_APIENTRYP ProgramUniform3fEXT)(GLuint program, GLint location, GLfloat x, GLfloat y, GLfloat z);
    void (QOPENGLF_APIENTRYP ProgramUniform4fEXT)(GLuint program, GLint location, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
    void (QOPENGLF_APIENTRYP ProgramUniform1ivEXT)(GLuint program, GLint location, GLsizei count, const GLint *value);
    void (QOPENGLF_APIENTRYP ProgramUniform2ivEXT)(GLuint program, GLint location, GLsizei count, const GLint *value);
    void (QOPENGLF_APIENTRYP ProgramUniform3ivEXT)(GLuint program, GLint location, GLsizei count, const GLint *value);
    void (QOPENGLF_APIENTRYP ProgramUniform4ivEXT)(GLuint program, GLint location, GLsizei count, const GLint *value);
    void (QOPENGLF_APIENTRYP ProgramUniform1fvEXT)(GLuint program, GLint location, GLsizei count, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniform2fvEXT)(GLuint program, GLint location, GLsizei count, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniform3fvEXT)(GLuint program, GLint location, GLsizei count, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniform4fvEXT)(GLuint program, GLint location, GLsizei count, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix2fvEXT)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix3fvEXT)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ProgramUniformMatrix4fvEXT)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void (QOPENGLF_APIENTRYP ValidateProgramPipelineEXT)(GLuint pipeline);
    void (QOPENGLF_APIENTRYP GetProgramPipelineInfoLogEXT)(GLuint pipeline, GLsizei bufSize, GLsizei *length, GLchar *infoLog);
};

class QOpenGLExtension_EXT_separate_shader_objects : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_separate_shader_objects();

    bool initializeOpenGLFunctions() final;

    void glUseProgramStagesEXT(GLuint pipeline, GLbitfield stages, GLuint program);
    void glActiveShaderProgramEXT(GLuint pipeline, GLuint program);
    GLuint glCreateShaderProgramvEXT(GLenum type, GLsizei count, const GLchar **strings);
    void glBindProgramPipelineEXT(GLuint pipeline);
    void glDeleteProgramPipelinesEXT(GLsizei n, const GLuint *pipelines);
    void glGenProgramPipelinesEXT(GLsizei n, GLuint *pipelines);
    GLboolean glIsProgramPipelineEXT(GLuint pipeline);
    void glProgramParameteriEXT(GLuint program, GLenum pname, GLint value);
    void glGetProgramPipelineivEXT(GLuint pipeline, GLenum pname, GLint *params);
    void glProgramUniform1iEXT(GLuint program, GLint location, GLint x);
    void glProgramUniform2iEXT(GLuint program, GLint location, GLint x, GLint y);
    void glProgramUniform3iEXT(GLuint program, GLint location, GLint x, GLint y, GLint z);
    void glProgramUniform4iEXT(GLuint program, GLint location, GLint x, GLint y, GLint z, GLint w);
    void glProgramUniform1fEXT(GLuint program, GLint location, GLfloat x);
    void glProgramUniform2fEXT(GLuint program, GLint location, GLfloat x, GLfloat y);
    void glProgramUniform3fEXT(GLuint program, GLint location, GLfloat x, GLfloat y, GLfloat z);
    void glProgramUniform4fEXT(GLuint program, GLint location, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
    void glProgramUniform1ivEXT(GLuint program, GLint location, GLsizei count, const GLint *value);
    void glProgramUniform2ivEXT(GLuint program, GLint location, GLsizei count, const GLint *value);
    void glProgramUniform3ivEXT(GLuint program, GLint location, GLsizei count, const GLint *value);
    void glProgramUniform4ivEXT(GLuint program, GLint location, GLsizei count, const GLint *value);
    void glProgramUniform1fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat *value);
    void glProgramUniform2fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat *value);
    void glProgramUniform3fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat *value);
    void glProgramUniform4fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat *value);
    void glProgramUniformMatrix2fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glProgramUniformMatrix3fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glProgramUniformMatrix4fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glValidateProgramPipelineEXT(GLuint pipeline);
    void glGetProgramPipelineInfoLogEXT(GLuint pipeline, GLsizei bufSize, GLsizei *length, GLchar *infoLog);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_separate_shader_objects)
};

inline void QOpenGLExtension_EXT_separate_shader_objects::glUseProgramStagesEXT(GLuint pipeline, GLbitfield stages, GLuint program)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->UseProgramStagesEXT(pipeline, stages, program);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glActiveShaderProgramEXT(GLuint pipeline, GLuint program)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->ActiveShaderProgramEXT(pipeline, program);
}

inline GLuint QOpenGLExtension_EXT_separate_shader_objects::glCreateShaderProgramvEXT(GLenum type, GLsizei count, const GLchar **strings)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    return d->CreateShaderProgramvEXT(type, count, strings);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glBindProgramPipelineEXT(GLuint pipeline)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->BindProgramPipelineEXT(pipeline);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glDeleteProgramPipelinesEXT(GLsizei n, const GLuint *pipelines)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->DeleteProgramPipelinesEXT(n, pipelines);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glGenProgramPipelinesEXT(GLsizei n, GLuint *pipelines)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->GenProgramPipelinesEXT(n, pipelines);
}

inline GLboolean QOpenGLExtension_EXT_separate_shader_objects::glIsProgramPipelineEXT(GLuint pipeline)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    return d->IsProgramPipelineEXT(pipeline);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glProgramParameteriEXT(GLuint program, GLenum pname, GLint value)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->ProgramParameteriEXT(program, pname, value);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glGetProgramPipelineivEXT(GLuint pipeline, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->GetProgramPipelineivEXT(pipeline, pname, params);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glProgramUniform1iEXT(GLuint program, GLint location, GLint x)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->ProgramUniform1iEXT(program, location, x);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glProgramUniform2iEXT(GLuint program, GLint location, GLint x, GLint y)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->ProgramUniform2iEXT(program, location, x, y);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glProgramUniform3iEXT(GLuint program, GLint location, GLint x, GLint y, GLint z)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->ProgramUniform3iEXT(program, location, x, y, z);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glProgramUniform4iEXT(GLuint program, GLint location, GLint x, GLint y, GLint z, GLint w)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->ProgramUniform4iEXT(program, location, x, y, z, w);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glProgramUniform1fEXT(GLuint program, GLint location, GLfloat x)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->ProgramUniform1fEXT(program, location, x);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glProgramUniform2fEXT(GLuint program, GLint location, GLfloat x, GLfloat y)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->ProgramUniform2fEXT(program, location, x, y);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glProgramUniform3fEXT(GLuint program, GLint location, GLfloat x, GLfloat y, GLfloat z)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->ProgramUniform3fEXT(program, location, x, y, z);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glProgramUniform4fEXT(GLuint program, GLint location, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->ProgramUniform4fEXT(program, location, x, y, z, w);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glProgramUniform1ivEXT(GLuint program, GLint location, GLsizei count, const GLint *value)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->ProgramUniform1ivEXT(program, location, count, value);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glProgramUniform2ivEXT(GLuint program, GLint location, GLsizei count, const GLint *value)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->ProgramUniform2ivEXT(program, location, count, value);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glProgramUniform3ivEXT(GLuint program, GLint location, GLsizei count, const GLint *value)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->ProgramUniform3ivEXT(program, location, count, value);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glProgramUniform4ivEXT(GLuint program, GLint location, GLsizei count, const GLint *value)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->ProgramUniform4ivEXT(program, location, count, value);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glProgramUniform1fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat *value)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->ProgramUniform1fvEXT(program, location, count, value);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glProgramUniform2fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat *value)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->ProgramUniform2fvEXT(program, location, count, value);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glProgramUniform3fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat *value)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->ProgramUniform3fvEXT(program, location, count, value);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glProgramUniform4fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat *value)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->ProgramUniform4fvEXT(program, location, count, value);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glProgramUniformMatrix2fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->ProgramUniformMatrix2fvEXT(program, location, count, transpose, value);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glProgramUniformMatrix3fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->ProgramUniformMatrix3fvEXT(program, location, count, transpose, value);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glProgramUniformMatrix4fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->ProgramUniformMatrix4fvEXT(program, location, count, transpose, value);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glValidateProgramPipelineEXT(GLuint pipeline)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->ValidateProgramPipelineEXT(pipeline);
}

inline void QOpenGLExtension_EXT_separate_shader_objects::glGetProgramPipelineInfoLogEXT(GLuint pipeline, GLsizei bufSize, GLsizei *length, GLchar *infoLog)
{
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);
    d->GetProgramPipelineInfoLogEXT(pipeline, bufSize, length, infoLog);
}

class QOpenGLExtension_EXT_texture_storagePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP TexStorage1DEXT)(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width);
    void (QOPENGLF_APIENTRYP TexStorage2DEXT)(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height);
    void (QOPENGLF_APIENTRYP TexStorage3DEXT)(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth);
    void (QOPENGLF_APIENTRYP TextureStorage1DEXT)(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width);
    void (QOPENGLF_APIENTRYP TextureStorage2DEXT)(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height);
    void (QOPENGLF_APIENTRYP TextureStorage3DEXT)(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth);
};

class QOpenGLExtension_EXT_texture_storage : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_EXT_texture_storage();

    bool initializeOpenGLFunctions() final;

    void glTexStorage1DEXT(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width);
    void glTexStorage2DEXT(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height);
    void glTexStorage3DEXT(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth);
    void glTextureStorage1DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width);
    void glTextureStorage2DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height);
    void glTextureStorage3DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_EXT_texture_storage)
};

inline void QOpenGLExtension_EXT_texture_storage::glTexStorage1DEXT(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width)
{
    Q_D(QOpenGLExtension_EXT_texture_storage);
    d->TexStorage1DEXT(target, levels, internalformat, width);
}

inline void QOpenGLExtension_EXT_texture_storage::glTexStorage2DEXT(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height)
{
    Q_D(QOpenGLExtension_EXT_texture_storage);
    d->TexStorage2DEXT(target, levels, internalformat, width, height);
}

inline void QOpenGLExtension_EXT_texture_storage::glTexStorage3DEXT(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth)
{
    Q_D(QOpenGLExtension_EXT_texture_storage);
    d->TexStorage3DEXT(target, levels, internalformat, width, height, depth);
}

inline void QOpenGLExtension_EXT_texture_storage::glTextureStorage1DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width)
{
    Q_D(QOpenGLExtension_EXT_texture_storage);
    d->TextureStorage1DEXT(texture, target, levels, internalformat, width);
}

inline void QOpenGLExtension_EXT_texture_storage::glTextureStorage2DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height)
{
    Q_D(QOpenGLExtension_EXT_texture_storage);
    d->TextureStorage2DEXT(texture, target, levels, internalformat, width, height);
}

inline void QOpenGLExtension_EXT_texture_storage::glTextureStorage3DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth)
{
    Q_D(QOpenGLExtension_EXT_texture_storage);
    d->TextureStorage3DEXT(texture, target, levels, internalformat, width, height, depth);
}

class QOpenGLExtension_IMG_multisampled_render_to_texturePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP RenderbufferStorageMultisampleIMG)(GLenum, GLsizei, GLenum, GLsizei, GLsizei);
    void (QOPENGLF_APIENTRYP FramebufferTexture2DMultisampleIMG)(GLenum, GLenum, GLenum, GLuint, GLint, GLsizei);
};

class QOpenGLExtension_IMG_multisampled_render_to_texture : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_IMG_multisampled_render_to_texture();

    bool initializeOpenGLFunctions() final;

    void glRenderbufferStorageMultisampleIMG(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
    void glFramebufferTexture2DMultisampleIMG(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLsizei samples);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_IMG_multisampled_render_to_texture)
};

inline void QOpenGLExtension_IMG_multisampled_render_to_texture::glRenderbufferStorageMultisampleIMG(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height)
{
    Q_D(QOpenGLExtension_IMG_multisampled_render_to_texture);
    d->RenderbufferStorageMultisampleIMG(target, samples, internalformat, width, height);
}

inline void QOpenGLExtension_IMG_multisampled_render_to_texture::glFramebufferTexture2DMultisampleIMG(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLsizei samples)
{
    Q_D(QOpenGLExtension_IMG_multisampled_render_to_texture);
    d->FramebufferTexture2DMultisampleIMG(target, attachment, textarget, texture, level, samples);
}

class QOpenGLExtension_NV_coverage_samplePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP CoverageMaskNV)(GLboolean mask);
    void (QOPENGLF_APIENTRYP CoverageOperationNV)(GLenum operation);
};

class QOpenGLExtension_NV_coverage_sample : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_coverage_sample();

    bool initializeOpenGLFunctions() final;

    void glCoverageMaskNV(GLboolean mask);
    void glCoverageOperationNV(GLenum operation);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_coverage_sample)
};

inline void QOpenGLExtension_NV_coverage_sample::glCoverageMaskNV(GLboolean mask)
{
    Q_D(QOpenGLExtension_NV_coverage_sample);
    d->CoverageMaskNV(mask);
}

inline void QOpenGLExtension_NV_coverage_sample::glCoverageOperationNV(GLenum operation)
{
    Q_D(QOpenGLExtension_NV_coverage_sample);
    d->CoverageOperationNV(operation);
}

class QOpenGLExtension_NV_draw_buffersPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP DrawBuffersNV)(GLsizei n, const GLenum *bufs);
};

class QOpenGLExtension_NV_draw_buffers : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_draw_buffers();

    bool initializeOpenGLFunctions() final;

    void glDrawBuffersNV(GLsizei n, const GLenum *bufs);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_draw_buffers)
};

inline void QOpenGLExtension_NV_draw_buffers::glDrawBuffersNV(GLsizei n, const GLenum *bufs)
{
    Q_D(QOpenGLExtension_NV_draw_buffers);
    d->DrawBuffersNV(n, bufs);
}

class QOpenGLExtension_NV_fencePrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP DeleteFencesNV)(GLsizei n, const GLuint *fences);
    void (QOPENGLF_APIENTRYP GenFencesNV)(GLsizei n, GLuint *fences);
    GLboolean (QOPENGLF_APIENTRYP IsFenceNV)(GLuint fence);
    GLboolean (QOPENGLF_APIENTRYP TestFenceNV)(GLuint fence);
    void (QOPENGLF_APIENTRYP GetFenceivNV)(GLuint fence, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP FinishFenceNV)(GLuint fence);
    void (QOPENGLF_APIENTRYP SetFenceNV)(GLuint fence, GLenum condition);
};

class QOpenGLExtension_NV_fence : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_fence();

    bool initializeOpenGLFunctions() final;

    void glDeleteFencesNV(GLsizei n, const GLuint *fences);
    void glGenFencesNV(GLsizei n, GLuint *fences);
    GLboolean glIsFenceNV(GLuint fence);
    GLboolean glTestFenceNV(GLuint fence);
    void glGetFenceivNV(GLuint fence, GLenum pname, GLint *params);
    void glFinishFenceNV(GLuint fence);
    void glSetFenceNV(GLuint fence, GLenum condition);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_fence)
};

inline void QOpenGLExtension_NV_fence::glDeleteFencesNV(GLsizei n, const GLuint *fences)
{
    Q_D(QOpenGLExtension_NV_fence);
    d->DeleteFencesNV(n, fences);
}

inline void QOpenGLExtension_NV_fence::glGenFencesNV(GLsizei n, GLuint *fences)
{
    Q_D(QOpenGLExtension_NV_fence);
    d->GenFencesNV(n, fences);
}

inline GLboolean QOpenGLExtension_NV_fence::glIsFenceNV(GLuint fence)
{
    Q_D(QOpenGLExtension_NV_fence);
    return d->IsFenceNV(fence);
}

inline GLboolean QOpenGLExtension_NV_fence::glTestFenceNV(GLuint fence)
{
    Q_D(QOpenGLExtension_NV_fence);
    return d->TestFenceNV(fence);
}

inline void QOpenGLExtension_NV_fence::glGetFenceivNV(GLuint fence, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_NV_fence);
    d->GetFenceivNV(fence, pname, params);
}

inline void QOpenGLExtension_NV_fence::glFinishFenceNV(GLuint fence)
{
    Q_D(QOpenGLExtension_NV_fence);
    d->FinishFenceNV(fence);
}

inline void QOpenGLExtension_NV_fence::glSetFenceNV(GLuint fence, GLenum condition)
{
    Q_D(QOpenGLExtension_NV_fence);
    d->SetFenceNV(fence, condition);
}

class QOpenGLExtension_NV_read_bufferPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP ReadBufferNV)(GLenum mode);
};

class QOpenGLExtension_NV_read_buffer : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_NV_read_buffer();

    bool initializeOpenGLFunctions() final;

    void glReadBufferNV(GLenum mode);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_NV_read_buffer)
};

inline void QOpenGLExtension_NV_read_buffer::glReadBufferNV(GLenum mode)
{
    Q_D(QOpenGLExtension_NV_read_buffer);
    d->ReadBufferNV(mode);
}

class QOpenGLExtension_QCOM_alpha_testPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP AlphaFuncQCOM)(GLenum func, GLclampf ref);
};

class QOpenGLExtension_QCOM_alpha_test : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_QCOM_alpha_test();

    bool initializeOpenGLFunctions() final;

    void glAlphaFuncQCOM(GLenum func, GLclampf ref);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_QCOM_alpha_test)
};

inline void QOpenGLExtension_QCOM_alpha_test::glAlphaFuncQCOM(GLenum func, GLclampf ref)
{
    Q_D(QOpenGLExtension_QCOM_alpha_test);
    d->AlphaFuncQCOM(func, ref);
}

class QOpenGLExtension_QCOM_driver_controlPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP GetDriverControlsQCOM)(GLint *num, GLsizei size, GLuint *driverControls);
    void (QOPENGLF_APIENTRYP GetDriverControlStringQCOM)(GLuint driverControl, GLsizei bufSize, GLsizei *length, GLchar *driverControlString);
    void (QOPENGLF_APIENTRYP EnableDriverControlQCOM)(GLuint driverControl);
    void (QOPENGLF_APIENTRYP DisableDriverControlQCOM)(GLuint driverControl);
};

class QOpenGLExtension_QCOM_driver_control : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_QCOM_driver_control();

    bool initializeOpenGLFunctions() final;

    void glGetDriverControlsQCOM(GLint *num, GLsizei size, GLuint *driverControls);
    void glGetDriverControlStringQCOM(GLuint driverControl, GLsizei bufSize, GLsizei *length, GLchar *driverControlString);
    void glEnableDriverControlQCOM(GLuint driverControl);
    void glDisableDriverControlQCOM(GLuint driverControl);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_QCOM_driver_control)
};

inline void QOpenGLExtension_QCOM_driver_control::glGetDriverControlsQCOM(GLint *num, GLsizei size, GLuint *driverControls)
{
    Q_D(QOpenGLExtension_QCOM_driver_control);
    d->GetDriverControlsQCOM(num, size, driverControls);
}

inline void QOpenGLExtension_QCOM_driver_control::glGetDriverControlStringQCOM(GLuint driverControl, GLsizei bufSize, GLsizei *length, GLchar *driverControlString)
{
    Q_D(QOpenGLExtension_QCOM_driver_control);
    d->GetDriverControlStringQCOM(driverControl, bufSize, length, driverControlString);
}

inline void QOpenGLExtension_QCOM_driver_control::glEnableDriverControlQCOM(GLuint driverControl)
{
    Q_D(QOpenGLExtension_QCOM_driver_control);
    d->EnableDriverControlQCOM(driverControl);
}

inline void QOpenGLExtension_QCOM_driver_control::glDisableDriverControlQCOM(GLuint driverControl)
{
    Q_D(QOpenGLExtension_QCOM_driver_control);
    d->DisableDriverControlQCOM(driverControl);
}

class QOpenGLExtension_QCOM_extended_getPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP ExtGetTexturesQCOM)(GLuint *textures, GLint maxTextures, GLint *numTextures);
    void (QOPENGLF_APIENTRYP ExtGetBuffersQCOM)(GLuint *buffers, GLint maxBuffers, GLint *numBuffers);
    void (QOPENGLF_APIENTRYP ExtGetRenderbuffersQCOM)(GLuint *renderbuffers, GLint maxRenderbuffers, GLint *numRenderbuffers);
    void (QOPENGLF_APIENTRYP ExtGetFramebuffersQCOM)(GLuint *framebuffers, GLint maxFramebuffers, GLint *numFramebuffers);
    void (QOPENGLF_APIENTRYP ExtGetTexLevelParameterivQCOM)(GLuint texture, GLenum face, GLint level, GLenum pname, GLint *params);
    void (QOPENGLF_APIENTRYP ExtTexObjectStateOverrideiQCOM)(GLenum target, GLenum pname, GLint param);
    void (QOPENGLF_APIENTRYP ExtGetTexSubImageQCOM)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, GLvoid *texels);
    void (QOPENGLF_APIENTRYP ExtGetBufferPointervQCOM)(GLenum target, GLvoid **params);
};

class QOpenGLExtension_QCOM_extended_get : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_QCOM_extended_get();

    bool initializeOpenGLFunctions() final;

    void glExtGetTexturesQCOM(GLuint *textures, GLint maxTextures, GLint *numTextures);
    void glExtGetBuffersQCOM(GLuint *buffers, GLint maxBuffers, GLint *numBuffers);
    void glExtGetRenderbuffersQCOM(GLuint *renderbuffers, GLint maxRenderbuffers, GLint *numRenderbuffers);
    void glExtGetFramebuffersQCOM(GLuint *framebuffers, GLint maxFramebuffers, GLint *numFramebuffers);
    void glExtGetTexLevelParameterivQCOM(GLuint texture, GLenum face, GLint level, GLenum pname, GLint *params);
    void glExtTexObjectStateOverrideiQCOM(GLenum target, GLenum pname, GLint param);
    void glExtGetTexSubImageQCOM(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, GLvoid *texels);
    void glExtGetBufferPointervQCOM(GLenum target, GLvoid **params);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_QCOM_extended_get)
};

inline void QOpenGLExtension_QCOM_extended_get::glExtGetTexturesQCOM(GLuint *textures, GLint maxTextures, GLint *numTextures)
{
    Q_D(QOpenGLExtension_QCOM_extended_get);
    d->ExtGetTexturesQCOM(textures, maxTextures, numTextures);
}

inline void QOpenGLExtension_QCOM_extended_get::glExtGetBuffersQCOM(GLuint *buffers, GLint maxBuffers, GLint *numBuffers)
{
    Q_D(QOpenGLExtension_QCOM_extended_get);
    d->ExtGetBuffersQCOM(buffers, maxBuffers, numBuffers);
}

inline void QOpenGLExtension_QCOM_extended_get::glExtGetRenderbuffersQCOM(GLuint *renderbuffers, GLint maxRenderbuffers, GLint *numRenderbuffers)
{
    Q_D(QOpenGLExtension_QCOM_extended_get);
    d->ExtGetRenderbuffersQCOM(renderbuffers, maxRenderbuffers, numRenderbuffers);
}

inline void QOpenGLExtension_QCOM_extended_get::glExtGetFramebuffersQCOM(GLuint *framebuffers, GLint maxFramebuffers, GLint *numFramebuffers)
{
    Q_D(QOpenGLExtension_QCOM_extended_get);
    d->ExtGetFramebuffersQCOM(framebuffers, maxFramebuffers, numFramebuffers);
}

inline void QOpenGLExtension_QCOM_extended_get::glExtGetTexLevelParameterivQCOM(GLuint texture, GLenum face, GLint level, GLenum pname, GLint *params)
{
    Q_D(QOpenGLExtension_QCOM_extended_get);
    d->ExtGetTexLevelParameterivQCOM(texture, face, level, pname, params);
}

inline void QOpenGLExtension_QCOM_extended_get::glExtTexObjectStateOverrideiQCOM(GLenum target, GLenum pname, GLint param)
{
    Q_D(QOpenGLExtension_QCOM_extended_get);
    d->ExtTexObjectStateOverrideiQCOM(target, pname, param);
}

inline void QOpenGLExtension_QCOM_extended_get::glExtGetTexSubImageQCOM(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, GLvoid *texels)
{
    Q_D(QOpenGLExtension_QCOM_extended_get);
    d->ExtGetTexSubImageQCOM(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, texels);
}

inline void QOpenGLExtension_QCOM_extended_get::glExtGetBufferPointervQCOM(GLenum target, GLvoid **params)
{
    Q_D(QOpenGLExtension_QCOM_extended_get);
    d->ExtGetBufferPointervQCOM(target, params);
}

class QOpenGLExtension_QCOM_extended_get2Private : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP ExtGetShadersQCOM)(GLuint *shaders, GLint maxShaders, GLint *numShaders);
    void (QOPENGLF_APIENTRYP ExtGetProgramsQCOM)(GLuint *programs, GLint maxPrograms, GLint *numPrograms);
    GLboolean (QOPENGLF_APIENTRYP ExtIsProgramBinaryQCOM)(GLuint program);
    void (QOPENGLF_APIENTRYP ExtGetProgramBinarySourceQCOM)(GLuint program, GLenum shadertype, GLchar *source, GLint *length);
};

class QOpenGLExtension_QCOM_extended_get2 : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_QCOM_extended_get2();

    bool initializeOpenGLFunctions() final;

    void glExtGetShadersQCOM(GLuint *shaders, GLint maxShaders, GLint *numShaders);
    void glExtGetProgramsQCOM(GLuint *programs, GLint maxPrograms, GLint *numPrograms);
    GLboolean glExtIsProgramBinaryQCOM(GLuint program);
    void glExtGetProgramBinarySourceQCOM(GLuint program, GLenum shadertype, GLchar *source, GLint *length);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_QCOM_extended_get2)
};

inline void QOpenGLExtension_QCOM_extended_get2::glExtGetShadersQCOM(GLuint *shaders, GLint maxShaders, GLint *numShaders)
{
    Q_D(QOpenGLExtension_QCOM_extended_get2);
    d->ExtGetShadersQCOM(shaders, maxShaders, numShaders);
}

inline void QOpenGLExtension_QCOM_extended_get2::glExtGetProgramsQCOM(GLuint *programs, GLint maxPrograms, GLint *numPrograms)
{
    Q_D(QOpenGLExtension_QCOM_extended_get2);
    d->ExtGetProgramsQCOM(programs, maxPrograms, numPrograms);
}

inline GLboolean QOpenGLExtension_QCOM_extended_get2::glExtIsProgramBinaryQCOM(GLuint program)
{
    Q_D(QOpenGLExtension_QCOM_extended_get2);
    return d->ExtIsProgramBinaryQCOM(program);
}

inline void QOpenGLExtension_QCOM_extended_get2::glExtGetProgramBinarySourceQCOM(GLuint program, GLenum shadertype, GLchar *source, GLint *length)
{
    Q_D(QOpenGLExtension_QCOM_extended_get2);
    d->ExtGetProgramBinarySourceQCOM(program, shadertype, source, length);
}

class QOpenGLExtension_QCOM_tiled_renderingPrivate : public QAbstractOpenGLExtensionPrivate
{
public:
    void (QOPENGLF_APIENTRYP StartTilingQCOM)(GLuint x, GLuint y, GLuint width, GLuint height, GLbitfield preserveMask);
    void (QOPENGLF_APIENTRYP EndTilingQCOM)(GLbitfield preserveMask);
};

class QOpenGLExtension_QCOM_tiled_rendering : public QAbstractOpenGLExtension
{
public:
    QOpenGLExtension_QCOM_tiled_rendering();

    bool initializeOpenGLFunctions() final;

    void glStartTilingQCOM(GLuint x, GLuint y, GLuint width, GLuint height, GLbitfield preserveMask);
    void glEndTilingQCOM(GLbitfield preserveMask);

protected:
    Q_DECLARE_PRIVATE(QOpenGLExtension_QCOM_tiled_rendering)
};

inline void QOpenGLExtension_QCOM_tiled_rendering::glStartTilingQCOM(GLuint x, GLuint y, GLuint width, GLuint height, GLbitfield preserveMask)
{
    Q_D(QOpenGLExtension_QCOM_tiled_rendering);
    d->StartTilingQCOM(x, y, width, height, preserveMask);
}

inline void QOpenGLExtension_QCOM_tiled_rendering::glEndTilingQCOM(GLbitfield preserveMask)
{
    Q_D(QOpenGLExtension_QCOM_tiled_rendering);
    d->EndTilingQCOM(preserveMask);
}

#endif

QT_END_NAMESPACE

#endif // QT_NO_OPENGL

#endif
