/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.dynamite.client;

import android.content.Context;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.Log;
import com.google.vr.dynamite.client.ILoadedInstanceCreator;
import com.google.vr.dynamite.client.INativeLibraryLoader;
import com.google.vr.dynamite.client.LoaderException;
import com.google.vr.dynamite.client.ObjectWrapper;
import com.google.vr.dynamite.client.RemoteLibraryLoader;
import com.google.vr.dynamite.client.TargetLibraryInfo;
import com.google.vr.dynamite.client.UsedByNative;
import com.google.vr.dynamite.client.Version;

@UsedByNative(value="dynamite_client.cc")
public final class DynamiteClient {
    private static final String TAG = "DynamiteClient";
    private static final ArrayMap<TargetLibraryInfo, RemoteLibraryLoader> targetLibraries = new ArrayMap();

    private DynamiteClient() {
    }

    @UsedByNative(value="dynamite_client.cc")
    public static synchronized int checkVersion(Context context, String remotePackageName, String libraryName, String clientVersionString) {
        if (Version.parse(clientVersionString) == null) {
            String string = String.valueOf(clientVersionString);
            throw new IllegalArgumentException(string.length() != 0 ? "Improperly formatted minVersion string: ".concat(string) : new String("Improperly formatted minVersion string: "));
        }
        TargetLibraryInfo info = new TargetLibraryInfo(remotePackageName, libraryName);
        RemoteLibraryLoader remoteLibLoader = DynamiteClient.getRemoteLibraryLoaderFromInfo(info);
        try {
            Context remoteContext = remoteLibLoader.getRemoteContext(context);
            ILoadedInstanceCreator creator = remoteLibLoader.getRemoteCreator(context);
            INativeLibraryLoader loader = creator.newNativeLibraryLoader(ObjectWrapper.wrap(remoteContext), ObjectWrapper.wrap(context));
            if (loader == null) {
                String string = String.valueOf(info);
                Log.e((String)TAG, (String)new StringBuilder(72 + String.valueOf(string).length()).append("Failed to load native library ").append(string).append(" from remote package: no loader available.").toString());
                return -1;
            }
            return loader.checkVersion(clientVersionString);
        }
        catch (RemoteException | LoaderException | IllegalArgumentException | IllegalStateException | SecurityException | UnsatisfiedLinkError e) {
            String string = String.valueOf(info);
            Log.e((String)TAG, (String)new StringBuilder(54 + String.valueOf(string).length()).append("Failed to load native library ").append(string).append(" from remote package:\n  ").toString(), (Throwable)e);
            return -1;
        }
    }

    @UsedByNative(value="dynamite_client.cc")
    public static synchronized long loadNativeRemoteLibrary(Context context, String remotePackageName, String libraryName) {
        TargetLibraryInfo info = new TargetLibraryInfo(remotePackageName, libraryName);
        RemoteLibraryLoader remoteLibLoader = DynamiteClient.getRemoteLibraryLoaderFromInfo(info);
        try {
            Context remoteContext = remoteLibLoader.getRemoteContext(context);
            ILoadedInstanceCreator creator = remoteLibLoader.getRemoteCreator(context);
            INativeLibraryLoader loader = creator.newNativeLibraryLoader(ObjectWrapper.wrap(remoteContext), ObjectWrapper.wrap(context));
            if (loader == null) {
                String string = String.valueOf(info);
                Log.e((String)TAG, (String)new StringBuilder(72 + String.valueOf(string).length()).append("Failed to load native library ").append(string).append(" from remote package: no loader available.").toString());
                return 0L;
            }
            return loader.initializeAndLoadNativeLibrary(libraryName);
        }
        catch (RemoteException | LoaderException | IllegalArgumentException | IllegalStateException | SecurityException | UnsatisfiedLinkError e) {
            String string = String.valueOf(info);
            Log.e((String)TAG, (String)new StringBuilder(54 + String.valueOf(string).length()).append("Failed to load native library ").append(string).append(" from remote package:\n  ").toString(), (Throwable)e);
            return 0L;
        }
    }

    @UsedByNative(value="dynamite_client.cc")
    public static synchronized ClassLoader getRemoteClassLoader(Context context, String remotePackageName, String libraryName) {
        Context remoteContext;
        TargetLibraryInfo info = new TargetLibraryInfo(remotePackageName, libraryName);
        RemoteLibraryLoader remoteLibLoader = DynamiteClient.getRemoteLibraryLoaderFromInfo(info);
        try {
            remoteContext = remoteLibLoader.getRemoteContext(context);
        }
        catch (LoaderException e) {
            String string = String.valueOf(info);
            Log.e((String)TAG, (String)new StringBuilder(52 + String.valueOf(string).length()).append("Failed to get remote Context").append(string).append(" from remote package:\n  ").toString(), (Throwable)e);
            return null;
        }
        if (remoteContext != null) {
            return remoteContext.getClassLoader();
        }
        return null;
    }

    @UsedByNative(value="dynamite_client.cc")
    private static synchronized RemoteLibraryLoader getRemoteLibraryLoaderFromInfo(TargetLibraryInfo info) {
        RemoteLibraryLoader remoteLibLoader = (RemoteLibraryLoader)targetLibraries.get((Object)info);
        if (remoteLibLoader == null) {
            remoteLibLoader = new RemoteLibraryLoader(info);
            targetLibraries.put((Object)info, (Object)remoteLibLoader);
        }
        return remoteLibLoader;
    }
}

