/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JavaScript Engine testing utilities.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corp.
 * Portions created by the Initial Developer are Copyright (C) 2002
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   pschwartau@netscape.com
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

/*
 *
 * Date:    19 Mar 2002
 * SUMMARY: Function declarations in global or function scope are {DontDelete}.
 *          Function declarations in eval scope are not {DontDelete}.
 *
 * See http://bugzilla.mozilla.org/show_bug.cgi?id=131964
 *
 */
//-----------------------------------------------------------------------------
var gTestfile = 'regress-131964.js';
var UBound = 0;
var BUGNUMBER =   131964;
var summary = 'Functions defined in global or function scope are {DontDelete}';
var status = '';
var statusitems = [];
var actual = '';
var actualvalues = [];
var expect= '';
var expectedvalues = [];


status = inSection(1);
function f()
{
  return 'f lives!';
}
delete f;

try
{
  actual = f();
}
catch(e)
{
  actual = 'f was deleted';
}

expect = 'f lives!';
addThis();



/*
 * Try the same test in function scope -
 */
status = inSection(2);
function g()
{
  function f()
  {
    return 'f lives!';
  }
  delete f;

  try
  {
    actual = f();
  }
  catch(e)
  {
    actual = 'f was deleted';
  }

  expect = 'f lives!';
  addThis();
}
g();



/*
 * Try the same test in eval scope - here we EXPECT the function to be deleted (?)
 */
status = inSection(3);
var s = '';
s += 'function h()';
s += '{ ';
s += '  return "h lives!";';
s += '}';
s += 'delete h;';

s += 'try';
s += '{';
s += '  actual = h();';
s += '}';
s += 'catch(e)';
s += '{';
s += '  actual = "h was deleted";';
s += '}';

s += 'expect = "h was deleted";';
s += 'addThis();';
eval(s);


/*
 * Define the function in eval scope, but delete it in global scope -
 */
status = inSection(4);
s = '';
s += 'function k()';
s += '{ ';
s += '  return "k lives!";';
s += '}';
eval(s);

delete k;

try
{
  actual = k();
}
catch(e)
{
  actual = 'k was deleted';
}

expect = 'k was deleted';
addThis();




//-----------------------------------------------------------------------------
test();
//-----------------------------------------------------------------------------



function wasDeleted(functionName)
{
  return functionName + ' was deleted...';
}


function addThis()
{
  statusitems[UBound] = status;
  actualvalues[UBound] = actual;
  expectedvalues[UBound] = expect;
  UBound++;
}


function test()
{
  enterFunc('test');
  printBugNumber(BUGNUMBER);
  printStatus(summary);

  for (var i=0; i<UBound; i++)
  {
    reportCompare(expectedvalues[i], actualvalues[i], statusitems[i]);
  }

  exitFunc ('test');
}
