CURRENT_MAC_SDK_VERSION := $(shell /usr/bin/xcrun --sdk $(EXPORT_QMAKE_MAC_SDK) -show-sdk-version)

ifneq ($(CURRENT_MAC_SDK_VERSION),$(EXPORT_QMAKE_MAC_SDK_VERSION))
    $(info The platform SDK has been changed from version $(EXPORT_QMAKE_MAC_SDK_VERSION) to version $(CURRENT_MAC_SDK_VERSION).)
    $(info This requires a fresh build. Please wipe the build directory completely,)
    $(info including any .qmake.stash and .qmake.cache files generated by qmake.)
    # FIXME: Ideally this should be advertised as just running make distclean, or we
    # should even do it automatically by having proper makefile dependencies between
    # .qmake.stash and the SDK version, but as qmake doesn't seem to be consistent in
    # how it deals with .qmake.stash as a dependency we need to defer that until later.
    $(error ^)
endif
