/*
 * Copyright (C) 2010 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef WebGLExtension_h
#define WebGLExtension_h

#include "core/html/canvas/HTMLCanvasElement.h"
#include "modules/webgl/WebGLExtensionName.h"
#include "modules/webgl/WebGLRenderingContextBase.h"
#include "platform/bindings/ScriptWrappable.h"
#include "platform/heap/Handle.h"

namespace blink {

class WebGLExtensionScopedContext final {
  STACK_ALLOCATED();
  WTF_MAKE_NONCOPYABLE(WebGLExtensionScopedContext);

 public:
  explicit WebGLExtensionScopedContext(WebGLExtension*);
  ~WebGLExtensionScopedContext();

  bool IsLost() const { return !context_; }
  WebGLRenderingContextBase* Context() const { return context_.Get(); }

 private:
  Member<WebGLRenderingContextBase> context_;
};

class WebGLExtension : public ScriptWrappable {
  WTF_MAKE_NONCOPYABLE(WebGLExtension);

 public:
  virtual WebGLExtensionName GetName() const = 0;

  // Lose this extension. Passing true = force loss. Some extensions
  // like WEBGL_lose_context are not normally lost when the context
  // is lost but must be lost when destroying their WebGLRenderingContextBase.
  virtual void Lose(bool) { context_ = nullptr; }

  bool IsLost() { return !context_; }

  virtual void Trace(blink::Visitor*);

 protected:
  explicit WebGLExtension(WebGLRenderingContextBase*);

 private:
  friend WebGLExtensionScopedContext;

  WeakMember<WebGLRenderingContextBase> context_;
};

}  // namespace blink

#endif  // WebGLExtension_h
