/* Generated by wayland-scanner 1.13.0 */

#ifndef KEYBOARD_CONFIGURATION_UNSTABLE_V1_SERVER_PROTOCOL_H
#define KEYBOARD_CONFIGURATION_UNSTABLE_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_keyboard_configuration_unstable_v1 The keyboard_configuration_unstable_v1 protocol
 * @section page_ifaces_keyboard_configuration_unstable_v1 Interfaces
 * - @subpage page_iface_zcr_keyboard_configuration_v1 - extends wl_keyboard with events for device configuration change
 * - @subpage page_iface_zcr_keyboard_device_configuration_v1 - extension of wl_keyboard protocol
 * @section page_copyright_keyboard_configuration_unstable_v1 Copyright
 * <pre>
 *
 * Copyright 2016 The Chromium Authors.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_keyboard;
struct zcr_keyboard_configuration_v1;
struct zcr_keyboard_device_configuration_v1;

/**
 * @page page_iface_zcr_keyboard_configuration_v1 zcr_keyboard_configuration_v1
 * @section page_iface_zcr_keyboard_configuration_v1_desc Description
 *
 * Allows a wl_keyboard to notify device configuration change events of
 * the keyboard to the client.
 *
 * Warning! The protocol described in this file is experimental and
 * backward incompatible changes may be made. Backward compatible changes
 * may be added together with the corresponding uinterface version bump.
 * Backward incompatible changes are done by bumping the version number in
 * the protocol and uinterface names and resetting the interface version.
 * Once the protocol is to be declared stable, the 'z' prefix and the
 * version number in the protocol and interface names are removed and the
 * interface version number is reset.
 * @section page_iface_zcr_keyboard_configuration_v1_api API
 * See @ref iface_zcr_keyboard_configuration_v1.
 */
/**
 * @defgroup iface_zcr_keyboard_configuration_v1 The zcr_keyboard_configuration_v1 interface
 *
 * Allows a wl_keyboard to notify device configuration change events of
 * the keyboard to the client.
 *
 * Warning! The protocol described in this file is experimental and
 * backward incompatible changes may be made. Backward compatible changes
 * may be added together with the corresponding uinterface version bump.
 * Backward incompatible changes are done by bumping the version number in
 * the protocol and uinterface names and resetting the interface version.
 * Once the protocol is to be declared stable, the 'z' prefix and the
 * version number in the protocol and interface names are removed and the
 * interface version number is reset.
 */
extern const struct wl_interface zcr_keyboard_configuration_v1_interface;
/**
 * @page page_iface_zcr_keyboard_device_configuration_v1 zcr_keyboard_device_configuration_v1
 * @section page_iface_zcr_keyboard_device_configuration_v1_desc Description
 *
 * The zcr_keyboard_device_configuration_v1 interface extends the wl_keyboard
 * interface with events to describe device configuration of a keyboard.
 * @section page_iface_zcr_keyboard_device_configuration_v1_api API
 * See @ref iface_zcr_keyboard_device_configuration_v1.
 */
/**
 * @defgroup iface_zcr_keyboard_device_configuration_v1 The zcr_keyboard_device_configuration_v1 interface
 *
 * The zcr_keyboard_device_configuration_v1 interface extends the wl_keyboard
 * interface with events to describe device configuration of a keyboard.
 */
extern const struct wl_interface zcr_keyboard_device_configuration_v1_interface;

#ifndef ZCR_KEYBOARD_CONFIGURATION_V1_ERROR_ENUM
#define ZCR_KEYBOARD_CONFIGURATION_V1_ERROR_ENUM
enum zcr_keyboard_configuration_v1_error {
	/**
	 * the keyboard already has a device configuration object associated
	 */
	ZCR_KEYBOARD_CONFIGURATION_V1_ERROR_DEVICE_CONFIGURATION_EXISTS = 0,
};
#endif /* ZCR_KEYBOARD_CONFIGURATION_V1_ERROR_ENUM */

/**
 * @ingroup iface_zcr_keyboard_configuration_v1
 * @struct zcr_keyboard_configuration_v1_interface
 */
struct zcr_keyboard_configuration_v1_interface {
	/**
	 * get keyboard_device_configuration interface for a keyboard
	 *
	 * Create keyboard_device_configuration object. See
	 * zcr_keyboard_device_configuration interface for details. If the
	 * given wl_keyboard object already has a device configuration
	 * object associated, the keyboard_device_configuration_exists
	 * protocol error is raised.
	 */
	void (*get_keyboard_device_configuration)(struct wl_client *client,
						  struct wl_resource *resource,
						  uint32_t id,
						  struct wl_resource *keyboard);
};


/**
 * @ingroup iface_zcr_keyboard_configuration_v1
 */
#define ZCR_KEYBOARD_CONFIGURATION_V1_GET_KEYBOARD_DEVICE_CONFIGURATION_SINCE_VERSION 1

#ifndef ZCR_KEYBOARD_DEVICE_CONFIGURATION_V1_KEYBOARD_TYPE_ENUM
#define ZCR_KEYBOARD_DEVICE_CONFIGURATION_V1_KEYBOARD_TYPE_ENUM
/**
 * @ingroup iface_zcr_keyboard_device_configuration_v1
 * keyboard types
 */
enum zcr_keyboard_device_configuration_v1_keyboard_type {
	/**
	 * Physical keyboard
	 */
	ZCR_KEYBOARD_DEVICE_CONFIGURATION_V1_KEYBOARD_TYPE_PHYSICAL = 0,
	/**
	 * Virtual keyboard
	 */
	ZCR_KEYBOARD_DEVICE_CONFIGURATION_V1_KEYBOARD_TYPE_VIRTUAL = 1,
};
#endif /* ZCR_KEYBOARD_DEVICE_CONFIGURATION_V1_KEYBOARD_TYPE_ENUM */

/**
 * @ingroup iface_zcr_keyboard_device_configuration_v1
 * @struct zcr_keyboard_device_configuration_v1_interface
 */
struct zcr_keyboard_device_configuration_v1_interface {
	/**
	 * destroy keyboard_device_configuration object
	 *
	 * 
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define ZCR_KEYBOARD_DEVICE_CONFIGURATION_V1_TYPE_CHANGE 0

/**
 * @ingroup iface_zcr_keyboard_device_configuration_v1
 */
#define ZCR_KEYBOARD_DEVICE_CONFIGURATION_V1_TYPE_CHANGE_SINCE_VERSION 1

/**
 * @ingroup iface_zcr_keyboard_device_configuration_v1
 */
#define ZCR_KEYBOARD_DEVICE_CONFIGURATION_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_zcr_keyboard_device_configuration_v1
 * Sends an type_change event to the client owning the resource.
 * @param resource_ The client's resource
 * @param type new device type
 */
static inline void
zcr_keyboard_device_configuration_v1_send_type_change(struct wl_resource *resource_, uint32_t type)
{
	wl_resource_post_event(resource_, ZCR_KEYBOARD_DEVICE_CONFIGURATION_V1_TYPE_CHANGE, type);
}

#ifdef  __cplusplus
}
#endif

#endif
