/*
 * Copyright (C) 2012 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef WebRTCSessionDescriptionRequest_h
#define WebRTCSessionDescriptionRequest_h

#include "WebCommon.h"
#include "WebNonCopyable.h"
#include "WebPrivatePtr.h"
#include "WebString.h"

namespace blink {

class RTCSessionDescriptionRequest;
class WebRTCSessionDescription;

class WebRTCSessionDescriptionRequest {
 public:
  WebRTCSessionDescriptionRequest() {}
  WebRTCSessionDescriptionRequest(
      const WebRTCSessionDescriptionRequest& other) {
    Assign(other);
  }
  ~WebRTCSessionDescriptionRequest() { Reset(); }

  WebRTCSessionDescriptionRequest& operator=(
      const WebRTCSessionDescriptionRequest& other) {
    Assign(other);
    return *this;
  }

  BLINK_PLATFORM_EXPORT void Assign(const WebRTCSessionDescriptionRequest&);

  BLINK_PLATFORM_EXPORT void Reset();
  bool IsNull() const { return private_.IsNull(); }

  BLINK_PLATFORM_EXPORT void RequestSucceeded(
      const WebRTCSessionDescription&) const;
  BLINK_PLATFORM_EXPORT void RequestFailed(const WebString& error) const;

#if INSIDE_BLINK
  BLINK_PLATFORM_EXPORT WebRTCSessionDescriptionRequest(
      RTCSessionDescriptionRequest*);
#endif

 private:
  WebPrivatePtr<RTCSessionDescriptionRequest,
                kWebPrivatePtrDestructionCrossThread>
      private_;
};

}  // namespace blink

#endif  // WebRTCSessionDescriptionRequest_h
