// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_VIZ_SERVICE_FRAME_SINKS_PRIMARY_BEGIN_FRAME_SOURCE_H_
#define COMPONENTS_VIZ_SERVICE_FRAME_SINKS_PRIMARY_BEGIN_FRAME_SOURCE_H_

#include "base/containers/flat_set.h"
#include "cc/scheduler/begin_frame_source.h"
#include "components/viz/service/viz_service_export.h"

namespace viz {

// PrimaryBeginFrameSource echos the first BeginFrameSource in the system.
// If the first source goes away then it will echo the new first
// BeginFrameSource.
class VIZ_SERVICE_EXPORT PrimaryBeginFrameSource
    : public cc::BeginFrameSource,
      public cc::BeginFrameObserver,
      public cc::ExternalBeginFrameSourceClient {
 public:
  PrimaryBeginFrameSource();
  ~PrimaryBeginFrameSource() override;

  void OnBeginFrameSourceAdded(cc::BeginFrameSource* begin_frame_source);
  void OnBeginFrameSourceRemoved(cc::BeginFrameSource* begin_frame_source);

  // cc::BeginFrameObserver implementation.
  void OnBeginFrame(const cc::BeginFrameArgs& args) override;
  const cc::BeginFrameArgs& LastUsedBeginFrameArgs() const override;
  void OnBeginFrameSourcePausedChanged(bool paused) override;

  // cc::BeginFrameSource implementation.
  void DidFinishFrame(cc::BeginFrameObserver* obs) override;
  void AddObserver(cc::BeginFrameObserver* obs) override;
  void RemoveObserver(cc::BeginFrameObserver* obs) override;
  bool IsThrottled() const override;

  // cc::ExternalBeginFrameSourceClient implementation.
  void OnNeedsBeginFrames(bool needs_begin_frames) override;

 private:
  cc::ExternalBeginFrameSource begin_frame_source_;
  cc::BeginFrameSource* current_begin_frame_source_ = nullptr;

  // The last begin frame args generated by the begin frame source.
  cc::BeginFrameArgs last_begin_frame_args_;

  bool needs_begin_frames_ = false;

  base::flat_set<cc::BeginFrameSource*> sources_;

  DISALLOW_COPY_AND_ASSIGN(PrimaryBeginFrameSource);
};

}  // namespace viz

#endif  // COMPONENTS_VIZ_SERVICE_FRAME_SINKS_PRIMARY_BEGIN_FRAME_SOURCE_H_
