/****************************************************************************
**
** Copyright (C) 2023 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

import QtQuick
import QtQuick.Controls
import WelcomeScreen 1.0
import StudioControls 1.0 as StudioControls
import projectmodel 1.0

ListModel {

    ListElement {
        qmlFileName: "tours/welcomepage-tour/WelcomeSlideShow.ui.qml"
        thumbnail: "images/tutorialclusterdemo_thumbnail.png"
        title: "Welcome Page"
        subtitle: "The welcome page of Qt Design Studio."
    }
    ListElement {
        qmlFileName: "tours/toolbar-tour/ToolbarSlideShow.ui.qml"
        thumbnail: "images/tutorialclusterdemo_thumbnail.png"
        title: "Top Toolbar"
        subtitle: "Short explanation of the top toolbar."
    }
    ListElement {
        qmlFileName: "tours/workspace-tour/WorkspaceSlideShow.ui.qml"
        thumbnail: "images/tutorialclusterdemo_thumbnail.png"
        title: "Workspaces"
        subtitle: "Introduction to the most important workspaces."
    }
    ListElement {
        qmlFileName: "tours/states-tour/StatesSlideShow.ui.qml"
        thumbnail: "images/tutorialclusterdemo_thumbnail.png"
        title: "States"
        subtitle: "An introduction to states."
    }
}
