/****************************************************************************
**
** Copyright (C) 2020 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the Qt Safe Renderer module
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick 2.1
import HelperWidgets 2.0
import QtQuick.Layouts 1.0

import QtQuick.Layouts 1.0

Column {
    anchors.left: parent.left
    anchors.right: parent.right

Section {
    anchors.left: parent.left
    anchors.right: parent.right
    caption: qsTr("Text")

    property bool showIsWrapping: false
    property bool showElide: false
    property bool showVerticalAlignment: true
    property bool useLineEdit: true
    property bool showFormatProperty: false
    property bool showFontSizeMode: false

    SectionLayout {
        columns: 2
        rows: 3
        Label {
            text: qsTr("Text")
        }
        LineEdit {
            backendValue: backendValues.text
            Layout.fillWidth: true
        }

        Label {
            text: qsTr("Wrap mode")
        }

        ComboBox {
            Layout.fillWidth: true
            backendValue: backendValues.wrapMode
            scope: "Text"
            model: ["NoWrap", "WordWrap", "WrapAnywhere", "WrapAtWordBoundaryOrAnywhere"]
        }

        Label {
            text: qsTr("Horizontal alignment")
        }

        AligmentHorizontalButtons {

        }

        Label {
            text: qsTr("Vertical alignment")
        }

        AligmentVerticalButtons {
            visible: showVerticalAlignment
        }

        Label {
            text: qsTr("Dynamic")
            tooltip: qsTr("Whether the text is possible to change runtime.")
        }
        CheckBox {
            text: backendValues.runtimeEditable.valueToString
            backendValue: backendValues.runtimeEditable
            Layout.fillWidth: true
        }

    }
}

FontSection {
    width: parent.width
}
}
