/****************************************************************************
**
** Copyright (C) 2017 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the test suite of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef GIFRECORDER_H
#define GIFRECORDER_H

#include <QObject>
#include <QProcess>
#include <QQmlApplicationEngine>
#include <QQuickWindow>
#include <QDir>
#include <QString>
#include <QTimer>

class GifRecorder : public QObject
{
    Q_OBJECT

public:
    GifRecorder();

    void setRecordingDuration(int duration);
    void setRecordCursor(bool recordCursor);
    void setDataDirPath(const QString &path);
    void setOutputDir(const QDir &dir);
    void setOutputFileBaseName(const QString &fileBaseName);
    void setQmlFileName(const QString &fileName);
    void setView(QQuickWindow *mWindow);
    void setHighQuality(bool highQuality);

    QQuickWindow *window() const;

    void start();
    bool hasStarted() const;
    void waitForFinish();

private slots:
    void onByzanzError();
    void onByzanzFinished();

private:
    QString mDataDirPath;
    QDir mOutputDir;
    QString mOutputFileBaseName;
    QString mByzanzOutputFileName;
    QString mGifFileName;
    QString mQmlInputFileName;
    QQmlApplicationEngine mEngine;
    QQuickWindow *mWindow;
    bool mHighQuality;
    int mRecordingDuration;
    bool mRecordCursor;

    QProcess mByzanzProcess;
    bool mByzanzProcessFinished;
    QTimer mEventTimer;
};

#endif // GIFRECORDER_H
