// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_BROWSER_API_ALARMS_ALARMS_API_H_
#define EXTENSIONS_BROWSER_API_ALARMS_ALARMS_API_H_

#include <vector>

#include "extensions/browser/extension_function.h"

namespace base {
class Clock;
}  // namespace base

namespace extensions {
struct Alarm;
using AlarmList = std::vector<std::unique_ptr<Alarm>>;

class AlarmsCreateFunction : public UIThreadExtensionFunction {
 public:
  AlarmsCreateFunction();
  // Use |clock| instead of the default clock. Does not take ownership
  // of |clock|. Used for testing.
  explicit AlarmsCreateFunction(base::Clock* clock);

 protected:
  ~AlarmsCreateFunction() override;

  // UIThreadExtensionFunction:
  ResponseAction Run() override;
  DECLARE_EXTENSION_FUNCTION("alarms.create", ALARMS_CREATE)
 private:
  void Callback();

  base::Clock* const clock_;
};

class AlarmsGetFunction : public UIThreadExtensionFunction {
 protected:
  ~AlarmsGetFunction() override {}

  // UIThreadExtensionFunction:
  ResponseAction Run() override;

 private:
  void Callback(const std::string& name, Alarm* alarm);
  DECLARE_EXTENSION_FUNCTION("alarms.get", ALARMS_GET)
};

class AlarmsGetAllFunction : public UIThreadExtensionFunction {
 protected:
  ~AlarmsGetAllFunction() override {}

  // UIThreadExtensionFunction:
  ResponseAction Run() override;

 private:
  void Callback(const AlarmList* alarms);
  DECLARE_EXTENSION_FUNCTION("alarms.getAll", ALARMS_GETALL)
};

class AlarmsClearFunction : public UIThreadExtensionFunction {
 protected:
  ~AlarmsClearFunction() override {}

  // UIThreadExtensionFunction:
  ResponseAction Run() override;

 private:
  void Callback(const std::string& name, bool success);
  DECLARE_EXTENSION_FUNCTION("alarms.clear", ALARMS_CLEAR)
};

class AlarmsClearAllFunction : public UIThreadExtensionFunction {
 protected:
  ~AlarmsClearAllFunction() override {}

  // UIThreadExtensionFunction:
  ResponseAction Run() override;

 private:
  void Callback();
  DECLARE_EXTENSION_FUNCTION("alarms.clearAll", ALARMS_CLEARALL)
};

}  //  namespace extensions

#endif  // EXTENSIONS_BROWSER_API_ALARMS_ALARMS_API_H_
