/****************************************************************************
**
** Copyright (C) 2017 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the release tools of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// constructor
function Component()
{
    // Determine if this is a online snapshot build
    var snapshotBuild = false;
    var isSnapshotStr = "false";
    if (['true', 'yes', '1'].indexOf(isSnapshotStr) >= 0)
        snapshotBuild = true;

    if (snapshotBuild) {
        // Indicate in DisplayName and Description that this is a snapshot build
        var displayName = component.value("DisplayName");
        var description = component.value("Description");
        component.setValue("DisplayName", displayName + " %QT_RELEASE_TAG% snapshot (#856)")
        component.setValue("Description", description + " %QT_RELEASE_TAG% snapshot (#856)")

        if (!installer.isOfflineOnly())
            component.setValue("Virtual", "true")

    }
}


Component.prototype.createOperations = function()
{
    component.createOperations();
}

