// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CSSSyntaxDescriptor_h
#define CSSSyntaxDescriptor_h

#include "core/css/parser/CSSParserTokenRange.h"

namespace blink {

class CSSParserContext;
class CSSValue;

enum class CSSSyntaxType {
  kTokenStream,
  kIdent,
  kLength,
  kNumber,
  kPercentage,
  kLengthPercentage,
  kColor,
  kImage,
  kUrl,
  kInteger,
  kAngle,
  kTime,
  kResolution,
  kTransformList,
  kCustomIdent,
};

struct CSSSyntaxComponent {
  CSSSyntaxComponent(CSSSyntaxType type, const String& string, bool repeatable)
      : type_(type), string_(string), repeatable_(repeatable) {}

  CSSSyntaxType type_;
  String string_;  // Only used when type_ is CSSSyntaxType::kIdent
  bool repeatable_;
};

class CORE_EXPORT CSSSyntaxDescriptor {
 public:
  CSSSyntaxDescriptor(String syntax);

  const CSSValue* Parse(CSSParserTokenRange,
                        const CSSParserContext*,
                        bool is_animation_tainted) const;
  bool IsValid() const { return !syntax_components_.IsEmpty(); }
  bool IsTokenStream() const {
    return syntax_components_.size() == 1 &&
           syntax_components_[0].type_ == CSSSyntaxType::kTokenStream;
  }
  const Vector<CSSSyntaxComponent>& Components() const {
    return syntax_components_;
  }

 private:
  Vector<CSSSyntaxComponent> syntax_components_;
};

}  // namespace blink

#endif  // CSSSyntaxDescriptor_h
