/****************************************************************************
**
** Copyright (C) 2025 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the release tools of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// constructor
function Component()
{

}

Component.prototype.createOperations = function()
{
    component.createOperations();
}


// Returns original host path based on original host OS

originalQtHostPath_690 = function(buildHostName)
{
    if (originalHostOS_690(buildHostName) === "Linux") {
        return "/home/qt/work/install";
    }
    else {
        return "/Users/qt/work/install";
    }
}

// Function that returns the value of what the component was originally build on

originalHostOS_690 = function(buildHostName)
{
    var originalHostOSName = buildHostName.toLowerCase();

    if (originalHostOSName.startsWith("macos")) {
        return "macOS";
    }
    else if (originalHostOSName.startsWith("windows")) {
        return "Windows";
    }
    else if (originalHostOSName.startsWith("linux")) {
        return "Linux";
    }
    else {
        console.log("Could not determine 'originalHostOSName' in function originalHostOS_690()");
        return "";
    }
}

// Functions that return a generic value

getNativePath_690 = function(TARGET_INSTALL_DIR, buildHostName = "")
{
    // WebAssembly, QNX and Android installations on Windows requires installation path with forward separators in certain cases
    if ((buildHostName.includes("WebAssembly") || buildHostName.includes("QNX") || buildHostName.includes("Android")) && (installer.value("os") === "win")) {
        var qtPathWindows_UnixSeparators = installer.value("TargetDir") + TARGET_INSTALL_DIR;
        return qtPathWindows_UnixSeparators.replace(/\\/g, "/");
    }

    return installer.toNativeSeparators(installer.value("TargetDir") + TARGET_INSTALL_DIR);
}

targetQtConfDocumentation_690 = function()
{
    return "Documentation=../../Docs/Qt-6.9.0";
}

targetQtConfExamples_690 = function()
{
    return "Examples=../../Examples/Qt-6.9.0";
}

originalHostPrefix_690 = function()
{
    return "HostPrefix=../../";
}

originalHostData_690 = function()
{
    return "HostData=target";
}

qdeviceFile_690 = function()
{
    return "/mkspecs/qdevice.pri";
}

qconfigFile_690 = function()
{
    return "/mkspecs/qconfig.pri";
}

qtConfigureModuleScript_690 = function()
{
    return installer.toNativeSeparators("/bin/qt-configure-module");
}

targetQtConf_690 = function()
{
    return installer.toNativeSeparators("/bin/target_qt.conf");
}

qtToolchainCmake_690 = function()
{
    return installer.toNativeSeparators("/lib/cmake/Qt6/qt.toolchain.cmake");
}

qtBuildInternalsExtraCmake_690 = function()
{
    return installer.toNativeSeparators("/lib/cmake/Qt6BuildInternals/QtBuildInternalsExtra.cmake");
}

qt6DependenciesCMakePath_690 = function()
{
    return installer.toNativeSeparators("/lib/cmake/Qt6/Qt6Dependencies.cmake");
}

originalHostTargetPath_690 = function(buildHostName)
{
    return originalQtHostPath_690(buildHostName) + "/target";
}

// Qnx specific functions

originalSysroot_690 = function()
{
    return "Sysroot=.*";
}

originalInitialToolchain_690 = function(qnxToolChainFile)
{
    return "/opt/qnx710/" + qnxToolChainFile;
}

newSysroot_690 = function()
{
    return "Sysroot=" + installer.toNativeSeparators(installer.value("QNX710_SDP_PATH") + "/target/qnx7");
}

newInitialToolchain_690 = function(qnxToolChainFile)
{
    return "/" + installer.toNativeSeparators(qnxToolChainFile);
}

sdpDirectoryPath_690 = function()
{
    return installer.value("QNX710_SDP_PATH");
}

// Functions that return a value based on what the original packages are build on

originalSetCmakePath_690 = function(buildHostName)
{
    if (originalHostOS_690(buildHostName) === "macOS") {
        return "/Applications/CMake.app/Contents/bin/cmake";
    }
    else if (originalHostOS_690(buildHostName) === "Windows") {
        return "C:/CMake/bin/cmake.exe";
    }
    else {
        return "/opt/cmake-*.*.*/bin/cmake";
    }
}

originalHostSpec_690 = function(buildHostName)
{
    if (originalHostOS_690(buildHostName) === "macOS") {
        return "macx-clang";
    }
    else if (originalHostOS_690(buildHostName) === "Windows") {
        return "win32-g++";
    }
    else {
        return "linux-g++";
    }
}

originalBIPrefix_690 = function(buildHostName)
{
    if (originalHostOS_690(buildHostName) === "macOS") {
        return "/usr/local/Qt-6.9.0";
    }
    else if (originalHostOS_690(buildHostName) === "Windows") {
        return "C:/Qt/Qt-6.9.0";
    }
    else {
        return "/usr/local/Qt-6.9.0";
    }
}

originalHostBinPath_690 = function(buildHostName)
{
     // Packages from windows has unix path separator until Qt 6.5.0 release.
    // After that it will have windows style one
    if (originalHostOS_690(buildHostName) === "Windows" && 69 >= 65) {
        return "\\Users\\qt\\work\\install\\bin";
    }
    else {
        return  originalQtHostPath_690(buildHostName) + "/bin";
    }
}

originalQmakePath_690 = function(buildHostName)
{
    if (installer.value("os") === "win") {
        return originalHostBinPath_690(buildHostName) + "\\qmake";
    }
    else {
        return originalHostBinPath_690(buildHostName) + "/qmake";
    }
}

originalQtPathsPath_690 = function(buildHostName)
{
    if (installer.value("os") === "win") {
        return originalHostBinPath_690(buildHostName) + "\\qtpaths";
    }
    else {
        return originalHostBinPath_690(buildHostName) + "/qtpaths";
    }
}

// Functions that return values used in patching

qtCMakePrivateScript_690 = function()
{
    if (installer.value("os") === "x11") {
        return "/libexec/qt-cmake-private";
    }
    else if (installer.value("os") === "mac") {
        return "/libexec/qt-cmake-private";
    }
    else {
        return "\\bin\\qt-cmake-private.bat";
    }
}

qtCMakeStandaloneTestScript_690 = function()
{
    if (installer.value("os") === "x11") {
        return "/libexec/qt-cmake-standalone-test";
    }
    else if (installer.value("os") === "mac") {
        return "/libexec/qt-cmake-standalone-test";
    }
    else {
        return "\\bin\\qt-cmake-standalone-test";
    }
}

qtPathsScript_690 = function()
{
    if (installer.value("os") === "win") {
        return "\\bin\\qtpaths.bat";
    }
    else {
        return "/bin/qtpaths";
    }
}

qtPaths6Script_690 = function()
{
    if (installer.value("os") === "win") {
        return "\\bin\\qtpaths6.bat";
    }
    else {
        return "/bin/qtpaths6";
    }
}

qtCMakeScript_690 = function()
{
    if (installer.value("os") === "win") {
        return "\\bin\\qt-cmake.bat";
    }
    else {
        return "/bin/qt-cmake";
    }
}

qmakeScript_690 = function()
{
    if (installer.value("os") === "win") {
        return "\\bin\\qmake.bat";
    }
    else {
        return "/bin/qmake";
    }
}

qmake6Script_690 = function()
{
    if (installer.value("os") === "win") {
        return "\\bin\\qmake6.bat";
    }
    else {
        return "/bin/qmake6";
    }
}

// Initialize New Host Data based on target_arch

newHostData_690 = function(target_arch, componentName)
{
    if (target_arch === "singlethread" || target_arch === "multithread") {
        return "HostData=../wasm_" + target_arch;
    }
    else if (target_arch === "wasm_32") {
        return "HostData=../" + target_arch;
    }

    else if (target_arch === "ios") {
        return "HostData=../" + target_arch;
    }

    else if (target_arch === "msvc2019_arm64") {
        return "HostData=../" + target_arch;
    }

    else if (target_arch === "msvc2022_arm64") {
        return "HostData=../" + target_arch;
    }

    else if (componentName.includes("qnx")) {
        return "HostData=../qnx71_" + target_arch;
    }

    else if (componentName.includes("android")) {
        return "HostData=../android_" + target_arch;
    }

    else {
        console.log("Error from component " + component.value("Name") + " in function newHostData");
        console.log("New host data cannot be initialized, checking if parameter target_arch is empty: " + target_arch);
        console.log("Checking if installed components name is passed correctly: " + componentName);
    }
}

// Functions that return a value new path used for patching

newQtPathsPath_690 = function(buildHostName)
{
    var buildTarget = buildHostName.toLowerCase();

    if (installer.value("os") === "x11") {
        if (systemInfo.currentCpuArchitecture == "arm64")
            return installer.toNativeSeparators(installer.value("TargetDir") + "/6.9.0/gcc_arm64/bin/qtpaths");
        else
            return installer.toNativeSeparators(installer.value("TargetDir") + "/6.9.0/gcc_64/bin/qtpaths");
    }
    else if (installer.value("os") === "win") {
        if (systemInfo.currentCpuArchitecture == "arm64")
            return installer.value("TargetDir") + "/6.9.0/msvc2022_arm64/bin/qtpaths";

        // Check if we are installing msvc2019 component
        else if (buildTarget.includes("msvc2019"))
            return installer.toNativeSeparators(installer.value("TargetDir") + "/6.9.0/msvc2019_64/bin/qtpaths");

        // Check if we are installing msvc2022 component
        else if (buildTarget.includes("msvc2022"))
            return installer.toNativeSeparators(installer.value("TargetDir") + "/6.9.0/msvc2022_64/bin/qtpaths");

        else
            return installer.toNativeSeparators(installer.value("TargetDir") + "/6.9.0/mingw_64/bin/qtpaths");
    }
    else {
        return installer.toNativeSeparators(installer.value("TargetDir") + "/6.9.0/macos/bin/qtpaths");
    }
}

newQmakePath_690 = function(buildHostName)
{
    var buildTarget = buildHostName.toLowerCase();

    if (installer.value("os") === "x11") {
        if (systemInfo.currentCpuArchitecture == "arm64")
            return installer.toNativeSeparators(installer.value("TargetDir") + "/6.9.0/gcc_arm64/bin/qmake");
        else
            return installer.toNativeSeparators(installer.value("TargetDir") + "/6.9.0/gcc_64/bin/qmake");
    }
    else if (installer.value("os") === "win") {
        if (systemInfo.currentCpuArchitecture == "arm64")
            return installer.value("TargetDir") + "/6.9.0/msvc2022_arm64/bin/qmake";

        // Check from component's name if we are installing msvc2019 component
        else if (buildTarget.includes("msvc2019"))
            return installer.toNativeSeparators(installer.value("TargetDir") + "/6.9.0/msvc2019_64/bin/qmake");

        // Check from component's name if we are installing msvc2022 component
        else if (buildTarget.includes("msvc2022"))
            return installer.toNativeSeparators(installer.value("TargetDir") + "/6.9.0/msvc2022_64/bin/qmake");

        else
            return installer.toNativeSeparators(installer.value("TargetDir") + "/6.9.0/mingw_64/bin/qmake");
    }
    else {
        return installer.toNativeSeparators(installer.value("TargetDir") + "/6.9.0/macos/bin/qmake");
    }
}

newQtHostPath_690 = function(buildHostName)
{
    var buildTarget = buildHostName.toLowerCase();

    if (installer.value("os") === "x11") {
        if (systemInfo.currentCpuArchitecture == "arm64")
            return installer.value("TargetDir") + "/6.9.0/gcc_arm64";
        else
            return installer.value("TargetDir") + "/6.9.0/gcc_64";
    }
    else if (installer.value("os") === "win") {
        if (systemInfo.currentCpuArchitecture == "arm64")
            return installer.value("TargetDir") + "/6.9.0/msvc2022_arm64";

        // Check from component's name if we are installing msvc2019 component
        else if (buildTarget.includes("msvc2019"))
            return installer.value("TargetDir") + "/6.9.0/msvc2019_64";

        // Check from component's name if we are installing msvc2022 component
        else if (buildTarget.includes("msvc2022"))
            return installer.value("TargetDir") + "/6.9.0/msvc2022_64";

        else
            return installer.value("TargetDir") + "/6.9.0/mingw_64";
    }
    else {
        return installer.value("TargetDir") + "/6.9.0/macos";
    }
}

newHostPrefix_690 = function(buildHostName)
{
    var prefix = buildHostName.toLowerCase();

    if (installer.value("os") === "x11") {
        if (systemInfo.currentCpuArchitecture == "arm64")
            return "HostPrefix=../../gcc_arm64";
        else
            return "HostPrefix=../../gcc_64";
    }
    else if (installer.value("os") === "win") {
        if (systemInfo.currentCpuArchitecture == "arm64")
            return "HostPrefix=../../msvc2022_arm64";

        else if (prefix.includes("msvc2019"))
            return "HostPrefix=../../msvc2019_64";

        else if (prefix.includes("msvc2022"))
            return "HostPrefix=../../msvc2022_64";

        else
            return "HostPrefix=../../mingw_64";
    }
    else {
        return "HostPrefix=../../macos";
    }
}

newHostSpec_690 = function()
{
    if (installer.value("os") === "x11") {
        return "linux-g++";
    }
    else if (installer.value("os") === "mac") {
        return "macx-clang";
    }
    else {
        return "win32-g++";
    }
}

newNDKHost_690 = function()
{
    if (installer.value("os") === "x11") {
        return "linux-x86_64";
    }
    else if (installer.value("os") === "mac") {
        return "darwin-x86_64";
    }
    else {
        return "windows-x86_64";
     }
}

newHostLibExecutables_690 = function()
{
    if (installer.value("os") === "win") {
        return "./bin";
    }
    else {
        return "./libexec";
    }
}

newSetCMakePath_690 = function()
{
    if (installer.value("os") === "win") {
        return installer.toNativeSeparators(installer.value("TargetDir") + "/Tools/CMake_64/bin/cmake.exe");
    }
    else if (installer.value("os") === "mac") {
        return installer.value("TargetDir") + "/Tools/CMake/CMake.app/Contents/bin/cmake";
    }
    else {
        return installer.value("TargetDir") + "/Tools/CMake/bin/cmake";
    }
}

platformIdentification_690 = function()
{
    if (installer.value("os") === "x11") {
        return "linux";
    }
    else if (installer.value("os") === "mac") {
        return "mac";
    }
    else if (installer.value("os") === "win") {
        return "windows";
    }
    else {
        console.log("platform not identified = " + installer.value("os"));
        return
    }
}

fromWindowsToUnixFlag_690 = function(buildHostName)
{
    // We don't need to add additional execute rules in windows environment
    if (installer.value("os") === "win") {
        return false;
    }
    // Set a flag to indicate that host build is from a windows
    else if (originalHostOS_690(buildHostName) === "Windows") {
        return true;
    }
    else {
    // If OS is not windows and original build host is not windows, then we don't need to add additional execute rules
        return false;
    }
}

// Qt-configure-module functions (QTBUG-120636, QTBUG-131810)
original_QtProcessConfigureArgsCmakePath_690 = function()
{
    return "/..\\lib\\cmake\\Qt6/QtProcessConfigureArgs.cmake";
}

new_QtProcessConfigureArgsCmakePath_690 = function()
{
    return "/../lib/cmake/Qt6/QtProcessConfigureArgs.cmake";
}

original_QtWriteArgsFileCmakePath_690 = function()
{
    return "/..\\lib\\cmake\\Qt6/QtWriteArgsFile.cmake"
}

new_QtWriteArgsFileCmakePath_690 = function()
{
    return "/../lib/cmake/Qt6/QtWriteArgsFile.cmake"
}

// Below is a generic patching logic that all cross-compile targets use.
// Main benefit keeping the logic in the patcher component is that you can change the logic easily since patcher is not a generic component.

qtExecuteGenericPatching_690 = function(buildHostName, target_arch, TARGET_INSTALL_DIR, componentName, qnxToolChainFile)
{
    console.log("Starting patching for " + componentName);

    // Specify component that the patching is done for
    var patchComponent = installer.componentByName(componentName);

    // Host specific installation path
    var pathToQt = getNativePath_690(TARGET_INSTALL_DIR);

    // patch qmake(.bat)
    patchComponent.addOperation("Replace", pathToQt + qmakeScript_690(), originalQmakePath_690(buildHostName), newQmakePath_690(buildHostName));

    // patch qt-cmake(.bat)
    patchComponent.addOperation("Replace", pathToQt + qtCMakeScript_690(), originalSetCmakePath_690(buildHostName), newSetCMakePath_690(), "regex");

    // Patch build time CMAke paths from qt-cmake-private(.bat) script
    patchComponent.addOperation("Replace", pathToQt + qtCMakePrivateScript_690(), originalSetCmakePath_690(buildHostName), newSetCMakePath_690(), "regex");

    // Patch qt-configure-module
    // The qt-configure module needs to patched do to these bugs QTBUG-120636, QTBUG-131810.
    if (installer.value("os") === "x11" && componentName.includes("android")) {
        patchComponent.addOperation("Replace", pathToQt + qtConfigureModuleScript_690(), original_QtProcessConfigureArgsCmakePath_690(), new_QtProcessConfigureArgsCmakePath_690());

        patchComponent.addOperation("Replace", pathToQt + qtConfigureModuleScript_690(), original_QtWriteArgsFileCmakePath_690(), new_QtWriteArgsFileCmakePath_690());
    }

    // If we are using executables from windows in unix environment we need to add
    // execute rights for those; windows doesn't set it automatically at creating phase.

    if (fromWindowsToUnixFlag_690(buildHostName) == true) {
        console.log("Setting execute rights for needed files.");

        patchComponent.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qmakeScript_690());
        patchComponent.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtCMakeScript_690());
        patchComponent.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtPathsScript_690());
        patchComponent.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtCMakePrivateScript_690());
        patchComponent.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtCMakeStandaloneTestScript_690());
        patchComponent.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtConfigureModuleScript_690());

        // scripts with '6' are available only from Qt 6.4.0 ->
        if ("690" == "dev" || 69 >= 64) {
            patchComponent.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qmake6Script_690());
            patchComponent.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtPaths6Script_690());
            }
    }

    // Patch Host Prefix, Host Data and Host Spec paths from target_qt.conf
    patchComponent.addOperation("Replace", pathToQt + targetQtConf_690(), originalHostPrefix_690(), newHostPrefix_690(buildHostName));

    patchComponent.addOperation("Replace", pathToQt + targetQtConf_690(), originalHostData_690(), newHostData_690(target_arch, componentName));

    patchComponent.addOperation("Replace", pathToQt + targetQtConf_690(), originalHostSpec_690(buildHostName), newHostSpec_690());

    // Patch HostLibraryExecutables from target_qt.conf
    patchComponent.addOperation("LineReplace", pathToQt + targetQtConf_690(), "HostLibraryExecutables=", "HostLibraryExecutables=" + newHostLibExecutables_690());

    // Append target_qt.conf with relative paths to documentation and examples
    patchComponent.addOperation("AppendFile", pathToQt + targetQtConf_690(), targetQtConfDocumentation_690());

    // Add a new line to targetQtConf which AppendFile operation doesn't add automatically
    if (installer.value("os") == "win") {
        // \r\n = CR + LF used as a new line character in Windows
        patchComponent.addOperation("AppendFile", pathToQt + targetQtConf_690(), "\r\n");
    }
    else {
        // \n = LF (Line Feed) used as a new line character in Unix/macOS
        patchComponent.addOperation("AppendFile", pathToQt + targetQtConf_690(), "\n");
    }
    patchComponent.addOperation("AppendFile", pathToQt + targetQtConf_690(), targetQtConfExamples_690());

    // Patch Qt install path from qt.toolchain.cmake
    patchComponent.addOperation("Replace", pathToQt + qtToolchainCmake_690(), originalQtHostPath_690(buildHostName), newQtHostPath_690(buildHostName));

    // Patch Qt install paths from QtBuildInternalsExtra.cmake
    patchComponent.addOperation("Replace", pathToQt + qtBuildInternalsExtraCmake_690(), originalBIPrefix_690(buildHostName), installer.value("TargetDir"));

    // Patch Qt install paths from QtBuildInternalsExtra.cmake
    patchComponent.addOperation("Replace", pathToQt + qtBuildInternalsExtraCmake_690(), originalHostTargetPath_690(buildHostName), getNativePath_690(TARGET_INSTALL_DIR, buildHostName));

    // Patch Qt install path from qtpaths(.bat)
    patchComponent.addOperation("Replace", pathToQt + qtPathsScript_690(), originalQtPathsPath_690(buildHostName), newQtPathsPath_690(buildHostName));

    if ("690" == "dev" || 69 >= 64) {

        // Patch Qt install path from Qt6Dependencies.cmake if file exist; it isn't available before Qt 6.4.0
        patchComponent.addOperation("Replace", pathToQt + qt6DependenciesCMakePath_690(), originalQtHostPath_690(buildHostName), newQtHostPath_690(buildHostName));

        // patch qmake6(.bat) if file exist; it isn't available before Qt 6.4.0
        patchComponent.addOperation("Replace", pathToQt + qmake6Script_690(), originalQmakePath_690(buildHostName), newQmakePath_690(buildHostName));

        // Patch Qt install path from qtpaths6(.bat) if file exist; it isn't available before Qt 6.4.0
        patchComponent.addOperation("Replace", pathToQt + qtPaths6Script_690(), originalQtPathsPath_690(buildHostName), newQtPathsPath_690(buildHostName));
    }

    // QNX specific patching
    if (buildHostName.includes("QNX")) {

            //Patch Sysroot from target_qt.conf
            patchComponent.addOperation("Replace", pathToQt + targetQtConf_690(), originalSysroot_690(), newSysroot_690(), "regex");

            // Patch Qt install path from qt.toolchain.cmake
            patchComponent.addOperation("Replace", pathToQt + qtToolchainCmake_690(), originalInitialToolchain_690(qnxToolChainFile), pathToQt.replace(/\\/g, "/") + newInitialToolchain_690(qnxToolChainFile));
    }

    // Patch default ndk host from qdevice.pri
    patchComponent.addOperation("LineReplace", pathToQt + qdeviceFile_690(), "DEFAULT_ANDROID_NDK_HOST =", "DEFAULT_ANDROID_NDK_HOST = " + newNDKHost_690());

    if (installer.value("SDKToolBinary") == "")
        return;

     // patch qconfig.pri
    // is this OpenSource installation?
    var isOpenSource = "true";
    if (['true', 'yes', '1'].indexOf(isOpenSource) >= 0) {
        patchComponent.addOperation("LineReplace", pathToQt + qconfigFile_690(), "QT_EDITION =", "QT_EDITION = OpenSource");
    }
}

qtExecuteWasmThreadingPatching_690 = function(componentName, displayString, TARGET_INSTALL_DIR)
{
    // Host specific installation path
    var pathToQt = getNativePath_690(TARGET_INSTALL_DIR);

    // Specify component that the patching is done for
    var patchComponent = installer.componentByName(componentName);

    // add Qt into QtCreator
    patchComponent.addOperation("Execute",
                           ["@SDKToolBinary@", "addQt",
                            "--id", componentName,
                            "--name", "Qt %{Qt:Version} WebAssembly (" + displayString + ")",
                            "--type", "Qt4ProjectManager.QtVersion.WebAssembly",
                            "--qmake", pathToQt + qmakeScript_690(),
                            "UNDOEXECUTE", "{0,2}",
                            "@SDKToolBinary@", "rmQt", "--id", componentName]);

    var kitName = componentName + "_kit";
    patchComponent.addOperation("Execute",
                           ["@SDKToolBinary@", "addKit",
                            "--id", kitName,
                            "--name", "WebAssembly Qt %{Qt:Version} (" + displayString + ")",
                            "--Ctoolchain", "asmjs-unknown-unknown-emscripten-32bit",
                            "--Cxxtoolchain", "asmjs-unknown-unknown-emscripten-32bit",
                            "--qt", componentName,
                            "--devicetype", "WebAssemblyDeviceType",
                            "UNDOEXECUTE", "{0,2}",
                            "@SDKToolBinary@", "rmKit", "--id", kitName]);

    // enable WebAssembly Qt Creator plugin
    var settingsFile = installer.value("QtCreatorInstallerSettingsFile");
    patchComponent.addOperation("Settings", "path="+settingsFile, "method=add_array_value", "key=Plugins/ForceEnabled", "value=WebAssembly");

    // create qt.conf file
    createQtConfFiles(patchComponent, installer.value("TargetDir") + TARGET_INSTALL_DIR, "Qt-6.9.0");
}

qtExecuteAndroidPatching_690 = function(componentName, displayString, TARGET_INSTALL_DIR)
{
    // Host specific installation path
    var pathToQt = getNativePath_690(TARGET_INSTALL_DIR);

    // Specify component that the patching is done for
    var patchComponent = installer.componentByName(componentName);

    // add Qt into QtCreator
    patchComponent.addOperation("Execute",
                           ["@SDKToolBinary@", "addQt",
                            "--id", componentName,
                            "--name", "Qt %{Qt:Version} for Android " + displayString,
                            "--type", "Qt4ProjectManager.QtVersion.Android",
                            "--qmake", pathToQt + qmakeScript_690(),
                            "UNDOEXECUTE",
                            "@SDKToolBinary@", "rmQt", "--id", componentName]);

    // create qt.conf file
    createQtConfFiles(patchComponent, installer.value("TargetDir") + TARGET_INSTALL_DIR, "Qt-6.9.0");
}

qtExecuteIosPatching_690 = function(componentName, TARGET_INSTALL_DIR)
{
    // Host specific installation path
    var pathToQt = getNativePath_690(TARGET_INSTALL_DIR);

    // Specify component that the patching is done for
    var patchComponent = installer.componentByName(componentName);

    // add Qt into QtCreator
    patchComponent.addOperation("Execute",
                           ["@SDKToolBinary@", "addQt",
                            "--id", componentName,
                            "--name", "Qt %{Qt:Version} for iOS",
                            "--type", "Qt4ProjectManager.QtVersion.Ios",
                            "--qmake", pathToQt + qmakeScript_690(),
                            "UNDOEXECUTE",
                            "@SDKToolBinary@", "rmQt", "--id", componentName]);

    // create qt.conf file
    createQtConfFiles(patchComponent, installer.value("TargetDir") + TARGET_INSTALL_DIR, "Qt-6.9.0");
}

qtExecuteQnxPatching_690 = function(componentName, TARGET_INSTALL_DIR, displayString, qnxAbi, qnxTargetArch, qnxMkspecs)
{
    // Host specific installation path
    var pathToQt = getNativePath_690(TARGET_INSTALL_DIR);

    // Specify component that the patching is done for
    var patchComponent = installer.componentByName(componentName);

    // add Qt into QtCreator
    patchComponent.addOperation("Execute",
                           ["@SDKToolBinary@", "addQt",
                            "--id", componentName,
                            "--name", "Qt %{Qt:Version} for QNX 7.1 " + displayString,
                            "--type", "Qt4ProjectManager.QtVersion.QNX.QNX",
                            "--qmake", pathToQt + qmakeScript_690(),
                            "--abis", qnxAbi,
                            "SDKPath", "QString:" + installer.toNativeSeparators(sdpDirectoryPath_690()),
                            "UNDOEXECUTE", "{0,2}",
                            "@SDKToolBinary@", "rmQt", "--id", componentName]);

    // add Kit to QtCreator
    patchComponent.addOperation("Execute",
                           ["@SDKToolBinary@", "addKit",
                            "--id", componentName + ".kit",
                            "--name", "Qt %{Qt:Version} for QNX 7.1 " + displayString,
                            "--debuggerid", "opt_qnx710_debugger_" + qnxTargetArch,
                            "--devicetype", "QnxOsType",
                            "--sysroot", installer.toNativeSeparators(sdpDirectoryPath_690() + "/target/qnx7"),
                            "--Ctoolchain", "Qnx.QccToolChain:opt_qnx710_qcc_" + qnxTargetArch,
                            "--Cxxtoolchain", "Qnx.QccToolChain:opt_qnx710_qcc_" + qnxTargetArch + ".g++",
                            "--qt", componentName,
                            "--mkspec", qnxMkspecs,
                            "UNDOEXECUTE", "{0,2}",
                            "@SDKToolBinary@", "rmKit", "--id", componentName + ".kit"]);

}

qtExecuteMsvcPatching_690 = function(componentName, TARGET_INSTALL_DIR)
{
    // Host specific installation path
    var pathToQt = getNativePath_690(TARGET_INSTALL_DIR);

    // Specify component that the patching is done for
    var patchComponent = installer.componentByName(componentName);

    // add Qt into QtCreator
        patchComponent.addOperation("Execute",
                               ["@SDKToolBinary@", "addQt",
                                "--id", componentName,
                                "--name", "Qt %{Qt:Version} MSVC2019 ARM64",
                                "--type", "Qt4ProjectManager.QtVersion.Desktop",
                                "--qmake", pathToQt + qmakeScript_690(),
                                "UNDOEXECUTE", "{0,2}",
                                "@SDKToolBinary@", "rmQt", "--id", componentName]);

        var kitName = componentName + "_kit";
        patchComponent.addOperation("Execute",
                               ["@SDKToolBinary@", "addKit",
                                "--id", kitName,
                                "--name", "Desktop Qt %{Qt:Version} MSVC2019 ARM64",
                                "--Ctoolchain", "arm-windows-msvc2019-pe-64bit",
                                "--Cxxtoolchain", "arm-windows-msvc2019-pe-64bit",
                                "--qt", componentName,
                                "--debuggerengine", "4",
                                "--devicetype", "Desktop",
                                "UNDOEXECUTE", "{0,2}",
                                "@SDKToolBinary@", "rmKit", "--id", kitName]);

    // create qt.conf file
    createQtConfFiles(patchComponent, installer.value("TargetDir") + TARGET_INSTALL_DIR, "Qt-6.9.0");
}

qtExecuteMsvc2022Patching_690 = function(componentName, TARGET_INSTALL_DIR)
{
    // Host specific installation path
    var pathToQt = getNativePath_690(TARGET_INSTALL_DIR);

    // Specify component that the patching is done for
    var patchComponent = installer.componentByName(componentName);

        // add Qt into QtCreator
        patchComponent.addOperation("Execute",
                               ["@SDKToolBinary@", "addQt",
                                "--id", componentName,
                                "--name", "Qt %{Qt:Version} MSVC2022 ARM64",
                                "--type", "Qt4ProjectManager.QtVersion.Desktop",
                                "--qmake", pathToQt + qmakeScript_690(),
                                "UNDOEXECUTE", "{0,2}",
                                "@SDKToolBinary@", "rmQt", "--id", componentName]);

        var kitName = componentName + "_kit";
        patchComponent.addOperation("Execute",
                               ["@SDKToolBinary@", "addKit",
                                "--id", kitName,
                                "--name", "Desktop Qt %{Qt:Version} MSVC2022 ARM64",
                                "--Ctoolchain", "arm-windows-msvc2022-pe-64bit",
                                "--Cxxtoolchain", "arm-windows-msvc2022-pe-64bit",
                                "--qt", componentName,
                                "--debuggerengine", "4",
                                "--devicetype", "Desktop",
                                "UNDOEXECUTE", "{0,2}",
                                "@SDKToolBinary@", "rmKit", "--id", kitName]);

    // create qt.conf file
    createQtConfFiles(patchComponent, installer.value("TargetDir") + TARGET_INSTALL_DIR, "Qt-6.9.0");
}

qtExecuteWasm32Patching_690 = function(componentName, TARGET_INSTALL_DIR)
{
    // Host specific installation path
    var pathToQt = getNativePath_690(TARGET_INSTALL_DIR);

    // Specify component that the patching is done for
    var patchComponent = installer.componentByName(componentName);

    // add Qt into QtCreator
    patchComponent.addOperation("Execute",
                           ["@SDKToolBinary@", "addQt",
                            "--id", componentName,
                            "--name", "Qt %{Qt:Version} WebAssembly",
                            "--type", "Qt4ProjectManager.QtVersion.WebAssembly",
                            "--qmake", pathToQt + qmakeScript_690(),
                            "UNDOEXECUTE", "{0,2}",
                            "@SDKToolBinary@", "rmQt", "--id", componentName]);

    var kitName = componentName + "_kit";
    patchComponent.addOperation("Execute",
                           ["@SDKToolBinary@", "addKit",
                            "--id", kitName,
                            "--name", "WebAssembly Qt %{Qt:Version}",
                            "--Ctoolchain", "asmjs-unknown-unknown-emscripten-32bit",
                            "--Cxxtoolchain", "asmjs-unknown-unknown-emscripten-32bit",
                            "--qt", componentName,
                            "--devicetype", "WebAssemblyDeviceType",
                            "UNDOEXECUTE", "{0,2}",
                            "@SDKToolBinary@", "rmKit", "--id", kitName]);

    // enable WebAssembly Qt Creator plugin
    var settingsFile = installer.value("QtCreatorInstallerSettingsFile");
    patchComponent.addOperation("Settings", "path="+settingsFile, "method=add_array_value", "key=Plugins/ForceEnabled", "value=WebAssembly");

    // create qt.conf file
    createQtConfFiles(patchComponent, installer.value("TargetDir") + TARGET_INSTALL_DIR, "Qt-6.9.0");
}
