/****************************************************************************
**
** Copyright (C) 2024 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the release tools of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// constructor
function Component()
{
    // Install Android target(s) when Android node is selected for installation
    component.addAutoDependOn("qt.qt6.693.android");

    // For release builds set the dependency directly to the host binary
    var hostDependencyStr = "";

    // Linux desktop component naming was changed in Qt 6.7.0 from gcc_64 to linux_gcc_64
    if (installer.componentByName("qt.qt6.693.gcc_64")) {
        hostDependencyStr = "qt.qt6.693.gcc_64"
    }
    else if (installer.componentByName("qt.qt6.693.linux_gcc_64")) {
        hostDependencyStr = "qt.qt6.693.linux_gcc_64"
    }
    // Linux on ARM supported from Qt 6.7 onward
    else if (installer.componentByName("qt.qt6.693.linux_gcc_arm64")) {
        hostDependencyStr = "qt.qt6.693.linux_gcc_arm64"
    }
    // Windows on ARM is supported from 6.7 onwards
    else if (installer.componentByName("qt.qt6.693.win64_msvc2022_arm64")) {
        hostDependencyStr = "qt.qt6.693.win64_msvc2022_arm64"
    }
    else if (installer.componentByName("qt.qt6.693.win64_mingw")) {
        // Add dynamic dependency for mingw TC for Android packages on Windows.
        component.addDependency("qt.tools.win64_mingw1310")
        hostDependencyStr = "qt.qt6.693.win64_mingw";
    }
    else if (installer.componentByName("qt.qt6.693.clang_64")) {
        hostDependencyStr = "qt.qt6.693.clang_64"
    }
    else {
        console.log("Warning: no host dependencies added");
    }
    component.addDependency(hostDependencyStr);
}

Component.prototype.createOperations = function()
{
    component.createOperations();

    qtExecuteGenericPatching_693("Windows-Windows_10_22H2-Clang-Android-Android_ANY-ARMv7", "armv7", "/6.9.3/android_armv7", component.value("Name"));

    qtExecuteAndroidPatching_693(component.value("Name"), "ARMv7", "/6.9.3/android_armv7");
}

