// Copyright (C) 2023 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0

import QtQuick

QtObject {
    readonly property int width: 1920
    readonly property int height: 1080

    property FontLoader controlIcons: FontLoader {
        source: "icons.ttf"
    }

    objectName: "internalConstantsObject"

    readonly property string actionIcon: "\u0021"
    readonly property string actionIconBinding: "\u0022"
    readonly property string addColumnAfter: "\u0023"
    readonly property string addColumnBefore: "\u0024"
    readonly property string addFile: "\u0025"
    readonly property string addRowAfter: "\u0026"
    readonly property string addRowBefore: "\u0027"
    readonly property string addTable: "\u0028"
    readonly property string add_medium: "\u0029"
    readonly property string add_small: "\u002A"
    readonly property string adsClose: "\u002B"
    readonly property string adsDetach: "\u002C"
    readonly property string adsDropDown: "\u002D"
    readonly property string alias: "\u002E"
    readonly property string aliasAnimated: "\u002F"
    readonly property string alignBottom: "\u0030"
    readonly property string alignCenterHorizontal: "\u0031"
    readonly property string alignCenterVertical: "\u0032"
    readonly property string alignLeft: "\u0033"
    readonly property string alignRight: "\u0034"
    readonly property string alignTo: "\u0035"
    readonly property string alignToCam_medium: "\u0036"
    readonly property string alignToCamera_small: "\u0037"
    readonly property string alignToObject_small: "\u0038"
    readonly property string alignToView_medium: "\u0039"
    readonly property string alignTop: "\u003A"
    readonly property string anchorBaseline: "\u003B"
    readonly property string anchorBottom: "\u003C"
    readonly property string anchorFill: "\u003D"
    readonly property string anchorLeft: "\u003E"
    readonly property string anchorRight: "\u003F"
    readonly property string anchorTop: "\u0040"
    readonly property string anchors_small: "\u0041"
    readonly property string animatedProperty: "\u0042"
    readonly property string annotationBubble: "\u0043"
    readonly property string annotationDecal: "\u0044"
    readonly property string annotations_large: "\u0045"
    readonly property string annotations_small: "\u0046"
    readonly property string applyMaterialToSelected: "\u0047"
    readonly property string apply_medium: "\u0048"
    readonly property string apply_small: "\u0049"
    readonly property string arrange_small: "\u004A"
    readonly property string arrow_small: "\u004B"
    readonly property string assign: "\u004C"
    readonly property string attach_medium: "\u004D"
    readonly property string back_medium: "\u004E"
    readonly property string backspace_small: "\u004F"
    readonly property string bevelAll: "\u0050"
    readonly property string bevelCorner: "\u0051"
    readonly property string bezier_medium: "\u0052"
    readonly property string binding_medium: "\u0053"
    readonly property string bounds_small: "\u0054"
    readonly property string branch_medium: "\u0055"
    readonly property string camera_small: "\u0056"
    readonly property string centerHorizontal: "\u0057"
    readonly property string centerVertical: "\u0058"
    readonly property string cleanLogs_medium: "\u0059"
    readonly property string closeCross: "\u005A"
    readonly property string closeFile_large: "\u005B"
    readonly property string closeLink: "\u005C"
    readonly property string close_small: "\u005D"
    readonly property string colorPopupClose: "\u005E"
    readonly property string colorSelection_medium: "\u005F"
    readonly property string columnsAndRows: "\u0060"
    readonly property string cone_medium: "\u0061"
    readonly property string cone_small: "\u0062"
    readonly property string connection_small: "\u0063"
    readonly property string connections_medium: "\u0064"
    readonly property string copyLink: "\u0065"
    readonly property string copyStyle: "\u0066"
    readonly property string copy_small: "\u0067"
    readonly property string cornerA: "\u0068"
    readonly property string cornerB: "\u0069"
    readonly property string cornersAll: "\u006A"
    readonly property string createComponent_large: "\u006B"
    readonly property string createComponent_small: "\u006C"
    readonly property string create_medium: "\u006D"
    readonly property string create_small: "\u006E"
    readonly property string cube_medium: "\u006F"
    readonly property string cube_small: "\u0070"
    readonly property string curveDesigner: "\u0071"
    readonly property string curveDesigner_medium: "\u0072"
    readonly property string curveEditor: "\u0073"
    readonly property string customMaterialEditor: "\u0074"
    readonly property string cylinder_medium: "\u0075"
    readonly property string cylinder_small: "\u0076"
    readonly property string decisionNode: "\u0077"
    readonly property string deleteColumn: "\u0078"
    readonly property string deleteMaterial: "\u0079"
    readonly property string deleteRow: "\u007A"
    readonly property string deleteTable: "\u007B"
    readonly property string delete_medium: "\u007C"
    readonly property string delete_small: "\u007D"
    readonly property string designMode_large: "\u007E"
    readonly property string detach: "\u007F"
    readonly property string directionalLight_small: "\u0080"
    readonly property string distributeBottom: "\u0081"
    readonly property string distributeCenterHorizontal: "\u0082"
    readonly property string distributeCenterVertical: "\u0083"
    readonly property string distributeLeft: "\u0084"
    readonly property string distributeOriginBottomRight: "\u0085"
    readonly property string distributeOriginCenter: "\u0086"
    readonly property string distributeOriginNone: "\u0087"
    readonly property string distributeOriginTopLeft: "\u0088"
    readonly property string distributeRight: "\u0089"
    readonly property string distributeSpacingHorizontal: "\u008A"
    readonly property string distributeSpacingVertical: "\u008B"
    readonly property string distributeTop: "\u008C"
    readonly property string download: "\u008D"
    readonly property string downloadUnavailable: "\u008E"
    readonly property string downloadUpdate: "\u008F"
    readonly property string downloaded: "\u0090"
    readonly property string duplicate_small: "\u0091"
    readonly property string edit: "\u0092"
    readonly property string editComponent_large: "\u0093"
    readonly property string editComponent_small: "\u0094"
    readonly property string editLightOff_medium: "\u0095"
    readonly property string editLightOn_medium: "\u0096"
    readonly property string edit_medium: "\u0097"
    readonly property string edit_small: "\u0098"
    readonly property string events_small: "\u0099"
    readonly property string export_medium: "\u009A"
    readonly property string eyeDropper: "\u009B"
    readonly property string favorite: "\u009D"
    readonly property string fitAll_medium: "\u009E"
    readonly property string fitSelected_small: "\u009F"
    readonly property string fitSelection_medium: "\u00A0"
    readonly property string fitToView_medium: "\u00A1"
    readonly property string flowAction: "\u00A2"
    readonly property string flowTransition: "\u00A3"
    readonly property string fontStyleBold: "\u00A4"
    readonly property string fontStyleItalic: "\u00A5"
    readonly property string fontStyleStrikethrough: "\u00A6"
    readonly property string fontStyleUnderline: "\u00A7"
    readonly property string forward_medium: "\u00A8"
    readonly property string globalOrient_medium: "\u00A9"
    readonly property string gradient: "\u00AA"
    readonly property string gridView: "\u00AB"
    readonly property string grid_medium: "\u00AC"
    readonly property string group_small: "\u00AE"
    readonly property string home_large: "\u00AF"
    readonly property string idAliasOff: "\u00B0"
    readonly property string idAliasOn: "\u00B1"
    readonly property string import_medium: "\u00B2"
    readonly property string imported: "\u00B3"
    readonly property string importedModels_small: "\u00B4"
    readonly property string infinity: "\u00B5"
    readonly property string invisible_medium: "\u00B6"
    readonly property string keyframe: "\u00B7"
    readonly property string languageList_medium: "\u00B8"
    readonly property string layouts_small: "\u00B9"
    readonly property string lights_small: "\u00BA"
    readonly property string linear_medium: "\u00BB"
    readonly property string linkTriangle: "\u00BC"
    readonly property string linked: "\u00BD"
    readonly property string listView: "\u00BE"
    readonly property string list_medium: "\u00BF"
    readonly property string localOrient_medium: "\u00C0"
    readonly property string lockOff: "\u00C1"
    readonly property string lockOn: "\u00C2"
    readonly property string loopPlayback_medium: "\u00C3"
    readonly property string materialBrowser_medium: "\u00C4"
    readonly property string materialPreviewEnvironment: "\u00C5"
    readonly property string materialPreviewModel: "\u00C6"
    readonly property string material_medium: "\u00C7"
    readonly property string mergeCells: "\u00C8"
    readonly property string merge_small: "\u00C9"
    readonly property string minus: "\u00CA"
    readonly property string mirror: "\u00CB"
    readonly property string more_medium: "\u00CC"
    readonly property string mouseArea_small: "\u00CD"
    readonly property string moveDown_medium: "\u00CE"
    readonly property string moveInwards_medium: "\u00CF"
    readonly property string moveUp_medium: "\u00D0"
    readonly property string moveUpwards_medium: "\u00D1"
    readonly property string move_medium: "\u00D2"
    readonly property string newMaterial: "\u00D3"
    readonly property string nextFile_large: "\u00D4"
    readonly property string openLink: "\u00D5"
    readonly property string openMaterialBrowser: "\u00D6"
    readonly property string orientation: "\u00D7"
    readonly property string orthCam_medium: "\u00D8"
    readonly property string orthCam_small: "\u00D9"
    readonly property string paddingEdge: "\u00DA"
    readonly property string paddingFrame: "\u00DB"
    readonly property string particleAnimation_medium: "\u00DC"
    readonly property string pasteStyle: "\u00DD"
    readonly property string paste_small: "\u00DE"
    readonly property string pause: "\u00DF"
    readonly property string perspectiveCam_medium: "\u00E0"
    readonly property string perspectiveCam_small: "\u00E1"
    readonly property string pin: "\u00E2"
    readonly property string plane_medium: "\u00E3"
    readonly property string plane_small: "\u00E4"
    readonly property string play: "\u00E5"
    readonly property string playFill_medium: "\u00E6"
    readonly property string playOutline_medium: "\u00E7"
    readonly property string plus: "\u00E8"
    readonly property string pointLight_small: "\u00E9"
    readonly property string positioners_small: "\u00EA"
    readonly property string previewEnv_medium: "\u00EB"
    readonly property string previousFile_large: "\u00EC"
    readonly property string promote: "\u00ED"
    readonly property string properties_medium: "\u00EE"
    readonly property string readOnly: "\u00EF"
    readonly property string recordFill_medium: "\u00F0"
    readonly property string recordOutline_medium: "\u00F1"
    readonly property string redo: "\u00F2"
    readonly property string reload_medium: "\u00F3"
    readonly property string remove_medium: "\u00F4"
    readonly property string remove_small: "\u00F5"
    readonly property string rename_small: "\u00F6"
    readonly property string replace_small: "\u00F7"
    readonly property string resetView_small: "\u00F8"
    readonly property string restartParticles_medium: "\u00F9"
    readonly property string reverseOrder_medium: "\u00FA"
    readonly property string roatate_medium: "\u00FB"
    readonly property string rotationFill: "\u00FC"
    readonly property string rotationOutline: "\u00FD"
    readonly property string runProjFill_large: "\u00FE"
    readonly property string runProjOutline_large: "\u00FF"
    readonly property string s_anchors: "\u0100"
    readonly property string s_annotations: "\u0101"
    readonly property string s_arrange: "\u0102"
    readonly property string s_boundingBox: "\u0103"
    readonly property string s_component: "\u0104"
    readonly property string s_connections: "\u0105"
    readonly property string s_edit: "\u0106"
    readonly property string s_enterComponent: "\u0107"
    readonly property string s_eventList: "\u0108"
    readonly property string s_group: "\u0109"
    readonly property string s_layouts: "\u010A"
    readonly property string s_merging: "\u010B"
    readonly property string s_mouseArea: "\u010C"
    readonly property string s_positioners: "\u010D"
    readonly property string s_selection: "\u010E"
    readonly property string s_snapping: "\u010F"
    readonly property string s_timeline: "\u0110"
    readonly property string s_visibility: "\u0111"
    readonly property string saveLogs_medium: "\u0112"
    readonly property string scale_medium: "\u0113"
    readonly property string search: "\u0114"
    readonly property string search_small: "\u0115"
    readonly property string sectionToggle: "\u0116"
    readonly property string selectFill_medium: "\u0117"
    readonly property string selectOutline_medium: "\u0118"
    readonly property string selectParent_small: "\u0119"
    readonly property string selection_small: "\u011A"
    readonly property string settings_medium: "\u011B"
    readonly property string signal_small: "\u011C"
    readonly property string snapping_small: "\u011D"
    readonly property string sphere_medium: "\u011E"
    readonly property string sphere_small: "\u011F"
    readonly property string splitColumns: "\u0120"
    readonly property string splitRows: "\u0121"
    readonly property string spotLight_small: "\u0122"
    readonly property string stackedContainer_small: "\u0123"
    readonly property string startNode: "\u0124"
    readonly property string step_medium: "\u0125"
    readonly property string stop_medium: "\u0126"
    readonly property string testIcon: "\u0127"
    readonly property string textAlignBottom: "\u0128"
    readonly property string textAlignCenter: "\u0129"
    readonly property string textAlignJustified: "\u012A"
    readonly property string textAlignLeft: "\u012B"
    readonly property string textAlignMiddle: "\u012C"
    readonly property string textAlignRight: "\u012D"
    readonly property string textAlignTop: "\u012E"
    readonly property string textBulletList: "\u012F"
    readonly property string textFullJustification: "\u0130"
    readonly property string textNumberedList: "\u0131"
    readonly property string textures_medium: "\u0132"
    readonly property string tickIcon: "\u0133"
    readonly property string tickMark_small: "\u0134"
    readonly property string timeline_small: "\u0135"
    readonly property string toEndFrame_medium: "\u0136"
    readonly property string toNextFrame_medium: "\u0137"
    readonly property string toPrevFrame_medium: "\u0138"
    readonly property string toStartFrame_medium: "\u0139"
    readonly property string topToolbar_annotations: "\u013A"
    readonly property string topToolbar_closeFile: "\u013B"
    readonly property string topToolbar_designMode: "\u013C"
    readonly property string topToolbar_enterComponent: "\u013D"
    readonly property string topToolbar_home: "\u013E"
    readonly property string topToolbar_makeComponent: "\u013F"
    readonly property string topToolbar_navFile: "\u0140"
    readonly property string topToolbar_runProject: "\u0141"
    readonly property string translationCreateFiles: "\u0142"
    readonly property string translationCreateReport: "\u0143"
    readonly property string translationExport: "\u0144"
    readonly property string translationImport: "\u0145"
    readonly property string translationSelectLanguages: "\u0146"
    readonly property string translationTest: "\u0147"
    readonly property string transparent: "\u0148"
    readonly property string triState: "\u0149"
    readonly property string triangleArcA: "\u014A"
    readonly property string triangleArcB: "\u014B"
    readonly property string triangleCornerA: "\u014C"
    readonly property string triangleCornerB: "\u014D"
    readonly property string unLinked: "\u014E"
    readonly property string undo: "\u014F"
    readonly property string unify_medium: "\u0150"
    readonly property string unpin: "\u0151"
    readonly property string upDownIcon: "\u0152"
    readonly property string upDownSquare2: "\u0153"
    readonly property string visibilityOff: "\u0154"
    readonly property string visibilityOn: "\u0155"
    readonly property string visible_medium: "\u0156"
    readonly property string visible_small: "\u0157"
    readonly property string wildcard: "\u0158"
    readonly property string wizardsAutomotive: "\u0159"
    readonly property string wizardsDesktop: "\u015A"
    readonly property string wizardsGeneric: "\u015B"
    readonly property string wizardsMcuEmpty: "\u015C"
    readonly property string wizardsMcuGraph: "\u015D"
    readonly property string wizardsMobile: "\u015E"
    readonly property string wizardsUnknown: "\u015F"
    readonly property string zoomAll: "\u0160"
    readonly property string zoomIn: "\u0161"
    readonly property string zoomIn_medium: "\u0162"
    readonly property string zoomOut: "\u0163"
    readonly property string zoomOut_medium: "\u0164"
    readonly property string zoomSelection: "\u0165"

    readonly property font iconFont: Qt.font({
                                                 "family": controlIcons.name,
                                                 "pixelSize": 12
                                             })

    readonly property font font: Qt.font({
                                             "family": "Arial",
                                             "pointSize": Qt.application.font.pixelSize
                                         })

    readonly property font largeFont: Qt.font({
                                                  "family": "Arial",
                                                  "pointSize": Qt.application.font.pixelSize * 1.6
                                              })
}
