/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.text.method.MetaKeyKeyListener;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import org.qtproject.qt5.android.QtEditText;
import org.qtproject.qt5.android.QtLayout;
import org.qtproject.qt5.android.QtNative;
import org.qtproject.qt5.android.QtNativeLibrariesDir;
import org.qtproject.qt5.android.QtSurface;

public class QtActivityDelegate {
    private Activity m_activity = null;
    private Method m_super_dispatchKeyEvent = null;
    private Method m_super_onRestoreInstanceState = null;
    private Method m_super_onRetainNonConfigurationInstance = null;
    private Method m_super_onSaveInstanceState = null;
    private Method m_super_onKeyDown = null;
    private Method m_super_onKeyUp = null;
    private Method m_super_onConfigurationChanged = null;
    private static final String NATIVE_LIBRARIES_KEY = "native.libraries";
    private static final String BUNDLED_LIBRARIES_KEY = "bundled.libraries";
    private static final String MAIN_LIBRARY_KEY = "main.library";
    private static final String ENVIRONMENT_VARIABLES_KEY = "environment.variables";
    private static final String APPLICATION_PARAMETERS_KEY = "application.parameters";
    private static final String STATIC_INIT_CLASSES_KEY = "static.init.classes";
    private static final String NECESSITAS_API_LEVEL_KEY = "necessitas.api.level";
    private static String m_environmentVariables = null;
    private static String m_applicationParameters = null;
    private int m_currentOrientation = 0;
    private String m_mainLib;
    private long m_metaState;
    private int m_lastChar = 0;
    private boolean m_fullScreen = false;
    private boolean m_started = false;
    private QtSurface m_surface = null;
    private QtLayout m_layout = null;
    private QtEditText m_editText = null;
    private InputMethodManager m_imm = null;
    private boolean m_quitApp = true;
    private Process m_debuggerProcess = null;
    public boolean m_keyboardIsVisible = false;
    public boolean m_keyboardIsHiding = false;
    private final int ImhNoAutoUppercase = 2;
    private final int ImhPreferUppercase = 8;
    private final int ImhPreferLowercase = 16;
    private final int ImhUppercaseOnly = 262144;
    private final int ImhLowercaseOnly = 524288;
    private final int ImhNoPredictiveText = 32;
    private final int ImhHiddenText = 1;
    private final int ImhPreferNumbers = 4;
    private final int ImhMultiLine = 1024;
    private final int ImhDigitsOnly = 65536;
    private final int ImhFormattedNumbersOnly = 131072;
    private final int ImhDialableCharactersOnly = 0x100000;
    private final int ImhEmailCharactersOnly = 0x200000;
    private final int ImhUrlCharactersOnly = 0x400000;
    private boolean m_opionsMenuIsVisible = false;
    private boolean m_contextMenuVisible = false;

    public QtLayout getQtLayout() {
        return this.m_layout;
    }

    public QtSurface getQtSurface() {
        return this.m_surface;
    }

    public void redrawWindow(int n, int n2, int n3, int n4) {
        this.m_surface.drawBitmap(new Rect(n, n2, n3, n4));
    }

    public void setFullScreen(boolean bl) {
        if (this.m_fullScreen == bl) {
            return;
        }
        this.m_fullScreen = bl;
        if (this.m_fullScreen) {
            this.m_activity.getWindow().addFlags(1024);
            this.m_activity.getWindow().clearFlags(2048);
        } else {
            this.m_activity.getWindow().addFlags(2048);
            this.m_activity.getWindow().clearFlags(1024);
        }
    }

    public void resetSoftwareKeyboard() {
        if (this.m_imm == null) {
            return;
        }
        this.m_editText.postDelayed(new Runnable(){

            @Override
            public void run() {
                QtActivityDelegate.this.m_imm.restartInput((View)QtActivityDelegate.this.m_editText);
            }
        }, 5L);
    }

    public void showSoftwareKeyboard(int n, int n2, int n3, int n4, int n5) {
        if (this.m_imm == null) {
            return;
        }
        if (n4 > this.m_surface.getHeight() * 2 / 3) {
            this.m_activity.getWindow().setSoftInputMode(17);
        } else {
            this.m_activity.getWindow().setSoftInputMode(33);
        }
        int n6 = 0;
        int n7 = 6;
        int n8 = 1;
        if ((n5 & 0x400) != 0) {
            n8 = 131073;
            n7 = 0x40000000;
        }
        if (((n5 & 2) != 0 || (n5 & 8) != 0) && (n5 & 0x80000) == 0) {
            n6 = 16384;
        }
        if ((n5 & 0x40000) != 0) {
            n6 = 4096;
        }
        if ((n5 & 1) != 0) {
            n8 = 128;
        }
        if ((n5 & 4) != 0) {
            n8 = 2;
        }
        if ((n5 & 0x10000) != 0) {
            n8 = 2;
        }
        if ((n5 & 0x20000) != 0) {
            n8 = 12290;
        }
        if ((n5 & 0x100000) != 0) {
            n8 = 3;
        }
        if ((n5 & 0x200000) != 0) {
            n8 = 32;
        }
        if ((n5 & 0x400000) != 0) {
            n8 = 16;
            n7 = 2;
        }
        if ((n5 & 0x20) != 0) {
            n8 = 145;
        }
        this.m_editText.setInitialCapsMode(n6);
        this.m_editText.setImeOptions(n7);
        this.m_editText.setInputType(n8);
        this.m_layout.removeView(this.m_editText);
        this.m_layout.addView(this.m_editText, new QtLayout.LayoutParams(n3, n4, n, n2));
        this.m_editText.bringToFront();
        this.m_editText.requestFocus();
        this.m_editText.postDelayed(new Runnable(){

            @Override
            public void run() {
                QtActivityDelegate.this.m_imm.showSoftInput((View)QtActivityDelegate.this.m_editText, 0);
                QtActivityDelegate.this.m_keyboardIsVisible = true;
                QtActivityDelegate.this.m_keyboardIsHiding = false;
                QtActivityDelegate.this.m_editText.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        QtActivityDelegate.this.m_imm.restartInput((View)QtActivityDelegate.this.m_editText);
                    }
                }, 25L);
            }
        }, 15L);
    }

    public void hideSoftwareKeyboard() {
        if (this.m_imm == null) {
            return;
        }
        this.m_imm.hideSoftInputFromWindow(this.m_editText.getWindowToken(), 0);
        this.m_keyboardIsVisible = false;
        this.m_keyboardIsHiding = false;
    }

    public boolean isSoftwareKeyboardVisible() {
        return this.m_keyboardIsVisible;
    }

    String getAppIconSize(Activity activity) {
        int n = activity.getResources().getDimensionPixelSize(0x1050000);
        if (n < 36 || n > 512) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
            n = displayMetrics.densityDpi / 10 * 3;
            if (n < 36) {
                n = 36;
            }
            if (n > 512) {
                n = 512;
            }
        }
        return "\tQT_ANDROID_APP_ICON_SIZE=" + n;
    }

    public void updateSelection(int n, int n2, int n3, int n4) {
        if (this.m_imm == null) {
            return;
        }
        this.m_imm.updateSelection((View)this.m_editText, n, n2, n3, n4);
    }

    public boolean loadApplication(Activity activity, ClassLoader classLoader, Bundle bundle) {
        if (!(bundle.containsKey(NATIVE_LIBRARIES_KEY) && bundle.containsKey(BUNDLED_LIBRARIES_KEY) && bundle.containsKey(ENVIRONMENT_VARIABLES_KEY))) {
            return false;
        }
        this.m_activity = activity;
        QtNative.setActivity(this.m_activity, this);
        QtNative.setClassLoader(classLoader);
        if (bundle.containsKey(STATIC_INIT_CLASSES_KEY)) {
            for (String string : bundle.getStringArray(STATIC_INIT_CLASSES_KEY)) {
                if (string.length() == 0) continue;
                try {
                    Class<?> clazz = classLoader.loadClass(string);
                    Object obj = clazz.newInstance();
                    Method method = clazz.getMethod("setActivity", Activity.class, Object.class);
                    method.invoke(obj, this.m_activity, this);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        QtNative.loadQtLibraries(bundle.getStringArrayList(NATIVE_LIBRARIES_KEY));
        ArrayList arrayList = bundle.getStringArrayList(BUNDLED_LIBRARIES_KEY);
        QtNative.loadBundledLibraries(arrayList, QtNativeLibrariesDir.nativeLibrariesDir(this.m_activity));
        this.m_mainLib = bundle.getString(MAIN_LIBRARY_KEY);
        if (null == this.m_mainLib && arrayList.size() > 0) {
            this.m_mainLib = (String)arrayList.get(arrayList.size() - 1);
        }
        try {
            this.m_super_dispatchKeyEvent = this.m_activity.getClass().getMethod("super_dispatchKeyEvent", KeyEvent.class);
            this.m_super_onRestoreInstanceState = this.m_activity.getClass().getMethod("super_onRestoreInstanceState", Bundle.class);
            this.m_super_onRetainNonConfigurationInstance = this.m_activity.getClass().getMethod("super_onRetainNonConfigurationInstance", new Class[0]);
            this.m_super_onSaveInstanceState = this.m_activity.getClass().getMethod("super_onSaveInstanceState", Bundle.class);
            this.m_super_onKeyDown = this.m_activity.getClass().getMethod("super_onKeyDown", Integer.TYPE, KeyEvent.class);
            this.m_super_onKeyUp = this.m_activity.getClass().getMethod("super_onKeyUp", Integer.TYPE, KeyEvent.class);
            this.m_super_onConfigurationChanged = this.m_activity.getClass().getMethod("super_onConfigurationChanged", Configuration.class);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        int n = 1;
        if (bundle.containsKey(NECESSITAS_API_LEVEL_KEY)) {
            n = bundle.getInt(NECESSITAS_API_LEVEL_KEY);
        }
        m_environmentVariables = bundle.getString(ENVIRONMENT_VARIABLES_KEY);
        String string = "QT_ANDROID_FONTS_MONOSPACE=Droid Sans Mono;Droid Sans;Droid Sans Fallback\tNECESSITAS_API_LEVEL=" + n + "\tHOME=" + this.m_activity.getFilesDir().getAbsolutePath() + "\tTMPDIR=" + this.m_activity.getFilesDir().getAbsolutePath();
        string = Build.VERSION.SDK_INT < 14 ? string + "\tQT_ANDROID_FONTS=Droid Sans;Droid Sans Fallback" : string + "\tQT_ANDROID_FONTS=Roboto;Droid Sans;Droid Sans Fallback";
        string = string + this.getAppIconSize(activity);
        m_environmentVariables = m_environmentVariables != null && m_environmentVariables.length() > 0 ? string + "\t" + m_environmentVariables : string;
        m_applicationParameters = bundle.containsKey(APPLICATION_PARAMETERS_KEY) ? bundle.getString(APPLICATION_PARAMETERS_KEY) : "";
        return true;
    }

    public void debugLog(String string) {
        Log.i((String)"Qt JAVA", (String)("DEBUGGER: " + string));
    }

    public boolean startApplication() {
        try {
            String string;
            String string2;
            String string3;
            Bundle bundle = this.m_activity.getIntent().getExtras();
            if (bundle != null && bundle.containsKey("native_debug") && bundle.getString("native_debug").equals("true")) {
                try {
                    string3 = this.m_activity.getPackageManager().getApplicationInfo((String)this.m_activity.getPackageName(), (int)16384).dataDir + "/";
                    string2 = bundle.containsKey("gdbserver_path") ? bundle.getString("gdbserver_path") : string3 + "lib/gdbserver ";
                    string = bundle.containsKey("gdbserver_socket") ? bundle.getString("gdbserver_socket") : "+debug-socket";
                    this.m_debuggerProcess = Runtime.getRuntime().exec(string2 + string + " --attach " + android.os.Process.myPid(), null, new File(string3));
                }
                catch (IOException iOException) {
                    Log.e((String)"Qt JAVA", (String)("Can't start debugger" + iOException.getMessage()));
                }
                catch (SecurityException securityException) {
                    Log.e((String)"Qt JAVA", (String)("Can't start debugger" + securityException.getMessage()));
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    Log.e((String)"Qt JAVA", (String)("Can't start debugger" + nameNotFoundException.getMessage()));
                }
            }
            if (bundle != null && bundle.containsKey("debug_ping") && bundle.getString("debug_ping").equals("true")) {
                try {
                    File file;
                    File file2;
                    this.debugLog("extra parameters: " + bundle);
                    string3 = this.m_activity.getPackageName();
                    string2 = bundle.getString("ping_file");
                    string = bundle.getString("pong_file");
                    String string4 = bundle.getString("gdbserver_socket");
                    String string5 = bundle.getString("gdbserver_command");
                    boolean bl = string2 != null;
                    boolean bl2 = string != null;
                    boolean bl3 = string4 != null;
                    int n = 200;
                    int n2 = 30000;
                    int n3 = n2 / n;
                    if (bl) {
                        this.debugLog("removing ping file " + string2);
                        file2 = new File(string2);
                        if (file2.exists() && !file2.delete()) {
                            this.debugLog("ping file cannot be deleted");
                        }
                    }
                    if (bl2) {
                        this.debugLog("removing pong file " + string);
                        file2 = new File(string);
                        if (file2.exists() && !file2.delete()) {
                            this.debugLog("pong file cannot be deleted");
                        }
                    }
                    this.debugLog("starting " + string5);
                    this.m_debuggerProcess = Runtime.getRuntime().exec(string5);
                    this.debugLog("gdbserver started");
                    if (bl3) {
                        int n4;
                        for (n4 = 0; n4 < n3; ++n4) {
                            this.debugLog("waiting for socket at " + string4 + ", attempt " + n4);
                            file = new File(string4);
                            if (file.exists()) {
                                file.setReadable(true, false);
                                file.setWritable(true, false);
                                file.setExecutable(true, false);
                                break;
                            }
                            Thread.sleep(n);
                        }
                        if (n4 == n3) {
                            this.debugLog("time out when waiting for socket");
                            return false;
                        }
                        this.debugLog("socket ok");
                    } else {
                        this.debugLog("socket not used");
                    }
                    if (bl) {
                        this.debugLog("writing ping at " + string2);
                        FileWriter fileWriter = new FileWriter(string2);
                        fileWriter.write("" + android.os.Process.myPid());
                        fileWriter.close();
                        file = new File(string2);
                        file.setReadable(true, false);
                        file.setWritable(true, false);
                        file.setExecutable(true, false);
                        this.debugLog("wrote ping");
                    } else {
                        this.debugLog("ping not requested");
                    }
                    if (bl2) {
                        int n5;
                        for (n5 = 0; n5 < n3; ++n5) {
                            this.debugLog("waiting for pong at " + string + ", attempt " + n5);
                            file = new File(string);
                            if (file.exists()) {
                                file.delete();
                                break;
                            }
                            this.debugLog("go to sleep");
                            Thread.sleep(n);
                        }
                        if (n5 == n3) {
                            this.debugLog("time out when waiting for pong file");
                            return false;
                        }
                        this.debugLog("got pong " + string);
                    } else {
                        this.debugLog("pong not requested");
                    }
                }
                catch (IOException iOException) {
                    Log.e((String)"Qt JAVA", (String)("Can't start debugger" + iOException.getMessage()));
                }
                catch (SecurityException securityException) {
                    Log.e((String)"Qt JAVA", (String)("Can't start debugger" + securityException.getMessage()));
                }
            }
            if (bundle != null && bundle.containsKey("qml_debug") && bundle.getString("qml_debug").equals("true")) {
                if (bundle.containsKey("qmljsdebugger")) {
                    string3 = bundle.getString("qmljsdebugger");
                    string3.replaceAll("\\s", "");
                } else {
                    string3 = "port:3768";
                }
                m_applicationParameters = m_applicationParameters + "\t-qmljsdebugger=" + string3;
            }
            if (null == this.m_surface) {
                this.onCreate(null);
            }
            string3 = QtNativeLibrariesDir.nativeLibrariesDir(this.m_activity);
            this.m_surface.applicationStarted(QtNative.startApplication(m_applicationParameters, m_environmentVariables, this.m_mainLib, string3));
            this.m_started = true;
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void onTerminate() {
        QtNative.terminateQt();
    }

    public void onCreate(Bundle bundle) {
        this.m_quitApp = true;
        if (null == bundle) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            this.m_activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
            QtNative.setApplicationDisplayMetrics(displayMetrics.widthPixels, displayMetrics.heightPixels, displayMetrics.widthPixels, displayMetrics.heightPixels, displayMetrics.xdpi, displayMetrics.ydpi, displayMetrics.scaledDensity);
        }
        this.m_layout = new QtLayout((Context)this.m_activity);
        this.m_surface = new QtSurface((Context)this.m_activity, 0);
        this.m_editText = new QtEditText((Context)this.m_activity);
        this.m_imm = (InputMethodManager)this.m_activity.getSystemService("input_method");
        this.m_layout.addView((View)this.m_surface, 0);
        this.m_activity.setContentView((View)this.m_layout, new ViewGroup.LayoutParams(-1, -1));
        this.m_layout.bringChildToFront((View)this.m_surface);
        this.m_activity.registerForContextMenu((View)this.m_layout);
        this.m_currentOrientation = this.m_activity.getResources().getConfiguration().orientation;
    }

    public void onConfigurationChanged(Configuration configuration) {
        try {
            this.m_super_onConfigurationChanged.invoke((Object)this.m_activity, configuration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (configuration.orientation != this.m_currentOrientation && this.m_currentOrientation != 0) {
            QtNative.handleOrientationChanged(configuration.orientation);
        }
        this.m_currentOrientation = configuration.orientation;
    }

    public void onDestroy() {
        if (this.m_quitApp) {
            if (this.m_debuggerProcess != null) {
                this.m_debuggerProcess.destroy();
            }
            System.exit(0);
        }
    }

    public void onRestoreInstanceState(Bundle bundle) {
        try {
            this.m_super_onRestoreInstanceState.invoke((Object)this.m_activity, bundle);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_started = bundle.getBoolean("Started");
        if (this.m_started) {
            this.m_surface.applicationStarted(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResume() {
        Object object = QtNative.m_mainActivityMutex;
        synchronized (object) {
            Iterator<Runnable> iterator = QtNative.getLostActions().iterator();
            while (iterator.hasNext()) {
                this.m_activity.runOnUiThread(iterator.next());
            }
            if (this.m_started) {
                QtNative.clearLostActions();
                QtNative.updateWindow();
            }
        }
    }

    public Object onRetainNonConfigurationInstance() {
        try {
            this.m_super_onRetainNonConfigurationInstance.invoke((Object)this.m_activity, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_quitApp = false;
        return true;
    }

    public void onSaveInstanceState(Bundle bundle) {
        try {
            this.m_super_onSaveInstanceState.invoke((Object)this.m_activity, bundle);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        bundle.putBoolean("FullScreen", this.m_fullScreen);
        bundle.putBoolean("Started", this.m_started);
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        int n2;
        if (!this.m_started) {
            return false;
        }
        if (n == 82) {
            try {
                return (Boolean)this.m_super_onKeyDown.invoke((Object)this.m_activity, n, keyEvent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        this.m_metaState = MetaKeyKeyListener.handleKeyDown((long)this.m_metaState, (int)n, (KeyEvent)keyEvent);
        int n3 = n2 = keyEvent.getUnicodeChar(MetaKeyKeyListener.getMetaState((long)this.m_metaState));
        this.m_metaState = MetaKeyKeyListener.adjustMetaAfterKeypress((long)this.m_metaState);
        if ((n2 & Integer.MIN_VALUE) != 0) {
            int n4;
            n2 &= Integer.MAX_VALUE;
            n2 = n4 = KeyEvent.getDeadChar((int)this.m_lastChar, (int)n2);
        }
        this.m_lastChar = n3;
        if (n != 4) {
            QtNative.keyDown(n, n2, keyEvent.getMetaState());
        }
        return true;
    }

    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        if (!this.m_started) {
            return false;
        }
        if (n == 82) {
            try {
                return (Boolean)this.m_super_onKeyUp.invoke((Object)this.m_activity, n, keyEvent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        if (n == 4 && this.m_keyboardIsVisible && !this.m_keyboardIsHiding) {
            this.hideSoftwareKeyboard();
            return true;
        }
        this.m_metaState = MetaKeyKeyListener.handleKeyUp((long)this.m_metaState, (int)n, (KeyEvent)keyEvent);
        QtNative.keyUp(n, keyEvent.getUnicodeChar(), keyEvent.getMetaState());
        return true;
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (this.m_started && keyEvent.getAction() == 2 && keyEvent.getCharacters() != null && keyEvent.getCharacters().length() == 1 && keyEvent.getKeyCode() == 0) {
            QtNative.keyDown(0, keyEvent.getCharacters().charAt(0), keyEvent.getMetaState());
            QtNative.keyUp(0, keyEvent.getCharacters().charAt(0), keyEvent.getMetaState());
        }
        try {
            return (Boolean)this.m_super_dispatchKeyEvent.invoke((Object)this.m_activity, keyEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        menu.clear();
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        this.m_opionsMenuIsVisible = true;
        return QtNative.onPrepareOptionsMenu(menu);
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        return QtNative.onOptionsItemSelected(menuItem.getItemId(), menuItem.isChecked());
    }

    public void onOptionsMenuClosed(Menu menu) {
        this.m_opionsMenuIsVisible = false;
        QtNative.onOptionsMenuClosed(menu);
    }

    public void resetOptionsMenu() {
        if (this.m_opionsMenuIsVisible) {
            this.m_activity.closeOptionsMenu();
        }
    }

    public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
        contextMenu.clearHeader();
        QtNative.onCreateContextMenu(contextMenu);
        this.m_contextMenuVisible = true;
    }

    public void onContextMenuClosed(Menu menu) {
        if (!this.m_contextMenuVisible) {
            Log.e((String)"Qt JAVA", (String)"invalid onContextMenuClosed call");
            return;
        }
        this.m_contextMenuVisible = false;
        QtNative.onContextMenuClosed(menu);
    }

    public boolean onContextItemSelected(MenuItem menuItem) {
        return QtNative.onContextItemSelected(menuItem.getItemId(), menuItem.isChecked());
    }

    public void openContextMenu() {
        this.m_layout.postDelayed(new Runnable(){

            @Override
            public void run() {
                QtActivityDelegate.this.m_activity.openContextMenu((View)QtActivityDelegate.this.m_layout);
            }
        }, 10L);
    }

    public void closeContextMenu() {
        this.m_activity.closeContextMenu();
    }
}

