import highendivisystem 1.0
import QtQuick.Studio.Components 1.0
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.11
import QtGraphicalEffects 1.0
import QtQuick3D.Effects 1.15
import QtQuick.Studio.Effects 1.0
import QtQuick.Timeline 1.0
import FlowView 1.0
import QtMultimedia 5.15
import QtQuick3D 1.15
import QtQuick 2.15
import QtQuick.VirtualKeyboard 2.1
import QtLocation 5.6
import QtPositioning 5.6
import Quick3DAssets.CarWindows 1.0


Model {
    id: doorfrontleft
    source: "asset_imports/Quick3DAssets/BakedCar2/meshes/door_front_left.mesh"
    isWireframeMode: false
    property bool isOpen: false
    visible: true
    z: 485.95053
    eulerRotation.x: -90
    
    DefaultMaterial {
        id: defaultMaterial2
        opacity: 0
        diffuseColor: "#040404"
    }
    
    DefaultMaterial {
        id: cubeMaterial2
        emissiveFactor: 0
        emissiveColor: "#ffffff"
        specularTint: "#000000"
        specularAmount: 0.4
        diffuseMap: element5
        diffuseColor: "#7b8f91"
        
        Texture {
            id: element5
            source: "doorFL.png"
        }
    }

    Model {
        id: cube
        source: "asset_imports/Quick3DAssets/CarWindows/meshes/door_front_left_window.mesh"
        materials: cubeMaterial
        DefaultMaterial {
            id: cubeMaterial
            specularRoughness: 1
            indexOfRefraction: 1.865
            specularAmount: 0
            diffuseMap: texture1
            diffuseColor: "#ffffff"

            Texture {
                id: texture1
                source: "img/flwindow.png"
                positionV: flwindowslider.value
            }
        }
    }
    states: [
        State {
            name: "closed"
            when: !doorfrontleft.isOpen
        },
        State {
            name: "open"
            when: doorfrontleft.isOpen

            PropertyChanges {
                target: doorfrontleft
                visible: true
                pickable: true
                eulerRotation.y: -35
            }
        }
    ]

    transitions: Transition {
        NumberAnimation
        {
            properties: "eulerRotation.y"
            easing.type: Easing.InOutQuad
            duration: 500
        }

    }

    materials: [cubeMaterial2, defaultMaterial2]
}


