# About the project

This is a demo project to showcase full workflow from Figma to Qt for MCU via Qt Design Studio.

The Figma project [McuDemo.fig](/examples/TreadmillMcuDemo/figmadesign/McuDemo.fig) is already fine-tuned to make the conversion easy and it shows all the best practises for making a great user experience when doing a Qt for MCU project with Qt Design Studio. Also included is an example export [McuDemo.qtbridge](/examples/TreadmillMcuDemo/figmadesign/McuDemo.qtbridge) from Figma via the Qt Bridge for Figma plugin.

The project has been tested with Qt Design Studio 4.7.1 and Qt Creator 16.0.0 with Qt for MCUs 2.9.1 on STM32F7 hardware.

## Running in Qt Creator:
```
-choose MCU kit
-open CMakeLists.txt
-ignore (or fix) the warnings, shouldn't use the directory property on MCU projects.
-if build fails, it might help to clear CMake configuration and then rebuilding the project
```

## How to run from an empty DS project

1. Open [McuDemo.fig](/examples/TreadmillMcuDemo/figmadesign/McuDemo.fig) in figma (or just grab the example import file [McuDemo.qtbridge](/examples/TreadmillMcuDemo/figmadesign/McuDemo.qtbridge) and skip to step 5.)

2. Get Qt Bridge for Figma from Figma's main menu -> Plugins -> Manage plugins

3. Export the design with the bridge

4. Create a new MCU project in DS, resolution should be 800x480

5. Import .qtbridge contents to DS assets (+ button in assets, or just drag n drop to the 2D view)

6. Install the [exo](https://fonts.google.com/specimen/Exo) font on your system, or get the necessary font files from [fonts](/examples/TreadmillMcuDemo/fonts)

7. Get the logic from [TreadmillMcuDemo.qml](/examples/TreadmillMcuDemo/TreadmillMcuDemo.qml) or make your own

8. Copy-paste the Timeline animations from [SplashScreen.ui.qml](/examples/TreadmillMcuDemo/SplashScreen.ui.qml) and [TrackView.ui.qml](/examples/TreadmillMcuDemo/TrackView.ui.qml) or recreate them:

### Animation for TrackView.ui.qml

1. Navigate to TrackView.ui.qml  

    ![track1](/examples/TreadmillMcuDemo/readme_screenshots/track1.png)  
2. Add a Timeline with the "Add Timeline" button  

    ![track2](/examples/TreadmillMcuDemo/readme_screenshots/addTimeline.png)  
3. Set the timeline ID to timeline, the animation ID to timelineAnimation, set the duration to 10000, make the animation continuous and set Running in base state to false  

    ![track3](/examples/TreadmillMcuDemo/readme_screenshots/track3.png)  
4. Click the Auto key button to enable automatic Keyframe generation  

    ![track4](/examples/TreadmillMcuDemo/readme_screenshots/autoKey.png)  
5. Select trackView_merge_1 from the Navigator and Insert Keyframes for the x and y properties from the property editor  

    ![track5_1](/examples/TreadmillMcuDemo/readme_screenshots/track5_1.png)
    ![track5_2](/examples/TreadmillMcuDemo/readme_screenshots/track5_2.png)
    ![track5_3](/examples/TreadmillMcuDemo/readme_screenshots/track5_3.png)  
6. Move the playhead to around frame 200  

    ![track6](/examples/TreadmillMcuDemo/readme_screenshots/track6.png)  
7. Drag and drop trackView_merge_1 across the track towards the bend  

    ![track7](/examples/TreadmillMcuDemo/readme_screenshots/track7.png)  
8. Move the playhead to about 20 frames ahead  

    ![track8](/examples/TreadmillMcuDemo/readme_screenshots/track8.png)  
9. Move the trackView_merge_1 a bit further along the track  

    ![track9](/examples/TreadmillMcuDemo/readme_screenshots/track9.png)  
10. Repeat steps 9 and 10 until trackView_merge_1 is out of the bend, around the frame 500, move the playhead to frame 700, and repeat steps 9 and 10 until trackView_merge_1 is almost back at the beginning  

    ![track10_1](/examples/TreadmillMcuDemo/readme_screenshots/track10_1.png)
    ![track10_2](/examples/TreadmillMcuDemo/readme_screenshots/track10_2.png)  
11. Click the Auto key button to disable automatic Keyframe generation and you should now have Keyframes for all the positions for the Timeline animation  

12. Running the project with the logic copied from [TreadmillMcuDemo.qml](/examples/TreadmillMcuDemo/TreadmillMcuDemo.qml) should now play the animation when clicking the START button

### Animation for SplashScreen.ui.qml
1. Navigate to SplashScreen.ui.qml  

    ![splash1](/examples/TreadmillMcuDemo/readme_screenshots/splash1.png)  
2. Add a Timeline with the "Add Timeline" button  

    ![splash2](/examples/TreadmillMcuDemo/readme_screenshots/addTimeline.png)  
3. Set the timeline ID to timeline and the animation ID to timelineAnimation and set the duration to 5000  

    ![splash3](/examples/TreadmillMcuDemo/readme_screenshots/splash3.png)  
4. Click the Auto key button to enable automatic Keyframe generation  

    ![splash4](/examples/TreadmillMcuDemo/readme_screenshots/autoKey.png)  
5. Select (CTRL+click for multiselect) slogan, qtLogo and speedtrekLogo from the Navigator  

    ![splash5](/examples/TreadmillMcuDemo/readme_screenshots/splash5.png)  
6. Insert a Keyframe for opacity and set it to 0 from the Property editor with those three elements selected  

    ![splash6](/examples/TreadmillMcuDemo/readme_screenshots/splash6.png)  
7. Select slogan and set the x property to 254 from the Property editor  

    ![splash7](/examples/TreadmillMcuDemo/readme_screenshots/splash7.png)  
8. Similarly select speedtrekLogo and set the x property to -12 from the Property editor  

9. Move the playhead to frame 200  

10. Select slogan and set the x property to 154 and opacity to 1  

11. Select speedtrekLogo and set the x property to 88 and opacity to 1  

    ![splash9](/examples/TreadmillMcuDemo/readme_screenshots/splash9.png)  
12. Select qtLogo and insert a Keyframe for the y property and opacity  

    ![splash12](/examples/TreadmillMcuDemo/readme_screenshots/splash12.png)  
13. Move the playhead to frame 400  

14. Set the y property for qtLogo to 334 and opacity to 1  

    ![splash13](/examples/TreadmillMcuDemo/readme_screenshots/splash13.png)  
15. Move the playhead to frame 800  

16. Select splashScreen and insert a Keyframe for opacity  

    ![splash16_1](/examples/TreadmillMcuDemo/readme_screenshots/splash16_1.png)
    ![splash16_2](/examples/TreadmillMcuDemo/readme_screenshots/splash16_2.png)  
17. Move the playhead to frame 1000  

18. Set opacity to 0 for splashScreen  

    ![splash18](/examples/TreadmillMcuDemo/readme_screenshots/splash18.png)  
19. Click the Auto key button to disable automatic Keyframe generation  

20. Running the project with the logic copied from [TreadmillMcuDemo.qml](/examples/TreadmillMcuDemo/TreadmillMcuDemo.qml) should now play the animation when the project starts up