/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the examples of the Qt Design Studio.
**
** $QT_BEGIN_LICENSE:BSD$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** BSD License Usage
** Alternatively, you may use this file under the terms of the BSD license
** as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of The Qt Company Ltd nor the names of its
**     contributors may be used to endorse or promote products derived
**     from this software without specific prior written permission.
**
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
** $QT_END_LICENSE$
**
****************************************************************************/
import QtQuick
import QtQuick.Timeline

Item
{
    id: root
    width: 1170
    height: 300

    property double value: 0.7
    property int rpm: 0

    Item {
        id: internal
        property color colorA: "#ffffff"
        property color colorB: "#f94a07"
    }

    Item {
        id: labels
        x: -4
        width: 1170
        height: 200
        anchors.top: parent.top
        anchors.topMargin: -19

        Text {
            id: label_0
            x: 46
            y: 165
            color: internal.colorA
            text: qsTr("0")
            font.pixelSize: 33
            font.bold: true
            font.family: "Barlow-mono"
        }

        Text {
            id: label_1
            x: 109
            y: 139
            color: internal.colorA
            text: qsTr("1")
            font.pixelSize: 33
            font.family: "Barlow-mono"
            font.bold: true
        }

        Text {
            id: label_2
            x: 172
            y: 111
            color: internal.colorA
            text: qsTr("2")
            font.pixelSize: 33
            font.bold: true
            font.family: "Barlow-mono"
        }

        Text {
            id: label_3
            x: 235
            y: 87
            color: internal.colorA
            text: qsTr("3")
            font.pixelSize: 33
            font.family: "Barlow-mono"
            font.bold: true
        }

        Text {
            id: label_4
            x: 306
            y: 69
            color: internal.colorA
            text: qsTr("4")
            font.pixelSize: 33
            font.bold: true
            font.family: "Barlow-mono"
        }

        Text {
            id: label_5
            x: 382
            y: 65
            color: internal.colorA
            text: qsTr("5")
            font.pixelSize: 33
            font.family: "Barlow-mono"
            font.bold: true
        }

        Text {
            id: label_6
            x: 461
            y: 66
            color: internal.colorA
            text: qsTr("6")
            font.pixelSize: 33
            font.bold: true
            font.family: "Barlow-mono"
        }

        Text {
            id: label_7
            x: 537
            y: 66
            color: internal.colorA
            text: qsTr("7")
            font.pixelSize: 33
            font.family: "Barlow-mono"
            font.bold: true
        }

        Text {
            id: label_8
            x: 609
            y: 66
            color: internal.colorA
            text: qsTr("8")
            font.pixelSize: 33
            font.bold: true
            font.family: "Barlow-mono"
        }

        Text {
            id: label_9
            x: 688
            y: 66
            color: internal.colorA
            text: qsTr("9")
            font.pixelSize: 33
            font.family: "Barlow-mono"
            font.bold: true
        }

        Text {
            id: label_10
            x: 747
            y: 65
            color: internal.colorA
            text: qsTr("10")
            font.pixelSize: 33
            font.bold: true
            font.family: "Barlow-mono"
        }

        Text {
            id: label_11
            x: 825
            y: 69
            color: internal.colorA
            text: qsTr("11")
            font.pixelSize: 33
            font.family: "Barlow-mono"
            font.bold: true
        }

        Text {
            id: label_12
            x: 899
            y: 85
            color: internal.colorB
            text: qsTr("12")
            font.pixelSize: 33
            font.bold: true
            font.family: "Barlow-mono"
        }

        Text {
            id: label_13
            x: 969
            y: 113
            color: internal.colorB
            text: qsTr("13")
            font.pixelSize: 33
            font.family: "Barlow-mono"
            font.bold: true
        }

        Text {
            id: label_14
            x: 1034
            y: 143
            color: internal.colorB
            text: qsTr("14")
            font.pixelSize: 33
            font.bold: true
            font.family: "Barlow-mono"
        }

        Text {
            id: label_15
            x: 1095
            y: 172
            color: internal.colorB
            text: qsTr("15")
            font.pixelSize: 33
            font.family: "Barlow-mono"
            font.bold: true
        }
    }

    Item {
        id: segments
        width: 1170
        height: 220
        anchors.bottom: parent.bottom
        anchors.bottomMargin: 0


        Rectangle {
            id: colorPlaceHolder1
            x: 10
            y: 14
            width: 50
            height: 50
            visible: false
            color: internal.colorA
        }

        Rectangle {
            id: colorPlaceHolder2
            x: 59
            y: 14
            width: 50
            height: 50
            visible: false
            color: internal.colorB
        }

        RpmSegment {
            id: segment_1
            x: 6
            y: 95
            opacity: 0
            source: "images/big/tacho/1.png"
            color: internal.colorA
        }

        RpmSegment {
            id: segment_2
            x: 66
            y: 66
            opacity: 0
            source: "images/big/tacho/2.png"
            color: internal.colorA
        }

        RpmSegment {
            id: segment_3
            x: 130
            y: 37
            opacity: 0
            source: "images/big/tacho/3.png"
            color: internal.colorA
        }

        RpmSegment {
            id: segment_4
            x: 194
            y: 14
            opacity: 0
            source: "images/big/tacho/4.png"
            color: internal.colorA
        }

        RpmSegment {
            id: segment_5
            x: 258
            y: 2
            opacity: 0
            source: "images/big/tacho/5.png"
            color: internal.colorA
        }

        RpmSegment {
            id: segment_6
            x: 333
            y: 0
            opacity: 0
            source: "images/big/tacho/6.png"
            color: internal.colorA
        }

        RpmSegment {
            id: segment_7
            x: 409
            y: 0
            opacity: 0
            source: "images/big/tacho/6.png"
            color: internal.colorA
        }

        RpmSegment {
            id: segment_8
            x: 485
            y: 0
            opacity: 0
            source: "images/big/tacho/6.png"
            color: internal.colorA
        }

        RpmSegment {
            id: segment_9
            x: 560
            y: 0
            opacity: 0
            source: "images/big/tacho/6.png"
            color: internal.colorA
        }

        RpmSegment {
            id: segment_10
            x: 637
            y: 0
            opacity: 0
            source: "images/big/tacho/6.png"
            color: internal.colorA
        }

        RpmSegment {
            id: segment_11
            x: 713
            y: 0
            opacity: 0
            source: "images/big/tacho/6.png"
            color: internal.colorA
        }

        RpmSegment {
            id: segment_12
            x: 907
            y: 2
            opacity: 0
            source: "images/big/tacho/5.png"
            color: internal.colorA
            mirror: true
        }

        RpmSegment {
            id: segment_13
            x: 971
            y: 14
            opacity: 0
            source: "images/big/tacho/4.png"
            color: internal.colorB
            mirror: true
        }

        RpmSegment {
            id: segment_14
            x: 1035
            y: 37
            opacity: 0
            source: "images/big/tacho/3.png"
            color: internal.colorB
            mirror: true
        }

        RpmSegment {
            id: segment_15
            x: 1099
            y: 66
            opacity: 0
            source: "images/big/tacho/2.png"
            color: internal.colorB
            mirror: true
        }

        RpmSegment {
            id: segment_16
            x: 1160
            y: 95
            opacity: 0
            source: "images/big/tacho/1.png"
            color: internal.colorB
            mirror: true
        }
    }

    Timeline {
        id: timeline2
        currentFrame: root.rpm*1000/17
        enabled: true
        startFrame: 0
        endFrame: 1000

        KeyframeGroup {
            target: segment_1
            property: "opacity"
            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 62
                value: 1
            }

            Keyframe {
                frame: 52
                value: 0
            }
        }

        KeyframeGroup {
            target: segment_2
            property: "opacity"
            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 124
                value: 1
            }

            Keyframe {
                frame: 114
                value: 0
            }
        }

        KeyframeGroup {
            target: segment_3
            property: "opacity"
            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 186
                value: 1
            }

            Keyframe {
                frame: 176
                value: 0
            }
        }

        KeyframeGroup {
            target: segment_4
            property: "opacity"
            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 248
                value: 1
            }

            Keyframe {
                frame: 238
                value: 0
            }
        }

        KeyframeGroup {
            target: segment_5
            property: "opacity"
            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 310
                value: 1
            }

            Keyframe {
                frame: 300
                value: 0
            }
        }

        KeyframeGroup {
            target: segment_6
            property: "opacity"
            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 372
                value: 1
            }

            Keyframe {
                frame: 362
                value: 0
            }
        }

        KeyframeGroup {
            target: segment_7
            property: "opacity"
            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 434
                value: 1
            }

            Keyframe {
                frame: 424
                value: 0
            }
        }

        KeyframeGroup {
            target: segment_8
            property: "opacity"
            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 496
                value: 1
            }

            Keyframe {
                frame: 486
                value: 0
            }
        }

        KeyframeGroup {
            target: segment_9
            property: "opacity"
            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 558
                value: 1
            }

            Keyframe {
                frame: 548
                value: 0
            }
        }

        KeyframeGroup {
            target: segment_10
            property: "opacity"
            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 620
                value: 1
            }

            Keyframe {
                frame: 610
                value: 0
            }
        }

        KeyframeGroup {
            target: segment_11
            property: "opacity"
            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 682
                value: 1
            }

            Keyframe {
                frame: 672
                value: 0
            }
        }

        KeyframeGroup {
            target: segment_12
            property: "opacity"
            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 744
                value: 1
            }

            Keyframe {
                frame: 734
                value: 0
            }
        }

        KeyframeGroup {
            target: segment_13
            property: "opacity"
            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 806
                value: 1
            }

            Keyframe {
                frame: 796
                value: 0
            }
        }

        KeyframeGroup {
            target: segment_14
            property: "opacity"
            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 868
                value: 1
            }

            Keyframe {
                frame: 858
                value: 0
            }
        }

        KeyframeGroup {
            target: segment_15
            property: "opacity"
            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 930
                value: 1
            }

            Keyframe {
                frame: 920
                value: 0
            }
        }

        KeyframeGroup {
            target: segment_16
            property: "opacity"
            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 992
                value: 1
            }

            Keyframe {
                frame: 982
                value: 0
            }
        }
    }
}

