/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the examples of the Qt Design Studio.
**
** $QT_BEGIN_LICENSE:BSD$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** BSD License Usage
** Alternatively, you may use this file under the terms of the BSD license
** as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of The Qt Company Ltd nor the names of its
**     contributors may be used to endorse or promote products derived
**     from this software without specific prior written permission.
**
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
** $QT_END_LICENSE$
**
****************************************************************************/
import QtQuick
import QtQuick.Timeline
import QtQuickUltralite.Extras
import MotorClusterData

Item {
    id: root
    width: 152
    height: 152

    property real visibility: 1.0
    property int rpm: 0
    property int gear: 0

    Item {
        id: internal
        property string gearText: root.gear == 0 ? "N" : root.gear
        property color color:
            root.rpm == 0 ? Style.neutralGreen :
                            (root.rpm < 13 ? Style.neutralGreen : Style.red)
    }

    Rectangle {
        id: background
        opacity: 0
        color: internal.color
        anchors.left: holeInBackground.left
        anchors.right: holeInBackground.right
        anchors.top: holeInBackground.top
        anchors.bottom: holeInBackground.bottom
        anchors.rightMargin: 0
        anchors.leftMargin: 0
        anchors.bottomMargin: 0
        anchors.topMargin: 0
    }

    Text {
        id: textValue
        opacity: 1
        text: internal.gearText
        visible: true
        font.family: "Barlow-mono"
        font.pixelSize: 110
        color: "white"
        anchors.centerIn: background
        anchors.verticalCenterOffset: -22
    }

    Text {
        id: gearLabel
        height: gearLabel.width
        opacity: 1
        visible: true
        font.family: "Barlow-mono"
        font.pixelSize: 32
        color: "white"
        text: "Gear"
        anchors.centerIn: background
        anchors.verticalCenterOffset: 60
    }

    Image {
        id: holeInBackground
        visible: true
        anchors.centerIn: root
        source: "images/big/fuelGauge/hole-in-bg.png"
    }

    ColorizedImage {
        id: gradientCircle
        opacity: 1
        visible: true
        color: internal.color
        anchors.centerIn: root
        source: "images/big/fuelGauge/fuel-colored-circle.png"
    }

    Image {
        id: ring1
        opacity: 1
        visible: true
        source: "images/big/fuelGauge/ring-1.png"
        anchors.centerIn: root
    }

    Image {
        id: ring2
        property int offset: -200
        source: "images/big/fuelGauge/ring-2.png"
        anchors.centerIn: root
        anchors.horizontalCenterOffset: offset
        opacity: 1
        visible: true
    }

    Timeline {
        id: timeline
        currentFrame: visibility*1000
        startFrame: 0
        endFrame: 1000
        enabled: true

        KeyframeGroup {
            target: ring2
            property: "opacity"
            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 1
                frame: 125
            }

            Keyframe {
                value: 1
                frame: 291
            }
        }

        KeyframeGroup {
            target: ring1
            property: "opacity"
            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 1
                frame: 616
            }

            Keyframe {
                value: 1
                frame: 430
            }

            Keyframe {
                value: 0
                frame: 293
            }
        }

        KeyframeGroup {
            target: ring2
            property: "offset"
            Keyframe {
                value: -200
                frame: 0
            }
        
            Keyframe {
                value: -200
                frame: 80
            }
        
            Keyframe {
                value: 0
                frame: 292
            }
        }

        KeyframeGroup {
            target: gradientCircle
            property: "opacity"
            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 1
                frame: 615
            }

            Keyframe {
                value: 0
                frame: 429
            }
        }

        KeyframeGroup {
            target: gearLabel
            property: "opacity"
            Keyframe {
                value: 0
                frame: 701
            }

            Keyframe {
                value: 1
                frame: 967
            }

            Keyframe {
                value: 0
                frame: 0
            }
        }

        KeyframeGroup {
            target: textValue
            property: "opacity"
            Keyframe {
                value: 0
                frame: 701
            }

            Keyframe {
                value: 1
                frame: 967
            }

            Keyframe {
                value: 0
                frame: 0
            }
        }

        KeyframeGroup {
            target: background
            property: "opacity"
            Keyframe {
                value: 1
                frame: 1000
            }

            Keyframe {
                value: 0
                frame: 965
            }

            Keyframe {
                value: 0
                frame: 0
            }
        }

        KeyframeGroup {
            target: holeInBackground
            property: "opacity"
            Keyframe {
                value: 1
                frame: 613
            }

            Keyframe {
                value: 0
                frame: 429
            }

            Keyframe {
                value: 0
                frame: 0
            }
        }
    }
}

