
/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the examples of the Qt Design Studio.
**
** $QT_BEGIN_LICENSE:BSD$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** BSD License Usage
** Alternatively, you may use this file under the terms of the BSD license
** as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of The Qt Company Ltd nor the names of its
**     contributors may be used to endorse or promote products derived
**     from this software without specific prior written permission.
**
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
** $QT_END_LICENSE$
**
****************************************************************************/
import QtQuick
import QtQuick.Timeline
import QtQuickUltralite.Extras
import MotorClusterData

Item {
    id: root
    width: 243
    height: 243
    opacity: 1

    property bool active: true
    property real visibility: 1.0
    property real fuelLevel: 1.0

    Item {
        id: internal
        property real fuelLevelMargin: -(1.0 - root.fuelLevel) * 100
        visible: true
        property color color: fuelLevel < 0.15 ? Style.red : (fuelLevel < 0.4 ? Style.orange : Style.neutralGreen)
    }

    Image {
        id: background
        opacity: 1
        visible: false
        source: "images/big/fuelGauge/fuel-colored-bg.png"
        anchors.centerIn: root
    }

    Item {
        id: hole
        width: 176
        height: 176
        opacity: 0
        visible: true
        anchors.centerIn: root
        clip: true

        property int wavesOffset: 0
        property int wavesOffsetVisible: 0
        readonly property int waveHorizontalOffset: -1

        ColorizedImage {
            id: wave
            source: "images/big/fuelGauge/wave-top-part.png"
            color: internal.color
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.horizontalCenterOffset: hole.wavesOffsetVisible
            anchors.bottom: fuelLevelImage.top
            anchors.bottomMargin: hole.waveHorizontalOffset
        }

        ColorizedImage {
            id: wave_2
            source: "images/big/fuelGauge/wave-top-part.png"
            color: internal.color
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.horizontalCenterOffset: -60 - hole.wavesOffsetVisible
            anchors.bottom: fuelLevelImage.top
            anchors.bottomMargin: hole.waveHorizontalOffset
        }

        Image {
            id: wave_2_shadow
            source: "images/big/fuelGauge/wave-shadow.png"
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.horizontalCenterOffset: -60 - hole.wavesOffsetVisible
            anchors.bottom: fuelLevelImage.top
            anchors.bottomMargin: hole.waveHorizontalOffset
        }

        ColorizedImage {
            id: fuelLevelImage
            source: "images/big/fuelGauge/wave-bottom-part.png"
            color: internal.color
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.bottom: parent.bottom
            anchors.bottomMargin: internal.fuelLevelMargin
        }

        Timer {
            id: updateTimer
            interval: 100
            running: true
            repeat: true
        }
        Connections {
            target: updateTimer
            onTriggered: {
                hole.wavesOffsetVisible = hole.wavesOffset
            }
        }

        readonly property real valIn: 80
        readonly property real valOut: 20
        SequentialAnimation {
            id: wavesAnimation
            running: true
            loops: Animation.Infinite

            NumberAnimation {
                id: numberAnimation
                target: hole
                property: "wavesOffset"
                duration: 3000
                from: -hole.valIn
                to: hole.valOut
            }

            NumberAnimation {
                target: hole
                property: "wavesOffset"
                duration: 3000
                from: hole.valOut
                to: -hole.valIn
            }
        }
    }

    Image {
        id: fuelScale
        opacity: 0
        source: "images/big/fuelGauge/fuel-scale_2.png"
        anchors.centerIn: root
        anchors.horizontalCenterOffset: 40
    }

    Image {
        id: holeInBackground
        visible: true
        anchors.centerIn: parent
        source: "images/big/fuelGauge/hole-in-bg.png"
    }

    ColorizedImage {
        id: gradientCircle
        opacity: 0
        visible: true
        color: internal.color
        anchors.centerIn: root
        source: "images/big/fuelGauge/fuel-colored-circle.png"
    }

    Image {
        id: ring1
        opacity: 1
        source: "images/big/fuelGauge/ring-1.png"
        anchors.centerIn: root
    }

    Image {
        id: ring2
        source: "images/big/fuelGauge/ring-2.png"
        property int offset: 200
        anchors.horizontalCenterOffset: offset
        anchors.centerIn: root
        opacity: 1
    }

    Timeline {
        id: startupTimeline
        currentFrame: visibility * 1000
        startFrame: 0
        enabled: true
        endFrame: 1000

        KeyframeGroup {
            target: ring2
            property: "opacity"
            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 126
                value: 1
            }

            Keyframe {
                value: 1
                frame: 292
            }
        }

        KeyframeGroup {
            target: ring1
            property: "opacity"
            Keyframe {
                frame: 293
                value: 0
            }

            Keyframe {
                frame: 430
                value: 1
            }

            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                value: 1
                frame: 622
            }
        }

        KeyframeGroup {
            target: fuelScale
            property: "opacity"
            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 702
            }

            Keyframe {
                value: 1
                frame: 967
            }
        }

        KeyframeGroup {
            target: gradientCircle
            property: "opacity"
            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 429
            }

            Keyframe {
                value: 1
                frame: 615
            }
        }

        KeyframeGroup {
            target: hole
            property: "opacity"
            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 702
            }

            Keyframe {
                value: 1
                frame: 967
            }
        }

        KeyframeGroup {
            target: background
            property: "opacity"
            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 965
            }

            Keyframe {
                value: 1
                frame: 999
            }
        }

        KeyframeGroup {
            target: holeInBackground
            property: "opacity"
            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 431
            }

            Keyframe {
                value: 1
                frame: 619
            }
        }

        KeyframeGroup {
            target: ring2
            property: "offset"
            Keyframe {
                value: 200
                frame: 0
            }

            Keyframe {
                value: 200
                frame: 80
            }

            Keyframe {
                value: 0
                frame: 292
            }
        }
    }
}
