// Copyright (C) 2019 The Qt Company Ltd.
// Copyright © 2004-2023 Unicode, Inc.
// SPDX-License-Identifier: Unicode-3.0

#ifndef QHIJRI_CALENDAR_DATA_P_H
#define QHIJRI_CALENDAR_DATA_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not a normal header file.
// It defines data tables for internal use by QHijriCalendar.
// It may change incompatibly between versions, or even be removed.
//
// We mean it.
//

QT_BEGIN_NAMESPACE

namespace QtPrivate::Hijri {

// GENERATED PART STARTS HERE

/*
    This part of the file was generated on 2025-11-13 from the
    Common Locale Data Repository v48

    http://www.unicode.org/cldr/

    Do not edit this section: instead regenerate it using
    cldr2qlocalexml.py and qlocalexml2cpp.py on updated (or
    edited) CLDR data; see qtbase/util/locale_database/.
*/

static inline constexpr QCalendarLocale locale_data[] = {
     // lang   script terr  sLong  long sShrt short sNarw narow Sizes...
      {     1,     0,     0,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// C/AnyScript/AnyTerritory
      {     2,    27,    90,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Abkhazian/Cyrillic/Georgia
      {     3,    66,    77,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Afar/Latin/Ethiopia
      {     3,    66,    67,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Afar/Latin/Djibouti
      {     3,    66,    74,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Afar/Latin/Eritrea
      {     4,    66,   216,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Afrikaans/Latin/South Africa
      {     4,    66,   162,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Afrikaans/Latin/Namibia
      {     5,    66,    40,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Aghem/Latin/Cameroon
      {     6,    66,    92,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Akan/Latin/Ghana
      {     8,    66,    40,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Akoose/Latin/Cameroon
      {     9,    66,     3,  210,  325,  440,  519,  184,  184,115,115, 79, 79, 26, 26 },// Albanian/Latin/Albania
      {     9,    66,   126,  210,  325,  440,  519,  184,  184,115,115, 79, 79, 26, 26 },// Albanian/Latin/Kosovo
      {     9,    66,   140,  210,  325,  440,  519,  184,  184,115,115, 79, 79, 26, 26 },// Albanian/Latin/Macedonia
      {    11,    33,    77,  598,  598,  106,  106,  184,  184, 74, 74, 78, 78, 26, 26 },// Amharic/Ethiopic/Ethiopia
      {    14,     4,    71,  672,  672,  672,  672,  768,  768, 96, 96, 96, 96, 26, 26 },// Arabic/Arabic/Egypt
      {    14,     4,     4,  672,  672,  672,  672,  768,  768, 96, 96, 96, 96, 26, 26 },// Arabic/Arabic/Algeria
      {    14,     4,    19,  672,  672,  672,  672,  768,  768, 96, 96, 96, 96, 26, 26 },// Arabic/Arabic/Bahrain
      {    14,     4,    48,  672,  672,  672,  672,  768,  768, 96, 96, 96, 96, 26, 26 },// Arabic/Arabic/Chad
      {    14,     4,    55,  672,  672,  672,  672,  768,  768, 96, 96, 96, 96, 26, 26 },// Arabic/Arabic/Comoros
      {    14,     4,    67,  672,  672,  672,  672,  768,  768, 96, 96, 96, 96, 26, 26 },// Arabic/Arabic/Djibouti
      {    14,     4,    74,  672,  672,  672,  672,  768,  768, 96, 96, 96, 96, 26, 26 },// Arabic/Arabic/Eritrea
      {    14,     4,   113,  672,  672,  672,  672,  768,  768, 96, 96, 96, 96, 26, 26 },// Arabic/Arabic/Iraq
      {    14,     4,   116,  672,  672,  672,  672,  768,  768, 96, 96, 96, 96, 26, 26 },// Arabic/Arabic/Israel
      {    14,     4,   122,  672,  672,  672,  672,  768,  768, 96, 96, 96, 96, 26, 26 },// Arabic/Arabic/Jordan
      {    14,     4,   127,  672,  672,  672,  672,  768,  768, 96, 96, 96, 96, 26, 26 },// Arabic/Arabic/Kuwait
      {    14,     4,   132,  672,  672,  672,  672,  768,  768, 96, 96, 96, 96, 26, 26 },// Arabic/Arabic/Lebanon
      {    14,     4,   135,  672,  672,  672,  672,  768,  768, 96, 96, 96, 96, 26, 26 },// Arabic/Arabic/Libya
      {    14,     4,   149,  672,  672,  672,  672,  768,  768, 96, 96, 96, 96, 26, 26 },// Arabic/Arabic/Mauritania
      {    14,     4,   159,  672,  672,  672,  672,  768,  768, 96, 96, 96, 96, 26, 26 },// Arabic/Arabic/Morocco
      {    14,     4,   176,  672,  672,  672,  672,  768,  768, 96, 96, 96, 96, 26, 26 },// Arabic/Arabic/Oman
      {    14,     4,   180,  672,  672,  672,  672,  768,  768, 96, 96, 96, 96, 26, 26 },// Arabic/Arabic/Palestinian Territories
      {    14,     4,   190,  672,  672,  672,  672,  768,  768, 96, 96, 96, 96, 26, 26 },// Arabic/Arabic/Qatar
      {    14,     4,   205,  672,  672,  672,  672,  768,  768, 96, 96, 96, 96, 26, 26 },// Arabic/Arabic/Saudi Arabia
      {    14,     4,   215,  672,  672,  672,  672,  768,  768, 96, 96, 96, 96, 26, 26 },// Arabic/Arabic/Somalia
      {    14,     4,   219,  672,  672,  672,  672,  768,  768, 96, 96, 96, 96, 26, 26 },// Arabic/Arabic/South Sudan
      {    14,     4,   222,  672,  672,  672,  672,  768,  768, 96, 96, 96, 96, 26, 26 },// Arabic/Arabic/Sudan
      {    14,     4,   227,  672,  672,  672,  672,  768,  768, 96, 96, 96, 96, 26, 26 },// Arabic/Arabic/Syria
      {    14,     4,   238,  672,  672,  672,  672,  768,  768, 96, 96, 96, 96, 26, 26 },// Arabic/Arabic/Tunisia
      {    14,     4,   245,  672,  672,  672,  672,  768,  768, 96, 96, 96, 96, 26, 26 },// Arabic/Arabic/United Arab Emirates
      {    14,     4,   257,  672,  672,  672,  672,  768,  768, 96, 96, 96, 96, 26, 26 },// Arabic/Arabic/Western Sahara
      {    14,     4,   258,  672,  672,  672,  672,  768,  768, 96, 96, 96, 96, 26, 26 },// Arabic/Arabic/world
      {    14,     4,   259,  672,  672,  672,  672,  768,  768, 96, 96, 96, 96, 26, 26 },// Arabic/Arabic/Yemen
      {    15,    66,   220,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Aragonese/Latin/Spain
      {    17,     5,    12,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Armenian/Armenian/Armenia
      {    18,     9,   110,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Assamese/Bangla/India
      {    19,    66,   220,    0,  794,  106,  106,  184,  184,106,142, 78, 78, 26, 26 },// Asturian/Latin/Spain
      {    20,    66,   230,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Asu/Latin/Tanzania
      {    21,    66,   169,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Atsam/Latin/Nigeria
      {    25,    66,    17,  936,  936, 1046, 1046,  184,  184,110,110, 71, 71, 26, 26 },// Azerbaijani/Latin/Azerbaijan
      {    25,     4,   112,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Azerbaijani/Arabic/Iran
      {    25,     4,   113,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Azerbaijani/Arabic/Iraq
      {    25,     4,   239,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Azerbaijani/Arabic/Turkey
      {    25,    27,    17,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Azerbaijani/Cyrillic/Azerbaijan
      {    26,    66,    40,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Bafia/Latin/Cameroon
      {    28,    66,   145,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Bambara/Latin/Mali
      {    28,    90,   145,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Bambara/Nko/Mali
      {    30,     9,    20, 1117, 1117, 1117, 1117, 1222, 1222,105,105,105,105, 26, 26 },// Bangla/Bangla/Bangladesh
      {    30,     9,   110, 1117, 1117, 1117, 1117, 1222, 1222,105,105,105,105, 26, 26 },// Bangla/Bangla/India
      {    31,    66,    40,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Basaa/Latin/Cameroon
      {    32,    27,   193, 1248, 1248, 1364, 1364,  184,  184,116,116, 71, 71, 26, 26 },// Bashkir/Cyrillic/Russia
      {    33,    66,   220,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Basque/Latin/Spain
      {    35,    27,    22,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Belarusian/Cyrillic/Belarus
      {    36,    66,   260,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Bemba/Latin/Zambia
      {    37,    66,   230,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Bena/Latin/Tanzania
      {    38,    29,   110,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Bhojpuri/Devanagari/India
      {    40,    33,    74,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Blin/Ethiopic/Eritrea
      {    41,    29,   110,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Bodo/Devanagari/India
      {    42,    66,    29, 1435, 1435, 1534, 1534,  184,  184, 99, 99, 74, 74, 26, 26 },// Bosnian/Latin/Bosnia and Herzegovina
      {    42,    27,    29, 1608, 1698, 1795, 1795,  184,  184, 90, 97, 69, 69, 26, 26 },// Bosnian/Cyrillic/Bosnia and Herzegovina
      {    43,    66,    84,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Breton/Latin/France
      {    45,    27,    36, 1864, 1864,  106,  106,  184,  184, 96, 96, 78, 78, 26, 26 },// Bulgarian/Cyrillic/Bulgaria
      {    46,    86,   161,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Burmese/Myanmar/Myanmar
      {    47,   137,   107, 1960, 1960, 1960, 1960,  184,  184, 71, 71, 71, 71, 26, 26 },// Cantonese/Traditional Han/Hong Kong
      {    47,   118,    50, 2031, 2031, 2031, 2031,  184,  184, 71, 71, 71, 71, 26, 26 },// Cantonese/Simplified Han/China
      {    47,   137,    50, 1960, 1960, 1960, 1960,  184,  184, 71, 71, 71, 71, 26, 26 },// Cantonese/Traditional Han/China
      {    47,   137,   139, 1960, 1960, 1960, 1960,  184,  184, 71, 71, 71, 71, 26, 26 },// Cantonese/Traditional Han/Macao
      {    48,    66,   220,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Catalan/Latin/Spain
      {    48,    66,     6,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Catalan/Latin/Andorra
      {    48,    66,    84,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Catalan/Latin/France
      {    48,    66,   117,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Catalan/Latin/Italy
      {    49,    66,   185,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Cebuano/Latin/Philippines
      {    50,    66,   159,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Central Atlas Tamazight/Latin/Morocco
      {    51,     4,   113, 2102, 2102,  106,  106,  184,  184,108,108, 78, 78, 26, 26 },// Central Kurdish/Arabic/Iraq
      {    51,     4,   112, 2102, 2102,  106,  106,  184,  184,108,108, 78, 78, 26, 26 },// Central Kurdish/Arabic/Iran
      {    52,    21,    20, 2210, 2210,  106,  106, 2431, 2431,221,221, 78, 78, 41, 41 },// Chakma/Chakma/Bangladesh
      {    52,    21,   110, 2210, 2210,  106,  106, 2431, 2431,221,221, 78, 78, 41, 41 },// Chakma/Chakma/India
      {    54,    27,   193,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Chechen/Cyrillic/Russia
      {    55,    23,   248,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Cherokee/Cherokee/United States
      {    56,    66,   248,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Chickasaw/Latin/United States
      {    57,    66,   243,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Chiga/Latin/Uganda
      {    58,   118,    50, 2472, 2472, 2509, 2509,  184,  184, 37, 37, 38, 38, 26, 26 },// Chinese/Simplified Han/China
      {    58,    66,    50, 2472, 2472, 2509, 2509,  184,  184, 37, 37, 38, 38, 26, 26 },// Chinese/Latin/China
      {    58,   118,   107, 2472, 2472, 2509, 2509,  184,  184, 37, 37, 38, 38, 26, 26 },// Chinese/Simplified Han/Hong Kong
      {    58,   118,   139, 2472, 2472, 2509, 2509,  184,  184, 37, 37, 38, 38, 26, 26 },// Chinese/Simplified Han/Macao
      {    58,   118,   143, 2472, 2472, 2509, 2509,  184,  184, 37, 37, 38, 38, 26, 26 },// Chinese/Simplified Han/Malaysia
      {    58,   118,   210, 2472, 2472, 2509, 2509,  184,  184, 37, 37, 38, 38, 26, 26 },// Chinese/Simplified Han/Singapore
      {    58,   137,   107, 1960, 1960, 1960, 1960,  184,  184, 71, 71, 71, 71, 26, 26 },// Chinese/Traditional Han/Hong Kong
      {    58,   137,   139, 1960, 1960, 1960, 1960,  184,  184, 71, 71, 71, 71, 26, 26 },// Chinese/Traditional Han/Macao
      {    58,   137,   143, 1960, 1960, 1960, 1960,  184,  184, 71, 71, 71, 71, 26, 26 },// Chinese/Traditional Han/Malaysia
      {    58,   137,   228, 1960, 1960, 1960, 1960,  184,  184, 71, 71, 71, 71, 26, 26 },// Chinese/Traditional Han/Taiwan
      {    59,    27,   193,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Church/Cyrillic/Russia
      {    60,    27,   193, 2547, 2547, 2678, 2678,  184,  184,131,131, 79, 79, 26, 26 },// Chuvash/Cyrillic/Russia
      {    61,    66,    91,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Colognian/Latin/Germany
      {    62,    24,    71, 2757, 2757, 2861, 2861, 2938, 2938,104,104, 77, 77, 39, 39 },// Coptic/Coptic/Egypt
      {    63,    66,   246,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Cornish/Latin/United Kingdom
      {    64,    66,    84,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Corsican/Latin/France
      {    66,    66,    60,    0,    0,  106,  106, 2977, 2977,106,106, 78, 78, 38, 38 },// Croatian/Latin/Croatia
      {    66,    66,    29,    0,    0,  106,  106, 2977, 2977,106,106, 78, 78, 38, 38 },// Croatian/Latin/Bosnia and Herzegovina
      {    67,    66,    64, 3015, 3015, 3144, 3144,  184,  184,129,129, 76, 76, 26, 26 },// Czech/Latin/Czechia
      {    68,    66,    65, 3220, 3220,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Danish/Latin/Denmark
      {    68,    66,    95, 3220, 3220,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Danish/Latin/Greenland
      {    69,   132,   144,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Divehi/Thaana/Maldives
      {    70,    29,   110,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Dogri/Devanagari/India
      {    71,    66,    40,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Duala/Latin/Cameroon
      {    72,    66,   165, 3326, 3326, 3460, 3460,  184,  184,134,134, 83, 83, 26, 26 },// Dutch/Latin/Netherlands
      {    72,    66,    13, 3326, 3326, 3460, 3460,  184,  184,134,134, 83, 83, 26, 26 },// Dutch/Latin/Aruba
      {    72,    66,    23, 3326, 3326, 3460, 3460,  184,  184,134,134, 83, 83, 26, 26 },// Dutch/Latin/Belgium
      {    72,    66,    44, 3326, 3326, 3460, 3460,  184,  184,134,134, 83, 83, 26, 26 },// Dutch/Latin/Caribbean Netherlands
      {    72,    66,    62, 3326, 3326, 3460, 3460,  184,  184,134,134, 83, 83, 26, 26 },// Dutch/Latin/Curacao
      {    72,    66,   211, 3326, 3326, 3460, 3460,  184,  184,134,134, 83, 83, 26, 26 },// Dutch/Latin/Sint Maarten
      {    72,    66,   223, 3326, 3326, 3460, 3460,  184,  184,134,134, 83, 83, 26, 26 },// Dutch/Latin/Suriname
      {    73,   134,    27,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Dzongkha/Tibetan/Bhutan
      {    74,    66,   124,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Embu/Latin/Kenya
      {    75,    66,   248,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/United States
      {    75,    28,   248,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Deseret/United States
      {    75,    66,     5,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/American Samoa
      {    75,    66,     8,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Anguilla
      {    75,    66,    10,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Antigua and Barbuda
      {    75,    66,    15,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Australia
      {    75,    66,    16,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Austria
      {    75,    66,    18,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Bahamas
      {    75,    66,    21,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Barbados
      {    75,    66,    23,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Belgium
      {    75,    66,    24,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Belize
      {    75,    66,    26,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Bermuda
      {    75,    66,    30,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Botswana
      {    75,    66,    33,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/British Indian Ocean Territory
      {    75,    66,    34,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/British Virgin Islands
      {    75,    66,    38,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Burundi
      {    75,    66,    40,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Cameroon
      {    75,    66,    41,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Canada
      {    75,    66,    45,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Cayman Islands
      {    75,    66,    51,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Christmas Island
      {    75,    66,    53,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Cocos Islands
      {    75,    66,    58,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Cook Islands
      {    75,    66,    63,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Cyprus
      {    75,    66,    64,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Czechia
      {    75,    66,    65,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Denmark
      {    75,    66,    66,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Diego Garcia
      {    75,    66,    68,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Dominica
      {    75,    66,    74,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Eritrea
      {    75,    66,    75,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Estonia
      {    75,    66,    76,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Eswatini
      {    75,    66,    78,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Europe
      {    75,    66,    80,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Falkland Islands
      {    75,    66,    82,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Fiji
      {    75,    66,    83,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Finland
      {    75,    66,    84,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/France
      {    75,    66,    89,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Gambia
      {    75,    66,    90,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Georgia
      {    75,    66,    91,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Germany
      {    75,    66,    92,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Ghana
      {    75,    66,    93,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Gibraltar
      {    75,    66,    96,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Grenada
      {    75,    66,    98,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Guam
      {    75,    66,   100,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Guernsey
      {    75,    66,   103,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Guyana
      {    75,    66,   107,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Hong Kong
      {    75,    66,   108,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Hungary
      {    75,    66,   110,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/India
      {    75,    66,   111,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Indonesia
      {    75,    66,   114,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Ireland
      {    75,    66,   115,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Isle of Man
      {    75,    66,   116,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Israel
      {    75,    66,   117,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Italy
      {    75,    66,   119,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Jamaica
      {    75,    66,   120,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Japan
      {    75,    66,   121,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Jersey
      {    75,    66,   124,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Kenya
      {    75,    66,   125,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Kiribati
      {    75,    66,   131,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Latvia
      {    75,    66,   133,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Lesotho
      {    75,    66,   134,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Liberia
      {    75,    66,   137,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Lithuania
      {    75,    66,   139,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Macao
      {    75,    66,   141,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Madagascar
      {    75,    66,   142,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Malawi
      {    75,    66,   143,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Malaysia
      {    75,    66,   144,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Maldives
      {    75,    66,   146,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Malta
      {    75,    66,   147,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Marshall Islands
      {    75,    66,   150,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Mauritius
      {    75,    66,   153,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Micronesia
      {    75,    66,   158,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Montserrat
      {    75,    66,   162,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Namibia
      {    75,    66,   163,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Nauru
      {    75,    66,   165,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Netherlands
      {    75,    66,   167,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/New Zealand
      {    75,    66,   169,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Nigeria
      {    75,    66,   171,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Niue
      {    75,    66,   172,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Norfolk Island
      {    75,    66,   173,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Northern Mariana Islands
      {    75,    66,   175,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Norway
      {    75,    66,   178,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Pakistan
      {    75,    66,   179,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Palau
      {    75,    66,   182,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Papua New Guinea
      {    75,    66,   185,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Philippines
      {    75,    66,   186,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Pitcairn
      {    75,    66,   187,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Poland
      {    75,    66,   188,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Portugal
      {    75,    66,   189,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Puerto Rico
      {    75,    66,   192,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Romania
      {    75,    66,   194,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Rwanda
      {    75,    66,   196,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Saint Helena
      {    75,    66,   197,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Saint Kitts and Nevis
      {    75,    66,   198,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Saint Lucia
      {    75,    66,   201,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Saint Vincent and Grenadines
      {    75,    66,   202,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Samoa
      {    75,    66,   208,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Seychelles
      {    75,    66,   209,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Sierra Leone
      {    75,    66,   210,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Singapore
      {    75,    66,   211,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Sint Maarten
      {    75,    66,   212,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Slovakia
      {    75,    66,   213,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Slovenia
      {    75,    66,   214,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Solomon Islands
      {    75,    66,   216,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/South Africa
      {    75,    66,   217,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/South Georgia and South Sandwich Islands
      {    75,    66,   219,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/South Sudan
      {    75,    66,   220,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Spain
      {    75,    66,   222,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Sudan
      {    75,    66,   225,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Sweden
      {    75,    66,   226,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Switzerland
      {    75,    66,   230,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Tanzania
      {    75,    66,   234,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Tokelau
      {    75,    66,   235,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Tonga
      {    75,    66,   236,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Trinidad and Tobago
      {    75,    66,   241,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Turks and Caicos Islands
      {    75,    66,   242,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Tuvalu
      {    75,    66,   243,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Uganda
      {    75,    66,   244,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Ukraine
      {    75,    66,   245,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/United Arab Emirates
      {    75,    66,   246,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/United Kingdom
      {    75,    66,   247,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/United States Outlying Islands
      {    75,    66,   249,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/United States Virgin Islands
      {    75,    66,   252,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Vanuatu
      {    75,    66,   258,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/world
      {    75,    66,   260,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Zambia
      {    75,    66,   261,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Latin/Zimbabwe
      {    75,   115,   246,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// English/Shavian/United Kingdom
      {    76,    27,   193,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Erzya/Cyrillic/Russia
      {    77,    66,   258,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Esperanto/Latin/world
      {    78,    66,    75,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Estonian/Latin/Estonia
      {    79,    66,    92, 3543, 3543, 3629, 3629,  184,  184, 86, 86, 47, 47, 26, 26 },// Ewe/Latin/Ghana
      {    79,    66,   233, 3543, 3543, 3629, 3629,  184,  184, 86, 86, 47, 47, 26, 26 },// Ewe/Latin/Togo
      {    80,    66,    40,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Ewondo/Latin/Cameroon
      {    81,    66,    81,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Faroese/Latin/Faroe Islands
      {    81,    66,    65,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Faroese/Latin/Denmark
      {    83,    66,   185,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Filipino/Latin/Philippines
      {    84,    66,    83, 3676, 3676,  106,  106,  184,  184,129,129, 78, 78, 26, 26 },// Finnish/Latin/Finland
      {    85,    66,    84, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/France
      {    85,    66,     4, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Algeria
      {    85,    66,    23, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Belgium
      {    85,    66,    25, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Benin
      {    85,    66,    37, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Burkina Faso
      {    85,    66,    38, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Burundi
      {    85,    66,    40, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Cameroon
      {    85,    66,    41, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Canada
      {    85,    66,    46, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Central African Republic
      {    85,    66,    48, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Chad
      {    85,    66,    55, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Comoros
      {    85,    66,    56, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Congo - Brazzaville
      {    85,    66,    57, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Congo - Kinshasa
      {    85,    66,    67, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Djibouti
      {    85,    66,    73, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Equatorial Guinea
      {    85,    66,    85, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/French Guiana
      {    85,    66,    86, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/French Polynesia
      {    85,    66,    88, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Gabon
      {    85,    66,    97, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Guadeloupe
      {    85,    66,   102, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Guinea
      {    85,    66,   104, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Haiti
      {    85,    66,   118, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Ivory Coast
      {    85,    66,   138, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Luxembourg
      {    85,    66,   141, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Madagascar
      {    85,    66,   145, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Mali
      {    85,    66,   148, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Martinique
      {    85,    66,   149, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Mauritania
      {    85,    66,   150, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Mauritius
      {    85,    66,   151, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Mayotte
      {    85,    66,   155, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Monaco
      {    85,    66,   159, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Morocco
      {    85,    66,   166, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/New Caledonia
      {    85,    66,   170, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Niger
      {    85,    66,   191, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Reunion
      {    85,    66,   194, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Rwanda
      {    85,    66,   195, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Saint Barthelemy
      {    85,    66,   199, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Saint Martin
      {    85,    66,   200, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Saint Pierre and Miquelon
      {    85,    66,   206, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Senegal
      {    85,    66,   208, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Seychelles
      {    85,    66,   226, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Switzerland
      {    85,    66,   227, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Syria
      {    85,    66,   233, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Togo
      {    85,    66,   238, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Tunisia
      {    85,    66,   252, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Vanuatu
      {    85,    66,   256, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// French/Latin/Wallis and Futuna
      {    86,    66,   117,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Friulian/Latin/Italy
      {    87,    66,   206,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Fulah/Latin/Senegal
      {    87,     1,    37, 4124, 4124, 4377, 4377, 4472, 4472,253,253, 95, 95, 41, 41 },// Fulah/Adlam/Burkina Faso
      {    87,     1,    40, 4124, 4124, 4377, 4377, 4472, 4472,253,253, 95, 95, 41, 41 },// Fulah/Adlam/Cameroon
      {    87,     1,    89, 4124, 4124, 4377, 4377, 4472, 4472,253,253, 95, 95, 41, 41 },// Fulah/Adlam/Gambia
      {    87,     1,    92, 4124, 4124, 4377, 4377, 4472, 4472,253,253, 95, 95, 41, 41 },// Fulah/Adlam/Ghana
      {    87,     1,   101, 4124, 4124, 4377, 4377, 4472, 4472,253,253, 95, 95, 41, 41 },// Fulah/Adlam/Guinea-Bissau
      {    87,     1,   102, 4124, 4124, 4377, 4377, 4472, 4472,253,253, 95, 95, 41, 41 },// Fulah/Adlam/Guinea
      {    87,     1,   134, 4124, 4124, 4377, 4377, 4472, 4472,253,253, 95, 95, 41, 41 },// Fulah/Adlam/Liberia
      {    87,     1,   149, 4124, 4124, 4377, 4377, 4472, 4472,253,253, 95, 95, 41, 41 },// Fulah/Adlam/Mauritania
      {    87,     1,   169, 4124, 4124, 4377, 4377, 4472, 4472,253,253, 95, 95, 41, 41 },// Fulah/Adlam/Nigeria
      {    87,     1,   170, 4124, 4124, 4377, 4377, 4472, 4472,253,253, 95, 95, 41, 41 },// Fulah/Adlam/Niger
      {    87,     1,   206, 4124, 4124, 4377, 4377, 4472, 4472,253,253, 95, 95, 41, 41 },// Fulah/Adlam/Senegal
      {    87,     1,   209, 4124, 4124, 4377, 4377, 4472, 4472,253,253, 95, 95, 41, 41 },// Fulah/Adlam/Sierra Leone
      {    87,    66,    37,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Fulah/Latin/Burkina Faso
      {    87,    66,    40,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Fulah/Latin/Cameroon
      {    87,    66,    89,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Fulah/Latin/Gambia
      {    87,    66,    92,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Fulah/Latin/Ghana
      {    87,    66,   101,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Fulah/Latin/Guinea-Bissau
      {    87,    66,   102,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Fulah/Latin/Guinea
      {    87,    66,   134,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Fulah/Latin/Liberia
      {    87,    66,   149,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Fulah/Latin/Mauritania
      {    87,    66,   169,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Fulah/Latin/Nigeria
      {    87,    66,   170,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Fulah/Latin/Niger
      {    87,    66,   209,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Fulah/Latin/Sierra Leone
      {    88,    66,   246,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Gaelic/Latin/United Kingdom
      {    89,    66,    92,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Ga/Latin/Ghana
      {    90,    66,   220,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Galician/Latin/Spain
      {    91,    66,   243,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Ganda/Latin/Uganda
      {    92,    33,    77,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Geez/Ethiopic/Ethiopia
      {    92,    33,    74,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Geez/Ethiopic/Eritrea
      {    93,    35,    90, 4513, 4513, 4637, 4637,  184,  184,124,124, 73, 73, 26, 26 },// Georgian/Georgian/Georgia
      {    94,    66,    91, 4710, 4710,  106,  106,  184,  184,116,116, 78, 78, 26, 26 },// German/Latin/Germany
      {    94,    66,    16, 4710, 4710,  106,  106,  184,  184,116,116, 78, 78, 26, 26 },// German/Latin/Austria
      {    94,    66,    23, 4710, 4710,  106,  106,  184,  184,116,116, 78, 78, 26, 26 },// German/Latin/Belgium
      {    94,    66,   117, 4710, 4710,  106,  106,  184,  184,116,116, 78, 78, 26, 26 },// German/Latin/Italy
      {    94,    66,   136, 4710, 4710,  106,  106,  184,  184,116,116, 78, 78, 26, 26 },// German/Latin/Liechtenstein
      {    94,    66,   138, 4710, 4710,  106,  106,  184,  184,116,116, 78, 78, 26, 26 },// German/Latin/Luxembourg
      {    94,    66,   226, 4710, 4710,  106,  106,  184,  184,116,116, 78, 78, 26, 26 },// German/Latin/Switzerland
      {    96,    39,    94,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Greek/Greek/Greece
      {    96,    39,    63,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Greek/Greek/Cyprus
      {    97,    66,   183,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Guarani/Latin/Paraguay
      {    98,    40,   110, 4826, 4826, 4924, 4924,  184,  184, 98, 98, 74, 74, 26, 26 },// Gujarati/Gujarati/India
      {    99,    66,   124,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Gusii/Latin/Kenya
      {   100,    66,   104, 3805, 3805, 3944, 4034,  184,  184,139,139, 90, 90, 26, 26 },// Haitian/Latin/Haiti
      {   101,    66,   169, 4998, 4998,  106,  106,  184,  184,107,107, 78, 78, 26, 26 },// Hausa/Latin/Nigeria
      {   101,     4,   169,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Hausa/Arabic/Nigeria
      {   101,     4,   222,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Hausa/Arabic/Sudan
      {   101,    66,    92, 4998, 4998,  106,  106,  184,  184,107,107, 78, 78, 26, 26 },// Hausa/Latin/Ghana
      {   101,    66,   170, 4998, 4998,  106,  106,  184,  184,107,107, 78, 78, 26, 26 },// Hausa/Latin/Niger
      {   102,    66,   248,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Hawaiian/Latin/United States
      {   103,    47,   116, 5105, 5221, 5337, 5337,  184,  184,116,116, 95, 95, 26, 26 },// Hebrew/Hebrew/Israel
      {   105,    29,   110, 5432, 5432,  106,  106,  184,  184,108,108, 78, 78, 26, 26 },// Hindi/Devanagari/India
      {   105,    66,   110,    0, 5540,  106, 5670,  184,  184,106,130, 78, 63, 26, 26 },// Hindi/Latin/India
      {   107,    66,   108, 5733, 5832, 5959, 5959,  184,  184, 99,127, 76, 76, 26, 26 },// Hungarian/Latin/Hungary
      {   108,    66,   109, 3220, 3220, 6035, 6035,  184,  184,106,106, 78, 78, 26, 26 },// Icelandic/Latin/Iceland
      {   109,    66,   258,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Ido/Latin/world
      {   110,    66,   169,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Igbo/Latin/Nigeria
      {   111,    66,    83,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Inari Sami/Latin/Finland
      {   112,    66,   111, 6113, 6113, 6222, 6222,  184,  184,109,109, 86, 86, 26, 26 },// Indonesian/Latin/Indonesia
      {   114,    66,   258,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Interlingua/Latin/world
      {   115,    66,    75,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Interlingue/Latin/Estonia
      {   116,    18,    41,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Inuktitut/Canadian Aboriginal/Canada
      {   116,    66,    41,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Inuktitut/Latin/Canada
      {   118,    66,   114,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Irish/Latin/Ireland
      {   118,    66,   246,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Irish/Latin/United Kingdom
      {   119,    66,   117,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Italian/Latin/Italy
      {   119,    66,   203,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Italian/Latin/San Marino
      {   119,    66,   226,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Italian/Latin/Switzerland
      {   119,    66,   253,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Italian/Latin/Vatican City
      {   120,    53,   120, 6308, 6308, 6308, 6308,  184,  184, 97, 97, 97, 97, 26, 26 },// Japanese/Japanese/Japan
      {   121,    66,   111, 6405, 6405, 6491, 6491,  184,  184, 86, 86, 72, 72, 26, 26 },// Javanese/Latin/Indonesia
      {   122,    66,   169,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Jju/Latin/Nigeria
      {   123,    66,   206,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Jola-Fonyi/Latin/Senegal
      {   124,    66,    43,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Kabuverdianu/Latin/Cape Verde
      {   125,    66,     4,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Kabyle/Latin/Algeria
      {   126,    66,    40,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Kako/Latin/Cameroon
      {   127,    66,    95,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Kalaallisut/Latin/Greenland
      {   128,    66,   124,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Kalenjin/Latin/Kenya
      {   129,    66,   124,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Kamba/Latin/Kenya
      {   130,    56,   110, 6563, 6563, 6663, 6663,  184,  184,100,100, 79, 79, 26, 26 },// Kannada/Kannada/India
      {   132,     4,   110,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Kashmiri/Arabic/India
      {   132,    29,   110,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Kashmiri/Devanagari/India
      {   133,    27,   123, 6742, 6742, 6857, 6929,  184,  184,115,115, 72, 72, 26, 26 },// Kazakh/Cyrillic/Kazakhstan
      {   133,     4,    50,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Kazakh/Arabic/China
      {   134,    66,    40,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Kenyang/Latin/Cameroon
      {   135,    60,    39,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Khmer/Khmer/Cambodia
      {   136,    66,    99,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Kiche/Latin/Guatemala
      {   137,    66,   124,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Kikuyu/Latin/Kenya
      {   138,    66,   194,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Kinyarwanda/Latin/Rwanda
      {   141,    29,   110,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Konkani/Devanagari/India
      {   141,    66,   110,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Konkani/Latin/India
      {   142,    63,   218, 7001, 7001,  106,  106,  184,  184, 69, 69, 78, 78, 26, 26 },// Korean/Korean/South Korea
      {   142,    63,    50, 7001, 7001,  106,  106,  184,  184, 69, 69, 78, 78, 26, 26 },// Korean/Korean/China
      {   142,    63,   174, 7001, 7001,  106,  106,  184,  184, 69, 69, 78, 78, 26, 26 },// Korean/Korean/North Korea
      {   144,    66,   145,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Koyraboro Senni/Latin/Mali
      {   145,    66,   145,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Koyra Chiini/Latin/Mali
      {   146,    66,   134,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Kpelle/Latin/Liberia
      {   146,    66,   102,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Kpelle/Latin/Guinea
      {   148,    66,   239, 7070, 7070, 7179, 7179,  184,  184,109,109, 79, 79, 26, 26 },// Kurdish/Latin/Turkey
      {   148,     4,   112,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Kurdish/Arabic/Iran
      {   148,     4,   113,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Kurdish/Arabic/Iraq
      {   148,    66,   113, 7070, 7070, 7179, 7179,  184,  184,109,109, 79, 79, 26, 26 },// Kurdish/Latin/Iraq
      {   148,    66,   227, 7070, 7070, 7179, 7179,  184,  184,109,109, 79, 79, 26, 26 },// Kurdish/Latin/Syria
      {   149,    66,    40,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Kwasio/Latin/Cameroon
      {   150,    27,   128,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Kyrgyz/Cyrillic/Kyrgyzstan
      {   151,    66,   248,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Lakota/Latin/United States
      {   152,    66,   230,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Langi/Latin/Tanzania
      {   153,    65,   129, 7258, 7258, 7353, 7428,  184,  184, 95, 95, 75, 77, 26, 26 },// Lao/Lao/Laos
      {   154,    66,   253,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Latin/Latin/Vatican City
      {   155,    66,   131, 7505, 7505,  106,  106,  184,  184,108,108, 78, 78, 26, 26 },// Latvian/Latin/Latvia
      {   158,    66,    57,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Lingala/Latin/Congo - Kinshasa
      {   158,    66,     7,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Lingala/Latin/Angola
      {   158,    66,    46,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Lingala/Latin/Central African Republic
      {   158,    66,    56,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Lingala/Latin/Congo - Brazzaville
      {   160,    66,   137,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Lithuanian/Latin/Lithuania
      {   161,    66,   258,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Lojban/Latin/world
      {   162,    66,    91,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Lower Sorbian/Latin/Germany
      {   163,    66,    91,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Low German/Latin/Germany
      {   163,    66,   165,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Low German/Latin/Netherlands
      {   164,    66,    57,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Luba-Katanga/Latin/Congo - Kinshasa
      {   165,    66,   225,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Lule Sami/Latin/Sweden
      {   165,    66,   175,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Lule Sami/Latin/Norway
      {   166,    66,   124,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Luo/Latin/Kenya
      {   167,    66,   138,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Luxembourgish/Latin/Luxembourg
      {   168,    66,   124,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Luyia/Latin/Kenya
      {   169,    27,   140, 7613, 7613, 7702, 7702,  184,  184, 89, 89, 71, 71, 26, 26 },// Macedonian/Cyrillic/Macedonia
      {   170,    66,   230,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Machame/Latin/Tanzania
      {   171,    29,   110,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Maithili/Devanagari/India
      {   172,    66,   160,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Makhuwa-Meetto/Latin/Mozambique
      {   173,    66,   230,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Makonde/Latin/Tanzania
      {   174,    66,   141,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Malagasy/Latin/Madagascar
      {   175,    74,   110, 7773, 7875, 7977, 7977, 8074, 8074,102,102, 97, 97, 26, 26 },// Malayalam/Malayalam/India
      {   176,    66,   143, 8100, 8100, 8209, 8209,  184,  184,109,109, 73, 73, 26, 26 },// Malay/Latin/Malaysia
      {   176,     4,    35,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Malay/Arabic/Brunei
      {   176,     4,   143,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Malay/Arabic/Malaysia
      {   176,    66,    35, 8100, 8100, 8209, 8209,  184,  184,109,109, 73, 73, 26, 26 },// Malay/Latin/Brunei
      {   176,    66,   111, 8100, 8100, 8209, 8209,  184,  184,109,109, 73, 73, 26, 26 },// Malay/Latin/Indonesia
      {   176,    66,   210, 8100, 8100, 8209, 8209,  184,  184,109,109, 73, 73, 26, 26 },// Malay/Latin/Singapore
      {   177,    66,   146,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Maltese/Latin/Malta
      {   179,     9,   110,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Manipuri/Bangla/India
      {   179,    78,   110,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Manipuri/Meitei Mayek/India
      {   180,    66,   115,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Manx/Latin/Isle of Man
      {   181,    66,   167,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Maori/Latin/New Zealand
      {   182,    66,    49,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Mapuche/Latin/Chile
      {   183,    29,   110, 8282, 8282, 8369, 8369, 8447, 8447, 87, 87, 78, 78, 26, 26 },// Marathi/Devanagari/India
      {   185,    66,   124,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Masai/Latin/Kenya
      {   185,    66,   230,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Masai/Latin/Tanzania
      {   186,     4,   112,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Mazanderani/Arabic/Iran
      {   188,    66,   124,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Meru/Latin/Kenya
      {   189,    66,    40,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Meta/Latin/Cameroon
      {   190,    66,    41,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Mohawk/Latin/Canada
      {   191,    27,   156,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Mongolian/Cyrillic/Mongolia
      {   191,    83,    50,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Mongolian/Mongolian/China
      {   191,    83,   156,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Mongolian/Mongolian/Mongolia
      {   192,    66,   150,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Morisyen/Latin/Mauritius
      {   193,    66,    40,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Mundang/Latin/Cameroon
      {   194,    66,   248,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Muscogee/Latin/United States
      {   195,    66,   162,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Nama/Latin/Namibia
      {   197,    66,   248,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Navajo/Latin/United States
      {   199,    29,   164,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Nepali/Devanagari/Nepal
      {   199,    29,   110,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Nepali/Devanagari/India
      {   201,    66,    40,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Ngiemboon/Latin/Cameroon
      {   202,    66,    40,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Ngomba/Latin/Cameroon
      {   203,    66,   169,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Nigerian Pidgin/Latin/Nigeria
      {   204,    90,   102,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Nko/Nko/Guinea
      {   205,     4,   112,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Northern Luri/Arabic/Iran
      {   205,     4,   113,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Northern Luri/Arabic/Iraq
      {   206,    66,   175,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Northern Sami/Latin/Norway
      {   206,    66,    83,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Northern Sami/Latin/Finland
      {   206,    66,   225,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Northern Sami/Latin/Sweden
      {   207,    66,   216,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Northern Sotho/Latin/South Africa
      {   208,    66,   261,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// North Ndebele/Latin/Zimbabwe
      {   209,    66,   175, 8473, 8473, 8579, 8657,  184,  184,106,106, 78, 78, 26, 26 },// Norwegian Bokmal/Latin/Norway
      {   209,    66,   224, 8473, 8473, 8579, 8657,  184,  184,106,106, 78, 78, 26, 26 },// Norwegian Bokmal/Latin/Svalbard and Jan Mayen
      {   210,    66,   175, 8473, 8473, 8579, 8657,  184,  184,106,106, 78, 78, 26, 26 },// Norwegian Nynorsk/Latin/Norway
      {   211,    66,   219,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Nuer/Latin/South Sudan
      {   212,    66,   142,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Nyanja/Latin/Malawi
      {   213,    66,   243,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Nyankole/Latin/Uganda
      {   214,    66,    84,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Occitan/Latin/France
      {   214,    66,   220,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Occitan/Latin/Spain
      {   215,    91,   110,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Odia/Odia/India
      {   220,    66,    77,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Oromo/Latin/Ethiopia
      {   220,    66,   124,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Oromo/Latin/Kenya
      {   221,   101,   248,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Osage/Osage/United States
      {   222,    27,    90,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Ossetic/Cyrillic/Georgia
      {   222,    27,   193,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Ossetic/Cyrillic/Russia
      {   225,    66,   246,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Pali/Latin/United Kingdom
      {   226,    66,    62,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Papiamento/Latin/Curacao
      {   226,    66,    13,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Papiamento/Latin/Aruba
      {   227,     4,     1, 8735, 8735, 8818, 8818,  184,  184, 83, 83, 73, 73, 26, 26 },// Pashto/Arabic/Afghanistan
      {   227,     4,   178, 8735, 8891, 8818, 8818,  184,  184, 83, 88, 73, 73, 26, 26 },// Pashto/Arabic/Pakistan
      {   228,     4,   112, 8979, 8979, 8979, 8979, 9069, 9069, 90, 90, 90, 90, 23, 23 },// Persian/Arabic/Iran
      {   228,     4,     1, 8979, 8979, 8979, 8979, 9069, 9069, 90, 90, 90, 90, 23, 23 },// Persian/Arabic/Afghanistan
      {   230,    66,   187, 9092, 9092, 9199, 9199,  184,  184,107,107, 77, 77, 26, 26 },// Polish/Latin/Poland
      {   231,    66,    32,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Portuguese/Latin/Brazil
      {   231,    66,     7,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Portuguese/Latin/Angola
      {   231,    66,    43,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Portuguese/Latin/Cape Verde
      {   231,    66,    73,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Portuguese/Latin/Equatorial Guinea
      {   231,    66,   101,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Portuguese/Latin/Guinea-Bissau
      {   231,    66,   138,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Portuguese/Latin/Luxembourg
      {   231,    66,   139,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Portuguese/Latin/Macao
      {   231,    66,   160,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Portuguese/Latin/Mozambique
      {   231,    66,   188,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Portuguese/Latin/Portugal
      {   231,    66,   204,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Portuguese/Latin/Sao Tome and Principe
      {   231,    66,   226,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Portuguese/Latin/Switzerland
      {   231,    66,   232,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Portuguese/Latin/Timor-Leste
      {   232,    66,   187,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Prussian/Latin/Poland
      {   233,    41,   110, 9276, 9368, 9462, 9462,  184,  184, 92, 94, 77, 77, 26, 26 },// Punjabi/Gurmukhi/India
      {   233,     4,   178,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Punjabi/Arabic/Pakistan
      {   234,    66,   184,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Quechua/Latin/Peru
      {   234,    66,    28,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Quechua/Latin/Bolivia
      {   234,    66,    70,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Quechua/Latin/Ecuador
      {   235,    66,   192,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Romanian/Latin/Romania
      {   235,    66,   154,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Romanian/Latin/Moldova
      {   236,    66,   226,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Romansh/Latin/Switzerland
      {   237,    66,   230,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Rombo/Latin/Tanzania
      {   238,    66,    38,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Rundi/Latin/Burundi
      {   239,    27,   193, 2547, 2547, 2678, 2678,  184,  184,131,131, 79, 79, 26, 26 },// Russian/Cyrillic/Russia
      {   239,    27,    22, 2547, 2547, 2678, 2678,  184,  184,131,131, 79, 79, 26, 26 },// Russian/Cyrillic/Belarus
      {   239,    27,   123, 2547, 2547, 2678, 2678,  184,  184,131,131, 79, 79, 26, 26 },// Russian/Cyrillic/Kazakhstan
      {   239,    27,   128, 2547, 2547, 2678, 2678,  184,  184,131,131, 79, 79, 26, 26 },// Russian/Cyrillic/Kyrgyzstan
      {   239,    27,   154, 2547, 2547, 2678, 2678,  184,  184,131,131, 79, 79, 26, 26 },// Russian/Cyrillic/Moldova
      {   239,    27,   244, 2547, 2547, 2678, 2678,  184,  184,131,131, 79, 79, 26, 26 },// Russian/Cyrillic/Ukraine
      {   240,    66,   230,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Rwa/Latin/Tanzania
      {   241,    66,    74,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Saho/Latin/Eritrea
      {   242,    27,   193,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Sakha/Cyrillic/Russia
      {   243,    66,   124,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Samburu/Latin/Kenya
      {   245,    66,    46,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Sango/Latin/Central African Republic
      {   246,    66,   230,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Sangu/Latin/Tanzania
      {   247,    29,   110,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Sanskrit/Devanagari/India
      {   248,    93,   110,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Santali/Ol Chiki/India
      {   248,    29,   110,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Santali/Devanagari/India
      {   249,    66,   117, 9539, 9539, 8657, 8657,  184,  184,105,105, 78, 78, 26, 26 },// Sardinian/Latin/Italy
      {   251,    66,   160,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Sena/Latin/Mozambique
      {   252,    27,   207, 1608, 9644, 1795, 1795,  184,  184, 90, 97, 69, 69, 26, 26 },// Serbian/Cyrillic/Serbia
      {   252,    27,    29, 1608, 9644, 1795, 1795,  184,  184, 90, 97, 69, 69, 26, 26 },// Serbian/Cyrillic/Bosnia and Herzegovina
      {   252,    27,   126, 1608, 9644, 1795, 1795,  184,  184, 90, 97, 69, 69, 26, 26 },// Serbian/Cyrillic/Kosovo
      {   252,    27,   157, 1608, 9644, 1795, 1795,  184,  184, 90, 97, 69, 69, 26, 26 },// Serbian/Cyrillic/Montenegro
      {   252,    66,    29, 9741, 9835, 9932, 9932,  184,  184, 94, 97, 72, 72, 26, 26 },// Serbian/Latin/Bosnia and Herzegovina
      {   252,    66,   126, 9741, 9835, 9932, 9932,  184,  184, 94, 97, 72, 72, 26, 26 },// Serbian/Latin/Kosovo
      {   252,    66,   157, 9741, 9835, 9932, 9932,  184,  184, 94, 97, 72, 72, 26, 26 },// Serbian/Latin/Montenegro
      {   252,    66,   207, 9741, 9835, 9932, 9932,  184,  184, 94, 97, 72, 72, 26, 26 },// Serbian/Latin/Serbia
      {   253,    66,   230,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Shambala/Latin/Tanzania
      {   254,    66,   261,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Shona/Latin/Zimbabwe
      {   255,   141,    50,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Sichuan Yi/Yi/China
      {   256,    66,   117,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Sicilian/Latin/Italy
      {   257,    66,    77,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Sidamo/Latin/Ethiopia
      {   258,    66,   187,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Silesian/Latin/Poland
      {   259,     4,   178,10004,10004,10004,10004,  184,  184, 91, 91, 91, 91, 26, 26 },// Sindhi/Arabic/Pakistan
      {   259,    29,   110,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Sindhi/Devanagari/India
      {   260,   119,   221,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Sinhala/Sinhala/Sri Lanka
      {   261,    66,    83,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Skolt Sami/Latin/Finland
      {   262,    66,   212,10095,10095,10230,10230,  184,  184,135,135, 78, 78, 26, 26 },// Slovak/Latin/Slovakia
      {   263,    66,   213,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Slovenian/Latin/Slovenia
      {   264,    66,   243,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Soga/Latin/Uganda
      {   265,    66,   215,10308,10439,10569,10643,  184,  184,131,130, 74, 81, 26, 26 },// Somali/Latin/Somalia
      {   265,    66,    67,10308,10439,10569,10643,  184,  184,131,130, 74, 81, 26, 26 },// Somali/Latin/Djibouti
      {   265,    66,    77,10308,10439,10569,10643,  184,  184,131,130, 74, 81, 26, 26 },// Somali/Latin/Ethiopia
      {   265,    66,   124,10308,10439,10569,10643,  184,  184,131,130, 74, 81, 26, 26 },// Somali/Latin/Kenya
      {   266,     4,   112,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Southern Kurdish/Arabic/Iran
      {   266,     4,   113,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Southern Kurdish/Arabic/Iraq
      {   267,    66,   225,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Southern Sami/Latin/Sweden
      {   267,    66,   175,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Southern Sami/Latin/Norway
      {   268,    66,   216,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Southern Sotho/Latin/South Africa
      {   268,    66,   133,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Southern Sotho/Latin/Lesotho
      {   269,    66,   216,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// South Ndebele/Latin/South Africa
      {   270,    66,   220,10724,10724, 8657, 8657,  184,  184,106,106, 78, 78, 26, 26 },// Spanish/Latin/Spain
      {   270,    66,    11,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Spanish/Latin/Argentina
      {   270,    66,    24,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Spanish/Latin/Belize
      {   270,    66,    28,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Spanish/Latin/Bolivia
      {   270,    66,    32,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Spanish/Latin/Brazil
      {   270,    66,    42,10724,10724, 8657, 8657,  184,  184,106,106, 78, 78, 26, 26 },// Spanish/Latin/Canary Islands
      {   270,    66,    47,10724,10724, 8657, 8657,  184,  184,106,106, 78, 78, 26, 26 },// Spanish/Latin/Ceuta and Melilla
      {   270,    66,    49,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Spanish/Latin/Chile
      {   270,    66,    54,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Spanish/Latin/Colombia
      {   270,    66,    59,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Spanish/Latin/Costa Rica
      {   270,    66,    61,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Spanish/Latin/Cuba
      {   270,    66,    69,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Spanish/Latin/Dominican Republic
      {   270,    66,    70,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Spanish/Latin/Ecuador
      {   270,    66,    72,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Spanish/Latin/El Salvador
      {   270,    66,    73,10724,10724, 8657, 8657,  184,  184,106,106, 78, 78, 26, 26 },// Spanish/Latin/Equatorial Guinea
      {   270,    66,    99,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Spanish/Latin/Guatemala
      {   270,    66,   106,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Spanish/Latin/Honduras
      {   270,    66,   130,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Spanish/Latin/Latin America
      {   270,    66,   152,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Spanish/Latin/Mexico
      {   270,    66,   168,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Spanish/Latin/Nicaragua
      {   270,    66,   181,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Spanish/Latin/Panama
      {   270,    66,   183,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Spanish/Latin/Paraguay
      {   270,    66,   184,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Spanish/Latin/Peru
      {   270,    66,   185,10724,10724, 8657, 8657,  184,  184,106,106, 78, 78, 26, 26 },// Spanish/Latin/Philippines
      {   270,    66,   189,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Spanish/Latin/Puerto Rico
      {   270,    66,   248,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Spanish/Latin/United States
      {   270,    66,   250,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Spanish/Latin/Uruguay
      {   270,    66,   254,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Spanish/Latin/Venezuela
      {   271,   135,   159,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Standard Moroccan Tamazight/Tifinagh/Morocco
      {   272,    66,   111,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Sundanese/Latin/Indonesia
      {   273,    66,   230,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Swahili/Latin/Tanzania
      {   273,    66,    57,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Swahili/Latin/Congo - Kinshasa
      {   273,    66,   124,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Swahili/Latin/Kenya
      {   273,    66,   243,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Swahili/Latin/Uganda
      {   274,    66,   216,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Swati/Latin/South Africa
      {   274,    66,    76,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Swati/Latin/Eswatini
      {   275,    66,   225,10830,10957,  106,  106,  184,  184,127,127, 78, 78, 26, 26 },// Swedish/Latin/Sweden
      {   275,    66,     2,10830,10957,  106,  106,  184,  184,127,127, 78, 78, 26, 26 },// Swedish/Latin/Aland Islands
      {   275,    66,    83,10830,10957,  106,  106,  184,  184,127,127, 78, 78, 26, 26 },// Swedish/Latin/Finland
      {   276,    66,   226,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Swiss German/Latin/Switzerland
      {   276,    66,    84,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Swiss German/Latin/France
      {   276,    66,   136,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Swiss German/Latin/Liechtenstein
      {   277,   123,   113,11084,11084,  106,  106,  184,  184, 91, 91, 78, 78, 26, 26 },// Syriac/Syriac/Iraq
      {   277,   123,   227,11084,11084,  106,  106,  184,  184, 91, 91, 78, 78, 26, 26 },// Syriac/Syriac/Syria
      {   278,   135,   159,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Tachelhit/Tifinagh/Morocco
      {   278,    66,   159,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Tachelhit/Latin/Morocco
      {   280,   127,   255,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Tai Dam/Tai Viet/Vietnam
      {   281,    66,   124,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Taita/Latin/Kenya
      {   282,    27,   229,11175,11286,11396,11396,  184,  184,111,110, 74, 74, 26, 26 },// Tajik/Cyrillic/Tajikistan
      {   283,   129,   110,11470,11470,11561,11561,  184,  184, 91, 91, 72, 72, 26, 26 },// Tamil/Tamil/India
      {   283,   129,   143,11470,11470,11561,11561,  184,  184, 91, 91, 72, 72, 26, 26 },// Tamil/Tamil/Malaysia
      {   283,   129,   210,11470,11470,11561,11561,  184,  184, 91, 91, 72, 72, 26, 26 },// Tamil/Tamil/Singapore
      {   283,   129,   221,11470,11470,11561,11561,  184,  184, 91, 91, 72, 72, 26, 26 },// Tamil/Tamil/Sri Lanka
      {   284,    66,   228,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Taroko/Latin/Taiwan
      {   285,    66,   170,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Tasawaq/Latin/Niger
      {   286,    27,   193,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Tatar/Cyrillic/Russia
      {   287,   131,   110,11633,    0,11728,11728,  184,  184, 95,106, 74, 74, 26, 26 },// Telugu/Telugu/India
      {   288,    66,   243,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Teso/Latin/Uganda
      {   288,    66,   124,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Teso/Latin/Kenya
      {   289,   133,   231,11802,11802,11904,11904,  184,  184,102,102, 89, 89, 26, 26 },// Thai/Thai/Thailand
      {   290,   134,    50,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Tibetan/Tibetan/China
      {   290,   134,   110,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Tibetan/Tibetan/India
      {   291,    33,    74,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Tigre/Ethiopic/Eritrea
      {   292,    33,    77,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Tigrinya/Ethiopic/Ethiopia
      {   292,    33,    74,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Tigrinya/Ethiopic/Eritrea
      {   294,    66,   182,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Tok Pisin/Latin/Papua New Guinea
      {   295,    66,   235,11993,11993,12092,12092,  184,  184, 99, 99, 60, 60, 26, 26 },// Tongan/Latin/Tonga
      {   296,    66,   216,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Tsonga/Latin/South Africa
      {   297,    66,   216,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Tswana/Latin/South Africa
      {   297,    66,    30,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Tswana/Latin/Botswana
      {   298,    66,   239,12152,12152,12262,12262,  184,  184,110,110, 83, 83, 26, 26 },// Turkish/Latin/Turkey
      {   298,    66,    63,12152,12152,12262,12262,  184,  184,110,110, 83, 83, 26, 26 },// Turkish/Latin/Cyprus
      {   299,    66,   240,12345,12345,12458,12458,  184,  184,113,113, 59, 59, 26, 26 },// Turkmen/Latin/Turkmenistan
      {   301,    66,   169,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Tyap/Latin/Nigeria
      {   303,    27,   244,12517,12517,12620,12691,  184,  184,103,103, 71, 81, 26, 26 },// Ukrainian/Cyrillic/Ukraine
      {   304,    66,    91,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Upper Sorbian/Latin/Germany
      {   305,     4,   178,12772,12772,12868,12966,  184,  184, 96, 96, 98, 96, 26, 26 },// Urdu/Arabic/Pakistan
      {   305,     4,   110,12772,12772,12868,12966,  184,  184, 96, 96, 98, 96, 26, 26 },// Urdu/Arabic/India
      {   306,     4,    50,13062,13062,13062,13062,  184,  184,118,118,118,118, 26, 26 },// Uyghur/Arabic/China
      {   307,    66,   251,13180,13180,13298,13298,  184,  184,118,118, 82, 82, 26, 26 },// Uzbek/Latin/Uzbekistan
      {   307,     4,     1,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Uzbek/Arabic/Afghanistan
      {   307,    27,   251,13380,13380,  106,  106,  184,  184,114,114, 78, 78, 26, 26 },// Uzbek/Cyrillic/Uzbekistan
      {   308,   139,   134,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Vai/Vai/Liberia
      {   308,    66,   134,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Vai/Latin/Liberia
      {   309,    66,   216,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Venda/Latin/South Africa
      {   310,    66,   255,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Vietnamese/Latin/Vietnam
      {   311,    66,   258,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Volapuk/Latin/world
      {   312,    66,   230,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Vunjo/Latin/Tanzania
      {   313,    66,    23,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Walloon/Latin/Belgium
      {   314,    66,   226,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Walser/Latin/Switzerland
      {   315,    66,    15,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Warlpiri/Latin/Australia
      {   316,    66,   246,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Welsh/Latin/United Kingdom
      {   317,     4,   178,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Western Balochi/Arabic/Pakistan
      {   317,     4,     1,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Western Balochi/Arabic/Afghanistan
      {   317,     4,   112,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Western Balochi/Arabic/Iran
      {   317,     4,   176,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Western Balochi/Arabic/Oman
      {   317,     4,   245,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Western Balochi/Arabic/United Arab Emirates
      {   318,    66,   165, 3326, 3326, 3460, 3460,  184,  184,134,134, 83, 83, 26, 26 },// Western Frisian/Latin/Netherlands
      {   319,    33,    77,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Wolaytta/Ethiopic/Ethiopia
      {   320,    66,   206,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Wolof/Latin/Senegal
      {   321,    66,   216,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Xhosa/Latin/South Africa
      {   322,    66,    40,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Yangben/Latin/Cameroon
      {   323,    47,   244,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Yiddish/Hebrew/Ukraine
      {   324,    66,   169,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Yoruba/Latin/Nigeria
      {   324,    66,    25,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Yoruba/Latin/Benin
      {   325,    66,   170,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Zarma/Latin/Niger
      {   326,    66,    50,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Zhuang/Latin/China
      {   327,    66,   216,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Zulu/Latin/South Africa
      {   328,    66,    32,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Kaingang/Latin/Brazil
      {   329,    66,    32,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Nheengatu/Latin/Brazil
      {   329,    66,    54,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Nheengatu/Latin/Colombia
      {   329,    66,   254,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Nheengatu/Latin/Venezuela
      {   330,    29,   110,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Haryanvi/Devanagari/India
      {   331,    66,    91,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Northern Frisian/Latin/Germany
      {   332,    29,   110,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Rajasthani/Devanagari/India
      {   333,    27,   193,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Moksha/Cyrillic/Russia
      {   334,    66,   258,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Toki Pona/Latin/world
      {   335,    66,   214,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Pijin/Latin/Solomon Islands
      {   336,    66,   169,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Obolo/Latin/Nigeria
      {   337,     4,   178,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Baluchi/Arabic/Pakistan
      {   337,    66,   178,13494,13494,13589,13589,  184,  184, 95, 95, 74, 74, 26, 26 },// Baluchi/Latin/Pakistan
      {   338,    66,   117,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Ligurian/Latin/Italy
      {   339,   142,   161,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Rohingya/Hanifi/Myanmar
      {   339,   142,    20,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Rohingya/Hanifi/Bangladesh
      {   340,     4,   178,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Torwali/Arabic/Pakistan
      {   341,    66,    25,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Anii/Latin/Benin
      {   342,    29,   110,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Kangri/Devanagari/India
      {   343,    66,   117,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Venetian/Latin/Italy
      {   344,    66,   110,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Kuvi/Latin/India
      {   344,    29,   110,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Kuvi/Devanagari/India
      {   344,    91,   110,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Kuvi/Odia/India
      {   344,   131,   110,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Kuvi/Telugu/India
      {   345,    27,   251,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Kara-Kalpak/Cyrillic/Uzbekistan
      {   345,    66,   251,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Kara-Kalpak/Latin/Uzbekistan
      {   346,    18,    41,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Swampy Cree/Canadian Aboriginal/Canada
      {   347,    66,   117,    0,    0,  106,  106,  184,  184,106,106, 78, 78, 26, 26 },// Ladin/Latin/Italy
      {   348,    86,   161,13663,13663,13796,13796,  184,  184,133,133, 87, 87, 26, 26 },// Shan/Myanmar/Myanmar
      {   348,    86,   231,13663,13663,13796,13796,  184,  184,133,133, 87, 87, 26, 26 },// Shan/Myanmar/Thailand
      {     0,     0,     0,    0,    0,    0,    0,    0,    0,  0,  0,  0,  0,  0,  0 },// trailing zeros
};

static inline constexpr char16_t months_data[] = {
0x4d, 0x75, 0x68, 0x61, 0x72, 0x72, 0x61, 0x6d, 0x3b, 0x53, 0x61, 0x66,
0x61, 0x72, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x2bb, 0x20, 0x49, 0x3b, 0x52,
0x61, 0x62, 0x69, 0x2bb, 0x20, 0x49, 0x49, 0x3b, 0x4a, 0x75, 0x6d, 0x61,
0x64, 0x61, 0x20, 0x49, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20,
0x49, 0x49, 0x3b, 0x52, 0x61, 0x6a, 0x61, 0x62, 0x3b, 0x53, 0x68, 0x61,
0x2bb, 0x62, 0x61, 0x6e, 0x3b, 0x52, 0x61, 0x6d, 0x61, 0x64, 0x61, 0x6e,
0x3b, 0x53, 0x68, 0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b, 0x44, 0x68, 0x75,
0x2bb, 0x6c, 0x2d, 0x51, 0x69, 0x2bb, 0x64, 0x61, 0x68, 0x3b, 0x44, 0x68,
0x75, 0x2bb, 0x6c, 0x2d, 0x48, 0x69, 0x6a, 0x6a, 0x61, 0x68, 0x4d, 0x75,
0x68, 0x2e, 0x3b, 0x53, 0x61, 0x66, 0x2e, 0x3b, 0x52, 0x61, 0x62, 0x2e,
0x20, 0x49, 0x3b, 0x52, 0x61, 0x62, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x4a,
0x75, 0x6d, 0x2e, 0x20, 0x49, 0x3b, 0x4a, 0x75, 0x6d, 0x2e, 0x20, 0x49,
0x49, 0x3b, 0x52, 0x61, 0x6a, 0x2e, 0x3b, 0x53, 0x68, 0x61, 0x2e, 0x3b,
0x52, 0x61, 0x6d, 0x2e, 0x3b, 0x53, 0x68, 0x61, 0x77, 0x2e, 0x3b, 0x44,
0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x51, 0x2e, 0x3b, 0x44, 0x68, 0x75, 0x2bb,
0x6c, 0x2d, 0x48, 0x2e, 0x31, 0x3b, 0x32, 0x3b, 0x33, 0x3b, 0x34, 0x3b,
0x35, 0x3b, 0x36, 0x3b, 0x37, 0x3b, 0x38, 0x3b, 0x39, 0x3b, 0x31, 0x30,
0x3b, 0x31, 0x31, 0x3b, 0x31, 0x32, 0x4d, 0x75, 0x68, 0x61, 0x72, 0x72,
0x65, 0x6d, 0x3b, 0x53, 0x65, 0x66, 0x65, 0x72, 0x3b, 0x52, 0x65, 0x62,
0x69, 0x75, 0x6c, 0x2d, 0x65, 0x76, 0x65, 0x6c, 0x3b, 0x52, 0x65, 0x62,
0x69, 0x75, 0x2d, 0x74, 0x68, 0x65, 0x6e, 0x69, 0x3b, 0x58, 0x68, 0x75,
0x6d, 0x61, 0x64, 0x65, 0x6c, 0x2d, 0x75, 0x6c, 0x61, 0x3b, 0x58, 0x68,
0x75, 0x6d, 0x61, 0x64, 0x65, 0x2d, 0x74, 0x68, 0x65, 0x6e, 0x69, 0x3b,
0x52, 0x65, 0x78, 0x68, 0x65, 0x62, 0x3b, 0x53, 0x68, 0x61, 0x62, 0x61,
0x6e, 0x3b, 0x52, 0x61, 0x6d, 0x61, 0x7a, 0x61, 0x6e, 0x3b, 0x53, 0x68,
0x65, 0x76, 0x61, 0x6c, 0x3b, 0x44, 0x68, 0x75, 0x6c, 0x2d, 0x6b, 0x61,
0x64, 0x65, 0x3b, 0x44, 0x68, 0x75, 0x6c, 0x2d, 0x68, 0x69, 0x78, 0x68,
0x65, 0x6d, 0x75, 0x68, 0x61, 0x72, 0x72, 0x65, 0x6d, 0x3b, 0x73, 0x65,
0x66, 0x65, 0x72, 0x3b, 0x72, 0x65, 0x62, 0x69, 0x75, 0x6c, 0x2d, 0x65,
0x76, 0x65, 0x6c, 0x3b, 0x72, 0x65, 0x62, 0x69, 0x75, 0x2d, 0x74, 0x68,
0x65, 0x6e, 0x69, 0x3b, 0x78, 0x68, 0x75, 0x6d, 0x61, 0x64, 0x65, 0x6c,
0x2d, 0x75, 0x6c, 0x61, 0x3b, 0x78, 0x68, 0x75, 0x6d, 0x61, 0x64, 0x65,
0x2d, 0x74, 0x68, 0x65, 0x6e, 0x69, 0x3b, 0x72, 0x65, 0x78, 0x68, 0x65,
0x62, 0x3b, 0x73, 0x68, 0x61, 0x62, 0x61, 0x6e, 0x3b, 0x72, 0x61, 0x6d,
0x61, 0x7a, 0x61, 0x6e, 0x3b, 0x73, 0x68, 0x65, 0x76, 0x61, 0x6c, 0x3b,
0x64, 0x68, 0x75, 0x6c, 0x2d, 0x6b, 0x61, 0x64, 0x65, 0x3b, 0x64, 0x68,
0x75, 0x6c, 0x2d, 0x68, 0x69, 0x78, 0x68, 0x65, 0x4d, 0x75, 0x68, 0x2e,
0x3b, 0x53, 0x65, 0x66, 0x2e, 0x3b, 0x52, 0x65, 0x62, 0x2e, 0x20, 0x49,
0x3b, 0x52, 0x65, 0x62, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x58, 0x68, 0x75,
0x6d, 0x2e, 0x20, 0x49, 0x3b, 0x58, 0x68, 0x75, 0x6d, 0x2e, 0x20, 0x49,
0x49, 0x3b, 0x52, 0x65, 0x78, 0x68, 0x2e, 0x3b, 0x53, 0x68, 0x61, 0x2e,
0x3b, 0x52, 0x61, 0x6d, 0x2e, 0x3b, 0x53, 0x68, 0x65, 0x76, 0x2e, 0x3b,
0x44, 0x68, 0x75, 0x6c, 0x2d, 0x6b, 0x2e, 0x3b, 0x44, 0x68, 0x75, 0x6c,
0x2d, 0x68, 0x2e, 0x6d, 0x75, 0x68, 0x2e, 0x3b, 0x73, 0x65, 0x66, 0x2e,
0x3b, 0x72, 0x65, 0x62, 0x2e, 0x20, 0x49, 0x3b, 0x72, 0x65, 0x62, 0x2e,
0x20, 0x49, 0x49, 0x3b, 0x78, 0x68, 0x75, 0x6d, 0x2e, 0x20, 0x49, 0x3b,
0x78, 0x68, 0x75, 0x6d, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x72, 0x65, 0x78,
0x68, 0x2e, 0x3b, 0x73, 0x68, 0x61, 0x2e, 0x3b, 0x72, 0x61, 0x6d, 0x2e,
0x3b, 0x73, 0x68, 0x65, 0x76, 0x2e, 0x3b, 0x64, 0x68, 0x75, 0x6c, 0x2d,
0x6b, 0x2e, 0x3b, 0x64, 0x68, 0x75, 0x6c, 0x2d, 0x68, 0x2e, 0x1219, 0x1200,
0x1228, 0x121d, 0x3b, 0x1233, 0x1348, 0x122d, 0x3b, 0x1228, 0x1262, 0x12d1, 0x120d, 0x20,
0x12a0, 0x12c8, 0x120d, 0x3b, 0x1228, 0x1262, 0x12d1, 0x120d, 0x20, 0x12a0, 0x12ba, 0x122d,
0x3b, 0x1300, 0x121b, 0x12f0, 0x120d, 0x20, 0x12a0, 0x12c8, 0x120d, 0x3b, 0x1300, 0x121b,
0x12f0, 0x120d, 0x20, 0x12a0, 0x12ba, 0x122d, 0x3b, 0x1228, 0x1300, 0x1265, 0x3b, 0x123b,
0x12a5, 0x1263, 0x1295, 0x3b, 0x1228, 0x1218, 0x12f3, 0x1295, 0x3b, 0x1238, 0x12cb, 0x120d,
0x3b, 0x12d9, 0x120d, 0x1242, 0x12f3, 0x1205, 0x3b, 0x12d9, 0x120d, 0x1202, 0x1303, 0x1205,
0x645, 0x62d, 0x631, 0x645, 0x3b, 0x635, 0x641, 0x631, 0x3b, 0x631, 0x628, 0x64a,
0x639, 0x20, 0x627, 0x644, 0x623, 0x648, 0x644, 0x3b, 0x631, 0x628, 0x64a, 0x639,
0x20, 0x627, 0x644, 0x622, 0x62e, 0x631, 0x3b, 0x62c, 0x645, 0x627, 0x62f, 0x649,
0x20, 0x627, 0x644, 0x623, 0x648, 0x644, 0x649, 0x3b, 0x62c, 0x645, 0x627, 0x62f,
0x649, 0x20, 0x627, 0x644, 0x622, 0x62e, 0x631, 0x629, 0x3b, 0x631, 0x62c, 0x628,
0x3b, 0x634, 0x639, 0x628, 0x627, 0x646, 0x3b, 0x631, 0x645, 0x636, 0x627, 0x646,
0x3b, 0x634, 0x648, 0x627, 0x644, 0x3b, 0x630, 0x648, 0x20, 0x627, 0x644, 0x642,
0x639, 0x62f, 0x629, 0x3b, 0x630, 0x648, 0x20, 0x627, 0x644, 0x62d, 0x62c, 0x629,
0x661, 0x3b, 0x662, 0x3b, 0x663, 0x3b, 0x664, 0x3b, 0x665, 0x3b, 0x666, 0x3b,
0x667, 0x3b, 0x668, 0x3b, 0x669, 0x3b, 0x661, 0x660, 0x3b, 0x661, 0x661, 0x3b,
0x661, 0x662, 0x64, 0x65, 0x20, 0x4d, 0x75, 0x68, 0x61, 0x72, 0x72, 0x61,
0x6d, 0x3b, 0x64, 0x65, 0x20, 0x53, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x64,
0x65, 0x20, 0x52, 0x61, 0x62, 0x69, 0x2bb, 0x20, 0x49, 0x3b, 0x64, 0x65,
0x20, 0x52, 0x61, 0x62, 0x69, 0x2bb, 0x20, 0x49, 0x49, 0x3b, 0x64, 0x65,
0x20, 0x4a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x49, 0x3b, 0x64, 0x65,
0x20, 0x4a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x49, 0x49, 0x3b, 0x64,
0x65, 0x20, 0x52, 0x61, 0x6a, 0x61, 0x62, 0x3b, 0x64, 0x65, 0x20, 0x53,
0x68, 0x61, 0x2bb, 0x62, 0x61, 0x6e, 0x3b, 0x64, 0x65, 0x20, 0x52, 0x61,
0x6d, 0x61, 0x64, 0x61, 0x6e, 0x3b, 0x64, 0x65, 0x20, 0x53, 0x68, 0x61,
0x77, 0x77, 0x61, 0x6c, 0x3b, 0x64, 0x65, 0x20, 0x44, 0x68, 0x75, 0x2bb,
0x6c, 0x2d, 0x51, 0x69, 0x2bb, 0x64, 0x61, 0x68, 0x3b, 0x64, 0x65, 0x20,
0x44, 0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x48, 0x69, 0x6a, 0x6a, 0x61, 0x68,
0x4d, 0x259, 0x68, 0x259, 0x72, 0x72, 0x259, 0x6d, 0x3b, 0x53, 0x259, 0x66,
0x259, 0x72, 0x3b, 0x52, 0x259, 0x62, 0x69, 0xfc, 0x6c, 0x259, 0x76, 0x76,
0x259, 0x6c, 0x3b, 0x52, 0x259, 0x62, 0x69, 0xfc, 0x6c, 0x61, 0x78, 0x131,
0x72, 0x3b, 0x43, 0x259, 0x6d, 0x61, 0x64, 0x69, 0x79, 0x259, 0x6c, 0x259,
0x76, 0x76, 0x259, 0x6c, 0x3b, 0x43, 0x259, 0x6d, 0x61, 0x64, 0x69, 0x79,
0x259, 0x6c, 0x61, 0x78, 0x131, 0x72, 0x3b, 0x52, 0x259, 0x63, 0x259, 0x62,
0x3b, 0x15e, 0x61, 0x62, 0x61, 0x6e, 0x3b, 0x52, 0x61, 0x6d, 0x61, 0x7a,
0x61, 0x6e, 0x3b, 0x15e, 0x259, 0x76, 0x76, 0x61, 0x6c, 0x3b, 0x5a, 0x69,
0x6c, 0x71, 0x259, 0x64, 0x259, 0x3b, 0x5a, 0x69, 0x6c, 0x68, 0x69, 0x63,
0x63, 0x259, 0x4d, 0x259, 0x68, 0x2e, 0x3b, 0x53, 0x259, 0x66, 0x2e, 0x3b,
0x52, 0x259, 0x62, 0x2e, 0x20, 0x49, 0x3b, 0x52, 0x259, 0x62, 0x2e, 0x20,
0x49, 0x49, 0x3b, 0x43, 0x259, 0x6d, 0x2e, 0x20, 0x49, 0x3b, 0x43, 0x259,
0x6d, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x52, 0x259, 0x63, 0x2e, 0x3b, 0x15e,
0x61, 0x62, 0x2e, 0x3b, 0x52, 0x61, 0x6d, 0x2e, 0x3b, 0x15e, 0x259, 0x76,
0x2e, 0x3b, 0x5a, 0x69, 0x6c, 0x71, 0x2e, 0x3b, 0x5a, 0x69, 0x6c, 0x68,
0x2e, 0x9ae, 0x9c1, 0x9b9, 0x9b0, 0x9b0, 0x9ae, 0x3b, 0x9b8, 0x9ab, 0x9b0, 0x3b,
0x9b0, 0x9ac, 0x9bf, 0x989, 0x9b2, 0x20, 0x986, 0x989, 0x9af, 0x9bc, 0x9be, 0x9b2,
0x3b, 0x9b0, 0x9ac, 0x9bf, 0x989, 0x9b8, 0x20, 0x9b8, 0x9be, 0x9a8, 0x9bf, 0x3b,
0x99c, 0x9ae, 0x9be, 0x9a6, 0x9bf, 0x989, 0x9b2, 0x20, 0x986, 0x989, 0x9af, 0x9bc,
0x9be, 0x9b2, 0x3b, 0x99c, 0x9ae, 0x9be, 0x9a6, 0x9bf, 0x989, 0x9b8, 0x20, 0x9b8,
0x9be, 0x9a8, 0x9bf, 0x3b, 0x9b0, 0x99c, 0x9ac, 0x3b, 0x9b6, 0x9be, 0x2018, 0x9ac,
0x9be, 0x9a8, 0x3b, 0x9b0, 0x9ae, 0x99c, 0x9be, 0x9a8, 0x3b, 0x9b6, 0x9be, 0x993,
0x9af, 0x9bc, 0x9be, 0x9b2, 0x3b, 0x99c, 0x9cd, 0x9ac, 0x9bf, 0x9b2, 0x995, 0x9a6,
0x3b, 0x99c, 0x9cd, 0x9ac, 0x9bf, 0x9b2, 0x9b9, 0x99c, 0x9cd, 0x99c, 0x9e7, 0x3b,
0x9e8, 0x3b, 0x9e9, 0x3b, 0x9ea, 0x3b, 0x9eb, 0x3b, 0x9ec, 0x3b, 0x9ed, 0x3b,
0x9ee, 0x3b, 0x9ef, 0x3b, 0x9e7, 0x9e6, 0x3b, 0x9e7, 0x9e7, 0x3b, 0x9e7, 0x9e8,
0x43c, 0x4e9, 0x445, 0x4d9, 0x440, 0x440, 0x4d9, 0x43c, 0x3b, 0x441, 0x4d9, 0x444,
0x4d9, 0x440, 0x3b, 0x440, 0x430, 0x431, 0x438, 0x493, 0x4af, 0x43b, 0x20, 0x4d9,
0x4af, 0x4af, 0x4d9, 0x43b, 0x3b, 0x440, 0x430, 0x431, 0x438, 0x493, 0x4af, 0x43b,
0x20, 0x430, 0x445, 0x44b, 0x440, 0x3b, 0x439, 0x43e, 0x43c, 0x430, 0x434, 0x438,
0x4d9, 0x43b, 0x20, 0x4d9, 0x4af, 0x4af, 0x4d9, 0x43b, 0x3b, 0x439, 0x43e, 0x43c,
0x430, 0x434, 0x438, 0x4d9, 0x43b, 0x20, 0x430, 0x445, 0x44b, 0x440, 0x3b, 0x440,
0x4d9, 0x436, 0x4d9, 0x431, 0x3b, 0x448, 0x4d9, 0x493, 0x431, 0x430, 0x43d, 0x3b,
0x440, 0x430, 0x43c, 0x430, 0x499, 0x430, 0x43d, 0x3b, 0x448, 0x4d9, 0x4af, 0x4af,
0x4d9, 0x43b, 0x3b, 0x437, 0x4e9, 0x43b, 0x4a1, 0x4d9, 0x493, 0x438, 0x499, 0x4d9,
0x3b, 0x437, 0x4e9, 0x43b, 0x445, 0x438, 0x437, 0x4d9, 0x43c, 0x4e9, 0x445, 0x2e,
0x3b, 0x441, 0x4d9, 0x444, 0x2e, 0x3b, 0x440, 0x430, 0x431, 0x2e, 0x20, 0x49,
0x3b, 0x440, 0x430, 0x431, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x439, 0x43e, 0x43c,
0x2e, 0x20, 0x49, 0x3b, 0x439, 0x43e, 0x43c, 0x2e, 0x20, 0x49, 0x49, 0x3b,
0x440, 0x4d9, 0x436, 0x2e, 0x3b, 0x448, 0x4d9, 0x493, 0x2e, 0x3b, 0x440, 0x430,
0x43c, 0x2e, 0x3b, 0x448, 0x4d9, 0x4af, 0x2e, 0x3b, 0x437, 0x4e9, 0x43b, 0x4a1,
0x2e, 0x3b, 0x437, 0x4e9, 0x43b, 0x445, 0x2e, 0x6d, 0x75, 0x68, 0x61, 0x72,
0x65, 0x6d, 0x3b, 0x73, 0x61, 0x66, 0x65, 0x72, 0x3b, 0x72, 0x61, 0x62,
0x69, 0x2bb, 0x20, 0x69, 0x3b, 0x72, 0x61, 0x62, 0x69, 0x2bb, 0x20, 0x69,
0x69, 0x3b, 0x64, 0x17e, 0x75, 0x6d, 0x61, 0x64, 0x65, 0x20, 0x69, 0x3b,
0x64, 0x17e, 0x75, 0x6d, 0x61, 0x64, 0x65, 0x20, 0x69, 0x69, 0x3b, 0x72,
0x65, 0x64, 0x17e, 0x65, 0x62, 0x3b, 0x53, 0x68, 0x61, 0x2bb, 0x62, 0x61,
0x6e, 0x3b, 0x72, 0x61, 0x6d, 0x61, 0x7a, 0x61, 0x6e, 0x3b, 0x161, 0x65,
0x76, 0x61, 0x6c, 0x3b, 0x7a, 0x75, 0x6c, 0x2d, 0x6b, 0x61, 0x64, 0x65,
0x3b, 0x7a, 0x75, 0x6c, 0x2d, 0x68, 0x69, 0x64, 0x17e, 0x65, 0x6d, 0x75,
0x68, 0x2e, 0x3b, 0x73, 0x61, 0x66, 0x2e, 0x3b, 0x52, 0x61, 0x62, 0x2e,
0x20, 0x49, 0x3b, 0x72, 0x61, 0x62, 0x2e, 0x20, 0x69, 0x69, 0x3b, 0x64,
0x17e, 0x75, 0x6d, 0x2e, 0x20, 0x69, 0x3b, 0x64, 0x17e, 0x75, 0x6d, 0x2e,
0x20, 0x69, 0x69, 0x3b, 0x72, 0x65, 0x64, 0x17e, 0x2e, 0x3b, 0x161, 0x61,
0x2e, 0x3b, 0x72, 0x61, 0x6d, 0x2e, 0x3b, 0x161, 0x65, 0x2e, 0x3b, 0x7a,
0x75, 0x6c, 0x2d, 0x6b, 0x2e, 0x3b, 0x7a, 0x75, 0x6c, 0x2d, 0x68, 0x2e,
0x41c, 0x443, 0x445, 0x430, 0x440, 0x435, 0x43c, 0x3b, 0x421, 0x430, 0x444, 0x435,
0x440, 0x3b, 0x420, 0x435, 0x431, 0x438, 0x20, 0x31, 0x3b, 0x420, 0x435, 0x431,
0x438, 0x20, 0x32, 0x3b, 0x40f, 0x443, 0x43c, 0x430, 0x434, 0x435, 0x20, 0x31,
0x3b, 0x40f, 0x443, 0x43c, 0x430, 0x434, 0x435, 0x20, 0x32, 0x3b, 0x420, 0x435,
0x45f, 0x435, 0x431, 0x3b, 0x428, 0x430, 0x2bb, 0x431, 0x430, 0x43d, 0x3b, 0x420,
0x430, 0x43c, 0x430, 0x437, 0x430, 0x43d, 0x3b, 0x428, 0x435, 0x432, 0x430, 0x43b,
0x3b, 0x417, 0x443, 0x43b, 0x2d, 0x43a, 0x430, 0x434, 0x435, 0x3b, 0x417, 0x443,
0x43b, 0x2d, 0x445, 0x438, 0x45f, 0x435, 0x41c, 0x443, 0x440, 0x430, 0x445, 0x430,
0x43c, 0x3b, 0x421, 0x430, 0x444, 0x430, 0x440, 0x3b, 0x420, 0x430, 0x431, 0x438,
0x2bb, 0x20, 0x49, 0x3b, 0x420, 0x430, 0x431, 0x438, 0x2bb, 0x20, 0x49, 0x49,
0x3b, 0x408, 0x443, 0x43c, 0x430, 0x434, 0x430, 0x20, 0x49, 0x3b, 0x408, 0x443,
0x43c, 0x430, 0x434, 0x430, 0x20, 0x49, 0x49, 0x3b, 0x420, 0x430, 0x452, 0x430,
0x431, 0x3b, 0x428, 0x430, 0x2bb, 0x431, 0x430, 0x43d, 0x3b, 0x420, 0x430, 0x43c,
0x430, 0x434, 0x430, 0x43d, 0x3b, 0x428, 0x430, 0x432, 0x430, 0x43b, 0x3b, 0x414,
0x443, 0x2bb, 0x43b, 0x2d, 0x41a, 0x438, 0x2bb, 0x434, 0x430, 0x3b, 0x414, 0x443,
0x2bb, 0x43b, 0x2d, 0x445, 0x438, 0x452, 0x430, 0x41c, 0x443, 0x445, 0x2e, 0x3b,
0x421, 0x430, 0x444, 0x2e, 0x3b, 0x420, 0x435, 0x431, 0x2e, 0x20, 0x31, 0x3b,
0x420, 0x435, 0x431, 0x2e, 0x20, 0x32, 0x3b, 0x40f, 0x443, 0x43c, 0x2e, 0x20,
0x31, 0x3b, 0x40f, 0x443, 0x43c, 0x2e, 0x20, 0x32, 0x3b, 0x420, 0x435, 0x45f,
0x2e, 0x3b, 0x428, 0x430, 0x2e, 0x3b, 0x420, 0x430, 0x43c, 0x2e, 0x3b, 0x428,
0x435, 0x2e, 0x3b, 0x417, 0x443, 0x43b, 0x2d, 0x43a, 0x2e, 0x3b, 0x417, 0x443,
0x43b, 0x2d, 0x445, 0x2e, 0x43c, 0x443, 0x445, 0x430, 0x440, 0x430, 0x43c, 0x3b,
0x441, 0x430, 0x444, 0x430, 0x440, 0x3b, 0x440, 0x430, 0x431, 0x438, 0x2d, 0x31,
0x3b, 0x440, 0x430, 0x431, 0x438, 0x2d, 0x32, 0x3b, 0x434, 0x436, 0x443, 0x43c,
0x430, 0x434, 0x430, 0x2d, 0x31, 0x3b, 0x434, 0x436, 0x443, 0x43c, 0x430, 0x434,
0x430, 0x2d, 0x32, 0x3b, 0x440, 0x430, 0x434, 0x436, 0x430, 0x431, 0x3b, 0x448,
0x430, 0x431, 0x430, 0x43d, 0x3b, 0x440, 0x430, 0x43c, 0x430, 0x437, 0x430, 0x43d,
0x3b, 0x428, 0x430, 0x432, 0x430, 0x43b, 0x3b, 0x414, 0x445, 0x443, 0x43b, 0x2d,
0x41a, 0x430, 0x430, 0x434, 0x430, 0x3b, 0x414, 0x445, 0x443, 0x43b, 0x2d, 0x445,
0x438, 0x434, 0x436, 0x430, 0x7a46, 0x54c8, 0x862d, 0x59c6, 0x6708, 0x3b, 0x8272, 0x6cd5,
0x723e, 0x6708, 0x3b, 0x8cf4, 0x6bd4, 0x6708, 0x20, 0x49, 0x3b, 0x8cf4, 0x6bd4, 0x6708,
0x20, 0x49, 0x49, 0x3b, 0x4e3b, 0x99ac, 0x9054, 0x6708, 0x20, 0x49, 0x3b, 0x4e3b,
0x99ac, 0x9054, 0x6708, 0x20, 0x49, 0x49, 0x3b, 0x8cf4, 0x54f2, 0x535c, 0x6708, 0x3b,
0x820d, 0x723e, 0x90a6, 0x6708, 0x3b, 0x8cf4, 0x8cb7, 0x4e39, 0x6708, 0x3b, 0x9583, 0x74e6,
0x9b6f, 0x6708, 0x3b, 0x90fd, 0x723e, 0x5580, 0x723e, 0x5fb7, 0x6708, 0x3b, 0x90fd, 0x723e,
0x9ed1, 0x54f2, 0x6708, 0x7a46, 0x54c8, 0x5170, 0x59c6, 0x6708, 0x3b, 0x8272, 0x6cd5, 0x5c14,
0x6708, 0x3b, 0x8d56, 0x6bd4, 0x6708, 0x20, 0x49, 0x3b, 0x8d56, 0x6bd4, 0x6708, 0x20,
0x49, 0x49, 0x3b, 0x4e3b, 0x9a6c, 0x8fbe, 0x6708, 0x20, 0x49, 0x3b, 0x4e3b, 0x9a6c,
0x8fbe, 0x6708, 0x20, 0x49, 0x49, 0x3b, 0x8d56, 0x54f2, 0x535c, 0x6708, 0x3b, 0x820d,
0x5c14, 0x90a6, 0x6708, 0x3b, 0x8d56, 0x4e70, 0x4e39, 0x6708, 0x3b, 0x95ea, 0x74e6, 0x9c81,
0x6708, 0x3b, 0x90fd, 0x5c14, 0x5580, 0x5c14, 0x5fb7, 0x6708, 0x3b, 0x90fd, 0x5c14, 0x9ed1,
0x54f2, 0x6708, 0x645, 0x648, 0x62d, 0x6d5, 0x631, 0x6d5, 0x645, 0x3b, 0x633, 0x6d5,
0x641, 0x6d5, 0x631, 0x3b, 0x631, 0x6d5, 0x628, 0x6cc, 0x639, 0x6cc, 0x20, 0x6cc,
0x6d5, 0x6a9, 0x6d5, 0x645, 0x3b, 0x695, 0x6d5, 0x628, 0x6cc, 0x639, 0x6cc, 0x20,
0x62f, 0x648, 0x648, 0x6d5, 0x645, 0x3b, 0x62c, 0x6d5, 0x645, 0x627, 0x62f, 0x6cc,
0x20, 0x6cc, 0x6d5, 0x6a9, 0x6d5, 0x645, 0x3b, 0x62c, 0x6d5, 0x645, 0x627, 0x62f,
0x6cc, 0x20, 0x62f, 0x648, 0x648, 0x6d5, 0x645, 0x3b, 0x695, 0x6d5, 0x62c, 0x6d5,
0x628, 0x3b, 0x634, 0x6d5, 0x639, 0x628, 0x627, 0x646, 0x3b, 0x695, 0x6d5, 0x645,
0x6d5, 0x632, 0x627, 0x646, 0x3b, 0x634, 0x6d5, 0x648, 0x627, 0x644, 0x3b, 0x632,
0x648, 0x644, 0x642, 0x6d5, 0x639, 0x62f, 0x6d5, 0x3b, 0x632, 0x648, 0x644, 0x62d,
0x62c, 0x6d5, 0xd804, 0xdd1f, 0xd804, 0xdd27, 0xd804, 0xdd26, 0xd804, 0xdd27, 0xd804, 0xdd22,
0xd804, 0xdd27, 0xd804, 0xdd1f, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd25, 0xd804, 0xdd27, 0xd804,
0xdd1c, 0xd804, 0xdd22, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd22, 0xd804, 0xdd27, 0xd804, 0xdd1d,
0xd804, 0xdd28, 0xd804, 0xdd05, 0xd804, 0xdd23, 0xd804, 0xdd34, 0x20, 0xd804, 0xdd03, 0xd804,
0xdd03, 0xd804, 0xdd2a, 0xd804, 0xdd20, 0xd804, 0xdd23, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd22,
0xd804, 0xdd27, 0xd804, 0xdd1d, 0xd804, 0xdd28, 0xd804, 0xdd05, 0xd804, 0xdd25, 0xd804, 0xdd34,
0x20, 0xd804, 0xdd25, 0xd804, 0xdd1a, 0xd804, 0xdd28, 0x3b, 0xd804, 0xdd0e, 0xd804, 0xdd27,
0xd804, 0xdd1f, 0xd804, 0xdd18, 0xd804, 0xdd28, 0xd804, 0xdd05, 0xd804, 0xdd23, 0xd804, 0xdd34,
0x20, 0xd804, 0xdd03, 0xd804, 0xdd03, 0xd804, 0xdd2a, 0xd804, 0xdd20, 0xd804, 0xdd23, 0xd804,
0xdd34, 0x3b, 0xd804, 0xdd0e, 0xd804, 0xdd27, 0xd804, 0xdd1f, 0xd804, 0xdd18, 0xd804, 0xdd28,
0xd804, 0xdd05, 0xd804, 0xdd0c, 0xd804, 0xdd34, 0x20, 0xd804, 0xdd25, 0xd804, 0xdd1a, 0xd804,
0xdd28, 0x3b, 0xd804, 0xdd22, 0xd804, 0xdd27, 0xd804, 0xdd0e, 0xd804, 0xdd27, 0xd804, 0xdd1d,
0xd804, 0xdd34, 0x3b, 0xd804, 0xdd25, 0xd804, 0xdd33, 0xd804, 0xdd03, 0xd804, 0xdd1d, 0xd804,
0xdd27, 0xd804, 0xdd1a, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd22, 0xd804, 0xdd27, 0xd804, 0xdd1f,
0xd804, 0xdd34, 0xd804, 0xdd0e, 0xd804, 0xdd1a, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd25, 0xd804,
0xdd24, 0xd804, 0xdd23, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd0e, 0xd804, 0xdd28, 0xd804, 0xdd23,
0xd804, 0xdd34, 0xd804, 0xdd07, 0xd804, 0xdd27, 0xd804, 0xdd18, 0xd804, 0xdd34, 0x3b, 0xd804,
0xdd0e, 0xd804, 0xdd28, 0xd804, 0xdd23, 0xd804, 0xdd34, 0xd804, 0xdd26, 0xd804, 0xdd27, 0xd804,
0xdd0e, 0xd804, 0xdd34, 0xd804, 0xdd0e, 0xd804, 0xdd27, 0xd804, 0xdd37, 0x3b, 0xd804, 0xdd38,
0x3b, 0xd804, 0xdd39, 0x3b, 0xd804, 0xdd3a, 0x3b, 0xd804, 0xdd3b, 0x3b, 0xd804, 0xdd3c,
0x3b, 0xd804, 0xdd3d, 0x3b, 0xd804, 0xdd3e, 0x3b, 0xd804, 0xdd3f, 0x3b, 0xd804, 0xdd37,
0xd804, 0xdd36, 0x3b, 0xd804, 0xdd37, 0xd804, 0xdd37, 0x3b, 0xd804, 0xdd37, 0xd804, 0xdd38,
0x4e00, 0x6708, 0x3b, 0x4e8c, 0x6708, 0x3b, 0x4e09, 0x6708, 0x3b, 0x56db, 0x6708, 0x3b,
0x4e94, 0x6708, 0x3b, 0x516d, 0x6708, 0x3b, 0x4e03, 0x6708, 0x3b, 0x516b, 0x6708, 0x3b,
0x4e5d, 0x6708, 0x3b, 0x5341, 0x6708, 0x3b, 0x5341, 0x4e00, 0x6708, 0x3b, 0x5341, 0x4e8c,
0x6708, 0x31, 0x6708, 0x3b, 0x32, 0x6708, 0x3b, 0x33, 0x6708, 0x3b, 0x34, 0x6708,
0x3b, 0x35, 0x6708, 0x3b, 0x36, 0x6708, 0x3b, 0x37, 0x6708, 0x3b, 0x38, 0x6708,
0x3b, 0x39, 0x6708, 0x3b, 0x31, 0x30, 0x6708, 0x3b, 0x31, 0x31, 0x6708, 0x3b,
0x31, 0x32, 0x6708, 0x43c, 0x443, 0x445, 0x430, 0x440, 0x440, 0x430, 0x43c, 0x3b,
0x441, 0x430, 0x444, 0x430, 0x440, 0x3b, 0x440, 0x430, 0x431, 0x438, 0x2d, 0x443,
0x43b, 0x44c, 0x2d, 0x430, 0x432, 0x432, 0x430, 0x43b, 0x44c, 0x3b, 0x440, 0x430,
0x431, 0x438, 0x2d, 0x443, 0x43b, 0x44c, 0x2d, 0x430, 0x445, 0x438, 0x440, 0x3b,
0x434, 0x436, 0x443, 0x43c, 0x430, 0x434, 0x2d, 0x443, 0x43b, 0x44c, 0x2d, 0x430,
0x432, 0x432, 0x430, 0x43b, 0x44c, 0x3b, 0x434, 0x436, 0x443, 0x43c, 0x430, 0x434,
0x2d, 0x443, 0x43b, 0x44c, 0x2d, 0x430, 0x445, 0x438, 0x440, 0x3b, 0x440, 0x430,
0x434, 0x436, 0x430, 0x431, 0x3b, 0x448, 0x430, 0x430, 0x431, 0x430, 0x43d, 0x3b,
0x440, 0x430, 0x43c, 0x430, 0x434, 0x430, 0x43d, 0x3b, 0x448, 0x430, 0x432, 0x432,
0x430, 0x43b, 0x44c, 0x3b, 0x437, 0x443, 0x43b, 0x44c, 0x2d, 0x43a, 0x430, 0x430,
0x434, 0x430, 0x3b, 0x437, 0x443, 0x43b, 0x44c, 0x2d, 0x445, 0x438, 0x434, 0x436,
0x436, 0x430, 0x43c, 0x443, 0x445, 0x2e, 0x3b, 0x441, 0x430, 0x444, 0x2e, 0x3b,
0x440, 0x430, 0x431, 0x2e, 0x20, 0x49, 0x3b, 0x440, 0x430, 0x431, 0x2e, 0x20,
0x49, 0x49, 0x3b, 0x434, 0x436, 0x443, 0x43c, 0x2e, 0x20, 0x49, 0x3b, 0x434,
0x436, 0x443, 0x43c, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x440, 0x430, 0x434, 0x436,
0x2e, 0x3b, 0x448, 0x430, 0x430, 0x431, 0x2e, 0x3b, 0x440, 0x430, 0x43c, 0x2e,
0x3b, 0x448, 0x430, 0x432, 0x2e, 0x3b, 0x437, 0x443, 0x43b, 0x44c, 0x2d, 0x43a,
0x2e, 0x3b, 0x437, 0x443, 0x43b, 0x44c, 0x2d, 0x445, 0x2e, 0x2c99, 0x2c9f, 0x2ca9,
0x3e9, 0x2c81, 0x2ca3, 0x2ca3, 0x2c81, 0x2c99, 0x3b, 0x2ca5, 0x2c81, 0x3e5, 0x2c81, 0x2ca3,
0x3b, 0x2ca3, 0x2c81, 0x2c83, 0x2c93, 0x2bb, 0x20, 0x49, 0x3b, 0x2ca3, 0x2c81, 0x2c83,
0x2c93, 0x2bb, 0x20, 0x49, 0x49, 0x3b, 0x3eb, 0x2c9f, 0x2ca9, 0x2c99, 0x2c81, 0x2c87,
0x2c81, 0x20, 0x49, 0x3b, 0x3eb, 0x2c9f, 0x2ca9, 0x2c99, 0x2c81, 0x2c87, 0x2c81, 0x20,
0x49, 0x49, 0x3b, 0x2ca3, 0x2c81, 0x3eb, 0x2c81, 0x2c83, 0x3b, 0x3e3, 0x2c81, 0x2bb,
0x2c83, 0x2c81, 0x2c9b, 0x3b, 0x2ca3, 0x2c81, 0x2c99, 0x2c81, 0x2c87, 0x2c81, 0x2c9b, 0x3b,
0x3e3, 0x2c81, 0x2c9f, 0x2ca9, 0x2c81, 0x2c97, 0x3b, 0x2c87, 0x2c9f, 0x2ca9, 0x2c97, 0x2d,
0x2c95, 0x2c93, 0x2bb, 0x2c87, 0x2c81, 0x3e9, 0x3b, 0x2c87, 0x2c9f, 0x2ca9, 0x2c97, 0x2d,
0x3e9, 0x2c93, 0x3eb, 0x3eb, 0x2c81, 0x2c99, 0x2c9f, 0x2ca9, 0x3e9, 0x2e, 0x3b, 0x2ca5,
0x2c81, 0x3e5, 0x2e, 0x3b, 0x2ca3, 0x2c81, 0x2c83, 0x2e, 0x20, 0x49, 0x3b, 0x2ca3,
0x2c81, 0x2c83, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x3eb, 0x2c9f, 0x2ca9, 0x2c99, 0x2e,
0x20, 0x49, 0x3b, 0x3eb, 0x2c9f, 0x2ca9, 0x2c99, 0x2e, 0x20, 0x49, 0x49, 0x3b,
0x2ca3, 0x2c81, 0x3eb, 0x2e, 0x3b, 0x3e3, 0x2c81, 0x2e, 0x3b, 0x2ca3, 0x2c81, 0x2c99,
0x2e, 0x3b, 0x3e3, 0x2c81, 0x2ca9, 0x2e, 0x3b, 0x2c87, 0x2c9f, 0x2ca9, 0x2c97, 0x2d,
0x2c95, 0x2e, 0x3b, 0x2c87, 0x2c9f, 0x2ca9, 0x2c97, 0x2d, 0x3e9, 0x2e, 0x2c81, 0x305,
0x3b, 0x2c83, 0x305, 0x3b, 0x2c85, 0x305, 0x3b, 0x2c87, 0x305, 0x3b, 0x2c89, 0x305,
0x3b, 0x2c8b, 0x305, 0x3b, 0x2c8d, 0x305, 0x3b, 0x2c8f, 0x305, 0x3b, 0x2c91, 0x305,
0x3b, 0x2c93, 0x305, 0x3b, 0x2c93, 0x305, 0x2c81, 0x305, 0x3b, 0x2c93, 0x305, 0x2c83,
0x305, 0x31, 0x2e, 0x3b, 0x32, 0x2e, 0x3b, 0x33, 0x2e, 0x3b, 0x34, 0x2e,
0x3b, 0x35, 0x2e, 0x3b, 0x36, 0x2e, 0x3b, 0x37, 0x2e, 0x3b, 0x38, 0x2e,
0x3b, 0x39, 0x2e, 0x3b, 0x31, 0x30, 0x2e, 0x3b, 0x31, 0x31, 0x2e, 0x3b,
0x31, 0x32, 0x2e, 0x6d, 0x75, 0x68, 0x61, 0x72, 0x72, 0x65, 0x6d, 0x3b,
0x73, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x72, 0x65, 0x62, 0xed, 0x2019, 0x75,
0x20, 0x6c, 0x2d, 0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b, 0x72, 0x65, 0x62,
0xed, 0x2019, 0x75, 0x20, 0x73, 0x2d, 0x73, 0xe1, 0x6e, 0xed, 0x3b, 0x64,
0x17e, 0x75, 0x6d, 0xe1, 0x64, 0xe1, 0x20, 0x61, 0x6c, 0x2d, 0xfa, 0x6c,
0xe1, 0x3b, 0x64, 0x17e, 0x75, 0x6d, 0xe1, 0x64, 0xe1, 0x20, 0x61, 0x6c,
0x2d, 0xe1, 0x63, 0x68, 0x69, 0x72, 0x61, 0x3b, 0x72, 0x65, 0x64, 0x17e,
0x65, 0x62, 0x3b, 0x161, 0x61, 0x2019, 0x62, 0xe1, 0x6e, 0x3b, 0x72, 0x61,
0x6d, 0x61, 0x64, 0xe1, 0x6e, 0x3b, 0x161, 0x61, 0x77, 0x77, 0x61, 0x6c,
0x3b, 0x7a, 0xfa, 0x20, 0x6c, 0x2d, 0x6b, 0x61, 0x2019, 0x64, 0x61, 0x3b,
0x7a, 0xfa, 0x20, 0x6c, 0x2d, 0x68, 0x69, 0x64, 0x17e, 0x64, 0x17e, 0x61,
0x6d, 0x75, 0x68, 0x2e, 0x3b, 0x73, 0x61, 0x66, 0x2e, 0x3b, 0x72, 0x65,
0x62, 0x2e, 0x20, 0x49, 0x3b, 0x72, 0x65, 0x62, 0x2e, 0x20, 0x49, 0x49,
0x3b, 0x64, 0x17e, 0x75, 0x6d, 0x2e, 0x20, 0x49, 0x3b, 0x64, 0x17e, 0x75,
0x6d, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x72, 0x65, 0x64, 0x2e, 0x3b, 0x161,
0x61, 0x2e, 0x3b, 0x72, 0x61, 0x6d, 0x2e, 0x3b, 0x161, 0x61, 0x77, 0x2e,
0x3b, 0x7a, 0xfa, 0x20, 0x6c, 0x2d, 0x6b, 0x2e, 0x3b, 0x7a, 0xfa, 0x20,
0x6c, 0x2d, 0x68, 0x2e, 0x6d, 0x75, 0x68, 0x61, 0x72, 0x72, 0x61, 0x6d,
0x3b, 0x73, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x72, 0x61, 0x62, 0x69, 0x2bb,
0x20, 0x49, 0x3b, 0x72, 0x61, 0x62, 0x69, 0x2bb, 0x20, 0x49, 0x49, 0x3b,
0x6a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x49, 0x3b, 0x6a, 0x75, 0x6d,
0x61, 0x64, 0x61, 0x20, 0x49, 0x49, 0x3b, 0x72, 0x61, 0x6a, 0x61, 0x62,
0x3b, 0x73, 0x68, 0x61, 0x2bb, 0x62, 0x61, 0x6e, 0x3b, 0x72, 0x61, 0x6d,
0x61, 0x64, 0x61, 0x6e, 0x3b, 0x73, 0x68, 0x61, 0x77, 0x77, 0x61, 0x6c,
0x3b, 0x64, 0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x51, 0x69, 0x2bb, 0x64, 0x61,
0x68, 0x3b, 0x64, 0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x48, 0x69, 0x6a, 0x6a,
0x61, 0x68, 0x4d, 0x6f, 0x65, 0x68, 0x61, 0x72, 0x72, 0x61, 0x6d, 0x3b,
0x53, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x2bb, 0x61,
0x20, 0x61, 0x6c, 0x20, 0x61, 0x77, 0x61, 0x6c, 0x3b, 0x52, 0x61, 0x62,
0x69, 0x2bb, 0x61, 0x20, 0x61, 0x6c, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x69,
0x3b, 0x4a, 0x6f, 0x65, 0x6d, 0x61, 0x64, 0x2bb, 0x61, 0x6c, 0x20, 0x61,
0x77, 0x61, 0x6c, 0x3b, 0x4a, 0x6f, 0x65, 0x6d, 0x61, 0x64, 0x2bb, 0x61,
0x6c, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x69, 0x3b, 0x52, 0x61, 0x6a, 0x61,
0x62, 0x3b, 0x53, 0x6a, 0x61, 0x2bb, 0x61, 0x62, 0x61, 0x6e, 0x3b, 0x52,
0x61, 0x6d, 0x61, 0x64, 0x61, 0x6e, 0x3b, 0x53, 0x6a, 0x61, 0x77, 0x61,
0x6c, 0x3b, 0x44, 0x6f, 0x65, 0x20, 0x61, 0x6c, 0x20, 0x6b, 0x61, 0x2bb,
0x61, 0x62, 0x61, 0x3b, 0x44, 0x6f, 0x65, 0x20, 0x61, 0x6c, 0x20, 0x68,
0x69, 0x7a, 0x6a, 0x61, 0x4d, 0x6f, 0x65, 0x68, 0x2e, 0x3b, 0x53, 0x61,
0x66, 0x2e, 0x3b, 0x52, 0x61, 0x62, 0x2e, 0x20, 0x49, 0x3b, 0x52, 0x61,
0x62, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x4a, 0x6f, 0x65, 0x6d, 0x2e, 0x20,
0x49, 0x3b, 0x4a, 0x6f, 0x65, 0x6d, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x52,
0x61, 0x6a, 0x2e, 0x3b, 0x53, 0x6a, 0x61, 0x2e, 0x3b, 0x52, 0x61, 0x6d,
0x2e, 0x3b, 0x53, 0x6a, 0x61, 0x77, 0x2e, 0x3b, 0x44, 0x6f, 0x65, 0x20,
0x61, 0x6c, 0x20, 0x6b, 0x2e, 0x3b, 0x44, 0x6f, 0x65, 0x20, 0x61, 0x6c,
0x20, 0x68, 0x2e, 0x64, 0x7a, 0x6f, 0x76, 0x65, 0x3b, 0x64, 0x7a, 0x6f,
0x64, 0x7a, 0x65, 0x3b, 0x74, 0x65, 0x64, 0x6f, 0x78, 0x65, 0x3b, 0x61,
0x66, 0x254, 0x66, 0x69, 0x1ebd, 0x3b, 0x64, 0x61, 0x6d, 0x25b, 0x3b, 0x6d,
0x61, 0x73, 0x61, 0x3b, 0x73, 0x69, 0x61, 0x6d, 0x6c, 0x254, 0x6d, 0x3b,
0x64, 0x65, 0x61, 0x73, 0x69, 0x61, 0x6d, 0x69, 0x6d, 0x65, 0x3b, 0x61,
0x6e, 0x79, 0x254, 0x6e, 0x79, 0x254, 0x3b, 0x6b, 0x65, 0x6c, 0x65, 0x3b,
0x61, 0x64, 0x65, 0x25b, 0x6d, 0x65, 0x6b, 0x70, 0x254, 0x78, 0x65, 0x3b,
0x64, 0x7a, 0x6f, 0x6d, 0x65, 0x64, 0x7a, 0x76, 0x3b, 0x64, 0x7a, 0x64,
0x3b, 0x74, 0x65, 0x64, 0x3b, 0x61, 0x66, 0x254, 0x3b, 0x64, 0x61, 0x6d,
0x3b, 0x6d, 0x61, 0x73, 0x3b, 0x73, 0x69, 0x61, 0x3b, 0x64, 0x65, 0x61,
0x3b, 0x61, 0x6e, 0x79, 0x3b, 0x6b, 0x65, 0x6c, 0x3b, 0x61, 0x64, 0x65,
0x3b, 0x64, 0x7a, 0x6d, 0x6d, 0x75, 0x68, 0x61, 0x72, 0x72, 0x61, 0x6d,
0x3b, 0x73, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x72, 0x61, 0x62, 0x69, 0x2019,
0x20, 0x61, 0x6c, 0x2d, 0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b, 0x72, 0x61,
0x62, 0x69, 0x2019, 0x20, 0x61, 0x6c, 0x2d, 0x61, 0x6b, 0x68, 0x69, 0x72,
0x3b, 0x64, 0x17e, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x2d, 0x6c, 0x2d, 0x75,
0x6c, 0x61, 0x3b, 0x64, 0x17e, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x2d, 0x6c,
0x2d, 0x61, 0x6b, 0x68, 0x69, 0x72, 0x61, 0x3b, 0x72, 0x61, 0x64, 0x17e,
0x61, 0x62, 0x3b, 0x161, 0x61, 0x2019, 0x62, 0x61, 0x6e, 0x3b, 0x72, 0x61,
0x6d, 0x61, 0x64, 0x61, 0x6e, 0x3b, 0x161, 0x61, 0x77, 0x77, 0x61, 0x6c,
0x3b, 0x64, 0x68, 0x75, 0x2d, 0x6c, 0x2d, 0x71, 0x61, 0x2019, 0x64, 0x61,
0x3b, 0x64, 0x68, 0x75, 0x2d, 0x6c, 0x2d, 0x68, 0x69, 0x64, 0x64, 0x17e,
0x61, 0x6d, 0x6f, 0x75, 0x68, 0x61, 0x72, 0x72, 0x61, 0x6d, 0x3b, 0x73,
0x61, 0x66, 0x61, 0x72, 0x3b, 0x72, 0x61, 0x62, 0x69, 0x61, 0x20, 0x61,
0x6c, 0x20, 0x61, 0x77, 0x61, 0x6c, 0x3b, 0x72, 0x61, 0x62, 0x69, 0x61,
0x20, 0x61, 0x74, 0x68, 0x2d, 0x74, 0x68, 0x61, 0x6e, 0x69, 0x3b, 0x6a,
0x6f, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x61, 0x6c, 0x20, 0x6f, 0x75,
0x6c, 0x61, 0x3b, 0x6a, 0x6f, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x61,
0x74, 0x68, 0x2d, 0x74, 0x68, 0x61, 0x6e, 0x69, 0x61, 0x3b, 0x72, 0x61,
0x6a, 0x61, 0x62, 0x3b, 0x63, 0x68, 0x61, 0x61, 0x62, 0x61, 0x6e, 0x65,
0x3b, 0x72, 0x61, 0x6d, 0x61, 0x64, 0x61, 0x6e, 0x3b, 0x63, 0x68, 0x61,
0x77, 0x77, 0x61, 0x6c, 0x3b, 0x64, 0x68, 0x6f, 0x75, 0x20, 0x61, 0x6c,
0x20, 0x71, 0x69, 0x60, 0x64, 0x61, 0x3b, 0x64, 0x68, 0x6f, 0x75, 0x20,
0x61, 0x6c, 0x2d, 0x68, 0x69, 0x6a, 0x6a, 0x61, 0x6d, 0x6f, 0x75, 0x68,
0x2e, 0x3b, 0x73, 0x61, 0x66, 0x2e, 0x3b, 0x72, 0x61, 0x62, 0x2e, 0x20,
0x61, 0x77, 0x2e, 0x3b, 0x72, 0x61, 0x62, 0x2e, 0x20, 0x74, 0x68, 0x2e,
0x3b, 0x6a, 0x6f, 0x75, 0x6d, 0x2e, 0x20, 0x6f, 0x75, 0x2e, 0x3b, 0x6a,
0x6f, 0x75, 0x6d, 0x2e, 0x20, 0x74, 0x68, 0x2e, 0x3b, 0x72, 0x61, 0x6a,
0x2e, 0x3b, 0x63, 0x68, 0x61, 0x61, 0x2e, 0x3b, 0x72, 0x61, 0x6d, 0x2e,
0x3b, 0x63, 0x68, 0x61, 0x77, 0x2e, 0x3b, 0x64, 0x68, 0x6f, 0x75, 0x2e,
0x20, 0x71, 0x69, 0x2e, 0x3b, 0x64, 0x68, 0x6f, 0x75, 0x2e, 0x20, 0x68,
0x69, 0x2e, 0x6d, 0x6f, 0x75, 0x68, 0x2e, 0x3b, 0x73, 0x61, 0x66, 0x2e,
0x3b, 0x72, 0x61, 0x62, 0x2e, 0x20, 0x61, 0x77, 0x2e, 0x3b, 0x72, 0x61,
0x62, 0x2e, 0x20, 0x74, 0x68, 0x2e, 0x3b, 0x6a, 0x6f, 0x75, 0x6d, 0x2e,
0x20, 0x6f, 0x75, 0x6c, 0x2e, 0x3b, 0x6a, 0x6f, 0x75, 0x6d, 0x2e, 0x20,
0x74, 0x68, 0x61, 0x2e, 0x3b, 0x72, 0x61, 0x6a, 0x2e, 0x3b, 0x63, 0x68,
0x61, 0x61, 0x2e, 0x3b, 0x72, 0x61, 0x6d, 0x2e, 0x3b, 0x63, 0x68, 0x61,
0x77, 0x2e, 0x3b, 0x64, 0x68, 0x6f, 0x75, 0x2e, 0x20, 0x71, 0x2e, 0x3b,
0x64, 0x68, 0x6f, 0x75, 0x2e, 0x20, 0x68, 0x2e, 0xd83a, 0xdd14, 0xd83a, 0xdd2e,
0xd83a, 0xdd25, 0xd83a, 0xdd26, 0xd83a, 0xdd2b, 0xd83a, 0xdd32, 0xd83a, 0xdd3c, 0xd83a, 0xdd2b,
0x3b, 0xd83a, 0xdd05, 0xd83a, 0xdd22, 0xd83a, 0xdd26, 0xd83a, 0xdd46, 0xd83a, 0xdd2e, 0xd83a,
0xdd2a, 0xd83a, 0xdd23, 0xd83a, 0xdd35, 0x2d, 0xd83a, 0xdd06, 0xd83a, 0xdd22, 0xd83a, 0xdd2a,
0xd83a, 0xdd22, 0xd83a, 0xdd32, 0x3b, 0xd83a, 0xdd06, 0xd83a, 0xdd22, 0xd83a, 0xdd2a, 0xd83a,
0xdd22, 0xd83a, 0xdd32, 0x3b, 0xd83a, 0xdd03, 0xd83a, 0xdd2d, 0xd83a, 0xdd25, 0xd83a, 0xdd28,
0xd83a, 0xdd22, 0xd83a, 0xdd2a, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0x3b, 0xd83a, 0xdd04, 0xd83a,
0xdd22, 0xd83a, 0xdd28, 0xd83a, 0xdd46, 0xd83a, 0xdd22, 0xd83a, 0xdd2a, 0xd83a, 0xdd22, 0xd83a,
0xdd32, 0x3b, 0xd83a, 0xdd05, 0xd83a, 0xdd22, 0xd83a, 0xdd26, 0xd83a, 0xdd46, 0xd83a, 0xdd2e,
0xd83a, 0xdd2a, 0xd83a, 0xdd23, 0xd83a, 0xdd35, 0x2d, 0xd83a, 0xdd08, 0xd83a, 0xdd22, 0xd83a,
0xdd44, 0xd83a, 0xdd36, 0xd83a, 0xdd2d, 0xd83a, 0xdd26, 0xd83a, 0xdd2d, 0x3b, 0xd83a, 0xdd08,
0xd83a, 0xdd22, 0xd83a, 0xdd44, 0xd83a, 0xdd36, 0xd83a, 0xdd2d, 0xd83a, 0xdd26, 0xd83a, 0xdd2d,
0x3b, 0xd83a, 0xdd05, 0xd83a, 0xdd22, 0xd83a, 0xdd26, 0xd83a, 0xdd46, 0xd83a, 0xdd2e, 0xd83a,
0xdd2a, 0xd83a, 0xdd23, 0xd83a, 0xdd35, 0x2d, 0xd83a, 0xdd05, 0xd83a, 0xdd35, 0xd83a, 0xdd45,
0xd83a, 0xdd25, 0xd83a, 0xdd22, 0xd83a, 0xdd34, 0xd83a, 0xdd2b, 0xd83a, 0xdd45, 0x3b, 0xd83a,
0xdd05, 0xd83a, 0xdd35, 0xd83a, 0xdd45, 0xd83a, 0xdd25, 0xd83a, 0xdd22, 0xd83a, 0xdd34, 0xd83a,
0xdd2b, 0xd83a, 0xdd45, 0x3b, 0xd83a, 0xdd14, 0xd83a, 0xdd35, 0xd83a, 0xdd45, 0xd83a, 0xdd24,
0xd83a, 0xdd23, 0xd83a, 0xdd22, 0xd83a, 0xdd44, 0xd83a, 0xdd32, 0xd83a, 0xdd4b, 0xd83a, 0xdd23,
0xd83a, 0xdd35, 0x3b, 0xd83a, 0xdd05, 0xd83a, 0xdd22, 0xd83a, 0xdd26, 0xd83a, 0xdd46, 0xd83a,
0xdd2e, 0xd83a, 0xdd2a, 0xd83a, 0xdd23, 0xd83a, 0xdd35, 0x2d, 0xd83a, 0xdd01, 0xd83a, 0xdd2e,
0xd83a, 0xdd32, 0xd83a, 0xdd33, 0xd83a, 0xdd2d, 0xd83a, 0xdd32, 0x3b, 0xd83a, 0xdd01, 0xd83a,
0xdd35, 0xd83a, 0xdd32, 0xd83a, 0xdd33, 0xd83a, 0xdd2d, 0xd83a, 0xdd32, 0xd83a, 0xdd14, 0xd83a,
0xdd2e, 0xd83a, 0xdd26, 0x2e, 0x3b, 0xd83a, 0xdd05, 0xd83a, 0xdd22, 0xd83a, 0xdd28, 0x2e,
0x3b, 0xd83a, 0xdd06, 0xd83a, 0xdd22, 0xd83a, 0xdd2a, 0x2e, 0x3b, 0xd83a, 0xdd03, 0xd83a,
0xdd2d, 0xd83a, 0xdd28, 0x2e, 0x3b, 0xd83a, 0xdd04, 0xd83a, 0xdd22, 0xd83a, 0xdd28, 0x2e,
0x3b, 0xd83a, 0xdd05, 0xd83a, 0xdd22, 0xd83a, 0xdd2a, 0x2e, 0x3b, 0xd83a, 0xdd08, 0xd83a,
0xdd22, 0xd83a, 0xdd36, 0x2e, 0x3b, 0xd83a, 0xdd05, 0xd83a, 0xdd22, 0xd83a, 0xdd27, 0x2e,
0x3b, 0xd83a, 0xdd05, 0xd83a, 0xdd35, 0xd83a, 0xdd25, 0x2e, 0x3b, 0xd83a, 0xdd14, 0xd83a,
0xdd35, 0xd83a, 0xdd24, 0x2e, 0x3b, 0xd83a, 0xdd05, 0xd83a, 0xdd22, 0xd83a, 0xdd23, 0x2e,
0x3b, 0xd83a, 0xdd01, 0xd83a, 0xdd2e, 0xd83a, 0xdd32, 0x2e, 0xd83a, 0xdd51, 0x3b, 0xd83a,
0xdd52, 0x3b, 0xd83a, 0xdd53, 0x3b, 0xd83a, 0xdd54, 0x3b, 0xd83a, 0xdd55, 0x3b, 0xd83a,
0xdd56, 0x3b, 0xd83a, 0xdd57, 0x3b, 0xd83a, 0xdd58, 0x3b, 0xd83a, 0xdd59, 0x3b, 0xd83a,
0xdd51, 0xd83a, 0xdd50, 0x3b, 0xd83a, 0xdd51, 0xd83a, 0xdd51, 0x3b, 0xd83a, 0xdd51, 0xd83a,
0xdd52, 0x10db, 0x10e3, 0x10f0, 0x10d0, 0x10e0, 0x10d0, 0x10db, 0x10d8, 0x3b, 0x10e1, 0x10d0,
0x10e4, 0x10d0, 0x10e0, 0x10d8, 0x3b, 0x10e0, 0x10d0, 0x10d1, 0x10d8, 0x20, 0x10e3, 0x10da,
0x2d, 0x10d0, 0x10d5, 0x10d0, 0x10da, 0x10d8, 0x3b, 0x10e0, 0x10d0, 0x10d1, 0x10d8, 0x20,
0x10e3, 0x10da, 0x2d, 0x10d0, 0x10ee, 0x10d8, 0x10e0, 0x10d8, 0x3b, 0x10ef, 0x10e3, 0x10db,
0x10d0, 0x10d3, 0x10d0, 0x20, 0x10e3, 0x10da, 0x2d, 0x10d0, 0x10d5, 0x10d0, 0x10da, 0x10d8,
0x3b, 0x10ef, 0x10e3, 0x10db, 0x10d0, 0x10d3, 0x10d0, 0x20, 0x10e3, 0x10da, 0x2d, 0x10d0,
0x10ee, 0x10d8, 0x10e0, 0x10d8, 0x3b, 0x10e0, 0x10d0, 0x10ef, 0x10d0, 0x10d1, 0x10d8, 0x3b,
0x10e8, 0x10d0, 0x10d1, 0x10d0, 0x10dc, 0x10d8, 0x3b, 0x10e0, 0x10d0, 0x10db, 0x10d0, 0x10d3,
0x10d0, 0x10dc, 0x10d8, 0x3b, 0x10e8, 0x10d0, 0x10d5, 0x10d0, 0x10da, 0x10d8, 0x3b, 0x10d6,
0x10e3, 0x10da, 0x2d, 0x10d9, 0x10d0, 0x10d0, 0x10d3, 0x10d0, 0x3b, 0x10d6, 0x10e3, 0x10da,
0x2d, 0x10f0, 0x10d8, 0x10ef, 0x10d0, 0x10db, 0x10e3, 0x10f0, 0x2e, 0x3b, 0x10e1, 0x10d0,
0x10e4, 0x2e, 0x3b, 0x10e0, 0x10d0, 0x10d1, 0x2e, 0x20, 0x49, 0x3b, 0x10e0, 0x10d0,
0x10d1, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x10ef, 0x10e3, 0x10db, 0x2e, 0x20, 0x49,
0x3b, 0x10ef, 0x10e3, 0x10db, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x10e0, 0x10d0, 0x10ef,
0x2e, 0x3b, 0x10e8, 0x10d0, 0x10d1, 0x2e, 0x3b, 0x10e0, 0x10d0, 0x10db, 0x2e, 0x3b,
0x10e8, 0x10d0, 0x10d5, 0x2e, 0x3b, 0x10d6, 0x10e3, 0x10da, 0x2d, 0x10d9, 0x2e, 0x3b,
0x10d6, 0x10e3, 0x10da, 0x2d, 0x10f0, 0x2e, 0x4d, 0x75, 0x68, 0x61, 0x72, 0x72,
0x61, 0x6d, 0x3b, 0x53, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x52, 0x61, 0x62,
0x69, 0x2bb, 0x20, 0x49, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x2bb, 0x20, 0x49,
0x49, 0x3b, 0x44, 0x73, 0x63, 0x68, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20,
0x49, 0x3b, 0x44, 0x73, 0x63, 0x68, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20,
0x49, 0x49, 0x3b, 0x52, 0x61, 0x64, 0x73, 0x63, 0x68, 0x61, 0x62, 0x3b,
0x53, 0x68, 0x61, 0x2bb, 0x62, 0x61, 0x6e, 0x3b, 0x52, 0x61, 0x6d, 0x61,
0x64, 0x61, 0x6e, 0x3b, 0x53, 0x68, 0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b,
0x44, 0x68, 0x75, 0x20, 0x6c, 0x2d, 0x71, 0x61, 0x2bf, 0x64, 0x61, 0x3b,
0x44, 0x68, 0x75, 0x20, 0x6c, 0x2d, 0x48, 0x69, 0x64, 0x64, 0x73, 0x63,
0x68, 0x61, 0xaae, 0xac1, 0xab9, 0xab0, 0xacd, 0xab0, 0xaae, 0x3b, 0xab8, 0xaab,
0xab0, 0x3b, 0xab0, 0xabe, 0xaac, 0xac0, 0x2bb, 0x20, 0x49, 0x3b, 0xab0, 0xabe,
0xaac, 0xac0, 0x2bb, 0x20, 0x49, 0x49, 0x3b, 0xa9c, 0xac1, 0xaae, 0xabe, 0xaa6,
0xabe, 0x20, 0x49, 0x3b, 0xa9c, 0xac1, 0xaae, 0xabe, 0xaa6, 0xabe, 0x20, 0x49,
0x49, 0x3b, 0xab0, 0xa9c, 0xaac, 0x3b, 0xab6, 0xabe, 0x2bb, 0xaac, 0xabe, 0xaa8,
0x3b, 0xab0, 0xaae, 0xaa6, 0xabe, 0xaa8, 0x3b, 0xab6, 0xabe, 0xab5, 0xacd, 0xab5,
0xab2, 0x3b, 0xaa7, 0xac1, 0x2bb, 0xab2, 0x2d, 0xa95, 0xacd, 0xab5, 0xac0, 0x2bb,
0xaa1, 0xabe, 0xab9, 0x3b, 0xaa7, 0xac1, 0x2bb, 0xab2, 0x2d, 0xab9, 0xabf, 0xa9c,
0xacd, 0xa9c, 0xabe, 0xab9, 0xaae, 0xac1, 0xab9, 0x2e, 0x3b, 0xab8, 0xaab, 0x2e,
0x3b, 0xab0, 0xaac, 0x2e, 0x49, 0x3b, 0xab0, 0xaac, 0x2e, 0x20, 0x49, 0x49,
0x3b, 0xa9c, 0xac1, 0xaae, 0x2e, 0x20, 0x49, 0x3b, 0xa9c, 0xac1, 0xaae, 0x2e,
0x20, 0x49, 0x49, 0x3b, 0xab0, 0xabe, 0xa9c, 0x2e, 0x3b, 0xab6, 0xabe, 0x2e,
0x3b, 0xab0, 0xabe, 0xaae, 0x2e, 0x3b, 0xab6, 0xabe, 0xab5, 0x2e, 0x3b, 0xaa7,
0xac1, 0x2bb, 0xab2, 0x2d, 0xa95, 0xacd, 0xaaf, 0xac1, 0x2e, 0x3b, 0xaa7, 0xac1,
0x2bb, 0xab2, 0x2d, 0xa8f, 0xa9a, 0x2e, 0x4d, 0x75, 0x68, 0x61, 0x72, 0x72,
0x61, 0x6d, 0x3b, 0x53, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x52, 0x61, 0x62,
0x69, 0x2bb, 0x20, 0x49, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x2bb, 0x20, 0x49,
0x49, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x49, 0x3b, 0x4a,
0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x49, 0x49, 0x3b, 0x52, 0x61, 0x6a,
0x61, 0x62, 0x3b, 0x53, 0x68, 0x61, 0x2bc, 0x61, 0x62, 0x61, 0x6e, 0x3b,
0x52, 0x61, 0x6d, 0x61, 0x64, 0x61, 0x6e, 0x3b, 0x53, 0x68, 0x61, 0x77,
0x77, 0x61, 0x6c, 0x3b, 0x44, 0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x51, 0x69,
0x2bb, 0x64, 0x61, 0x68, 0x3b, 0x44, 0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x48,
0x69, 0x6a, 0x6a, 0x61, 0x68, 0x5de, 0x5d5, 0x5d7, 0x5e8, 0x5dd, 0x3b, 0x5e6,
0x5e4, 0x5e8, 0x3b, 0x5e8, 0x5d1, 0x5d9, 0x5e2, 0x20, 0x5d0, 0x5dc, 0x5be, 0x5d0,
0x5d5, 0x5d5, 0x5dc, 0x3b, 0x5e8, 0x5d1, 0x5d9, 0x5e2, 0x20, 0x5d0, 0x5be, 0x5ea,
0x5f3, 0x5d0, 0x5e0, 0x5d9, 0x3b, 0x5d2, 0x5f3, 0x5d5, 0x5de, 0x5d0, 0x5d3, 0x5d0,
0x20, 0x5d0, 0x5dc, 0x5be, 0x5d0, 0x5d5, 0x5dc, 0x5d0, 0x3b, 0x5d2, 0x5f3, 0x5d5,
0x5de, 0x5d0, 0x5d3, 0x5d0, 0x20, 0x5d0, 0x5be, 0x5ea, 0x5f3, 0x5d0, 0x5e0, 0x5d9,
0x5d4, 0x3b, 0x5e8, 0x5d2, 0x5f3, 0x5d1, 0x3b, 0x5e9, 0x5e2, 0x5d1, 0x5d0, 0x5df,
0x3b, 0x5e8, 0x5de, 0x5d3, 0x5d0, 0x5df, 0x3b, 0x5e9, 0x5d5, 0x5d5, 0x5d0, 0x5dc,
0x3b, 0x5d3, 0x5f3, 0x5d5, 0x20, 0x5d0, 0x5dc, 0x5be, 0x5e7, 0x5e2, 0x5d3, 0x5d4,
0x3b, 0x5d3, 0x5f3, 0x5d5, 0x20, 0x5d0, 0x5dc, 0x5be, 0x5d7, 0x5d9, 0x5d2, 0x5f3,
0x5d4, 0x5de, 0x5d5, 0x5d7, 0x5e8, 0x5dd, 0x3b, 0x5e6, 0x5e4, 0x5e8, 0x3b, 0x5e8,
0x5d1, 0x5d9, 0x5e2, 0x20, 0x5d0, 0x5dc, 0x2d, 0x5d0, 0x5d5, 0x5d5, 0x5dc, 0x3b,
0x5e8, 0x5d1, 0x5d9, 0x5e2, 0x20, 0x5d0, 0x2d, 0x5ea, 0x5f3, 0x5d0, 0x5e0, 0x5d9,
0x3b, 0x5d2, 0x5f3, 0x5d5, 0x5de, 0x5d0, 0x5d3, 0x5d0, 0x20, 0x5d0, 0x5dc, 0x2d,
0x5d0, 0x5d5, 0x5dc, 0x5d0, 0x3b, 0x5d2, 0x5f3, 0x5d5, 0x5de, 0x5d0, 0x5d3, 0x5d0,
0x20, 0x5d0, 0x2d, 0x5ea, 0x5f3, 0x5d0, 0x5e0, 0x5d9, 0x5d4, 0x3b, 0x5e8, 0x5d2,
0x5f3, 0x5d1, 0x3b, 0x5e9, 0x5e2, 0x5d1, 0x5d0, 0x5df, 0x3b, 0x5e8, 0x5de, 0x5d3,
0x5d0, 0x5df, 0x3b, 0x5e9, 0x5d5, 0x5d5, 0x5d0, 0x5dc, 0x3b, 0x5d3, 0x5f3, 0x5d5,
0x20, 0x5d0, 0x5dc, 0x5be, 0x5e7, 0x5e2, 0x5d3, 0x5d4, 0x3b, 0x5d3, 0x5f3, 0x5d5,
0x20, 0x5d0, 0x5dc, 0x5be, 0x5d7, 0x5d9, 0x5d2, 0x5f3, 0x5d4, 0x5de, 0x5d5, 0x5d7,
0x5e8, 0x5dd, 0x3b, 0x5e6, 0x5e4, 0x5e8, 0x3b, 0x5e8, 0x5d1, 0x5d9, 0x5e2, 0x20,
0x5d0, 0x5f3, 0x3b, 0x5e8, 0x5d1, 0x5d9, 0x5e2, 0x20, 0x5d1, 0x5f3, 0x3b, 0x5d2,
0x5f3, 0x5d5, 0x5de, 0x5d0, 0x5d3, 0x5d0, 0x20, 0x5d0, 0x5f3, 0x3b, 0x5d2, 0x5f3,
0x5d5, 0x5de, 0x5d0, 0x5d3, 0x5d0, 0x20, 0x5d1, 0x5f3, 0x3b, 0x5e8, 0x5d2, 0x5f3,
0x5d1, 0x3b, 0x5e9, 0x5e2, 0x5d1, 0x5d0, 0x5df, 0x3b, 0x5e8, 0x5de, 0x5d3, 0x5d0,
0x5df, 0x3b, 0x5e9, 0x5d5, 0x5d5, 0x5d0, 0x5dc, 0x3b, 0x5d3, 0x5f3, 0x5d5, 0x20,
0x5d0, 0x5dc, 0x5be, 0x5e7, 0x5e2, 0x5d3, 0x5d4, 0x3b, 0x5d3, 0x5f3, 0x5d5, 0x20,
0x5d0, 0x5dc, 0x5be, 0x5d7, 0x5d9, 0x5d2, 0x5f3, 0x5d4, 0x92e, 0x941, 0x939, 0x930,
0x94d, 0x930, 0x92e, 0x3b, 0x938, 0x92b, 0x930, 0x3b, 0x930, 0x93e, 0x92c, 0x940,
0x20, 0x92a, 0x94d, 0x930, 0x925, 0x92e, 0x3b, 0x930, 0x93e, 0x92c, 0x940, 0x20,
0x926, 0x94d, 0x935, 0x93f, 0x924, 0x940, 0x92f, 0x3b, 0x91c, 0x941, 0x92e, 0x94d,
0x921, 0x93e, 0x20, 0x92a, 0x94d, 0x930, 0x925, 0x92e, 0x3b, 0x91c, 0x941, 0x92e,
0x94d, 0x921, 0x93e, 0x20, 0x926, 0x94d, 0x935, 0x93f, 0x924, 0x940, 0x92f, 0x3b,
0x930, 0x91c, 0x92c, 0x3b, 0x936, 0x93e, 0x935, 0x928, 0x3b, 0x930, 0x92e, 0x91c,
0x93e, 0x928, 0x3b, 0x936, 0x935, 0x94d, 0x935, 0x94d, 0x932, 0x3b, 0x91c, 0x93f,
0x932, 0x2d, 0x915, 0x94d, 0x926, 0x93e, 0x939, 0x3b, 0x91c, 0x93f, 0x932, 0x94d,
0x2d, 0x939, 0x93f, 0x91c, 0x94d, 0x91c, 0x93e, 0x939, 0x4d, 0x75, 0x68, 0x61,
0x72, 0x72, 0x61, 0x6d, 0x3b, 0x53, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x52,
0x61, 0x62, 0x69, 0x20, 0x61, 0x6c, 0x2d, 0x41, 0x77, 0x77, 0x61, 0x6c,
0x3b, 0x52, 0x61, 0x62, 0x69, 0x20, 0x61, 0x73, 0x2d, 0x53, 0x61, 0x61,
0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x64, 0x61, 0x20, 0x61,
0x6c, 0x2d, 0x41, 0x77, 0x77, 0x61, 0x6c, 0x3b, 0x4a, 0x75, 0x6d, 0x61,
0x61, 0x64, 0x61, 0x20, 0x61, 0x73, 0x2d, 0x53, 0x61, 0x61, 0x6e, 0x69,
0x3b, 0x52, 0x61, 0x6a, 0x61, 0x62, 0x3b, 0x53, 0x68, 0x61, 0x61, 0x62,
0x61, 0x61, 0x6e, 0x3b, 0x52, 0x61, 0x6d, 0x7a, 0x61, 0x61, 0x6e, 0x3b,
0x53, 0x68, 0x61, 0x77, 0x77, 0x61, 0x61, 0x6c, 0x3b, 0x5a, 0x75, 0x2019,
0x6c, 0x2d, 0x51, 0x61, 0x61, 0x64, 0x61, 0x3b, 0x5a, 0x75, 0x2019, 0x6c,
0x2d, 0x48, 0x69, 0x6a, 0x6a, 0x61, 0x4d, 0x75, 0x68, 0x3b, 0x53, 0x61,
0x66, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x20, 0x31, 0x3b, 0x52, 0x61, 0x62,
0x69, 0x20, 0x32, 0x3b, 0x4a, 0x75, 0x6d, 0x20, 0x31, 0x3b, 0x4a, 0x75,
0x6d, 0x20, 0x32, 0x3b, 0x52, 0x61, 0x6a, 0x61, 0x62, 0x3b, 0x53, 0x68,
0x61, 0x62, 0x3b, 0x52, 0x61, 0x6d, 0x3b, 0x53, 0x68, 0x61, 0x77, 0x3b,
0x5a, 0x75, 0x20, 0x51, 0x3b, 0x5a, 0x75, 0x20, 0x48, 0x4d, 0x6f, 0x68,
0x61, 0x72, 0x72, 0x65, 0x6d, 0x3b, 0x53, 0x61, 0x66, 0x61, 0x72, 0x3b,
0x52, 0xe9, 0x62, 0x69, 0x20, 0x49, 0x3b, 0x52, 0xe9, 0x62, 0x69, 0x20,
0x49, 0x49, 0x3b, 0x44, 0x73, 0x65, 0x6d, 0xe1, 0x64, 0x69, 0x20, 0x49,
0x3b, 0x44, 0x73, 0x65, 0x6d, 0xe1, 0x64, 0x69, 0x20, 0x49, 0x49, 0x3b,
0x52, 0x65, 0x64, 0x73, 0x65, 0x62, 0x3b, 0x53, 0x61, 0x62, 0xe1, 0x6e,
0x3b, 0x52, 0x61, 0x6d, 0x61, 0x64, 0xe1, 0x6e, 0x3b, 0x53, 0x65, 0x76,
0x76, 0xe1, 0x6c, 0x3b, 0x44, 0x73, 0xfc, 0x6c, 0x20, 0x6b, 0x61, 0x64,
0x65, 0x3b, 0x44, 0x73, 0xfc, 0x6c, 0x20, 0x68, 0x65, 0x64, 0x73, 0x65,
0x4d, 0x6f, 0x68, 0x61, 0x72, 0x72, 0x65, 0x6d, 0x3b, 0x53, 0x61, 0x66,
0x61, 0x72, 0x3b, 0x52, 0xe9, 0x62, 0x69, 0x20, 0x65, 0x6c, 0x20, 0x61,
0x76, 0x76, 0x65, 0x6c, 0x3b, 0x52, 0xe9, 0x62, 0x69, 0x20, 0x65, 0x6c,
0x20, 0x61, 0x63, 0x63, 0x68, 0x65, 0x72, 0x3b, 0x44, 0x73, 0x65, 0x6d,
0xe1, 0x64, 0x69, 0x20, 0x65, 0x6c, 0x20, 0x61, 0x76, 0x76, 0x65, 0x6c,
0x3b, 0x44, 0x73, 0x65, 0x6d, 0xe1, 0x64, 0x69, 0x20, 0x65, 0x6c, 0x20,
0x61, 0x63, 0x63, 0x68, 0x65, 0x72, 0x3b, 0x52, 0x65, 0x64, 0x73, 0x65,
0x62, 0x3b, 0x53, 0x61, 0x62, 0xe1, 0x6e, 0x3b, 0x52, 0x61, 0x6d, 0x61,
0x64, 0xe1, 0x6e, 0x3b, 0x53, 0x65, 0x76, 0x76, 0xe1, 0x6c, 0x3b, 0x44,
0x73, 0xfc, 0x6c, 0x20, 0x6b, 0x61, 0x64, 0x65, 0x3b, 0x44, 0x73, 0xfc,
0x6c, 0x20, 0x68, 0x65, 0x64, 0x73, 0x65, 0x4d, 0x6f, 0x68, 0x2e, 0x3b,
0x53, 0x61, 0x66, 0x2e, 0x3b, 0x52, 0xe9, 0x62, 0x2e, 0x20, 0x31, 0x3b,
0x52, 0xe9, 0x62, 0x2e, 0x20, 0x32, 0x3b, 0x44, 0x73, 0x65, 0x6d, 0x2e,
0x20, 0x49, 0x3b, 0x44, 0x73, 0x65, 0x6d, 0x2e, 0x20, 0x49, 0x49, 0x3b,
0x52, 0x65, 0x64, 0x2e, 0x3b, 0x53, 0x61, 0x62, 0x2e, 0x3b, 0x52, 0x61,
0x6d, 0x2e, 0x3b, 0x53, 0x65, 0x76, 0x2e, 0x3b, 0x44, 0x73, 0xfc, 0x6c,
0x20, 0x6b, 0x2e, 0x3b, 0x44, 0x73, 0xfc, 0x6c, 0x20, 0x68, 0x2e, 0x6d,
0x75, 0x68, 0x2e, 0x3b, 0x73, 0x61, 0x66, 0x2e, 0x3b, 0x72, 0x61, 0x62,
0x2e, 0x20, 0x49, 0x3b, 0x72, 0x61, 0x62, 0x2e, 0x20, 0x49, 0x49, 0x3b,
0x6a, 0x75, 0x6d, 0x2e, 0x20, 0x49, 0x3b, 0x6a, 0x75, 0x6d, 0x2e, 0x20,
0x49, 0x49, 0x3b, 0x72, 0x61, 0x6a, 0x2e, 0x3b, 0x73, 0x68, 0x61, 0x2e,
0x3b, 0x72, 0x61, 0x6d, 0x2e, 0x3b, 0x73, 0x68, 0x61, 0x77, 0x2e, 0x3b,
0x64, 0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x51, 0x2e, 0x3b, 0x64, 0x68, 0x75,
0x2bb, 0x6c, 0x2d, 0x48, 0x2e, 0x4d, 0x75, 0x68, 0x61, 0x72, 0x61, 0x6d,
0x3b, 0x53, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x75,
0x6c, 0x61, 0x77, 0x61, 0x6c, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x75, 0x6c,
0x61, 0x6b, 0x68, 0x69, 0x72, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x64, 0x69,
0x6c, 0x61, 0x77, 0x61, 0x6c, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x64, 0x69,
0x6c, 0x61, 0x6b, 0x68, 0x69, 0x72, 0x3b, 0x52, 0x61, 0x6a, 0x61, 0x62,
0x3b, 0x53, 0x79, 0x61, 0x6b, 0x62, 0x61, 0x6e, 0x3b, 0x52, 0x61, 0x6d,
0x61, 0x64, 0x61, 0x6e, 0x3b, 0x53, 0x79, 0x61, 0x77, 0x61, 0x6c, 0x3b,
0x5a, 0x75, 0x6c, 0x6b, 0x61, 0x69, 0x64, 0x61, 0x68, 0x3b, 0x5a, 0x75,
0x6c, 0x68, 0x69, 0x6a, 0x61, 0x68, 0x4d, 0x75, 0x68, 0x2e, 0x3b, 0x53,
0x61, 0x66, 0x2e, 0x3b, 0x52, 0x61, 0x62, 0x2e, 0x20, 0x41, 0x77, 0x61,
0x6c, 0x3b, 0x52, 0x61, 0x62, 0x2e, 0x20, 0x41, 0x6b, 0x68, 0x69, 0x72,
0x3b, 0x4a, 0x75, 0x6d, 0x2e, 0x20, 0x41, 0x77, 0x61, 0x6c, 0x3b, 0x4a,
0x75, 0x6d, 0x2e, 0x20, 0x41, 0x6b, 0x68, 0x69, 0x72, 0x3b, 0x52, 0x61,
0x6a, 0x2e, 0x3b, 0x53, 0x79, 0x61, 0x2e, 0x3b, 0x52, 0x61, 0x6d, 0x2e,
0x3b, 0x53, 0x79, 0x61, 0x77, 0x2e, 0x3b, 0x5a, 0x75, 0x6c, 0x6b, 0x61,
0x2e, 0x3b, 0x5a, 0x75, 0x6c, 0x68, 0x69, 0x2e, 0x30e0, 0x30cf, 0x30c3, 0x30e9,
0x30e0, 0x3b, 0x30b5, 0x30d5, 0x30a2, 0x30eb, 0x3b, 0x30e9, 0x30d3, 0x30fc, 0x30fb, 0x30a6,
0x30eb, 0x30fb, 0x30a2, 0x30a6, 0x30ef, 0x30eb, 0x3b, 0x30e9, 0x30d3, 0x30fc, 0x30fb, 0x30a6,
0x30c3, 0x30fb, 0x30b5, 0x30fc, 0x30cb, 0x30fc, 0x3b, 0x30b8, 0x30e5, 0x30de, 0x30fc, 0x30c0,
0x30eb, 0x30fb, 0x30a2, 0x30a6, 0x30ef, 0x30eb, 0x3b, 0x30b8, 0x30e5, 0x30de, 0x30fc, 0x30c0,
0x30c3, 0x30b5, 0x30fc, 0x30cb, 0x30fc, 0x3b, 0x30e9, 0x30b8, 0x30e3, 0x30d6, 0x3b, 0x30b7,
0x30e3, 0x30a2, 0x30d0, 0x30fc, 0x30f3, 0x3b, 0x30e9, 0x30de, 0x30c0, 0x30fc, 0x30f3, 0x3b,
0x30b7, 0x30e3, 0x30a6, 0x30ef, 0x30fc, 0x30eb, 0x3b, 0x30ba, 0x30eb, 0x30fb, 0x30ab, 0x30a4,
0x30c0, 0x3b, 0x30ba, 0x30eb, 0x30fb, 0x30d2, 0x30c3, 0x30b8, 0x30e3, 0x53, 0x75, 0x72,
0x61, 0x3b, 0x53, 0x61, 0x70, 0x61, 0x72, 0x3b, 0x4d, 0x75, 0x6c, 0x75,
0x64, 0x3b, 0x42, 0x61, 0x6b, 0x64, 0x61, 0x20, 0x4d, 0x75, 0x6c, 0x75,
0x64, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x64, 0x69, 0x6c, 0x61, 0x77, 0x61,
0x6c, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x64, 0x69, 0x6c, 0x61, 0x6b, 0x69,
0x72, 0x3b, 0x52, 0x65, 0x6a, 0x65, 0x62, 0x3b, 0x52, 0x75, 0x77, 0x61,
0x68, 0x3b, 0x50, 0x61, 0x73, 0x61, 0x3b, 0x53, 0x61, 0x77, 0x61, 0x6c,
0x3b, 0x53, 0x65, 0x6c, 0x6f, 0x3b, 0x42, 0x65, 0x73, 0x61, 0x72, 0x53,
0x75, 0x72, 0x2e, 0x3b, 0x53, 0x61, 0x70, 0x2e, 0x3b, 0x4d, 0x75, 0x6c,
0x2e, 0x3b, 0x42, 0x2e, 0x20, 0x4d, 0x75, 0x6c, 0x2e, 0x3b, 0x4a, 0x75,
0x6d, 0x2e, 0x20, 0x41, 0x77, 0x2e, 0x3b, 0x4a, 0x75, 0x6d, 0x2e, 0x20,
0x41, 0x6b, 0x2e, 0x3b, 0x52, 0x65, 0x6a, 0x2e, 0x3b, 0x52, 0x75, 0x77,
0x2e, 0x3b, 0x50, 0x73, 0x6f, 0x2e, 0x3b, 0x53, 0x68, 0x61, 0x77, 0x2e,
0x3b, 0x53, 0x6c, 0x6f, 0x2e, 0x3b, 0x42, 0x73, 0x61, 0x72, 0x2e, 0xcae,
0xcc1, 0xcb9, 0xcb0, 0xcae, 0xccd, 0x3b, 0xcb8, 0xcab, 0xcbe, 0xcb0, 0xccd, 0x3b,
0xcb0, 0xcac, 0xcbf, 0x2018, 0x20, 0x49, 0x3b, 0xcb0, 0xcac, 0xcbf, 0x2018, 0x20,
0x49, 0x49, 0x3b, 0xc9c, 0xcc1, 0xcae, 0xcbe, 0xca6, 0xcbe, 0x20, 0x49, 0x3b,
0xc9c, 0xcc1, 0xcae, 0xcbe, 0xca6, 0xcbe, 0x20, 0x49, 0x49, 0x3b, 0xcb0, 0xc9c,
0xcac, 0xccd, 0x3b, 0xcb6, 0x2019, 0xcac, 0xcbe, 0xca8, 0xccd, 0x3b, 0xcb0, 0xcae,
0xca6, 0xcbe, 0xca8, 0xccd, 0x3b, 0xcb6, 0xcb5, 0xccd, 0xcb5, 0xcbe, 0xcb2, 0xccd,
0x3b, 0xca7, 0xcc1, 0x2018, 0xcb2, 0xccd, 0x2d, 0xc95, 0xcbf, 0x2018, 0xca1, 0xcbe,
0xcb9, 0xccd, 0x3b, 0xca7, 0xcc1, 0x2018, 0xcb2, 0xccd, 0x2d, 0xcb9, 0xcbf, 0xc9c,
0xcbe, 0xcb9, 0xccd, 0xcae, 0xcc1, 0xcb9, 0xccd, 0x2e, 0x3b, 0xcb8, 0xcab, 0xcbe,
0x2e, 0x3b, 0xcb0, 0xcac, 0xcbf, 0x2018, 0x20, 0x49, 0x3b, 0xcb0, 0xcac, 0xcbf,
0x2018, 0x20, 0x49, 0x49, 0x3b, 0xc9c, 0xcc1, 0xcae, 0xccd, 0x2e, 0x20, 0x49,
0x3b, 0xc9c, 0xcc1, 0xcae, 0xccd, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0xcb0, 0xc9c,
0xccd, 0x2e, 0x3b, 0xcb6, 0x2e, 0x3b, 0xcb0, 0xcae, 0xccd, 0x2e, 0x3b, 0xcb6,
0xcb5, 0xccd, 0x2e, 0x3b, 0xca7, 0xcc1, 0x2018, 0xcb2, 0xccd, 0x2d, 0xc95, 0xcbf,
0x2e, 0x3b, 0xca7, 0xcc1, 0x2018, 0xcb2, 0xccd, 0x2d, 0xcb9, 0x2e, 0x41c, 0x4b1,
0x445, 0x430, 0x440, 0x440, 0x430, 0x43c, 0x3b, 0x421, 0x430, 0x444, 0x430, 0x440,
0x3b, 0x420, 0x430, 0x431, 0x438, 0x493, 0x443, 0x43b, 0x20, 0x4d9, 0x443, 0x443,
0x4d9, 0x43b, 0x3b, 0x420, 0x430, 0x431, 0x438, 0x493, 0x443, 0x43b, 0x20, 0x430,
0x445, 0x438, 0x440, 0x3b, 0x416, 0x4b1, 0x43c, 0x430, 0x434, 0x4d9, 0x43b, 0x20,
0x430, 0x443, 0x443, 0x4d9, 0x43b, 0x3b, 0x416, 0x4b1, 0x43c, 0x430, 0x434, 0x4d9,
0x43b, 0x20, 0x430, 0x445, 0x438, 0x440, 0x3b, 0x415, 0x440, 0x435, 0x436, 0x435,
0x43f, 0x3b, 0x428, 0x430, 0x493, 0x431, 0x430, 0x43d, 0x3b, 0x420, 0x430, 0x43c,
0x430, 0x437, 0x430, 0x43d, 0x3b, 0x428, 0x4d9, 0x443, 0x443, 0x430, 0x43b, 0x3b,
0x417, 0x4b1, 0x43b, 0x49b, 0x430, 0x493, 0x434, 0x430, 0x3b, 0x417, 0x4b1, 0x43b,
0x445, 0x438, 0x436, 0x436, 0x430, 0x41c, 0x4b1, 0x445, 0x2e, 0x3b, 0x421, 0x430,
0x444, 0x2e, 0x3b, 0x420, 0x430, 0x431, 0x2e, 0x20, 0x406, 0x3b, 0x420, 0x430,
0x431, 0x2e, 0x20, 0x406, 0x406, 0x3b, 0x416, 0x4b1, 0x43c, 0x2e, 0x20, 0x49,
0x3b, 0x416, 0x4b1, 0x43c, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x415, 0x440, 0x435,
0x436, 0x2e, 0x3b, 0x428, 0x430, 0x493, 0x2e, 0x3b, 0x420, 0x430, 0x43c, 0x2e,
0x3b, 0x428, 0x4d9, 0x443, 0x2e, 0x3b, 0x417, 0x4b1, 0x43b, 0x49b, 0x2e, 0x3b,
0x417, 0x4b1, 0x43b, 0x445, 0x2e, 0x41c, 0x4b1, 0x445, 0x2e, 0x3b, 0x421, 0x430,
0x444, 0x2e, 0x3b, 0x420, 0x430, 0x431, 0x2e, 0x20, 0x49, 0x3b, 0x420, 0x430,
0x431, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x416, 0x4b1, 0x43c, 0x2e, 0x20, 0x49,
0x3b, 0x416, 0x4b1, 0x43c, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x415, 0x440, 0x435,
0x436, 0x2e, 0x3b, 0x428, 0x430, 0x493, 0x2e, 0x3b, 0x420, 0x430, 0x43c, 0x2e,
0x3b, 0x428, 0x4d9, 0x443, 0x2e, 0x3b, 0x417, 0x4b1, 0x43b, 0x49b, 0x2e, 0x3b,
0x417, 0x4b1, 0x43b, 0x445, 0x2e, 0xbb34, 0xd558, 0xb78c, 0x3b, 0xc0ac, 0xd30c, 0xb974,
0x3b, 0xb77c, 0xbe44, 0x20, 0xc54c, 0x20, 0xc544, 0xc648, 0x3b, 0xb77c, 0xbe44, 0x20,
0xc54c, 0x20, 0xc384, 0xb2c8, 0x3b, 0xc8fc, 0xb9c8, 0xb2e4, 0x20, 0xc54c, 0x20, 0xc544,
0xc648, 0x3b, 0xc8fc, 0xb9c8, 0xb2e4, 0x20, 0xc54c, 0x20, 0xc384, 0xb2c8, 0x3b, 0xb77c,
0xc7a1, 0x3b, 0xc250, 0xc544, 0xbc18, 0x3b, 0xb77c, 0xb9c8, 0xb2e8, 0x3b, 0xc250, 0xc648,
0x3b, 0xb4c0, 0x20, 0xc54c, 0x20, 0xae4c, 0xb2e4, 0x3b, 0xb4c0, 0x20, 0xc54c, 0x20,
0xd788, 0xc790, 0x6d, 0x75, 0x68, 0x65, 0x72, 0x65, 0x6d, 0x3b, 0x73, 0x65,
0x66, 0x65, 0x72, 0x3b, 0x72, 0x65, 0x62, 0xee, 0x2bf, 0x75, 0x6c, 0x65,
0x77, 0x65, 0x6c, 0x3b, 0x72, 0x65, 0x62, 0xee, 0x2bf, 0x75, 0x6c, 0x61,
0x78, 0x65, 0x72, 0x3b, 0x63, 0x65, 0x6d, 0x61, 0x7a, 0xee, 0x79, 0x65,
0x6c, 0x65, 0x77, 0x65, 0x6c, 0x3b, 0x63, 0x65, 0x6d, 0x61, 0x7a, 0xee,
0x79, 0x65, 0x6c, 0x61, 0x78, 0x65, 0x72, 0x3b, 0x72, 0x65, 0x63, 0x65,
0x62, 0x3b, 0x15f, 0x65, 0x2bf, 0x62, 0x61, 0x6e, 0x3b, 0x72, 0x65, 0x6d,
0x65, 0x7a, 0x61, 0x6e, 0x3b, 0x15f, 0x65, 0x77, 0x61, 0x6c, 0x3b, 0x7a,
0xee, 0x6c, 0x71, 0x65, 0x2bf, 0x64, 0x65, 0x3b, 0x7a, 0x69, 0x6c, 0x68,
0x65, 0x63, 0x65, 0x6d, 0x75, 0x68, 0x2e, 0x3b, 0x73, 0x65, 0x66, 0x2e,
0x3b, 0x72, 0x65, 0x62, 0x2e, 0x20, 0x49, 0x65, 0x6d, 0x3b, 0x72, 0x65,
0x62, 0x2e, 0x20, 0x49, 0x49, 0x79, 0x65, 0x6d, 0x3b, 0x63, 0x6d, 0x7a,
0x2e, 0x20, 0x49, 0x65, 0x6d, 0x3b, 0x63, 0x6d, 0x7a, 0x2e, 0x20, 0x49,
0x49, 0x79, 0x65, 0x6d, 0x3b, 0x72, 0x63, 0x62, 0x2e, 0x3b, 0x15f, 0x62,
0x6e, 0x2e, 0x3b, 0x72, 0x6d, 0x7a, 0x2e, 0x3b, 0x15f, 0x77, 0x6c, 0x2e,
0x3b, 0x7a, 0x71, 0x64, 0x2e, 0x3b, 0x7a, 0x68, 0x63, 0x2e, 0xea1, 0xeb8,
0xea3, 0xeb0, 0xeae, 0xead, 0xea1, 0x3b, 0xe8a, 0xeb2, 0xe9f, 0xeb2, 0xea3, 0x3b,
0xeae, 0xead, 0xe94, 0xe9a, 0xeb5, 0x20, 0x31, 0x3b, 0xeae, 0xead, 0xe94, 0xe9a,
0xeb5, 0x20, 0x32, 0x3b, 0xe88, 0xeb8, 0xea1, 0xeb2, 0xe94, 0xeb2, 0x20, 0x31,
0x3b, 0xe88, 0xeb8, 0xea1, 0xeb2, 0xe94, 0xeb2, 0x20, 0x32, 0x3b, 0xeae, 0xeb2,
0xe88, 0xeb1, 0xe9a, 0x3b, 0xe8a, 0xeb0, 0xe9a, 0xeb2, 0xe99, 0x3b, 0xeae, 0xeb2,
0xea1, 0xeb2, 0xe94, 0xead, 0xe99, 0x3b, 0xec0, 0xe8a, 0xebb, 0xeb2, 0xea7, 0xeb1,
0xe94, 0x3b, 0xe94, 0xeb8, 0xead, 0xeb1, 0xe94, 0xe81, 0xeb4, 0xe94, 0xeb0, 0x3b,
0xe94, 0xeb8, 0xead, 0xeb1, 0xe94, 0xe81, 0xeb4, 0xe88, 0xeb0, 0xea1, 0xeb8, 0xeae,
0xeb1, 0xe94, 0x3b, 0xec0, 0xe84, 0xeb2, 0xeb0, 0x3b, 0xeae, 0xead, 0xe81, 0xe9a,
0xeb5, 0x20, 0x31, 0x3b, 0xeae, 0xead, 0xe81, 0xe9a, 0xeb5, 0x20, 0x32, 0x3b,
0xe99, 0xeb8, 0xea1, 0xeb2, 0x20, 0x31, 0x3b, 0xe99, 0xeb8, 0xea1, 0xeb2, 0x20,
0x32, 0x3b, 0xec0, 0xeae, 0xeb2, 0xeb0, 0x3b, 0xe8a, 0xeb2, 0x3b, 0xec0, 0xeae,
0xeb2, 0xeb0, 0xea1, 0xeb0, 0x3b, 0xec0, 0xe8a, 0xebb, 0xeb2, 0x3b, 0xe8a, 0xeb8,
0xea5, 0xe81, 0xeb4, 0xead, 0xeb8, 0x3b, 0xe8a, 0xeb8, 0xea5, 0xeab, 0xeb4, 0xe88,
0xea1, 0xeb8, 0xeae, 0xeb1, 0xe94, 0x3b, 0xec0, 0xe84, 0xeb2, 0xeb0, 0x3b, 0xeae,
0xead, 0xe94, 0xe9a, 0xeb5, 0x20, 0x31, 0x3b, 0xeae, 0xead, 0xe81, 0xe9a, 0xeb5,
0x20, 0x32, 0x3b, 0xe99, 0xeb8, 0xea1, 0xeb2, 0x20, 0x31, 0x3b, 0xe99, 0xeb8,
0xea1, 0xeb2, 0x20, 0x32, 0x3b, 0xec0, 0xeae, 0xeb2, 0xeb0, 0x3b, 0xe8a, 0xeb0,
0xead, 0xecc, 0x3b, 0xec0, 0xeae, 0xeb2, 0xeb0, 0xea1, 0xeb0, 0x3b, 0xec0, 0xe8a,
0xebb, 0xeb2, 0x3b, 0xe8a, 0xeb8, 0xea5, 0xe81, 0xeb4, 0xead, 0xeb8, 0x3b, 0xe8a,
0xeb8, 0xea5, 0xeab, 0xeb4, 0xe88, 0x6d, 0x75, 0x68, 0x61, 0x72, 0x61, 0x6d,
0x73, 0x3b, 0x73, 0x61, 0x66, 0x61, 0x72, 0x73, 0x3b, 0x31, 0x2e, 0x20,
0x72, 0x61, 0x62, 0x12b, 0x3b, 0x32, 0x2e, 0x20, 0x72, 0x61, 0x62, 0x12b,
0x3b, 0x31, 0x2e, 0x20, 0x64, 0x17e, 0x75, 0x6d, 0x101, 0x64, 0x101, 0x3b,
0x32, 0x2e, 0x20, 0x64, 0x17e, 0x75, 0x6d, 0x101, 0x64, 0x101, 0x3b, 0x72,
0x61, 0x64, 0x17e, 0x61, 0x62, 0x73, 0x3b, 0x161, 0x61, 0x62, 0x61, 0x6e,
0x73, 0x3b, 0x72, 0x61, 0x6d, 0x61, 0x64, 0x101, 0x6e, 0x73, 0x3b, 0x161,
0x61, 0x75, 0x76, 0x61, 0x6c, 0x73, 0x3b, 0x64, 0x75, 0x20, 0x61, 0x6c,
0x2d, 0x6b, 0x69, 0x64, 0x101, 0x3b, 0x64, 0x75, 0x20, 0x61, 0x6c, 0x2d,
0x68, 0x69, 0x64, 0x17e, 0x101, 0x43c, 0x443, 0x445, 0x430, 0x440, 0x435, 0x43c,
0x3b, 0x441, 0x430, 0x444, 0x430, 0x440, 0x3b, 0x440, 0x430, 0x431, 0x438, 0x20,
0x49, 0x3b, 0x440, 0x430, 0x431, 0x438, 0x20, 0x49, 0x49, 0x3b, 0x45f, 0x443,
0x43c, 0x430, 0x434, 0x430, 0x20, 0x49, 0x3b, 0x45f, 0x443, 0x43c, 0x430, 0x434,
0x430, 0x20, 0x49, 0x49, 0x3b, 0x440, 0x430, 0x45f, 0x430, 0x431, 0x3b, 0x448,
0x430, 0x431, 0x430, 0x43d, 0x3b, 0x440, 0x430, 0x43c, 0x430, 0x434, 0x430, 0x43d,
0x3b, 0x448, 0x430, 0x432, 0x430, 0x43b, 0x3b, 0x434, 0x443, 0x43b, 0x43a, 0x438,
0x434, 0x430, 0x3b, 0x434, 0x443, 0x43b, 0x445, 0x438, 0x45f, 0x430, 0x43c, 0x443,
0x445, 0x2e, 0x3b, 0x441, 0x430, 0x444, 0x2e, 0x3b, 0x440, 0x430, 0x431, 0x2e,
0x20, 0x49, 0x3b, 0x440, 0x430, 0x431, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x45f,
0x443, 0x43c, 0x2e, 0x20, 0x49, 0x3b, 0x45f, 0x443, 0x43c, 0x2e, 0x20, 0x49,
0x49, 0x3b, 0x440, 0x430, 0x45f, 0x2e, 0x3b, 0x448, 0x430, 0x431, 0x2e, 0x3b,
0x440, 0x430, 0x43c, 0x2e, 0x3b, 0x448, 0x430, 0x432, 0x2e, 0x3b, 0x434, 0x443,
0x43b, 0x43a, 0x2e, 0x3b, 0x434, 0x443, 0x43b, 0x445, 0x2e, 0xd2e, 0xd41, 0xd39,
0xd31, 0xd02, 0x3b, 0xd38, 0xd2b, 0xd7c, 0x3b, 0xd31, 0xd2c, 0xd40, 0xd39, 0xd41,
0xd7d, 0x20, 0xd05, 0xd35, 0xd4d, 0xd35, 0xd7d, 0x3b, 0xd31, 0xd2c, 0xd40, 0xd39,
0xd41, 0xd7d, 0x20, 0xd06, 0xd16, 0xd3f, 0xd7c, 0x3b, 0xd1c, 0xd2e, 0xd3e, 0xd26,
0xd41, 0xd7d, 0x20, 0xd05, 0xd35, 0xd4d, 0xd35, 0xd7d, 0x3b, 0xd1c, 0xd2e, 0xd3e,
0xd26, 0xd41, 0xd7d, 0x20, 0xd06, 0xd16, 0xd3f, 0xd7c, 0x3b, 0xd31, 0xd1c, 0xd2c,
0xd4d, 0x3b, 0xd36, 0xd39, 0xd2c, 0xd3e, 0xd7b, 0x3b, 0xd31, 0xd2e, 0xd26, 0xd3e,
0xd7b, 0x3b, 0xd36, 0xd35, 0xd4d, 0xd35, 0xd3e, 0xd7d, 0x3b, 0xd26, 0xd41, 0xd7d,
0x20, 0xd16, 0xd39, 0xd26, 0xd4d, 0x3b, 0xd26, 0xd41, 0xd7d, 0x20, 0xd39, 0xd3f,
0xd1c, 0xd4d, 0xd1c, 0xd2e, 0xd41, 0xd39, 0xd31, 0xd02, 0x3b, 0xd38, 0xd2b, 0xd7c,
0x3b, 0xd31, 0xd2c, 0xd40, 0xd39, 0xd41, 0xd7d, 0x20, 0xd05, 0xd35, 0xd4d, 0xd35,
0xd7d, 0x3b, 0xd31, 0xd2c, 0xd40, 0xd39, 0xd41, 0xd7d, 0x20, 0xd06, 0xd16, 0xd3f,
0xd7c, 0x3b, 0xd1c, 0xd2e, 0xd3e, 0xd26, 0xd41, 0xd7d, 0x20, 0xd05, 0xd35, 0xd4d,
0xd35, 0xd7d, 0x3b, 0xd1c, 0xd2e, 0xd3e, 0xd26, 0xd41, 0xd7d, 0x20, 0xd06, 0xd16,
0xd3f, 0xd7c, 0x3b, 0xd31, 0xd1c, 0xd2c, 0xd4d, 0x3b, 0xd36, 0xd39, 0xd2c, 0xd3e,
0xd7b, 0x3b, 0xd31, 0xd2e, 0xd33, 0xd3e, 0xd7b, 0x3b, 0xd36, 0xd35, 0xd4d, 0xd35,
0xd3e, 0xd7d, 0x3b, 0xd26, 0xd41, 0xd7d, 0x20, 0xd16, 0xd39, 0xd26, 0xd4d, 0x3b,
0xd26, 0xd41, 0xd7d, 0x20, 0xd39, 0xd3f, 0xd1c, 0xd4d, 0xd1c, 0xd2e, 0xd41, 0xd39,
0x2e, 0x3b, 0xd38, 0xd2b, 0x2e, 0x3b, 0xd31, 0xd2c, 0xd40, 0xd39, 0xd41, 0xd7d,
0x20, 0xd05, 0xd35, 0xd4d, 0xd35, 0x2e, 0x3b, 0xd31, 0xd2c, 0xd40, 0xd39, 0xd41,
0xd7d, 0x20, 0xd06, 0xd16, 0xd3f, 0x2e, 0x3b, 0xd1c, 0xd2e, 0xd3e, 0xd26, 0xd41,
0xd7d, 0x20, 0xd05, 0xd35, 0xd4d, 0xd35, 0x2e, 0x3b, 0xd1c, 0xd2e, 0xd3e, 0xd26,
0xd41, 0xd7d, 0x20, 0xd06, 0xd16, 0xd3f, 0x2e, 0x3b, 0xd31, 0xd1c, 0x2e, 0x3b,
0xd36, 0xd39, 0xd2c, 0xd3e, 0x2e, 0x3b, 0xd31, 0xd2e, 0xd26, 0xd3e, 0x2e, 0x3b,
0xd36, 0xd35, 0xd4d, 0xd35, 0xd3e, 0x2e, 0x3b, 0xd26, 0xd41, 0xd7d, 0x20, 0xd16,
0xd39, 0x2e, 0x3b, 0xd26, 0xd41, 0xd7d, 0x20, 0xd39, 0xd3f, 0x2e, 0xd2e, 0xd41,
0x3b, 0xd38, 0x3b, 0xd31, 0x3b, 0xd31, 0x3b, 0xd1c, 0x3b, 0xd1c, 0x3b, 0xd31,
0x3b, 0xd36, 0x3b, 0xd31, 0x3b, 0xd36, 0x3b, 0xd26, 0xd41, 0x3b, 0xd26, 0xd41,
0x4d, 0x75, 0x68, 0x61, 0x72, 0x61, 0x6d, 0x3b, 0x53, 0x61, 0x66, 0x61,
0x72, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x75, 0x6c, 0x61, 0x77, 0x61, 0x6c,
0x3b, 0x52, 0x61, 0x62, 0x69, 0x75, 0x6c, 0x61, 0x6b, 0x68, 0x69, 0x72,
0x3b, 0x4a, 0x61, 0x6d, 0x61, 0x64, 0x69, 0x6c, 0x61, 0x77, 0x61, 0x6c,
0x3b, 0x4a, 0x61, 0x6d, 0x61, 0x64, 0x69, 0x6c, 0x61, 0x6b, 0x68, 0x69,
0x72, 0x3b, 0x52, 0x65, 0x6a, 0x61, 0x62, 0x3b, 0x53, 0x79, 0x61, 0x61,
0x62, 0x61, 0x6e, 0x3b, 0x52, 0x61, 0x6d, 0x61, 0x64, 0x61, 0x6e, 0x3b,
0x53, 0x79, 0x61, 0x77, 0x61, 0x6c, 0x3b, 0x5a, 0x75, 0x6c, 0x6b, 0x61,
0x65, 0x64, 0x61, 0x68, 0x3b, 0x5a, 0x75, 0x6c, 0x68, 0x69, 0x6a, 0x61,
0x68, 0x4d, 0x75, 0x68, 0x2e, 0x3b, 0x53, 0x61, 0x66, 0x2e, 0x3b, 0x52,
0x61, 0x62, 0x2e, 0x20, 0x49, 0x3b, 0x52, 0x61, 0x62, 0x2e, 0x20, 0x49,
0x49, 0x3b, 0x4a, 0x61, 0x6d, 0x2e, 0x20, 0x49, 0x3b, 0x4a, 0x61, 0x6d,
0x2e, 0x20, 0x49, 0x49, 0x3b, 0x52, 0x65, 0x6a, 0x2e, 0x3b, 0x53, 0x79,
0x61, 0x61, 0x2e, 0x3b, 0x52, 0x61, 0x6d, 0x2e, 0x3b, 0x53, 0x79, 0x61,
0x77, 0x2e, 0x3b, 0x5a, 0x75, 0x6c, 0x6b, 0x2e, 0x3b, 0x5a, 0x75, 0x6c,
0x68, 0x2e, 0x92e, 0x94b, 0x939, 0x930, 0x92e, 0x3b, 0x938, 0x92b, 0x930, 0x3b,
0x930, 0x93e, 0x92c, 0x940, 0x20, 0x49, 0x3b, 0x930, 0x93e, 0x92c, 0x940, 0x20,
0x49, 0x49, 0x3b, 0x91c, 0x941, 0x92e, 0x93e, 0x926, 0x93e, 0x20, 0x49, 0x3b,
0x91c, 0x941, 0x92e, 0x93e, 0x926, 0x93e, 0x20, 0x49, 0x49, 0x3b, 0x930, 0x91d,
0x93e, 0x92c, 0x3b, 0x936, 0x93e, 0x92c, 0x93e, 0x928, 0x3b, 0x930, 0x92e, 0x91c,
0x93e, 0x928, 0x3b, 0x936, 0x935, 0x94d, 0x935, 0x93e, 0x932, 0x3b, 0x927, 0x941,
0x932, 0x2d, 0x915, 0x940, 0x926, 0x93e, 0x939, 0x3b, 0x927, 0x941, 0x932, 0x2d,
0x939, 0x93f, 0x91c, 0x93e, 0x939, 0x92e, 0x94b, 0x939, 0x2e, 0x3b, 0x938, 0x92b,
0x2e, 0x3b, 0x930, 0x93e, 0x92c, 0x940, 0x20, 0x49, 0x3b, 0x930, 0x93e, 0x92c,
0x940, 0x20, 0x49, 0x49, 0x3b, 0x91c, 0x941, 0x92e, 0x93e, 0x2e, 0x20, 0x49,
0x3b, 0x91c, 0x941, 0x92e, 0x93e, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x930, 0x91d,
0x93e, 0x2e, 0x3b, 0x936, 0x93e, 0x92c, 0x93e, 0x2e, 0x3b, 0x930, 0x92e, 0x2e,
0x3b, 0x936, 0x935, 0x94d, 0x935, 0x93e, 0x2e, 0x3b, 0x927, 0x941, 0x932, 0x2d,
0x915, 0x940, 0x2e, 0x3b, 0x927, 0x941, 0x932, 0x2d, 0x939, 0x93f, 0x2e, 0x967,
0x3b, 0x968, 0x3b, 0x969, 0x3b, 0x96a, 0x3b, 0x96b, 0x3b, 0x96c, 0x3b, 0x96d,
0x3b, 0x96e, 0x3b, 0x96f, 0x3b, 0x967, 0x966, 0x3b, 0x967, 0x967, 0x3b, 0x967,
0x968, 0x6d, 0x75, 0x68, 0x61, 0x72, 0x72, 0x61, 0x6d, 0x3b, 0x73, 0x61,
0x66, 0x61, 0x72, 0x3b, 0x72, 0x61, 0x62, 0x69, 0x2bb, 0x20, 0x49, 0x3b,
0x72, 0x61, 0x62, 0x69, 0x2bb, 0x20, 0x49, 0x49, 0x3b, 0x6a, 0x75, 0x6d,
0x61, 0x64, 0x61, 0x20, 0x49, 0x3b, 0x6a, 0x75, 0x6d, 0x61, 0x64, 0x61,
0x20, 0x49, 0x49, 0x3b, 0x72, 0x61, 0x6a, 0x61, 0x62, 0x3b, 0x73, 0x68,
0x61, 0x2bb, 0x62, 0x61, 0x6e, 0x3b, 0x72, 0x61, 0x6d, 0x61, 0x64, 0x61,
0x6e, 0x3b, 0x73, 0x68, 0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b, 0x64, 0x68,
0x75, 0x2bb, 0x6c, 0x2d, 0x71, 0x69, 0x2bb, 0x64, 0x61, 0x68, 0x3b, 0x64,
0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x68, 0x69, 0x6a, 0x6a, 0x61, 0x68, 0x6d,
0x75, 0x68, 0x2e, 0x3b, 0x73, 0x61, 0x66, 0x2e, 0x3b, 0x72, 0x61, 0x62,
0x2e, 0x20, 0x49, 0x3b, 0x72, 0x61, 0x62, 0x2e, 0x20, 0x49, 0x49, 0x3b,
0x6a, 0x75, 0x6d, 0x2e, 0x20, 0x49, 0x3b, 0x6a, 0x75, 0x6d, 0x2e, 0x20,
0x49, 0x49, 0x3b, 0x72, 0x61, 0x6a, 0x2e, 0x3b, 0x73, 0x68, 0x61, 0x2e,
0x3b, 0x72, 0x61, 0x6d, 0x2e, 0x3b, 0x73, 0x68, 0x61, 0x77, 0x2e, 0x3b,
0x64, 0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x71, 0x2e, 0x3b, 0x44, 0x68, 0x75,
0x2bb, 0x6c, 0x2d, 0x48, 0x2e, 0x6d, 0x75, 0x68, 0x2e, 0x3b, 0x73, 0x61,
0x66, 0x2e, 0x3b, 0x72, 0x61, 0x62, 0x2e, 0x20, 0x49, 0x3b, 0x72, 0x61,
0x62, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x6a, 0x75, 0x6d, 0x2e, 0x20, 0x49,
0x3b, 0x6a, 0x75, 0x6d, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x72, 0x61, 0x6a,
0x2e, 0x3b, 0x73, 0x68, 0x61, 0x2e, 0x3b, 0x72, 0x61, 0x6d, 0x2e, 0x3b,
0x73, 0x68, 0x61, 0x77, 0x2e, 0x3b, 0x64, 0x68, 0x75, 0x2bb, 0x6c, 0x2d,
0x71, 0x2e, 0x3b, 0x64, 0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x68, 0x2e, 0x645,
0x62d, 0x631, 0x645, 0x3b, 0x635, 0x641, 0x631, 0x3b, 0x631, 0x628, 0x6cc, 0x639,
0x20, 0x627, 0x648, 0x644, 0x3b, 0x631, 0x628, 0x64a, 0x639, 0x20, 0x49, 0x49,
0x3b, 0x62c, 0x645, 0x627, 0x62f, 0x64a, 0x20, 0x627, 0x648, 0x644, 0x3b, 0x62c,
0x645, 0x627, 0x639, 0x647, 0x20, 0x49, 0x49, 0x3b, 0x631, 0x62c, 0x628, 0x3b,
0x634, 0x639, 0x628, 0x627, 0x646, 0x3b, 0x631, 0x645, 0x636, 0x627, 0x646, 0x3b,
0x634, 0x648, 0x627, 0x644, 0x3b, 0x630, 0x64a, 0x20, 0x627, 0x644, 0x642, 0x639,
0x62f, 0x647, 0x3b, 0x630, 0x64a, 0x20, 0x627, 0x644, 0x62d, 0x62c, 0x645, 0x62d,
0x631, 0x645, 0x3b, 0x635, 0x641, 0x631, 0x3b, 0x631, 0x628, 0x64a, 0x639, 0x3b,
0x631, 0x628, 0x64a, 0x639, 0x20, 0x49, 0x49, 0x3b, 0x62c, 0x645, 0x627, 0x62f,
0x20, 0x49, 0x3b, 0x62c, 0x645, 0x627, 0x62f, 0x20, 0x6f2, 0x3b, 0x631, 0x62c,
0x628, 0x3b, 0x634, 0x639, 0x628, 0x627, 0x646, 0x3b, 0x631, 0x645, 0x636, 0x627,
0x646, 0x3b, 0x634, 0x648, 0x627, 0x644, 0x3b, 0x62f, 0x627, 0x644, 0x642, 0x627,
0x639, 0x62f, 0x647, 0x3b, 0x630, 0x64a, 0x20, 0x627, 0x644, 0x62d, 0x62c, 0x645,
0x62d, 0x631, 0x645, 0x3b, 0x62f, 0x20, 0x635, 0x641, 0x631, 0x6d2, 0x20, 0x62f,
0x3b, 0x631, 0x628, 0x6cc, 0x639, 0x20, 0x627, 0x648, 0x644, 0x3b, 0x631, 0x628,
0x64a, 0x639, 0x20, 0x49, 0x49, 0x3b, 0x62c, 0x645, 0x627, 0x62f, 0x64a, 0x20,
0x627, 0x648, 0x644, 0x3b, 0x62c, 0x645, 0x627, 0x639, 0x647, 0x20, 0x49, 0x49,
0x3b, 0x631, 0x62c, 0x628, 0x3b, 0x634, 0x639, 0x628, 0x627, 0x646, 0x3b, 0x631,
0x645, 0x636, 0x627, 0x646, 0x3b, 0x634, 0x648, 0x627, 0x644, 0x3b, 0x630, 0x64a,
0x20, 0x627, 0x644, 0x642, 0x639, 0x62f, 0x647, 0x3b, 0x630, 0x64a, 0x20, 0x627,
0x644, 0x62d, 0x62c, 0x645, 0x62d, 0x631, 0x645, 0x3b, 0x635, 0x641, 0x631, 0x3b,
0x631, 0x628, 0x6cc, 0x639, 0x200c, 0x627, 0x644, 0x627, 0x648, 0x644, 0x3b, 0x631,
0x628, 0x6cc, 0x639, 0x200c, 0x627, 0x644, 0x62b, 0x627, 0x646, 0x6cc, 0x3b, 0x62c,
0x645, 0x627, 0x62f, 0x6cc, 0x200c, 0x627, 0x644, 0x627, 0x648, 0x644, 0x3b, 0x62c,
0x645, 0x627, 0x62f, 0x6cc, 0x200c, 0x627, 0x644, 0x62b, 0x627, 0x646, 0x6cc, 0x3b,
0x631, 0x62c, 0x628, 0x3b, 0x634, 0x639, 0x628, 0x627, 0x646, 0x3b, 0x631, 0x645,
0x636, 0x627, 0x646, 0x3b, 0x634, 0x648, 0x627, 0x644, 0x3b, 0x630, 0x6cc, 0x642,
0x639, 0x62f, 0x647, 0x3b, 0x630, 0x6cc, 0x62d, 0x62c, 0x647, 0x645, 0x3b, 0x635,
0x3b, 0x631, 0x3b, 0x631, 0x3b, 0x62c, 0x3b, 0x62c, 0x3b, 0x631, 0x3b, 0x634,
0x3b, 0x631, 0x3b, 0x634, 0x3b, 0x630, 0x3b, 0x630, 0x4d, 0x75, 0x68, 0x61,
0x72, 0x72, 0x61, 0x6d, 0x3b, 0x53, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x52,
0x61, 0x62, 0x69, 0x2bb, 0x20, 0x49, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x2bb,
0x20, 0x49, 0x49, 0x3b, 0x44, 0x17c, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20,
0x49, 0x3b, 0x44, 0x17c, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x49, 0x49,
0x3b, 0x52, 0x61, 0x64, 0x17c, 0x61, 0x62, 0x3b, 0x53, 0x7a, 0x61, 0x62,
0x61, 0x6e, 0x3b, 0x52, 0x61, 0x6d, 0x61, 0x64, 0x61, 0x6e, 0x3b, 0x53,
0x7a, 0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b, 0x5a, 0x75, 0x20, 0x61, 0x6c,
0x2d, 0x6b, 0x61, 0x64, 0x61, 0x3b, 0x5a, 0x75, 0x20, 0x61, 0x6c, 0x2d,
0x68, 0x69, 0x64, 0x17c, 0x64, 0x17c, 0x61, 0x4d, 0x75, 0x68, 0x2e, 0x3b,
0x53, 0x61, 0x66, 0x2e, 0x3b, 0x52, 0x61, 0x62, 0x2e, 0x20, 0x49, 0x3b,
0x52, 0x61, 0x62, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x44, 0x17c, 0x75, 0x2e,
0x20, 0x49, 0x3b, 0x44, 0x17c, 0x75, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x52,
0x61, 0x2e, 0x3b, 0x53, 0x7a, 0x61, 0x2e, 0x3b, 0x52, 0x61, 0x6d, 0x2e,
0x3b, 0x53, 0x7a, 0x61, 0x77, 0x2e, 0x3b, 0x5a, 0x75, 0x20, 0x61, 0x6c,
0x2d, 0x6b, 0x2e, 0x3b, 0x5a, 0x75, 0x20, 0x61, 0x6c, 0x2d, 0x68, 0x2e,
0xa2e, 0xa41, 0xa39, 0xa71, 0xa30, 0xa2e, 0x3b, 0xa38, 0xa2b, 0xa30, 0x3b, 0xa30,
0xa2c, 0xa40, 0x2bb, 0x20, 0x49, 0x3b, 0xa30, 0xa2c, 0xa40, 0x2bb, 0x20, 0x49,
0x49, 0x3b, 0xa1c, 0xa41, 0xa2e, 0xa3e, 0xa26, 0xa3e, 0x20, 0x49, 0x3b, 0xa1c,
0xa41, 0xa2e, 0xa3e, 0xa26, 0xa3e, 0x20, 0x49, 0x49, 0x3b, 0xa30, 0xa1c, 0xa2c,
0x3b, 0xa38, 0xa3c, 0xa2c, 0xa3e, 0xa28, 0x3b, 0xa30, 0xa2e, 0xa1c, 0xa3c, 0xa3e,
0xa28, 0x3b, 0xa38, 0xa3c, 0xa35, 0xa3e, 0xa32, 0x3b, 0xa26, 0xa42, 0x2d, 0xa05,
0xa32, 0x2d, 0xa15, 0xa40, 0xa26, 0xa3e, 0xa39, 0x3b, 0xa26, 0xa42, 0x2d, 0xa05,
0xa32, 0x2d, 0xa39, 0xa3f, 0xa1c, 0xa4d, 0xa39, 0xa3e, 0xa2e, 0xa41, 0xa39, 0xa71,
0xa30, 0xa2e, 0x3b, 0xa38, 0xa2b, 0xa30, 0x3b, 0xa30, 0xa2c, 0xa40, 0x20, 0x2bb,
0x20, 0x49, 0x3b, 0xa30, 0xa2c, 0xa40, 0x20, 0x2bb, 0x20, 0x49, 0x49, 0x3b,
0xa1c, 0xa41, 0xa2e, 0xa3e, 0xa26, 0xa3e, 0x20, 0x49, 0x3b, 0xa1c, 0xa41, 0xa2e,
0xa3e, 0xa26, 0xa3e, 0x20, 0x49, 0x49, 0x3b, 0xa30, 0xa1c, 0xa2c, 0x3b, 0xa38,
0xa3c, 0xa2c, 0xa3e, 0xa28, 0x3b, 0xa30, 0xa2e, 0xa1c, 0xa3c, 0xa3e, 0xa28, 0x3b,
0xa38, 0xa3c, 0xa35, 0xa3e, 0xa32, 0x3b, 0xa26, 0xa42, 0x2d, 0xa05, 0xa32, 0x2d,
0xa15, 0xa40, 0xa26, 0xa3e, 0xa39, 0x3b, 0xa26, 0xa42, 0x2d, 0xa05, 0xa32, 0x2d,
0xa39, 0xa3f, 0xa1c, 0xa4d, 0xa39, 0xa3e, 0xa2e, 0xa41, 0xa39, 0xa71, 0x2e, 0x3b,
0xa38, 0xa2b, 0x2e, 0x3b, 0xa30, 0xa2c, 0x2e, 0x20, 0x49, 0x3b, 0xa30, 0xa2c,
0x2e, 0x20, 0x49, 0x49, 0x3b, 0xa1c, 0xa41, 0xa2e, 0x2e, 0x20, 0x49, 0x3b,
0xa1c, 0xa41, 0xa2e, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0xa30, 0xa3e, 0xa1c, 0x2e,
0x3b, 0xa38, 0xa3c, 0xa3e, 0x2e, 0x3b, 0xa30, 0xa3e, 0xa2e, 0x2e, 0x3b, 0xa38,
0xa3c, 0xa05, 0x2e, 0x3b, 0xa26, 0xa42, 0x2d, 0xa05, 0xa32, 0x2d, 0xa15, 0xa40,
0x2e, 0x3b, 0xa26, 0xa42, 0x2d, 0xa05, 0xa32, 0x2d, 0xa39, 0xa3f, 0x2e, 0x6d,
0x75, 0x68, 0x61, 0x72, 0x72, 0x61, 0x6d, 0x3b, 0x73, 0x61, 0x66, 0x61,
0x72, 0x3b, 0x72, 0x61, 0x62, 0x69, 0x2bb, 0x20, 0x49, 0x3b, 0x72, 0x61,
0x62, 0x69, 0x2bb, 0x20, 0x49, 0x49, 0x3b, 0x6a, 0x75, 0x6d, 0x61, 0x64,
0x61, 0x20, 0x49, 0x3b, 0x6a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x49,
0x49, 0x3b, 0x72, 0x61, 0x6a, 0x61, 0x62, 0x3b, 0x73, 0x68, 0x61, 0x62,
0x61, 0x6e, 0x3b, 0x72, 0x61, 0x6d, 0x61, 0x64, 0x61, 0x6e, 0x3b, 0x73,
0x68, 0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b, 0x64, 0x68, 0x75, 0x2bb, 0x6c,
0x2d, 0x71, 0x69, 0x2bb, 0x64, 0x61, 0x68, 0x3b, 0x64, 0x68, 0x75, 0x2bb,
0x6c, 0x2d, 0x68, 0x69, 0x6a, 0x6a, 0x61, 0x68, 0x41c, 0x443, 0x445, 0x430,
0x440, 0x435, 0x43c, 0x3b, 0x421, 0x430, 0x444, 0x430, 0x440, 0x3b, 0x420, 0x430,
0x431, 0x438, 0x2bb, 0x20, 0x49, 0x3b, 0x420, 0x430, 0x431, 0x438, 0x2bb, 0x20,
0x49, 0x49, 0x3b, 0x408, 0x443, 0x43c, 0x430, 0x434, 0x430, 0x20, 0x49, 0x3b,
0x408, 0x443, 0x43c, 0x430, 0x434, 0x430, 0x20, 0x49, 0x49, 0x3b, 0x420, 0x430,
0x452, 0x430, 0x431, 0x3b, 0x428, 0x430, 0x2bb, 0x431, 0x430, 0x43d, 0x3b, 0x420,
0x430, 0x43c, 0x430, 0x434, 0x430, 0x43d, 0x3b, 0x428, 0x430, 0x432, 0x430, 0x43b,
0x3b, 0x414, 0x443, 0x2bb, 0x43b, 0x2d, 0x41a, 0x438, 0x2bb, 0x434, 0x430, 0x3b,
0x414, 0x443, 0x2bb, 0x43b, 0x2d, 0x445, 0x438, 0x452, 0x430, 0x4d, 0x75, 0x68,
0x61, 0x72, 0x65, 0x6d, 0x3b, 0x53, 0x61, 0x66, 0x65, 0x72, 0x3b, 0x52,
0x65, 0x62, 0x69, 0x20, 0x31, 0x3b, 0x52, 0x65, 0x62, 0x69, 0x20, 0x32,
0x3b, 0x44, 0x17e, 0x75, 0x6d, 0x61, 0x64, 0x65, 0x20, 0x31, 0x3b, 0x44,
0x17e, 0x75, 0x6d, 0x61, 0x64, 0x65, 0x20, 0x32, 0x3b, 0x52, 0x65, 0x64,
0x17e, 0x65, 0x62, 0x3b, 0x160, 0x61, 0x2bb, 0x62, 0x61, 0x6e, 0x3b, 0x52,
0x61, 0x6d, 0x61, 0x7a, 0x61, 0x6e, 0x3b, 0x160, 0x65, 0x76, 0x61, 0x6c,
0x3b, 0x5a, 0x75, 0x6c, 0x2d, 0x6b, 0x61, 0x64, 0x65, 0x3b, 0x5a, 0x75,
0x6c, 0x2d, 0x68, 0x69, 0x64, 0x17e, 0x65, 0x4d, 0x75, 0x68, 0x61, 0x72,
0x65, 0x6d, 0x3b, 0x53, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x52, 0x61, 0x62,
0x69, 0x2bb, 0x20, 0x49, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x2bb, 0x20, 0x49,
0x49, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x49, 0x3b, 0x4a,
0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x49, 0x49, 0x3b, 0x52, 0x61, 0x111,
0x61, 0x62, 0x3b, 0x160, 0x61, 0x2bb, 0x62, 0x61, 0x6e, 0x3b, 0x52, 0x61,
0x6d, 0x61, 0x64, 0x61, 0x6e, 0x3b, 0x160, 0x61, 0x76, 0x61, 0x6c, 0x3b,
0x44, 0x75, 0x2bb, 0x6c, 0x2d, 0x4b, 0x69, 0x2bb, 0x64, 0x61, 0x3b, 0x44,
0x75, 0x2bb, 0x6c, 0x2d, 0x68, 0x69, 0x111, 0x61, 0x4d, 0x75, 0x68, 0x2e,
0x3b, 0x53, 0x61, 0x66, 0x2e, 0x3b, 0x52, 0x65, 0x62, 0x2e, 0x20, 0x31,
0x3b, 0x52, 0x65, 0x62, 0x2e, 0x20, 0x32, 0x3b, 0x44, 0x17e, 0x75, 0x6d,
0x2e, 0x20, 0x31, 0x3b, 0x44, 0x17e, 0x75, 0x6d, 0x2e, 0x20, 0x32, 0x3b,
0x52, 0x65, 0x64, 0x17e, 0x2e, 0x3b, 0x160, 0x61, 0x2e, 0x3b, 0x52, 0x61,
0x6d, 0x2e, 0x3b, 0x160, 0x65, 0x2e, 0x3b, 0x5a, 0x75, 0x6c, 0x2d, 0x6b,
0x2e, 0x3b, 0x5a, 0x75, 0x6c, 0x2d, 0x68, 0x2e, 0x645, 0x62d, 0x631, 0x645,
0x3b, 0x635, 0x641, 0x631, 0x3b, 0x631, 0x628, 0x64a, 0x639, 0x20, 0x627, 0x644,
0x627, 0x648, 0x644, 0x3b, 0x631, 0x628, 0x6cc, 0x639, 0x20, 0x627, 0x644, 0x627,
0x62e, 0x631, 0x3b, 0x62c, 0x645, 0x627, 0x62f, 0x6cc, 0x20, 0x627, 0x644, 0x627,
0x648, 0x644, 0x3b, 0x62c, 0x645, 0x627, 0x62f, 0x64a, 0x20, 0x627, 0x644, 0x627,
0x62e, 0x631, 0x3b, 0x631, 0x62c, 0x628, 0x3b, 0x634, 0x639, 0x628, 0x627, 0x646,
0x3b, 0x631, 0x645, 0x636, 0x627, 0x646, 0x3b, 0x634, 0x648, 0x627, 0x644, 0x3b,
0x630, 0x648, 0x627, 0x644, 0x642, 0x639, 0x62f, 0x3b, 0x630, 0x648, 0x627, 0x644,
0x62d, 0x62c, 0x6c1, 0x61, 0x6c, 0x2d, 0x6d, 0x75, 0x68, 0x61, 0x72, 0x72,
0x61, 0x6d, 0x3b, 0x73, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x72, 0x61, 0x62,
0xed, 0xb4, 0x20, 0x61, 0x6c, 0x2d, 0x61, 0x76, 0x76, 0x61, 0x6c, 0x3b,
0x72, 0x61, 0x62, 0xed, 0xb4, 0x61, 0x74, 0x68, 0x2d, 0x74, 0x68, 0xe1,
0x6e, 0xed, 0x3b, 0x64, 0x17e, 0x75, 0x6d, 0xe1, 0x64, 0xe1, 0x20, 0x6c,
0x2d, 0xfa, 0x6c, 0xe1, 0x3b, 0x64, 0x17e, 0x75, 0x6d, 0xe1, 0x64, 0xe1,
0x20, 0x6c, 0x2d, 0xe1, 0x63, 0x68, 0x69, 0x72, 0x61, 0x3b, 0x72, 0x61,
0x64, 0x17e, 0x61, 0x62, 0x3b, 0x161, 0x61, 0xb4, 0x20, 0x62, 0xe1, 0x6e,
0x3b, 0x72, 0x61, 0x6d, 0x61, 0x64, 0xe1, 0x6e, 0x3b, 0x161, 0x61, 0x75,
0x76, 0xe1, 0x6c, 0x3b, 0x64, 0x68, 0xfa, 0x20, 0x6c, 0x2d, 0x6b, 0x61,
0xb4, 0x20, 0x64, 0x61, 0x3b, 0x64, 0x68, 0xfa, 0x20, 0x6c, 0x2d, 0x68,
0x69, 0x64, 0x17e, 0x64, 0x17e, 0x61, 0x6d, 0x75, 0x68, 0x2e, 0x3b, 0x73,
0x61, 0x66, 0x2e, 0x3b, 0x72, 0x61, 0x62, 0x2e, 0x20, 0x49, 0x3b, 0x72,
0x61, 0x62, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x64, 0x17e, 0x75, 0x6d, 0x2e,
0x20, 0x49, 0x3b, 0x64, 0x17e, 0x75, 0x6d, 0x2e, 0x20, 0x49, 0x49, 0x3b,
0x72, 0x61, 0x64, 0x2e, 0x3b, 0x161, 0x61, 0x2e, 0x3b, 0x72, 0x61, 0x6d,
0x2e, 0x3b, 0x161, 0x61, 0x75, 0x2e, 0x3b, 0x64, 0x68, 0xfa, 0x20, 0x6c,
0x2d, 0x6b, 0x2e, 0x3b, 0x64, 0x68, 0xfa, 0x20, 0x6c, 0x2d, 0x68, 0x2e,
0x4d, 0x75, 0x78, 0x61, 0x72, 0x72, 0x61, 0x6d, 0x3b, 0x53, 0x61, 0x66,
0x61, 0x72, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x63, 0x20, 0x61, 0x6c, 0x2d,
0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x63, 0x20,
0x61, 0x6c, 0x2d, 0x74, 0x68, 0x61, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6d,
0x61, 0x64, 0x61, 0x20, 0x61, 0x6c, 0x2d, 0x61, 0x77, 0x77, 0x61, 0x6c,
0x3b, 0x6a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x61, 0x6c, 0x2d, 0x74,
0x68, 0x61, 0x6e, 0x69, 0x3b, 0x52, 0x61, 0x6a, 0x61, 0x62, 0x3b, 0x53,
0x68, 0x61, 0x63, 0x62, 0x61, 0x6e, 0x3b, 0x52, 0x61, 0x6d, 0x61, 0x64,
0x61, 0x6e, 0x3b, 0x53, 0x68, 0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b, 0x44,
0x75, 0x6c, 0x20, 0x61, 0x6c, 0x2d, 0x71, 0x61, 0x63, 0x64, 0x61, 0x68,
0x3b, 0x44, 0x75, 0x6c, 0x20, 0x78, 0x69, 0x6a, 0x6a, 0x61, 0x68, 0x4d,
0x75, 0x78, 0x61, 0x72, 0x72, 0x61, 0x6d, 0x3b, 0x53, 0x61, 0x66, 0x61,
0x72, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x63, 0x20, 0x61, 0x6c, 0x2d, 0x61,
0x77, 0x77, 0x61, 0x6c, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x63, 0x20, 0x61,
0x6c, 0x2d, 0x74, 0x68, 0x61, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61,
0x64, 0x61, 0x20, 0x61, 0x6c, 0x2d, 0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b,
0x6a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x61, 0x6c, 0x2d, 0x74, 0x68,
0x61, 0x6e, 0x69, 0x3b, 0x52, 0x61, 0x6a, 0x61, 0x62, 0x3b, 0x53, 0x68,
0x61, 0x63, 0x62, 0x61, 0x6e, 0x3b, 0x52, 0x61, 0x6d, 0x61, 0x64, 0x61,
0x6e, 0x3b, 0x53, 0x68, 0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b, 0x44, 0x75,
0x6c, 0x20, 0x61, 0x6c, 0x2d, 0x71, 0x61, 0x63, 0x64, 0x61, 0x3b, 0x44,
0x75, 0x6c, 0x20, 0x78, 0x69, 0x6a, 0x6a, 0x61, 0x68, 0x4d, 0x75, 0x78,
0x2e, 0x3b, 0x53, 0x61, 0x66, 0x2e, 0x3b, 0x52, 0x61, 0x62, 0x2e, 0x20,
0x49, 0x3b, 0x52, 0x61, 0x62, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x4a, 0x75,
0x6d, 0x2e, 0x20, 0x49, 0x3b, 0x4a, 0x75, 0x6d, 0x2e, 0x20, 0x49, 0x49,
0x3b, 0x52, 0x61, 0x6a, 0x2e, 0x3b, 0x53, 0x68, 0x61, 0x2e, 0x3b, 0x52,
0x61, 0x6d, 0x2e, 0x3b, 0x53, 0x68, 0x61, 0x77, 0x2e, 0x3b, 0x44, 0x75,
0x6c, 0x2d, 0x51, 0x2e, 0x3b, 0x44, 0x75, 0x6c, 0x2d, 0x58, 0x2e, 0x4d,
0x75, 0x78, 0x2e, 0x3b, 0x53, 0x61, 0x66, 0x2e, 0x3b, 0x52, 0x61, 0x62,
0x2e, 0x20, 0x49, 0x3b, 0x52, 0x61, 0x62, 0x2e, 0x20, 0x49, 0x49, 0x3b,
0x4a, 0x75, 0x6d, 0x2e, 0x20, 0x49, 0x3b, 0x4a, 0x75, 0x6d, 0x2e, 0x20,
0x49, 0x49, 0x3b, 0x52, 0x61, 0x6a, 0x2e, 0x3b, 0x53, 0x68, 0x61, 0x2e,
0x3b, 0x52, 0x61, 0x6d, 0x2e, 0x3b, 0x53, 0x68, 0x61, 0x77, 0x2e, 0x3b,
0x44, 0x75, 0x6c, 0x2019, 0x2d, 0x51, 0x69, 0x63, 0x64, 0x61, 0x2e, 0x3b,
0x44, 0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x48, 0x2e, 0x6d, 0x75, 0x68, 0x61,
0x72, 0x72, 0x61, 0x6d, 0x3b, 0x73, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x72,
0x61, 0x62, 0x69, 0x2bb, 0x20, 0x49, 0x3b, 0x72, 0x61, 0x62, 0x69, 0x2bb,
0x20, 0x49, 0x49, 0x3b, 0x6a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x49,
0x3b, 0x6a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x49, 0x49, 0x3b, 0x72,
0x61, 0x6a, 0x61, 0x62, 0x3b, 0x73, 0x68, 0x61, 0x2bb, 0x62, 0x61, 0x6e,
0x3b, 0x72, 0x61, 0x6d, 0x61, 0x64, 0xe1, 0x6e, 0x3b, 0x73, 0x68, 0x61,
0x77, 0x77, 0x61, 0x6c, 0x3b, 0x64, 0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x71,
0x69, 0x2bb, 0x64, 0x61, 0x68, 0x3b, 0x64, 0x68, 0x75, 0x2bb, 0x6c, 0x2d,
0x68, 0x69, 0x6a, 0x6a, 0x61, 0x68, 0x4d, 0x75, 0x68, 0x61, 0x72, 0x72,
0x61, 0x6d, 0x3b, 0x53, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x52, 0x61, 0x62,
0x69, 0x2019, 0x20, 0x61, 0x6c, 0x2d, 0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b,
0x52, 0x61, 0x62, 0x69, 0x2019, 0x20, 0x61, 0x6c, 0x2d, 0x61, 0x6b, 0x68,
0x69, 0x72, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x2d, 0x6c, 0x2d,
0x75, 0x6c, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x2d, 0x6c,
0x2d, 0x61, 0x6b, 0x68, 0x69, 0x72, 0x61, 0x3b, 0x52, 0x61, 0x6a, 0x61,
0x62, 0x3b, 0x53, 0x68, 0x61, 0x2019, 0x62, 0x61, 0x6e, 0x3b, 0x52, 0x61,
0x6d, 0x61, 0x64, 0x61, 0x6e, 0x3b, 0x53, 0x68, 0x61, 0x77, 0x77, 0x61,
0x6c, 0x3b, 0x44, 0x68, 0x75, 0x2d, 0x6c, 0x2d, 0x67, 0x61, 0x2019, 0x64,
0x61, 0x3b, 0x44, 0x68, 0x75, 0x2d, 0x6c, 0x2d, 0x68, 0x69, 0x6a, 0x6a,
0x61, 0x6d, 0x75, 0x68, 0x61, 0x72, 0x72, 0x61, 0x6d, 0x3b, 0x73, 0x61,
0x66, 0x61, 0x72, 0x3b, 0x72, 0x61, 0x62, 0x69, 0x2019, 0x20, 0x61, 0x6c,
0x2d, 0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b, 0x72, 0x61, 0x62, 0x69, 0x2019,
0x20, 0x61, 0x6c, 0x2d, 0x61, 0x6b, 0x68, 0x69, 0x72, 0x3b, 0x6a, 0x75,
0x6d, 0x61, 0x64, 0x61, 0x2d, 0x6c, 0x2d, 0x75, 0x6c, 0x61, 0x3b, 0x6a,
0x75, 0x6d, 0x61, 0x64, 0x61, 0x2d, 0x6c, 0x2d, 0x61, 0x6b, 0x68, 0x69,
0x72, 0x61, 0x3b, 0x72, 0x61, 0x6a, 0x61, 0x62, 0x3b, 0x73, 0x68, 0x61,
0x2019, 0x62, 0x61, 0x6e, 0x3b, 0x72, 0x61, 0x6d, 0x61, 0x64, 0x61, 0x6e,
0x3b, 0x73, 0x68, 0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b, 0x64, 0x68, 0x75,
0x2d, 0x6c, 0x2d, 0x67, 0x61, 0x2019, 0x64, 0x61, 0x3b, 0x64, 0x68, 0x75,
0x2d, 0x6c, 0x2d, 0x68, 0x69, 0x6a, 0x6a, 0x61, 0x721, 0x718, 0x71a, 0x72a,
0x721, 0x3b, 0x728, 0x726, 0x72a, 0x3b, 0x72a, 0x712, 0x71d, 0x725, 0x20, 0x729,
0x715, 0x721, 0x71d, 0x710, 0x3b, 0x72a, 0x712, 0x71d, 0x725, 0x20, 0x72c, 0x72a,
0x71d, 0x722, 0x710, 0x3b, 0x713, 0x718, 0x721, 0x715, 0x710, 0x20, 0x729, 0x715,
0x721, 0x71d, 0x710, 0x3b, 0x713, 0x718, 0x721, 0x715, 0x710, 0x20, 0x72c, 0x72a,
0x71d, 0x722, 0x710, 0x3b, 0x72a, 0x713, 0x712, 0x3b, 0x72b, 0x725, 0x712, 0x710,
0x722, 0x3b, 0x72a, 0x721, 0x728, 0x710, 0x722, 0x3b, 0x72b, 0x718, 0x710, 0x720,
0x3b, 0x715, 0x718, 0x720, 0x729, 0x725, 0x715, 0x717, 0x3b, 0x715, 0x718, 0x720,
0x71a, 0x713, 0x717, 0x41c, 0x443, 0x4b3, 0x430, 0x440, 0x440, 0x430, 0x43c, 0x3b,
0x421, 0x430, 0x444, 0x430, 0x440, 0x3b, 0x420, 0x430, 0x431, 0x435, 0x44a, 0x20,
0x49, 0x3b, 0x420, 0x430, 0x431, 0x435, 0x44a, 0x20, 0x49, 0x49, 0x3b, 0x4b6,
0x438, 0x43c, 0x43e, 0x434, 0x438, 0x2d, 0x443, 0x43b, 0x2d, 0x443, 0x43b, 0x43e,
0x3b, 0x4b6, 0x438, 0x43c, 0x43e, 0x434, 0x438, 0x2d, 0x443, 0x43b, 0x2d, 0x441,
0x43e, 0x43d, 0x438, 0x3b, 0x420, 0x430, 0x4b7, 0x430, 0x431, 0x3b, 0x428, 0x430,
0x44a, 0x431, 0x43e, 0x43d, 0x3b, 0x420, 0x430, 0x43c, 0x430, 0x437, 0x43e, 0x43d,
0x3b, 0x428, 0x430, 0x430, 0x432, 0x43e, 0x43b, 0x3b, 0x414, 0x445, 0x443, 0x43b,
0x2d, 0x49a, 0x438, 0x434, 0x430, 0x4b3, 0x3b, 0x414, 0x445, 0x443, 0x43b, 0x2d,
0x4b2, 0x438, 0x4b7, 0x4b7, 0x430, 0x4b3, 0x41c, 0x443, 0x4b3, 0x430, 0x440, 0x440,
0x430, 0x43c, 0x3b, 0x421, 0x430, 0x444, 0x430, 0x440, 0x3b, 0x420, 0x430, 0x431,
0x435, 0x44a, 0x20, 0x49, 0x3b, 0x420, 0x430, 0x431, 0x435, 0x44a, 0x20, 0x49,
0x49, 0x3b, 0x4b7, 0x438, 0x43c, 0x43e, 0x434, 0x438, 0x2d, 0x443, 0x43b, 0x2d,
0x443, 0x43b, 0x43e, 0x3b, 0x4b7, 0x438, 0x43c, 0x43e, 0x434, 0x438, 0x2d, 0x443,
0x43b, 0x2d, 0x441, 0x43e, 0x43d, 0x438, 0x3b, 0x440, 0x430, 0x4b7, 0x430, 0x431,
0x3b, 0x428, 0x430, 0x431, 0x430, 0x43d, 0x3b, 0x420, 0x430, 0x43c, 0x430, 0x434,
0x430, 0x43d, 0x3b, 0x428, 0x430, 0x432, 0x432, 0x430, 0x43b, 0x3b, 0x414, 0x445,
0x443, 0x442, 0x2d, 0x49a, 0x438, 0x434, 0x430, 0x4b3, 0x3b, 0x414, 0x445, 0x443,
0x442, 0x2d, 0x4b2, 0x438, 0x4b7, 0x4b7, 0x430, 0x4b3, 0x41c, 0x443, 0x4b3, 0x2e,
0x3b, 0x421, 0x430, 0x444, 0x2e, 0x3b, 0x420, 0x430, 0x431, 0x2e, 0x20, 0x49,
0x3b, 0x420, 0x430, 0x431, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x4b6, 0x443, 0x43c,
0x2e, 0x20, 0x49, 0x3b, 0x4b6, 0x443, 0x43c, 0x2e, 0x20, 0x49, 0x49, 0x3b,
0x420, 0x430, 0x4b7, 0x2e, 0x3b, 0x428, 0x430, 0x2e, 0x3b, 0x420, 0x430, 0x43c,
0x2e, 0x3b, 0x428, 0x430, 0x432, 0x2e, 0x3b, 0x414, 0x445, 0x443, 0x43b, 0x2d,
0x49a, 0x2e, 0x3b, 0x414, 0x445, 0x443, 0x43b, 0x2d, 0x4b2, 0x2e, 0xbae, 0xbc1,
0xbb9, 0xbb0, 0xbcd, 0xbb0, 0xbae, 0xbcd, 0x3b, 0xb9a, 0xb83, 0xbaa, 0xbb0, 0xbcd,
0x3b, 0xbb0, 0xbaa, 0xbbf, 0x20, 0x31, 0x3b, 0xbb0, 0xbaa, 0xbbf, 0x20, 0x32,
0x3b, 0xb9c, 0xbc1, 0xbae, 0xba4, 0xbbe, 0x20, 0x31, 0x3b, 0xb9c, 0xbc1, 0xbae,
0xba4, 0xbbe, 0x20, 0x32, 0x3b, 0xbb0, 0xb9c, 0xbaa, 0xbcd, 0x3b, 0xbb7, 0xb83,
0xbaa, 0xbbe, 0xba9, 0xbcd, 0x3b, 0xbb0, 0xbae, 0xbb2, 0xbbe, 0xba9, 0xbcd, 0x3b,
0xbb7, 0xbb5, 0xbcd, 0xbb5, 0xbbe, 0xbb2, 0xbcd, 0x3b, 0xba4, 0xbc1, 0xbb2, 0xbcd,
0x20, 0xb95, 0xb83, 0xba4, 0xbbe, 0x3b, 0xba4, 0xbc1, 0xbb2, 0xbcd, 0x20, 0xbb9,
0xbbf, 0xb9c, 0xbcd, 0xb9c, 0xbbe, 0xbae, 0xbc1, 0xbb9, 0x2e, 0x3b, 0xb9a, 0xb83,
0xbaa, 0x2e, 0x3b, 0xbb0, 0xbaa, 0xbbf, 0x20, 0x31, 0x3b, 0xbb0, 0xbaa, 0xbbf,
0x20, 0x32, 0x3b, 0xb9c, 0xbc1, 0xbae, 0x2e, 0x20, 0x31, 0x3b, 0xb9c, 0xbc1,
0xbae, 0x2e, 0x20, 0x32, 0x3b, 0xbb0, 0xb9c, 0x2e, 0x3b, 0xbb7, 0xb83, 0x2e,
0x3b, 0xbb0, 0xbae, 0x2e, 0x3b, 0xbb7, 0xbb5, 0xbcd, 0x2e, 0x3b, 0xba4, 0xbc1,
0xbb2, 0xbcd, 0x20, 0xb95, 0xb83, 0x2e, 0x3b, 0xba4, 0xbc1, 0xbb2, 0xbcd, 0x20,
0xbb9, 0xbbf, 0xb9c, 0xbcd, 0x2e, 0xc2e, 0xc41, 0xc39, 0xc30, 0xc4d, 0xc30, 0xc02,
0x3b, 0xc38, 0xc2b, 0xc30, 0xc4d, 0x3b, 0xc30, 0xc2c, 0xc40, 0x20, 0x49, 0x3b,
0xc30, 0xc2c, 0xc40, 0x20, 0x49, 0x49, 0x3b, 0xc1c, 0xc41, 0xc2e, 0xc26, 0xc3e,
0x20, 0x49, 0x3b, 0xc1c, 0xc41, 0xc2e, 0xc26, 0xc3e, 0x20, 0x49, 0x49, 0x3b,
0xc30, 0xc1c, 0xc2c, 0xc4d, 0x3b, 0xc37, 0xc2c, 0xc3e, 0xc28, 0xc4d, 0x3b, 0xc30,
0xc02, 0xc1c, 0xc3e, 0xc28, 0xc4d, 0x3b, 0xc37, 0xc35, 0xc4d, 0xc35, 0xc3e, 0xc32,
0xc4d, 0x3b, 0xc27, 0xc41, 0xc32, 0xc4d, 0x2d, 0xc15, 0xc3f, 0x20, 0xc26, 0xc3e,
0xc39, 0xc4d, 0x3b, 0xc27, 0xc41, 0xc32, 0xc4d, 0x2d, 0xc39, 0xc3f, 0xc1c, 0xc4d,
0xc1c, 0xc3e, 0xc39, 0xc4d, 0xc2e, 0xc41, 0xc39, 0x2e, 0x3b, 0xc38, 0xc2b, 0x2e,
0x3b, 0xc30, 0x2e, 0x20, 0x49, 0x3b, 0xc30, 0x2e, 0x20, 0x49, 0x49, 0x3b,
0xc1c, 0xc41, 0xc2e, 0x2e, 0x20, 0x49, 0x3b, 0xc1c, 0xc41, 0xc2e, 0x2e, 0x20,
0x49, 0x49, 0x3b, 0xc30, 0xc1c, 0x2e, 0x3b, 0xc37, 0xc2c, 0xc3e, 0x2e, 0x3b,
0xc30, 0xc02, 0xc1c, 0xc3e, 0x2e, 0x3b, 0xc37, 0xc35, 0xc4d, 0xc35, 0xc3e, 0x2e,
0x3b, 0xc27, 0xc41, 0xc32, 0xc4d, 0x2d, 0xc15, 0xc3f, 0x2e, 0x3b, 0xc27, 0xc41,
0xc32, 0xc4d, 0x2d, 0xc39, 0xc3f, 0x2e, 0xe21, 0xe38, 0xe2e, 0xe30, 0xe23, 0xe4c,
0xe23, 0xe2d, 0xe21, 0x3b, 0xe0b, 0xe2d, 0xe1f, 0xe32, 0xe23, 0xe4c, 0x3b, 0xe23,
0xe2d, 0xe1a, 0xe35, 0x20, 0x49, 0x3b, 0xe23, 0xe2d, 0xe1a, 0xe35, 0x20, 0x49,
0x49, 0x3b, 0xe08, 0xe38, 0xe21, 0xe32, 0xe14, 0xe32, 0x20, 0x49, 0x3b, 0xe08,
0xe38, 0xe21, 0xe32, 0xe14, 0xe32, 0x20, 0x49, 0x49, 0x3b, 0xe23, 0xe2d, 0xe08,
0xe31, 0xe1a, 0x3b, 0xe0a, 0xe30, 0xe2d, 0xe30, 0xe1a, 0xe32, 0xe19, 0x3b, 0xe23,
0xe2d, 0xe21, 0xe30, 0xe14, 0xe2d, 0xe19, 0x3b, 0xe40, 0xe0a, 0xe32, 0xe27, 0xe31,
0xe25, 0x3b, 0xe0b, 0xe38, 0xe25, 0xe01, 0xe34, 0xe2d, 0xe3a, 0xe14, 0xe30, 0xe2e,
0xe3a, 0x3b, 0xe0b, 0xe38, 0xe25, 0xe2b, 0xe34, 0xe08, 0xe0d, 0xe30, 0xe2e, 0xe3a,
0xe21, 0xe38, 0xe2e, 0xe31, 0xe23, 0x2e, 0x3b, 0xe40, 0xe28, 0xe32, 0xe30, 0x2e,
0x3b, 0xe23, 0xe2d, 0xe1a, 0xe35, 0x20, 0x49, 0x3b, 0xe23, 0xe2d, 0xe1a, 0xe35,
0x20, 0x49, 0x49, 0x3b, 0xe08, 0xe38, 0xe21, 0xe32, 0xe14, 0xe32, 0x20, 0x49,
0x3b, 0xe08, 0xe38, 0xe21, 0xe32, 0xe14, 0xe32, 0x20, 0x49, 0x49, 0x3b, 0xe40,
0xe23, 0xe32, 0xe30, 0x2e, 0x3b, 0xe0a, 0xe30, 0xe2d, 0xe4c, 0x2e, 0x3b, 0xe40,
0xe23, 0xe32, 0xe30, 0xe21, 0xe30, 0x2e, 0x3b, 0xe40, 0xe0a, 0xe32, 0xe27, 0x2e,
0x3b, 0xe0b, 0xe38, 0xe25, 0xe01, 0xe34, 0xe2d, 0xe3a, 0x2e, 0x3b, 0xe0b, 0xe38,
0xe25, 0xe2b, 0xe34, 0xe08, 0x2e, 0x4d, 0x75, 0x68, 0x61, 0x6c, 0x61, 0x6d,
0x69, 0x3b, 0x53, 0x61, 0x66, 0x61, 0x6c, 0x69, 0x3b, 0x4c, 0x61, 0x70,
0x12b, 0x20, 0x49, 0x3b, 0x4c, 0x61, 0x70, 0x12b, 0x20, 0x49, 0x49, 0x3b,
0x53, 0x75, 0x6d, 0x61, 0x74, 0x101, 0x20, 0x49, 0x3b, 0x53, 0x75, 0x6d,
0x61, 0x74, 0x101, 0x20, 0x49, 0x49, 0x3b, 0x4c, 0x61, 0x73, 0x61, 0x70,
0x69, 0x3b, 0x53, 0x61, 0x2bb, 0x61, 0x70, 0x101, 0x6e, 0x69, 0x3b, 0x4c,
0x61, 0x6d, 0x61, 0x74, 0x101, 0x6e, 0x69, 0x3b, 0x53, 0x61, 0x76, 0x101,
0x6c, 0x69, 0x3b, 0x53, 0x16b, 0x2d, 0x6b, 0x61, 0x2bb, 0x61, 0x74, 0x61,
0x3b, 0x53, 0x16b, 0x2d, 0x68, 0x69, 0x73, 0x61, 0x4d, 0x75, 0x68, 0x3b,
0x53, 0x61, 0x66, 0x3b, 0x4c, 0x61, 0x70, 0x20, 0x49, 0x3b, 0x4c, 0x61,
0x70, 0x20, 0x49, 0x49, 0x3b, 0x53, 0x75, 0x6d, 0x20, 0x49, 0x3b, 0x53,
0x75, 0x6d, 0x20, 0x49, 0x49, 0x3b, 0x4c, 0x61, 0x73, 0x3b, 0x53, 0x61,
0x2bb, 0x61, 0x3b, 0x4c, 0x61, 0x6d, 0x3b, 0x53, 0x61, 0x76, 0x3b, 0x53,
0x16b, 0x2d, 0x6b, 0x3b, 0x53, 0x16b, 0x2d, 0x68, 0x4d, 0x75, 0x68, 0x61,
0x72, 0x72, 0x65, 0x6d, 0x3b, 0x53, 0x61, 0x66, 0x65, 0x72, 0x3b, 0x52,
0x65, 0x62, 0x69, 0xfc, 0x6c, 0x65, 0x76, 0x76, 0x65, 0x6c, 0x3b, 0x52,
0x65, 0x62, 0x69, 0xfc, 0x6c, 0x61, 0x68, 0x69, 0x72, 0x3b, 0x43, 0x65,
0x6d, 0x61, 0x7a, 0x69, 0x79, 0x65, 0x6c, 0x65, 0x76, 0x76, 0x65, 0x6c,
0x3b, 0x43, 0x65, 0x6d, 0x61, 0x7a, 0x69, 0x79, 0x65, 0x6c, 0x61, 0x68,
0x69, 0x72, 0x3b, 0x52, 0x65, 0x63, 0x65, 0x70, 0x3b, 0x15e, 0x61, 0x62,
0x61, 0x6e, 0x3b, 0x52, 0x61, 0x6d, 0x61, 0x7a, 0x61, 0x6e, 0x3b, 0x15e,
0x65, 0x76, 0x76, 0x61, 0x6c, 0x3b, 0x5a, 0x69, 0x6c, 0x6b, 0x61, 0x64,
0x65, 0x3b, 0x5a, 0x69, 0x6c, 0x68, 0x69, 0x63, 0x63, 0x65, 0x4d, 0x75,
0x68, 0x61, 0x72, 0x2e, 0x3b, 0x53, 0x61, 0x66, 0x65, 0x72, 0x3b, 0x52,
0x2e, 0x65, 0x76, 0x76, 0x65, 0x6c, 0x3b, 0x52, 0x2e, 0x61, 0x68, 0x69,
0x72, 0x3b, 0x43, 0x2e, 0x65, 0x76, 0x76, 0x65, 0x6c, 0x3b, 0x43, 0x2e,
0x61, 0x68, 0x69, 0x72, 0x3b, 0x52, 0x65, 0x63, 0x65, 0x70, 0x3b, 0x15e,
0x61, 0x62, 0x61, 0x6e, 0x3b, 0x52, 0x61, 0x6d, 0x2e, 0x3b, 0x15e, 0x65,
0x76, 0x76, 0x61, 0x6c, 0x3b, 0x5a, 0x69, 0x6c, 0x6b, 0x61, 0x64, 0x65,
0x3b, 0x5a, 0x69, 0x6c, 0x68, 0x69, 0x63, 0x63, 0x65, 0x41, 0x15f, 0x79,
0x72, 0x3b, 0x53, 0x61, 0x70, 0x61, 0x72, 0x3b, 0x44, 0xf6, 0x72, 0x74,
0x20, 0x74, 0x69, 0x72, 0x6b, 0x65, 0x15f, 0x69, 0x6b, 0x20, 0x31, 0x3b,
0x44, 0xf6, 0x72, 0x74, 0x20, 0x74, 0x69, 0x72, 0x6b, 0x65, 0x15f, 0x69,
0x6b, 0x20, 0x32, 0x3b, 0x44, 0xf6, 0x72, 0x74, 0x20, 0x74, 0x69, 0x72,
0x6b, 0x65, 0x15f, 0x69, 0x6b, 0x20, 0x33, 0x3b, 0x44, 0xf6, 0x72, 0x74,
0x20, 0x74, 0x69, 0x72, 0x6b, 0x65, 0x15f, 0x69, 0x6b, 0x20, 0x34, 0x3b,
0x52, 0x65, 0x6a, 0x65, 0x70, 0x3b, 0x4d, 0x65, 0x72, 0x65, 0x74, 0x3b,
0x4f, 0x72, 0x61, 0x7a, 0x61, 0x3b, 0x42, 0x61, 0xfd, 0x72, 0x61, 0x6d,
0x3b, 0x42, 0x6f, 0x15f, 0x20, 0x61, 0xfd, 0x3b, 0x47, 0x75, 0x72, 0x62,
0x61, 0x6e, 0x41, 0x15f, 0x79, 0x3b, 0x53, 0x61, 0x70, 0x3b, 0x54, 0x69,
0x72, 0x20, 0x49, 0x3b, 0x54, 0x69, 0x72, 0x20, 0x49, 0x49, 0x3b, 0x54,
0x69, 0x72, 0x20, 0x49, 0x49, 0x49, 0x3b, 0x54, 0x69, 0x72, 0x20, 0x49,
0x56, 0x3b, 0x52, 0x65, 0x6a, 0x3b, 0x4d, 0x65, 0x72, 0x3b, 0x4f, 0x72,
0x61, 0x3b, 0x42, 0x61, 0xfd, 0x3b, 0x42, 0x6f, 0x15f, 0x3b, 0x47, 0x75,
0x72, 0x43c, 0x443, 0x445, 0x430, 0x440, 0x440, 0x430, 0x43c, 0x3b, 0x441, 0x430,
0x444, 0x430, 0x440, 0x3b, 0x440, 0x430, 0x431, 0x456, 0x20, 0x49, 0x3b, 0x440,
0x430, 0x431, 0x456, 0x20, 0x49, 0x49, 0x3b, 0x434, 0x436, 0x443, 0x43c, 0x430,
0x434, 0x430, 0x20, 0x49, 0x3b, 0x434, 0x436, 0x443, 0x43c, 0x430, 0x434, 0x430,
0x20, 0x49, 0x49, 0x3b, 0x440, 0x430, 0x434, 0x436, 0x430, 0x431, 0x3b, 0x448,
0x430, 0x430, 0x431, 0x430, 0x43d, 0x3b, 0x440, 0x430, 0x43c, 0x430, 0x434, 0x430,
0x43d, 0x3b, 0x434, 0x430, 0x432, 0x432, 0x430, 0x43b, 0x3b, 0x437, 0x443, 0x2d,
0x43b, 0x44c, 0x2d, 0x43a, 0x430, 0x430, 0x434, 0x430, 0x3b, 0x437, 0x443, 0x2d,
0x43b, 0x44c, 0x2d, 0x445, 0x456, 0x434, 0x436, 0x430, 0x43c, 0x443, 0x445, 0x3b,
0x441, 0x430, 0x444, 0x3b, 0x440, 0x430, 0x431, 0x456, 0x20, 0x49, 0x3b, 0x440,
0x430, 0x431, 0x456, 0x20, 0x49, 0x49, 0x3b, 0x434, 0x436, 0x443, 0x43c, 0x20,
0x49, 0x3b, 0x434, 0x436, 0x443, 0x43c, 0x20, 0x49, 0x49, 0x3b, 0x440, 0x430,
0x434, 0x436, 0x3b, 0x448, 0x430, 0x430, 0x431, 0x3b, 0x440, 0x430, 0x43c, 0x3b,
0x434, 0x430, 0x432, 0x3b, 0x437, 0x443, 0x2d, 0x43b, 0x44c, 0x2d, 0x43a, 0x3b,
0x437, 0x443, 0x2d, 0x43b, 0x44c, 0x2d, 0x445, 0x43c, 0x443, 0x445, 0x2e, 0x3b,
0x441, 0x430, 0x444, 0x2e, 0x3b, 0x440, 0x430, 0x431, 0x456, 0x20, 0x49, 0x3b,
0x440, 0x430, 0x431, 0x456, 0x20, 0x49, 0x49, 0x3b, 0x434, 0x436, 0x443, 0x43c,
0x2e, 0x20, 0x49, 0x3b, 0x434, 0x436, 0x443, 0x43c, 0x2e, 0x20, 0x49, 0x49,
0x3b, 0x440, 0x430, 0x434, 0x436, 0x2e, 0x3b, 0x448, 0x430, 0x430, 0x431, 0x2e,
0x3b, 0x440, 0x430, 0x43c, 0x2e, 0x3b, 0x434, 0x430, 0x432, 0x2e, 0x3b, 0x437,
0x443, 0x2d, 0x43b, 0x44c, 0x2d, 0x43a, 0x2e, 0x3b, 0x437, 0x443, 0x2d, 0x43b,
0x44c, 0x2d, 0x445, 0x2e, 0x645, 0x62d, 0x631, 0x645, 0x3b, 0x635, 0x641, 0x631,
0x3b, 0x631, 0x20, 0x628, 0x6cc, 0x639, 0x20, 0x627, 0x644, 0x627, 0x648, 0x644,
0x3b, 0x631, 0x20, 0x628, 0x6cc, 0x639, 0x20, 0x627, 0x644, 0x62b, 0x627, 0x646,
0x6cc, 0x3b, 0x62c, 0x645, 0x627, 0x62f, 0x6cc, 0x20, 0x627, 0x644, 0x627, 0x648,
0x644, 0x3b, 0x62c, 0x645, 0x627, 0x62f, 0x6cc, 0x20, 0x627, 0x644, 0x62b, 0x627,
0x646, 0x6cc, 0x3b, 0x631, 0x62c, 0x628, 0x3b, 0x634, 0x639, 0x628, 0x627, 0x646,
0x3b, 0x631, 0x645, 0x636, 0x627, 0x646, 0x3b, 0x634, 0x648, 0x627, 0x644, 0x3b,
0x630, 0x648, 0x627, 0x644, 0x642, 0x639, 0x62f, 0x6c3, 0x3b, 0x630, 0x648, 0x627,
0x644, 0x62d, 0x62c, 0x6c3, 0x645, 0x62d, 0x631, 0x645, 0x3b, 0x635, 0x641, 0x631,
0x3b, 0x631, 0x628, 0x6cc, 0x639, 0x20, 0x627, 0x644, 0x627, 0x648, 0x651, 0x644,
0x3b, 0x631, 0x628, 0x6cc, 0x639, 0x20, 0x627, 0x644, 0x62b, 0x651, 0x627, 0x646,
0x6cc, 0x3b, 0x62c, 0x645, 0x627, 0x62f, 0x6cc, 0x20, 0x627, 0x644, 0x627, 0x648,
0x651, 0x644, 0x3b, 0x62c, 0x645, 0x627, 0x62f, 0x6cc, 0x20, 0x627, 0x644, 0x62b,
0x651, 0x627, 0x646, 0x6cc, 0x3b, 0x631, 0x62c, 0x628, 0x3b, 0x634, 0x639, 0x628,
0x627, 0x646, 0x3b, 0x631, 0x645, 0x636, 0x627, 0x646, 0x3b, 0x634, 0x648, 0x627,
0x644, 0x3b, 0x630, 0x648, 0x627, 0x644, 0x642, 0x639, 0x62f, 0x6c3, 0x3b, 0x630,
0x648, 0x627, 0x644, 0x62d, 0x62c, 0x6c3, 0x645, 0x62d, 0x631, 0x645, 0x3b, 0x635,
0x641, 0x631, 0x3b, 0x631, 0x628, 0x6cc, 0x639, 0x20, 0x627, 0x644, 0x627, 0x648,
0x651, 0x644, 0x3b, 0x631, 0x628, 0x6cc, 0x639, 0x20, 0x627, 0x644, 0x62b, 0x627,
0x646, 0x6cc, 0x3b, 0x62c, 0x645, 0x627, 0x62f, 0x6cc, 0x20, 0x627, 0x644, 0x627,
0x648, 0x651, 0x644, 0x3b, 0x62c, 0x645, 0x627, 0x62f, 0x6cc, 0x20, 0x627, 0x644,
0x62b, 0x627, 0x646, 0x6cc, 0x3b, 0x631, 0x62c, 0x628, 0x3b, 0x634, 0x639, 0x628,
0x627, 0x646, 0x3b, 0x631, 0x645, 0x636, 0x627, 0x646, 0x3b, 0x634, 0x648, 0x627,
0x644, 0x3b, 0x630, 0x648, 0x627, 0x644, 0x642, 0x639, 0x62f, 0x6c3, 0x3b, 0x630,
0x648, 0x627, 0x644, 0x62d, 0x62c, 0x6c3, 0x645, 0x6c7, 0x6be, 0x6d5, 0x631, 0x631,
0x6d5, 0x645, 0x3b, 0x633, 0x6d5, 0x67e, 0x6d5, 0x631, 0x3b, 0x631, 0x6d5, 0x628,
0x649, 0x626, 0x6c7, 0x644, 0x626, 0x6d5, 0x6cb, 0x6cb, 0x6d5, 0x644, 0x3b, 0x631,
0x6d5, 0x628, 0x649, 0x626, 0x6c7, 0x644, 0x626, 0x627, 0x62e, 0x649, 0x631, 0x3b,
0x62c, 0x6d5, 0x645, 0x627, 0x62f, 0x649, 0x64a, 0x6d5, 0x644, 0x626, 0x6d5, 0x6cb,
0x6cb, 0x6d5, 0x644, 0x3b, 0x62c, 0x6d5, 0x645, 0x627, 0x62f, 0x649, 0x64a, 0x6d5,
0x644, 0x626, 0x627, 0x62e, 0x649, 0x631, 0x3b, 0x631, 0x6d5, 0x62c, 0x6d5, 0x628,
0x3b, 0x634, 0x6d5, 0x626, 0x628, 0x627, 0x646, 0x3b, 0x631, 0x627, 0x645, 0x649,
0x632, 0x627, 0x646, 0x3b, 0x634, 0x6d5, 0x6cb, 0x6cb, 0x627, 0x644, 0x3b, 0x632,
0x6c7, 0x644, 0x642, 0x6d5, 0x626, 0x62f, 0x6d5, 0x3b, 0x632, 0x6c7, 0x644, 0x6be,
0x6d5, 0x62c, 0x62c, 0x6d5, 0x4d, 0x75, 0x68, 0x61, 0x72, 0x72, 0x61, 0x6d,
0x3b, 0x53, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x2bc,
0x75, 0x6c, 0x20, 0x61, 0x76, 0x76, 0x61, 0x6c, 0x3b, 0x52, 0x61, 0x62,
0x69, 0x2bc, 0x75, 0x73, 0x20, 0x73, 0x6f, 0x6e, 0x69, 0x79, 0x3b, 0x4a,
0x75, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x20, 0x61, 0x76, 0x76, 0x61, 0x6c,
0x3b, 0x4a, 0x75, 0x6d, 0x6f, 0x64, 0x75, 0x73, 0x20, 0x73, 0x6f, 0x6e,
0x69, 0x79, 0x3b, 0x52, 0x61, 0x6a, 0x61, 0x62, 0x3b, 0x53, 0x68, 0x61,
0x2019, 0x62, 0x6f, 0x6e, 0x3b, 0x52, 0x61, 0x6d, 0x61, 0x7a, 0x6f, 0x6e,
0x3b, 0x53, 0x68, 0x61, 0x76, 0x76, 0x6f, 0x6c, 0x3b, 0x5a, 0x75, 0x6c,
0x71, 0x61, 0x2bc, 0x64, 0x61, 0x3b, 0x5a, 0x75, 0x6c, 0x68, 0x69, 0x6a,
0x6a, 0x61, 0x4d, 0x75, 0x68, 0x2e, 0x3b, 0x53, 0x61, 0x66, 0x2e, 0x3b,
0x52, 0x61, 0x62, 0x2e, 0x20, 0x61, 0x76, 0x76, 0x2e, 0x3b, 0x52, 0x61,
0x62, 0x2e, 0x20, 0x73, 0x6f, 0x6e, 0x2e, 0x3b, 0x4a, 0x75, 0x6d, 0x2e,
0x20, 0x61, 0x76, 0x76, 0x2e, 0x3b, 0x4a, 0x75, 0x6d, 0x2e, 0x20, 0x73,
0x6f, 0x6e, 0x2e, 0x3b, 0x52, 0x61, 0x6a, 0x2e, 0x3b, 0x53, 0x68, 0x61,
0x2e, 0x3b, 0x52, 0x61, 0x6d, 0x2e, 0x3b, 0x53, 0x68, 0x61, 0x76, 0x2e,
0x3b, 0x5a, 0x75, 0x6c, 0x71, 0x2e, 0x3b, 0x5a, 0x75, 0x6c, 0x68, 0x2e,
0x41c, 0x443, 0x4b3, 0x430, 0x440, 0x440, 0x430, 0x43c, 0x3b, 0x421, 0x430, 0x444,
0x430, 0x440, 0x3b, 0x420, 0x430, 0x431, 0x438, 0x443, 0x43b, 0x2d, 0x430, 0x432,
0x432, 0x430, 0x43b, 0x3b, 0x420, 0x430, 0x431, 0x438, 0x443, 0x43b, 0x2d, 0x43e,
0x445, 0x438, 0x440, 0x3b, 0x416, 0x443, 0x43c, 0x43e, 0x434, 0x438, 0x443, 0x43b,
0x2d, 0x443, 0x43b, 0x43e, 0x3b, 0x416, 0x443, 0x43c, 0x43e, 0x434, 0x438, 0x443,
0x43b, 0x2d, 0x443, 0x445, 0x440, 0x43e, 0x3b, 0x420, 0x430, 0x436, 0x430, 0x431,
0x3b, 0x428, 0x430, 0x44a, 0x431, 0x43e, 0x43d, 0x3b, 0x420, 0x430, 0x43c, 0x430,
0x437, 0x43e, 0x43d, 0x3b, 0x428, 0x430, 0x432, 0x432, 0x43e, 0x43b, 0x3b, 0x417,
0x438, 0x43b, 0x2d, 0x49b, 0x430, 0x44a, 0x434, 0x430, 0x3b, 0x417, 0x438, 0x43b,
0x2d, 0x4b3, 0x438, 0x436, 0x436, 0x430, 0x4d, 0x6f, 0x68, 0x61, 0x72, 0x72,
0x61, 0x6d, 0x3b, 0x53, 0x61, 0x70, 0x61, 0x72, 0x3b, 0x52, 0x61, 0x62,
0x69, 0x2bb, 0x20, 0x49, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x2bb, 0x20, 0x49,
0x49, 0x3b, 0x4a, 0x61, 0x6d, 0xe1, 0x64, 0x69, 0x20, 0x49, 0x3b, 0x4a,
0x61, 0x6d, 0xe1, 0x64, 0x69, 0x20, 0x49, 0x49, 0x3b, 0x52, 0x61, 0x6a,
0x61, 0x62, 0x3b, 0x53, 0x68, 0xe1, 0x62, 0xe1, 0x6e, 0x3b, 0x52, 0x61,
0x6d, 0x65, 0x7a, 0xe1, 0x6e, 0x3b, 0x53, 0x68, 0x61, 0x75, 0x77, 0xe1,
0x6c, 0x3b, 0x5a, 0x6f, 0x6c, 0x6b, 0xe1, 0x64, 0x61, 0x3b, 0x5a, 0x6f,
0x6c, 0x68, 0x61, 0x6a, 0x6a, 0x4d, 0x6f, 0x68, 0x2e, 0x3b, 0x53, 0x61,
0x70, 0x2e, 0x3b, 0x52, 0x61, 0x62, 0x2e, 0x20, 0x49, 0x3b, 0x52, 0x61,
0x62, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x4a, 0x61, 0x6d, 0x2e, 0x20, 0x49,
0x3b, 0x4a, 0x61, 0x6d, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x52, 0x61, 0x6a,
0x2e, 0x3b, 0x53, 0x68, 0x61, 0x2e, 0x3b, 0x52, 0x61, 0x6d, 0x2e, 0x3b,
0x53, 0x68, 0x61, 0x77, 0x2e, 0x3b, 0x5a, 0x6f, 0x6c, 0x2d, 0x4b, 0x2e,
0x3b, 0x5a, 0x6f, 0x6c, 0x2d, 0x48, 0x2e, 0x1019, 0x1030, 0x1087, 0x1081, 0x1083,
0x1087, 0x101b, 0x1019, 0x103a, 0x1087, 0x3b, 0x101e, 0x1083, 0x1087, 0x107e, 0x1083, 0x1087,
0x3b, 0x101b, 0x1083, 0x1087, 0x1015, 0x102e, 0x1087, 0x20, 0x49, 0x3b, 0x101b, 0x1083,
0x1087, 0x1015, 0x102e, 0x1087, 0x20, 0x49, 0x49, 0x3b, 0x1075, 0x103b, 0x1030, 0x1087,
0x1019, 0x1083, 0x1087, 0x1010, 0x1083, 0x1087, 0x20, 0x49, 0x3b, 0x1075, 0x103b, 0x1030,
0x1087, 0x1019, 0x1083, 0x1087, 0x1010, 0x1083, 0x1087, 0x20, 0x49, 0x49, 0x3b, 0x101b,
0x1083, 0x1087, 0x1078, 0x1062, 0x1015, 0x103a, 0x1089, 0x3b, 0x101e, 0x103b, 0x1083, 0x1038,
0x1015, 0x1062, 0x107c, 0x103a, 0x1087, 0x3b, 0x101b, 0x1083, 0x1087, 0x1019, 0x1083, 0x1087,
0x1010, 0x1062, 0x107c, 0x103a, 0x1087, 0x3b, 0x101e, 0x103b, 0x1031, 0x1083, 0x1038, 0x101d,
0x1083, 0x1087, 0x101c, 0x103a, 0x3b, 0x107b, 0x1030, 0x101d, 0x103a, 0x1087, 0x101c, 0x103a,
0x2d, 0x1075, 0x102d, 0x1010, 0x3b, 0x107b, 0x1030, 0x101d, 0x103a, 0x1087, 0x101c, 0x103a,
0x1081, 0x102d, 0x1010, 0x103a, 0x1089, 0x1078, 0x1083, 0x1087, 0x1019, 0x1030, 0x1087, 0x2e,
0x3b, 0x101e, 0x1083, 0x1087, 0x2e, 0x3b, 0x101b, 0x1083, 0x1087, 0x2e, 0x20, 0x49,
0x3b, 0x101b, 0x1083, 0x1087, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x1075, 0x103b, 0x1030,
0x1087, 0x2e, 0x20, 0x49, 0x3b, 0x1075, 0x103b, 0x1030, 0x1087, 0x2e, 0x20, 0x49,
0x49, 0x3b, 0x101b, 0x1083, 0x1087, 0x1078, 0x103a, 0x2e, 0x3b, 0x101e, 0x103b, 0x1083,
0x1038, 0x2e, 0x3b, 0x101b, 0x1083, 0x2e, 0x3b, 0x101e, 0x103b, 0x1031, 0x1083, 0x1038,
0x2e, 0x3b, 0x107b, 0x1030, 0x101d, 0x103a, 0x1087, 0x101c, 0x103a, 0x2e, 0x1075, 0x2e,
0x3b, 0x107b, 0x1030, 0x101d, 0x103a, 0x1087, 0x101c, 0x103a, 0x2e, 0x1081, 0x2e
};
// GENERATED PART ENDS HERE

} // namespace QtPrivate::Hijri

QT_END_NAMESPACE

#endif // QHIJRI_CALENDAR_DATA_P_H
