/*
 * Decompiled with CFR 0.152.
 */
package kawa;

import gnu.expr.Language;
import gnu.kawa.io.CheckConsole;
import gnu.kawa.io.InPort;
import gnu.kawa.io.OutPort;
import gnu.kawa.io.Path;
import gnu.kawa.io.QueueReader;
import gnu.kawa.io.TtyInPort;
import gnu.mapping.Environment;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import kawa.Shell;
import org.domterm.Backend;
import org.domterm.util.DomTermErrorWriter;
import org.domterm.util.Utf8WriterOutputStream;

public class DomTermBackend
extends Backend
implements Runnable {
    Language language;
    QueueReader inIn;
    Appendable inOut;
    OutputStream inOutS;
    boolean usingJLine;
    TtyInPort in_p;
    Method setSizeMethod;
    public volatile int nrows = -1;
    public volatile int ncols = -1;
    public volatile int pixw;
    public volatile int pixh;

    public DomTermBackend(Language language, Environment penvironment, boolean shared) {
        this.language = language;
    }

    public DomTermBackend() {
        this(Language.getDefaultLanguage(), Environment.getCurrent(), false);
    }

    @Override
    public void run() {
        Path inPath;
        OutPort outp;
        DomTermErrorWriter errWriter;
        block7: {
            errWriter = new DomTermErrorWriter(this.termWriter);
            outp = new OutPort(this.termWriter, true, true, Path.valueOf("/dev/stdout"));
            outp.setDomTerm(true);
            inPath = Path.valueOf("/dev/stdin");
            int useJLine = CheckConsole.useJLine();
            if (useJLine >= 0) {
                try {
                    PipedInputStream in = new PipedInputStream();
                    this.inOutS = new PipedOutputStream(in);
                    Class<?> JLineClass = Class.forName("gnu.kawa.io.JLineInPort");
                    this.in_p = (TtyInPort)JLineClass.getConstructor(InputStream.class, Path.class, OutputStream.class, OutPort.class).newInstance(in, inPath, new Utf8WriterOutputStream((Writer)outp), outp);
                    this.setSizeMethod = JLineClass.getMethod("setSize", Integer.TYPE, Integer.TYPE);
                    this.usingJLine = true;
                }
                catch (Throwable ex) {
                    this.inOutS = null;
                    if (useJLine <= 0) break block7;
                    ex.printStackTrace();
                }
            }
        }
        if (this.in_p == null) {
            QueueReader inQ;
            this.inIn = inQ = new QueueReader(){

                @Override
                public void checkAvailable() {
                }
            };
            this.inOut = inQ;
            this.in_p = new TtyInPort(this.inIn, inPath, outp);
        }
        this.in_p.setInDomTerm(true);
        InPort.setInDefault(this.in_p);
        OutPort.setOutDefault(outp);
        OutPort.setErrDefault(new OutPort((Writer)errWriter, true, true, Path.valueOf("/dev/stderr")));
        Environment env = Environment.getCurrent();
        try {
            this.sendInputMode(this.usingJLine ? (char)'c' : 'p');
            this.setAutomaticNewline(true);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        if (this.nrows >= 0) {
            this.setWindowSize(this.nrows, this.ncols, this.pixw, this.pixh);
        }
        Shell.run(this.language, env);
    }

    public void run(Writer out) throws Exception {
        this.termWriter = out;
        Thread thread2 = new Thread(this);
        thread2.start();
    }

    public void processInputCharacters(String text) {
        try {
            if (this.inOutS != null) {
                this.inOutS.write(text.getBytes());
                this.inOutS.flush();
            } else if (this.inOut != null) {
                this.inOut.append(text, 0, text.length());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setWindowSize(int nrows, int ncols, int pixw, int pixh) {
        this.nrows = nrows;
        this.ncols = ncols;
        this.pixw = pixw;
        this.pixh = pixh;
        if (this.in_p != null && this.setSizeMethod != null) {
            try {
                this.setSizeMethod.invoke((Object)this.in_p, ncols, nrows);
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
    }
}

