/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.ImmutablePair;
import gnu.text.SourceLocator;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class PairWithPosition
extends ImmutablePair
implements SourceLocator {
    String filename;
    int position;

    public final void setFile(String string) {
        this.filename = string;
    }

    public final void setLine(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        this.position = (n << 12) + n2;
    }

    public final void setLine(int n) {
        this.setLine(n, 0);
    }

    public final String getFileName() {
        return this.filename;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.filename;
    }

    public final int getLineNumber() {
        int n = this.position >> 12;
        return n == 0 ? -1 : n;
    }

    public final int getColumnNumber() {
        int n = this.position & 0xFFF;
        return n == 0 ? -1 : n;
    }

    public boolean isStableSourceLocation() {
        return true;
    }

    public PairWithPosition() {
    }

    public PairWithPosition(SourceLocator sourceLocator, Object object2, Object object3) {
        super(object2, object3);
        this.filename = sourceLocator.getFileName();
        this.setLine(sourceLocator.getLineNumber(), sourceLocator.getColumnNumber());
    }

    public PairWithPosition(Object object2, Object object3) {
        super(object2, object3);
    }

    public static PairWithPosition make(Object object2, Object object3, String string, int n, int n2) {
        PairWithPosition pairWithPosition = new PairWithPosition(object2, object3);
        pairWithPosition.filename = string;
        pairWithPosition.setLine(n, n2);
        return pairWithPosition;
    }

    public static PairWithPosition make(Object object2, Object object3, String string, int n) {
        PairWithPosition pairWithPosition = new PairWithPosition(object2, object3);
        pairWithPosition.filename = string;
        pairWithPosition.position = n;
        return pairWithPosition;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.car);
        objectOutput.writeObject(this.cdr);
        objectOutput.writeObject(this.filename);
        objectOutput.writeInt(this.position);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.car = objectInput.readObject();
        this.cdr = objectInput.readObject();
        this.filename = (String)objectInput.readObject();
        this.position = objectInput.readInt();
    }
}

