/*
 * Decompiled with CFR 0.152.
 */
package kawa;

import gnu.expr.Language;
import gnu.mapping.Environment;
import gnu.mapping.Future;
import gnu.mapping.OutPort;
import gnu.text.QueueReader;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Writer;
import kawa.GuiInPort;
import kawa.MessageArea;
import kawa.repl;
import kawa.standard.Scheme;

public class GuiConsole
extends Frame
implements ActionListener {
    private static String CLOSE = "Close";
    private static String EXIT = "Exit";
    private static String NEW = "New";
    private static String NEW_SHARED = "New (Shared)";
    private static String PURGE_MESSAGE = "Purge Buffer";
    static int window_number = 0;
    Language language;
    Environment environment;
    Future thread;
    QueueReader in_r;
    OutPort out_p;
    OutPort err_p;
    MessageArea message = null;

    public static void main(String[] args) {
        Scheme language = Scheme.getInstance();
        new GuiConsole();
    }

    public GuiConsole() {
        this(Language.getDefaultLanguage(), Environment.getCurrent(), false);
    }

    public GuiConsole(Language language, Environment penvironment, boolean shared) {
        super("Kawa");
        this.language = language;
        this.in_r = new QueueReader();
        this.message = new MessageArea(this.in_r);
        ++window_number;
        repl.exitIncrement();
        this.out_p = new OutPort((Writer)this.message.getStdout(), true, "<msg_stdout>");
        this.err_p = new OutPort((Writer)this.message.getStderr(), true, "<msg_stderr>");
        GuiInPort in_p = new GuiInPort(this.in_r, "<msg_stdin>", this.out_p, this.message);
        this.setLayout(new BorderLayout(0, 0));
        this.add("Center", this.message);
        this.setupMenus();
        this.setLocation(100 * window_number, 50 * window_number);
        this.setSize(700, 500);
        this.setVisible(true);
        this.thread = new Future(new repl(language), penvironment, in_p, this.out_p, this.err_p);
        Environment env = this.thread.getEnvironment();
        if (shared) {
            env.setIndirectDefines();
        }
        this.environment = env;
        this.thread.start();
    }

    void close() {
        this.in_r.appendEOF();
        this.dispose();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread.stop();
        repl.exitDecrement();
    }

    private void setupMenus() {
        WindowAdapter windowExitCmd = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                GuiConsole.this.close();
            }
        };
        MenuBar menubar = new MenuBar();
        Menu fileMenu = new Menu("File");
        Menu utilitiesMenu = new Menu("Utilities");
        menubar.add(fileMenu);
        menubar.add(utilitiesMenu);
        MenuItem menuItem = new MenuItem(NEW);
        menuItem.addActionListener(this);
        fileMenu.add(menuItem);
        menuItem = new MenuItem(NEW_SHARED);
        menuItem.addActionListener(this);
        fileMenu.add(menuItem);
        menuItem = new MenuItem(CLOSE);
        menuItem.addActionListener(this);
        fileMenu.add(menuItem);
        menuItem = new MenuItem(EXIT);
        menuItem.addActionListener(this);
        this.addWindowListener(windowExitCmd);
        fileMenu.add(menuItem);
        menuItem = new MenuItem(PURGE_MESSAGE);
        menuItem.addActionListener(this);
        utilitiesMenu.add(menuItem);
        this.setMenuBar(menubar);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(NEW)) {
            new GuiConsole(this.language, Environment.getGlobal(), false);
        } else if (cmd.equals(NEW_SHARED)) {
            new GuiConsole(this.language, this.environment, true);
        } else if (cmd.equals(EXIT)) {
            System.exit(0);
        } else if (cmd.equals(CLOSE)) {
            this.close();
        } else if (cmd.equals(PURGE_MESSAGE)) {
            this.message.deleteOldText();
        } else {
            OutPort.outDefault().println("Unknown menu action: " + cmd);
        }
    }
}

