/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml;

import gnu.lists.Consumer;
import gnu.lists.FilterConsumer;
import gnu.lists.TreeList;
import gnu.mapping.Symbol;
import gnu.xml.XMLParserChar;

public class NamespaceResolver
extends FilterConsumer {
    XMLParserChar parser;
    String[] nameStack = new String[30];
    int[] startIndexes = new int[10];
    int attrCount;
    boolean inStartTag;
    boolean inAttribute;
    TreeList tlist;
    Consumer cons;
    String[] namespaceStack;
    int namespaceStackLength;
    int[] namespaceLengthStack = new int[10];
    int nesting;
    StringBuffer stringValue;
    public boolean namespacePrefixes = false;
    int indexHashMask = 31;
    int[] indexHash = new int[this.indexHashMask + 1];
    int indexHashCount;
    int nextIndex;
    boolean mismatchReported;

    public NamespaceResolver(Consumer consumer) {
        super(consumer);
        this.cons = consumer;
        this.tlist = consumer instanceof TreeList ? (TreeList)consumer : new TreeList();
        this.namespaceStack = new String[10];
        this.namespaceStack[0] = "xml";
        this.namespaceStack[1] = "http://www.w3.org/XML/1998/namespace";
        this.namespaceStackLength = 2;
    }

    public void setParser(XMLParserChar xMLParserChar) {
        this.parser = xMLParserChar;
    }

    public void beginGroup(String string, Object object2) {
        this.closeStartTag();
        if (this.nesting >= this.namespaceLengthStack.length) {
            int[] nArray = new int[2 * this.nesting];
            System.arraycopy(this.namespaceLengthStack, 0, nArray, 0, this.nesting);
            this.namespaceLengthStack = nArray;
        }
        this.namespaceLengthStack[this.nesting] = this.namespaceStackLength;
        ++this.nesting;
        this.inStartTag = true;
        this.startIndexes[0] = this.tlist.gapStart;
        this.tlist.beginGroup(0);
        this.base = this.tlist;
        string = string.intern();
        this.attrCount = 0;
        this.nameStack[0] = string;
        int n = string.indexOf(58);
        if (n > 0) {
            this.nameStack[1] = string.substring(0, n).intern();
            this.nameStack[2] = string.substring(n + 1).intern();
        } else {
            this.nameStack[1] = null;
            this.nameStack[2] = string;
        }
    }

    public void endAttribute() {
        this.inAttribute = false;
        if (this.stringValue == null || this.namespacePrefixes) {
            this.tlist.endAttribute();
        }
        if (this.stringValue != null) {
            String string = this.stringValue.toString();
            this.namespaceStack[this.namespaceStackLength + 1] = string = string.length() == 0 ? null : string.intern();
            this.namespaceStackLength += 2;
            this.stringValue = null;
        }
    }

    public void beginAttribute(String string, Object object2) {
        Object object3;
        String[] stringArray;
        ++this.attrCount;
        if (this.attrCount >= this.startIndexes.length) {
            stringArray = new String[2 * this.nameStack.length];
            System.arraycopy(this.nameStack, 0, stringArray, 0, this.nameStack.length);
            this.nameStack = stringArray;
            object3 = new int[2 * this.startIndexes.length];
            System.arraycopy(this.startIndexes, 0, object3, 0, this.attrCount);
            this.startIndexes = object3;
        }
        if (this.namespaceStackLength >= this.namespaceStack.length) {
            stringArray = new String[2 * this.namespaceStack.length];
            System.arraycopy(this.namespaceStack, 0, stringArray, 0, this.namespaceStackLength);
            this.namespaceStack = stringArray;
        }
        string = string.intern();
        int n = string.indexOf(58);
        this.nameStack[3 * this.attrCount] = string;
        this.startIndexes[this.attrCount] = this.tlist.gapStart;
        if (n > 0) {
            object3 = string.substring(0, n).intern();
            String string2 = string.substring(n + 1).intern();
            this.nameStack[3 * this.attrCount + 1] = object3;
            this.nameStack[3 * this.attrCount + 2] = string2;
            if (object3 == "xmlns") {
                this.namespaceStack[this.namespaceStackLength] = string2;
                this.stringValue = new StringBuffer(100);
            }
        } else {
            this.nameStack[3 * this.attrCount + 1] = null;
            this.nameStack[3 * this.attrCount + 2] = string;
            if (string == "xmlns") {
                this.namespaceStack[this.namespaceStackLength] = null;
                this.stringValue = new StringBuffer(100);
            }
        }
        if (this.stringValue == null || this.namespacePrefixes) {
            this.tlist.beginAttribute(0);
        }
        this.inAttribute = true;
    }

    private String resolve(String string) {
        int n = this.namespaceStackLength;
        while ((n -= 2) >= 0) {
            String string2 = this.namespaceStack[n];
            if (string2 != string && (string != null || string2 != null)) continue;
            return this.namespaceStack[n + 1];
        }
        return "";
    }

    int getIndex(String string, Object object2) {
        int n = string == null ? 0 : string.hashCode();
        int n2 = n & this.indexHashMask;
        Object[] objectArray = this.tlist.objects;
        int n3 = this.indexHash[n2];
        if (n3 > 0 && objectArray[n3 - 1] == string && objectArray[n3] == object2) {
            return n3 - 1;
        }
        n3 = this.tlist.find(string, object2);
        this.indexHash[n2] = n3 + 1;
        return n3;
    }

    void closeStartTag() {
        if (!this.inStartTag || this.inAttribute) {
            return;
        }
        this.inStartTag = false;
        this.endAttributes();
    }

    protected void endAttributes() {
        int n = 0;
        while (n <= this.attrCount) {
            int n2;
            String string = this.nameStack[3 * n];
            String string2 = this.nameStack[3 * n + 1];
            String string3 = this.nameStack[3 * n + 2];
            boolean bl = string == "xmlns" || string2 == "xmlns";
            String string4 = bl ? "(namespace-node)" : this.resolve(string2);
            Symbol symbol = Symbol.make(string4, string3);
            if (this.cons == this.tlist) {
                n2 = this.getIndex(string, symbol);
                if (n == 0) {
                    this.tlist.setIntN(this.tlist.gapEnd + 1, n2);
                } else if (!bl || this.namespacePrefixes) {
                    this.tlist.setIntN(this.startIndexes[n] + 1, n2);
                }
            } else if (n == 0) {
                this.cons.beginGroup(string, symbol);
            } else if (!bl || this.namespacePrefixes) {
                this.cons.beginAttribute(string, symbol);
                n2 = this.startIndexes[n];
                int n3 = n < this.attrCount ? this.startIndexes[n + 1] : this.tlist.gapStart;
                this.tlist.consumeIRange(n2 + 5, n3 - 1, this.cons);
                this.cons.endAttribute();
            }
            ++n;
        }
        if (this.cons != this.tlist) {
            this.base = this.cons;
            this.tlist.clear();
        }
        this.attrCount = 0;
    }

    public void endGroup(String string) {
        this.closeStartTag();
        if (this.nesting <= 0) {
            return;
        }
        --this.nesting;
        this.namespaceStackLength = this.namespaceLengthStack[this.nesting];
        this.base.endGroup(string);
    }

    public void writeChar(int n) {
        this.closeStartTag();
        if (this.stringValue != null) {
            this.stringValue.append((char)n);
            if (!this.namespacePrefixes) {
                return;
            }
        }
        this.base.writeChar(n);
    }

    public void writeBoolean(boolean bl) {
        this.closeStartTag();
        if (this.stringValue != null) {
            this.stringValue.append(bl);
            if (!this.namespacePrefixes) {
                return;
            }
        }
        this.base.writeBoolean(bl);
    }

    public void writeFloat(float f) {
        this.closeStartTag();
        if (this.stringValue != null) {
            this.stringValue.append(f);
            if (!this.namespacePrefixes) {
                return;
            }
        }
        this.base.writeFloat(f);
    }

    public void writeDouble(double d) {
        this.closeStartTag();
        if (this.stringValue != null) {
            this.stringValue.append(d);
            if (!this.namespacePrefixes) {
                return;
            }
        }
        this.base.writeDouble(d);
    }

    public void writeInt(int n) {
        this.closeStartTag();
        if (this.stringValue != null) {
            this.stringValue.append(n);
        }
        this.writeInt(n);
    }

    public void writeLong(long l) {
        this.closeStartTag();
        if (this.stringValue != null) {
            this.stringValue.append(l);
            if (!this.namespacePrefixes) {
                return;
            }
        }
        this.writeLong(l);
    }

    public void writeObject(Object object2) {
        this.closeStartTag();
        if (this.stringValue != null) {
            this.stringValue.append(object2);
            if (!this.namespacePrefixes) {
                return;
            }
        }
        this.base.writeObject(object2);
    }

    public void writeChars(String string) {
        this.closeStartTag();
        if (this.stringValue != null) {
            this.stringValue.append(string);
            if (!this.namespacePrefixes) {
                return;
            }
        }
        this.base.writeChars(string);
    }

    public void write(char[] cArray, int n, int n2) {
        this.closeStartTag();
        if (this.stringValue != null) {
            this.stringValue.append(cArray, n, n2);
            if (!this.namespacePrefixes) {
                return;
            }
        }
        this.base.write(cArray, n, n2);
    }
}

