/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.swing;

import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.Marker;
import gnu.jemacs.swing.BufferContent;
import gnu.jemacs.swing.SwingBuffer;
import gnu.mapping.InPort;
import gnu.text.NullReader;
import java.io.IOException;

public class MarkerReader
extends InPort {
    Marker marker;
    BufferContent content;

    public MarkerReader(Buffer buffer) {
        this(buffer, buffer.pointMarker);
    }

    public MarkerReader(Marker marker) {
        this(marker.getBuffer(), marker);
    }

    MarkerReader(Buffer buffer, Marker marker) {
        super(NullReader.nullReader, buffer.getName());
        this.marker = marker;
        this.content = ((SwingBuffer)buffer).content;
        this.buffer = this.content.getArray();
    }

    public int read() {
        int n = this.marker.getOffset();
        this.buffer = this.content.getArray();
        if (n >= this.content.gapStart) {
            n += this.content.gapEnd - this.content.gapStart;
        }
        int n2 = this.buffer.length;
        this.pos = n;
        if (n >= n2) {
            this.limit = n;
            return -1;
        }
        char c = this.buffer[this.pos];
        ++this.pos;
        this.limit = this.pos;
        return c;
    }

    public int getLineNumber() {
        throw new Error("MarkerReader. getLineNumber - not implemented");
    }

    public int getColumnNumber() {
        throw new Error("MarkerReader,getColumnNumber - not implemented");
    }

    public void reset() throws IOException {
        throw new Error("MarkerReader.reset - not implemented");
    }
}

