/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.text.LineBufferedReader;
import gnu.text.SourceLocator;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;

public class SourceError
implements SourceLocator {
    public SourceError next;
    public char severity;
    public String filename;
    public String code;
    public int line;
    public int column;
    public String message;
    public Throwable fakeException;

    public SourceError(char severity, String filename, int line, int column, String message) {
        this.severity = severity;
        this.filename = filename;
        this.line = line;
        this.column = column;
        this.message = message;
    }

    public SourceError(char severity, SourceLocator location2, String message) {
        this(severity, location2.getFileName(), location2.getLineNumber(), location2.getColumnNumber(), message);
    }

    public SourceError(LineBufferedReader port, char severity, String message) {
        this(severity, port.getName(), port.getLineNumber() + 1, port.getColumnNumber(), message);
        if (this.column >= 0) {
            ++this.column;
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean stripDirectories) {
        String fname;
        StringBuffer buffer = new StringBuffer();
        if (this.filename == null) {
            fname = "<unknown>";
        } else {
            fname = this.filename;
            if (stripDirectories) {
                fname = new File(fname).getName();
            }
        }
        buffer.append(fname);
        if (this.line > 0 || this.column > 0) {
            buffer.append(':');
            buffer.append(this.line);
            if (this.column > 0) {
                buffer.append(':');
                buffer.append(this.column);
            }
        }
        buffer.append(": ");
        if (this.severity == 'w') {
            buffer.append("warning - ");
        } else if (this.severity == 'i') {
            buffer.append("note - ");
        }
        buffer.append(this.message);
        if (this.code != null) {
            buffer.append(" [");
            buffer.append(this.code);
            buffer.append("]");
        }
        if (this.fakeException != null) {
            StackTraceElement[] stackTrace = this.fakeException.getStackTrace();
            for (int i = 0; i < stackTrace.length; ++i) {
                buffer.append("\n");
                buffer.append("    ");
                buffer.append(stackTrace[i].toString());
            }
        }
        return buffer.toString();
    }

    public void print(PrintWriter out) {
        out.print(this);
    }

    public void println(PrintWriter out, boolean stripDirectories) {
        int nl;
        String line = this.toString(stripDirectories);
        while ((nl = line.indexOf(10)) >= 0) {
            out.println(line.substring(0, nl));
            line = line.substring(nl + 1);
        }
        out.println(line);
    }

    public void println(PrintStream out, boolean stripDirectories) {
        int nl;
        String line = this.toString();
        while ((nl = line.indexOf(10)) >= 0) {
            out.println(line.substring(0, nl));
            line = line.substring(nl + 1);
        }
        out.println(line);
    }

    public int getLineNumber() {
        return this.line == 0 ? -1 : this.line;
    }

    public int getColumnNumber() {
        return this.column == 0 ? -1 : this.column;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.filename;
    }

    public String getFileName() {
        return this.filename;
    }

    public boolean isStableSourceLocation() {
        return true;
    }
}

