/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.concurrent.datastructures;

import com.sun.electric.tool.util.concurrent.datastructures.CircularArray;
import com.sun.electric.tool.util.concurrent.datastructures.IDEStructure;
import java.util.concurrent.atomic.AtomicInteger;

public class UnboundedDEQueue<T>
extends IDEStructure<T> {
    private volatile CircularArray<T> elements;
    private volatile int bottom;
    private AtomicInteger top;

    public UnboundedDEQueue(int LOG_CAPACITY) {
        this.elements = new CircularArray(LOG_CAPACITY);
        this.top = new AtomicInteger(0);
        this.bottom = 0;
    }

    @Override
    public T getFromTop() {
        int oldTop = this.top.get();
        int newTop = oldTop + 1;
        int oldBottom = this.bottom;
        int size = oldBottom - oldTop;
        if (size <= 0) {
            return null;
        }
        T elem = this.elements.get(oldTop);
        if (this.top.compareAndSet(oldTop, newTop)) {
            return elem;
        }
        return null;
    }

    @Override
    public void add(T item) {
        int oldBottom = this.bottom;
        int oldTop = this.top.get();
        CircularArray<T> currentElements = this.elements;
        int size = oldBottom - this.top.get();
        if (size >= currentElements.getCapacity() - 1) {
            currentElements = currentElements.resize(oldBottom, oldTop);
            this.elements = currentElements;
        }
        this.elements.add(item, oldBottom);
        this.bottom = oldBottom + 1;
    }

    @Override
    public T remove() {
        --this.bottom;
        int oldTop = this.top.get();
        int newTop = oldTop + 1;
        int size = this.bottom - oldTop;
        if (size < 0) {
            this.bottom = oldTop;
            return null;
        }
        T item = this.elements.get(this.bottom);
        if (size > 0) {
            return item;
        }
        if (!this.top.compareAndSet(oldTop, newTop)) {
            item = null;
        }
        this.bottom = oldTop + 1;
        return item;
    }

    @Override
    public boolean isEmpty() {
        return this.bottom <= this.top.get();
    }

    @Override
    @Deprecated
    public boolean isFull() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean tryAdd(T item) {
        throw new UnsupportedOperationException();
    }
}

