/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.plugins.j3d;

import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Iterator;
import org.jogamp.java3d.Behavior;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.WakeupCondition;
import org.jogamp.java3d.WakeupCriterion;
import org.jogamp.java3d.WakeupOnAWTEvent;
import org.jogamp.java3d.WakeupOr;
import org.jogamp.vecmath.Matrix4d;
import org.jogamp.vecmath.Vector3d;

public class J3DKeyBehavior
extends Behavior {
    protected static final double FAST_SPEED = 10.0;
    protected static final double NORMAL_SPEED = 1.0;
    protected TransformGroup tGroup;
    protected Transform3D transform;
    protected WakeupCondition keyCriterion;
    private double delta = 5.0;
    private double rotateAmount = 0.3141592653589793;
    private double speed = 1.0;
    private int forwardKey = 38;
    private int backKey = 40;
    private int leftKey = 37;
    private int rightKey = 39;
    private static double[] values = new double[3];
    private static Vector3d move = new Vector3d();
    private static final int X = 0;
    private static final int Y = 1;
    private static final int Z = 2;
    private static Transform3D toMove = new Transform3D();

    public J3DKeyBehavior(TransformGroup tg) {
        this.tGroup = tg;
        this.transform = new Transform3D();
    }

    public void initialize() {
        WakeupCriterion[] keyEvents = new WakeupCriterion[]{new WakeupOnAWTEvent(401), new WakeupOnAWTEvent(402)};
        this.keyCriterion = new WakeupOr(keyEvents);
        this.wakeupOn(this.keyCriterion);
    }

    public void processStimulus(Iterator<WakeupCriterion> criteria) {
        while (criteria.hasNext()) {
            WakeupCriterion wakeup = criteria.next();
            if (!(wakeup instanceof WakeupOnAWTEvent)) continue;
            AWTEvent[] event = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
            for (int i = 0; i < event.length; ++i) {
                if (event[i].getID() != 401 && event[i].getID() != 402) continue;
                this.processKeyEvent((KeyEvent)event[i]);
            }
        }
        this.wakeupOn(this.keyCriterion);
    }

    protected void processKeyEvent(KeyEvent event) {
        int keycode = event.getKeyCode();
        this.speed = event.isShiftDown() ? 10.0 : 1.0;
        if (event.isAltDown()) {
            this.altMove(keycode);
        } else if (event.isControlDown()) {
            this.controlMove(keycode);
        } else {
            this.standardMove(keycode);
        }
    }

    private void standardMove(int keycode) {
        if (keycode == this.forwardKey) {
            this.moveAlongAxis(2, 1);
        } else if (keycode == this.backKey) {
            this.moveAlongAxis(2, -1);
        } else if (keycode == this.leftKey) {
            this.rotateAlongAxis(1, 1);
        } else if (keycode == this.rightKey) {
            this.rotateAlongAxis(1, -1);
        }
    }

    protected void altMove(int keycode) {
        if (keycode == this.forwardKey) {
            this.rotateAlongAxis(0, 1);
        } else if (keycode == this.backKey) {
            this.rotateAlongAxis(0, -1);
        } else if (keycode == this.leftKey) {
            this.moveAlongAxis(0, -1);
        } else if (keycode == this.rightKey) {
            this.moveAlongAxis(0, 1);
        }
    }

    protected void controlMove(int keycode) {
        if (keycode == this.forwardKey) {
            this.moveAlongAxis(1, 1);
        } else if (keycode == this.backKey) {
            this.moveAlongAxis(1, -1);
        } else if (keycode == this.leftKey) {
            this.rotateAlongAxis(2, 1);
        } else if (keycode == this.rightKey) {
            this.rotateAlongAxis(2, -1);
        }
    }

    public void moveAlongAxis(int axis, int dir) {
        Arrays.fill(values, 0.0);
        J3DKeyBehavior.values[axis] = (double)dir * this.getMovementRate();
        move.set(values);
        if (!this.doMove(move, false)) {
            J3DKeyBehavior.values[axis] = (double)(-dir) * this.getMovementRate();
            move.set(values);
            this.doMove(move, true);
        }
    }

    protected void rotateAlongAxis(int axis, int dir) {
        double radian = this.rotateAmount * this.speed;
        if (!this.rotate(axis, (double)dir * radian, false)) {
            this.rotate(axis, (double)(-dir) * radian, true);
        }
    }

    protected boolean updateTransform(boolean force) {
        this.tGroup.setTransform(this.transform);
        return true;
    }

    public void setHomeRotation(double[] rotVals) {
        for (int i = 0; i < rotVals.length; ++i) {
            this.rotate(i, rotVals[i], true);
        }
    }

    protected boolean rotate(int axis, double radians, boolean force) {
        this.tGroup.getTransform(this.transform);
        Transform3D toMove = new Transform3D();
        switch (axis) {
            case 0: {
                toMove.rotX(radians);
                break;
            }
            case 1: {
                toMove.rotY(radians);
                break;
            }
            case 2: {
                toMove.rotZ(radians);
            }
        }
        this.transform.mul(toMove);
        boolean noCollision = this.updateTransform(force);
        return noCollision;
    }

    void zoomInOut(boolean out) {
        double z_factor = 0.7;
        double factor = out ? 1.0 / z_factor : z_factor;
        this.tGroup.getTransform(this.transform);
        Matrix4d mat = new Matrix4d();
        this.transform.get(mat);
        double dy = this.transform.getScale() * factor;
        this.transform.setScale(dy);
        this.tGroup.setTransform(this.transform);
    }

    private boolean doMove(Vector3d theMove, boolean force) {
        this.tGroup.getTransform(this.transform);
        toMove.setIdentity();
        toMove.setTranslation(theMove);
        this.transform.mul(toMove);
        return this.updateTransform(force);
    }

    protected double getMovementRate() {
        return this.delta * this.speed;
    }
}

