/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tests;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.extract.Connectivity;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.tests.AbstractTest;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.ECoord;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

public class ExtractionTest
extends AbstractTest {
    public ExtractionTest(String name) {
        super(name);
    }

    public static List<AbstractTest> getTests() {
        ArrayList<AbstractTest> list = new ArrayList<AbstractTest>();
        list.add(new ExtractionTest("Extract1"));
        list.add(new ExtractionTest("Extract2"));
        list.add(new ExtractionTest("Extract3"));
        list.add(new ExtractionTest("Extract4"));
        list.add(new ExtractionTest("Extract5"));
        list.add(new ExtractionTest("Extract6"));
        list.add(new ExtractionTest("Extract7"));
        list.add(new ExtractionTest("Extract8"));
        list.add(new ExtractionTest("Extract9"));
        list.add(new ExtractionTest("Extract10"));
        return list;
    }

    public static String getOutputDirectory() {
        String rootPath = User.getRegressionPath();
        if (rootPath == null) {
            return null;
        }
        return rootPath + "/tools/Extraction/output/";
    }

    public Boolean Extract1() {
        return this.commonExtractionTest("Test01");
    }

    public Boolean Extract2() {
        return this.commonExtractionTest("Test02");
    }

    public Boolean Extract3() {
        return this.commonExtractionTest("Test03");
    }

    public Boolean Extract4() {
        return this.commonExtractionTest("Test04");
    }

    public Boolean Extract5() {
        return this.commonExtractionTest("Test05");
    }

    public Boolean Extract6() {
        return this.commonExtractionTest("Test06");
    }

    public Boolean Extract7() {
        return this.commonExtractionTest("Test07");
    }

    public Boolean Extract8() {
        return this.commonExtractionTest("Test08");
    }

    public Boolean Extract9() {
        return this.commonExtractionTest("Test09");
    }

    public Boolean Extract10() {
        return this.commonExtractionTest("Test10");
    }

    public static boolean runExtractionTest(String testName) {
        ExtractionTest t = new ExtractionTest(testName);
        Class<?> c = t.getClass();
        boolean good = false;
        try {
            Method method = c.getDeclaredMethod(testName, new Class[0]);
            Object obj = method.invoke((Object)t, new Object[0]);
            if (obj instanceof Boolean) {
                good = (Boolean)obj;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return good;
    }

    private Boolean commonExtractionTest(String cellName) {
        boolean usePureLayerNodes;
        boolean flattenPcells;
        ArrayList<Pattern> pats;
        boolean approximateCuts;
        Cell cell;
        String testParameter = this.createMessageOutput();
        EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool());
        Technology tech = Technology.getMocmosTechnology();
        ExtractionTest.setFoundry(tech);
        URL fileURL = TextUtils.makeURLToFile(ExtractionTest.dataDir(this.getRegressionPath(), testParameter) + "ExtractionTests.jelib");
        String libName = "ExtractionTests";
        Library rootLib = Library.findLibrary(libName);
        if (rootLib == null) {
            rootLib = LibraryFiles.readLibrary(ep, fileURL, libName, FileType.JELIB, true);
        }
        if ((cell = rootLib.findNodeProto(cellName + "{lay}")) == null) {
            System.out.println("ERROR: Cannot find cell " + cellName + "{lay}");
            return Boolean.FALSE;
        }
        ErrorLogger errorLogger = ErrorLogger.newInstance("Node Extraction Test on cell " + cell.getName());
        boolean recursive = false;
        double smallestPolygonSize = 0.0;
        int activeHandling = 0;
        boolean gridAlignExtraction = false;
        ECoord scaledResolution = tech.getFactoryResolution();
        Connectivity c = new Connectivity(cell, null, ep, errorLogger, smallestPolygonSize, activeHandling, gridAlignExtraction, scaledResolution, approximateCuts = false, recursive, pats = new ArrayList<Pattern>());
        Cell newCell = c.doExtract(cell, recursive, pats, flattenPcells = false, usePureLayerNodes = false, true, null, null, null, null);
        if (newCell == null) {
            System.out.println("ERROR: Extraction of cell " + cell.describe(false) + " failed");
        } else {
            newCell.lowLevelSetCreationDate(new Date(0L));
        }
        cell.rename(cell.getName() + "_ORIGINAL", null);
        return this.compareCellResults(newCell, this.getResultName());
    }
}

