/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.SimulationModel;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class Infrastructure {
    public static final int SEVERITY_NOMESSAGE = 0;
    public static final int SEVERITY_WARNING = 1;
    public static final int SEVERITY_NONFATAL = 2;
    public static final int SEVERITY_FATAL = 3;
    public static int[] gpibControllers;
    private static boolean log;
    public static final int DEFAULT_MV_STEP = 100;
    private static long timeMarker;
    public static BufferedReader console;

    private Infrastructure() {
    }

    public static void nonfatal(String message) {
        Exception err2 = new Exception(message);
        err2.printStackTrace();
    }

    public static void fatal(String message) {
        Exception err2 = new Exception(message);
        err2.printStackTrace();
        Infrastructure.exit(1);
    }

    public static void exit(int exitValue2) {
        SimulationModel.finishAll();
        System.exit(exitValue2);
    }

    public static void error(int severity, String message) {
        if (severity == 0) {
            return;
        }
        if (severity == 1) {
            System.err.println(message);
        } else if (severity == 2) {
            Exception err2 = new Exception(message);
            err2.printStackTrace();
        } else if (severity == 3) {
            Exception err3 = new Exception(message);
            err3.printStackTrace();
            Infrastructure.exit(1);
        } else {
            Infrastructure.nonfatal(message);
            Infrastructure.fatal("Bad severity " + severity);
        }
    }

    public static void log(String msg) {
        if (log) {
            System.out.println(msg);
        }
    }

    public static String readln() {
        try {
            return console.readLine();
        }
        catch (Exception e) {
            System.err.println(e);
            Infrastructure.exit(1);
            return null;
        }
    }

    public static String readln(String prompt) {
        System.out.print(prompt);
        try {
            return console.readLine();
        }
        catch (Exception e) {
            System.err.println(e);
            Infrastructure.exit(1);
            return null;
        }
    }

    public static void markTime() {
        timeMarker = System.currentTimeMillis();
    }

    public static String getTimeSinceMarker() {
        return Infrastructure.getElapsedTime(System.currentTimeMillis() - timeMarker);
    }

    public static String getElapsedTime(long milliseconds) {
        int minutes;
        int hours;
        int days;
        if (milliseconds < 60000L) {
            return (double)milliseconds / 1000.0 + " secs";
        }
        StringBuffer buf = new StringBuffer();
        int seconds = (int)milliseconds / 1000;
        if (seconds < 0) {
            seconds = 0;
        }
        if ((days = seconds / 86400) > 0) {
            buf.append(days + " days, ");
        }
        if ((hours = (seconds -= days * 86400) / 3600) > 0) {
            buf.append(hours + " hrs, ");
        }
        if ((minutes = (seconds -= hours * 3600) / 60) > 0) {
            buf.append(minutes + " mins, ");
        }
        buf.append((seconds -= minutes * 60) + " secs");
        return buf.toString();
    }

    public static void waitSeconds(float seconds) {
        Infrastructure.wait(seconds);
    }

    protected static void wait(float seconds) {
        float milliSec = seconds * 1000.0f;
        try {
            Thread.sleep((int)milliSec);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        Infrastructure.fatal("Here is a crash message");
    }

    static {
        log = false;
        timeMarker = 0L;
        console = new BufferedReader(new InputStreamReader(System.in));
    }
}

