/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.io.output.Topology;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.User;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class Tegas
extends Topology {
    private static final int MAXLENGTH = 80;
    private static final int MAXNAMECHARS = 12;
    private Map<Nodable, Integer> nodeNames;
    private Map<ArcInst, Integer> implicitInverters;
    private Netlist netList;
    private TegasPreferences localPrefs;
    private List<String> reservedWords = null;

    Tegas(TegasPreferences tp) {
        this.localPrefs = tp;
    }

    protected void start() {
        String str1;
        this.setOutputWidth(80, true);
        this.writeWidthLimited("/* GENERATED BY THE ELECTRIC VLSI DESIGN SYSTEM */\n\n");
        this.writeWidthLimited("COMPILE  ;\n\n");
        String libname = this.getLibraryName(this.topCell);
        int length = libname.length();
        if (length > 12) {
            this.reportWarning("Library name exceeds 12 characters, The name used for the\nTDL directory will be truncated to :- " + this.convertName(libname));
        }
        if (this.isReservedWord(str1 = this.convertName(libname))) {
            this.reportError(str1 + " IS A RESERVED WORD, RENAME LIBRARY AND RE-RUN");
            return;
        }
        this.writeWidthLimited("DIRECTORY:  " + str1 + " ;\n\n");
        this.writeWidthLimited("OPTIONS:   REPLACE  ;\n\n");
    }

    protected void done() {
        this.writeWidthLimited(" END COMPILE;\n\n ");
    }

    protected void writeCellTopology(Cell cell, String cellName, Topology.CellNetInfo cni, VarContext context, Topology.MyCellInfo info) {
        this.writeWidthLimited("MODULE:  ");
        this.writeWidthLimited(this.convertName(cell.describe(false)));
        this.writeWidthLimited(";\n\n");
        this.netList = cni.getNetList();
        if (cell.getNumPorts() > 0) {
            Export e;
            Topology.CellSignal cs;
            StringBuffer infstr = new StringBuffer();
            infstr.append("INPUTS:\n");
            Iterator<Topology.CellSignal> it = cni.getCellSignals();
            while (it.hasNext()) {
                cs = it.next();
                if (!cs.isExported() || (e = cs.getExport()).getCharacteristic() != PortCharacteristic.IN) continue;
                if (this.isReservedWord(this.convertName(e.getName()))) {
                    this.reportError("ERROR: " + this.convertName(e.getName()) + " IS A RESERVED WORD");
                }
                infstr.append("   " + this.convertName(e.getName()) + "\n");
            }
            infstr.append(";\n\n");
            this.writeWidthLimited(infstr.toString());
            infstr = new StringBuffer();
            infstr.append("OUTPUTS:\n");
            it = cni.getCellSignals();
            while (it.hasNext()) {
                cs = it.next();
                if (!cs.isExported()) continue;
                e = cs.getExport();
                if (e.getCharacteristic() == PortCharacteristic.OUT) {
                    infstr.append("   " + this.convertName(e.getName()) + "\n");
                    continue;
                }
                if (e.getCharacteristic() == PortCharacteristic.IN) continue;
                this.reportError("EXPORT " + e.getName() + " MUST BE EITHER INPUT OR OUTPUT");
            }
            infstr.append(";\n\n");
            this.writeWidthLimited(infstr.toString());
        }
        TreeSet<String> instanceDeclarations = new TreeSet<String>();
        TreeSet<String> gateDeclarations = new TreeSet<String>();
        Iterator<Nodable> it = this.netList.getNodables();
        while (it.hasNext()) {
            Nodable no = it.next();
            if (no.isCellInstance()) {
                Cell subCell = (Cell)no.getProto();
                String instName = this.getNodeProtoName(no);
                instanceDeclarations.add(instName + " = " + instName + "///" + this.getLibraryName(subCell));
                continue;
            }
            NodeInst ni = (NodeInst)no;
            PrimitiveNode.Function fun = ni.getFunction();
            if (fun == PrimitiveNode.Function.GATEAND || fun == PrimitiveNode.Function.GATEOR || fun == PrimitiveNode.Function.GATEXOR) {
                String gateName = this.getGateName(ni);
                int gateWidth = this.getGateWidth(ni);
                gateDeclarations.add(gateWidth + "-" + gateName + " = " + gateName + "(" + gateWidth + ",1)");
                continue;
            }
            if (fun != PrimitiveNode.Function.SOURCE && !fun.isResistor() && !fun.isCapacitor() && fun != PrimitiveNode.Function.DIODE && fun != PrimitiveNode.Function.INDUCT && fun != PrimitiveNode.Function.METER) continue;
            this.reportError("CANNOT HANDLE " + ni.getProto().describe(true) + " NODES");
        }
        int numDecls = instanceDeclarations.size() + gateDeclarations.size();
        if (numDecls > 0) {
            this.writeWidthLimited("USE:\n\n");
        }
        int countDecls = 1;
        for (String decl : instanceDeclarations) {
            decl = countDecls < numDecls ? decl + "," : decl + ";";
            ++countDecls;
            this.writeWidthLimited("    " + decl + "\n");
        }
        for (String decl : gateDeclarations) {
            decl = countDecls < numDecls ? decl + "," : decl + ";";
            ++countDecls;
            this.writeWidthLimited("    " + decl + "\n");
        }
        if (numDecls > 0) {
            this.writeWidthLimited("\n");
        }
        this.writeWidthLimited("DEFINE:\n");
        this.implicitInverters = new HashMap<ArcInst, Integer>();
        int count = 1;
        Iterator<Object> it2 = cell.getArcs();
        while (it2.hasNext()) {
            ArcInst ai = it2.next();
            for (int i = 0; i < 2; ++i) {
                PrimitiveNode.Function fun;
                if (!ai.isNegated(i) || ai.getPortInst(i).getPortProto().getCharacteristic() == PortCharacteristic.OUT && ((fun = ai.getPortInst(i).getNodeInst().getFunction()) == PrimitiveNode.Function.GATEAND || fun == PrimitiveNode.Function.GATEOR || fun == PrimitiveNode.Function.GATEXOR || fun == PrimitiveNode.Function.BUFFER)) continue;
                this.implicitInverters.put(ai, new Integer(count));
                ++count;
            }
        }
        this.nodeNames = new HashMap<Nodable, Integer>();
        it2 = this.netList.getNodables();
        while (it2.hasNext()) {
            Nodable no = (Nodable)it2.next();
            PrimitiveNode.Function fun = this.getNodableFunction(no);
            if (!fun.isTransistor() && fun != PrimitiveNode.Function.GATEXOR && fun != PrimitiveNode.Function.GATEAND && fun != PrimitiveNode.Function.GATEOR && fun != PrimitiveNode.Function.BUFFER && !fun.isFlipFlop() && !no.isCellInstance()) continue;
            this.nodeNames.put(no, new Integer(count++));
        }
        boolean wrotePower = false;
        boolean wroteGround = false;
        Iterator<Nodable> it3 = this.netList.getNodables();
        while (it3.hasNext()) {
            Nodable no = it3.next();
            PrimitiveNode.Function fun = this.getNodableFunction(no);
            if (fun.isPin() || fun == PrimitiveNode.Function.ART) continue;
            if (fun == PrimitiveNode.Function.CONPOWER) {
                if (wrotePower) continue;
                wrotePower = true;
                this.writeWidthLimited(this.getNameOfPower((NodeInst)no));
                continue;
            }
            if (fun == PrimitiveNode.Function.CONGROUND) {
                if (wroteGround) continue;
                wroteGround = true;
                this.writeWidthLimited(this.getNameOfPower((NodeInst)no));
                continue;
            }
            if (fun.isTransistor() || fun == PrimitiveNode.Function.GATEXOR || fun == PrimitiveNode.Function.GATEAND || fun == PrimitiveNode.Function.GATEOR || fun == PrimitiveNode.Function.BUFFER || fun.isFlipFlop() || no.isCellInstance()) {
                String str1 = this.getOutputSignals(no, context, cni) + " = " + this.getNodeProtoName(no) + this.getInputSignals(no, context, cni) + this.getGateDelay(no) + ";\n";
                this.writeWidthLimited(str1);
                continue;
            }
            this.reportWarning("NODETYPE " + no.getProto() + " NOT SUPPORTED");
        }
        this.writeWidthLimited(" END MODULE;\n\n");
    }

    private String getOutputSignals(Nodable no, VarContext context, Topology.CellNetInfo cni) {
        int nodeNumber = -1;
        Integer nodeNum = this.nodeNames.get(no);
        if (nodeNum != null) {
            nodeNumber = nodeNum;
        }
        StringBuffer infstr = new StringBuffer();
        infstr.append("U" + nodeNumber + "(");
        PrimitiveNode.Function fun = this.getNodableFunction(no);
        boolean needComma = false;
        if (no.isCellInstance()) {
            Topology.CellNetInfo subCni = this.getCellNetInfo(this.parameterizedName(no, context));
            Iterator<Topology.CellSignal> it = subCni.getCellSignals();
            while (it.hasNext()) {
                Export e;
                Topology.CellSignal subCs = it.next();
                if (!subCs.isExported() || (e = subCs.getExport()).getCharacteristic() == PortCharacteristic.IN) continue;
                if (needComma) {
                    infstr.append(",");
                } else {
                    needComma = true;
                }
                Network net = this.netList.getNetwork(no, e, subCs.getExportIndex());
                Topology.CellSignal cs = cni.getCellSignal(net);
                infstr.append(this.convertName(cs.getName()));
            }
        } else {
            NodeInst ni = (NodeInst)no;
            Iterator<PortProto> it = no.getProto().getPorts();
            while (it.hasNext()) {
                PortProto pp = it.next();
                if (fun.isTransistor() ? pp.getName().equals("g") : pp.getCharacteristic() == PortCharacteristic.IN) continue;
                Iterator<Connection> aIt = ni.getConnections();
                while (aIt.hasNext()) {
                    Connection con = aIt.next();
                    PortInst pi = con.getPortInst();
                    if (pi.getPortProto() != pp) continue;
                    ArcInst ai = con.getArc();
                    if (needComma) {
                        infstr.append(",");
                    } else {
                        needComma = true;
                    }
                    String nodeName = this.getConnectionName(con);
                    infstr.append(nodeName);
                    if (!con.isNegated() || this.implicitInverters.get(ai) == null) continue;
                    this.writeInverter(con, nodeName, "U" + nodeNumber + "." + this.convertName(pp.getName()));
                }
            }
        }
        infstr.append(")");
        return infstr.toString();
    }

    private String getInputSignals(Nodable no, VarContext context, Topology.CellNetInfo cni) {
        PrimitiveNode.Function fun = this.getNodableFunction(no);
        if (fun.isFlipFlop()) {
            return this.getFlipFlopInputSignals((NodeInst)no);
        }
        if (no.getProto().getNumPorts() == 0) {
            return "";
        }
        StringBuffer infstr = new StringBuffer();
        infstr.append("(");
        boolean first = true;
        if (no.isCellInstance()) {
            Topology.CellNetInfo subCni = this.getCellNetInfo(this.parameterizedName(no, context));
            Iterator<Topology.CellSignal> it = subCni.getCellSignals();
            while (it.hasNext()) {
                Export e;
                Topology.CellSignal subCs = it.next();
                if (!subCs.isExported() || (e = subCs.getExport()).getCharacteristic() == PortCharacteristic.OUT) continue;
                if (first) {
                    first = false;
                } else {
                    infstr.append(",");
                }
                Network net = this.netList.getNetwork(no, e, subCs.getExportIndex());
                Topology.CellSignal cs = cni.getCellSignal(net);
                infstr.append(this.convertName(cs.getName()));
            }
        } else {
            NodeInst ni = (NodeInst)no;
            Iterator<PortProto> it = no.getProto().getPorts();
            while (it.hasNext()) {
                PrimitivePort pp = (PrimitivePort)it.next();
                if (pp.getCharacteristic() != PortCharacteristic.IN || fun.isTransistor() && pp.getName().startsWith("s") || fun == PrimitiveNode.Function.BUFFER && pp.getName().equals("c")) continue;
                boolean portWired = false;
                Iterator<Connection> aIt = ni.getConnections();
                while (aIt.hasNext()) {
                    Connection con = aIt.next();
                    if (con.getPortInst().getPortProto() != pp) continue;
                    if (first) {
                        first = false;
                    } else {
                        infstr.append(",");
                    }
                    infstr.append(this.getInvertedConnectionName(con));
                    portWired = true;
                    if (pp.isIsolated()) continue;
                    break;
                }
                if (portWired) continue;
                this.reportWarning("UNWIRED PORT " + pp.getName());
                if (first) {
                    first = false;
                } else {
                    infstr.append(",");
                }
                infstr.append("NC");
            }
        }
        infstr.append(")");
        String result = infstr.toString();
        return result;
    }

    private String getFlipFlopInputSignals(NodeInst ni) {
        String[] signals = new String[5];
        int x = 0;
        Iterator<PortProto> it = ni.getProto().getPorts();
        while (it.hasNext()) {
            PortProto pp = it.next();
            if (pp.getCharacteristic() == PortCharacteristic.OUT) continue;
            String ptr = "NC";
            Iterator<Connection> pIt = ni.getConnections();
            while (pIt.hasNext()) {
                Connection con = pIt.next();
                if (con.getPortInst().getPortProto() != pp) continue;
                ptr = this.getInvertedConnectionName(con);
                break;
            }
            Iterator<Export> eIt = ni.getExports();
            while (eIt.hasNext()) {
                Export e = eIt.next();
                if (e.getOriginalPort().getPortProto() != pp) continue;
                ptr = this.convertName(e.getName());
                break;
            }
            if (x >= 5) break;
            signals[x++] = ptr;
        }
        StringBuffer infstr = new StringBuffer();
        infstr.append("(" + signals[2] + "," + signals[0]);
        PrimitiveNode.Function fun = ni.getFunction();
        if (fun == PrimitiveNode.Function.FLIPFLOPRSMS || fun == PrimitiveNode.Function.FLIPFLOPRSP || fun == PrimitiveNode.Function.FLIPFLOPRSN || fun == PrimitiveNode.Function.FLIPFLOPJKMS || fun == PrimitiveNode.Function.FLIPFLOPJKP || fun == PrimitiveNode.Function.FLIPFLOPJKN) {
            infstr.append("," + signals[1]);
        }
        infstr.append("," + signals[3] + "," + signals[4] + ")");
        return infstr.toString();
    }

    private boolean isNegatedNode(NodeInst ni) {
        Iterator<Connection> it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = it.next();
            PortInst pi = con.getPortInst();
            PortProto pp = pi.getPortProto();
            if (pp.getCharacteristic() != PortCharacteristic.OUT || !con.isNegated()) continue;
            return true;
        }
        return false;
    }

    private String getGateDelay(Nodable no) {
        if (no.isCellInstance()) {
            return "";
        }
        NodeInst ni = (NodeInst)no;
        Variable var = ni.getVar(Simulation.RISE_DELAY_KEY);
        String str1 = "/1,";
        if (var != null) {
            str1 = "/" + var.getPureValue(-1) + ",";
        }
        var = ni.getVar(Simulation.FALL_DELAY_KEY);
        String str2 = "/1,";
        if (var != null) {
            str2 = "/" + var.getPureValue(-1) + ",";
        }
        return str1 + str2;
    }

    private int getGateWidth(NodeInst ni) {
        int inputs = 0;
        Iterator<Connection> iIt = ni.getConnections();
        while (iIt.hasNext()) {
            Connection con = iIt.next();
            if (con.getPortInst().getPortProto().getCharacteristic() != PortCharacteristic.IN) continue;
            ++inputs;
        }
        if (inputs < 2) {
            this.reportError("MUST HAVE AT LEAST TWO INPUTS ON " + ni);
        }
        return inputs;
    }

    private String getGateName(NodeInst ni) {
        PrimitiveNode.Function fun;
        boolean negated = false;
        if (this.isNegatedNode(ni)) {
            negated = true;
        }
        if ((fun = ni.getFunction()) == PrimitiveNode.Function.GATEAND) {
            if (negated) {
                return "NAND";
            }
            return "AND";
        }
        if (fun == PrimitiveNode.Function.GATEOR) {
            if (negated) {
                return "NOR";
            }
            return "OR";
        }
        if (fun == PrimitiveNode.Function.GATEXOR) {
            if (negated) {
                return "NXOR";
            }
            return "XOR";
        }
        return "";
    }

    private void writeInverter(Connection con, String str1, String str2) {
        Integer index = this.implicitInverters.get(con.getArc());
        if (index == null) {
            return;
        }
        this.writeWidthLimited("I" + index + "(" + this.convertName(str1) + ") = NOT(" + this.convertName(str2) + ");\n");
        this.implicitInverters.remove(con.getArc());
    }

    private String getNameOfPower(NodeInst ni) {
        if (!ni.hasConnections()) {
            this.reportWarning("PWR / GND NODE UNCONNECTED");
            return "";
        }
        PrimitiveNode.Function fun = ni.getFunction();
        if ((fun == PrimitiveNode.Function.CONGROUND || fun == PrimitiveNode.Function.CONPOWER) && ni.hasConnections()) {
            Connection con = ni.getConnections().next();
            Network net = this.netList.getNetwork(con.getArc(), 0);
            String decl = net.describe(false) + " = ";
            decl = fun == PrimitiveNode.Function.CONPOWER ? decl + "PWR" : decl + "GRND";
            return decl + ";\n";
        }
        return "";
    }

    private String getConnectionName(Connection con) {
        Network net = this.netList.getNetwork(con.getArc(), 0);
        if (net != null) {
            return this.convertName(net.describe(false));
        }
        return "???";
    }

    private String getInvertedConnectionName(Connection con) {
        String conName = this.getConnectionName(con);
        ArcInst ai = con.getArc();
        if (!con.isNegated()) {
            return conName;
        }
        Integer index = this.implicitInverters.get(ai);
        if (index != null) {
            String str = "I" + index + ".O";
            this.writeInverter(con, str, conName);
            return str;
        }
        return conName;
    }

    private PrimitiveNode.Function getNodableFunction(Nodable no) {
        PrimitiveNode.Function fun = PrimitiveNode.Function.UNKNOWN;
        if (!no.isCellInstance()) {
            NodeInst ni = (NodeInst)no;
            fun = ni.getFunction();
        }
        return fun;
    }

    private String getNodeProtoName(Nodable no) {
        if (no.isCellInstance()) {
            return this.convertName(no.getProto().describe(false));
        }
        NodeInst ni = (NodeInst)no;
        PrimitiveNode.Function fun = ni.getFunction();
        if (fun == PrimitiveNode.Function.GATEAND || fun == PrimitiveNode.Function.GATEOR || fun == PrimitiveNode.Function.GATEXOR) {
            return this.getGateWidth(ni) + "-" + this.getGateName(ni);
        }
        if (fun == PrimitiveNode.Function.BUFFER) {
            if (this.isNegatedNode(ni)) {
                return "NOT";
            }
            return "DELAY";
        }
        if (fun.isFlipFlop()) {
            return this.getFlipFlopName(ni);
        }
        if (fun == PrimitiveNode.Function.TRANS) {
            return "BDSWITCH";
        }
        return "";
    }

    private String convertName(String str) {
        if (str.length() > 12) {
            str = str.substring(0, 12);
        }
        return str.toUpperCase();
    }

    String getLibraryName(Cell cell) {
        return this.convertName(cell.getLibrary().getName());
    }

    private String getFlipFlopName(NodeInst ni) {
        PrimitiveNode.Function fun = ni.getFunction();
        if (fun == PrimitiveNode.Function.FLIPFLOPRSMS) {
            return "SRMNE";
        }
        if (fun == PrimitiveNode.Function.FLIPFLOPRSP) {
            return "SREPE";
        }
        if (fun == PrimitiveNode.Function.FLIPFLOPRSN) {
            return "SRENE";
        }
        if (fun == PrimitiveNode.Function.FLIPFLOPJKMS) {
            return "JKMNE";
        }
        if (fun == PrimitiveNode.Function.FLIPFLOPJKP) {
            return "JKEPE";
        }
        if (fun == PrimitiveNode.Function.FLIPFLOPJKN) {
            return "JKENE";
        }
        if (fun == PrimitiveNode.Function.FLIPFLOPDMS) {
            return "DMNE";
        }
        if (fun == PrimitiveNode.Function.FLIPFLOPDP) {
            return "DEPE";
        }
        if (fun == PrimitiveNode.Function.FLIPFLOPDN) {
            return "DENE";
        }
        if (fun == PrimitiveNode.Function.FLIPFLOPTP || fun == PrimitiveNode.Function.FLIPFLOPTN) {
            this.reportError("T TYPE FLIP-FLOP MUST BE MS");
        }
        return "TMNE";
    }

    private boolean isReservedWord(String str) {
        if (this.reservedWords == null) {
            this.reservedWords = new ArrayList<String>();
            try {
                String line;
                File f = new File(this.localPrefs.workingDirectory + File.separator + "reservedwords.dat");
                FileReader fr = new FileReader(f);
                BufferedReader br = new BufferedReader(fr);
                while ((line = br.readLine()) != null) {
                    this.reservedWords.add(line);
                }
                br.close();
                fr.close();
            }
            catch (IOException e) {
                return false;
            }
        }
        if (str.length() < 2) {
            return false;
        }
        for (String match : this.reservedWords) {
            if (!match.startsWith(str)) continue;
            return true;
        }
        return false;
    }

    protected String getSafeCellName(String name) {
        return name;
    }

    protected String getPowerName(Network net) {
        return ".VDD";
    }

    protected String getGroundName(Network net) {
        return "GRND";
    }

    protected String getGlobalName(Global glob) {
        return glob.getName();
    }

    protected boolean isNetworksUseExportedNames() {
        return true;
    }

    protected boolean isLibraryNameAlwaysAddedToCellName() {
        return false;
    }

    protected boolean isAggregateNamesSupported() {
        return false;
    }

    protected boolean isAggregateNameGapsSupported() {
        return false;
    }

    protected boolean isSeparateInputAndOutput() {
        return true;
    }

    protected boolean isCaseSensitive() {
        return true;
    }

    protected String getSafeNetName(String name, boolean bus) {
        return name;
    }

    protected Netlist.ShortResistors getShortResistors() {
        return Netlist.ShortResistors.ALL;
    }

    protected boolean canParameterizeNames() {
        return true;
    }

    public static class TegasPreferences
    extends Output.OutputPreferences {
        String workingDirectory = "";

        public TegasPreferences(boolean factory) {
            super(factory);
            this.workingDirectory = factory ? "" : User.getWorkingDirectory();
        }

        public Output doOutput(Cell cell, VarContext context, String filePath) {
            Tegas out = new Tegas(this);
            if (out.openTextOutputStream(filePath)) {
                return out.finishWrite();
            }
            if (out.writeCell(cell, context)) {
                return out.finishWrite();
            }
            if (out.closeTextOutputStream()) {
                return out.finishWrite();
            }
            System.out.println(filePath + " written");
            return out.finishWrite();
        }
    }
}

