/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.database.Environment;
import com.sun.electric.tool.Consumer;
import com.sun.electric.tool.EThread;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.ServerJobManager;
import com.sun.electric.tool.Tool;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiTaskJob<TaskKey, TaskResult, Result>
extends Job {
    private transient LinkedHashMap<TaskKey, Task> tasks;
    private transient ArrayList<Task> allTasks;
    private transient int tasksDone;
    private transient Environment env;
    private transient EThread ownerThread;
    private transient int numberOfRunningThreads;
    private transient int numberOfFinishedThreads;
    private Consumer<Result> consumer;

    public MultiTaskJob(String jobName, Tool t, Consumer<Result> c) {
        super(jobName, t, Job.Type.SERVER_EXAMINE, null, null, Job.Priority.USER);
        this.consumer = c;
    }

    public abstract void prepareTasks() throws JobException;

    public abstract TaskResult runTask(TaskKey var1) throws JobException;

    public abstract Result mergeTaskResults(Map<TaskKey, TaskResult> var1) throws JobException;

    @Override
    public final boolean doIt() throws JobException {
        this.tasks = new LinkedHashMap();
        this.allTasks = new ArrayList();
        this.prepareTasks();
        this.env = Environment.getThreadEnvironment();
        this.ownerThread = (EThread)Thread.currentThread();
        this.numberOfRunningThreads = ServerJobManager.getMaxNumberOfThreads();
        for (int id = 0; id < this.numberOfRunningThreads; ++id) {
            new WorkingThread(id).start();
        }
        this.waitTasks();
        LinkedHashMap<Object, Object> taskResults = new LinkedHashMap<Object, Object>();
        for (Task task : this.tasks.values()) {
            if (task.taskResult == null) continue;
            taskResults.put(task.taskKey, task.taskResult);
        }
        Result result = this.mergeTaskResults(taskResults);
        if (this.consumer != null) {
            this.consumer.consume(result);
        }
        return true;
    }

    public synchronized void startTask(String taskName, TaskKey taskKey) {
        Task task = new Task(taskName, taskKey);
        if (this.tasks.containsKey(taskKey)) {
            throw new IllegalArgumentException();
        }
        this.tasks.put(taskKey, task);
        this.allTasks.add(task);
    }

    private synchronized Task getTask() {
        if (this.tasksDone == this.allTasks.size()) {
            return null;
        }
        return this.allTasks.get(this.tasksDone++);
    }

    private synchronized void waitTasks() {
        try {
            while (this.numberOfFinishedThreads < this.numberOfRunningThreads) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private synchronized void finishWorkingThread() {
        ++this.numberOfFinishedThreads;
        this.notify();
    }

    class WorkingThread
    extends EThread {
        private WorkingThread(int id) {
            super("WorkingThread-" + id);
            this.userInterface = new ServerJobManager.UserInterfaceRedirect(((MultiTaskJob)MultiTaskJob.this).ownerThread.ejob.jobKey);
            this.ejob = ((MultiTaskJob)MultiTaskJob.this).ownerThread.ejob;
            this.isServerThread = ((MultiTaskJob)MultiTaskJob.this).ownerThread.isServerThread;
            this.database = ((MultiTaskJob)MultiTaskJob.this).ownerThread.database;
        }

        public void run() {
            Task t;
            Environment.setThreadEnvironment(MultiTaskJob.this.env);
            while ((t = MultiTaskJob.this.getTask()) != null) {
                try {
                    t.taskResult = MultiTaskJob.this.runTask(t.taskKey);
                }
                catch (Throwable e) {
                    e.getStackTrace();
                    e.printStackTrace(System.out);
                    e.printStackTrace();
                }
            }
            MultiTaskJob.this.finishWorkingThread();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Task {
        private final String taskName;
        private final TaskKey taskKey;
        private TaskResult taskResult;

        private Task(String taskName, TaskKey taskKey) {
            this.taskName = taskName;
            this.taskKey = taskKey;
        }
    }
}

