/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.text;

import com.sun.electric.Main;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pref {
    private final String name;
    private PrefType type;
    private final Preferences prefs;
    private Object cachedObj;
    private Object factoryObj;
    private static final List<Pref> allPrefs = new ArrayList<Pref>();
    private static boolean doFlushing = true;
    private static Set<Preferences> queueForFlushing;
    private static int numStrings;
    private static int lenStrings;
    private static int numValueStrings;
    private static int lenValueStrings;

    public static Group groupForPackage(Class classFromPackage) {
        Preferences prefs = Preferences.userNodeForPackage(classFromPackage);
        return new Group(prefs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pref(Preferences prefs, String name) {
        this.name = name;
        this.prefs = prefs;
        List<Pref> list = allPrefs;
        synchronized (list) {
            allPrefs.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pref(Group group, String name) {
        this.name = name;
        this.prefs = group.prefs;
        List<Pref> list = allPrefs;
        synchronized (list) {
            allPrefs.add(this);
        }
    }

    public static void importPrefs(String fileName) {
        if (fileName == null) {
            return;
        }
        Pref.importPrefs(TextUtils.makeURLToFile(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importPrefs(URL fileURL) {
        if (fileURL == null) {
            return;
        }
        try {
            URLConnection urlCon = fileURL.openConnection();
            InputStream inputStream = urlCon.getInputStream();
            System.out.println("Importing preferences...");
            Pref.delayPrefFlushing();
            List<Pref> list = allPrefs;
            synchronized (list) {
                for (Pref pref : allPrefs) {
                    switch (pref.type) {
                        case BOOLEAN: {
                            if (pref.getBoolean() == pref.getBooleanFactoryValue()) break;
                            pref.setBoolean(pref.getBooleanFactoryValue());
                            break;
                        }
                        case INTEGER: {
                            if (pref.getInt() == pref.getIntFactoryValue()) break;
                            pref.setInt(pref.getIntFactoryValue());
                            break;
                        }
                        case LONG: {
                            if (pref.getLong() == pref.getLongFactoryValue()) break;
                            pref.setLong(pref.getLongFactoryValue());
                            break;
                        }
                        case DOUBLE: {
                            if (pref.getDouble() == pref.getDoubleFactoryValue()) break;
                            pref.setDouble(pref.getDoubleFactoryValue());
                            break;
                        }
                        case STRING: {
                            if (pref.getString().equals(pref.getStringFactoryValue())) break;
                            pref.setString(pref.getStringFactoryValue());
                        }
                    }
                }
            }
            Pref.resumePrefFlushing();
            Preferences.importPreferences(inputStream);
            inputStream.close();
            Pref.delayPrefFlushing();
            list = allPrefs;
            synchronized (list) {
                for (Pref pref : allPrefs) {
                    switch (pref.type) {
                        case BOOLEAN: {
                            pref.setBoolean(pref.prefs.getBoolean(pref.name, pref.getBooleanFactoryValue()));
                            break;
                        }
                        case INTEGER: {
                            pref.setInt(pref.prefs.getInt(pref.name, pref.getIntFactoryValue()));
                            break;
                        }
                        case LONG: {
                            pref.setLong(pref.prefs.getLong(pref.name, pref.getLongFactoryValue()));
                            break;
                        }
                        case DOUBLE: {
                            pref.setDouble(pref.prefs.getDouble(pref.name, pref.getDoubleFactoryValue()));
                            break;
                        }
                        case STRING: {
                            pref.setString(pref.prefs.get(pref.name, pref.getStringFactoryValue()));
                        }
                    }
                }
                Setting.saveAllSettingsToPreferences();
            }
            Pref.resumePrefFlushing();
            Technology.cacheTransparentLayerColors();
        }
        catch (InvalidPreferencesFormatException e) {
            String message = "Invalid preferences format";
            if (e.getCause() instanceof SAXParseException) {
                SAXParseException se = (SAXParseException)e.getCause();
                message = message + " (line " + se.getLineNumber() + ")";
            }
            System.out.println(message + ": " + e.getMessage());
            return;
        }
        catch (IOException e) {
            System.out.println("Error reading preferences file");
            e.printStackTrace();
            return;
        }
        Job.getExtendedUserInterface().restoreSavedBindings(false);
        Job.getUserInterface().repaintAllEditWindows();
        System.out.println("...preferences imported from " + fileURL.getFile());
    }

    public static void exportPrefs(String fileName) {
        if (fileName == null) {
            return;
        }
        try {
            Preferences root = Preferences.userNodeForPackage(Main.class);
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            root.exportSubtree(bs);
            String xmlDump = bs.toString();
            int sunPos = xmlDump.indexOf("java.sun.com");
            String insertDTD = "";
            if (sunPos >= 0) {
                int openPos = xmlDump.lastIndexOf(60, sunPos);
                int closePos = xmlDump.indexOf(62, sunPos);
                if (openPos >= 0 && closePos >= 0) {
                    insertDTD = xmlDump.substring(openPos, closePos + 1);
                    xmlDump = xmlDump.substring(0, openPos) + xmlDump.substring(closePos + 1);
                }
            }
            StreamSource source = new StreamSource(new StringReader(xmlDump));
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute("indent-number", new Integer(2));
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(new OutputStreamWriter((OutputStream)bos, "utf-8"));
            transformer.transform(source, result);
            String xmlFormatted = bos.toString();
            int closePos = xmlFormatted.indexOf(62);
            if (closePos >= 0) {
                xmlFormatted = xmlFormatted.substring(0, closePos + 1) + "\n" + insertDTD + xmlFormatted.substring(closePos + 1);
            }
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            printWriter.print(xmlFormatted);
            printWriter.close();
        }
        catch (Exception e) {
            if (Job.getDebug()) {
                e.printStackTrace();
            }
            System.out.println("Error exporting Preferences");
            return;
        }
        System.out.println("Preferences saved to " + fileName);
    }

    protected void initBoolean(boolean factory) {
        this.type = PrefType.BOOLEAN;
        this.factoryObj = new Integer(factory ? 1 : 0);
        this.cachedObj = this.prefs != null ? new Integer(this.prefs.getBoolean(this.name, factory) ? 1 : 0) : new Integer(factory ? 1 : 0);
    }

    public static Pref makeBooleanPref(String name, Group group, boolean factory) {
        Pref pref = new Pref(group.prefs, name);
        pref.initBoolean(factory);
        return pref;
    }

    protected void initInt(int factory) {
        this.type = PrefType.INTEGER;
        this.factoryObj = new Integer(factory);
        this.cachedObj = this.prefs != null ? new Integer(this.prefs.getInt(this.name, factory)) : new Integer(factory);
    }

    public static Pref makeIntPref(String name, Group group, int factory) {
        Pref pref = new Pref(group.prefs, name);
        pref.initInt(factory);
        return pref;
    }

    protected void initLong(long factory) {
        this.type = PrefType.LONG;
        this.factoryObj = new Long(factory);
        this.cachedObj = this.prefs != null ? new Long(this.prefs.getLong(this.name, factory)) : new Long(factory);
    }

    public static Pref makeLongPref(String name, Group group, long factory) {
        Pref pref = new Pref(group.prefs, name);
        pref.initLong(factory);
        return pref;
    }

    protected void initDouble(double factory) {
        this.type = PrefType.DOUBLE;
        this.factoryObj = new Double(factory);
        this.cachedObj = this.prefs != null ? new Double(this.prefs.getDouble(this.name, factory)) : new Double(factory);
    }

    public static Pref makeDoublePref(String name, Group group, double factory) {
        Pref pref = new Pref(group.prefs, name);
        pref.initDouble(factory);
        return pref;
    }

    protected void initString(String factory) {
        this.type = PrefType.STRING;
        this.factoryObj = new String(factory);
        this.cachedObj = this.prefs != null ? new String(this.prefs.get(this.name, factory)) : new String(factory);
    }

    public static Pref makeStringPref(String name, Group group, String factory) {
        Pref pref = new Pref(group.prefs, name);
        pref.initString(factory);
        return pref;
    }

    public static Pref makeStringPref(String name, Preferences prefs, String factory) {
        Pref pref = new Pref(prefs, name);
        pref.initString(factory);
        return pref;
    }

    public boolean getBoolean() {
        return (Integer)this.cachedObj != 0;
    }

    public int getInt() {
        return (Integer)this.cachedObj;
    }

    public long getLong() {
        return (Long)this.cachedObj;
    }

    public double getDouble() {
        return (Double)this.cachedObj;
    }

    public String getString() {
        return (String)this.cachedObj;
    }

    public Object getFactoryValue() {
        return this.factoryObj;
    }

    public boolean getBooleanFactoryValue() {
        return (Integer)this.factoryObj != 0;
    }

    public int getIntFactoryValue() {
        return (Integer)this.factoryObj;
    }

    public long getLongFactoryValue() {
        return (Long)this.factoryObj;
    }

    public double getDoubleFactoryValue() {
        return (Double)this.factoryObj;
    }

    public String getStringFactoryValue() {
        return (String)this.factoryObj;
    }

    public String getPrefName() {
        return this.name;
    }

    public Object getValue() {
        return this.cachedObj;
    }

    public PrefType getType() {
        return this.type;
    }

    public static void gatherPrefChanges() {
    }

    public static PrefChangeBatch getPrefChanges() {
        return null;
    }

    public static void implementPrefChanges(PrefChangeBatch obj) {
    }

    public static void delayPrefFlushing() {
        doFlushing = false;
        queueForFlushing = new HashSet<Preferences>();
    }

    public static void resumePrefFlushing() {
        doFlushing = true;
        for (Preferences p : queueForFlushing) {
            Pref.flushOptions(p);
        }
    }

    public void setBoolean(boolean v) {
        boolean cachedBool;
        boolean bl = cachedBool = (Integer)this.cachedObj != 0;
        if (v != cachedBool) {
            this.cachedObj = new Integer(v ? 1 : 0);
            if (this.prefs != null) {
                this.prefs.putBoolean(this.name, v);
                if (doFlushing) {
                    Pref.flushOptions(this.prefs);
                } else {
                    queueForFlushing.add(this.prefs);
                }
            }
        }
    }

    public void setInt(int v) {
        int cachedInt = (Integer)this.cachedObj;
        if (v != cachedInt) {
            this.cachedObj = new Integer(v);
            if (this.prefs != null) {
                this.prefs.putInt(this.name, v);
                if (doFlushing) {
                    Pref.flushOptions(this.prefs);
                } else {
                    queueForFlushing.add(this.prefs);
                }
            }
        }
    }

    public void setLong(long v) {
        long cachedLong = (Long)this.cachedObj;
        if (v != cachedLong) {
            this.cachedObj = new Long(v);
            if (this.prefs != null) {
                this.prefs.putLong(this.name, v);
                if (doFlushing) {
                    Pref.flushOptions(this.prefs);
                } else {
                    queueForFlushing.add(this.prefs);
                }
            }
        }
    }

    public boolean setDouble(double v) {
        double cachedDouble = (Double)this.cachedObj;
        boolean changed = false;
        if (v != cachedDouble) {
            this.cachedObj = new Double(v);
            if (this.prefs != null) {
                this.prefs.putDouble(this.name, v);
                if (doFlushing) {
                    Pref.flushOptions(this.prefs);
                } else {
                    queueForFlushing.add(this.prefs);
                }
            }
            changed = true;
        }
        return changed;
    }

    public void setString(String str) {
        String cachedString = (String)this.cachedObj;
        if (!str.equals(cachedString)) {
            this.cachedObj = new String(str);
            if (this.prefs != null) {
                this.prefs.put(this.name, str);
                if (doFlushing) {
                    Pref.flushOptions(this.prefs);
                } else {
                    queueForFlushing.add(this.prefs);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printAllPrefs(PrintStream out) {
        lenValueStrings = 0;
        numValueStrings = 0;
        TreeMap<String, Pref> sortedPrefs = new TreeMap<String, Pref>();
        List<Pref> list = allPrefs;
        synchronized (list) {
            for (Pref pref : allPrefs) {
                sortedPrefs.put(pref.prefs.absolutePath() + "/" + pref.name, pref);
            }
        }
        Preferences rootNode = Preferences.userRoot().node("com/sun/electric");
        lenStrings = 0;
        numStrings = 0;
        try {
            Pref.gatherPrefs(out, 0, rootNode, null);
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        out.println(lenStrings + " chars in " + numStrings + " strings");
        out.println(lenValueStrings + " chars in " + numValueStrings + " value strings");
        Setting.printAllSettings(out);
        out.println("ELECTRIC USER PREFERENCES");
        int i = 0;
        for (Pref pref : sortedPrefs.values()) {
            out.println(i++ + pref.prefs.absolutePath() + " " + pref.name + " " + pref.cachedObj);
        }
    }

    private static void gatherPrefs(PrintStream out, int level, Preferences topNode, List<String> ks) throws BackingStoreException {
        for (int i = 0; i < level; ++i) {
            out.print("  ");
        }
        String[] keys = topNode.keys();
        for (int i = 0; i < keys.length; ++i) {
            ++numStrings;
            lenStrings += keys.length;
            String value = topNode.get(keys[i], null);
            ++numValueStrings;
            lenValueStrings += value.length();
        }
        out.println(topNode.name() + " " + keys.length);
        if (topNode.absolutePath().equals("/com/sun/electric/database/hierarchy")) {
            return;
        }
        String[] children = topNode.childrenNames();
        for (int i = 0; i < children.length; ++i) {
            String childName = children[i];
            ++numStrings;
            lenStrings += children[i].length();
            Preferences childNode = topNode.node(childName);
            Pref.gatherPrefs(out, level + 1, childNode, ks);
        }
    }

    private static void flushOptions(Preferences p) {
        block2: {
            try {
                p.flush();
            }
            catch (Exception e) {
                if (Job.BATCHMODE) break block2;
                System.out.println("Failed to save preferences");
            }
        }
    }

    static {
        numValueStrings = 0;
        lenValueStrings = 0;
    }

    public static class PrefChangeBatch
    implements Serializable {
        private HashMap<String, HashMap<String, Object>> changesForNodes = new HashMap();

        private void add(Pref pref, Object newValue) {
            String nodeName = pref.prefs.absolutePath();
            HashMap<String, Object> changesForTheNode = this.changesForNodes.get(nodeName);
            if (changesForTheNode == null) {
                changesForTheNode = new HashMap();
                this.changesForNodes.put(nodeName, changesForTheNode);
            }
            changesForTheNode.put(pref.name, newValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PrefType {
        BOOLEAN,
        INTEGER,
        LONG,
        DOUBLE,
        STRING;

    }

    public static class Group {
        Preferences prefs;

        Group(Preferences prefs) {
            this.prefs = prefs;
        }

        public String absolutePath() {
            return this.prefs.absolutePath();
        }
    }
}

