/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MrDLibImporter
extends Importer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MrDLibImporter.class);
    public ParserResult parserResult;

    @Override
    public boolean isRecognizedFormat(BufferedReader input) throws IOException {
        String recommendationsAsString = this.convertToString(input);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            DefaultHandler handler = new DefaultHandler(){};
            try (ByteArrayInputStream stream = new ByteArrayInputStream(recommendationsAsString.getBytes());){
                saxParser.parse((InputStream)stream, handler);
            }
            catch (Exception e) {
                return false;
            }
        }
        catch (ParserConfigurationException | SAXException e) {
            return false;
        }
        return true;
    }

    @Override
    public ParserResult importDatabase(BufferedReader input) throws IOException {
        this.parse(input);
        return this.parserResult;
    }

    @Override
    public String getName() {
        return "MrDLibImporter";
    }

    @Override
    public StandardFileType getFileType() {
        return StandardFileType.XML;
    }

    @Override
    public String getDescription() {
        return "Takes valid xml documents. Parses from MrDLib API a BibEntry";
    }

    private String convertToString(BufferedReader input) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            while ((line = input.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return stringBuilder.toString();
    }

    private void parse(BufferedReader input) throws IOException {
        BibDatabase bibDatabase = new BibDatabase();
        String recommendations = this.convertToString(input);
        List<Object> bibEntries = new ArrayList();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            MrDlibImporterHandler handler = new MrDlibImporterHandler();
            try (ByteArrayInputStream stream = new ByteArrayInputStream(recommendations.getBytes());){
                saxParser.parse((InputStream)stream, (DefaultHandler)handler);
            }
            catch (SAXException e2) {
                LOGGER.error(e2.getMessage(), e2);
            }
            List<RankedBibEntry> rankedBibEntries = handler.getRankedBibEntries();
            rankedBibEntries.sort((rankedBibEntry1, rankedBibEntry2) -> rankedBibEntry1.rank.compareTo(rankedBibEntry2.rank));
            bibEntries = rankedBibEntries.stream().map(e -> e.entry).collect(Collectors.toList());
        }
        catch (ParserConfigurationException | SAXException e3) {
            LOGGER.error(e3.getMessage(), e3);
        }
        for (BibEntry bibentry : bibEntries) {
            bibDatabase.insertEntry(bibentry);
        }
        this.parserResult = new ParserResult(bibDatabase);
    }

    public ParserResult getParserResult() {
        return this.parserResult;
    }

    private class MrDlibImporterHandler
    extends DefaultHandler {
        private final List<RankedBibEntry> rankedBibEntries = new ArrayList<RankedBibEntry>();
        private boolean authors;
        private boolean published_in;
        private boolean title;
        private boolean year;
        private boolean snippet;
        private boolean rank;
        private boolean type;
        private String htmlSnippetSingle;
        private int htmlSnippetSingleRank = -1;
        private BibEntry currentEntry;

        private MrDlibImporterHandler() {
        }

        public List<RankedBibEntry> getRankedBibEntries() {
            return this.rankedBibEntries;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            switch (qName.toLowerCase(Locale.ROOT)) {
                case "related_article": {
                    this.currentEntry = new BibEntry();
                    this.htmlSnippetSingle = null;
                    this.htmlSnippetSingleRank = -1;
                    break;
                }
                case "authors": {
                    this.authors = true;
                    break;
                }
                case "published_in": {
                    this.published_in = true;
                    break;
                }
                case "title": {
                    this.title = true;
                    break;
                }
                case "year": {
                    this.year = true;
                    break;
                }
                case "type": {
                    this.type = true;
                    break;
                }
                case "suggested_rank": {
                    this.rank = true;
                    break;
                }
            }
            if (qName.equalsIgnoreCase("snippet") && attributes.getValue(0).equalsIgnoreCase("html_fully_formatted")) {
                this.snippet = true;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equalsIgnoreCase("related_article")) {
                this.rankedBibEntries.add(new RankedBibEntry(this.currentEntry, this.htmlSnippetSingleRank));
                this.currentEntry = new BibEntry();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.authors) {
                this.currentEntry.setField("author", new String(ch, start, length));
                this.authors = false;
            }
            if (this.published_in) {
                this.currentEntry.setField("journal", new String(ch, start, length));
                this.published_in = false;
            }
            if (this.title) {
                this.currentEntry.setField("title", new String(ch, start, length));
                this.title = false;
            }
            if (this.year) {
                this.currentEntry.setField("year", new String(ch, start, length));
                this.year = false;
            }
            if (this.rank) {
                this.htmlSnippetSingleRank = Integer.parseInt(new String(ch, start, length));
                this.rank = false;
            }
            if (this.snippet) {
                this.currentEntry.setField("html_representation", new String(ch, start, length));
                this.snippet = false;
            }
        }
    }

    private class RankedBibEntry {
        public BibEntry entry;
        public Integer rank;

        public RankedBibEntry(BibEntry entry, Integer rank) {
            this.rank = rank;
            this.entry = entry;
        }
    }
}

