/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.IdFetcher;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.importer.Parser;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.identifier.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IdParserFetcher<T extends Identifier>
extends IdFetcher<T> {
    public static final Logger LOGGER = LoggerFactory.getLogger(IdParserFetcher.class);

    public URL getURLForEntry(BibEntry var1) throws URISyntaxException, MalformedURLException, FetcherException;

    public Parser getParser();

    default public void doPostCleanup(BibEntry entry) {
    }

    public Optional<T> extractIdentifier(BibEntry var1, List<BibEntry> var2) throws FetcherException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    default public Optional<T> findIdentifier(BibEntry entry) throws FetcherException {
        Objects.requireNonNull(entry);
        try (BufferedInputStream stream = new BufferedInputStream(this.getURLForEntry(entry).openStream());){
            List<BibEntry> fetchedEntries = this.getParser().parseEntries(stream);
            if (fetchedEntries.isEmpty()) {
                Optional optional2 = Optional.empty();
                return optional2;
            }
            fetchedEntries.forEach(this::doPostCleanup);
            Optional<T> optional = this.extractIdentifier(entry, fetchedEntries);
            return optional;
        }
        catch (URISyntaxException e) {
            throw new FetcherException("Search URI is malformed", e);
        }
        catch (FileNotFoundException e) {
            LOGGER.debug("Id not found");
            return Optional.empty();
        }
        catch (IOException e) {
            throw new FetcherException("An I/O exception occurred", e);
        }
        catch (ParseException e) {
            throw new FetcherException("An internal parser error occurred", e);
        }
    }
}

