/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.batik.dom.AbstractDOMImplementation;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.ExtendedNode;
import org.apache.batik.dom.events.DOMMutationEvent;
import org.apache.batik.dom.events.EventSupport;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.xbl.NodeXBL;
import org.apache.batik.dom.xbl.XBLManagerData;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;

public abstract class AbstractNode
implements ExtendedNode,
NodeXBL,
XBLManagerData,
Serializable {
    public static final NodeList EMPTY_NODE_LIST = new NodeList(){

        @Override
        public Node item(int n) {
            return null;
        }

        @Override
        public int getLength() {
            return 0;
        }
    };
    protected AbstractDocument ownerDocument;
    protected transient EventSupport eventSupport;
    protected HashMap userData;
    protected HashMap userDataHandlers;
    protected Object managerData;
    public static final short DOCUMENT_POSITION_DISCONNECTED = 1;
    public static final short DOCUMENT_POSITION_PRECEDING = 2;
    public static final short DOCUMENT_POSITION_FOLLOWING = 4;
    public static final short DOCUMENT_POSITION_CONTAINS = 8;
    public static final short DOCUMENT_POSITION_CONTAINED_BY = 16;
    public static final short DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = 32;

    @Override
    public void setNodeName(String string) {
    }

    @Override
    public void setOwnerDocument(Document document) {
        this.ownerDocument = (AbstractDocument)document;
    }

    @Override
    public void setSpecified(boolean bl) {
        throw this.createDOMException((short)11, "node.type", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
    }

    @Override
    public String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public void setNodeValue(String string) throws DOMException {
    }

    @Override
    public Node getParentNode() {
        return null;
    }

    @Override
    public void setParentNode(Node node) {
        throw this.createDOMException((short)3, "parent.not.allowed", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
    }

    @Override
    public NodeList getChildNodes() {
        return EMPTY_NODE_LIST;
    }

    @Override
    public Node getFirstChild() {
        return null;
    }

    @Override
    public Node getLastChild() {
        return null;
    }

    @Override
    public void setPreviousSibling(Node node) {
        throw this.createDOMException((short)3, "sibling.not.allowed", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
    }

    @Override
    public Node getPreviousSibling() {
        return null;
    }

    @Override
    public void setNextSibling(Node node) {
        throw this.createDOMException((short)3, "sibling.not.allowed", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
    }

    @Override
    public Node getNextSibling() {
        return null;
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public Document getOwnerDocument() {
        return this.ownerDocument;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public Node insertBefore(Node node, Node node2) throws DOMException {
        throw this.createDOMException((short)3, "children.not.allowed", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
    }

    @Override
    public Node replaceChild(Node node, Node node2) throws DOMException {
        throw this.createDOMException((short)3, "children.not.allowed", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
    }

    @Override
    public Node removeChild(Node node) throws DOMException {
        throw this.createDOMException((short)3, "children.not.allowed", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
    }

    @Override
    public Node appendChild(Node node) throws DOMException {
        throw this.createDOMException((short)3, "children.not.allowed", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    @Override
    public Node cloneNode(boolean bl) {
        Node node = bl ? this.deepCopyInto(this.newNode()) : this.copyInto(this.newNode());
        this.fireUserDataHandlers((short)1, this, node);
        return node;
    }

    @Override
    public void normalize() {
    }

    @Override
    public boolean isSupported(String string, String string2) {
        return this.getCurrentDocument().getImplementation().hasFeature(string, string2);
    }

    @Override
    public String getPrefix() {
        return this.getNamespaceURI() == null ? null : DOMUtilities.getPrefix(this.getNodeName());
    }

    @Override
    public void setPrefix(String string) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        String string2 = this.getNamespaceURI();
        if (string2 == null) {
            throw this.createDOMException((short)14, "namespace", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        String string3 = this.getLocalName();
        if (string == null) {
            this.setNodeName(string3);
            return;
        }
        if (!string.equals("") && !DOMUtilities.isValidName(string)) {
            throw this.createDOMException((short)5, "prefix", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), string});
        }
        if (!DOMUtilities.isValidPrefix(string)) {
            throw this.createDOMException((short)14, "prefix", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), string});
        }
        if (string.equals("xml") && !"http://www.w3.org/XML/1998/namespace".equals(string2) || string.equals("xmlns") && !"http://www.w3.org/2000/xmlns/".equals(string2)) {
            throw this.createDOMException((short)14, "namespace.uri", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), string2});
        }
        this.setNodeName(string + ':' + string3);
    }

    @Override
    public String getLocalName() {
        return this.getNamespaceURI() == null ? null : DOMUtilities.getLocalName(this.getNodeName());
    }

    public DOMException createDOMException(short s2, String string, Object[] objectArray) {
        try {
            return new DOMException(s2, this.getCurrentDocument().formatMessage(string, objectArray));
        }
        catch (Exception exception) {
            return new DOMException(s2, string);
        }
    }

    protected String getCascadedXMLBase(Node node) {
        Node node2;
        String string = null;
        for (Node node3 = node.getParentNode(); node3 != null; node3 = node3.getParentNode()) {
            if (node3.getNodeType() != 1) continue;
            string = this.getCascadedXMLBase(node3);
            break;
        }
        if (string == null) {
            node2 = node.getNodeType() == 9 ? (AbstractDocument)node : (AbstractDocument)node.getOwnerDocument();
            string = ((AbstractDocument)node2).getDocumentURI();
        }
        while (node != null && node.getNodeType() != 1) {
            node = node.getParentNode();
        }
        if (node == null) {
            return string;
        }
        node2 = (Element)node;
        Attr attr = node2.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "base");
        if (attr != null) {
            string = string == null ? attr.getNodeValue() : new ParsedURL(string, attr.getNodeValue()).toString();
        }
        return string;
    }

    @Override
    public String getBaseURI() {
        return this.getCascadedXMLBase(this);
    }

    public static String getBaseURI(Node node) {
        return ((AbstractNode)node).getBaseURI();
    }

    @Override
    public short compareDocumentPosition(Node node) throws DOMException {
        Node node2;
        if (this == node) {
            return 0;
        }
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>(10);
        ArrayList<Node> arrayList2 = new ArrayList<Node>(10);
        int n = 0;
        int n2 = 0;
        if (this.getNodeType() == 2) {
            Attr attr;
            arrayList.add(this);
            ++n;
            node2 = ((Attr)((Object)this)).getOwnerElement();
            if (node.getNodeType() == 2 && node2 == (attr = (Attr)node).getOwnerElement()) {
                if (this.hashCode() < ((Attr)node).hashCode()) {
                    return 34;
                }
                return 36;
            }
        } else {
            node2 = this;
        }
        while (node2 != null) {
            if (node2 == node) {
                return 20;
            }
            arrayList.add((AbstractNode)node2);
            ++n;
            node2 = node2.getParentNode();
        }
        if (node.getNodeType() == 2) {
            arrayList2.add(node);
            ++n2;
            node2 = ((Attr)node).getOwnerElement();
        } else {
            node2 = node;
        }
        while (node2 != null) {
            if (node2 == this) {
                return 10;
            }
            arrayList2.add(node2);
            ++n2;
            node2 = node2.getParentNode();
        }
        int n3 = n - 1;
        int n4 = n2 - 1;
        if (arrayList.get(n3) != arrayList2.get(n4)) {
            if (this.hashCode() < node.hashCode()) {
                return 35;
            }
            return 37;
        }
        Object e = arrayList.get(n3);
        Object e2 = arrayList2.get(n4);
        while (e == e2) {
            node2 = (Node)e;
            e = arrayList.get(--n3);
            e2 = arrayList2.get(--n4);
        }
        for (node2 = node2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2 == e) {
                return 2;
            }
            if (node2 != e2) continue;
            return 4;
        }
        return 1;
    }

    @Override
    public String getTextContent() {
        return null;
    }

    @Override
    public void setTextContent(String string) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        if (this.getNodeType() != 10) {
            while (this.getFirstChild() != null) {
                this.removeChild(this.getFirstChild());
            }
            this.appendChild(this.getOwnerDocument().createTextNode(string));
        }
    }

    @Override
    public boolean isSameNode(Node node) {
        return this == node;
    }

    @Override
    public String lookupPrefix(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        short s2 = this.getNodeType();
        switch (s2) {
            case 1: {
                return this.lookupNamespacePrefix(string, (Element)((Object)this));
            }
            case 9: {
                AbstractNode abstractNode = (AbstractNode)((Object)((Document)((Object)this)).getDocumentElement());
                return abstractNode.lookupPrefix(string);
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                return null;
            }
            case 2: {
                AbstractNode abstractNode = (AbstractNode)((Object)((Attr)((Object)this)).getOwnerElement());
                if (abstractNode != null) {
                    return abstractNode.lookupPrefix(string);
                }
                return null;
            }
        }
        for (Node node = this.getParentNode(); node != null; node = node.getParentNode()) {
            if (node.getNodeType() != 1) continue;
            return ((AbstractNode)node).lookupPrefix(string);
        }
        return null;
    }

    protected String lookupNamespacePrefix(String string, Element element) {
        Object object;
        String string2 = element.getNamespaceURI();
        String string3 = element.getPrefix();
        if (string2 != null && string2.equals(string) && string3 != null && (object = ((AbstractNode)((Object)element)).lookupNamespaceURI(string3)) != null && ((String)object).equals(string)) {
            return string3;
        }
        object = element.getAttributes();
        if (object != null) {
            for (int i = 0; i < object.getLength(); ++i) {
                String string4;
                AbstractNode abstractNode;
                String string5;
                Node node = object.item(i);
                if (!"xmlns".equals(node.getPrefix()) || !node.getNodeValue().equals(string) || (string5 = (abstractNode = (AbstractNode)((Object)element)).lookupNamespaceURI(string4 = node.getLocalName())) == null || !string5.equals(string)) continue;
                return string4;
            }
        }
        for (Node node = this.getParentNode(); node != null; node = node.getParentNode()) {
            if (node.getNodeType() != 1) continue;
            return ((AbstractNode)node).lookupNamespacePrefix(string, element);
        }
        return null;
    }

    @Override
    public boolean isDefaultNamespace(String string) {
        Node node;
        switch (this.getNodeType()) {
            case 9: {
                AbstractNode abstractNode = (AbstractNode)((Object)((Document)((Object)this)).getDocumentElement());
                return abstractNode.isDefaultNamespace(string);
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                return false;
            }
            case 2: {
                AbstractNode abstractNode = (AbstractNode)((Object)((Attr)((Object)this)).getOwnerElement());
                if (abstractNode != null) {
                    return abstractNode.isDefaultNamespace(string);
                }
                return false;
            }
            case 1: {
                if (this.getPrefix() == null) {
                    String string2 = this.getNamespaceURI();
                    return string2 == null && string == null || string2 != null && string2.equals(string);
                }
                NamedNodeMap namedNodeMap = this.getAttributes();
                if (namedNodeMap == null) break;
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    node = namedNodeMap.item(i);
                    if (!"xmlns".equals(node.getLocalName())) continue;
                    return node.getNodeValue().equals(string);
                }
                break;
            }
        }
        for (Node node2 = this; node2 != null; node2 = node2.getParentNode()) {
            if (node2.getNodeType() != 1) continue;
            node = node2;
            return ((AbstractNode)node).isDefaultNamespace(string);
        }
        return false;
    }

    @Override
    public String lookupNamespaceURI(String string) {
        Node node;
        switch (this.getNodeType()) {
            case 9: {
                AbstractNode abstractNode = (AbstractNode)((Object)((Document)((Object)this)).getDocumentElement());
                return abstractNode.lookupNamespaceURI(string);
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                return null;
            }
            case 2: {
                AbstractNode abstractNode = (AbstractNode)((Object)((Attr)((Object)this)).getOwnerElement());
                if (abstractNode != null) {
                    return abstractNode.lookupNamespaceURI(string);
                }
                return null;
            }
            case 1: {
                NamedNodeMap namedNodeMap = this.getAttributes();
                if (namedNodeMap == null) break;
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    node = namedNodeMap.item(i);
                    String string2 = node.getPrefix();
                    String string3 = node.getLocalName();
                    if (string3 == null) {
                        string3 = node.getNodeName();
                    }
                    if ((!"xmlns".equals(string2) || !this.compareStrings(string3, string)) && (!"xmlns".equals(string3) || string != null)) continue;
                    String string4 = node.getNodeValue();
                    if (string4.length() > 0) {
                        return string4;
                    }
                    return null;
                }
                break;
            }
        }
        for (Node node2 = this.getParentNode(); node2 != null; node2 = node2.getParentNode()) {
            if (node2.getNodeType() != 1) continue;
            node = (AbstractNode)node2;
            return ((AbstractNode)node).lookupNamespaceURI(string);
        }
        return null;
    }

    @Override
    public boolean isEqualNode(Node node) {
        Node node2;
        Node node3;
        if (node == null) {
            return false;
        }
        short s2 = node.getNodeType();
        if (!(s2 == this.getNodeType() && this.compareStrings(this.getNodeName(), node.getNodeName()) && this.compareStrings(this.getLocalName(), node.getLocalName()) && this.compareStrings(this.getPrefix(), node.getPrefix()) && this.compareStrings(this.getNodeValue(), node.getNodeValue()) && this.compareStrings(this.getNodeValue(), node.getNodeValue()) && this.compareNamedNodeMaps(this.getAttributes(), node.getAttributes()))) {
            return false;
        }
        if (s2 == 10) {
            node3 = (DocumentType)((Object)this);
            node2 = (DocumentType)node;
            if (!(this.compareStrings(node3.getPublicId(), node2.getPublicId()) && this.compareStrings(node3.getSystemId(), node2.getSystemId()) && this.compareStrings(node3.getInternalSubset(), node2.getInternalSubset()) && this.compareNamedNodeMaps(node3.getEntities(), node2.getEntities()) && this.compareNamedNodeMaps(node3.getNotations(), node2.getNotations()))) {
                return false;
            }
        }
        node3 = this.getFirstChild();
        node2 = node.getFirstChild();
        if (node3 != null && node2 != null && !((AbstractNode)node3).isEqualNode(node2)) {
            return false;
        }
        return node3 == node2;
    }

    protected boolean compareStrings(String string, String string2) {
        return string != null && string.equals(string2) || string == null && string2 == null;
    }

    protected boolean compareNamedNodeMaps(NamedNodeMap namedNodeMap, NamedNodeMap namedNodeMap2) {
        if (namedNodeMap == null && namedNodeMap2 != null || namedNodeMap != null && namedNodeMap2 == null) {
            return false;
        }
        if (namedNodeMap != null) {
            int n = namedNodeMap.getLength();
            if (n != namedNodeMap2.getLength()) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                Node node;
                String string = (node = namedNodeMap.item(i)).getLocalName();
                Node node2 = string != null ? namedNodeMap2.getNamedItemNS(node.getNamespaceURI(), string) : namedNodeMap2.getNamedItem(node.getNodeName());
                if (((AbstractNode)node).isEqualNode(node2)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Object getFeature(String string, String string2) {
        return null;
    }

    @Override
    public Object getUserData(String string) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(string);
    }

    @Override
    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        if (this.userData == null) {
            this.userData = new HashMap();
            this.userDataHandlers = new HashMap();
        }
        if (object == null) {
            this.userData.remove(string);
            return this.userDataHandlers.remove(string);
        }
        this.userDataHandlers.put(string, userDataHandler);
        return this.userData.put(string, object);
    }

    protected void fireUserDataHandlers(short s2, Node node, Node node2) {
        AbstractNode abstractNode = (AbstractNode)node;
        if (abstractNode.userData != null) {
            for (Map.Entry entry : abstractNode.userData.entrySet()) {
                UserDataHandler userDataHandler = (UserDataHandler)abstractNode.userDataHandlers.get(entry.getKey());
                if (userDataHandler == null) continue;
                userDataHandler.handle(s2, (String)entry.getKey(), entry.getValue(), node, node2);
            }
        }
    }

    @Override
    public void addEventListener(String string, EventListener eventListener, boolean bl) {
        if (this.eventSupport == null) {
            this.initializeEventSupport();
        }
        this.eventSupport.addEventListener(string, eventListener, bl);
    }

    @Override
    public void addEventListenerNS(String string, String string2, EventListener eventListener, boolean bl, Object object) {
        if (this.eventSupport == null) {
            this.initializeEventSupport();
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.eventSupport.addEventListenerNS(string, string2, eventListener, bl, object);
    }

    @Override
    public void removeEventListener(String string, EventListener eventListener, boolean bl) {
        if (this.eventSupport != null) {
            this.eventSupport.removeEventListener(string, eventListener, bl);
        }
    }

    @Override
    public void removeEventListenerNS(String string, String string2, EventListener eventListener, boolean bl) {
        if (this.eventSupport != null) {
            if (string != null && string.length() == 0) {
                string = null;
            }
            this.eventSupport.removeEventListenerNS(string, string2, eventListener, bl);
        }
    }

    @Override
    public NodeEventTarget getParentNodeEventTarget() {
        return (NodeEventTarget)((Object)this.getXblParentNode());
    }

    @Override
    public boolean dispatchEvent(Event event) throws EventException {
        if (this.eventSupport == null) {
            this.initializeEventSupport();
        }
        return this.eventSupport.dispatchEvent(this, event);
    }

    public boolean willTriggerNS(String string, String string2) {
        return true;
    }

    public boolean hasEventListenerNS(String string, String string2) {
        if (this.eventSupport == null) {
            return false;
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        return this.eventSupport.hasEventListenerNS(string, string2);
    }

    @Override
    public EventSupport getEventSupport() {
        return this.eventSupport;
    }

    public EventSupport initializeEventSupport() {
        if (this.eventSupport == null) {
            AbstractDocument abstractDocument = this.getCurrentDocument();
            AbstractDOMImplementation abstractDOMImplementation = (AbstractDOMImplementation)abstractDocument.getImplementation();
            this.eventSupport = abstractDOMImplementation.createEventSupport(this);
            abstractDocument.setEventsEnabled(true);
        }
        return this.eventSupport;
    }

    public void fireDOMNodeInsertedIntoDocumentEvent() {
        AbstractDocument abstractDocument = this.getCurrentDocument();
        if (abstractDocument.getEventsEnabled()) {
            DOMMutationEvent dOMMutationEvent = (DOMMutationEvent)abstractDocument.createEvent("MutationEvents");
            dOMMutationEvent.initMutationEventNS("http://www.w3.org/2001/xml-events", "DOMNodeInsertedIntoDocument", true, false, null, null, null, null, (short)2);
            this.dispatchEvent(dOMMutationEvent);
        }
    }

    public void fireDOMNodeRemovedFromDocumentEvent() {
        AbstractDocument abstractDocument = this.getCurrentDocument();
        if (abstractDocument.getEventsEnabled()) {
            DOMMutationEvent dOMMutationEvent = (DOMMutationEvent)abstractDocument.createEvent("MutationEvents");
            dOMMutationEvent.initMutationEventNS("http://www.w3.org/2001/xml-events", "DOMNodeRemovedFromDocument", true, false, null, null, null, null, (short)3);
            this.dispatchEvent(dOMMutationEvent);
        }
    }

    protected void fireDOMCharacterDataModifiedEvent(String string, String string2) {
        AbstractDocument abstractDocument = this.getCurrentDocument();
        if (abstractDocument.getEventsEnabled()) {
            DOMMutationEvent dOMMutationEvent = (DOMMutationEvent)abstractDocument.createEvent("MutationEvents");
            dOMMutationEvent.initMutationEventNS("http://www.w3.org/2001/xml-events", "DOMCharacterDataModified", true, false, null, string, string2, null, (short)1);
            this.dispatchEvent(dOMMutationEvent);
        }
    }

    protected AbstractDocument getCurrentDocument() {
        return this.ownerDocument;
    }

    protected abstract Node newNode();

    protected Node export(Node node, AbstractDocument abstractDocument) {
        AbstractNode abstractNode = (AbstractNode)node;
        abstractNode.ownerDocument = abstractDocument;
        abstractNode.setReadonly(false);
        return node;
    }

    protected Node deepExport(Node node, AbstractDocument abstractDocument) {
        AbstractNode abstractNode = (AbstractNode)node;
        abstractNode.ownerDocument = abstractDocument;
        abstractNode.setReadonly(false);
        return node;
    }

    protected Node copyInto(Node node) {
        AbstractNode abstractNode = (AbstractNode)node;
        abstractNode.ownerDocument = this.ownerDocument;
        return node;
    }

    protected Node deepCopyInto(Node node) {
        AbstractNode abstractNode = (AbstractNode)node;
        abstractNode.ownerDocument = this.ownerDocument;
        return node;
    }

    protected void checkChildType(Node node, boolean bl) {
        throw this.createDOMException((short)3, "children.not.allowed", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
    }

    @Override
    public Node getXblParentNode() {
        return this.ownerDocument.getXBLManager().getXblParentNode(this);
    }

    @Override
    public NodeList getXblChildNodes() {
        return this.ownerDocument.getXBLManager().getXblChildNodes(this);
    }

    @Override
    public NodeList getXblScopedChildNodes() {
        return this.ownerDocument.getXBLManager().getXblScopedChildNodes(this);
    }

    @Override
    public Node getXblFirstChild() {
        return this.ownerDocument.getXBLManager().getXblFirstChild(this);
    }

    @Override
    public Node getXblLastChild() {
        return this.ownerDocument.getXBLManager().getXblLastChild(this);
    }

    @Override
    public Node getXblPreviousSibling() {
        return this.ownerDocument.getXBLManager().getXblPreviousSibling(this);
    }

    @Override
    public Node getXblNextSibling() {
        return this.ownerDocument.getXBLManager().getXblNextSibling(this);
    }

    @Override
    public Element getXblFirstElementChild() {
        return this.ownerDocument.getXBLManager().getXblFirstElementChild(this);
    }

    @Override
    public Element getXblLastElementChild() {
        return this.ownerDocument.getXBLManager().getXblLastElementChild(this);
    }

    @Override
    public Element getXblPreviousElementSibling() {
        return this.ownerDocument.getXBLManager().getXblPreviousElementSibling(this);
    }

    @Override
    public Element getXblNextElementSibling() {
        return this.ownerDocument.getXBLManager().getXblNextElementSibling(this);
    }

    @Override
    public Element getXblBoundElement() {
        return this.ownerDocument.getXBLManager().getXblBoundElement(this);
    }

    @Override
    public Element getXblShadowTree() {
        return this.ownerDocument.getXBLManager().getXblShadowTree(this);
    }

    @Override
    public NodeList getXblDefinitions() {
        return this.ownerDocument.getXBLManager().getXblDefinitions(this);
    }

    @Override
    public Object getManagerData() {
        return this.managerData;
    }

    @Override
    public void setManagerData(Object object) {
        this.managerData = object;
    }
}

